-- SCDData dump
-- Schema: 3.6
-- Date: 2025-12-23

CREATE TABLE "metadata" (
  "id" INTEGER NOT NULL PRIMARY KEY,
  "key" VARCHAR(32) NOT NULL,
  "value" VARCHAR(64) NOT NULL
);-- START METADATAINSERT INTO metadata VALUES (1, "schema_major", 3);INSERT INTO metadata VALUES (2, "schema_minor", 6);INSERT INTO metadata VALUES (3, "dump_version", 20251223);-- END METADATA

BEGIN TRANSACTION;CREATE TABLE album (
    id integer NOT NULL,
    created timestamp with time zone,
    last_modified timestamp with time zone,
    name character varying(256) NOT NULL,
    shortname character varying(128) NOT NULL,
    verifier character varying(16) NOT NULL,
    verified boolean NOT NULL,
    alphaorder integer NOT NULL,
    productionyear integer NOT NULL,
    ramsayindexverno smallint NOT NULL,
    notes text NOT NULL,
    artist_id integer NOT NULL,
    CONSTRAINT album_alphaorder_check CHECK ((alphaorder >= 0)),
    CONSTRAINT album_productionyear_check CHECK ((productionyear >= 0)),
    CONSTRAINT album_ramsayindexverno_check CHECK ((ramsayindexverno >= 0))
);
CREATE TABLE albumsrecordingsmap (
    id integer NOT NULL,
    tracknumber smallint NOT NULL,
    album_id integer NOT NULL,
    recording_id integer NOT NULL,
    CONSTRAINT albumsrecordingsmap_tracknumber_check CHECK ((tracknumber >= 0))
);
CREATE TABLE couples (
    id integer NOT NULL,
    name character varying(32) NOT NULL
);
CREATE TABLE couplesshape (
    id integer NOT NULL,
    description character varying(32) NOT NULL,
    couples_id integer NOT NULL,
    shape_id integer NOT NULL
);
CREATE TABLE dance (
    id integer NOT NULL,
    created timestamp with time zone,
    last_modified timestamp with time zone,
    name character varying(128) NOT NULL,
    ucname character varying(128) NOT NULL,
    barsperrepeat smallint NOT NULL,
    intensity smallint NOT NULL,
    intensity_per_turn smallint NOT NULL,
    intensity_bars character varying(256) NOT NULL,
    devised date,
    data_verified smallint NOT NULL,
    steps_verified smallint NOT NULL,
    formations_verified smallint NOT NULL,
    tunes_verified smallint NOT NULL,
    notes text NOT NULL,
    couples_id integer,
    devisor_id integer NOT NULL,
    medleytype_id integer,
    progression_id integer,
    shape_id integer,
    type_id integer NOT NULL,
    CONSTRAINT dance_barsperrepeat_check CHECK ((barsperrepeat >= 0)),
    CONSTRAINT dance_data_verified_check CHECK ((data_verified >= 0)),
    CONSTRAINT dance_formations_verified_check CHECK ((formations_verified >= 0)),
    CONSTRAINT dance_steps_verified_check CHECK ((steps_verified >= 0)),
    CONSTRAINT dance_tunes_verified_check CHECK ((tunes_verified >= 0))
);
CREATE TABLE dancealias (
    id integer NOT NULL,
    name character varying(128) NOT NULL,
    ucname character varying(128) NOT NULL,
    status smallint NOT NULL,
    dance_id integer NOT NULL,
    CONSTRAINT dancealias_status_check CHECK ((status >= 0))
);
CREATE TABLE dancecrib (
    id integer NOT NULL,
    created timestamp with time zone,
    last_modified timestamp with time zone,
    format character varying(10) NOT NULL,
    text text NOT NULL,
    reliability smallint NOT NULL,
    dance_id integer NOT NULL,
    source_id integer NOT NULL,
    user_id integer,
    CONSTRAINT dancecrib_reliability_check CHECK ((reliability >= 0))
);
CREATE TABLE dancecribsource (
    id integer NOT NULL,
    created timestamp with time zone,
    last_modified timestamp with time zone,
    name character varying(64) NOT NULL,
    editor character varying(256) NOT NULL,
    slug character varying(50) NOT NULL,
    url character varying(256),
    email character varying(256) NOT NULL,
    group_id integer,
    derived_from_id integer,
    processor character varying(32) NOT NULL,
    comments_as_issues boolean NOT NULL
);
CREATE TABLE dancediagram (
    id integer NOT NULL,
    created timestamp with time zone,
    last_modified timestamp with time zone,
    upload_file character varying(100) NOT NULL,
    reliability smallint NOT NULL,
    dance_id integer NOT NULL,
    source_id integer NOT NULL,
    user_id integer,
    aspect_ratio double precision NOT NULL,
    CONSTRAINT dancediagram_reliability_check CHECK ((reliability >= 0))
);
CREATE TABLE dancesformationsmap (
    id integer NOT NULL,
    number smallint NOT NULL,
    instancenum smallint NOT NULL,
    dance_id integer NOT NULL,
    formation_id integer NOT NULL,
    CONSTRAINT dancesformationsmap_instancenum_check CHECK ((instancenum >= 0)),
    CONSTRAINT dancesformationsmap_number_check CHECK ((number >= 0))
);
CREATE TABLE dancespublicationsmap (
    id integer NOT NULL,
    number smallint NOT NULL,
    priority smallint NOT NULL,
    dance_id integer NOT NULL,
    publication_id integer NOT NULL,
    count smallint NOT NULL,
    page smallint NOT NULL,
    CONSTRAINT dancespublicationsmap_count_check CHECK ((count >= 0)),
    CONSTRAINT dancespublicationsmap_number_check CHECK ((number >= 0)),
    CONSTRAINT dancespublicationsmap_page_check CHECK ((page >= 0)),
    CONSTRAINT dancespublicationsmap_priority_check CHECK ((priority >= 0))
);
CREATE TABLE dancesrecordingsmap (
    id integer NOT NULL,
    alias_id integer,
    dance_id integer NOT NULL,
    recording_id integer NOT NULL
);
CREATE TABLE dancesstepsmap (
    id integer NOT NULL,
    dance_id integer NOT NULL,
    step_id integer NOT NULL
);
CREATE TABLE dancestunesmap (
    id integer NOT NULL,
    priority smallint NOT NULL,
    comment character varying(64) NOT NULL,
    dance_id integer NOT NULL,
    tune_id integer NOT NULL,
    alias_id integer,
    CONSTRAINT dancestunesmap_priority_check CHECK ((priority >= 0))
);
CREATE TABLE dancetype (
    id integer NOT NULL,
    name character varying(32) NOT NULL,
    short_name character varying(8) NOT NULL,
    rectype boolean NOT NULL,
    dnctype boolean NOT NULL
);
CREATE TABLE danceurl (
    id integer NOT NULL,
    url character varying(200) NOT NULL,
    priority smallint NOT NULL,
    dance_id integer NOT NULL,
    errors smallint NOT NULL,
    invalid boolean NOT NULL,
    last_check timestamp with time zone,
    last_status smallint NOT NULL,
    last_success timestamp with time zone,
    CONSTRAINT danceurl_errors_check CHECK ((errors >= 0)),
    CONSTRAINT danceurl_last_status_check CHECK ((last_status >= 0)),
    CONSTRAINT danceurl_priority_check CHECK ((priority >= 0))
);
CREATE TABLE dancevideo (
    id integer NOT NULL,
    created timestamp with time zone,
    last_modified timestamp with time zone,
    number smallint NOT NULL,
    upload_file character varying(100) NOT NULL,
    "offset" integer NOT NULL,
    "end" integer NOT NULL,
    quality character varying(1) NOT NULL,
    comment text NOT NULL,
    encoded boolean NOT NULL,
    published boolean NOT NULL,
    source character varying(1) NOT NULL,
    external character varying(32) NOT NULL,
    channel_id integer,
    dance_id integer NOT NULL,
    uploader_id integer NOT NULL,
    embed_path character varying(200) NOT NULL,
    thumbnail_path character varying(200) NOT NULL,
    credit character varying(256) NOT NULL,
    editors_pick boolean NOT NULL,
    CONSTRAINT dancevideo_end_check CHECK (("end" >= 0)),
    CONSTRAINT dancevideo_number_check CHECK ((number >= 0)),
    CONSTRAINT dancevideo_offset_check CHECK (("offset" >= 0))
);
CREATE TABLE formation (
    id integer NOT NULL,
    created timestamp with time zone,
    last_modified timestamp with time zone,
    napiername character varying(8) NOT NULL,
    name character varying(64) NOT NULL,
    searchid character varying(32) NOT NULL,
    notes text NOT NULL
);
CREATE TABLE formationmodifier (
    id integer NOT NULL,
    key character varying(16) NOT NULL,
    name character varying(64) NOT NULL
);
CREATE TABLE formationroot (
    id integer NOT NULL,
    key character varying(16) NOT NULL,
    name character varying(64) NOT NULL
);
CREATE TABLE formationstepmap (
    id integer NOT NULL,
    formation_id integer,
    step_id integer NOT NULL,
    type_id integer NOT NULL
);
CREATE TABLE 'group' (
    id integer NOT NULL,
    group_id integer NOT NULL,
    person_id integer NOT NULL
);
CREATE TABLE media (
    id integer NOT NULL,
    catalognumber character varying(64) NOT NULL,
    year integer NOT NULL,
    available boolean,
    album_id integer NOT NULL,
    media_id integer NOT NULL,
    CONSTRAINT media_year_check CHECK ((year >= 0))
);
CREATE TABLE mediatype (
    id integer NOT NULL,
    name character varying(32) NOT NULL,
    abbreviation character varying(4) NOT NULL,
    priority smallint NOT NULL,
    CONSTRAINT mediatype_priority_check CHECK ((priority >= 0))
);
CREATE TABLE medleytype (
    id integer NOT NULL,
    description character varying(32) NOT NULL,
    sortstring character varying(32) NOT NULL
);
CREATE TABLE person (
    id integer NOT NULL,
    created timestamp with time zone,
    last_modified timestamp with time zone,
    name character varying(128) NOT NULL,
    shortname character varying(64) NOT NULL,
    display_name character varying(128) NOT NULL,
    location character varying(64) NOT NULL,
    email character varying(64) NOT NULL,
    isdev boolean NOT NULL,
    ispub boolean NOT NULL,
    iscmp boolean NOT NULL,
    ismus boolean NOT NULL,
    byear integer NOT NULL,
    dyear integer NOT NULL,
    notes text NOT NULL,
    sameas_id integer,
    user_id integer,
    disallows_cribs boolean NOT NULL,
    CONSTRAINT person_byear_check CHECK ((byear >= 0)),
    CONSTRAINT person_dyear_check CHECK ((dyear >= 0))
);
CREATE TABLE personurl (
    id integer NOT NULL,
    url character varying(200) NOT NULL,
    priority smallint NOT NULL,
    person_id integer NOT NULL,
    errors smallint NOT NULL,
    invalid boolean NOT NULL,
    last_check timestamp with time zone,
    last_status smallint NOT NULL,
    last_success timestamp with time zone,
    CONSTRAINT personurl_errors_check CHECK ((errors >= 0)),
    CONSTRAINT personurl_last_status_check CHECK ((last_status >= 0)),
    CONSTRAINT personurl_priority_check CHECK ((priority >= 0))
);
CREATE TABLE phrasing (
    id integer NOT NULL,
    name character varying(16) NOT NULL
);
CREATE TABLE progression (
    id integer NOT NULL,
    name character varying(16) NOT NULL
);
CREATE TABLE publication (
    id integer NOT NULL,
    created timestamp with time zone,
    last_modified timestamp with time zone,
    name character varying(128) NOT NULL,
    shortname character varying(128) NOT NULL,
    rscds boolean NOT NULL,
    hasdances boolean NOT NULL,
    hastunes boolean NOT NULL,
    pagenumbering boolean NOT NULL,
    onpaper boolean NOT NULL,
    year integer NOT NULL,
    adopted_date timestamp with time zone,
    tlc_level smallint NOT NULL,
    notes text NOT NULL,
    adopted_by_id integer,
    devisor_id integer NOT NULL,
    page_check boolean NOT NULL,
    page_offset character varying NOT NULL,
    _series_next_id integer,
    _series_prev_id integer,
    CONSTRAINT publication_tlc_level_check CHECK ((tlc_level >= 0))
);
CREATE TABLE publicationurl (
    id integer NOT NULL,
    url character varying(200) NOT NULL,
    priority smallint NOT NULL,
    publication_id integer NOT NULL,
    errors smallint NOT NULL,
    invalid boolean NOT NULL,
    last_check timestamp with time zone,
    last_status smallint NOT NULL,
    last_success timestamp with time zone,
    CONSTRAINT publicationurl_errors_check CHECK ((errors >= 0)),
    CONSTRAINT publicationurl_last_status_check CHECK ((last_status >= 0)),
    CONSTRAINT publicationurl_priority_check CHECK ((priority >= 0))
);
CREATE TABLE recording (
    id integer NOT NULL,
    created timestamp with time zone,
    last_modified timestamp with time zone,
    name character varying(128) NOT NULL,
    repetitions smallint NOT NULL,
    barsperrepeat smallint NOT NULL,
    playingseconds integer NOT NULL,
    twochords boolean NOT NULL,
    notes text NOT NULL,
    artist_id integer NOT NULL,
    medleytype_id integer,
    phrasing_id integer,
    type_id integer NOT NULL,
    CONSTRAINT recording_barsperrepeat_check CHECK ((barsperrepeat >= 0)),
    CONSTRAINT recording_playingseconds_check CHECK ((playingseconds >= 0)),
    CONSTRAINT recording_repetitions_check CHECK ((repetitions >= 0))
);
CREATE TABLE shape (
    id integer NOT NULL,
    name character varying(32) NOT NULL,
    shortname character varying(8) NOT NULL
);
CREATE TABLE shapeprogressionsmap (
    id integer NOT NULL,
    couples_id integer NOT NULL,
    progression_id integer NOT NULL,
    shape_id integer NOT NULL
);
CREATE TABLE step (
    id integer NOT NULL,
    name character varying(32) NOT NULL,
    shortname character varying(8) NOT NULL
);
CREATE TABLE tune (
    id integer NOT NULL,
    created timestamp with time zone,
    last_modified timestamp with time zone,
    name character varying(128) NOT NULL,
    notes text NOT NULL,
    composer_id integer NOT NULL
);
CREATE TABLE tunealias (
    id integer NOT NULL,
    name character varying(128) NOT NULL,
    status smallint NOT NULL,
    tune_id integer NOT NULL,
    CONSTRAINT tunealias_status_check CHECK ((status >= 0))
);
CREATE TABLE tunespublicationsmap (
    id integer NOT NULL,
    priority smallint NOT NULL,
    number integer NOT NULL,
    publication_id integer NOT NULL,
    tune_id integer NOT NULL,
    alias_id integer,
    count smallint NOT NULL,
    page smallint NOT NULL,
    CONSTRAINT tunespublicationsmap_count_check CHECK ((count >= 0)),
    CONSTRAINT tunespublicationsmap_number_check CHECK ((number >= 0)),
    CONSTRAINT tunespublicationsmap_page_check CHECK ((page >= 0)),
    CONSTRAINT tunespublicationsmap_priority_check CHECK ((priority >= 0))
);
CREATE TABLE tunesrecordingsmap (
    id integer NOT NULL,
    number smallint NOT NULL,
    alias_id integer,
    recording_id integer NOT NULL,
    tune_id integer NOT NULL,
    CONSTRAINT tunesrecordingsmap_number_check CHECK ((number >= 0))
);
CREATE TABLE tuneurl (
    id integer NOT NULL,
    url character varying(200) NOT NULL,
    priority smallint NOT NULL,
    tune_id integer NOT NULL,
    errors smallint NOT NULL,
    invalid boolean NOT NULL,
    last_check timestamp with time zone,
    last_status smallint NOT NULL,
    last_success timestamp with time zone,
    CONSTRAINT tuneurl_errors_check CHECK ((errors >= 0)),
    CONSTRAINT tuneurl_last_status_check CHECK ((last_status >= 0)),
    CONSTRAINT tuneurl_priority_check CHECK ((priority >= 0))
);
INSERT INTO 'album' VALUES (1, '1998-05-17 22:00:00+00', '2012-01-20 12:57:53.282069+00', 'Scottish Celebration, A', 'Scot Celeb', 'AP', 1, 430, 1993, 1, '', 3016);
INSERT INTO 'album' VALUES (2, '1998-05-24 22:00:00+00', '2012-01-20 12:57:53.289188+00', 'After the Chord', 'After Chord', 'AP', 1, 67, 0, 1, '', 3014);
INSERT INTO 'album' VALUES (3, '1998-05-18 22:00:00+00', '2012-01-20 12:57:53.298285+00', 'Dance Through The Miscellanies - First Part', 'Miscellanies 1', 'AP', 1, 230, 1996, 1, '', 3002);
INSERT INTO 'album' VALUES (4, '1998-05-17 22:00:00+00', '2012-01-20 12:57:53.304906+00', 'Dance Through The Miscellanies - Second Part', 'Miscellanies 2', 'AP', 1, 231, 1996, 1, '', 3002);
INSERT INTO 'album' VALUES (5, '1998-05-18 22:00:00+00', '2012-01-20 12:57:53.311166+00', 'Dances from the Collections of Mary Isdale MacNab Vol 1', 'MacNab 1', 'AP', 1, 224, 1996, 1, '', 3015);
INSERT INTO 'album' VALUES (6, '1998-05-18 22:00:00+00', '2012-01-20 12:57:53.317409+00', 'Dances from the Collections of Mary Isdale MacNab Vol 2', 'MacNab 2', 'AP', 1, 225, 1996, 1, '', 3015);
INSERT INTO 'album' VALUES (7, '1998-05-26 22:00:00+00', '2012-01-20 12:57:53.323799+00', 'Free Spirit', 'Free Spirit', 'AP', 1, 392, 1996, 1, '', 3003);
INSERT INTO 'album' VALUES (8, '1998-05-17 22:00:00+00', '2012-01-20 12:57:53.333295+00', 'Highlander Music Old Masters Volume 1', 'Old Masters 1', 'AP', 1, 290, 1996, 1, '', 3001);
INSERT INTO 'album' VALUES (9, '1998-05-18 22:00:00+00', '2012-01-20 12:57:53.339562+00', 'Highlander Music Old Masters Volume 2', 'Old Masters 2', 'AP', 1, 423, 1996, 1, '', 3016);
INSERT INTO 'album' VALUES (15, '1998-05-18 22:00:00+00', '2012-01-20 12:57:53.377653+00', 'Scotland - The Dances and Dance Bands', 'Scotland D & DB', 'AP', 1, 428, 1987, 1, '', 3016);
INSERT INTO 'album' VALUES (16, '1998-05-18 22:00:00+00', '2012-01-20 12:57:53.386687+00', 'Scottish Dance Favourites Volume 1', 'SD Favourites 1', 'AP', 1, 435, 1995, 1, '', 3016);
INSERT INTO 'album' VALUES (17, '1998-05-17 22:00:00+00', '2012-01-20 12:57:53.393064+00', 'Scottish Dance Favourites Volume 2', 'SD Favourites 2', 'AP', 1, 436, 1995, 1, '', 3016);
INSERT INTO 'album' VALUES (18, '1998-05-18 22:00:00+00', '2012-01-20 12:57:53.399312+00', 'Scottish Dance Favourites Volume 3', 'SD Favourites 3', 'AP', 1, 437, 1995, 1, '', 3016);
INSERT INTO 'album' VALUES (19, '1999-03-09 23:00:00+00', '2012-01-20 12:57:53.405557+00', 'Terpsichore, Scottish Dance Music', 'SD Music (Terp)', 'AP', 1, 400, 1994, 1, '', 3017);
INSERT INTO 'album' VALUES (20, '1998-05-18 22:00:00+00', '2012-01-20 12:57:53.414706+00', 'Scottish Reflections', 'Sc.Reflections', 'AP', 1, 439, 1996, 1, '', 3016);
INSERT INTO 'album' VALUES (21, '1999-10-05 22:00:00+00', '2012-01-20 12:57:53.423758+00', 'Selected Scottish Country Dances', 'Selected SCD', 'AP', 1, 277, 1989, 1, '', 3009);
INSERT INTO 'album' VALUES (22, '1998-05-25 22:00:00+00', '2012-01-20 12:57:53.435721+00', 'Special Requests Volume 1', 'Sp.Requests 1', 'AP', 1, 109, 1996, 1, '', 3013);
INSERT INTO 'album' VALUES (23, '1998-05-17 22:00:00+00', '2012-01-20 12:57:53.445019+00', 'Best of Scottish Dance Bands, The', 'Best of SDB', 'AP', 1, 413, 1997, 1, '', 3016);
INSERT INTO 'album' VALUES (24, '1999-05-08 22:00:00+00', '2012-01-20 12:57:53.454084+00', 'Legendary Jimmy Shand, The', 'Legendary JS', 'IS', 1, 373, 1997, 1, '', 3010);
INSERT INTO 'album' VALUES (25, '1998-05-17 22:00:00+00', '2012-01-20 12:57:53.460455+00', 'World of Scottish Dance, The', 'World of SD', 'AP', 1, 443, 1993, 1, '', 3016);
INSERT INTO 'album' VALUES (27, '1998-05-25 22:00:00+00', '2012-01-20 12:57:53.472931+00', 'Complete Caledonian Ball, The', 'Caled. Ball', 'AP', 1, 161, 1988, 1, '', 3026);
INSERT INTO 'album' VALUES (28, '1998-05-26 22:00:00+00', '2012-01-20 12:57:53.482092+00', 'Scottish Dance Music', 'MM SD Music', 'AP', 1, 308, 1995, 1, '', 3030);
INSERT INTO 'album' VALUES (29, '1998-05-18 22:00:00+00', '2012-01-20 12:57:53.491125+00', 'Come Scottish Country Dancing', 'SCD Adamson', 'AP', 1, 3, 1996, 1, '', 3032);
INSERT INTO 'album' VALUES (30, '2002-05-23 22:00:00+00', '2012-01-20 12:57:53.500325+00', 'Diamond Jubilee', 'Diamond Jblee', 'AP', 1, 174, 1995, 1, '', 1396);
INSERT INTO 'album' VALUES (31, '1998-05-26 22:00:00+00', '2012-01-20 12:57:53.510064+00', 'Magic Medicine', 'Magic Medicine', 'AP', 1, 311, 1994, 1, '', 3012);
INSERT INTO 'album' VALUES (1028, '2012-12-27 21:01:08.224856+00', '2012-12-28 11:15:45.731051+00', 'Just As It Was 3', 'Just 3', '', 0, 0, 2012, 0, '', 903);
INSERT INTO 'album' VALUES (33, '1999-05-25 22:00:00+00', '2012-01-20 12:57:53.525833+00', 'Scottish Fancy, A', 'Scot Fancy CD', 'RS', 1, 382, 0, 1, '', 3010);
INSERT INTO 'album' VALUES (1017, '2012-02-28 14:41:29.196973+00', '2012-02-28 14:51:33.421887+00', 'Just As It Was - Sampler', 'Just-Sampler', '', 0, 0, 2011, 0, '', 903);
INSERT INTO 'album' VALUES (1033, '2013-01-02 14:53:12.825276+00', '2013-01-02 16:55:18.98949+00', 'Favourite SCDs Vol. 4 Dancer''s Choice', '', '', 0, 0, 2012, 0, '', 3678);
INSERT INTO 'album' VALUES (1021, '2012-05-31 07:12:40.857606+00', '2012-05-31 08:23:55.255011+00', 'Take Your Partners For Vol 3', 'Take Your Partners 3', '', 0, 0, 2012, 0, '', 10034);
INSERT INTO 'album' VALUES (1032, '2012-12-31 15:25:07.493738+00', '2012-12-31 16:43:57.979674+00', 'Diamond Jubilee Year, The', 'Queen''s Diamond Jubilee', '', 0, 0, 2012, 0, '', 2944);
INSERT INTO 'album' VALUES (1018, '2012-04-23 09:22:36.463219+00', '2012-04-23 10:00:53.411427+00', 'Let''s Go Scottish Country Dancing Vol 4', 'Let''s Go SCD 4', '', 0, 1, 2012, 1, '', 10614);
INSERT INTO 'album' VALUES (1025, '2012-09-26 14:05:18.683879+00', '2012-09-26 14:29:47.091215+00', 'Magazine Dances 2005-2009', 'Magazine Dances', '', 0, 1, 2012, 1, '', 3016);
INSERT INTO 'album' VALUES (32, '1998-10-18 22:00:00+00', '2012-09-27 11:27:03.939893+00', 'Reel Friends', 'Reel Friends', 'AP', 1, 72, 1993, 1, '', 3014);
INSERT INTO 'album' VALUES (1019, '2012-04-29 12:38:11.466786+00', '2012-04-29 14:31:43.286447+00', '6 x Through the Dance', '6xThrough', '', 0, 1, 2011, 0, '', 1502);
INSERT INTO 'album' VALUES (26, '1998-05-17 22:00:00+00', '2012-10-04 10:13:01.918537+00', 'Tweedside', 'Tweedside', 'AP', 1, 442, 1996, 1, '', 3016);
INSERT INTO 'album' VALUES (1040, '2013-01-16 12:42:18.896233+00', '2013-01-16 14:25:38.27306+00', 'Memories of Jim Johnstone', '', '', 0, 0, 2010, 0, '', 3016);
INSERT INTO 'album' VALUES (1029, '2012-12-28 13:25:39.577143+00', '2012-12-28 15:07:07.272869+00', 'Hairst Blinks', 'Hairst', '', 0, 0, 2011, 0, '', 10679);
INSERT INTO 'album' VALUES (1023, '2012-06-17 14:20:47.762768+00', '2012-06-17 15:15:12.688849+00', 'Dance for Joy Encore!', 'Dance for Joy Enc', '', 0, 0, 2012, 0, '', 10000);
INSERT INTO 'album' VALUES (1026, '2012-12-27 11:17:12.922844+00', '2012-12-27 12:20:24.689857+00', 'Just As It Was 1', 'Just 1', '', 0, 0, 2012, 0, '', 903);
INSERT INTO 'album' VALUES (1038, '2013-01-06 13:40:23.422612+00', '2013-01-06 14:49:54.556185+00', 'Legendary Scottish Dance Bands Vol 1', 'Legendary Bands 1', '', 0, 0, 2012, 0, '', 3016);
INSERT INTO 'album' VALUES (1034, '2013-01-03 08:15:56.085385+00', '2013-01-03 11:24:21.369627+00', 'Birling', 'Birling', '', 0, 0, 2012, 0, '', 2088);
INSERT INTO 'album' VALUES (1027, '2012-12-27 12:51:01.340905+00', '2012-12-27 20:33:04.711539+00', 'Just As It Was 2', 'Just 2', '', 0, 0, 2012, 0, '', 903);
INSERT INTO 'album' VALUES (1031, '2012-12-28 18:09:37.074079+00', '2013-01-01 19:16:04.95419+00', 'Diversity', '', '', 0, 0, 2007, 0, '', 10687);
INSERT INTO 'album' VALUES (1030, '2012-12-28 15:36:29.906157+00', '2012-12-28 16:59:03.047308+00', 'Let''s Dance ...', '', '', 0, 0, 2006, 0, '', 2583);
INSERT INTO 'album' VALUES (1037, '2013-01-05 16:28:14.188844+00', '2013-01-05 17:59:58.964243+00', 'Over the Waves to Shetland', 'Over the Waves', '', 0, 0, 2005, 0, '', 10108);
INSERT INTO 'album' VALUES (1036, '2013-01-04 15:33:15.009003+00', '2013-01-04 16:36:17.585813+00', 'Hello & Goodbye', 'H&G', '', 0, 0, 2012, 0, '', 10695);
INSERT INTO 'album' VALUES (1043, '2013-02-03 15:07:44.710503+00', '2013-02-03 15:56:18.425864+00', 'In West Coast Style', 'West Coast Style', '', 0, 0, 0, 0, '', 10547);
INSERT INTO 'album' VALUES (1044, '2013-02-03 17:23:03.343379+00', '2013-02-03 17:32:54.811707+00', 'Scottish Dance Frolic', 'Frolic', '', 0, 0, 0, 0, '', 2060);
INSERT INTO 'album' VALUES (1045, '2013-02-04 13:48:55.551595+00', '2013-02-04 13:58:05.435729+00', 'Let''s Go Scottish Country Dancing Vol 6', 'Let''s Go 6', '', 0, 0, 2012, 0, '', 3016);
INSERT INTO 'album' VALUES (1046, '2013-02-04 15:25:34.945637+00', '2013-02-04 15:38:08.457086+00', 'Let''s Go Scottish Country Dancing Vol 5', 'Let''s Go 5', '', 0, 1, 2012, 1, '', 3016);
INSERT INTO 'album' VALUES (1047, '2013-02-05 14:30:41.064821+00', '2013-02-05 16:10:12.831482+00', 'National Odyssey', 'Odyssey', '', 0, 1, 2012, 1, '', 3016);
INSERT INTO 'album' VALUES (1048, '2013-02-06 11:31:12.529514+00', '2013-02-06 14:46:22.489579+00', 'Scottish Accordion Favourites', '', '', 0, 1, 2012, 1, '', 10748);
INSERT INTO 'album' VALUES (1049, '2013-02-15 17:42:29.465195+00', '2013-02-15 17:51:03.405961+00', 'Scottish Dance Music', 'Scottish Dance Music', '', 0, 0, 2012, 0, 'Exists as LP "Meet the Olympains" too', 3024);
INSERT INTO 'album' VALUES (36, '1998-12-04 23:00:00+00', '2012-01-20 12:57:53.560879+00', 'Kirkbrae Collection, The', 'Kirkbrae 1', 'AH', 1, 388, 1997, 1, '', 3060);
INSERT INTO 'album' VALUES (37, '1998-05-25 22:00:00+00', '2012-01-20 12:57:53.567374+00', 'Let''s Meet Again', 'Meet Again', 'AP', 1, 141, 1996, 1, '', 3034);
INSERT INTO 'album' VALUES (173, '1998-12-20 23:00:00+00', '2012-01-20 12:57:54.762404+00', 'Fine Fettle', 'Fine Fettle', '', 0, 303, 0, 1, '', 2505);
INSERT INTO 'album' VALUES (10, '2000-04-04 22:00:00+00', '2013-04-10 09:57:17.293928+00', 'Highlander Music Scottish Dances Vol 1', 'Highlander SD 1', 'AP', 1, 309, 1996, 1, '', 3012);
INSERT INTO 'album' VALUES (11, '2000-04-04 22:00:00+00', '2013-04-10 09:57:31.454363+00', 'Highlander Music Scottish Dances Vol 2', 'Highlander SD 2', 'AP', 1, 14, 1996, 1, '', 3011);
INSERT INTO 'album' VALUES (13, '2000-04-04 22:00:00+00', '2013-04-10 09:58:01.384987+00', 'Highlander Music Scottish Dances Vol 4', 'Highlander SD 4', 'AP', 1, 191, 1996, 1, '', 3007);
INSERT INTO 'album' VALUES (14, '2000-04-04 22:00:00+00', '2013-04-10 09:58:15.845943+00', 'Highlander Music Scottish Dances Vol 5', 'Highlander SD 5', 'AP', 1, 283, 1996, 1, '', 3008);
INSERT INTO 'album' VALUES (1039, '2013-01-06 16:55:34.206502+00', '2013-08-09 13:34:36.88104+00', 'Macadians Dancing Master, The', 'Macadians D M', '', 0, 1, 2011, 1, '', 2029);
INSERT INTO 'album' VALUES (1042, '2013-02-02 15:20:40.131927+00', '2014-05-13 10:07:58.19421+00', 'Very Best of George Bell''s Scottish Dance Band, The - Vol 2', 'George Bell 2', '', 0, 0, 2006, 0, '', 10146);
INSERT INTO 'album' VALUES (1041, '2013-01-17 15:22:48.869496+00', '2014-05-13 10:08:33.283746+00', 'Very Best of George Bell''s Scottish Dance Band, The - Vol 1', 'George Bell 1', '', 0, 0, 2006, 0, '', 10146);
INSERT INTO 'album' VALUES (39, '1998-10-25 23:00:00+00', '2012-01-20 12:57:53.582753+00', 'Shores of Loch Alvie, The', 'Loch Alvie', 'BC', 1, 89, 1991, 1, '', 3018);
INSERT INTO 'album' VALUES (40, '1999-09-12 22:00:00+00', '2012-01-20 12:57:53.593424+00', 'Repeat Prescription', 'Rept Prescript', 'AP', 1, 312, 1992, 1, '', 3012);
INSERT INTO 'album' VALUES (41, '1998-06-16 22:00:00+00', '2012-01-20 12:57:53.603364+00', 'Dancer''s Miscellany Vol IV, A', 'Dancer''s Misc 4', 'AP', 1, 235, 1994, 1, '', 3002);
INSERT INTO 'album' VALUES (1020, '2012-05-09 15:22:08.371662+00', '2023-08-28 11:04:50.103711+00', 'Dancing on Air', 'Dancing Air', '', 0, 1, 2011, 1, '', 1502);
INSERT INTO 'album' VALUES (38, '1998-07-16 22:00:00+00', '2023-10-04 15:56:16.909864+00', 'True Reflection, A', 'True Reflection', 'PA', 1, 140, 0, 1, '', 3036);
INSERT INTO 'album' VALUES (42, '1998-06-16 22:00:00+00', '2012-01-20 12:57:53.609604+00', 'Book 18. Music for Twelve Scottish Country Dances', 'RSCDS 18', 'AP', 1, 112, 1995, 1, '', 3023);
INSERT INTO 'album' VALUES (43, '1999-05-25 22:00:00+00', '2012-01-20 12:57:53.618725+00', 'Book 17. Music for Twelve Scottish Country Dances', 'RSCDS 17', 'AP', 1, 461, 1994, 1, '', 3022);
INSERT INTO 'album' VALUES (44, '1999-05-25 22:00:00+00', '2012-01-20 12:57:53.62795+00', 'Book 13/14. Eight Scottish Country Dances', 'RSCDS 13/14', 'AP', 1, 82, 1990, 1, '', 3018);
INSERT INTO 'album' VALUES (45, '2002-05-23 22:00:00+00', '2012-01-20 12:57:53.637451+00', 'Manchester Medley, A', 'Manchester Med.', 'AP', 1, 175, 1990, 1, '', 1396);
INSERT INTO 'album' VALUES (46, '1998-06-16 22:00:00+00', '2012-01-20 12:57:53.64418+00', 'Dancer''s Miscellany Vol II, A', 'Dancer''s Misc 2', 'AP', 1, 233, 1991, 1, '', 3002);
INSERT INTO 'album' VALUES (47, '1998-06-16 22:00:00+00', '2012-01-20 12:57:53.650618+00', 'Dancer''s Miscellany Vol III, A', 'Dancer''s Misc 3', 'AP', 1, 234, 1993, 1, '', 3002);
INSERT INTO 'album' VALUES (48, '2001-05-16 22:00:00+00', '2012-01-20 12:57:53.657278+00', 'Dancing Fingers 3', 'Fingers 3', 'AP', 1, 218, 1992, 1, '', 1502);
INSERT INTO 'album' VALUES (49, '1999-10-09 22:00:00+00', '2012-01-20 12:57:53.666362+00', 'Book 16. Music for Twelve Scottish Country Dances', 'RSCDS 16', 'AP', 1, 83, 1993, 1, '', 3018);
INSERT INTO 'album' VALUES (50, '1999-05-25 22:00:00+00', '2012-01-20 12:57:53.681333+00', 'Book 37. Frae a'' the Airts, Vol 2', 'RSCDS 37', 'AP', 1, 130, 1992, 1, '', 3021);
INSERT INTO 'album' VALUES (51, '1998-06-16 22:00:00+00', '2012-01-20 12:57:53.6932+00', 'Let''s Dance Again...', 'Dance Again', 'AP', 1, 200, 1992, 1, '', 3038);
INSERT INTO 'album' VALUES (52, '1998-06-16 22:00:00+00', '2012-01-20 12:57:53.69963+00', 'Life begins at Forty', 'Life begins 40', 'AP', 1, 452, 1991, 1, '', 3039);
INSERT INTO 'album' VALUES (53, '1998-06-16 22:00:00+00', '2012-01-20 12:57:53.705828+00', 'In Strict Tempo', 'In Strict Tempo', 'AP', 1, 249, 1981, 1, '', 3040);
INSERT INTO 'album' VALUES (54, '1998-06-16 22:00:00+00', '2012-01-20 12:57:53.714819+00', 'Dancer''s Miscellany Vol I, A', 'Dancer''s Misc 1', 'AP', 1, 232, 1990, 1, '', 3002);
INSERT INTO 'album' VALUES (55, '1999-05-25 22:00:00+00', '2012-01-20 12:57:53.721179+00', 'Book 36. Frae a'' the Airts, Vol 1', 'RSCDS 36', 'AP', 1, 198, 1990, 1, '', 3038);
INSERT INTO 'album' VALUES (56, '1999-05-25 22:00:00+00', '2012-01-20 12:57:53.730182+00', 'Book 35. Music for Eight Scottish Country Dances', 'RSCDS 35', 'AP', 1, 267, 1988, 1, '', 3009);
INSERT INTO 'album' VALUES (60, '1999-05-25 22:00:00+00', '2012-01-20 12:57:53.764009+00', 'Book 13. Music for Eight Scottish Country Dances', 'RSCDS 13', 'AP', 1, 81, 1989, 1, '', 3018);
INSERT INTO 'album' VALUES (62, '1998-06-16 22:00:00+00', '2012-01-20 12:57:53.779321+00', 'Best Foot Forward', 'Best Foot Fwd', 'AP', 1, 391, 1992, 1, '', 3003);
INSERT INTO 'album' VALUES (64, '2002-05-23 22:00:00+00', '2012-01-20 12:57:53.794804+00', 'Taste of Andrew Rankine, A', 'Taste of AR', 'AP', 1, 440, 1993, 1, '', 3016);
INSERT INTO 'album' VALUES (65, '2002-05-11 22:00:00+00', '2012-01-20 12:57:53.803844+00', 'Book 39. Music for Nine Scottish Country Dances', 'RSCDS 39', 'AP', 1, 406, 1996, 1, '', 3019);
INSERT INTO 'album' VALUES (66, '1998-10-13 22:00:00+00', '2012-01-20 12:57:53.812981+00', 'Music for Fifteen Dances', '15 Dances', 'AP', 1, 421, 1990, 1, '', 3016);
INSERT INTO 'album' VALUES (67, '1999-05-25 22:00:00+00', '2012-04-14 15:40:23.120855+00', 'Book 38. Music for Eight Scottish Country Dances', 'RSCDS 38', 'AP', 1, 229, 1994, 1, '', 3002);
INSERT INTO 'album' VALUES (243, '2002-06-10 22:00:00+00', '2012-01-20 12:57:55.258735+00', 'To Dance To', 'To Dance To', 'CG', 1, 190, 0, 1, '', 3051);
INSERT INTO 'album' VALUES (35, '2001-05-14 22:00:00+00', '2012-09-27 12:21:22.949573+00', 'Dancing Fingers 2', 'Fingers 2', 'AP', 1, 217, 2001, 1, '', 1502);
INSERT INTO 'album' VALUES (68, '1999-05-25 22:00:00+00', '2012-01-20 12:57:53.828205+00', 'Book 34. Music for Eight Traditional Dances', 'RSCDS 34', 'AP', 1, 463, 1986, 1, '', 3022);
INSERT INTO 'album' VALUES (70, '1998-05-26 22:00:00+00', '2012-01-20 12:57:53.849378+00', 'Craigievar Dances', 'Craigievar', 'AP', 1, 301, 1997, 1, '', 3045);
INSERT INTO 'album' VALUES (71, '1999-05-25 22:00:00+00', '2012-01-20 12:57:53.85842+00', 'Special Requests Volume 2', 'Sp.Requests 2', 'AP', 1, 107, 1997, 1, '', 3046);
INSERT INTO 'album' VALUES (72, '1999-05-25 22:00:00+00', '2012-01-20 12:57:53.867486+00', 'Muckle Carfuffle', 'Muckle C.', 'AP', 1, 59, 1992, 1, '', 3047);
INSERT INTO 'album' VALUES (73, '1998-09-02 22:00:00+00', '2012-01-20 12:57:53.87646+00', 'Strictly Scottish Volume One', 'Strictly Scot 1', 'AP', 1, 453, 1997, 1, '', 3039);
INSERT INTO 'album' VALUES (76, '2002-05-11 22:00:00+00', '2012-01-20 12:57:53.903749+00', 'Book 22. Twelve Modern Scottish Country Dances', 'RSCDS 22', 'AP', 1, 97, 1997, 1, '', 3006);
INSERT INTO 'album' VALUES (81, '1998-05-18 22:00:00+00', '2012-01-20 12:57:53.952895+00', 'Dancing Forth', 'Dancing Forth', 'AP', 1, 355, 1997, 1, '', 3050);
INSERT INTO 'album' VALUES (82, '1998-09-02 22:00:00+00', '2012-01-20 12:57:53.959299+00', 'Lorne Choice', 'Lorne Choice', 'AP', 1, 201, 1997, 1, '', 3038);
INSERT INTO 'album' VALUES (86, '1999-02-24 23:00:00+00', '2012-01-20 12:57:53.993386+00', 'Tae Gar Ye Loup', 'Tae Gar', 'RC', 1, 66, 1984, 1, '', 2570);
INSERT INTO 'album' VALUES (87, '1998-11-17 23:00:00+00', '2012-01-20 12:57:54.002359+00', 'Come Scottish Country Dancing', 'Come SCD (JC)', 'PM', 1, 51, 1961, 1, '', 3065);
INSERT INTO 'album' VALUES (88, '1998-11-21 23:00:00+00', '2012-01-20 12:57:54.011336+00', 'Dancing World of Iain MacPhail, The', 'Dancing World', 'PM', 1, 282, 1993, 1, '', 3008);
INSERT INTO 'album' VALUES (89, '1998-11-19 23:00:00+00', '2012-01-20 12:57:54.020403+00', 'Take the Floor', 'Take the Floor', 'PM', 1, 214, 1992, 1, '', 3037);
INSERT INTO 'album' VALUES (90, '1999-01-30 23:00:00+00', '2012-01-20 12:57:54.026593+00', 'Let''s Dance Again. Volume 2', 'Dance Again 2', 'IS', 1, 199, 1994, 1, '', 3038);
INSERT INTO 'album' VALUES (91, '1998-10-11 22:00:00+00', '2012-01-20 12:57:54.032846+00', 'Dancer''s Choice', 'Dancer''s Choice', 'RC', 1, 202, 0, 1, '', 2303);
INSERT INTO 'album' VALUES (92, '1998-10-20 22:00:00+00', '2012-01-20 12:57:54.039143+00', 'Alastair Hunter and the Lorne Scottish Dance Band', 'AH & Lorne SDB', 'IS', 1, 195, 1989, 1, '', 3038);
INSERT INTO 'album' VALUES (94, '2000-08-01 22:00:00+00', '2012-01-20 12:57:54.051625+00', 'Island Fling, The', 'Island Fling', 'AP', 1, 40, 1979, 1, '', 3067);
INSERT INTO 'album' VALUES (95, '2000-08-01 22:00:00+00', '2012-01-20 12:57:54.060999+00', 'Maid of the Mill, The', 'Maid of Mill', 'DS', 1, 41, 1980, 1, '', 3067);
INSERT INTO 'album' VALUES (96, '2000-08-01 22:00:00+00', '2012-01-20 12:57:54.073218+00', 'Tarry a While', 'Tarry Awhile', 'DS', 1, 45, 1981, 1, '', 3067);
INSERT INTO 'album' VALUES (97, '1998-09-02 22:00:00+00', '2012-01-20 12:57:54.085296+00', 'Saint Andrew''s Ball - Volume 1', 'St. A. Ball 1', '', 0, 61, 0, 1, '', 3068);
INSERT INTO 'album' VALUES (98, '1998-11-23 23:00:00+00', '2012-01-20 12:57:54.093492+00', 'Lindsay Ross & his Scottish Dance Band', 'LR & his SDB', 'BL', 1, 346, 1967, 1, '', 3069);
INSERT INTO 'album' VALUES (99, '1999-01-31 23:00:00+00', '2012-01-20 12:57:54.101872+00', 'Highland Airs', 'Highland Airs', 'IS', 1, 324, 1994, 1, '', 3070);
INSERT INTO 'album' VALUES (100, '1998-11-23 23:00:00+00', '2012-01-20 12:57:54.110177+00', 'Best in Scottish Dance Music, The, Volume 1', 'Best in SDM 1', 'BC', 1, 410, 1981, 1, '', 3016);
INSERT INTO 'album' VALUES (102, '1998-12-04 23:00:00+00', '2012-01-20 12:57:54.126724+00', 'Best in Scottish Dance Music, The, Volume 3', 'Best in SDM 3', 'AH', 1, 412, 1989, 1, '', 3016);
INSERT INTO 'album' VALUES (84, '1998-05-26 22:00:00+00', '2012-04-14 14:53:42.806972+00', 'North of the Tweed', 'N of Tweed', 'AP', 1, 237, 1995, 1, '', 3002);
INSERT INTO 'album' VALUES (83, '1998-11-25 23:00:00+00', '2012-04-14 15:03:30.012558+00', 'Skye Collection, A', 'Skye Coll', 'AP', 1, 239, 1997, 1, '', 3002);
INSERT INTO 'album' VALUES (75, '1998-06-15 22:00:00+00', '2012-12-26 11:32:01.540301+00', 'Book 21. Music for Twelve Scottish Country Dances', 'RSCDS 21', 'AP', 1, 343, 2002, 1, '', 3049);
INSERT INTO 'album' VALUES (103, '2001-01-15 23:00:00+00', '2012-01-20 12:57:54.135209+00', 'Music for Scottish Dancing', 'Music for SD', 'AP', 1, 15, 1993, 1, '', 3011);
INSERT INTO 'album' VALUES (80, '1999-05-25 22:00:00+00', '2013-04-10 06:23:23.932661+00', 'Book 4. Music for Twelve Scottish Country Dances', 'RSCDS 4', 'AP', 1, 12, 1985, 1, '', 3011);
INSERT INTO 'album' VALUES (63, '1999-05-25 22:00:00+00', '2013-04-10 06:19:59.402453+00', 'Book 9. Music for Twelve Scottish Country Dances', 'RSCDS 9', 'AP', 1, 80, 1988, 1, '', 3018);
INSERT INTO 'album' VALUES (69, '1999-05-25 22:00:00+00', '2013-04-10 06:27:06.365472+00', 'Book 5. Music for Twelve Traditional Dances', 'RSCDS 5', 'AP', 1, 404, 1986, 1, '', 3019);
INSERT INTO 'album' VALUES (58, '1998-06-15 22:00:00+00', '2013-12-07 09:33:24.24227+00', 'Book 14/15. Music for Scottish Country Dances (2)', 'RSCDS 14/15 (2)', 'AP', 1, 129, 1991, 1, 'The full title of the MC is: 

MUSIC FOR SCOTTISH COUNTRY DANCES 

From Books 14 and 15. 

CASSETTE 2 - SIX DANCES



FIDDLERS THREE PLUS TWO

', 3021);
INSERT INTO 'album' VALUES (74, '1998-05-25 22:00:00+00', '2014-03-13 09:35:42.503649+00', 'Ghillies on the Golden Gate', 'Ghillies', 'AP', 1, 131, 1992, 1, '', 3048);
INSERT INTO 'album' VALUES (107, '1999-05-25 22:00:00+00', '2012-01-20 12:57:54.190549+00', 'Book 10.', 'RSCDS 10', 'RS', 1, 133, 1988, 1, '', 3020);
INSERT INTO 'album' VALUES (108, '1999-05-25 22:00:00+00', '2012-01-20 12:57:54.202459+00', 'Book 11.', 'RSCDS 11', 'AP', 1, 196, 1988, 1, '', 3038);
INSERT INTO 'album' VALUES (109, '1999-05-25 22:00:00+00', '2012-01-20 12:57:54.214648+00', 'Book 12.', 'RSCDS 12', 'PM', 1, 110, 1988, 1, '', 3023);
INSERT INTO 'album' VALUES (110, '1998-11-20 23:00:00+00', '2012-01-20 12:57:54.22651+00', 'Book 14.', 'RSCDS 14', 'PM', 1, 111, 1990, 1, '', 3023);
INSERT INTO 'album' VALUES (78, '1999-06-30 22:00:00+00', '2017-02-23 12:34:06.717852+00', 'Book 2. Music for Eleven Traditional Dances', 'RSCDS 2', 'AP', 1, 78, 1982, 1, '', 3018);
INSERT INTO 'album' VALUES (1050, '2013-02-22 14:26:12.460462+00', '2017-07-27 15:19:43.024618+00', 'Ah''m Dancin''! - Old Time Dances', 'Ah ''m Dancin''!', '', 0, 0, 2012, 0, '', 10209);
INSERT INTO 'album' VALUES (1110, '2018-03-30 08:21:17.947806+00', '2018-04-29 12:57:41.82364+00', 'Swans of Atlanta, The', '', '', 0, 0, 2016, 0, '', 11613);
INSERT INTO 'album' VALUES (111, '2002-03-12 23:00:00+00', '2012-01-20 12:57:54.238717+00', 'Book 19. Music for Twelve Scottish Country Dances', 'RSCDS 19', 'MB', 1, 240, 1996, 1, '', 3028);
INSERT INTO 'album' VALUES (112, '2001-05-12 22:00:00+00', '2012-01-20 12:57:54.247223+00', 'Book 20. Music for Twelve Scottish Country Dances', 'RSCDS 20', 'IS', 1, 297, 1996, 1, '', 3071);
INSERT INTO 'album' VALUES (113, '1999-01-19 23:00:00+00', '2012-01-20 12:57:54.255603+00', 'Book 27. Music for Twelve Traditional Dances', 'RSCDS 27', 'JW', 1, 317, 1975, 1, '', 3024);
INSERT INTO 'album' VALUES (115, '1999-05-25 22:00:00+00', '2012-01-20 12:57:54.283304+00', 'Book 29. Music for Ten Traditional Dances', 'RSCDS 29', 'AP', 1, 84, 2002, 1, '', 3018);
INSERT INTO 'album' VALUES (61, '1998-06-16 22:00:00+00', '2023-08-28 11:03:18.362148+00', 'Crystal Collection, The', 'Crystal Coll', 'AP', 1, 247, 1993, 1, '', 3040);
INSERT INTO 'album' VALUES (116, '1998-11-15 23:00:00+00', '2012-01-20 12:57:54.299087+00', 'Book 30.', 'RSCDS 30', 'JW', 1, 85, 0, 1, '', 3018);
INSERT INTO 'album' VALUES (117, '2001-05-12 22:00:00+00', '2012-01-20 12:57:54.310948+00', 'Book 31. Music for Eight Scottish Country Dances', 'RSCDS 31', 'RM', 1, 156, 1983, 1, '', 3026);
INSERT INTO 'album' VALUES (119, '1999-05-25 22:00:00+00', '2012-01-20 12:57:54.338698+00', 'Music for 12 Trad. Dances from the Graded Book', 'RSCDS Gr', 'IS', 1, 167, 1984, 1, '', 3026);
INSERT INTO 'album' VALUES (121, '1998-10-26 23:00:00+00', '2012-01-20 12:57:54.363446+00', 'Music for Eight Scottish Country Dances 1987', '8 SCD (1987)', 'MK', 1, 87, 1987, 1, '', 3018);
INSERT INTO 'album' VALUES (124, '2003-02-15 23:00:00+00', '2012-01-20 12:57:54.399582+00', 'Scotland Dances', 'Scotland Dances', 'EN', 1, 264, 0, 1, '', 2328);
INSERT INTO 'album' VALUES (125, '1998-11-25 23:00:00+00', '2012-01-20 12:57:54.407774+00', 'Burns'' Night in the Annapolis Valley', 'Annapolis', 'AP', 1, 287, 0, 1, '', 2029);
INSERT INTO 'album' VALUES (126, '2001-10-31 23:00:00+00', '2012-01-20 12:57:54.416168+00', 'Camp of Pleasure, A', 'Camp / Pleasure', 'DS', 1, 19, 1976, 1, '', 2035);
INSERT INTO 'album' VALUES (127, '1998-10-06 22:00:00+00', '2012-01-20 12:57:54.429377+00', 'Reel Dram, A', 'Reel Dram', 'PM', 1, 238, 1989, 1, '', 3002);
INSERT INTO 'album' VALUES (128, '1999-06-30 22:00:00+00', '2012-01-20 12:57:54.43756+00', 'Another Celebration', 'Another Celeb', 'JW', 1, 246, 1988, 1, '', 3040);
INSERT INTO 'album' VALUES (129, '1998-10-12 22:00:00+00', '2012-01-20 12:57:54.446094+00', 'Argyll''s Fancy', 'Argyll''s Fancy', 'RC', 1, 281, 1985, 1, '', 3008);
INSERT INTO 'album' VALUES (130, '1998-10-11 22:00:00+00', '2012-01-20 12:57:54.458078+00', 'Authentic Scottish Dancing Music', 'Authentic SDM', 'RC', 1, 294, 0, 1, '', 2058);
INSERT INTO 'album' VALUES (131, '1999-01-21 23:00:00+00', '2012-01-20 12:57:54.466332+00', 'Barmkin. The Dancing Years & other Leeds'' Branch Dances', 'Barmkin', 'JW', 1, 227, 0, 1, '', 3002);
INSERT INTO 'album' VALUES (132, '1998-12-01 23:00:00+00', '2012-01-20 12:57:54.475127+00', 'Bath Scottish Dancers', 'Bath SD', 'PM', 1, 68, 1988, 1, '', 3014);
INSERT INTO 'album' VALUES (133, '1999-05-25 22:00:00+00', '2012-01-20 12:57:54.483631+00', 'Something Old - Something New', 'Something Old', '', 0, 339, 0, 1, '', 2414);
INSERT INTO 'album' VALUES (134, '2003-01-28 23:00:00+00', '2012-01-20 12:57:54.491247+00', 'Scottish Country Dances (Vol. 1)', 'AM - SCD 1', '00', 1, 291, 1978, 1, '', 3001);
INSERT INTO 'album' VALUES (135, '1998-10-11 22:00:00+00', '2012-01-20 12:57:54.497514+00', 'Boston Hospitality', 'Boston Hosp', 'RC', 1, 321, 1987, 1, '', 2061);
INSERT INTO 'album' VALUES (136, '1998-11-14 23:00:00+00', '2012-01-20 12:57:54.506624+00', 'Caber Feidh', 'Caber Feidh', 'IM', 1, 48, 1977, 1, '', 2041);
INSERT INTO 'album' VALUES (137, '1999-05-25 22:00:00+00', '2012-01-20 12:57:54.512837+00', 'Caledonian Ball, The - Vol 1', 'Cale Ball 1', 'PM', 1, 157, 0, 1, '', 3026);
INSERT INTO 'album' VALUES (120, '1998-07-16 22:00:00+00', '2012-08-30 12:16:03.517266+00', 'Eight Scottish Country Dances', '8 SCD Gonnella', 'HO', 1, 154, 1983, 1, '', 3044);
INSERT INTO 'album' VALUES (114, '1998-11-23 23:00:00+00', '2012-09-16 15:45:42.032273+00', 'Book 28.', 'RSCDS 28', 'AH', 1, 243, 1977, 1, '', 3025);
INSERT INTO 'album' VALUES (138, '1999-05-25 22:00:00+00', '2012-01-20 12:57:54.519011+00', 'Caledonian Ball, The - Vol 3', 'Cale Ball 3', 'FM', 1, 159, 0, 1, '', 3026);
INSERT INTO 'album' VALUES (139, '1999-05-25 22:00:00+00', '2012-01-20 12:57:54.525748+00', 'Caledonian Ball, The - Vol 2', 'Cale Ball 2', 'PM', 1, 158, 0, 1, '', 3026);
INSERT INTO 'album' VALUES (141, '1999-06-24 22:00:00+00', '2012-01-20 12:57:54.541161+00', 'Come Scottish Country Dancing with the Great Jim MacLeod Band', 'JM - Come SCD', 'MK', 1, 268, 1979, 1, '', 3009);
INSERT INTO 'album' VALUES (142, '1999-01-23 23:00:00+00', '2012-01-20 12:57:54.547432+00', 'Dance Date No 4', 'Dance Date 4', 'BL', 1, 55, 0, 1, '', 3065);
INSERT INTO 'album' VALUES (143, '1999-05-25 22:00:00+00', '2012-01-20 12:57:54.553965+00', 'Come Scottish Country Dancing with Andrew Rankine', 'Come SCD w AR', 'RS', 1, 329, 1976, 1, '', 3042);
INSERT INTO 'album' VALUES (144, '2002-05-23 22:00:00+00', '2012-01-20 12:57:54.563295+00', 'Come Scottish Country Dancing with Robert Whitehead', 'Come SCD w RW', 'BL', 1, 455, 1979, 1, '', 3039);
INSERT INTO 'album' VALUES (145, '1998-11-03 23:00:00+00', '2012-01-20 12:57:54.569558+00', 'Something Else', 'Something Else', 'CG', 1, 338, 1990, 1, '', 2414);
INSERT INTO 'album' VALUES (147, '2002-05-23 22:00:00+00', '2012-01-20 12:57:54.587618+00', 'Come Scottish Country Dancing with Robert Whitehead (2)', 'Come SCD w RW 2', 'EC', 1, 456, 1983, 1, '', 3039);
INSERT INTO 'album' VALUES (148, '1998-10-26 23:00:00+00', '2012-01-20 12:57:54.59381+00', 'Craigellachie in Oxford', 'Craig in Oxford', 'BC', 1, 69, 1992, 1, '', 3014);
INSERT INTO 'album' VALUES (149, '1998-12-01 23:00:00+00', '2012-01-20 12:57:54.600006+00', 'Dance Time', 'Dance Time', 'PM', 1, 336, 1976, 1, '', 2414);
INSERT INTO 'album' VALUES (150, '1998-10-06 22:00:00+00', '2012-01-20 12:57:54.606318+00', 'Dance to Bobby Crowe''s Band', 'Dance BCrowe', 'MC', 1, 86, 0, 1, 'Title of CD is <First Album>', 3018);
INSERT INTO 'album' VALUES (151, '1999-01-22 23:00:00+00', '2012-01-20 12:57:54.615286+00', 'Dram o'' Scotch, A', 'Dram o'' Scotch', 'BL', 1, 358, 0, 1, '', 3061);
INSERT INTO 'album' VALUES (153, '1998-09-20 22:00:00+00', '2012-01-20 12:57:54.624915+00', 'Dances Old, Dances New', 'Dances Old', 'GS', 1, 318, 1983, 1, '', 3024);
INSERT INTO 'album' VALUES (155, '1998-12-29 23:00:00+00', '2012-01-20 12:57:54.637353+00', 'Dances of Scotland Volume 1', 'D of Scotland 1', 'PM', 1, 8, 1986, 1, '', 2032);
INSERT INTO 'album' VALUES (156, '1998-10-05 22:00:00+00', '2012-01-20 12:57:54.643713+00', 'Dances of Scotland', 'D of Scotland', 'MC', 1, 98, 1975, 1, '', 3006);
INSERT INTO 'album' VALUES (157, '2001-11-19 23:00:00+00', '2012-01-20 12:57:54.649924+00', 'Sound of Feolin', 'Feolin', 'AP', 1, 176, 1998, 1, '', 1396);
INSERT INTO 'album' VALUES (158, '1998-12-04 23:00:00+00', '2012-01-20 12:57:54.656136+00', 'Dances of Scotland Volume 2', 'D of Scotland 2', 'AH', 1, 417, 1973, 1, '', 3016);
INSERT INTO 'album' VALUES (159, '1998-07-16 22:00:00+00', '2012-01-20 12:57:54.662298+00', 'Dancin'' Music', 'Dancin'' Music', 'PM', 1, 390, 1988, 1, '', 2068);
INSERT INTO 'album' VALUES (161, '1999-10-05 22:00:00+00', '2012-01-20 12:57:54.67508+00', 'Dancing Strings of Scotland', 'Dancing Strings', 'IS', 1, 101, 1989, 1, '', 2069);
INSERT INTO 'album' VALUES (162, '1998-01-26 23:00:00+00', '2012-01-20 12:57:54.684522+00', 'Dancing Throu'' Scotland', 'Dancing / Scot', '', 0, 418, 0, 1, '', 3016);
INSERT INTO 'album' VALUES (163, '1998-07-16 22:00:00+00', '2012-01-20 12:57:54.687986+00', 'Dancing Through Scotland', 'Dancing / Scot (JS)', 'BL', 1, 364, 1972, 1, '', 3010);
INSERT INTO 'album' VALUES (169, '1998-11-30 23:00:00+00', '2012-01-20 12:57:54.731636+00', 'Encore', 'Encore', 'PM', 1, 70, 1989, 1, '', 3014);
INSERT INTO 'album' VALUES (171, '1998-07-16 22:00:00+00', '2012-01-20 12:57:54.749919+00', 'Favourite Scottish Dance Music Vol. 1', 'Favourite SDM 1', 'MC', 1, 30, 1971, 1, '', 2039);
INSERT INTO 'album' VALUES (140, '1998-07-22 22:00:00+00', '2012-10-02 14:58:09.719198+00', 'Caller Herrin'' and seven other SCD/Foss', 'Caller Herrin', 'WT', 1, 448, 2011, 1, '', 2067);
INSERT INTO 'album' VALUES (160, '2001-06-07 22:00:00+00', '2012-10-10 13:29:56.009311+00', 'Dancing Fingers', 'Fingers', 'AP', 1, 216, 1988, 1, '', 1502);
INSERT INTO 'album' VALUES (165, '2000-02-27 23:00:00+00', '2012-10-11 18:02:43.265348+00', 'Play Favourites', 'Play Favourites', 'JW', 1, 17, 1979, 1, '2 CDs - In Triumph & Play Favourites', 2033);
INSERT INTO 'album' VALUES (166, '1999-05-25 22:00:00+00', '2012-10-11 18:03:13.556373+00', 'In Triumph', 'In Triumph', 'DS', 1, 16, 1978, 1, '2 CDs - In Triumph & Play Favourites', 2033);
INSERT INTO 'album' VALUES (105, '1998-11-17 23:00:00+00', '2013-04-10 06:28:13.583265+00', 'Book 7.', 'RSCDS 7', 'PM', 1, 132, 1987, 1, '', 3020);
INSERT INTO 'album' VALUES (106, '1998-11-20 23:00:00+00', '2013-04-10 06:28:54.209486+00', 'Book 8.', 'RSCDS 8', 'PM', 1, 266, 1987, 1, '', 3009);
INSERT INTO 'album' VALUES (122, '1999-05-25 22:00:00+00', '2013-04-10 09:18:02.592294+00', 'Nine Scottish Country Dances (1981) - Leaflets', '9 SCD Leaflets', 'MK', 1, 331, 1981, 1, '', 3042);
INSERT INTO 'album' VALUES (170, '1998-12-01 23:00:00+00', '2014-05-13 10:32:32.34805+00', 'Farewell to the Tay (CD: Early Days)', 'Farewell Tay', 'PM', 1, 22, 2005, 1, '', 2036);
INSERT INTO 'album' VALUES (174, '1998-11-09 23:00:00+00', '2012-01-20 12:57:54.767361+00', 'Gateway to the Forth', 'Gateway', 'BL', 1, 366, 1967, 1, '', 3010);
INSERT INTO 'album' VALUES (1109, '2018-03-18 08:51:00.860112+00', '2018-03-31 11:42:04.687986+00', 'Traditionally Inspired', '', '', 0, 1, 2014, 1, '', 11611);
INSERT INTO 'album' VALUES (176, '2002-04-08 22:00:00+00', '2012-01-20 12:57:54.779932+00', 'Grandfather Mountain Gala', 'G''ather Mount', 'EC', 1, 39, 1986, 1, '', 3067);
INSERT INTO 'album' VALUES (178, '1999-06-30 22:00:00+00', '2012-01-20 12:57:54.795295+00', 'Australian Ladies', 'Aust Ladies', 'BC', 1, 184, 1983, 1, '', 2055);
INSERT INTO 'album' VALUES (179, '1999-05-25 22:00:00+00', '2012-01-20 12:57:54.801539+00', 'Heather and Yon', 'Heather / Yon', 'MH', 1, 20, 1978, 1, '', 2035);
INSERT INTO 'album' VALUES (180, '1998-10-06 22:00:00+00', '2012-01-20 12:57:54.807725+00', 'Hey Johnnie Cope and seven other SCD/Foss', 'Johnnie Cope', 'MH', 1, 451, 0, 1, '', 2067);
INSERT INTO 'album' VALUES (181, '1999-04-20 22:00:00+00', '2012-01-20 12:57:54.813994+00', 'Highland Party', 'Highland Party', 'PM', 1, 25, 0, 1, '', 2038);
INSERT INTO 'album' VALUES (182, '1998-10-27 23:00:00+00', '2012-01-20 12:57:54.820179+00', 'Honour the Piper', 'Honour Piper', 'RS', 1, 63, 1967, 1, '', 1556);
INSERT INTO 'album' VALUES (917, '2009-11-22 23:00:00+00', '2012-01-20 12:57:58.076252+00', 'Tarry A While', 'Tarry A While', '', 0, 0, 2006, 0, '', 3032);
INSERT INTO 'album' VALUES (177, '1998-09-19 22:00:00+00', '2022-08-23 22:13:19.648441+00', 'H.I.S.C.D.', 'H.I.S.C.D.', 'EC', 1, 34, 0, 1, '', 2040);
INSERT INTO 'album' VALUES (183, '1998-10-25 23:00:00+00', '2012-01-20 12:57:54.829168+00', 'Ian Powrie''s Farewell to Scotland', 'IP''s Farewell', 'EN', 1, 326, 1967, 1, '', 2062);
INSERT INTO 'album' VALUES (184, '1998-10-06 22:00:00+00', '2012-01-20 12:57:54.835456+00', 'Ian Reid and his Scottish Dance Band', 'I Reid and SDB', 'MH', 1, 341, 0, 1, '', 2060);
INSERT INTO 'album' VALUES (185, '1999-01-10 23:00:00+00', '2012-01-20 12:57:54.841685+00', 'Invitation to a Scottish Dance', 'Invitation', 'EC', 1, 256, 0, 1, '', 2057);
INSERT INTO 'album' VALUES (123, '1998-10-26 23:00:00+00', '2023-08-28 11:18:20.322029+00', 'Music for Ten Scottish Country Dances', '10 SCD (Crowe)', 'AP', 1, 88, 1978, 1, '', 3018);
INSERT INTO 'album' VALUES (168, '1998-05-17 22:00:00+00', '2023-08-28 11:34:22.404047+00', 'Tartan Capers', 'Tartan Capers', 'AP', 1, 445, 1997, 1, '', 2042);
INSERT INTO 'album' VALUES (152, '1998-12-01 23:00:00+00', '2025-03-24 12:07:52.231132+00', 'Dances Frae the North Vols. 1 & 2', 'Frae N 1 & 2', '', 0, 415, 0, 1, '', 3016);
INSERT INTO 'album' VALUES (146, '1998-09-02 22:00:00+00', '2025-06-29 08:00:17.130243+00', 'From Scotia''s Shores We''re Noo Awa''', 'Scotia''s Shores', 'AP', 1, 38, 1996, 1, '', 3067);
INSERT INTO 'album' VALUES (188, '1998-10-19 22:00:00+00', '2012-01-20 12:57:54.860825+00', 'King of the Melodeon Men', 'Melodeon', 'JW', 1, 371, 1994, 1, '', 3010);
INSERT INTO 'album' VALUES (189, '1998-10-11 22:00:00+00', '2012-01-20 12:57:54.867074+00', 'Reel Kick, A', 'Reel Kick', 'RC', 1, 122, 1982, 1, '', 3056);
INSERT INTO 'album' VALUES (190, '1999-01-11 23:00:00+00', '2012-01-20 12:57:54.876171+00', 'Kelpie Magic', 'Kelpie', '', 0, 424, 0, 1, '', 3016);
INSERT INTO 'album' VALUES (191, '1998-11-23 23:00:00+00', '2012-01-20 12:57:54.879536+00', 'Lad o'' Kyle, The', 'Lad o'' Kyle', 'PM', 1, 155, 1986, 1, '', 3044);
INSERT INTO 'album' VALUES (193, '1998-10-28 23:00:00+00', '2012-01-20 12:57:54.891998+00', 'Legends of Scotland - Best of Ian Powrie Band', 'Legends', 'RS', 1, 327, 1967, 1, '', 2062);
INSERT INTO 'album' VALUES (194, '1998-10-06 22:00:00+00', '2012-01-20 12:57:54.901163+00', 'Let''s Dance in Strict Tempo', 'Strict Tempo', 'MC', 1, 188, 1979, 1, '', 3051);
INSERT INTO 'album' VALUES (195, '1998-10-06 22:00:00+00', '2012-01-20 12:57:54.910305+00', 'London Highland Club Diamond Jubilee', 'London Highland', 'EC', 1, 330, 1984, 1, '', 3042);
INSERT INTO 'album' VALUES (196, '1999-08-04 22:00:00+00', '2012-01-20 12:57:54.919616+00', 'Looking For a Partner', 'Look Part (1)', 'CG', 1, 113, 1978, 1, '', 1815);
INSERT INTO 'album' VALUES (199, '1998-12-19 23:00:00+00', '2012-01-20 12:57:54.944333+00', 'Any Good Dance, Any Good Tune', 'Any Good Dance', 'FC', 1, 35, 1998, 1, '', 3067);
INSERT INTO 'album' VALUES (200, '1998-10-19 22:00:00+00', '2012-01-20 12:57:54.951001+00', 'Jig for Joy', 'Jig for Joy', 'AP', 1, 307, 1998, 1, '', 3030);
INSERT INTO 'album' VALUES (201, '1999-02-01 23:00:00+00', '2012-01-20 12:57:54.957319+00', 'Scottish Country Dances (Vol. 2)', 'SCD 2 (AM)', 'PM', 1, 292, 1979, 1, '', 3001);
INSERT INTO 'album' VALUES (202, '1998-10-13 22:00:00+00', '2012-01-20 12:57:54.963853+00', 'Music for Scottish Country Dancing', 'Music for SCD', 'RM', 1, 11, 1971, 1, '', 2034);
INSERT INTO 'album' VALUES (204, '1998-10-20 22:00:00+00', '2012-01-20 12:57:54.976655+00', 'Northern Jubilee', 'Northern Jub', 'PM', 1, 137, 1982, 1, '', 2046);
INSERT INTO 'album' VALUES (205, '1998-10-06 22:00:00+00', '2012-01-20 12:57:54.982932+00', 'Presenting the Lothian Scottish Dance Band', 'Present Lothian', 'EC', 1, 250, 1977, 1, '', 3040);
INSERT INTO 'album' VALUES (207, '1999-05-25 22:00:00+00', '2012-01-20 12:57:54.998297+00', 'Caledonian Ball, The - Vol 4', 'Cale Ball 4', 'PM', 1, 160, 0, 1, '', 3026);
INSERT INTO 'album' VALUES (197, '1998-10-06 22:00:00+00', '2012-03-06 12:51:08.917574+00', 'MacGregor''s Gathering', 'Gathering', 'MC', 1, 257, 0, 1, '', 2057);
INSERT INTO 'album' VALUES (209, '1998-12-06 23:00:00+00', '2012-01-20 12:57:55.010765+00', 'San Francisco Collection Vol 2', 'San Francisco 2', 'PM', 1, 427, 1997, 1, '', 3016);
INSERT INTO 'album' VALUES (211, '1998-10-28 23:00:00+00', '2012-01-20 12:57:55.02323+00', 'Footnotes', 'Footnotes', 'PM', 1, 316, 1992, 1, '', 2088);
INSERT INTO 'album' VALUES (212, '1998-09-13 22:00:00+00', '2012-01-20 12:57:55.029438+00', 'Scottish Band Showcase', 'Showcase', 'OO', 1, 429, 1976, 1, '', 3016);
INSERT INTO 'album' VALUES (213, '1998-10-27 23:00:00+00', '2012-01-20 12:57:55.035699+00', 'Capital Reels', 'Capital Reels', 'AT', 1, 9, 1995, 1, '', 2090);
INSERT INTO 'album' VALUES (215, '1998-10-27 23:00:00+00', '2012-01-20 12:57:55.050954+00', 'Scottish Country Dances for Children', 'SCD Children', 'RS', 1, 221, 1983, 1, '', 1502);
INSERT INTO 'album' VALUES (216, '1998-10-26 23:00:00+00', '2012-01-20 12:57:55.05724+00', 'Scottish Dance Masters, The Vol 1', 'SD Masters 1', 'BC', 1, 153, 1982, 1, '', 2252);
INSERT INTO 'album' VALUES (217, '1998-12-19 23:00:00+00', '2012-01-20 12:57:55.063439+00', 'Virtuoso Piper of Scotland', 'Virtuoso Piper', 'BC', 1, 64, 1987, 1, '', 1556);
INSERT INTO 'album' VALUES (218, '1998-10-26 23:00:00+00', '2012-01-20 12:57:55.069629+00', 'Scottish Dance Masters, The Vol 3', 'SD Masters 3', 'BC', 1, 150, 0, 1, '', 2231);
INSERT INTO 'album' VALUES (219, '1998-10-27 23:00:00+00', '2012-01-20 12:57:55.075823+00', 'Scottish Dance Masters, The Vol 4', 'SD Masters 4', 'RS', 1, 149, 1988, 1, '', 2398);
INSERT INTO 'album' VALUES (220, '1998-10-22 22:00:00+00', '2012-01-20 12:57:55.082107+00', 'Scottish Dance Time Vol 1', 'Dance Time 1', 'IM', 1, 179, 0, 1, '', 2053);
INSERT INTO 'album' VALUES (221, '2000-11-13 23:00:00+00', '2012-01-20 12:57:55.088304+00', 'Scottish Dance Time Vol 2', 'Dance Time 2', 'CG', 1, 180, 0, 1, '', 2053);
INSERT INTO 'album' VALUES (222, '1998-10-27 23:00:00+00', '2012-01-20 12:57:55.094478+00', 'Scottish Dance Time Vol 3', 'Dance Time 3', 'RS', 1, 181, 0, 1, '', 2053);
INSERT INTO 'album' VALUES (223, '1998-10-25 23:00:00+00', '2012-01-20 12:57:55.100748+00', 'Scottish Dance Time Vol 4', 'Dance Time 4', 'CG', 1, 182, 0, 1, '', 2053);
INSERT INTO 'album' VALUES (224, '1998-10-25 23:00:00+00', '2012-01-20 12:57:55.106923+00', 'Scottish Dance Time Vol 5', 'Dance Time 5', 'CG', 1, 183, 1970, 1, '', 2053);
INSERT INTO 'album' VALUES (225, '1999-05-25 22:00:00+00', '2012-01-20 12:57:55.113106+00', 'Scottish Dance Favourites', 'SD Favourites', 'AP', 1, 275, 0, 1, '', 3009);
INSERT INTO 'album' VALUES (226, '1998-10-29 23:00:00+00', '2012-01-20 12:57:55.122144+00', 'Scottish Jigs and Reels for Children', 'J & R / Child', 'PM', 1, 127, 0, 1, '', 2045);
INSERT INTO 'album' VALUES (227, '1998-10-11 22:00:00+00', '2012-01-20 12:57:55.128355+00', 'Scottish Welcome, A', 'Sco Welcome', 'RC', 1, 212, 1975, 1, '', 3037);
INSERT INTO 'album' VALUES (228, '1998-11-22 23:00:00+00', '2012-01-20 12:57:55.137368+00', 'Second Celebration', 'Second Celeb', 'BC', 1, 251, 1986, 1, '', 3040);
INSERT INTO 'album' VALUES (230, '1999-05-25 22:00:00+00', '2012-01-20 12:57:55.150727+00', 'Something to Celebrate', 'Something to C', 'BC', 1, 252, 0, 1, '', 3040);
INSERT INTO 'album' VALUES (232, '1999-07-26 22:00:00+00', '2012-01-20 12:57:55.166352+00', 'Saint Andrews'' Branch Golden Jubilee 37-87', 'Gold Jub 37-87', 'GS', 1, 95, 1987, 1, '', 2044);
INSERT INTO 'album' VALUES (235, '1999-01-22 23:00:00+00', '2012-01-20 12:57:55.193956+00', 'Teachers Certificate Examination (1990)', 'Tchrs Cert (90)', 'RS', 1, 223, 1990, 1, '', 1502);
INSERT INTO 'album' VALUES (237, '1998-10-28 23:00:00+00', '2012-01-20 12:57:55.211202+00', 'Canadian West Coast Sound, The', 'West Coast', 'AP', 1, 347, 1982, 1, '', 883);
INSERT INTO 'album' VALUES (239, '1998-10-06 22:00:00+00', '2012-01-20 12:57:55.227947+00', 'Scottish Sound of the Bill Hendry Band, The', 'Scottish Sound', 'MH', 1, 187, 0, 1, '', 10277);
INSERT INTO 'album' VALUES (240, '1998-11-30 23:00:00+00', '2012-01-20 12:57:55.236077+00', 'Shepherd''s Choice, The', 'Shepherd', 'PM', 1, 24, 0, 1, '', 2037);
INSERT INTO 'album' VALUES (241, '1999-10-05 22:00:00+00', '2012-01-20 12:57:55.243477+00', 'Vancouver Collection of Scottish Music, The', 'Vancouver', 'PM', 1, 348, 1978, 1, '', 883);
INSERT INTO 'album' VALUES (242, '1998-10-27 23:00:00+00', '2012-01-20 12:57:55.252514+00', 'White Cockade, The', 'White Cockade', 'RS', 1, 447, 1991, 1, '', 2042);
INSERT INTO 'album' VALUES (210, '1998-09-20 22:00:00+00', '2013-02-15 17:59:07.564112+00', 'Scotland''s Fancy', 'Scot Fancy', 'GS', 1, 142, 0, 1, '', 2048);
INSERT INTO 'album' VALUES (244, '1998-12-20 23:00:00+00', '2012-01-20 12:57:55.264935+00', 'Eighteen of the Best', '18 Best', 'BC', 1, 419, 1989, 1, '', 3016);
INSERT INTO 'album' VALUES (246, '1998-10-05 22:00:00+00', '2012-01-20 12:57:55.277374+00', 'Westering Home', 'Westering Home', 'MC', 1, 334, 1976, 1, '', 3042);
INSERT INTO 'album' VALUES (247, '1998-10-22 22:00:00+00', '2012-01-20 12:57:55.283565+00', 'Jimmy''s Fancy', 'Jimmy''s Fancy', 'HW', 1, 370, 1961, 1, '', 3010);
INSERT INTO 'album' VALUES (248, '1998-10-13 22:00:00+00', '2012-01-20 12:57:55.289743+00', 'Scotland on Parade', 'Scot Parade', 'RM', 1, 4, 1975, 1, '', 1595);
INSERT INTO 'album' VALUES (250, '1998-10-06 22:00:00+00', '2012-01-20 12:57:55.302085+00', 'Gates of Edinburgh', 'Gates / Edin', 'MC', 1, 29, 0, 1, '', 2092);
INSERT INTO 'album' VALUES (251, '1998-10-06 22:00:00+00', '2012-01-20 12:57:55.308254+00', 'Favourite Scottish Dance Music Vol. 2', 'Favourite SDM 2', 'MC', 1, 31, 1972, 1, '', 2039);
INSERT INTO 'album' VALUES (252, '2000-07-30 22:00:00+00', '2012-01-20 12:57:55.314436+00', 'Lassie Come and Dance Wi'' Me', 'Lassie Come', 'BC', 1, 93, 1997, 1, '', 2188);
INSERT INTO 'album' VALUES (253, '1998-12-01 23:00:00+00', '2012-01-20 12:57:55.320606+00', 'Down South', 'Down South', 'PM', 1, 203, 1976, 1, '', 2303);
INSERT INTO 'album' VALUES (203, '1998-12-06 23:00:00+00', '2019-09-25 16:33:40.325579+00', 'None So Pretty', 'None So Pretty', 'BL', 1, 21, 1979, 1, '', 2035);
INSERT INTO 'album' VALUES (254, '1999-08-08 22:00:00+00', '2012-01-20 12:57:55.326845+00', 'Memories of Scottish Weekend', 'Memories', 'AP', 1, 1, 1999, 1, '', 2162);
INSERT INTO 'album' VALUES (255, '1999-01-23 23:00:00+00', '2012-01-20 12:57:55.333051+00', 'Fiddle', 'Fiddle', 'BL', 1, 57, 0, 1, '', 2094);
INSERT INTO 'album' VALUES (256, '1998-10-11 22:00:00+00', '2012-01-20 12:57:55.342971+00', 'Bow and Curtsy', 'Bow & Curtsy', 'EN', 1, 104, 0, 1, '', 2095);
INSERT INTO 'album' VALUES (257, '1998-12-19 23:00:00+00', '2012-01-20 12:57:55.351985+00', 'John Ellis', 'J Ellis & HCB', 'JW', 1, 121, 1968, 1, '', 3056);
INSERT INTO 'album' VALUES (233, '1999-03-09 23:00:00+00', '2020-06-17 22:35:46.591665+00', 'Steppin'' Out', 'Steppin'' Out', 'GS', 1, 399, 1988, 1, '', 2065);
INSERT INTO 'album' VALUES (260, '2001-11-19 23:00:00+00', '2012-01-20 12:57:55.37619+00', 'Portrait of a Scottish Fiddler', 'Portrait', 'AP', 1, 135, 0, 1, '', 1782);
INSERT INTO 'album' VALUES (234, '2000-11-17 23:00:00+00', '2023-03-19 12:00:16.411964+00', 'Teachers Certificate Examination (1983)', 'Teachers Cert', 'OO', 1, 222, 1983, 1, '', 1502);
INSERT INTO 'album' VALUES (262, '1998-12-01 23:00:00+00', '2012-01-20 12:57:55.388626+00', 'Golden Fiddle Awards', 'Golden Fiddle', 'M', 1, 147, 1976, 1, '', 2098);
INSERT INTO 'album' VALUES (263, '1999-10-09 22:00:00+00', '2012-01-20 12:57:55.394836+00', 'Kilt is my Delight, The', 'Kilt is Delight', 'PM', 1, 165, 1971, 1, '', 3026);
INSERT INTO 'album' VALUES (264, '1998-10-11 22:00:00+00', '2012-01-20 12:57:55.401031+00', 'Scotch Mist', 'Scotch Mist', 'EN', 1, 169, 0, 1, '', 3026);
INSERT INTO 'album' VALUES (265, '1999-05-25 22:00:00+00', '2012-01-20 12:57:55.4072+00', 'Scottish Dance Party Vol 1', 'SD Party 1', '', 0, 170, 0, 1, '', 3026);
INSERT INTO 'album' VALUES (266, '1999-05-25 22:00:00+00', '2012-01-20 12:57:55.413376+00', 'Scottish Dance Party Vol 2', 'SD Party 2', '', 0, 171, 0, 1, '', 3026);
INSERT INTO 'album' VALUES (267, '1998-11-14 23:00:00+00', '2012-01-20 12:57:55.419544+00', 'Elma''s Tunes', 'Elma''s Tunes', 'DS', 1, 173, 0, 1, '', 2124);
INSERT INTO 'album' VALUES (258, '1998-11-14 23:00:00+00', '2023-08-28 11:34:50.216736+00', 'Tartan Stew', 'Tartan Stew', 'DS', 1, 446, 1993, 1, '', 2042);
INSERT INTO 'album' VALUES (238, '2000-03-16 23:00:00+00', '2024-10-15 22:05:31.682641+00', 'Scotch Piano, The', 'Scotch Piano', 'EC', 1, 178, 1969, 1, '', 2054);
INSERT INTO 'album' VALUES (206, '2001-12-11 23:00:00+00', '2025-06-29 08:03:01.362362+00', 'Ready...And!', 'Ready...And!', 'FM', 1, 43, 1985, 1, '', 3067);
INSERT INTO 'album' VALUES (270, '1998-10-11 22:00:00+00', '2012-01-20 12:57:55.438074+00', 'Come Dance With Me', 'Come Dance', 'RC', 1, 207, 1977, 1, '', 3037);
INSERT INTO 'album' VALUES (271, '1999-06-24 22:00:00+00', '2012-01-20 12:57:55.447399+00', 'Favourite Tunes - Favourite Dances', 'Favourite Tunes', 'M', 1, 209, 1983, 1, '', 3037);
INSERT INTO 'album' VALUES (272, '1998-09-19 22:00:00+00', '2012-01-20 12:57:55.455524+00', 'Preliminary Test', 'Prelim Test', 'OO', 1, 220, 1983, 1, '', 1502);
INSERT INTO 'album' VALUES (273, '1999-01-23 23:00:00+00', '2012-01-20 12:57:55.463644+00', 'Complete Scottish Dance Master No. 1, The', 'SD Master 1', 'JW', 1, 263, 1963, 1, '', 2328);
INSERT INTO 'album' VALUES (274, '1998-10-14 22:00:00+00', '2012-01-20 12:57:55.471929+00', 'Scottish Dance-Along', 'Dance-Along', 'RM', 1, 265, 1972, 1, '', 2328);
INSERT INTO 'album' VALUES (275, '1999-06-24 22:00:00+00', '2012-01-20 12:57:55.480096+00', 'Keep on Scottish Country Dancing with...', 'Keep on SD', 'MH', 1, 272, 0, 1, '', 3009);
INSERT INTO 'album' VALUES (277, '1999-01-23 23:00:00+00', '2012-01-20 12:57:55.497005+00', 'Salute t'' Scottish Dancing', 'Salute', 'JW', 1, 285, 1976, 1, '', 3008);
INSERT INTO 'album' VALUES (278, '1998-10-06 22:00:00+00', '2012-01-20 12:57:55.505363+00', 'Scottish Country Dance', 'Scottish CD', 'MC', 1, 253, 0, 1, '', 1549);
INSERT INTO 'album' VALUES (279, '1998-12-01 23:00:00+00', '2012-01-20 12:57:55.513742+00', 'Country Dance Style', 'Dance Style', 'M', 1, 255, 0, 1, '', 2057);
INSERT INTO 'album' VALUES (249, '1998-10-14 22:00:00+00', '2012-04-22 17:59:45.075179+00', 'Scottish Dances', 'Scottish Dances', 'RM', 1, 28, 1958, 1, '', 2038);
INSERT INTO 'album' VALUES (280, '1998-10-17 22:00:00+00', '2012-01-20 12:57:55.522069+00', 'Scottish Country Dance Music', 'SCD MacKinnon', 'MC', 1, 258, 0, 1, '', 2356);
INSERT INTO 'album' VALUES (282, '1998-11-15 23:00:00+00', '2012-01-20 12:57:55.538595+00', 'Guid Luck Go Wi'' Ye', 'Guid Luck', 'JW', 1, 367, 1968, 1, '', 3010);
INSERT INTO 'album' VALUES (283, '1998-10-19 22:00:00+00', '2012-01-20 12:57:55.550559+00', 'Scottish Dance Party', 'SD Party', 'OO', 1, 333, 1969, 1, '', 3042);
INSERT INTO 'album' VALUES (284, '1998-11-09 23:00:00+00', '2012-01-20 12:57:55.55886+00', 'Scottish Country Dances Volume 2', 'SCDances 2', 'AT', 0, 27, 0, 1, '', 2038);
INSERT INTO 'album' VALUES (285, '1998-10-27 23:00:00+00', '2012-01-20 12:57:55.567075+00', 'Step We Gaily', 'Step We Gaily', 'RS', 1, 384, 1960, 1, '', 3010);
INSERT INTO 'album' VALUES (286, '1998-09-20 22:00:00+00', '2012-01-20 12:57:55.579043+00', 'Step in Time', 'Step in Time', 'DM', 1, 90, 0, 1, '', 3018);
INSERT INTO 'album' VALUES (287, '1998-10-06 22:00:00+00', '2012-01-20 12:57:55.587146+00', 'Music for Scottish Country Dancing', 'Music SCD (BB)', 'IS', 1, 42, 1978, 1, '', 3067);
INSERT INTO 'album' VALUES (289, '1999-01-23 23:00:00+00', '2012-01-20 12:57:55.604614+00', 'Back Hame Tae Auchtermuchty', 'Back Hame', 'BL', 1, 362, 1965, 1, '', 3010);
INSERT INTO 'album' VALUES (290, '1998-12-29 23:00:00+00', '2012-01-20 12:57:55.612777+00', 'Jigtime', 'Jigtime', 'PM', 1, 368, 1970, 1, '', 3010);
INSERT INTO 'album' VALUES (291, '1998-12-19 23:00:00+00', '2012-01-20 12:57:55.621197+00', 'Magic Sounds of Jimmy Shand and His Band, The', 'Magic Sounds', 'MK', 1, 374, 1983, 1, '', 3010);
INSERT INTO 'album' VALUES (292, '1998-10-06 22:00:00+00', '2012-01-20 12:57:55.629316+00', 'My Scotland', 'My Scotland', 'RM', 1, 375, 0, 1, '', 3010);
INSERT INTO 'album' VALUES (294, '1998-10-18 22:00:00+00', '2012-01-20 12:57:55.649581+00', 'Seven Favourite Dances #4', '7 Favourite 4', 'EE', 1, 396, 2011, 1, '', 1456);
INSERT INTO 'album' VALUES (295, '1998-10-11 22:00:00+00', '2012-01-20 12:57:55.661528+00', 'Garple Burn and 7 other SCD by Hugh Foss', 'Garple Burn', 'RC', 1, 450, 0, 1, '', 2067);
INSERT INTO 'album' VALUES (296, '1999-01-13 23:00:00+00', '2012-01-20 12:57:55.669726+00', 'Scottish Gems', 'Scottish Gems', 'M', 1, 185, 1970, 1, '', 2131);
INSERT INTO 'album' VALUES (297, '1999-04-19 22:00:00+00', '2012-01-20 12:57:55.677983+00', 'Scotland''s Own Jimmy Shand', 'Scotland''s Own', 'IS', 1, 378, 1985, 1, '', 3010);
INSERT INTO 'album' VALUES (298, '1998-12-01 23:00:00+00', '2012-01-20 12:57:55.689936+00', 'Stalking the Wild Bagpipe', 'Stalking', 'M', 1, 409, 1981, 1, '', 2468);
INSERT INTO 'album' VALUES (300, '1998-10-05 22:00:00+00', '2012-01-20 12:57:55.706315+00', 'Salute to Scotland, A', 'Salute (BB)', 'RM', 1, 44, 0, 1, '', 3067);
INSERT INTO 'album' VALUES (301, '1998-10-14 22:00:00+00', '2012-01-20 12:57:55.71514+00', 'Fire in the Kilt', 'Fire/Kilt', 'FM', 1, 119, 1987, 1, '', 3056);
INSERT INTO 'album' VALUES (302, '1998-11-03 23:00:00+00', '2012-01-20 12:57:55.727658+00', 'On Stage With..., Volume 3', 'On Stage 3', 'CG', 1, 403, 1987, 1, '', 2133);
INSERT INTO 'album' VALUES (304, '1999-06-24 22:00:00+00', '2012-01-20 12:57:55.752176+00', 'Sound of Scotland, The', 'Sound / Scotland', 'EN', 1, 278, 0, 1, '', 3009);
INSERT INTO 'album' VALUES (305, '1998-11-14 23:00:00+00', '2012-01-20 12:57:55.760719+00', 'Broadswords', 'Broadswords', 'DS', 1, 62, 0, 1, '', 1556);
INSERT INTO 'album' VALUES (306, '1998-12-01 23:00:00+00', '2012-01-20 12:57:55.769191+00', 'Fiddle Volume 2', 'Fiddle 2', 'M', 1, 58, 0, 1, '', 2094);
INSERT INTO 'album' VALUES (307, '1998-05-11 22:00:00+00', '2012-01-20 12:57:55.781088+00', 'South of the Grampians', 'Grampians', '', 0, 115, 0, 1, '', 2173);
INSERT INTO 'album' VALUES (308, '1998-12-29 23:00:00+00', '2012-01-20 12:57:55.789219+00', 'Scottish Choice, A', 'Scottish Choice', 'PB', 1, 431, 1974, 1, '', 3016);
INSERT INTO 'album' VALUES (309, '1998-09-16 22:00:00+00', '2012-01-20 12:57:55.797337+00', 'Sound of the North', 'Sound / North', 'GS', 1, 458, 1970, 1, '', 3063);
INSERT INTO 'album' VALUES (310, '1999-05-25 22:00:00+00', '2012-01-20 12:57:55.80545+00', 'It''s Just for Fun', 'Just for Fun 1', 'AP', 1, 6, 1986, 1, '', 2171);
INSERT INTO 'album' VALUES (311, '1999-01-09 23:00:00+00', '2012-01-20 12:57:55.817403+00', 'In Top Gear', 'In Top Gear', 'AP', 1, 356, 0, 1, '', 3050);
INSERT INTO 'album' VALUES (312, '1999-02-22 23:00:00+00', '2012-01-20 12:57:55.825506+00', 'From Manse to Danse', 'Manse to Danse', 'AP', 1, 387, 0, 1, '', 3060);
INSERT INTO 'album' VALUES (314, '1998-11-23 23:00:00+00', '2012-01-20 12:57:55.845443+00', 'Hold The Lass Til I Get At Her', 'Hold The Lass', 'BC', 1, 323, 1989, 1, '', 2136);
INSERT INTO 'album' VALUES (318, '2000-04-04 22:00:00+00', '2013-04-10 09:58:48.294722+00', 'Highlander Music Scottish Dances Vol 7', 'Highlander SD 7', 'AP', 1, 139, 1999, 1, '', 3036);
INSERT INTO 'album' VALUES (269, '1998-11-15 23:00:00+00', '2014-08-05 16:47:16.393109+00', 'Measure of Scotch, A', 'Measure', 'JW', 1, 211, 1971, 1, '', 3037);
INSERT INTO 'album' VALUES (288, '1999-05-25 22:00:00+00', '2014-10-19 15:39:53.896825+00', 'Dances of Scotland Volume 1', 'Dances 1', 'GS', 1, 7, 1966, 1, '', 2032);
INSERT INTO 'album' VALUES (320, '2000-07-05 22:00:00+00', '2012-01-20 12:57:55.898265+00', 'Valley Gold', 'Valley Gold', 'AP', 1, 186, 0, 1, '', 2583);
INSERT INTO 'album' VALUES (321, '1998-11-30 23:00:00+00', '2012-01-20 12:57:55.906383+00', 'Scottish Dance Party', 'SD Party (JM)', 'HW', 1, 276, 1965, 1, '', 3009);
INSERT INTO 'album' VALUES (324, '1998-09-08 22:00:00+00', '2012-01-20 12:57:55.931151+00', 'On Track', 'On Track', 'AP', 1, 393, 1998, 1, '', 3003);
INSERT INTO 'album' VALUES (325, '1999-10-18 22:00:00+00', '2012-01-20 12:57:55.939387+00', 'Highlander Music Scottish Dances Vol 10', 'Highlander SD10', 'AP', 1, 248, 1999, 1, '', 3040);
INSERT INTO 'album' VALUES (327, '1998-11-30 23:00:00+00', '2012-01-20 12:57:55.955837+00', 'Swing Your Partners', 'Swing', 'BC', 1, 397, 1987, 1, '', 3029);
INSERT INTO 'album' VALUES (328, '1999-06-10 22:00:00+00', '2012-01-20 12:57:55.963972+00', 'Cairngorms', 'Cairngorms', 'AP', 1, 215, 1999, 1, '', 2586);
INSERT INTO 'album' VALUES (329, '1998-11-30 23:00:00+00', '2012-01-20 12:57:55.972136+00', 'Ken and Friends', 'Ken and Friends', 'BC', 1, 389, 1975, 1, '', 1734);
INSERT INTO 'album' VALUES (268, '1999-09-27 22:00:00+00', '2018-07-31 14:11:36.673289+00', '12 Scottish Country Dances', '12 SCD Johnston', 'MC', 1, 205, 0, 1, '', 1701);
INSERT INTO 'album' VALUES (331, '1999-05-25 22:00:00+00', '2012-01-20 12:57:55.992185+00', 'Mooiste Muziek uit Schotland, De', 'Mooiste Muz (1)', '', 0, 314, 1990, 1, '', 2592);
INSERT INTO 'album' VALUES (332, '1999-04-19 22:00:00+00', '2012-01-20 12:57:56.00407+00', 'Calum Wilson & his Scottish Country Dance Band', 'Wilson & SCDB', 'EN', 1, 459, 1980, 1, '', 3055);
INSERT INTO 'album' VALUES (334, '1998-12-01 23:00:00+00', '2012-01-20 12:57:56.024369+00', 'Swan River Selection', 'Swan River', 'BC', 1, 353, 0, 1, '', 2462);
INSERT INTO 'album' VALUES (335, '1999-06-30 22:00:00+00', '2012-01-20 12:57:56.032856+00', 'Alastair Hunter and his Caledonian Ceilidh Band', 'AH & Ceilidh B', 'EN', 1, 194, 0, 1, '', 2596);
INSERT INTO 'album' VALUES (336, '1999-05-26 22:00:00+00', '2012-01-20 12:57:56.041907+00', 'Mooiste Muziek uit Schotland, Deel 2, De', 'Mooiste Muz (2)', 'WT', 1, 166, 0, 1, '', 3026);
INSERT INTO 'album' VALUES (337, '1999-06-24 22:00:00+00', '2012-01-20 12:57:56.050391+00', 'Scottish Country Dances in Strict Tempo (No. 2)', 'Strict Tempo 2', 'IM', 1, 380, 0, 1, '', 3010);
INSERT INTO 'album' VALUES (330, '1999-06-10 22:00:00+00', '2022-12-09 10:41:32.671948+00', 'Strictly Scottish Volume Two', 'Strictly Scot 2', '', 0, 454, 0, 1, '', 3039);
INSERT INTO 'album' VALUES (338, '1999-06-24 22:00:00+00', '2012-01-20 12:57:56.059228+00', 'Comin'' Thro'' the Rye', 'Thro'' the Rye', 'IM', 1, 363, 0, 1, '', 3010);
INSERT INTO 'album' VALUES (339, '1999-06-24 22:00:00+00', '2012-01-20 12:57:56.067594+00', 'Scottish Dance Programme', 'SD Progr.', '', 0, 279, 0, 1, '', 2611);
INSERT INTO 'album' VALUES (340, '1998-11-11 23:00:00+00', '2012-01-20 12:57:56.076262+00', 'Tunes from The Newcastle Collection', 'Newcastle', 'JW', 1, 441, 1974, 1, '', 3016);
INSERT INTO 'album' VALUES (341, '1999-06-24 22:00:00+00', '2012-01-20 12:57:56.084683+00', 'Scottish Dance Programme Vol. 2', 'SD Progr. 2', 'IM', 1, 280, 0, 1, '', 2611);
INSERT INTO 'album' VALUES (342, '1999-06-24 22:00:00+00', '2012-01-20 12:57:56.093282+00', 'On With The Dance', 'On With', 'IM', 0, 47, 0, 1, '', 2182);
INSERT INTO 'album' VALUES (343, '1998-10-13 22:00:00+00', '2012-01-20 12:57:56.101992+00', 'Encore', 'Encore (DS)', 'AS', 1, 102, 1993, 1, '', 2069);
INSERT INTO 'album' VALUES (344, '1999-06-24 22:00:00+00', '2012-01-20 12:57:56.114516+00', 'Jimmy Shand Jr. Invites You To Come To The Dance', 'JS Jr. Invites', 'IM', 1, 360, 0, 1, '', 3061);
INSERT INTO 'album' VALUES (345, '1998-12-01 23:00:00+00', '2012-01-20 12:57:56.1231+00', 'Scottish and Colonial Dance Music', 'Scot & Colon', 'BC', 1, 444, 0, 1, '', 2465);
INSERT INTO 'album' VALUES (319, '1999-08-08 22:00:00+00', '2023-08-28 11:29:22.155685+00', 'Silver Thistle Collection', 'Silver Thistle', 'AP', 1, 100, 1998, 1, '', 3006);
INSERT INTO 'album' VALUES (303, '1998-12-04 23:00:00+00', '2025-02-09 23:05:34.73605+00', 'On Stage With..., Volume 2', 'On Stage 2', 'AH', 1, 402, 1987, 1, '', 2133);
INSERT INTO 'album' VALUES (316, '1998-10-26 23:00:00+00', '2025-07-14 09:35:20.904552+00', 'Farewell to Paternoster Square', 'Paternoster', 'BC', 1, 71, 1991, 1, '', 3014);
INSERT INTO 'album' VALUES (299, '1998-12-04 23:00:00+00', '2025-02-09 23:16:06.66977+00', 'On Stage With..., Volume 1', 'On Stage 1', 'AH', 1, 401, 1985, 1, '', 2133);
INSERT INTO 'album' VALUES (276, '1998-10-11 22:00:00+00', '2025-08-15 23:57:39.421453+00', 'Pride of Edinburgh', 'Pride / Edin', 'RC', 1, 284, 1979, 1, '', 3008);
INSERT INTO 'album' VALUES (346, '1999-08-08 22:00:00+00', '2012-01-20 12:57:56.132212+00', 'Book 25. Twelve Scottish Country Dances', 'RSCDS 25', 'AP', 1, 197, 1999, 1, '', 3038);
INSERT INTO 'album' VALUES (347, '1999-08-26 22:00:00+00', '2012-01-20 12:57:56.144227+00', 'Book 26. Twelve Scottish Country Dances', 'RSCDS 26-2', 'AP', 1, 138, 1999, 1, '', 3036);
INSERT INTO 'album' VALUES (349, '1999-08-04 22:00:00+00', '2012-01-20 12:57:56.159604+00', 'Dancing Thro'' Scotland', 'Dancing / Scot (MH)', 'IP', 1, 193, 1972, 1, '', 3064);
INSERT INTO 'album' VALUES (350, '1999-08-04 22:00:00+00', '2012-01-20 12:57:56.16584+00', 'More Sounds of the North', 'Sound / North 2', 'IP', 1, 457, 0, 1, '', 3063);
INSERT INTO 'album' VALUES (326, '1998-11-02 23:00:00+00', '2012-02-11 14:20:29.429663+00', 'Scotland Dances to Alasdair Downie and his Scottish Band', 'SD (A Downie)', 'HO', 1, 116, 1960, 1, '', 2246);
INSERT INTO 'album' VALUES (351, '1999-08-04 22:00:00+00', '2012-01-20 12:57:56.169225+00', 'Scottish Country Dance Music - Vol 2', 'SCD Vol2 (RE)', 'IP', 1, 126, 0, 1, '', 2045);
INSERT INTO 'album' VALUES (353, '1999-08-05 22:00:00+00', '2012-01-20 12:57:56.176023+00', 'Play the St. Andrew''s Ball', 'St Andrews (RK)', 'AP', 1, 241, 1999, 1, '', 2645);
INSERT INTO 'album' VALUES (355, '2001-12-11 23:00:00+00', '2012-01-20 12:57:56.191521+00', 'Kardinia Capers', 'Kardinia', '', 0, 531, 1999, 2, '', 2681);
INSERT INTO 'album' VALUES (357, '2002-07-03 22:00:00+00', '2012-01-20 12:57:56.206665+00', 'Gang on the Same Gate', 'Gang Same Gate', 'AP', 1, 515, 1999, 2, '', 2696);
INSERT INTO 'album' VALUES (358, '2002-04-25 22:00:00+00', '2012-01-20 12:57:56.212866+00', 'Hielan'' Laddie', 'Hielan'' Laddie', 'AP', 1, 505, 0, 2, '', 2038);
INSERT INTO 'album' VALUES (361, '2000-07-30 22:00:00+00', '2012-01-20 12:57:56.234156+00', 'Highlander Music Scottish Dances Vol 11', 'Highlander SD11', '', 0, 518, 2000, 2, '', 2583);
INSERT INTO 'album' VALUES (363, '2002-07-21 22:00:00+00', '2012-01-20 12:57:56.246501+00', 'Special Requests Volume 4', 'Sp.Requests 4', 'AP', 1, 512, 1999, 2, '', 3023);
INSERT INTO 'album' VALUES (364, '2000-07-01 22:00:00+00', '2012-01-20 12:57:56.255884+00', 'Dozen Dances, A', 'Dozen Dances', 'AP', 1, 504, 0, 2, '', 2036);
INSERT INTO 'album' VALUES (367, '2002-04-25 22:00:00+00', '2012-01-20 12:57:56.274493+00', 'Bobby Brown Collection, The', 'Bobby Brown Coll.', 'AP', 1, 506, 2000, 2, 'This CD set (of 2 CDs) is a reissue of Island Fling, Maid of the Mill and Tarry Awhile.', 3067);
INSERT INTO 'album' VALUES (369, '2000-11-09 23:00:00+00', '2012-01-20 12:57:56.286843+00', 'Book 41. The Millennium Dances', 'RSCDS 41', 'AP', 1, 511, 2000, 2, '', 3006);
INSERT INTO 'album' VALUES (370, '1998-10-27 23:00:00+00', '2012-01-20 12:57:56.293047+00', 'More Sounds of Scotland', 'More Sounds', 'EC', 1, 273, 1967, 1, '', 3009);
INSERT INTO 'album' VALUES (372, '1998-10-11 22:00:00+00', '2012-01-20 12:57:56.305423+00', 'Jimmy MacGovern Country Dance Orchestra, The', 'JMacGov CD Orch', 'JW', 1, 254, 1977, 1, '', 2291);
INSERT INTO 'album' VALUES (373, '2000-09-05 22:00:00+00', '2012-01-20 12:57:56.311612+00', 'Piper''s Choice', 'Piper''s Choice', '', 0, 509, 2000, 2, '', 1556);
INSERT INTO 'album' VALUES (374, '1998-11-03 23:00:00+00', '2012-01-20 12:57:56.317783+00', 'Scottish Dance Music', 'SD Music (GM)', 'HO', 1, 299, 1976, 1, '', 2412);
INSERT INTO 'album' VALUES (376, '1999-05-25 22:00:00+00', '2012-01-20 12:57:56.332982+00', 'Host of the Air, The', 'Host / Air', 'SP', 1, 172, 1998, 1, '', 2418);
INSERT INTO 'album' VALUES (378, '2000-12-04 23:00:00+00', '2012-01-20 12:57:56.34538+00', 'Water Aid Set Dances Vol. 1', 'Wateraid', 'MM', 1, 527, 1994, 2, '', 2566);
INSERT INTO 'album' VALUES (379, '1998-10-12 22:00:00+00', '2012-01-20 12:57:56.351545+00', 'Pride of Scotland, The', 'Pride Scotland', 'JW', 1, 377, 0, 1, '', 3010);
INSERT INTO 'album' VALUES (380, '2000-12-04 23:00:00+00', '2012-01-20 12:57:56.357739+00', 'Friendship Dances', 'Friendship', '', 0, 525, 1998, 2, '', 2197);
INSERT INTO 'album' VALUES (381, '1998-11-14 23:00:00+00', '2012-01-20 12:57:56.36391+00', 'Legendary Jimmy Shand, The', 'Legendary', 'RC', 1, 372, 1968, 1, '', 3010);
INSERT INTO 'album' VALUES (385, '1999-02-01 23:00:00+00', '2012-01-20 12:57:56.399935+00', 'Village Hall to Royal Ball', 'Village Hall', 'PM', 1, 342, 1952, 1, '', 2189);
INSERT INTO 'album' VALUES (384, '2001-12-11 23:00:00+00', '2012-04-14 15:00:42.656603+00', 'Memories of Fife', 'Memories of Fife', '', 0, 522, 2000, 2, '', 3002);
INSERT INTO 'album' VALUES (382, '2001-03-18 23:00:00+00', '2012-04-27 17:27:16.188636+00', 'Etive Selection of Scottish Country Dancing, The', 'Etive', '', 0, 519, 2001, 2, '', 3038);
INSERT INTO 'album' VALUES (354, '1999-08-26 22:00:00+00', '2012-04-27 19:02:43.231656+00', 'Book 40. SC Dances for young people and new dancers', 'RSCDS 40', 'AP', 1, 74, 1999, 1, '', 2137);
INSERT INTO 'album' VALUES (362, '2001-12-11 23:00:00+00', '2012-10-18 21:32:13.3629+00', 'Celebrate Fifty Years of Dancing with the Boston Branch', 'Celebrate 50', 'AP', 1, 536, 2000, 2, '', 3016);
INSERT INTO 'album' VALUES (368, '1998-10-20 22:00:00+00', '2013-02-15 17:50:07.011835+00', 'Meet the Olympians', 'Meet Olympians', 'EC', 1, 320, 0, 1, '', 3024);
INSERT INTO 'album' VALUES (386, '2002-06-02 22:00:00+00', '2012-01-20 12:57:56.406133+00', '12th Night Ball 2001', '12th Night', '', 0, 501, 0, 2, '', 2846);
INSERT INTO 'album' VALUES (457, '2004-10-12 22:00:00+00', '2012-01-20 12:57:56.880196+00', 'Book 12.', 'RSCDS 12', 'AP', 1, 0, 2003, 0, '', 3067);
INSERT INTO 'album' VALUES (323, '2000-04-04 22:00:00+00', '2013-04-10 09:59:18.961858+00', 'Highlander Music Scottish Dances Vol 9', 'Highlander SD 9', 'AP', 1, 242, 1999, 1, '', 2585);
INSERT INTO 'album' VALUES (387, '2002-04-25 22:00:00+00', '2012-01-20 12:57:56.412405+00', 'Dancing Fingers 1', 'Fingers 1-CD', '', 1, 521, 2001, 2, 'This CD is a re-issue of Dancing Fingers (formerly on tape) with extra material', 1502);
INSERT INTO 'album' VALUES (388, '1998-09-02 22:00:00+00', '2012-01-20 12:57:56.418617+00', 'Saint Andrew''s Ball - Volume 2', 'St. A. Ball 2', '', 0, 426, 0, 1, '', 3016);
INSERT INTO 'album' VALUES (389, '2002-04-02 22:00:00+00', '2012-01-20 12:57:56.424831+00', 'Reel Friends Book 2', 'Reel Friends 2', 'AP', 1, 516, 2000, 2, '', 1396);
INSERT INTO 'album' VALUES (390, '2001-05-30 22:00:00+00', '2012-01-20 12:57:56.431011+00', 'Live and Well', 'Live & Well', 'AP', 1, 528, 2001, 2, '', 3030);
INSERT INTO 'album' VALUES (392, '2002-04-25 22:00:00+00', '2012-01-20 12:57:56.443483+00', 'Country Dance, Ceilidh Dance', 'Country, Ceilidh', 'AP', 1, 514, 2001, 2, '', 3026);
INSERT INTO 'album' VALUES (395, '2001-11-17 23:00:00+00', '2012-01-20 12:57:56.462024+00', 'Morino Magic', 'Morino Magic', '', 0, 529, 1999, 2, '', 3012);
INSERT INTO 'album' VALUES (352, '1999-08-04 22:00:00+00', '2015-07-28 13:00:05.662353+00', 'Sound of Jim Johnstone and His Band, The', 'Sound of JJ', 'IP', 1, 213, 1974, 1, '', 3037);
INSERT INTO 'album' VALUES (365, '1998-11-11 23:00:00+00', '2015-10-08 14:48:57.288521+00', 'Just What the Doctor Ordered', 'Doctor', '', 1, 310, 1991, 1, '', 3012);
INSERT INTO 'album' VALUES (396, '2001-11-18 23:00:00+00', '2012-01-20 12:57:56.468203+00', 'Fife Fairing, A', 'Fife Fairing', '', 0, 534, 0, 2, '', 3016);
INSERT INTO 'album' VALUES (398, '1999-07-18 22:00:00+00', '2012-01-20 12:57:56.480597+00', 'Book 26. Scottish Country Dance Music', 'RSCDS 26-1', 'BL', 1, 350, 1973, 1, '', 2184);
INSERT INTO 'album' VALUES (399, '1999-05-25 22:00:00+00', '2012-01-20 12:57:56.486767+00', 'Awa'' Frae Hame', 'Awa'' Frae Hame', 'BL', 1, 361, 1963, 1, '', 3010);
INSERT INTO 'album' VALUES (400, '2001-12-18 23:00:00+00', '2012-01-20 12:57:56.492951+00', 'Clashmadin Volume One', 'Clashmadin1', '', 1, 526, 2001, 2, '', 3045);
INSERT INTO 'album' VALUES (402, '2002-07-02 22:00:00+00', '2012-01-20 12:57:56.50534+00', 'Reflections of Dalriada', 'Dalriada', 'AP', 1, 513, 0, 2, '', 2993);
INSERT INTO 'album' VALUES (404, '2002-03-12 23:00:00+00', '2012-01-20 12:57:56.518398+00', 'Dances with a Difference, Volume 1', 'Difference 1', '', 0, 524, 2002, 2, '', 3002);
INSERT INTO 'album' VALUES (405, '2002-04-03 22:00:00+00', '2012-01-20 12:57:56.524609+00', 'March Hare, The', 'March Hare', 'AP', 1, 520, 2001, 2, '', 3092);
INSERT INTO 'album' VALUES (406, '1998-10-13 22:00:00+00', '2012-01-20 12:57:56.530825+00', 'Scottish Collection: Dance Music', 'S Coll: Dance', 'AS', 1, 432, 1996, 1, '', 3016);
INSERT INTO 'album' VALUES (407, '2002-05-14 22:00:00+00', '2012-01-20 12:57:56.537017+00', 'Music for Leaflet Dances Vol. 1', 'Leaflet 1', 'AP', 1, 0, 2002, 2, '', 3016);
INSERT INTO 'album' VALUES (408, '1998-10-13 22:00:00+00', '2012-01-20 12:57:56.543256+00', 'Lilt O'' Scotland', 'Lilt Scotland', 'AS', 1, 114, 1994, 1, '', 2173);
INSERT INTO 'album' VALUES (409, '2002-06-19 22:00:00+00', '2012-01-20 12:57:56.549436+00', 'Music for Leaflet Dances Vol. 2', 'Leaflet 2', 'PM', 1, 0, 2002, 2, '', 3137);
INSERT INTO 'album' VALUES (410, '2002-06-04 22:00:00+00', '2012-01-20 12:57:56.555701+00', 'First Dram, A', 'First Dram', 'AP', 1, 0, 2002, 2, '', 3139);
INSERT INTO 'album' VALUES (360, '2000-03-18 23:00:00+00', '2022-08-23 22:45:00.110855+00', 'Nice to See You', 'Nice to See You', '', 0, 510, 2000, 2, '', 2188);
INSERT INTO 'album' VALUES (411, '2002-07-02 22:00:00+00', '2012-01-20 12:57:56.561921+00', 'Skye Collection, A', 'Skye Coll (CD)', 'PM', 1, 0, 2001, 2, '', 3016);
INSERT INTO 'album' VALUES (413, '2002-06-25 22:00:00+00', '2012-01-20 12:57:56.574285+00', 'Scottish Country Dancing', 'SCD (Crowe)', 'IS', 1, 0, 1991, 2, '', 3018);
INSERT INTO 'album' VALUES (414, '1999-08-04 22:00:00+00', '2012-01-20 12:57:56.580694+00', 'Dance Party Favourites', 'DancePartyFavs', 'BC', 1, 270, 0, 1, '', 3009);
INSERT INTO 'album' VALUES (415, '1998-11-15 23:00:00+00', '2012-01-20 12:57:56.586873+00', 'Scottish Country Dances', 'SCD (various)', 'BL', 1, 434, 1964, 1, '', 3016);
INSERT INTO 'album' VALUES (416, '2002-06-30 22:00:00+00', '2012-01-20 12:57:56.593108+00', 'Iain MacPhail Celebrates in South America', 'MacPhail in SA', 'PM', 1, 0, 2000, 2, '', 3008);
INSERT INTO 'album' VALUES (417, '1998-10-21 22:00:00+00', '2012-01-20 12:57:56.599294+00', 'Scottish Country Dance', 'SCD (Glenda)', 'EC', 1, 146, 1979, 1, '', 3057);
INSERT INTO 'album' VALUES (418, '1999-06-24 22:00:00+00', '2012-01-20 12:57:56.6064+00', 'Scottish Country Dances in Strict Tempo (No. 3)', 'Strict Tempo 3', 'EC', 1, 381, 0, 1, '', 3010);
INSERT INTO 'album' VALUES (419, '1999-01-13 23:00:00+00', '2012-01-20 12:57:56.6126+00', 'Scotland: The Sound of John Ellis and his HC Band Vol. 2', 'Scotland: Ellis2', 'EN', 1, 124, 1975, 1, '', 3056);
INSERT INTO 'album' VALUES (833, '1998-10-12 22:00:00+00', '2018-02-15 09:16:38.445068+00', 'Scottish Ramble', 'Ramble', 'JW', 1, 383, 1963, 1, '', 3010);
INSERT INTO 'album' VALUES (393, '2002-04-25 22:00:00+00', '2023-08-28 10:54:35.17368+00', 'Aberdeen Collection, An', 'Aberdeen', 'AP', 1, 532, 2001, 2, '', 2944);
INSERT INTO 'album' VALUES (356, '2002-06-30 22:00:00+00', '2023-08-28 11:37:44.157295+00', 'Tin Woodman, The', 'Tin Woodman', '', 0, 517, 1999, 2, '', 2583);
INSERT INTO 'album' VALUES (348, '1999-08-04 22:00:00+00', '2024-01-28 11:13:21.765501+00', 'Looking For a Partner', 'Look Part (2)', 'IP', 1, 394, 1968, 1, 'Spotify link <<https://open.spotify.com/album/4DcmgJUjiZuGM4UH8iej7r>>', 2631);
INSERT INTO 'album' VALUES (397, '2001-12-18 23:00:00+00', '2012-10-02 16:01:28.708245+00', 'Come Forth to the Scottish Country Dance', 'Come Forth', 'AP', 1, 502, 2000, 2, '', 3032);
INSERT INTO 'album' VALUES (420, '1998-10-25 23:00:00+00', '2012-01-20 12:57:56.618782+00', 'Cavendish Dance Band Plays SCD in Traditional Style', 'Cavendish DB', 'EN', 1, 60, 1973, 1, '', 3068);
INSERT INTO 'album' VALUES (421, '1998-10-25 23:00:00+00', '2012-01-20 12:57:56.625669+00', 'Scotland: The Sound of John Ellis and his HC Band', 'Scotland: Ellis', 'EN', 1, 123, 1974, 1, '', 3056);
INSERT INTO 'album' VALUES (423, '2003-01-01 23:00:00+00', '2012-01-20 12:57:56.63846+00', 'Dancing Fingers 4. The Blackadder Collection', 'Fingers 4', 'IM', 1, 0, 2002, 2, '', 1502);
INSERT INTO 'album' VALUES (424, '2003-01-01 23:00:00+00', '2012-01-20 12:57:56.644741+00', 'Dancing Fingers 5. The Merse Collection', 'Fingers 5', 'IM', 1, 0, 2002, 2, '', 1502);
INSERT INTO 'album' VALUES (425, '2002-08-20 22:00:00+00', '2012-01-20 12:57:56.650926+00', 'I Love Scottish Country Dance Music', 'I Love SCD Music', 'IM', 1, 0, 1997, 2, '', 3185);
INSERT INTO 'album' VALUES (426, '2002-10-20 22:00:00+00', '2012-01-20 12:57:56.657104+00', 'Dancing Feet', 'Dancing Feet', '', 0, 0, 2002, 2, '', 2184);
INSERT INTO 'album' VALUES (427, '2002-11-13 23:00:00+00', '2012-01-20 12:57:56.663287+00', 'Book 42.', 'RSCDS 42', 'PM', 1, 0, 2002, 2, '', 3217);
INSERT INTO 'album' VALUES (428, '2003-01-01 23:00:00+00', '2012-01-20 12:57:56.66946+00', 'Dancers'' Choice 1', 'Dancers C.:Anderson', 'AP', 1, 0, 2002, 2, '', 3217);
INSERT INTO 'album' VALUES (429, '2003-02-11 23:00:00+00', '2012-01-20 12:57:56.675666+00', 'Miss Ogilvie''s Fancy', 'Miss Ogilvie', 'AP', 1, 0, 2002, 2, '', 2696);
INSERT INTO 'album' VALUES (430, '2003-02-11 23:00:00+00', '2012-01-20 12:57:56.681876+00', 'Special Requests Volume 5', 'Sp.Requests 5', 'AP', 1, 0, 2002, 2, '', 3023);
INSERT INTO 'album' VALUES (431, '2003-02-11 23:00:00+00', '2012-01-20 12:57:56.688074+00', 'Book 36. Frae a'' the Airts, Vol 1', 'RSCDS 36 (CD)', 'AP', 1, 0, 2002, 2, '', 3008);
INSERT INTO 'album' VALUES (432, '2003-02-12 23:00:00+00', '2012-01-20 12:57:56.694652+00', 'Book 37. Frae a'' the Airts, Vol 2', 'RSCDS 37', '', 0, 0, 2002, 2, '', 3008);
INSERT INTO 'album' VALUES (434, '2003-02-15 23:00:00+00', '2012-01-20 12:57:56.707105+00', 'Road to Forfar, The', 'Road to Forfar', 'IM', 1, 0, 2002, 2, '', 3032);
INSERT INTO 'album' VALUES (437, '2003-05-19 22:00:00+00', '2012-01-20 12:57:56.72592+00', 'Best of Scottish Dance Bands, The', 'Best of SDB (LP)', '', 0, 0, 0, 2, '', 3016);
INSERT INTO 'album' VALUES (1111, '2018-04-10 10:33:52.122952+00', '2018-04-10 13:24:32.030271+00', 'More Swans of Atlanta', '', '', 0, 0, 2018, 0, '', 11613);
INSERT INTO 'album' VALUES (436, '2003-02-24 23:00:00+00', '2019-04-09 16:58:45.207593+00', 'Waverley Station: First Stop!', 'First Stop', '', 0, 0, 2003, 2, 'Can be purchased from 

http://rscdsleeds.uk/index.php?id_product=972&controller=product

', 2885);
INSERT INTO 'album' VALUES (441, '2003-11-17 23:00:00+00', '2012-01-20 12:57:56.751399+00', 'Book 43', 'RSCDS 43', '', 0, 0, 2003, 0, '', 3008);
INSERT INTO 'album' VALUES (442, '2003-11-17 23:00:00+00', '2012-01-20 12:57:56.757582+00', 'Quick Here''s Anither Yin', 'Anither Yin', '', 0, 0, 2003, 0, '', 3019);
INSERT INTO 'album' VALUES (445, '2003-12-18 23:00:00+00', '2012-01-20 12:57:56.778958+00', 'Many Happy Returns', 'Happy Returns', '', 0, 0, 2003, 0, '', 3399);
INSERT INTO 'album' VALUES (446, '2003-12-21 23:00:00+00', '2012-01-20 12:57:56.817734+00', 'In a Different Light', 'Different Light', 'AP', 1, 0, 1990, 0, '', 3071);
INSERT INTO 'album' VALUES (448, '2004-04-26 22:00:00+00', '2012-01-20 12:57:56.830493+00', 'Book 38. Music for Eight Scottish Country Dances', 'Book 38', 'AP', 1, 0, 2004, 0, '', 3002);
INSERT INTO 'album' VALUES (450, '2004-05-02 22:00:00+00', '2012-01-20 12:57:56.842864+00', 'Delaware Valley Spring Ball 2003', 'Delaware', 'AP', 1, 0, 2003, 0, '', 2586);
INSERT INTO 'album' VALUES (451, '2004-08-15 22:00:00+00', '2012-01-20 12:57:56.849126+00', 'Dance Through The Miscellanies - Part 3', 'Miscellanies 3', 'LH', 1, 0, 2004, 0, '', 3002);
INSERT INTO 'album' VALUES (452, '2004-08-15 22:00:00+00', '2012-01-20 12:57:56.855349+00', 'Book 44 - Music for Ten Scottish Country Dances', 'RSCDS 44', 'LH', 1, 0, 2004, 0, '', 3039);
INSERT INTO 'album' VALUES (453, '2004-08-24 22:00:00+00', '2012-01-20 12:57:56.86155+00', 'Luckenbooth Brooch, The', 'Luckenbooth', 'LH', 1, 0, 2004, 0, '', 3012);
INSERT INTO 'album' VALUES (422, '2002-07-02 22:00:00+00', '2012-10-02 15:22:54.494014+00', 'Ceilidh Round the Steeple', 'Ceilidh Steeple', 'BB', 1, 0, 2001, 2, '', 3050);
INSERT INTO 'album' VALUES (444, '2003-11-23 23:00:00+00', '2012-10-10 14:15:18.23552+00', 'Devil''s Quandary, The', 'Devil''s Quandary', '', 0, 0, 2003, 0, '', 3403);
INSERT INTO 'album' VALUES (435, '2003-02-15 23:00:00+00', '2012-12-26 15:44:48.453269+00', 'Vintage 78''s', 'Vintage 78s', '', 0, 0, 2001, 2, '', 2328);
INSERT INTO 'album' VALUES (456, '2004-10-12 22:00:00+00', '2012-01-20 12:57:56.873934+00', 'Book 31/32', 'RSCDS 31/32', 'AP', 1, 0, 2003, 0, '', 3022);
INSERT INTO 'album' VALUES (391, '2001-06-13 22:00:00+00', '2014-05-13 09:45:31.19738+00', 'Reel Party, The', 'Reel Party', 'AP', 1, 503, 1999, 2, '', 3011);
INSERT INTO 'album' VALUES (458, '2004-10-31 23:00:00+00', '2012-01-20 12:57:56.886397+00', 'Dancers'' Choice 2', 'Dancers'' Ch 2', '', 0, 0, 2004, 0, '', 3039);
INSERT INTO 'album' VALUES (459, '2004-10-31 23:00:00+00', '2012-01-20 12:57:56.892637+00', 'Berkhamsted Strathspey & Reel Club: Golden Jubilee Book of', 'Berkhamsted', '', 0, 0, 2003, 0, '', 3459);
INSERT INTO 'album' VALUES (460, '2004-11-01 23:00:00+00', '2012-01-20 12:57:56.898848+00', 'Dancing Forth Too', 'Dancing Forth 2', 'AP', 1, 0, 2004, 0, '', 3464);
INSERT INTO 'album' VALUES (461, '2004-11-02 23:00:00+00', '2012-01-20 12:57:56.905019+00', 'Music for Graded Scottish Country Dances', 'Graded (CD)', 'AP', 1, 0, 2004, 0, '', 3016);
INSERT INTO 'album' VALUES (463, '2004-11-24 23:00:00+00', '2012-01-20 12:57:56.917838+00', 'Special Requests Volume 6', 'Sp. Requests 6', '', 0, 0, 2004, 0, '', 3023);
INSERT INTO 'album' VALUES (466, '2004-12-07 23:00:00+00', '2012-01-20 12:57:56.936594+00', 'Breakdown, The', 'Breakdown', '', 0, 0, 2004, 0, '', 3483);
INSERT INTO 'album' VALUES (467, '2004-12-14 23:00:00+00', '2012-01-20 12:57:56.943288+00', 'Really Jiggin''', '', '', 0, 0, 2003, 0, '', 3060);
INSERT INTO 'album' VALUES (468, '2005-01-05 23:00:00+00', '2012-01-20 12:57:56.949514+00', 'Old Favourites and Odd Couples', 'Favourites/Couples', 'LH', 1, 0, 2004, 0, '', 3496);
INSERT INTO 'album' VALUES (471, '2005-02-03 23:00:00+00', '2012-01-20 12:57:56.96805+00', 'One Step at a Time', 'One Step', '', 0, 0, 2004, 0, '', 3420);
INSERT INTO 'album' VALUES (403, '2002-03-12 23:00:00+00', '2017-12-15 23:06:43.104325+00', 'Book 19. Music for Twelve Scottish Country Dances', 'RSCDS 19', '', 1, 240, 1996, 1, '', 3028);
INSERT INTO 'album' VALUES (462, '2004-11-24 23:00:00+00', '2017-11-19 18:40:00.685109+00', 'Birl Roond Forfar, A', 'Birl Roond Forfar', '', 0, 0, 2004, 0, '', 3032);
INSERT INTO 'album' VALUES (472, '2005-02-22 23:00:00+00', '2012-01-20 12:57:56.974226+00', 'What You Hear is What You Get', 'What You See', '', 0, 0, 2005, 0, '', 1836);
INSERT INTO 'album' VALUES (473, '2005-03-22 23:00:00+00', '2012-01-20 12:57:56.9804+00', 'Domino Five', 'Domino 5', '', 0, 0, 2004, 0, '', 3019);
INSERT INTO 'album' VALUES (474, '2005-03-24 23:00:00+00', '2012-01-20 12:57:56.986608+00', 'Music for Quadrilles', 'Quadrilles', '', 0, 0, 2005, 0, '', 3530);
INSERT INTO 'album' VALUES (475, '2005-04-13 22:00:00+00', '2012-01-20 12:57:56.992839+00', 'Frank Reid plays Just For You', '', '', 0, 0, 1979, 0, '', 1557);
INSERT INTO 'album' VALUES (476, '2005-05-01 22:00:00+00', '2012-01-20 12:57:56.999013+00', 'Scottish Fancy, A', 'Scot Fancy LP', '', 0, 0, 1971, 0, '', 3010);
INSERT INTO 'album' VALUES (479, '2005-05-03 22:00:00+00', '2012-01-20 12:57:57.020543+00', 'Industrial Strength', 'Industrial Strength', '', 0, 0, 0, 0, '', 3604);
INSERT INTO 'album' VALUES (480, '2005-06-29 22:00:00+00', '2012-01-20 12:57:57.026814+00', 'Book 45', 'RSCDS 45', 'AP', 1, 0, 2005, 0, '', 3040);
INSERT INTO 'album' VALUES (483, '2005-08-25 22:00:00+00', '2012-01-20 12:57:57.045856+00', 'Live in Moffat', 'Live in Moffat', 'AP', 1, 0, 2005, 0, '', 3619);
INSERT INTO 'album' VALUES (484, '2005-11-13 23:00:00+00', '2012-01-20 12:57:57.052125+00', 'It''s Just for Fun', 'Just for Fun 2', '', 0, 0, 2005, 0, '', 3650);
INSERT INTO 'album' VALUES (485, '2005-12-18 23:00:00+00', '2012-01-20 12:57:57.058357+00', 'Dancing Master Remembered, A', 'Dancing Master', 'WT', 1, 0, 2005, 0, '', 3653);
INSERT INTO 'album' VALUES (486, '2006-01-05 23:00:00+00', '2012-01-20 12:57:57.064544+00', 'Highlander Music Scottish Dances Vol 12', 'Highlander SD 12', 'LH', 1, 0, 2005, 0, '', 3217);
INSERT INTO 'album' VALUES (487, '2006-01-11 23:00:00+00', '2012-01-20 12:57:57.070723+00', 'Southern Touch, The', 'Southern Touch', 'LH', 1, 0, 2004, 0, '', 2681);
INSERT INTO 'album' VALUES (488, '2006-01-19 23:00:00+00', '2012-01-20 12:57:57.076925+00', 'Highlander Music Scottish Dances Vol 13', 'Highlander SD 13', 'AP', 1, 0, 2005, 0, '', 3039);
INSERT INTO 'album' VALUES (489, '2006-02-16 23:00:00+00', '2012-12-26 11:42:49.037292+00', 'Book 15', 'RSCDS 15', 'AP', 1, 0, 2005, 0, '', 3011);
INSERT INTO 'album' VALUES (492, '2006-03-30 22:00:00+00', '2012-01-20 12:57:57.102811+00', 'Odds, The', 'The Odds', '', 0, 0, 2003, 0, '', 3185);
INSERT INTO 'album' VALUES (433, '2003-02-14 23:00:00+00', '2022-12-11 20:07:08.374822+00', 'Music for the Scotia Centenary', 'Scotia Cent.', 'AP', 1, 0, 2002, 2, '', 3016);
INSERT INTO 'album' VALUES (477, '2005-05-01 22:00:00+00', '2022-12-16 14:07:37.155538+00', 'Scottish Country Dancing', 'SCD: McBain', 'AP', 1, 0, 1973, 0, '', 2058);
INSERT INTO 'album' VALUES (496, '2006-05-21 22:00:00+00', '2012-01-20 12:57:57.128009+00', 'Let''s Dance', 'Let''s Dance', 'LH', 1, 0, 2003, 0, '', 3185);
INSERT INTO 'album' VALUES (497, '2006-05-22 22:00:00+00', '2012-01-20 12:57:57.134196+00', '80 Years of Dundee Dancing', 'Dundee 80', '', 0, 0, 2006, 0, '', 3683);
INSERT INTO 'album' VALUES (498, '2006-05-25 22:00:00+00', '2012-01-20 12:57:57.14043+00', 'Leaflet 32 Dances, The', 'Leaflet 32', '', 0, 0, 0, 0, '', 3685);
INSERT INTO 'album' VALUES (506, '2006-08-13 22:00:00+00', '2012-01-20 12:57:57.225431+00', 'From Glenamond to Glenquaich', 'Glenalmond', '', 0, 0, 1995, 0, '', 3025);
INSERT INTO 'album' VALUES (508, '2006-10-12 22:00:00+00', '2012-01-20 12:57:57.237932+00', 'Diamond Jubilee', 'Diamond (Lothian)', 'LH', 1, 0, 2006, 0, '', 3040);
INSERT INTO 'album' VALUES (509, '2006-10-25 22:00:00+00', '2012-01-20 12:57:57.244171+00', 'Vallin Suite 1, The', 'Vallin', 'AP', 1, 0, 2006, 0, '', 3011);
INSERT INTO 'album' VALUES (510, '2006-12-05 23:00:00+00', '2012-01-20 12:57:57.250359+00', 'Reel Friends Book 3', 'Reel Friends 3', '', 0, 0, 2006, 0, '', 3040);
INSERT INTO 'album' VALUES (507, '2006-08-24 22:00:00+00', '2023-08-28 11:01:28.355018+00', 'Blackwater Collection, The', 'Blackwater', '', 0, 0, 2006, 0, '', 3014);
INSERT INTO 'album' VALUES (491, '2006-03-07 23:00:00+00', '2023-08-28 11:39:48.494002+00', 'We Twa', 'We Twa', '', 0, 0, 2006, 0, '', 3019);
INSERT INTO 'album' VALUES (495, '2006-05-17 22:00:00+00', '2025-11-04 14:59:59.559961+00', 'Lochiel Collection, The', 'Lochiel', 'AP', 1, 0, 2006, 0, '', 3420);
INSERT INTO 'album' VALUES (478, '2005-05-01 22:00:00+00', '2023-11-12 11:15:56.434322+00', 'Jimmy Shand Favourites', 'Shand Favs', '', 0, 0, 0, 0, '', 3010);
INSERT INTO 'album' VALUES (511, '2006-12-17 23:00:00+00', '2012-01-20 12:57:57.256542+00', '75th Anniversary of London Branch', 'London 75', 'AP', 1, 0, 2006, 0, '', 3016);
INSERT INTO 'album' VALUES (513, '2007-01-03 23:00:00+00', '2012-01-20 12:57:57.268911+00', 'Piano Dance', 'Piano Dance', 'AP', 1, 0, 2006, 0, '', 1846);
INSERT INTO 'album' VALUES (702, '1998-11-15 23:00:00+00', '2012-01-20 12:57:57.287501+00', 'Breath of Shetland, A', 'Shetland', 'EE', 1, 177, 1975, 1, '', 2177);
INSERT INTO 'album' VALUES (703, '1998-10-15 22:00:00+00', '2012-01-20 12:57:57.293679+00', 'Jimmy Shand Dance Party, A', 'JS Dance Party', 'WE', 1, 369, 0, 1, '', 3010);
INSERT INTO 'album' VALUES (705, '1998-11-20 23:00:00+00', '2012-01-20 12:57:57.299881+00', 'Across the Tay', 'AcrossTay', 'BC', 1, 298, 0, 1, '', 2178);
INSERT INTO 'album' VALUES (706, '1998-10-11 22:00:00+00', '2012-01-20 12:57:57.306073+00', 'Evening of Scottish Country Dancing, An', 'Evening of SCD', 'EN', 1, 204, 1974, 1, '', 2303);
INSERT INTO 'album' VALUES (709, '1998-11-14 23:00:00+00', '2012-01-20 12:57:57.312258+00', 'Artistic License', 'Artistic License', 'DS', 1, 300, 1996, 1, '', 2179);
INSERT INTO 'album' VALUES (712, '1999-10-05 22:00:00+00', '2012-01-20 12:57:57.327402+00', 'Barn Dance Party', 'Barn Dance', '??', 1, 328, 0, 1, '', 3042);
INSERT INTO 'album' VALUES (714, '1999-08-06 22:00:00+00', '2012-01-20 12:57:57.333602+00', 'Bobby MacLeod''s Highland Dance Band', 'MacLeod HDB', 'EN', 1, 261, 0, 1, '', 2328);
INSERT INTO 'album' VALUES (715, '1998-10-14 22:00:00+00', '2012-01-20 12:57:57.339807+00', 'Bobby''s Kind of Music', 'Kind of Music', 'BS', 1, 262, 1970, 1, '', 2328);
INSERT INTO 'album' VALUES (716, '1999-06-30 22:00:00+00', '2012-01-20 12:57:57.346151+00', 'Bonnie Scotland', 'Bonnie Scot', 'PB', 1, 414, 1974, 1, '', 3016);
INSERT INTO 'album' VALUES (717, '1998-10-10 22:00:00+00', '2012-01-20 12:57:57.352435+00', 'Canada on Tour', 'Canada on Tour', 'JW', 1, 36, 0, 1, '', 3067);
INSERT INTO 'album' VALUES (718, '1998-12-29 23:00:00+00', '2012-01-20 12:57:57.358622+00', 'Come Dance Wi'' Me', 'Dance Wi'' Me', 'EN', 1, 386, 0, 1, '', 2180);
INSERT INTO 'album' VALUES (719, '1998-10-12 22:00:00+00', '2012-01-20 12:57:57.364811+00', 'Come Home to Scotland', 'Come Home', 'EN', 1, 192, 1968, 1, '', 3064);
INSERT INTO 'album' VALUES (721, '1998-11-14 23:00:00+00', '2012-01-20 12:57:57.370998+00', 'Come Scottish Country Dancing with the Tillside Trio', 'Come SCD/Till', 'DS', 1, 407, 1980, 1, '', 2064);
INSERT INTO 'album' VALUES (722, '1999-06-24 22:00:00+00', '2012-01-20 12:57:57.377187+00', 'Come to Fiona''s Wedding', 'Fiona Wedding', 'IM', 1, 269, 1969, 1, '', 3009);
INSERT INTO 'album' VALUES (723, '1999-01-05 23:00:00+00', '2012-01-20 12:57:57.383398+00', 'Country Dancers Delight', 'CD Delight', 'HO', 1, 103, 0, 1, '', 3041);
INSERT INTO 'album' VALUES (512, '2007-09-03 22:00:00+00', '2012-03-25 08:49:44.872605+00', 'Platinum - 70 Years of Dancing in St Andrews', 'St Andrews Platinum', 'LH', 1, 0, 2007, 0, '', 3016);
INSERT INTO 'album' VALUES (516, '2007-11-15 23:00:00+00', '2012-09-16 15:48:23.328995+00', 'Scottish Christmas Dance Party', 'Christmas Party', '', 0, 0, 2007, 0, '', 10659);
INSERT INTO 'album' VALUES (501, '2006-07-27 22:00:00+00', '2012-09-28 16:13:51.982825+00', 'Book 10. Music for Twelve Scottish Country Dances', 'RSCDS 10 (CD)', '', 0, 0, 2004, 0, '', 1396);
INSERT INTO 'album' VALUES (504, '2006-07-30 22:00:00+00', '2012-10-02 14:40:13.259915+00', 'Caledonian Muse', 'Caledonian Muse', 'LH', 1, 0, 2005, 0, '', 3017);
INSERT INTO 'album' VALUES (505, '2006-07-31 22:00:00+00', '2012-10-11 16:07:19.538577+00', 'Kangaroo Paw, The', 'Kangaroo Paw', '', 0, 0, 2006, 0, '', 3217);
INSERT INTO 'album' VALUES (482, '2005-08-08 22:00:00+00', '2013-04-10 06:23:00.658451+00', 'Book 4. Music for Twelve Scottish Country Dances', 'RSCDS 4', '', 0, 0, 2003, 0, '', 3011);
INSERT INTO 'album' VALUES (470, '2005-02-01 23:00:00+00', '2013-05-12 12:32:41.967101+00', 'Clapyerhands ''n'' Stampyerfeet', 'Clapyerhands', '', 0, 0, 2003, 0, '', 3420);
INSERT INTO 'album' VALUES (502, '2006-07-27 22:00:00+00', '2014-02-14 13:59:35.701365+00', 'Scottish Country Dances Vol 1-2', 'SCD Vol 1-2 Ian Muir', '', 0, 0, 1992, 0, '', 2566);
INSERT INTO 'album' VALUES (503, '2006-07-27 22:00:00+00', '2014-02-14 14:00:56.192322+00', 'Scottish Country Dances Vol 3', 'SCD Vol 3 Ian Muir', '', 0, 0, 1994, 0, '', 2566);
INSERT INTO 'album' VALUES (465, '2004-11-24 23:00:00+00', '2014-07-30 13:40:40.357058+00', 'Dark Island, The', 'Dark Island', '', 0, 0, 2004, 0, '', 2501);
INSERT INTO 'album' VALUES (494, '2006-05-07 22:00:00+00', '2012-10-18 13:02:30.398342+00', 'Favourite SCDs Vol. 3 Teacher''s Choice', 'Teacher''s Choice', '', 0, 0, 2006, 0, '', 3678);
INSERT INTO 'album' VALUES (493, '2006-04-27 22:00:00+00', '2012-12-26 11:28:40.860377+00', 'Celtic Fire in the Music', 'Celtic Fire', 'LH', 1, 0, 2006, 0, '', 3067);
INSERT INTO 'album' VALUES (724, '1998-12-03 23:00:00+00', '2012-01-20 12:57:57.389615+00', 'Dance Date No 1', 'Dance Date 1', 'EN', 1, 52, 0, 1, '', 3065);
INSERT INTO 'album' VALUES (727, '1998-11-03 23:00:00+00', '2012-01-20 12:57:57.40215+00', 'Dance with the London Highland Club', 'London HC2', 'NH', 1, 337, 1974, 1, '', 2414);
INSERT INTO 'album' VALUES (729, '1998-07-22 22:00:00+00', '2012-01-20 12:57:57.414555+00', 'Dances of Scotland Volume 3', 'Dances /Scot 3', 'CG', 1, 319, 1973, 1, '', 3024);
INSERT INTO 'album' VALUES (730, '1998-10-13 22:00:00+00', '2012-01-20 12:57:57.420733+00', 'Dances of Scotland', 'Dances / Scot', 'EC', 1, 286, 0, 1, '', 1094);
INSERT INTO 'album' VALUES (732, '1998-11-19 23:00:00+00', '2012-01-20 12:57:57.426933+00', 'Dancing with the Shands', 'Dancing Shands', 'AS', 1, 357, 1994, 1, '', 3061);
INSERT INTO 'album' VALUES (734, '1999-03-23 23:00:00+00', '2012-01-20 12:57:57.43598+00', 'Donside Records presents', 'Donside', 'BC', 1, 143, 1987, 1, '', 3057);
INSERT INTO 'album' VALUES (735, '1998-11-15 23:00:00+00', '2012-01-20 12:57:57.442179+00', 'Ed Brydie and his Scottish Ramblers', 'Ramblers', 'BL', 1, 46, 0, 1, '', 2182);
INSERT INTO 'album' VALUES (737, '1998-12-19 23:00:00+00', '2012-01-20 12:57:57.448441+00', 'English Folk Dances', 'English FD', 'PB', 1, 365, 1973, 1, '', 3010);
INSERT INTO 'album' VALUES (740, '1998-10-11 22:00:00+00', '2012-01-20 12:57:57.454642+00', 'Fiddle Me Jig', 'Fiddle Me Jig', 'JW', 1, 420, 0, 1, '', 3016);
INSERT INTO 'album' VALUES (741, '1998-10-11 22:00:00+00', '2012-01-20 12:57:57.460836+00', 'Fitchet''s Fancy', 'Fitchet''s', 'JW', 1, 134, 1981, 1, '', 2301);
INSERT INTO 'album' VALUES (743, '1998-10-18 22:00:00+00', '2012-01-20 12:57:57.467047+00', 'For Old Tymes Sake', 'For Old Tymes', 'EE', 1, 37, 1996, 1, '', 3067);
INSERT INTO 'album' VALUES (745, '1998-12-29 23:00:00+00', '2012-01-20 12:57:57.476326+00', 'Gay Gordons, Vol 1', 'Gay Gordons 1', 'JW', 1, 162, 0, 1, '', 3026);
INSERT INTO 'album' VALUES (746, '1998-10-11 22:00:00+00', '2012-01-20 12:57:57.48529+00', 'Gay Gordons, Vol 2', 'Gay Gordons 2', 'JW', 1, 163, 0, 1, '', 3026);
INSERT INTO 'album' VALUES (747, '1998-10-27 23:00:00+00', '2012-01-20 12:57:57.494268+00', 'Golden Hour of Scottish Dancing', 'Golden Hour', 'HO', 1, 271, 0, 1, '', 3009);
INSERT INTO 'album' VALUES (748, '1998-10-13 22:00:00+00', '2012-01-20 12:57:57.500442+00', 'Great Scottish Dance Bands Vol 2', 'Great SDB 2', 'EN', 1, 120, 1976, 1, '', 3056);
INSERT INTO 'album' VALUES (749, '2001-06-13 22:00:00+00', '2012-01-20 12:57:57.509436+00', 'Great Scottish Dance Bands Vol 1', 'Great SDB 1', 'JW', 1, 345, 1976, 1, '', 3069);
INSERT INTO 'album' VALUES (750, '1998-11-11 23:00:00+00', '2012-01-20 12:57:57.515654+00', 'See You Jimmy!', 'See You', 'NI', 1, 304, 1995, 1, '', 2183);
INSERT INTO 'album' VALUES (751, '1998-10-18 22:00:00+00', '2012-01-20 12:57:57.521851+00', 'Happy We''ve Been A'' Thegither', 'Happy', 'EN', 1, 335, 1988, 1, '', 2344);
INSERT INTO 'album' VALUES (514, '2007-09-03 22:00:00+00', '2021-08-20 08:28:04.514604+00', 'Dance, Sing and Rejoice', 'Dance, Sing, Rejoice', '', 0, 0, 2007, 0, '', 3030);
INSERT INTO 'album' VALUES (753, '1998-10-18 22:00:00+00', '2012-01-20 12:57:57.53997+00', 'Highland Style', 'Highland Style', 'EN', 1, 56, 0, 1, '', 3059);
INSERT INTO 'album' VALUES (754, '1998-10-18 22:00:00+00', '2012-01-20 12:57:57.543369+00', 'I Love Scotland', 'I Love Scotland', 'EC', 1, 164, 1965, 1, '', 3026);
INSERT INTO 'album' VALUES (755, '1998-10-25 23:00:00+00', '2012-01-20 12:57:57.549554+00', 'Ian Powrie Band Show', 'Band Show', 'EC', 1, 325, 0, 1, '', 2062);
INSERT INTO 'album' VALUES (756, '1998-07-22 22:00:00+00', '2012-01-20 12:57:57.555775+00', 'Island Games', 'Island Games', 'IS', 1, 288, 1991, 1, '', 2029);
INSERT INTO 'album' VALUES (758, '1998-10-12 22:00:00+00', '2012-01-20 12:57:57.561951+00', 'Dance Date No 3', 'Dance Date 3', 'EN', 1, 54, 0, 1, '', 3065);
INSERT INTO 'album' VALUES (771, '1998-10-14 22:00:00+00', '2012-01-20 12:57:57.574574+00', 'More Capital Reels', 'More Capital', 'AS', 1, 10, 1997, 1, '', 2090);
INSERT INTO 'album' VALUES (774, '1999-01-22 23:00:00+00', '2012-01-20 12:57:57.583564+00', 'Music for Collins Pocket Reference. Vol 1', 'Collins Ref 1', 'RS', 1, 105, 1998, 1, '', 3046);
INSERT INTO 'album' VALUES (775, '1998-09-08 22:00:00+00', '2012-01-20 12:57:57.589767+00', 'Music for Collins Pocket Reference. Vol 2', 'Collins Ref 2', 'AP', 1, 106, 1998, 1, '', 3046);
INSERT INTO 'album' VALUES (711, '1998-11-24 23:00:00+00', '2022-08-27 10:26:55.147788+00', 'Back in Step', 'Back in Step', 'CS', 1, 315, 1996, 1, '', 2088);
INSERT INTO 'album' VALUES (777, '1998-10-13 22:00:00+00', '2012-01-20 12:57:57.596008+00', 'Scottish Collection: Music of the Glens', 'Scottish: Glens', 'AS', 1, 433, 1996, 1, '', 3016);
INSERT INTO 'album' VALUES (780, '1999-06-30 22:00:00+00', '2012-01-20 12:57:57.602185+00', 'Bobby MacLeod and his Band', 'MacLeod & Band', 'EN', 1, 260, 0, 1, '', 2328);
INSERT INTO 'album' VALUES (781, '1998-07-17 22:00:00+00', '2012-01-20 12:57:57.608352+00', 'Border Country Dance Band', 'Border DB', 'EC', 1, 33, 1977, 1, '', 2093);
INSERT INTO 'album' VALUES (785, '1998-10-13 22:00:00+00', '2012-01-20 12:57:57.614538+00', 'One More Couple Please', 'One More Couple', 'EN', 1, 351, 1975, 1, '', 2184);
INSERT INTO 'album' VALUES (786, '1999-08-06 22:00:00+00', '2012-01-20 12:57:57.620865+00', 'Pet O'' The Pipers', 'Pet Pipers', 'MB', 1, 313, 0, 1, '', 2185);
INSERT INTO 'album' VALUES (790, '1998-12-30 23:00:00+00', '2012-01-20 12:57:57.63353+00', 'Rob''s Music Box', 'Rob''s Music Box', 'JW', 1, 168, 0, 1, '', 3026);
INSERT INTO 'album' VALUES (803, '1998-10-18 22:00:00+00', '2012-01-20 12:57:57.646011+00', 'Scotland''s Favourite', 'Scotland''s Fav', 'EE', 1, 322, 1979, 1, '', 1811);
INSERT INTO 'album' VALUES (805, '1998-10-15 22:00:00+00', '2012-01-20 12:57:57.652219+00', 'Scottish Accordion Hits Vol. 2', 'S Accordion 2', 'JW', 1, 259, 1977, 1, '', 1605);
INSERT INTO 'album' VALUES (811, '1999-05-25 22:00:00+00', '2012-01-20 12:57:57.658417+00', 'Scottish Country Dances', 'SCD Duncan', 'JW', 1, 118, 0, 1, '', 2317);
INSERT INTO 'album' VALUES (822, '1999-06-24 22:00:00+00', '2012-01-20 12:57:57.664587+00', 'Scottish Country Dances in Strict Tempo', 'Strict Tempo', 'BL', 1, 379, 1957, 1, '', 3010);
INSERT INTO 'album' VALUES (824, '1998-07-22 22:00:00+00', '2012-01-20 12:57:57.670799+00', 'Scottish Dance Masters, The Vol 5', 'SD Masters 5', 'IS', 1, 151, 1991, 1, '', 2231);
INSERT INTO 'album' VALUES (725, '2002-04-08 22:00:00+00', '2023-11-09 00:00:54.65203+00', 'Dance Date No 2', 'Dance Date 2', 'BL', 1, 53, 0, 1, '', 3065);
INSERT INTO 'album' VALUES (728, '1999-04-22 22:00:00+00', '2025-03-24 12:10:23.045699+00', 'Dances Frae the North, Vols 1, 2 & 3', 'North 1, 2 & 3', 'AS', 1, 416, 1997, 1, '', 3016);
INSERT INTO 'album' VALUES (826, '1998-07-16 22:00:00+00', '2012-01-20 12:57:57.677046+00', 'Jimmy Blair''s Scottish Dance Party', 'JB''s SD Party', 'EE', 1, 26, 1961, 1, '', 2038);
INSERT INTO 'album' VALUES (829, '1998-10-25 23:00:00+00', '2012-01-20 12:57:57.689459+00', 'Scottish Dance Masters, The Vol 2', 'SD Masters 2', 'MK', 1, 152, 1984, 1, '', 2379);
INSERT INTO 'album' VALUES (832, '1998-10-15 22:00:00+00', '2012-01-20 12:57:57.695994+00', 'Scottish Pipes for Dancing', 'Pipes/Dancing', 'CG', 1, 344, 1958, 1, '', 1515);
INSERT INTO 'album' VALUES (836, '1998-11-11 23:00:00+00', '2012-01-20 12:57:57.708368+00', 'Scottish Sound of Ron Gonnella Playing a Stradivarius', 'Gonella / Strad', 'BC', 1, 148, 1984, 1, '', 1615);
INSERT INTO 'album' VALUES (841, '1998-10-14 22:00:00+00', '2012-01-20 12:57:57.720921+00', 'Skip Change with Scotch Measure', 'Skip Change', 'AS', 1, 349, 1997, 1, '', 2339);
INSERT INTO 'album' VALUES (847, '1998-07-16 22:00:00+00', '2012-01-20 12:57:57.727237+00', 'Happy Meeting, The', 'Happy Meeting', 'BC', 1, 144, 1988, 1, '', 3057);
INSERT INTO 'album' VALUES (849, '1998-07-16 22:00:00+00', '2012-01-20 12:57:57.733491+00', 'Kirrie Lads, The', 'Kirrie Lads', 'CS', 1, 92, 1998, 1, '', 2188);
INSERT INTO 'album' VALUES (852, '1998-07-17 22:00:00+00', '2012-01-20 12:57:57.742476+00', 'Tartan Track, The', 'Tartan Track', 'EE', 1, 206, 0, 1, '', 1701);
INSERT INTO 'album' VALUES (853, '1998-11-24 23:00:00+00', '2012-01-20 12:57:57.748674+00', 'This Lasting Pride', 'Lasting Pride', 'BC', 1, 91, 1989, 1, '', 3018);
INSERT INTO 'album' VALUES (854, '1998-11-20 23:00:00+00', '2012-01-20 12:57:57.754871+00', 'Top Scotch', 'Top Scotch', 'AS', 1, 245, 1994, 1, '', 3025);
INSERT INTO 'album' VALUES (856, '1999-05-25 22:00:00+00', '2012-01-20 12:57:57.76107+00', 'Two More Couples Please', '2 More Couples', 'JW', 1, 352, 1976, 1, '', 2184);
INSERT INTO 'album' VALUES (864, '1998-10-27 23:00:00+00', '2012-01-20 12:57:57.767277+00', 'Welcome to Tayside', 'WelcomeTayside', 'EC', 1, 293, 0, 1, '', 2397);
INSERT INTO 'album' VALUES (869, '1999-05-25 22:00:00+00', '2012-01-20 12:57:57.782954+00', 'Book 23. Twelve Modern Scottish Country Dances', 'RSCDS 23', 'AP', 1, 354, 1998, 1, '', 3050);
INSERT INTO 'album' VALUES (870, '1999-05-25 22:00:00+00', '2012-01-20 12:57:57.79197+00', 'Book 24, Twelve Scottish Country Dances', 'RSCDS 24', 'AP', 1, 228, 1998, 1, '', 3002);
INSERT INTO 'album' VALUES (871, '1998-08-13 22:00:00+00', '2012-01-20 12:57:57.800992+00', 'Dancing Live', 'Dancing Live', 'AP', 1, 226, 1998, 1, '', 2236);
INSERT INTO 'album' VALUES (872, '1998-09-10 22:00:00+00', '2012-01-20 12:57:57.807204+00', 'Come More Scottish Country Dancing', 'Come More SCD', 'AP', 1, 2, 1998, 1, '', 3032);
INSERT INTO 'album' VALUES (875, '2002-05-05 22:00:00+00', '2012-01-20 12:57:57.816147+00', 'Special Requests Volume 3', 'Sp.Requests 3', 'AP', 1, 108, 1998, 1, '', 3046);
INSERT INTO 'album' VALUES (876, '1998-08-13 22:00:00+00', '2012-01-20 12:57:57.825223+00', 'Haste Ye Back', 'Haste Ye', 'AP', 1, 236, 1998, 1, '', 3002);
INSERT INTO 'album' VALUES (878, '1998-10-13 22:00:00+00', '2012-01-20 12:57:57.831507+00', 'Fifteen Dances, Part Two', '15 Dances - 2', 'AP', 1, 422, 1991, 1, '', 3016);
INSERT INTO 'album' VALUES (879, '2009-08-02 22:00:00+00', '2012-01-20 12:57:57.837756+00', 'Dance for Joy!', 'Dance for Joy!', '', 0, 0, 2009, 0, '', 10000);
INSERT INTO 'album' VALUES (880, '2009-08-02 22:00:00+00', '2012-01-20 12:57:57.84396+00', 'Music for Scottish Country Dancing', 'Music for SCD', '', 0, 0, 2008, 0, '', 10008);
INSERT INTO 'album' VALUES (881, '2009-08-02 22:00:00+00', '2012-01-20 12:57:57.850136+00', 'Silver Tassie and other Favourite Dances', 'Silver Tassie', '', 0, 0, 2008, 0, '', 2586);
INSERT INTO 'album' VALUES (882, '2009-08-02 22:00:00+00', '2012-01-20 12:57:57.856338+00', 'Todlen Hame and other Favourite Dances', 'Todlen Hame', '', 0, 0, 2008, 0, '', 2586);
INSERT INTO 'album' VALUES (868, '1999-04-21 22:00:00+00', '2012-04-27 17:11:26.461708+00', 'RSCDS 75th Anniversary Dances', 'RSCDS 75th Anniv', 'AP', 1, 296, 1998, 1, '', 3071);
INSERT INTO 'album' VALUES (827, '1998-10-12 22:00:00+00', '2013-01-03 11:29:40.224437+00', 'Scottish Dances', 'S Dances (AD)', 'JW', 1, 117, 1962, 1, '', 2246);
INSERT INTO 'album' VALUES (883, '2009-10-17 22:00:00+00', '2012-01-20 12:57:57.862549+00', 'Book 11. Music for 12 Scottish Country Dances', 'Book 11', '', 0, 0, 2008, 0, '', 3049);
INSERT INTO 'album' VALUES (884, '2009-10-18 22:00:00+00', '2012-01-20 12:57:57.86881+00', 'Angus Welcome, An', 'Angus Welcome', '', 0, 0, 2008, 0, '', 3032);
INSERT INTO 'album' VALUES (885, '2009-10-18 22:00:00+00', '2012-01-20 12:57:57.87499+00', 'Book 34. Music for 11 Scottish Country Dances (Book 34 plus 3 Dances 2006)', 'Book 34 plus 3', '', 0, 0, 2007, 0, '', 10018);
INSERT INTO 'album' VALUES (886, '2009-10-18 22:00:00+00', '2012-01-20 12:57:57.881195+00', 'That Pinewoods Sound!', 'Pinewoods Sound', '', 0, 0, 2008, 0, '', 10019);
INSERT INTO 'album' VALUES (888, '2009-11-02 23:00:00+00', '2012-01-20 12:57:57.893535+00', 'Special Requests Volume 7', 'Sp Requests 7', '', 0, 0, 2007, 0, '', 3023);
INSERT INTO 'album' VALUES (889, '2009-11-03 23:00:00+00', '2012-01-20 12:57:57.899761+00', 'Take Your Partners For Vol 2', 'Take Your Partners 2', '', 0, 0, 2009, 0, '', 10034);
INSERT INTO 'album' VALUES (890, '2009-11-04 23:00:00+00', '2012-01-20 12:57:57.906028+00', 'Book 35. Music for Eight Scottish Country Dances', 'Book 35', '', 0, 0, 2006, 0, '', 3137);
INSERT INTO 'album' VALUES (892, '2009-11-04 23:00:00+00', '2012-01-20 12:57:57.918843+00', 'Take Your Partners For Vol 1', 'Take Your Partners 1', '', 0, 0, 2008, 0, '', 10034);
INSERT INTO 'album' VALUES (894, '2009-11-05 23:00:00+00', '2012-01-20 12:57:57.931256+00', '2008 Pittsburgh Ball', '2008 Pittsburgh Ball', '', 0, 0, 2008, 0, '', 3030);
INSERT INTO 'album' VALUES (896, '2009-11-05 23:00:00+00', '2012-01-20 12:57:57.943749+00', 'Live at Opotiki, Music for a Whale of a Time', 'Live at Opotiki', '', 0, 0, 2009, 0, '', 3420);
INSERT INTO 'album' VALUES (897, '2009-11-05 23:00:00+00', '2012-01-20 12:57:57.949974+00', 'Book 30. Music for Book 30 plus 3 Dances by Hugh Foss', 'Book 30', '', 0, 0, 2007, 0, '', 3006);
INSERT INTO 'album' VALUES (898, '2009-11-05 23:00:00+00', '2012-01-20 12:57:57.956311+00', 'Book 27. Music for Twelve Scottish Country Dances', 'Book 27', '', 0, 0, 2006, 0, '', 2944);
INSERT INTO 'album' VALUES (899, '2009-11-06 23:00:00+00', '2012-01-20 12:57:57.962525+00', 'Book 20. Music for Twelve Scottish Country Dances', 'Book 20', '', 0, 0, 2008, 0, '', 3045);
INSERT INTO 'album' VALUES (903, '2009-11-08 23:00:00+00', '2012-01-20 12:57:57.987782+00', 'To the Laird', 'To the Laird', '', 0, 0, 2009, 0, '2CD''s', 2681);
INSERT INTO 'album' VALUES (904, '2009-11-10 23:00:00+00', '2012-01-20 12:57:57.99408+00', 'Vallin Suite 2, The', 'Vallin 2', '', 0, 0, 2007, 0, '', 3006);
INSERT INTO 'album' VALUES (905, '2009-11-10 23:00:00+00', '2012-01-20 12:57:58.0003+00', 'Vallin Suite 3, The', 'Vallin 3', '', 0, 0, 2008, 0, '', 10018);
INSERT INTO 'album' VALUES (906, '2009-11-10 23:00:00+00', '2012-01-20 12:57:58.006501+00', 'Vallin Suite 4, The', 'Vallin 4', '', 0, 0, 2008, 0, '', 3023);
INSERT INTO 'album' VALUES (907, '2009-11-15 23:00:00+00', '2012-01-20 12:57:58.012695+00', 'Ruthven Collection Vol 2, The', 'Ruthven 2', '', 0, 0, 2009, 0, '', 3023);
INSERT INTO 'album' VALUES (909, '2009-11-17 23:00:00+00', '2012-01-20 12:57:58.025106+00', 'Heather Hills', 'Heather Hills', '', 0, 0, 2009, 0, '', 10070);
INSERT INTO 'album' VALUES (910, '2009-11-17 23:00:00+00', '2012-01-20 12:57:58.031785+00', 'Music for 12 Perth Dances', '12 Perth Dances', '', 0, 0, 2008, 0, '', 10037);
INSERT INTO 'album' VALUES (911, '2009-11-17 23:00:00+00', '2012-01-20 12:57:58.038118+00', 'Reel On - Roy Goldring''s Graded and Social Dances 3', 'Reel On', '', 0, 0, 2009, 0, '', 10076);
INSERT INTO 'album' VALUES (891, '2009-11-04 23:00:00+00', '2012-12-26 11:41:49.512984+00', 'Book 14. Music for Twelve Scottish Country Dances', 'Book 14', '', 0, 0, 2006, 0, '', 10037);
INSERT INTO 'album' VALUES (893, '2009-11-05 23:00:00+00', '2012-12-26 11:45:30.525461+00', 'Book 13. Music for 12 Scottish Country Dances', 'Book 13', '', 0, 0, 2007, 0, '', 3011);
INSERT INTO 'album' VALUES (915, '2009-11-22 23:00:00+00', '2012-01-20 12:57:58.063789+00', 'Very Best of Stan Hamilton, The', 'Best of Hamilton', '', 0, 0, 2009, 0, '', 3016);
INSERT INTO 'album' VALUES (916, '2009-11-22 23:00:00+00', '2012-01-20 12:57:58.070061+00', 'Dance Goes On, The', 'Dance Goes On', '', 0, 0, 2009, 0, '', 2029);
INSERT INTO 'album' VALUES (800, '1998-10-27 23:00:00+00', '2022-12-22 22:22:09.618343+00', 'Scotland Swings Again with the Great Jim MacLeod', 'Scotland Swings', 'EE', 1, 274, 1969, 1, 'Album cover shows no playing time for tracks.', 3009);
INSERT INTO 'album' VALUES (922, '2009-11-23 23:00:00+00', '2012-01-20 12:57:58.09485+00', 'Tribute to Derek Haynes, A', 'Tribute to Derek', '', 0, 0, 2007, 0, '', 3045);
INSERT INTO 'album' VALUES (923, '2009-11-26 23:00:00+00', '2012-01-20 12:57:58.101031+00', 'Original Lindsay Ross, The', 'Lindsay Ross', '', 0, 0, 2004, 0, '', 3069);
INSERT INTO 'album' VALUES (924, '2009-11-28 23:00:00+00', '2012-01-20 12:57:58.107228+00', 'Let''s Celebrate', 'Let''s Celebrate', '', 0, 0, 2006, 0, '', 10104);
INSERT INTO 'album' VALUES (925, '2009-11-29 23:00:00+00', '2012-01-20 12:57:58.113402+00', 'Transatlantic Ties', 'Transatlantic', '', 0, 0, 2007, 0, '', 1836);
INSERT INTO 'album' VALUES (926, '2009-11-29 23:00:00+00', '2012-01-20 12:57:58.119585+00', 'Favourite SCDs Vol 1', 'Favourite SCDs 1', '', 0, 0, 2004, 0, '', 3678);
INSERT INTO 'album' VALUES (927, '2009-11-30 23:00:00+00', '2012-01-20 12:57:58.126037+00', 'Favourite SCDs Vol 2', 'Favourite SCDs 2', '', 0, 0, 2005, 0, '', 3678);
INSERT INTO 'album' VALUES (928, '2009-11-30 23:00:00+00', '2012-01-20 12:57:58.132274+00', 'Dance o da Shetland Puffins', 'Shetland Puffins', '', 0, 0, 2003, 0, '', 10108);
INSERT INTO 'album' VALUES (929, '2009-12-01 23:00:00+00', '2012-01-20 12:57:58.13847+00', 'Crossing Borders', 'Crossing Borders', '', 0, 0, 2008, 0, '', 10114);
INSERT INTO 'album' VALUES (930, '2009-12-01 23:00:00+00', '2012-01-20 12:57:58.144768+00', 'Ruthven Collection, The', 'Ruthven', '', 0, 0, 2007, 0, '', 3023);
INSERT INTO 'album' VALUES (932, '2009-12-02 23:00:00+00', '2012-01-20 12:57:58.157679+00', 'Dusk Till Dawn', 'Dusk Till Dawn', '', 0, 0, 1996, 0, '', 2585);
INSERT INTO 'album' VALUES (933, '2009-12-02 23:00:00+00', '2012-01-20 12:57:58.164034+00', 'Thank You For Coming', 'Thank You', '', 0, 0, 2006, 0, '', 10117);
INSERT INTO 'album' VALUES (934, '2009-12-03 23:00:00+00', '2012-01-20 12:57:58.170257+00', 'Faculty of Actuaries, The', 'Faculty of Actuaries', '', 0, 0, 2006, 0, '', 10128);
INSERT INTO 'album' VALUES (935, '2009-12-06 23:00:00+00', '2012-01-20 12:57:58.176463+00', 'Bluebonnet Ball 2004', 'Bluebonnet2004', '', 0, 0, 2004, 0, '', 10129);
INSERT INTO 'album' VALUES (913, '2009-11-21 23:00:00+00', '2023-08-28 11:06:31.390905+00', 'Diamond Jubilee Dances - Belfast Branch', 'Belfast Diamond Jubilee', '', 0, 0, 2008, 0, '', 3217);
INSERT INTO 'album' VALUES (931, '2009-12-02 23:00:00+00', '2023-08-28 11:28:19.713186+00', 'Second Sheaf Collection, The', 'Sheaf Coll 2', '', 0, 0, 2005, 0, '', 10117);
INSERT INTO 'album' VALUES (902, '2009-11-08 23:00:00+00', '2023-08-28 11:33:31.54138+00', 'TAC 50th Anniversary Collection', 'TAC 50th Anniversary', '', 0, 0, 2008, 0, '', 3067);
INSERT INTO 'album' VALUES (895, '2009-11-05 23:00:00+00', '2023-08-28 11:38:15.31225+00', 'To Be A Wind', 'To Be A Wind', '', 0, 0, 2009, 0, '', 1836);
INSERT INTO 'album' VALUES (936, '2009-12-09 23:00:00+00', '2012-01-20 12:57:58.182727+00', 'Take Your Seats', 'Take Your Seats', '', 0, 0, 2006, 0, '', 3014);
INSERT INTO 'album' VALUES (937, '2009-12-16 23:00:00+00', '2012-01-20 12:57:58.188915+00', 'Jim Cameron''s Scottish Dance Band Vol 1', 'Jim Cameron 1', '', 0, 0, 2001, 0, '', 3065);
INSERT INTO 'album' VALUES (938, '2009-12-16 23:00:00+00', '2012-01-20 12:57:58.195144+00', 'Jim Cameron''s Scottish Dance Band Vol 2', 'Jim Cameron 2', '', 0, 0, 2001, 0, '', 3065);
INSERT INTO 'album' VALUES (939, '2009-12-16 23:00:00+00', '2012-01-20 12:57:58.201334+00', 'Jim Cameron''s Scottish Dance Band Vol 3', 'Jim Cameron 3', '', 0, 0, 2002, 0, '', 3065);
INSERT INTO 'album' VALUES (940, '2009-12-16 23:00:00+00', '2012-01-20 12:57:58.20753+00', 'Nice to See You Again', 'See You Again', '', 0, 0, 2009, 0, '', 2188);
INSERT INTO 'album' VALUES (941, '2009-12-16 23:00:00+00', '2012-01-20 12:57:58.213727+00', 'Tim Wright and his Scottish Dance Band', 'Tim Wright', '', 0, 0, 2007, 0, '', 10141);
INSERT INTO 'album' VALUES (942, '2009-12-22 23:00:00+00', '2012-01-20 12:57:58.219907+00', 'Strathearn - Early Days', 'Strathearn', '', 0, 0, 1967, 0, '', 10142);
INSERT INTO 'album' VALUES (943, '2009-12-22 23:00:00+00', '2012-01-20 12:57:58.226076+00', 'Old Scottish Dance Bands Vol 1, The', 'Old Bands 1', '', 0, 0, 2009, 0, '', 3016);
INSERT INTO 'album' VALUES (944, '2009-12-22 23:00:00+00', '2012-01-20 12:57:58.232306+00', 'Old Scottish Dance Bands Vol 2, The', 'Old Bands 2', '', 0, 0, 2009, 0, '', 3016);
INSERT INTO 'album' VALUES (945, '2009-12-27 23:00:00+00', '2012-01-20 12:57:58.238583+00', 'Robert Burns Dances', 'Burns Dances', '', 0, 0, 2009, 0, '', 3217);
INSERT INTO 'album' VALUES (947, '2010-01-25 23:00:00+00', '2012-01-20 12:57:58.251064+00', 'Silver Spire, The', 'Silver Spire', '', 0, 0, 2009, 0, '', 3012);
INSERT INTO 'album' VALUES (948, '2010-02-13 23:00:00+00', '2012-01-20 12:57:58.25727+00', 'Schottische Tänze', 'Schottische Tänze', '', 0, 0, 1999, 0, '', 10157);
INSERT INTO 'album' VALUES (901, '2009-11-07 23:00:00+00', '2013-04-10 08:10:42.059176+00', 'Book 9. Music for 18 Scottish Country Dances (Book 9 plus 4 Dances 2008 and 2 dances for Eileen Watt)', 'Book 9 plus 6', '', 0, 0, 2008, 0, '', 3016);
INSERT INTO 'album' VALUES (950, '2010-05-29 22:00:00+00', '2012-01-20 12:57:58.269622+00', 'Celtic Steps', 'Celtic Steps', '', 0, 0, 2005, 0, '', 10046);
INSERT INTO 'album' VALUES (951, '2010-05-30 22:00:00+00', '2012-01-20 12:57:58.275816+00', 'Vintage 78''s Vol 2', 'Vintage 78 2', '', 0, 0, 2003, 0, '', 2328);
INSERT INTO 'album' VALUES (952, '2010-05-30 22:00:00+00', '2012-01-20 12:57:58.281996+00', '25th Anniversary Dances, RSCDS Tokyo Branch', '25 Years Tokyo Branch', '', 0, 0, 2009, 0, '', 10176);
INSERT INTO 'album' VALUES (953, '2010-05-31 22:00:00+00', '2012-01-20 12:57:58.288189+00', 'Let''s Go Scottish Country Dancing Vol 1', 'Let''s Go SCD 1', '', 0, 0, 2009, 0, '', 3026);
INSERT INTO 'album' VALUES (954, '2010-06-01 22:00:00+00', '2012-01-20 12:57:58.294513+00', 'Old Tyme Favourites Vol 1', 'Old Tyme Fav 1', '', 0, 0, 2009, 0, '', 10177);
INSERT INTO 'album' VALUES (955, '2010-06-07 22:00:00+00', '2012-01-20 12:57:58.300728+00', 'Fraser McGlynn and his Scottish Dance Band', 'Fraser McGlynn', '', 0, 0, 2009, 0, '', 10183);
INSERT INTO 'album' VALUES (956, '2010-08-07 22:00:00+00', '2012-01-20 12:57:58.306909+00', 'Book 6. Music for Twelve Traditional Dances', 'Book 6', '', 0, 0, 2005, 0, '', 3011);
INSERT INTO 'album' VALUES (957, '2010-08-07 22:00:00+00', '2012-01-20 12:57:58.313172+00', 'Book 7 plus 2 Dances for 2009', 'Book VII', '', 0, 0, 2010, 0, '', 3006);
INSERT INTO 'album' VALUES (959, '2010-08-08 22:00:00+00', '2012-01-20 12:57:58.325612+00', 'Book 46', 'Book XLVI', '', 0, 0, 2010, 0, '', 3019);
INSERT INTO 'album' VALUES (961, '2010-08-31 22:00:00+00', '2012-01-20 12:57:58.338042+00', 'Early Days - John Crawford', 'John Crawford', '', 0, 0, 2005, 0, '', 10186);
INSERT INTO 'album' VALUES (964, '2010-09-02 22:00:00+00', '2012-01-20 12:57:58.356649+00', 'Corryvrechan Live in Concert', 'Corryvrechan Live', '', 0, 0, 2009, 0, '', 3479);
INSERT INTO 'album' VALUES (965, '2010-09-03 22:00:00+00', '2012-01-20 12:57:58.36298+00', 'Between the Bridges', 'Perth Bridges', '', 0, 0, 2009, 0, '', 10200);
INSERT INTO 'album' VALUES (918, '2009-11-23 23:00:00+00', '2018-10-25 09:28:28.715308+00', 'Double Take', 'Double Take', '', 0, 0, 2009, 0, '', 10095);
INSERT INTO 'album' VALUES (967, '2010-09-15 22:00:00+00', '2012-01-20 12:57:58.375482+00', 'Are ye askin''? - The Reel Party', 'Are ye askin''?', '', 0, 0, 2007, 0, '', 10209);
INSERT INTO 'album' VALUES (969, '2010-09-16 22:00:00+00', '2012-01-20 12:57:58.387861+00', 'Are ye dancin''? - The Ceilidh', 'Are ye dancin''?', '', 0, 0, 2006, 0, '', 10209);
INSERT INTO 'album' VALUES (970, '2010-09-20 22:00:00+00', '2012-01-20 12:57:58.394043+00', 'Purely Traditional', 'Purely Trad', '', 0, 0, 2007, 0, '', 10233);
INSERT INTO 'album' VALUES (972, '2010-10-07 22:00:00+00', '2012-01-20 12:57:58.406497+00', 'Highlander Music Scottish Dances Vol 14', 'Highlander SD 14', '', 0, 0, 2010, 0, '', 10247);
INSERT INTO 'album' VALUES (1069, '2014-03-26 14:26:24.850006+00', '2018-10-25 21:46:38.522216+00', 'Jim Mackay Scottish Dance Band, The', 'Jim Mackay', '', 0, 0, 2013, 0, '', 10936);
INSERT INTO 'album' VALUES (974, '2010-10-13 22:00:00+00', '2012-01-20 12:57:58.418957+00', 'Special Requests Volume 8', 'Sp Requests 8', '', 0, 0, 2010, 0, '', 3023);
INSERT INTO 'album' VALUES (975, '2010-10-15 22:00:00+00', '2012-01-20 12:57:58.425151+00', 'Old Tyme Favourites Vol 2', 'Old Tyme Fav 2', '', 0, 0, 2010, 0, '', 10177);
INSERT INTO 'album' VALUES (976, '2010-10-16 22:00:00+00', '2012-01-20 12:57:58.43133+00', 'William Hannah and his Band', 'William Hannah', '', 0, 0, 2010, 0, '', 10267);
INSERT INTO 'album' VALUES (977, '2010-10-17 22:00:00+00', '2012-01-20 12:57:58.437627+00', 'Kirrie Selection', 'Kirrie Selection', '', 0, 0, 2010, 0, '', 3065);
INSERT INTO 'album' VALUES (978, '2010-10-18 22:00:00+00', '2012-01-20 12:57:58.443858+00', 'All Set Volume One', 'All Set 1', '', 0, 0, 2006, 0, '', 10268);
INSERT INTO 'album' VALUES (979, '2010-10-18 22:00:00+00', '2012-01-20 12:57:58.450048+00', 'On the Rocks', 'On the Rocks', '', 0, 0, 2010, 0, '', 10037);
INSERT INTO 'album' VALUES (980, '2010-10-19 22:00:00+00', '2012-01-20 12:57:58.456284+00', 'Essential Scottish Dance Bands Collection, The', 'Essential SDBs', '', 0, 0, 2006, 0, '', 3016);
INSERT INTO 'album' VALUES (981, '2010-10-20 22:00:00+00', '2012-01-20 12:57:58.462506+00', '20 Scottish Favourites', '20 Favourites', '', 0, 0, 2010, 0, '', 3026);
INSERT INTO 'album' VALUES (982, '2010-10-26 22:00:00+00', '2012-01-20 12:57:58.468726+00', 'Scottish Sound of the Bill Hendry Dance Band, The', 'Bill Hendry', '', 0, 0, 2010, 0, '', 10277);
INSERT INTO 'album' VALUES (983, '2010-10-27 22:00:00+00', '2012-01-20 12:57:58.474909+00', 'Fisherman''s Reel, The', 'Fisherman', '', 0, 0, 2010, 0, '', 3217);
INSERT INTO 'album' VALUES (984, '2010-10-27 22:00:00+00', '2012-01-20 12:57:58.481138+00', 'Dashing White Sergeant, The', 'White Sergeant', '', 0, 0, 2004, 0, '', 10104);
INSERT INTO 'album' VALUES (985, '2011-01-20 23:00:00+00', '2012-01-20 12:57:58.487346+00', 'Let''s Go Scottish Country Dancing Vol 2', 'Let''s Go SCD 2', '', 0, 0, 2010, 0, '', 10296);
INSERT INTO 'album' VALUES (960, '2010-08-29 22:00:00+00', '2012-12-26 11:24:31.884261+00', 'King of the Button Box', 'Shand Button Box', '', 0, 0, 2007, 0, '', 3010);
INSERT INTO 'album' VALUES (962, '2010-08-31 22:00:00+00', '2012-12-26 11:26:10.350461+00', 'King of the Button Box Vol 2', 'Shand Button Box 2', '', 0, 0, 2008, 0, '', 3010);
INSERT INTO 'album' VALUES (986, '2011-02-17 23:00:00+00', '2012-12-26 11:46:41.643105+00', 'Black Watch Ball, The', 'Black Watch Ball', '', 0, 0, 2010, 0, '', 10659);
INSERT INTO 'album' VALUES (987, '2011-04-25 22:00:00+00', '2012-01-20 12:57:58.499762+00', 'Ruthven Collection ''Black Watch Edition'', The', 'Ruthven Black Watch', '', 0, 0, 2011, 0, '', 3023);
INSERT INTO 'album' VALUES (988, '2011-06-13 22:00:00+00', '2012-01-20 12:57:58.506014+00', 'Three Hands Across', '', '', 0, 0, 2011, 0, '', 10330);
INSERT INTO 'album' VALUES (989, '2011-08-18 22:00:00+00', '2012-01-20 12:57:58.512218+00', 'Scottish Country Dances', '', '', 0, 0, 1962, 0, '', 10381);
INSERT INTO 'album' VALUES (990, '2011-09-14 22:00:00+00', '2012-01-20 12:57:58.518494+00', 'Scottish Country Dancing Volume 3 (Music for Collins Pocket Reference. Vol 3)', 'Collins Vol3', '', 0, 0, 2011, 0, '', 3023);
INSERT INTO 'album' VALUES (996, '2011-11-04 23:00:00+00', '2012-01-20 12:57:58.537303+00', 'Saint Andrews Collection of Step Dances, The', 'St Andrews Coll', '', 0, 0, 2010, 0, '', 2586);
INSERT INTO 'album' VALUES (999, '2011-11-17 23:00:00+00', '2012-01-20 12:57:58.555967+00', 'Saint Bernard''s Waltz', 'St Bernard''s Waltz', '', 0, 0, 2005, 0, '', 3217);
INSERT INTO 'album' VALUES (1000, '2011-11-25 23:00:00+00', '2012-01-20 12:57:58.56222+00', 'Reflecting on Rankine', 'Reflecting on Rankine', '', 0, 0, 2010, 0, '', 10525);
INSERT INTO 'album' VALUES (1003, '2011-11-26 23:00:00+00', '2012-01-20 12:57:58.580954+00', 'Strikes Again', 'Strikes Again', '', 0, 0, 1998, 0, '', 10108);
INSERT INTO 'album' VALUES (1004, '2011-11-26 23:00:00+00', '2012-01-20 12:57:58.588648+00', 'Advance & Retire', 'Advance & Retire', '', 0, 0, 2005, 0, '', 10541);
INSERT INTO 'album' VALUES (1005, '2011-11-28 23:00:00+00', '2012-01-20 12:57:58.594887+00', 'Twenty Scottish Dance Bands Vol 1', '20 SCD Bands Vol 1', '', 0, 0, 2000, 0, '', 3016);
INSERT INTO 'album' VALUES (1006, '2011-11-28 23:00:00+00', '2012-01-20 12:57:58.601117+00', 'Twenty Scottish Dance Bands Vol 2', '20 SCD Bands Vol 2', '', 0, 0, 2000, 0, '', 3016);
INSERT INTO 'album' VALUES (991, '2011-09-21 22:00:00+00', '2012-09-16 15:47:54.495546+00', 'Reel of the Puffins', 'Puffins', '', 0, 0, 2011, 0, '', 10659);
INSERT INTO 'album' VALUES (997, '2011-11-07 23:00:00+00', '2012-12-26 11:18:45.032818+00', 'Live From C Sharp', 'Pinewoods 2010', '', 0, 0, 2011, 0, 'Album consists of 2 disks



Pinewoods 2010 Ensemble:



fiddles:  Paul Anderson, Hanneke Cassel, Calum Pasqua, Susan Worland

piano:   Susie Petrow, Tom Pixton

bass:    Barbara Pixton

pipes:   Mike MacNintch

with David Knight, fiddle

       Rosalind Buda, bassoon

', 10503);
INSERT INTO 'album' VALUES (1001, '2011-11-25 23:00:00+00', '2013-01-05 14:42:32.561976+00', 'Foaming Sea, The', 'Foaming Sea', '', 0, 0, 1997, 0, '', 10108);
INSERT INTO 'album' VALUES (1002, '2011-11-25 23:00:00+00', '2013-01-05 15:16:46.903466+00', 'Shetland Dance, A', 'A Shetland Dance', '', 0, 0, 2001, 0, '', 10108);
INSERT INTO 'album' VALUES (1007, '2011-11-29 23:00:00+00', '2012-01-20 12:57:58.607321+00', 'Vancouver - 20th Anniversary', 'Vancouver 20th', '', 0, 0, 2010, 0, '', 10551);
INSERT INTO 'album' VALUES (1008, '2011-11-29 23:00:00+00', '2012-01-20 12:57:58.613695+00', 'Salute Alasdair Heron', 'Salute Alasdair', '', 0, 0, 2010, 0, '', 2503);
INSERT INTO 'album' VALUES (949, '2010-04-14 22:00:00+00', '2023-08-28 10:59:44.653309+00', 'Ayr Branch 75th Anniversary Dances', 'Ayr Branch 75', '', 0, 0, 2008, 0, '', 2566);
INSERT INTO 'album' VALUES (908, '2009-11-16 23:00:00+00', '2023-08-28 11:05:46.835131+00', 'Diamond Jubilee Collection - Inverness & District Branch, The', 'Diamond Jubilee - Inverness', '', 0, 0, 2009, 0, '', 3023);
INSERT INTO 'album' VALUES (1009, '2011-12-01 23:00:00+00', '2012-01-20 12:57:58.61992+00', 'Reel Tradition, The', 'Reel Tradition', '', 0, 0, 2006, 0, '', 10553);
INSERT INTO 'album' VALUES (1010, '2011-12-02 23:00:00+00', '2012-01-20 12:57:58.6264+00', 'Peter Davidson and his Inverness Country Dance Band', 'Peter Davidson Band', '', 0, 0, 2009, 0, '', 10148);
INSERT INTO 'album' VALUES (1011, '2011-12-05 23:00:00+00', '2012-01-20 12:57:58.632862+00', 'Best of Donny & Diane''s Highland Ceilidh Band, The', 'Best of Donny & Diane', '', 0, 0, 2011, 0, '', 10555);
INSERT INTO 'album' VALUES (1012, '2011-12-05 23:00:00+00', '2012-01-20 12:57:58.639153+00', 'Highland Accordion Maestro', 'Accordion Maestro', '', 0, 0, 2011, 0, '', 2328);
INSERT INTO 'album' VALUES (1013, '2011-12-06 23:00:00+00', '2012-01-20 12:57:58.647915+00', 'Whistling Rufus', 'Whistling Rufus', '', 0, 0, 2011, 0, '', 3010);
INSERT INTO 'album' VALUES (1014, '2011-12-07 23:00:00+00', '2012-01-20 12:57:58.6544+00', 'Six For Sixty', 'Six For Sixty', '', 0, 0, 2007, 0, '', 10569);
INSERT INTO 'album' VALUES (231, '1999-01-30 23:00:00+00', '2013-03-09 10:59:14.173791+00', 'Sounds Scottish', 'Sounds Scottish', 'PM', 1, 189, 0, 1, '', 3051);
INSERT INTO 'album' VALUES (966, '2010-09-05 22:00:00+00', '2014-05-10 22:39:15.260936+00', 'Eight Bars of Magic', 'Eight Bars', '', 0, 0, 2010, 0, '', 10204);
INSERT INTO 'album' VALUES (971, '2010-09-20 22:00:00+00', '2014-11-11 16:05:02.055168+00', 'Music for 16 dances from the Ribble Valley Book', 'Ribble Valley', '', 0, 0, 2010, 0, '', 10237);
INSERT INTO 'album' VALUES (1064, '2014-03-13 18:19:19.325535+00', '2014-03-14 16:08:32.852221+00', 'Take Your Partners For Vol 4', 'Take Your Partners 4', '', 0, 0, 2014, 0, '', 10034);
INSERT INTO 'album' VALUES (412, '2002-06-16 22:00:00+00', '2014-03-14 16:40:34.98726+00', 'Reels and Wheels', 'Reels/Wheels', 'BB', 1, 0, 2001, 2, 'The booklet has full cribs for all the 17 dances.', 3050);
INSERT INTO 'album' VALUES (1058, '2014-02-06 15:19:46.03167+00', '2014-02-06 19:30:50.649741+00', 'Another Scottish Ramble', 'Another Scottish Ramble', '', 0, 0, 2013, 0, '', 2681);
INSERT INTO 'album' VALUES (481, '2005-08-08 22:00:00+00', '2013-04-10 06:20:58.483688+00', 'Book 2. Music for Eleven Traditional Dances +1', '', '', 0, 0, 2003, 0, '', 3016);
INSERT INTO 'album' VALUES (79, '1999-05-25 22:00:00+00', '2013-04-10 06:21:41.603439+00', 'Book 3. Music for Twelve Traditional Dances', 'RSCDS 3', 'AP', 1, 79, 1986, 1, '', 3018);
INSERT INTO 'album' VALUES (104, '1998-11-20 23:00:00+00', '2013-04-10 06:27:54.203198+00', 'Book 6. Music for Twelve Traditional Dances', 'RSCDS 6', 'PM', 1, 13, 1986, 1, '', 3011);
INSERT INTO 'album' VALUES (900, '2009-11-07 23:00:00+00', '2013-04-10 06:29:15.240099+00', 'Book 8. Music for 12 Scottish Country Dances', 'Book 8', '', 0, 0, 2009, 0, '', 10659);
INSERT INTO 'album' VALUES (12, '2000-04-04 22:00:00+00', '2013-04-10 09:57:42.954413+00', 'Highlander Music Scottish Dances Vol 3', 'Highlander SD 3', 'AP', 1, 99, 1996, 1, '', 3006);
INSERT INTO 'album' VALUES (317, '2000-04-04 22:00:00+00', '2013-04-10 09:58:33.099165+00', 'Highlander Music Scottish Dances Vol 6', 'Highlander SD 6', 'AP', 1, 65, 1999, 1, '', 2570);
INSERT INTO 'album' VALUES (322, '2000-04-04 22:00:00+00', '2013-04-10 09:59:00.952508+00', 'Highlander Music Scottish Dances Vol 8', 'Highlander SD 8', 'AP', 1, 5, 1999, 1, '', 2584);
INSERT INTO 'album' VALUES (968, '2010-09-15 22:00:00+00', '2017-07-27 15:18:33.381798+00', 'Ah''m askin'' - Scottish Country Dances', 'Ah''m askin''', '', 0, 0, 2010, 0, '', 10209);
INSERT INTO 'album' VALUES (1073, '2014-04-29 16:55:32.683061+00', '2014-04-29 17:45:11.393986+00', 'Sound of Scotland, The', 'Sound Scotland (CD)', '', 0, 0, 2013, 0, 'As LP "Sound of Scotland" NPL-30080 + 3 extras

- Scottish Waltz

- Argyll''s Fancy 6x32J

- Gay Gordons', 3009);
INSERT INTO 'album' VALUES (1074, '2014-05-10 00:29:06.098968+00', '2014-05-10 00:29:06.098968+00', 'Coast to Coast with Scotch Mist', 'Coast to Coast', '', 0, 0, 2014, 0, '', 10955);
INSERT INTO 'album' VALUES (1070, '2014-03-27 13:02:29.547773+00', '2014-03-27 14:18:06.273429+00', 'Highland Accordion Medley', 'Accordion Medley', '', 0, 0, 2013, 0, '', 2328);
INSERT INTO 'album' VALUES (1061, '2014-02-09 17:21:30.031306+00', '2014-02-09 18:07:06.991231+00', 'RSCDS Glasgow 90th Anniversary', 'Glasgow 90', '', 0, 0, 2013, 0, '', 2566);
INSERT INTO 'album' VALUES (1054, '2013-09-11 19:26:21.433599+00', '2013-09-11 22:12:39.072887+00', 'Book 47. 12 Dances to celebrate the 90th Anniversary', 'RSCDS 47', '', 0, 0, 2013, 0, '', 3050);
INSERT INTO 'album' VALUES (788, '1998-07-16 22:00:00+00', '2014-05-13 09:36:32.817626+00', 'Puirt-a-Beul', 'Puirt-a-Beul', 'EE', 1, 50, 1966, 1, '', 2186);
INSERT INTO 'album' VALUES (34, '2002-05-11 22:00:00+00', '2014-06-19 12:12:01.139096+00', 'Book 1. Music for Twelve Traditional Dances', 'RSCDS 1', 'AP', 1, 77, 2000, 1, '', 3018);
INSERT INTO 'album' VALUES (1055, '2013-10-28 23:31:50.375407+00', '2013-11-07 12:29:04.465115+00', 'Sunday Class Dance Book 1, The', 'Sunday Class 1', '', 0, 0, 2013, 0, '', 3217);
INSERT INTO 'album' VALUES (59, '1999-05-25 22:00:00+00', '2013-12-07 09:34:00.3245+00', 'Book 14/15. Music for Scottish Country Dances (1)', 'RSCDS 14/15 (1)', 'AP', 1, 128, 1991, 1, 'The full title of the MC is 

MUSIC FOR SCOTTISH COUNTRY DANCES 

From Books 14 and 15. 

CASSETTE 1 - EIGHT DANCES



FIDDLERS THREE PLUS TWO

', 3021);
INSERT INTO 'album' VALUES (214, '1998-11-19 23:00:00+00', '2014-08-05 15:10:07.166506+00', 'Scottish Country Dance Favourites Volume I', 'SCD Favs  I', 'MK', 1, 332, 1971, 1, '', 3042);
INSERT INTO 'album' VALUES (995, '2011-11-03 23:00:00+00', '2014-03-05 10:15:53.639488+00', 'Shining Lights', 'Shining Lights', '', 0, 0, 2011, 0, 'This album is available as a very reasonably priced MP3 download from Amazon.', 2066);
INSERT INTO 'album' VALUES (1078, '2014-09-17 16:17:12.051835+00', '2014-09-18 16:43:19.982967+00', 'Music for the Commonwealth Ceilidh', 'Commonwealth Ceilidh 2014', '', 0, 0, 2014, 0, 'No information (like tunes) given on the CD by the RSCDS.', 3016);
INSERT INTO 'album' VALUES (1057, '2014-02-06 14:11:44.196253+00', '2014-02-06 15:01:16.292497+00', 'Bordering on Scottish', 'Bordering', '', 0, 0, 1999, 0, '', 3217);
INSERT INTO 'album' VALUES (1052, '2013-05-11 16:36:43.346286+00', '2014-03-10 00:53:52.463276+00', 'Thistle Hall: Dancing to the Kiwi Band', 'Thistle Hall', '', 0, 0, 2006, 0, 'Entered 2013-05-10



Disc length: 4589 seconds', 3420);
INSERT INTO 'album' VALUES (1067, '2014-03-16 15:03:54.26313+00', '2014-03-16 16:14:05.260224+00', 'From Scotland to Saitama', 'Saitama', '', 0, 0, 2013, 0, '', 3008);
INSERT INTO 'album' VALUES (1066, '2014-03-16 11:47:56.320645+00', '2023-01-01 21:55:42.192812+00', 'sailing by', 'Sailing By', '', 0, 0, 2012, 0, '', 10920);
INSERT INTO 'album' VALUES (1065, '2014-03-16 10:18:35.205104+00', '2023-01-01 21:55:18.092807+00', 'Honky-tonk Chateau', 'Honky-tonk', '', 0, 0, 1999, 0, '', 10920);
INSERT INTO 'album' VALUES (1015, '2011-12-14 23:00:00+00', '2023-01-10 22:49:32.989792+00', 'Let''s Go Scottish Country Dancing Vol 3', 'Let''s Go SCD Vol 3', '', 0, 0, 2011, 0, '', 10580);
INSERT INTO 'album' VALUES (1071, '2014-04-25 10:15:07.673522+00', '2014-04-29 14:42:17.596996+00', 'Scottish Dance Band Greats Vol 1', 'SDB Greats 1', '', 0, 0, 2013, 0, '', 3016);
INSERT INTO 'album' VALUES (1063, '2014-03-13 15:57:41.651611+00', '2014-03-13 18:11:21.201445+00', 'Beyond the Borders', 'Beyond', '', 0, 0, 2014, 0, '', 10114);
INSERT INTO 'album' VALUES (1072, '2014-04-29 15:07:10.452756+00', '2014-04-29 16:01:20.95165+00', 'Scottish Country Dance Time Vol 1', 'SCD Time 1', '', 0, 0, 2013, 0, '', 2038);
INSERT INTO 'album' VALUES (1077, '2014-08-19 07:13:34.400475+00', '2014-08-19 09:14:25.451178+00', 'Dances to Song Tunes', 'Song Tunes', '', 0, 0, 2014, 0, '', 10982);
INSERT INTO 'album' VALUES (394, '2002-05-07 22:00:00+00', '2015-01-11 14:52:47.955078+00', 'Scottish Dance Country', 'Music SCD 2 (BB)', 'IM', 1, 507, 0, 2, '', 3067);
INSERT INTO 'album' VALUES (1081, '2015-05-14 11:56:21.91444+00', '2015-05-14 11:56:21.91444+00', 'Carriages at Midnight', '', '', 0, 0, 2014, 0, '', 11136);
INSERT INTO 'album' VALUES (1068, '2014-03-19 09:36:27.78803+00', '2016-03-14 12:15:26.695873+00', 'Scottish Jigs and Reels', 'Jigs and Reels', '', 0, 0, 2010, 0, 'Virginia Reel played 8x32R', 3016);
INSERT INTO 'album' VALUES (1093, '2016-10-08 23:51:17.66737+00', '2016-10-09 02:29:32.356633+00', 'Sunday Class Dance Book 2, The', 'Sunday Class 2', '', 0, 0, 2016, 0, '', 3217);
INSERT INTO 'album' VALUES (1092, '2016-10-03 23:21:44.115632+00', '2016-10-04 00:14:17.558569+00', 'Excited States', '', '', 0, 0, 2016, 0, 'Due to an error in mastering the CD, in the list of tracks in the CD booklet tracks 9 and 10 have been swapped. The order given here corresponds to the actual order of tracks on the CD/in the download.', 11376);
INSERT INTO 'album' VALUES (315, '1999-03-23 23:00:00+00', '2015-06-13 16:02:06.151773+00', 'Night Owls', 'Night Owls', 'M', 1, 75, 0, 1, 'Times and track numbering here might be different from what is on the cassette, for they are from a digitized version.', 2137);
INSERT INTO 'album' VALUES (1016, '2012-01-06 23:00:00+00', '2023-08-28 11:10:49.775387+00', 'Geordie Diamond, The', 'Geordie Diamond', '', 0, 0, 2011, 0, '', 3039);
INSERT INTO 'album' VALUES (1080, '2014-11-13 21:07:11.341192+00', '2023-08-28 11:13:35.507068+00', 'Leeds Golden Collection, The', 'Leeds Golden', '', 0, 0, 2014, 0, 'Recorded by Stuart Hamilton at Castlesound Studio

Manufactured for Birnam CD Ltd', 3011);
INSERT INTO 'album' VALUES (1059, '2014-02-06 18:00:10.043956+00', '2023-08-28 11:15:56.028416+00', 'Moments in Time', 'Moments', '', 0, 0, 2013, 0, '', 10915);
INSERT INTO 'album' VALUES (1076, '2014-08-11 22:03:52.665967+00', '2023-08-28 11:17:02.160528+00', 'Music for A Third Book of Graded Scottish Country Dances', '3rd Graded Book', '', 0, 0, 2014, 0, '', 10981);
INSERT INTO 'album' VALUES (1053, '2013-08-06 13:49:35.555293+00', '2023-08-28 11:20:46.237425+00', 'Opus Dance', 'Opus', '', 0, 1, 2013, 1, '', 10823);
INSERT INTO 'album' VALUES (1060, '2014-02-07 08:48:17.862722+00', '2023-08-28 11:23:34.650153+00', 'Prairie Gold', 'Prairie Gold', '', 0, 0, 2013, 0, '', 2339);
INSERT INTO 'album' VALUES (1051, '2013-03-19 09:20:14.485694+00', '2025-06-29 07:51:44.01313+00', 'Oxford Connections', '', '', 0, 0, 2012, 0, 'Not all tracks have been added.



Originally the <<https://www.craigellachie-band.co.uk/|Craigellachie band website>> had a link to some of the associated recordings (http://www.craigellachie-band.co.uk/oxford_connections.html) but this has been removed.', 3014);
INSERT INTO 'album' VALUES (1083, '2015-06-19 10:38:16.570017+00', '2015-06-19 12:00:45.389809+00', 'Gotta Dance! … to Reel of Seven', 'Gotta Dance!', '', 0, 1, 2015, 1, '', 10000);
INSERT INTO 'album' VALUES (1090, '2016-09-12 22:51:34.579517+00', '2016-09-12 23:50:51.262183+00', 'Book 50 – “Spring Fling” Music for 13 Scottish Country Dances', 'Book 50', '', 0, 0, 2016, 0, '', 11351);
INSERT INTO 'album' VALUES (1089, '2016-07-04 22:38:25.354944+00', '2016-07-04 23:20:09.979016+00', 'Burning of Paddy''s Breeches and other dances', 'Burning of Paddy''s Breeches', '', 0, 0, 1954, 0, 'Record contains recordings by "Bobby MacLeod''s Highland Dance Band" and "Bobby MacLeod and his Band".', 2328);
INSERT INTO 'album' VALUES (1085, '2015-08-31 12:01:56.195632+00', '2015-08-31 12:01:56.195632+00', 'Happy Tartan', '', '', 0, 0, 2014, 1, '', 11190);
INSERT INTO 'album' VALUES (1075, '2014-08-11 14:56:34.908364+00', '2015-09-05 22:03:03.096032+00', 'Book 48 - Music for 15 Scottish Country Dances', 'Book 48', '', 0, 0, 2014, 0, '', 10979);
INSERT INTO 'album' VALUES (245, '1998-11-03 23:00:00+00', '2015-10-06 11:09:22.548999+00', 'Welcome to the London Highland Club', 'Welcome/London', 'CG', 1, 340, 1977, 1, '', 2414);
INSERT INTO 'album' VALUES (371, '2000-09-02 22:00:00+00', '2018-11-09 18:41:16.229543+00', 'Teachers Choice 1', 'Teachers Choice 1', 'OO', 1, 533, 1965, 2, 'Artist set to Pasadena Recorders (was originally Various Artists). See http://my.strathspey.org/dd/issue/1503/', 11743);
INSERT INTO 'album' VALUES (1091, '2016-09-24 10:00:59.259238+00', '2016-09-24 12:03:28.788327+00', 'Dances from Miss Milligan''s Miscellany Part 5', 'Miscellany 5', '', 0, 0, 2016, 0, '', 10034);
INSERT INTO 'album' VALUES (1094, '2016-10-30 22:08:13.761217+00', '2016-10-30 23:50:44.08091+00', 'Tullich Collection, The', '', '', 0, 0, 2015, 0, '', 3013);
INSERT INTO 'album' VALUES (1056, '2013-12-19 16:09:48.740321+00', '2018-10-14 00:07:25.295614+00', 'Other Kangaroo Paw, The', 'Other Kangaroo Paw', '', 0, 0, 2013, 0, '', 3217);
INSERT INTO 'album' VALUES (93, '1998-09-02 22:00:00+00', '2017-01-25 01:20:36.077726+00', 'Biggar and Better Sound of Alex MacArthur, The', 'Biggar Better', '', 0, 289, 0, 1, 'Biggar is the name of a village where Alex had a hotel; it''s also a pun.', 3001);
INSERT INTO 'album' VALUES (1088, '2016-07-04 08:49:33.911384+00', '2017-02-03 16:20:53.653406+00', 'Take Your Partners', '', '', 0, 0, 0, 0, 'This LP has been reissued under the name Early Days in 2005 by Legacy Records.

It is available to buy on itunes, Amazon, Apple Music, etc.

and to listen to on Spotify.', 3057);
INSERT INTO 'album' VALUES (1097, '2017-02-12 12:10:29.868639+00', '2017-02-12 13:54:07.062866+00', 'Take Your Partners For … Vol. 5', 'Take Your Partners 5', '', 0, 0, 2015, 0, '', 10034);
INSERT INTO 'album' VALUES (1095, '2016-12-14 22:08:06.998512+00', '2017-07-27 16:12:50.74372+00', 'Sunday Class Christmas CD, The', 'Sunday Class Xmas', '', 0, 0, 2016, 0, '', 10209);
INSERT INTO 'album' VALUES (1096, '2016-12-18 01:14:57.066624+00', '2017-03-02 00:55:38.106449+00', 'Magic of Summer School, The', '', '', 0, 1, 2016, 1, '', 10000);
INSERT INTO 'album' VALUES (1101, '2017-08-26 22:27:31.868487+00', '2017-09-30 10:51:22.053534+00', 'Book 51 – Music for 12 Scottish Country Dances and Band Leader''s Choices', 'Book 51', '', 0, 0, 2017, 0, '', 10018);
INSERT INTO 'album' VALUES (919, '2009-11-23 23:00:00+00', '2017-03-13 15:29:26.996788+00', 'Cambusdoon', 'Cambusdoon', '', 0, 0, 2009, 0, '', 3019);
INSERT INTO 'album' VALUES (1102, '2017-11-06 18:23:24.037651+00', '2017-11-08 15:10:08.826632+00', 'Stirling at 90', '', '', 0, 0, 2017, 0, '', 10209);
INSERT INTO 'album' VALUES (175, '1999-10-01 22:00:00+00', '2017-11-08 15:19:04.215146+00', 'Gie us Tullochgorum', 'Gie us', 'RS', 1, 408, 1986, 1, '', 2066);
INSERT INTO 'album' VALUES (118, '2002-05-11 22:00:00+00', '2019-09-11 21:23:39.279214+00', 'Book 33. Music for Eight Scottish Country Dances', 'RSCDS 33', 'EC', 1, 405, 2001, 1, 'The entry is for the CD which has an extra track compared to the original LP/MC (album ID 1121).', 3019);
INSERT INTO 'album' VALUES (440, '2003-09-14 22:00:00+00', '2017-06-10 01:43:12.579801+00', 'Scottish in Salem', 'Salem', 'AP', 1, 0, 2003, 0, 'The complete lineup for the CD was Lissa Schneckenburger (fiddle), Tom Pixton (piano/accordion), Howard Lasnick and Paul Henle (percussion), and Barbara Pixton (bass).', 3372);
INSERT INTO 'album' VALUES (1035, '2013-01-04 12:23:14.374687+00', '2017-06-14 01:14:26.437627+00', 'Are You Ready? .... Well Here We Go!', 'Are You Ready', '', 0, 0, 2012, 0, 'A very special album, produced from recordings made during Bobby Brown''s last two live band appearances: The 2011 Edmonton Caledonian Ball and The 2011 Toronto Tartan Ball.



The lineup was: Bobby Brown (lead accordion), Laird Brown (2nd accordion), Kathy Fraser-Collins (piano), Don Wood (bass guitar), and Fred Collins (drums).

', 3067);
INSERT INTO 'album' VALUES (1103, '2017-11-10 16:19:37.003158+00', '2017-11-10 20:43:48.702406+00', 'Around the World with Scotch Mist', 'Around the World', '', 0, 0, 2017, 0, '', 10955);
INSERT INTO 'album' VALUES (1104, '2017-11-17 09:09:38.499315+00', '2017-11-17 14:34:14.487892+00', 'Elma McCausland MBE', 'Elma McCausland MBE', '', 0, 0, 2017, 0, 'This is the CD included in the RSCDS Belfast publication "Dances to Honour Elma McCausland MBE".', 3217);
INSERT INTO 'album' VALUES (760, '1998-10-12 22:00:00+00', '2021-08-20 22:00:08.380236+00', 'Jimmy Lindsay and his Scottish Dance Band', 'Lindsay & SDB', 'EN', 1, 244, 1975, 1, 'Only selected tracks have been entered. An image of the back cover is available via <<https://www.amazon.com/Jimmy-Lindsay-Scottish-Dance-Band/dp/B00DVN36D6>>.', 3025);
INSERT INTO 'album' VALUES (1082, '2015-05-31 09:41:23.136553+00', '2022-12-10 19:36:13.044972+00', 'Joy of Sets, The', 'Joy of Sets', '', 0, 0, 2015, 0, 'The data results from the download version on itunes

 - no tunes yet

 - the times have to be checked', 10037);
INSERT INTO 'album' VALUES (447, '2004-01-19 23:00:00+00', '2017-08-23 21:14:11.64856+00', 'Peter Macfarlane (fiddle) & Lilian Linden (piano)', 'Peter Macfarlane & Lilian Linden', '', 0, 0, 2003, 0, 'The CD actually does not show a title besides "Peter Macfarlane (fiddle) & Lilian Linden (piano)". Thus, this is the title of the CD as Peter Macfarlane pointed out by email.



Nevertheless, this CD is sometimes offered as "Invercauld" or "Invercauld001" which related to the catalog number of the CD.', 3418);
INSERT INTO 'album' VALUES (1113, '2018-09-15 09:31:17.515487+00', '2018-11-06 21:50:18.526658+00', 'Book 52 – Music for 12 Scottish Country Dances plus 5 Bonus Tracks', 'Book 52', '', 0, 0, 2018, 0, '', 10659);
INSERT INTO 'album' VALUES (455, '2004-09-29 22:00:00+00', '2019-01-14 16:27:50.071158+00', 'Campbell''s Birl', 'Campbell''s Birl', 'LH', 1, 0, 2004, 0, 'Dances from Glasgow Assembly and Farewell, My Fancy.', 2586);
INSERT INTO 'album' VALUES (1107, '2017-12-27 14:36:16.25479+00', '2017-12-27 17:17:32.534248+00', 'Music for The Carlingwark Collection, Volume Two', 'Carlingwark Collection, Vol. 2', '', 0, 0, 2017, 0, '', 11351);
INSERT INTO 'album' VALUES (1106, '2017-12-16 16:06:41.387136+00', '2017-12-27 17:18:41.25018+00', 'Music for The Carlingwark Collection, Volume One', 'Carlingwark Collection, Vol. 1', '', 0, 0, 2017, 0, '', 10037);
INSERT INTO 'album' VALUES (1108, '2017-12-27 17:14:11.095929+00', '2017-12-27 17:19:33.002192+00', 'Music for The Carlingwark Collection, Volume Three', 'Carlingwark Collection, Vol. 3', '', 0, 0, 2017, 0, '', 10018);
INSERT INTO 'album' VALUES (499, '2006-06-20 22:00:00+00', '2018-01-22 13:28:55.358665+00', 'Catch the Wind', 'Catch the Wind', 'AP', 1, 0, 2006, 0, '', 3030);
INSERT INTO 'album' VALUES (1087, '2016-03-13 00:56:44.468602+00', '2023-08-28 10:53:53.893062+00', '9 for 90 RSCDS Aberdeen Branch 90th Anniversary', '9 for 90', '', 0, 0, 2015, 0, '', 2944);
INSERT INTO 'album' VALUES (1105, '2017-11-24 16:03:00.175293+00', '2023-08-28 11:09:42.86276+00', 'Full Circle', '', '', 0, 0, 2017, 0, '', 11568);
INSERT INTO 'album' VALUES (973, '2010-10-08 22:00:00+00', '2023-08-28 11:16:32.337159+00', 'Music for A Second Book of Graded Scottish Country Dances', 'Graded Book 2', '', 0, 0, 2010, 0, '', 10249);
INSERT INTO 'album' VALUES (1114, '2019-01-08 15:52:22.966775+00', '2023-08-28 11:19:53.832887+00', 'Musicians'' Wedding, The', 'Musicians'' Wedding, The', '', 0, 0, 2018, 0, '', 3217);
INSERT INTO 'album' VALUES (1098, '2017-02-13 10:54:29.271333+00', '2023-08-28 11:22:07.339377+00', 'Platinum 70th Anniversary Dances - Belfast Branch', 'Belfast Platinum Dances', '', 0, 0, 2016, 0, 'The CD states "70th Anniversary Dances" as title on the side, but  "Platinum Anniversary Dances" and "1946 - 70 - 2016" on the front.', 3217);
INSERT INTO 'album' VALUES (1100, '2017-06-28 12:33:29.220775+00', '2023-08-28 11:30:31.145844+00', 'Spark O'' Water', 'Spark O'' Water', '', 0, 0, 2017, 0, '', 2586);
INSERT INTO 'album' VALUES (1086, '2015-12-08 10:07:57.666194+00', '2023-08-28 11:37:01.865124+00', 'Third Sheaf Collection of Scottish Country Dances, The', '3rd Sheaf Coll', '', 0, 0, 2015, 0, 'THIS CD AND RECORDINGS ARE IN THE PROCESS OF BEING ADDED - PLEASE BE PATIENT!', 3011);
INSERT INTO 'album' VALUES (1116, '2019-02-26 18:19:42.366445+00', '2024-09-07 09:35:35.523488+00', 'Dancing Bear, The', 'Dancing Bear', '', 0, 0, 2018, 0, 'Double CD album', 11791);
INSERT INTO 'album' VALUES (1099, '2017-05-19 08:53:45.768291+00', '2025-03-02 12:46:19.938027+00', 'Thistle House Live!', '', '', 0, 0, 2013, 2, 'Live recording of medleys suitable for Scottish country dancing with original music by David Knight (Fiddle) , Dave Wiesler (Piano) and Dan Emery (pipes and wooden flute) all featured. Recorded at the New Haven Branch Highland Ball 2007', 12284);
INSERT INTO 'album' VALUES (1119, '2019-06-14 14:42:56.136199+00', '2019-06-14 18:28:15.186592+00', 'Sunday Class Recorded Highlights Volume 1, The', 'TSC Recorded Hghlights 1', '', 0, 0, 2019, 0, 'Official release date: 1st July 2019', 10659);
INSERT INTO 'album' VALUES (77, '1998-07-23 22:00:00+00', '2017-12-17 22:13:45.978624+00', 'All Set', 'All Set', 'AP', 1, 96, 1995, 1, 'Please note, the CD indeed contains two recordings for "Saint Andrews of Brampton", a primary and an alternative set with different tunes.', 3006);
INSERT INTO 'album' VALUES (1115, '2019-02-26 18:18:42.178699+00', '2019-02-26 18:49:41.727594+00', 'Black Bear, The', '', '', 0, 0, 0, 0, 'This is a listening CD with mixed scottish tunes but not suitable for dancing.', 11791);
INSERT INTO 'album' VALUES (1117, '2019-02-26 18:20:42.181972+00', '2019-02-26 18:50:16.681334+00', 'Ursa Major', 'Ursa Major', '', 0, 0, 0, 0, 'This is a listening CD with mixed scottish tunes but not suitable for dancing.', 11791);
INSERT INTO 'album' VALUES (1121, '2019-09-11 21:04:39.166886+00', '2019-09-11 21:23:49.22428+00', 'Book 33. Music for Eight Scottish Country Dances', 'RSCDS 33', 'EC', 1, 405, 2001, 1, 'This entry is for the original LP/MC. The CD entry (album ID 118) has an extra track.', 3019);
INSERT INTO 'album' VALUES (1120, '2019-08-23 16:02:54.07517+00', '2019-08-23 16:18:16.928308+00', 'Second Chances', '', '', 0, 1, 2019, 1, '', 11862);
INSERT INTO 'album' VALUES (1118, '2019-03-14 00:12:47.537231+00', '2019-03-14 12:14:41.644694+00', 'Dancer''s Best Friend, A', 'Dancer''s Best Friend', '', 0, 0, 2018, 0, 'For this album the two original members of Terpsichore were joined by Ralph Gordon (https://my.strathspey.org/dd/person/11799/)', 3017);
INSERT INTO 'album' VALUES (438, '2003-07-04 22:00:00+00', '2019-11-16 17:42:54.930461+00', 'More Memories of Scottish Weekend', 'More Weekend', '', 0, 0, 2003, 2, '', 2162);
INSERT INTO 'album' VALUES (1084, '2015-08-19 14:29:07.429656+00', '2019-11-26 01:02:01.385378+00', 'Book 49 - Music for 15 Scottish Country Dances', 'Book 49', '', 0, 0, 2015, 0, '', 10659);
INSERT INTO 'album' VALUES (1122, '2019-12-09 22:03:54.591618+00', '2019-12-09 22:36:03.933496+00', 'Robertson: A Musical Heritage', '', '', 0, 0, 2019, 0, '', 11568);
INSERT INTO 'album' VALUES (186, '2001-11-19 23:00:00+00', '2020-02-01 17:17:10.266399+00', 'Note ''N'' Away', 'Note ''N'' Away', '', 0, 302, 1998, 1, 'Tune details still to be added for some tracks. A list is available at <<https://www.thedancinghaggis.com/note-away-p-68863.html>>.', 3045);
INSERT INTO 'album' VALUES (366, '1999-04-22 22:00:00+00', '2020-06-17 22:42:31.967748+00', 'Live', 'Live', 'AS', 1, 398, 1995, 1, 'Recorded live at the 20th Anniversary Ball of the San Diego branch of the RSCDS in 1995.', 2065);
INSERT INTO 'album' VALUES (1126, '2020-06-11 19:02:01.121591+00', '2020-06-11 20:11:26.799191+00', 'Scottish Dance Tour Japan 1997', 'Japan Tour', '', 0, 0, 1997, 0, 'CD of recordings made specially for a particular tour and not widely available (details supplied by Martina Mueller-Franz).', 3016);
INSERT INTO 'album' VALUES (1124, '2020-05-21 08:49:30.54046+00', '2020-05-21 10:26:33.143436+00', 'Grove Collection of SCDs Volume 1', 'Grove Collection 1', '', 0, 0, 2020, 0, '', 11858);
INSERT INTO 'album' VALUES (1127, '2020-07-04 15:21:29.178579+00', '2020-07-04 15:22:51.471074+00', 'Bruce Fordyce Memorial Collection, The', '', '', 0, 0, 0, 0, '', 1042);
INSERT INTO 'album' VALUES (1123, '2020-04-30 16:48:42.108331+00', '2020-05-08 08:39:58.529211+00', 'Short & Sweet', '', '', 0, 0, 2020, 0, '', 10114);
INSERT INTO 'album' VALUES (208, '1998-05-04 22:00:00+00', '2021-08-20 20:03:19.853201+00', 'Testing the Water', 'Testing Water', '', 0, 73, 0, 1, 'Some information about this CD found at <<https://www.thedancinghaggis.com/testing-the-water-p-70192.html>>. Used for assigning track numbers (the album was originally entered with all track numbers set to 0). Not all the 13 tracks claimed to be on the CD have been entered in the database.', 2089);
INSERT INTO 'album' VALUES (281, '1999-01-23 23:00:00+00', '2021-04-16 11:52:44.537501+00', 'Let''s All Go Scottish Country Dancing', 'Let''s All Go', 'JW', 1, 295, 1971, 1, 'In <<https://www.discogs.com/McBains-Scottish-Country-Dance-Band-Lets-All-Go-Scottish-Country-Dancing/release/3603144>> track 7 is described as "Airie Brenan". This is perhaps a mistake for Airie Bennan - though the lead tune listed here is not the recommended one for that dance. Similarly track 4 is described as "Earlstoun Loch" but also does not include the recommended tune for that dance.', 2058);
INSERT INTO 'album' VALUES (1128, '2020-07-31 16:00:31.832574+00', '2020-07-31 17:01:13.665131+00', 'Encore une Fois', '', '', 0, 0, 2018, 0, 'Arrangements by Laura Risk and Nicholas Williams.



Recorded by Nicholas Williams and Laura Risk at Tsuga studios in Waterville, QC, April 2018. Mixed and mastered by Nicholas Williams.



Laura and Nicholas would like to thank the Montréal Branch for their encouragement and support of our music. Thanks also to the many musicians with whom we''ve had the pleasure of collaborating over the years, in particular Éric Breton, and to Susie Petrov and Mara Shea for introducing us to some of our favourite dance tunes.', 11972);
INSERT INTO 'album' VALUES (1129, '2020-12-07 22:45:17.370004+00', '2020-12-07 23:30:35.670053+00', 'Well Tuned Piano, The', 'Well Tuned Piano', '', 0, 0, 2020, 0, 'Subtitle: Piano Music for Scottish Country Dancing.



Sheet music of the tunes is available on request to don.bartlett@veritrack.ca.', 709);
INSERT INTO 'album' VALUES (1132, '2021-05-22 07:59:41.58831+00', '2021-05-22 19:08:55.645134+00', 'Welcome to the Dance', '', '', 0, 0, 1970, 0, 'This is a stub entry with minimal data from <<https://www.discogs.com/Jim-Johnstone-And-His-Band-Welcome-To-The-Dance/release/6753923>>.', 3037);
INSERT INTO 'album' VALUES (1133, '2021-05-23 12:08:43.59459+00', '2021-05-23 12:08:43.59459+00', 'Lassie Come and Dance With Me', 'Lassie Come & Dance', '', 0, 0, 1966, 0, 'This is a stub entry added to link the recording specifically mentioned in the instructions for <<ddd:Johnny Lad#8430>>. The information was taken from <<https://www.discogs.com/Jim-MacLeod-And-His-Band-Lassie-Come-And-Dance-With-Me/release/10766308>>.', 3009);
INSERT INTO 'album' VALUES (1130, '2021-03-18 22:00:37.868864+00', '2021-03-18 22:34:09.796158+00', 'Jimmy Blue''s Welcome to Scotland', 'Blue''s Welcome', '', 0, 0, 1969, 0, 'Stub entry. Not all recordings on this album are entered.



Those, generic tracks or for dances unknown to the database, include:  

A2: The Ladies from Hell  

A3: Unknown Polka  

A4: Drum Salute  

A5: Scottish Waltz  

A6: Medley  

B2: Fiddle Solo  

B3: Bremner''s March  

B4: Hornpipes  

B5: Accordion Duet  

B7: Moladh Beinn Dobhrain  



Information from https://www.discogs.com/Jimmy-Blue-And-His-Scottish-Band-Jimmy-Blues-Welcome-To-Scotland/release/6491702 (and a google search shows a low resolution photo of the cover which matches the discogs record). Album originally notified via issue 2407 (https://my.strathspey.org/dd/issue/2407/).', 2039);
INSERT INTO 'album' VALUES (838, '1998-07-17 22:00:00+00', '2021-03-19 22:37:27.352837+00', 'Scottish Sounds of Jimmy Blue, The', 'Scottish Sounds', 'EC', 1, 32, 1972, 1, 'This album has several additional tracks which are not for dances and so are not currently listed here.  

A4: Fiddle solo  

A5: Accordion duet  

B3: Accordion Solo  

', 2039);
INSERT INTO 'album' VALUES (1131, '2021-04-03 15:27:57.703586+00', '2021-04-03 15:41:41.051846+00', 'Ian Powrie on Stage', 'Powrie on Stage', '', 0, 0, 1966, 0, 'Stub entry. The recording for only one dance is identified. The list of tunes used can be found at <<http://www.nigelgatherer.com/perf/fiddlers/ian_powrie.html>>.', 2062);
INSERT INTO 'album' VALUES (1135, '2021-08-13 21:15:51.248361+00', '2021-08-13 21:29:14.958169+00', 'Bill Ewan''s Lockdown Sessions', 'Lockdown Sessions', '', 0, 0, 2021, 0, 'Recordings of live music played by Bill Ewan in online sessions during the 2020 lockdown. Most are "listening" tracks but there are four for dances. The CD was issued in a limited set with all proceeds going to charity.', 12028);
INSERT INTO 'album' VALUES (375, '2000-09-06 22:00:00+00', '2021-08-17 08:18:28.240442+00', 'Dance to the Pipes', 'Dance to Pipes', 'AP', 1, 508, 2000, 2, 'The dance instructions are in the booklet with this note: "Tracks 4, 5, and 7 were previously allocated to the dances in brackets on the cassette ''Broadswords'' SRCM153. These three tracks and track 6 have piano accompaniment by Nancy Dickson. *(Information from <<https://my.strathspey.org/dd/issue/2611/|issue 2611>>).*



So track 4 "Aileen''s Reel" is also for "Bonnie Geordie''s Wig";  

track 5 "East of Yeadon" is also for "Kiss Under the Stairs";  

and track 7 "The Piper''s Glen" is also for "Lady Charlotte Bruce".  ', 1556);
INSERT INTO 'album' VALUES (1136, '2021-08-19 12:24:50.89556+00', '2021-08-20 15:20:34.130805+00', 'Friday Fun Night at the Stagger Inn', 'Stagger Inn', '', 0, 0, 2021, 0, '', 11858);
INSERT INTO 'album' VALUES (1125, '2020-05-29 10:20:37.164952+00', '2023-08-28 11:07:22.515697+00', 'Emigrant Scot, The', 'Emigrant Scot', '', 0, 1, 2020, 1, '', 11953);
INSERT INTO 'album' VALUES (172, '1998-10-18 22:00:00+00', '2021-10-05 11:52:15.4746+00', 'Favourite Scottish Dances', 'Favourite SD', 'EE', 1, 395, 0, 1, 'See <<https://my.strathspey.org/dd/issue/2629/|issue 2629>> for comments. Previously this was entered with title "Favourite Scottish Dances #5" but the "#5" is now removed.', 10748);
INSERT INTO 'album' VALUES (490, '2006-02-21 23:00:00+00', '2021-11-25 22:06:01.856397+00', 'Medal Tests for Young Dancers (2006)', 'Medal Tests 2006', '', 0, 0, 2006, 0, 'This album is presumably the one accompanying the original edition of the medal tests. Those were later revised and a new CD issued.', 3658);
INSERT INTO 'album' VALUES (261, '1998-10-10 22:00:00+00', '2022-07-30 16:07:45.260393+00', 'Reelin'' ''n'' Ramblin''', 'Reelin''', 'EN', 1, 145, 1976, 1, 'There is no evidence The Gordon Waltz is actually on this album. Maybe a mistake for a Roy Hendri album such as Scottish Dance Party vol 2?', 3057);
INSERT INTO 'album' VALUES (963, '2010-09-02 22:00:00+00', '2022-01-24 09:57:07.334266+00', 'Music of Corryvrechan, The', 'Corryvrechan Music', '', 0, 0, 2007, 0, '', 3479);
INSERT INTO 'album' VALUES (1143, '2022-07-21 09:58:12.879285+00', '2022-07-21 10:05:43.832519+00', 'Cherry Blossom Time Volume 1', 'Cherry Blossom 1', '', 0, 0, 2008, 0, 'This CD appears to be the last 13 tracks (2nd CD) from a double CD set <<dda:Cherry Blossom Time#912>>. It is assumed the recordings are identical (though possibly there was an error in the tune order of the last recording). See <<https://my.strathspey.org/dd/issue/2837/|issue 2837>> for more details.', 3050);
INSERT INTO 'album' VALUES (1141, '2022-05-03 21:48:37.910423+00', '2022-05-03 22:13:14.38641+00', 'Ship Ahoy!', '', '', 0, 1, 2020, 1, 'Produced by Ewan Galloway to raise funds for the Edinburgh Trinity Sea Cadets.', 11858);
INSERT INTO 'album' VALUES (1144, '2022-08-06 14:32:22.266736+00', '2022-08-06 16:05:45.618932+00', 'Simmerdim Danelaw Dance Band Favourites Vol. 1', 'Simmerdim', '', 0, 0, 2021, 0, 'This is named "Simmerdim" on the front and "Danelaw Dance Band Favourites Vol. 1" on the back. Note that only subset of the tracks have opening and closing chords.', 3039);
INSERT INTO 'album' VALUES (293, '1998-10-11 22:00:00+00', '2022-07-23 14:55:02.386365+00', 'O''er the Border', 'O''er the Border', 'EN', 1, 376, 1958, 1, '', 3010);
INSERT INTO 'album' VALUES (164, '1998-10-10 22:00:00+00', '2022-08-20 15:57:12.715687+00', 'Dancing with Jim Johnstone', 'Dancing w JJ', 'EN', 1, 208, 1967, 1, '', 3037);
INSERT INTO 'album' VALUES (359, '2000-03-12 23:00:00+00', '2022-07-24 18:27:54.177966+00', 'Band Boys'' Choice', 'Band Boys', '', 0, 530, 1999, 2, '', 3049);
INSERT INTO 'album' VALUES (1145, '2022-08-22 23:48:00.183061+00', '2022-08-22 23:48:00.183061+00', 'Highland Pretty', '', '', 0, 0, 2000, 0, '', 12196);
INSERT INTO 'album' VALUES (752, '1998-11-19 23:00:00+00', '2022-08-20 14:37:57.859638+00', 'Heather Medley Scottish Country Dancing', 'Heather Medley', 'EN', 1, 210, 1969, 1, 'The timings given here refer to the CD version, which was obviously not produced in 1969 (but doesn''t give the actual date). It says “This is a very limited edition CD produced to assist in raising funds for Scottish Cancer Charities.”', 3037);
INSERT INTO 'album' VALUES (85, '1998-09-02 22:00:00+00', '2022-08-23 00:01:55.849755+00', 'Scottish Country Dancing', 'SCD (C Wilson)', 'AP', 1, 460, 1997, 1, '', 3055);
INSERT INTO 'album' VALUES (167, '1998-11-14 23:00:00+00', '2022-08-23 21:57:39.61088+00', 'Edinburgh Castle Reel, The and other SCD', 'Edin Cas Reel', 'DS', 1, 136, 1986, 1, '', 2047);
INSERT INTO 'album' VALUES (998, '2011-11-11 23:00:00+00', '2022-08-26 22:52:39.416248+00', 'Live at the Beach Ballroom', 'Beach Ballroom', '', 0, 0, 2008, 0, '', 3034);
INSERT INTO 'album' VALUES (1062, '2014-02-14 14:58:55.918677+00', '2022-08-27 11:35:22.355211+00', 'Netherwood Collection, The', 'Netherwood', '', 0, 0, 2011, 0, 'The second CD has a recording for <<ddd:Nottingham Lace>> as track 2 that does not appear in the liner notes at all. Everything from “Ederline” is really one track later than it seems.', 1575);
INSERT INTO 'album' VALUES (443, '2003-11-17 23:00:00+00', '2022-08-29 00:01:53.830137+00', 'Basingstoke Ball Live 1971', 'Basingstoke', '', 0, 0, 2003, 0, 'This album was formerly entered in SCDDB with the name "Play Basingstoke Ball". However the CD is actually titled "Basingstoke Ball Live 1971". For more information see <<http://my.strathspey.org/dd/issue/1859/|issue 1859>>.

', 2058);
INSERT INTO 'album' VALUES (449, '2004-04-27 22:00:00+00', '2022-08-29 10:27:49.100907+00', 'Vintage Goldring', 'Vintage Goldring', '', 1, 0, 2004, 0, '', 2586);
INSERT INTO 'album' VALUES (1142, '2022-06-25 17:46:55.246972+00', '2023-01-30 18:09:20.097492+00', 'Newcastle 70th Anniversary', 'Newcastle 70th Anniversary', '', 0, 0, 2022, 0, 'Music performed by Marian Anderson''s and Iain MacPhail''s Dance Bands. Book of same name with dances devised by Sheila Trafford.', 12157);
INSERT INTO 'album' VALUES (1134, '2021-06-30 12:02:47.737547+00', '2023-03-06 01:27:23.630213+00', 'Thirty Popular Dances - Volume Two Part one', '', '', 0, 0, 2019, 0, '', 10037);
INSERT INTO 'album' VALUES (1138, '2021-11-25 22:20:28.755469+00', '2022-08-29 21:23:23.376356+00', 'Medal Tests for Young Dancers (2014)', 'Medal Tests 2014', '', 0, 0, 2014, 0, 'This is the CD accompanying the revised medal tests. Some recordings are assumed to be copies of those on the original medal tests CD (<<dda:#490>>) while others are new for the updated version. The insert says this is published and copyright in 2013, 2014.



The CDDB ID data for this album is `1c0c4227 39 150 3707 8230 11716 17728 21194 27213 33087 39133 42388 48384 54430 60375 66363 72322 78359 84377 90319 96233 102270 108272 114324 120229 126151 132151 139368 145396 151436 157479 163491 169333 175550 185538 191335 197294 207552 213523 219676 229657 3140`.

We''re including it here for the time being because the CDDB ID field in the database is limited to 256 characters, and we need to extend that first in order to store this.', 3658);
INSERT INTO 'album' VALUES (57, '1999-05-25 22:00:00+00', '2022-09-04 19:49:06.986102+00', 'Book 32. Music for Eight Scottish Country Dances', 'RSCDS 32', 'AP', 1, 462, 1985, 1, 'For some reason tracks are numbered 2-9 in SCDDB. Otherwise the order corresponds to <<https://www.discogs.com/release/11179821-Alastair-Wood-And-His-Scottish-Dance-Band-Music-For-Eight-Scottish-Country-Dances-Book-32>> or <<https://archive.rscds.org/index.php/music-for-eight-scottish-country-dances-32;isad?sf_culture=en_GB>>.', 3022);
INSERT INTO 'album' VALUES (1160, '2022-12-26 13:26:53.731386+00', '2022-12-26 13:30:33.930525+00', 'Dancing Memories Volume Three', 'DancingMemories03', '', 0, 0, 0, 0, '', 3016);
INSERT INTO 'album' VALUES (1147, '2022-12-11 20:51:28.375079+00', '2022-12-11 21:34:04.594716+00', 'Music for Old Time Dancing, Vol. 6', '', '', 0, 0, 2013, 0, '', 1580);
INSERT INTO 'album' VALUES (887, '2009-10-24 22:00:00+00', '2022-12-13 17:21:05.43387+00', 'Music for Scottish Dances Collected by Mary Isdal MacNab', 'MacNab Dances', '', 0, 0, 2007, 0, '', 3016);
INSERT INTO 'album' VALUES (1148, '2022-12-16 09:45:50.981777+00', '2022-12-16 09:45:50.981777+00', 'Scottish Country Dances', '', '', 0, 0, 2012, 0, '', 2058);
INSERT INTO 'album' VALUES (198, '1998-10-06 22:00:00+00', '2022-12-16 17:15:21.819692+00', 'Memory Lane', 'Memory Lane', 'EC', 1, 425, 1991, 1, 'TAC005CD has no track 22 as the TAC005C, Meinhard', 3016);
INSERT INTO 'album' VALUES (1149, '2022-12-20 23:14:08.447629+00', '2022-12-20 23:14:08.447629+00', 'Landslide', 'Landslide', '', 0, 0, 2019, 0, 'The titles and album information are as can be seen on Spotify.', 11376);
INSERT INTO 'album' VALUES (1150, '2022-12-20 23:19:38.040912+00', '2022-12-20 23:38:48.350477+00', 'Spindriftin''', 'Spindriftin''', '', 0, 0, 2017, 0, '', 11376);
INSERT INTO 'album' VALUES (1151, '2022-12-22 22:44:06.253914+00', '2022-12-26 19:31:18.19832+00', 'Scotland Swings With The Great Jim MacLeod Band', 'Scotland Swings Again', '', 0, 0, 1968, 0, 'The LP back states: "(...) in fact, four members of the band have all written a tune specifically for this album." Sadly though it is not credited who wrote which tune. 

Produced by Ray Horricks.', 3009);
INSERT INTO 'album' VALUES (1162, '2023-02-25 18:09:16.306931+00', '2023-02-26 23:24:53.924778+00', 'RSCDS Tokai 25th Anniversary', 'Tokai 25th', '', 0, 0, 2023, 0, 'CD to accompany <<ddpub:RSCDS Tokai 25th Anniversary Book#1639>>.', 11953);
INSERT INTO 'album' VALUES (912, '2009-11-20 23:00:00+00', '2023-01-16 14:02:37.322017+00', 'Cherry Blossom Time', 'Cherry Blossom Time', '', 0, 0, 2007, 0, 'The last half of the tracks here (from Breeze Bay onwards) seem to have been reissued under the name "Cherry Blossom Time Volume 1". See <<dda:Cherry Blossom Time Volume 1#1143>> and <<https://my.strathspey.org/dd/issue/2837/|issue 2837>>.', 3050);
INSERT INTO 'album' VALUES (1153, '2022-12-23 11:57:58.886506+00', '2022-12-23 12:45:55.754411+00', 'Simply the Best Scottish Country Dance Album', 'Best MacLeod', '', 0, 0, 2005, 0, 'This is the Audio-CD entry. A DVD with a different track list under the same name is available too. ', 3009);
INSERT INTO 'album' VALUES (1140, '2022-04-29 20:33:41.028937+00', '2023-08-28 10:55:31.102244+00', 'Argentine Collection 2020, The', 'Argentine Coll', '', 0, 1, 2020, 1, '', 12122);
INSERT INTO 'album' VALUES (1137, '2021-09-30 19:17:09.701937+00', '2023-08-28 10:57:12.708857+00', 'A'' the best again fae Banffshire - 90 years of Scottish Country Dancing', 'Banffshire 90th', '', 0, 0, 2021, 0, '', 12069);
INSERT INTO 'album' VALUES (1139, '2022-01-13 13:50:26.621791+00', '2023-08-28 11:26:19.764496+00', 'RSCDS Dunfermline Branch 90th Anniversary Dances', 'Dunfermline 90th', '', 0, 1, 2019, 0, '', 2944);
INSERT INTO 'album' VALUES (1146, '2022-12-07 22:00:34.864591+00', '2025-04-15 15:06:43.761535+00', 'Grove Collection of SCDs Volume 2', '', '', 0, 1, 2022, 1, '', 11858);
INSERT INTO 'album' VALUES (1152, '2022-12-22 23:21:10.941243+00', '2022-12-23 13:10:49.736885+00', 'Scottish Dance World Of Jim MacLeod And His Band, The', 'SD World MacLeod', '', 0, 0, 1971, 0, 'This album seems to be a "remix" of the previous Albums "Scotland Swings" and "Scotland Swings Again", published by Label "Ace of Clubs". The editor of this entry only connected previous recordings to that album; no new recordings entry were made, not knowing if new tracks were recorded at all. ', 3009);
INSERT INTO 'album' VALUES (1154, '2022-12-26 13:10:41.991702+00', '2022-12-26 13:10:41.991702+00', 'Saturday Dance Volume One', 'SatDance01', '', 0, 0, 0, 0, '', 3016);
INSERT INTO 'album' VALUES (1155, '2022-12-26 13:14:49.181341+00', '2022-12-26 13:15:37.06393+00', 'Saturday Dance Volume Two', 'SatDance02', '', 0, 0, 0, 0, '', 3016);
INSERT INTO 'album' VALUES (1156, '2022-12-26 13:17:12.204258+00', '2022-12-26 13:18:31.038438+00', 'Saturday Dance Volume Three', 'SatDance03', '', 0, 0, 0, 0, '', 3016);
INSERT INTO 'album' VALUES (1157, '2022-12-26 13:19:12.913327+00', '2022-12-26 13:20:13.02718+00', 'Saturday Dance Volume Four', 'SatDance04', '', 0, 0, 0, 0, '', 3016);
INSERT INTO 'album' VALUES (1158, '2022-12-26 13:23:27.880353+00', '2022-12-26 13:24:33.143428+00', 'Dancing Memories Volume One', 'DancingMemories01', '', 0, 0, 0, 0, '', 3016);
INSERT INTO 'album' VALUES (1159, '2022-12-26 13:25:19.711243+00', '2022-12-26 13:25:58.704572+00', 'Dancing Memories Volume Two', 'DancingMemories02', '', 0, 0, 0, 0, '', 3016);
INSERT INTO 'album' VALUES (1161, '2022-12-26 13:29:05.018989+00', '2022-12-26 13:29:50.67249+00', 'Dancing Memories Volume Four', 'DancingMemories04', '', 0, 0, 0, 0, '', 3016);
INSERT INTO 'album' VALUES (1180, '2024-06-05 09:41:22.526566+00', '2024-09-08 20:39:47.238723+00', 'All Sets Complete!', '', '', 0, 0, 2024, 0, '', 12478);
INSERT INTO 'album' VALUES (1112, '2018-06-23 14:16:42.103466+00', '2023-06-17 10:43:14.726422+00', 'DuK''s Miss Milligan''s Miscellany', 'CD MMM Part 4', '', 0, 0, 2015, 0, 'The DuK CD has a few oddities:



- The track for "The Monifieth Star" has been recorded as eight repetitions of a 32-bar reel - but the dance in fact is a 48-bar reel.



- The track for "Newington Assembly" has been recorded as eight repetitions of a 48-bar reel but the dance is in fact a 32-bar reel. (The original tune is called "Newington Assembly").



There are re-recordings available, if you first login at the <<http://www.rscds.org|RSCDS Homepage>>:  

then go to <<https://rscds.org/shop/product/music/cd-mmm-part-4/>> from where you can download the two "remastered" tracks.', 11651);
INSERT INTO 'album' VALUES (383, '1999-01-30 23:00:00+00', '2023-08-28 11:25:03.044302+00', 'Rose and Thistle Collection, The', 'Rose & Thistle', 'IS', 1, 94, 1995, 1, '', 2188);
INSERT INTO 'album' VALUES (313, '1999-05-25 22:00:00+00', '2023-08-28 11:27:51.761117+00', 'Second Kirkbrae Collection, The', 'Kirkbrae 2', 'AP', 1, 306, 1998, 1, '', 2566);
INSERT INTO 'album' VALUES (229, '1998-10-26 23:00:00+00', '2023-08-28 11:28:53.163186+00', 'Silver Jubilee Oxford Book of Dances', 'Silver Jubilee', 'BC', 1, 305, 1994, 1, '', 1590);
INSERT INTO 'album' VALUES (469, '2005-01-27 23:00:00+00', '2023-08-28 11:36:15.924003+00', 'Third Kirkbrae Collection, The', 'Kirkbrae 3', '', 0, 0, 2004, 0, '', 2566);
INSERT INTO 'album' VALUES (1163, '2023-03-06 01:43:43.869279+00', '2023-11-12 15:02:11.414643+00', 'Thirty Popular Dances - Volume Two Part two', '', '', 0, 1, 2019, 1, 'Tracks 10 and 11 are written in the wrong order in the leaflet and on the outside of the CD. The order has been corrected here to that one on the CD.', 3016);
INSERT INTO 'album' VALUES (1177, '2024-05-03 13:19:53.104238+00', '2024-05-03 14:23:03.221505+00', 'In Honour Of, Volume 3', '', '', 0, 0, 2024, 0, '', 11858);
INSERT INTO 'album' VALUES (1173, '2024-03-06 22:01:02.580836+00', '2024-03-06 23:10:04.668372+00', 'RSCDS Glasgow Branch 100th Anniversary Dances', 'Glasgow Branch 100th', '', 0, 0, 2024, 0, 'Available from <<https://glasgowrscds.bandcamp.com/album/100th-anniversary-dances>>.', 12435);
INSERT INTO 'album' VALUES (1170, '2023-10-18 11:39:38.404863+00', '2023-10-20 21:29:24.40044+00', 'Hour of Pearl, The', 'Hour of Pearl', '', 0, 0, 2023, 0, 'See <<https://sotr.org.au/Pearl>>.', 11136);
INSERT INTO 'album' VALUES (1176, '2024-04-05 17:30:20.377845+00', '2024-04-05 17:53:17.057596+00', 'Jennifer''s Dances – Performance Dances', 'Jennifer''s Dncs (Perf)', '', 0, 0, 2020, 0, '', 12439);
INSERT INTO 'album' VALUES (1175, '2024-04-05 16:47:52.542407+00', '2024-04-05 21:53:52.677293+00', 'Jennifer''s Dances – Social Dances', 'Jennifer''s Dncs (Social)', '', 0, 0, 2020, 0, '', 12439);
INSERT INTO 'album' VALUES (1174, '2024-03-30 22:37:03.817971+00', '2024-04-01 15:10:42.17204+00', 'Auld Friends Meet', '', '', 0, 0, 2023, 0, 'A double CD album of music for dances from <<ddpub:Auld Friends Meet>> (a collection of <<ddp:Goldring, Roy>>''s dance leaflets).



See <<https://scotscores.com/product/auld-friends-meet-2/>>.', 12437);
INSERT INTO 'album' VALUES (187, '1998-05-04 22:00:00+00', '2024-06-11 20:10:58.145675+00', 'Scottish Favourites', 'Scot Favourites', '', 0, 438, 0, 1, 'NB only the tracks deemed suitable for dancing are listed here.', 3016);
INSERT INTO 'album' VALUES (1167, '2023-07-09 21:48:12.919018+00', '2025-07-15 10:44:43.975526+00', 'Book 53 for 2023 - Volume 1', 'Book 53 Vol 1', '', 0, 0, 2023, 0, '', 12327);
INSERT INTO 'album' VALUES (1166, '2023-07-09 21:46:13.369691+00', '2025-07-15 10:46:14.942634+00', 'Book 53 for 2023 - Volume 2', 'Book 53 Vol 2', '', 0, 0, 2023, 0, '', 10237);
INSERT INTO 'album' VALUES (101, '1998-11-20 23:00:00+00', '2023-08-18 10:03:22.806143+00', 'Best in Scottish Dance Music, The, Volume 2', 'Best in SDM 2', 'MK', 1, 411, 1982, 1, '', 3016);
INSERT INTO 'album' VALUES (1172, '2024-02-04 10:46:55.110913+00', '2024-02-04 11:56:43.129589+00', 'In the Sunlight of Nikko and Kamakura', '', '', 0, 1, 2024, 1, '', 11314);
INSERT INTO 'album' VALUES (1168, '2023-08-27 13:56:02.317286+00', '2023-08-27 15:22:51.161217+00', 'Salute to San Diego', '', '', 0, 0, 2023, 0, '', 12371);
INSERT INTO 'album' VALUES (946, '2010-01-19 23:00:00+00', '2023-08-28 10:50:04.951655+00', '12 Scottish Country Dances by Mervyn Short', '12 Mervyn Short', '', 0, 0, 2009, 0, '', 2696);
INSERT INTO 'album' VALUES (377, '2000-09-10 22:00:00+00', '2023-08-28 10:51:10.404826+00', '15 Social Dances', '15 Social Dances', 'AP', 1, 523, 2000, 2, '', 3002);
INSERT INTO 'album' VALUES (1079, '2014-10-02 01:43:08.527029+00', '2023-08-28 10:53:09.47823+00', '90 - Twelve anniversary dances celebrating ninety years of RSCDS Edinburgh Branch', 'Edinburgh 90', '', 0, 0, 2014, 0, '', 11017);
INSERT INTO 'album' VALUES (914, '2009-11-21 23:00:00+00', '2023-08-28 10:59:00.011018+00', 'Aye Afloat', 'Aye Afloat', '', 0, 0, 2007, 0, '', 2586);
INSERT INTO 'album' VALUES (1022, '2012-06-12 14:22:24.332147+00', '2023-08-28 11:00:32.458121+00', 'Berkhamsted Diamond Collection, The', 'Berkhamsted Diamond', '', 0, 0, 2011, 0, '', 3012);
INSERT INTO 'album' VALUES (154, '1999-01-20 23:00:00+00', '2023-08-28 11:03:54.304373+00', 'Dances from the Galloway Album', 'Galloway', 'JW', 1, 449, 0, 1, '', 2067);
INSERT INTO 'album' VALUES (192, '1998-07-16 22:00:00+00', '2023-08-28 11:12:57.803166+00', 'Ladies of Dunse, The', 'Ladies / Dunse', 'DM', 1, 219, 1995, 1, '', 1502);
INSERT INTO 'album' VALUES (439, '2003-07-27 22:00:00+00', '2023-08-28 11:14:19.0854+00', 'Leicester Branch 1977-2002 The Silver Collection', 'Leicester silver', 'LA', 1, 0, 2003, 0, 'This <<http://my.strathspey.org/dd/publication/1297/|booklet>> of this CD contains the description of five dances that are not contained in the actual book <<http://my.strathspey.org/dd/publication/83/|The Silver Collection>>. Those dances are Jaunty Jack, The Jovial Gentleman, Daunder in the Glen, The Heather Bank Jig, Bonnie Buchanhaven.', 3006);
INSERT INTO 'album' VALUES (1178, '2024-05-20 22:04:55.294486+00', '2024-05-21 15:43:29.914298+00', 'Formation Foundations - Blue CD', '', '', 0, 0, 2024, 0, '', 10659);
INSERT INTO 'album' VALUES (1179, '2024-05-21 17:20:43.555162+00', '2024-05-25 14:42:05.708596+00', 'Diack Dances, The', '', '', 0, 0, 2024, 0, 'This “album” does not really exist as a separate entity – the individual tracks have been made available for download on Google Drive. but it makes sense to collect them here.', 1575);
INSERT INTO 'album' VALUES (1164, '2023-04-06 10:04:35.187766+00', '2025-03-02 13:21:51.232125+00', 'Delaware Valley Gold', 'DV Gold', '', 0, 1, 2023, 0, '', 3016);
INSERT INTO 'album' VALUES (1171, '2024-01-12 08:44:03.38365+00', '2024-06-08 11:43:50.699825+00', 'Formation Foundations - Green CD', '', '', 0, 0, 2023, 0, '', 10659);
INSERT INTO 'album' VALUES (1181, '2024-06-25 14:43:02.761775+00', '2024-06-25 14:43:32.996381+00', 'Horses for Courses', '', '', 0, 0, 2024, 0, 'This is a stub entry. Recordings and tunes are still to be added.', 12486);
INSERT INTO 'album' VALUES (1165, '2023-04-22 16:40:41.893774+00', '2024-08-03 18:52:00.01925+00', 'Atlanta Fare', 'Atlanta Fare', '', 0, 0, 2021, 0, '16 Dances from the RSCDS Atlanta Branch.



NB some of the tunes used in the recordings are not yet added to SCDDB.', 11613);
INSERT INTO 'album' VALUES (1169, '2023-09-02 11:51:22.589981+00', '2025-09-02 15:23:41.015916+00', 'Dance Through the Decades', 'Dance Decades', '', 0, 0, 2023, 0, 'A Celebration of 100 Years Through Scottish Music and Dance: the accompanying CD for the RSCDS publication <<ddpub:Dance Through The Decades#1671>>.



Information from <<https://my.strathspey.org/dd/issue/3247/|issue 3247>>.



This is a stub entry. Most of the information about recordings and tunes still needs to be entered into the database.', 3050);
INSERT INTO 'album' VALUES (958, '2010-08-07 22:00:00+00', '2024-07-20 20:04:34.116908+00', 'Book 17 plus 3 Dances for 2009', 'Book XVII', '', 0, 0, 2010, 0, 'The RSCDS has uploaded this album to youtube as a playlist <<https://www.youtube.com/playlist?list=OLAK5uy_l4GSZ84YFy5Un22hyNLbSXOziMKmKUYFQ>>.



However as reported in <<https://my.strathspey.org/dd/issue/2447/|issue 2447>> the "video" for Bob Sanders was uploaded incorrectly.



And as further reported in <<https://my.strathspey.org/dd/issue/3609/|issue 3609>> several other tracks are messed up as well, for example Valentine and Donald Bane.', 3016);
INSERT INTO 'album' VALUES (1187, '2025-01-20 16:34:09.751754+00', '2025-01-21 18:48:48.925926+00', 'In Honour Of, Volume 2', '', '', 0, 0, 2022, 0, '', 11858);
INSERT INTO 'album' VALUES (1182, '2024-09-12 09:17:57.790983+00', '2024-09-12 09:35:56.383112+00', 'Fine Mix', '', '', 0, 0, 2008, 0, 'This CD has a mix of ballroom, latin and SCD recordings. Only those related to SCD have been added to SCDDB.



The details of the recordings were taken from <<https://gnudb.org/cd/100c8883>> with the number of repeats as expected from the playing time. The only known tune information comes from <<https://my.strathspey.org/dd/issue/3666/|issue 3666>>.', 12505);
INSERT INTO 'album' VALUES (259, '1999-08-07 22:00:00+00', '2024-11-10 20:18:28.199765+00', 'John Ellis and his Highland Country Band', 'J Ellis & HDB', 'RC', 1, 125, 1980, 1, 'This album has several listening tracks with are not listed here. And some dancing tracks are still to be added.', 3056);
INSERT INTO 'album' VALUES (1186, '2025-01-20 16:31:21.240913+00', '2025-01-21 21:09:54.472744+00', 'In Honour Of, Volume 1', '', '', 0, 0, 2022, 0, '', 11858);
INSERT INTO 'album' VALUES (1196, '2025-08-11 09:53:53.396123+00', '2025-08-11 14:32:30.734303+00', 'Sir Walter Scott, The Heart of Mid-Lothian', '', '', 0, 0, 2021, 0, '', 12665);
INSERT INTO 'album' VALUES (1192, '2025-03-24 14:55:45.768159+00', '2025-03-24 18:33:19.316547+00', 'Lower Hutt SCD Club 60th Anniversary', '', '', 0, 0, 0, 0, '', 3016);
INSERT INTO 'album' VALUES (1188, '2025-01-25 23:06:55.681847+00', '2025-01-25 23:42:26.414209+00', 'Ready And...', '', '', 0, 0, 2024, 0, 'Tunes have so far only been added to the recordings if they were already known to the database.', 12541);
INSERT INTO 'album' VALUES (1183, '2024-11-14 21:06:33.449297+00', '2024-11-14 23:30:33.506454+00', 'Dance Around the World', 'Around the World', '', 0, 0, 2024, 0, 'Many of the tunes used in the recordings are still to be added...', 3023);
INSERT INTO 'album' VALUES (1193, '2025-05-05 21:46:33.064584+00', '2025-05-05 22:21:10.957136+00', 'Dances of Valour', '', '', 0, 0, 2025, 0, '', 11858);
INSERT INTO 'album' VALUES (1189, '2025-01-25 23:07:53.769563+00', '2025-01-26 11:55:42.800565+00', 'After the Rain', '', '', 0, 0, 2020, 0, '', 3217);
INSERT INTO 'album' VALUES (236, '1998-11-11 23:00:00+00', '2025-01-28 20:01:17.863975+00', 'Ten SCD - Leeds Branch Silver Jubilee', '10 SCD - Leeds', 'OO', 1, 76, 1987, 1, 'On the remastered CD (SSCD 38) the tracks are in a different order.  

1: The Weathercock  

2: The Rose of the North  

3: The Travelling Man  

4: Loch Linnhe  

5: The Highland Rambler  

6: West Park  

7: The Porridge Bowl  

8: The Marquess of Hartington''s Strathspey  

9: The Marchioness of Hartington''s Jig  

10: The Tocher Band



And the CD also lists <<ddp:Kerr, Ron#2266>> and Ronnie Currie as members of the band.', 2043);
INSERT INTO 'album' VALUES (1195, '2025-07-11 22:46:14.356518+00', '2025-08-13 17:11:14.080086+00', 'Book 54 - Music for 18 Scottish Country Dances', 'Book 54', '', 0, 0, 2025, 0, 'This is a double CD album.  This database entry lists all tracks on both CDs.



Jeremy Hill (RSCDS Membership Services) has reported that there are a number of typos in the CD booklet.

It is believed these have all been corrected in the SCDDB entries and are detailed there, but in summary:

- Dancing Forth:  composer names corrected

- Miss Lucy Clark: rhythm corrected (from strathspey to reel)

- Kathy''s Fascinator: tune name corrected

- The Waternish Tangle: composer name updated

- Thank You Patricia: tune name corrected', 12645);
INSERT INTO 'album' VALUES (1184, '2024-11-16 19:53:03.409075+00', '2024-11-17 18:42:01.759399+00', '14 New Dances and Tunes Celebrating the Centenary of RSCDS Edinburgh Branch', 'Edinburgh 100', '', 0, 0, 2024, 0, '', 12522);
INSERT INTO 'album' VALUES (1194, '2025-06-08 22:13:40.153978+00', '2025-06-09 00:24:03.773912+00', 'Start Dancing', '', '', 0, 0, 2023, 0, '', 3016);
INSERT INTO 'album' VALUES (1190, '2025-03-09 20:50:24.42863+00', '2025-03-15 23:27:21.938636+00', 'Welcome to Manchester', 'Manchester 90th', '', 0, 0, 2025, 0, 'Welcome to Manchester and other dances to celebrate our 90th anniversary.', 11185);
INSERT INTO 'album' VALUES (1191, '2025-03-12 14:46:52.821834+00', '2025-03-19 11:05:22.341783+00', 'Scottish Accordion Gems', '', '', 0, 0, 2018, 0, 'This is a partial entry. Only likely SCD recordings with tunes in SCDDB have been added (mostly based on <<https://www.discogs.com/release/27102741-Ronnie-Ross-Scottish-Accordion-Gems>>).', 12580);
INSERT INTO 'album' VALUES (333, '1998-12-01 23:00:00+00', '2025-03-24 12:08:52.982661+00', 'Dances Frae the North', 'Frae the North', 'BC', 1, 18, 1986, 1, '', 2059);
INSERT INTO 'album' VALUES (1185, '2024-12-18 11:04:49.66075+00', '2024-12-20 21:01:57.237305+00', 'RSCDS Cheshire Branch 40th Anniversary', 'Cheshire 40th Anniversary', '', 0, 0, 2024, 0, '', 3039);
INSERT INTO 'album' VALUES (401, '2002-02-24 23:00:00+00', '2025-11-03 22:25:09.900373+00', 'Delft Book of Scottish Country Dances, The', 'Delft', 'AP', 1, 535, 2001, 2, 'During the years 1973-1998 some members of the RSCDS Delft Branch in the Netherlands devised a variety of dances. A number was published in the Delft Book of Scottish Country Dances (2001). For some of the dances Alastair Hunter and Muriel Johnstone were asked to compose music. Their original recordings were on MC. As the music was taken from those originals, the CD does not offer studio quality.', 3016);
INSERT INTO 'album' VALUES (500, '2006-06-27 22:00:00+00', '2025-07-28 23:50:47.853673+00', 'A'' the best fae Banffshire', 'Banffshire', 'AP', 1, 0, 2006, 0, 'There are some strange things about this CD:



- According to the book, the tune for the dance <<ddd:Gourdieburn>>, is <<ddt:Walter and Betty Rutherford>>, but the CD uses that tune as the lead tune for <<ddd:Moranbank>>.

- Instead, the tune used for <<ddd:Gourdieburn>> is <<ddt:Modley House>>, which is not in the book at all.

- The tune given in the book for <<ddd:Moranbank>> (also called <<ddt:Moranbank>>) does not seem to appear anywhere on the CD.', 3023);


--
INSERT INTO 'albumsrecordingsmap' VALUES (1, 3, 1, 50);
INSERT INTO 'albumsrecordingsmap' VALUES (2, 16, 1, 59);
INSERT INTO 'albumsrecordingsmap' VALUES (3, 1, 1, 72);
INSERT INTO 'albumsrecordingsmap' VALUES (4, 6, 1, 88);
INSERT INTO 'albumsrecordingsmap' VALUES (5, 15, 1, 90);
INSERT INTO 'albumsrecordingsmap' VALUES (6, 11, 1, 106);
INSERT INTO 'albumsrecordingsmap' VALUES (7, 4, 1, 117);
INSERT INTO 'albumsrecordingsmap' VALUES (8, 14, 1, 149);
INSERT INTO 'albumsrecordingsmap' VALUES (9, 12, 1, 157);
INSERT INTO 'albumsrecordingsmap' VALUES (10, 13, 1, 200);
INSERT INTO 'albumsrecordingsmap' VALUES (11, 5, 1, 290);
INSERT INTO 'albumsrecordingsmap' VALUES (12, 7, 1, 337);
INSERT INTO 'albumsrecordingsmap' VALUES (13, 9, 1, 345);
INSERT INTO 'albumsrecordingsmap' VALUES (14, 8, 1, 350);
INSERT INTO 'albumsrecordingsmap' VALUES (15, 10, 2, 272);
INSERT INTO 'albumsrecordingsmap' VALUES (16, 3, 2, 309);
INSERT INTO 'albumsrecordingsmap' VALUES (17, 12, 2, 341);
INSERT INTO 'albumsrecordingsmap' VALUES (18, 9, 3, 21);
INSERT INTO 'albumsrecordingsmap' VALUES (19, 5, 3, 46);
INSERT INTO 'albumsrecordingsmap' VALUES (20, 2, 3, 97);
INSERT INTO 'albumsrecordingsmap' VALUES (21, 8, 3, 150);
INSERT INTO 'albumsrecordingsmap' VALUES (22, 11, 3, 154);
INSERT INTO 'albumsrecordingsmap' VALUES (23, 1, 3, 155);
INSERT INTO 'albumsrecordingsmap' VALUES (24, 3, 3, 161);
INSERT INTO 'albumsrecordingsmap' VALUES (25, 10, 3, 214);
INSERT INTO 'albumsrecordingsmap' VALUES (26, 6, 3, 230);
INSERT INTO 'albumsrecordingsmap' VALUES (27, 4, 3, 362);
INSERT INTO 'albumsrecordingsmap' VALUES (28, 1, 4, 8);
INSERT INTO 'albumsrecordingsmap' VALUES (29, 2, 4, 14);
INSERT INTO 'albumsrecordingsmap' VALUES (30, 4, 4, 34);
INSERT INTO 'albumsrecordingsmap' VALUES (31, 7, 4, 45);
INSERT INTO 'albumsrecordingsmap' VALUES (32, 6, 4, 91);
INSERT INTO 'albumsrecordingsmap' VALUES (33, 10, 4, 116);
INSERT INTO 'albumsrecordingsmap' VALUES (34, 5, 4, 128);
INSERT INTO 'albumsrecordingsmap' VALUES (35, 9, 4, 147);
INSERT INTO 'albumsrecordingsmap' VALUES (36, 8, 4, 286);
INSERT INTO 'albumsrecordingsmap' VALUES (37, 3, 4, 366);
INSERT INTO 'albumsrecordingsmap' VALUES (38, 1, 5, 15);
INSERT INTO 'albumsrecordingsmap' VALUES (39, 4, 5, 119);
INSERT INTO 'albumsrecordingsmap' VALUES (40, 5, 5, 144);
INSERT INTO 'albumsrecordingsmap' VALUES (41, 6, 5, 160);
INSERT INTO 'albumsrecordingsmap' VALUES (42, 9, 5, 183);
INSERT INTO 'albumsrecordingsmap' VALUES (43, 8, 5, 195);
INSERT INTO 'albumsrecordingsmap' VALUES (44, 10, 5, 197);
INSERT INTO 'albumsrecordingsmap' VALUES (45, 11, 5, 210);
INSERT INTO 'albumsrecordingsmap' VALUES (46, 12, 5, 284);
INSERT INTO 'albumsrecordingsmap' VALUES (47, 13, 5, 314);
INSERT INTO 'albumsrecordingsmap' VALUES (48, 5, 7, 3);
INSERT INTO 'albumsrecordingsmap' VALUES (49, 10, 7, 86);
INSERT INTO 'albumsrecordingsmap' VALUES (50, 12, 7, 198);
INSERT INTO 'albumsrecordingsmap' VALUES (51, 13, 7, 295);
INSERT INTO 'albumsrecordingsmap' VALUES (52, 4, 7, 297);
INSERT INTO 'albumsrecordingsmap' VALUES (53, 2, 7, 299);
INSERT INTO 'albumsrecordingsmap' VALUES (54, 8, 7, 300);
INSERT INTO 'albumsrecordingsmap' VALUES (55, 1, 7, 303);
INSERT INTO 'albumsrecordingsmap' VALUES (56, 11, 7, 304);
INSERT INTO 'albumsrecordingsmap' VALUES (57, 7, 7, 307);
INSERT INTO 'albumsrecordingsmap' VALUES (58, 14, 7, 308);
INSERT INTO 'albumsrecordingsmap' VALUES (59, 3, 7, 310);
INSERT INTO 'albumsrecordingsmap' VALUES (60, 6, 7, 348);
INSERT INTO 'albumsrecordingsmap' VALUES (61, 11, 8, 42);
INSERT INTO 'albumsrecordingsmap' VALUES (62, 8, 8, 124);
INSERT INTO 'albumsrecordingsmap' VALUES (63, 9, 8, 129);
INSERT INTO 'albumsrecordingsmap' VALUES (64, 1, 8, 134);
INSERT INTO 'albumsrecordingsmap' VALUES (65, 6, 8, 163);
INSERT INTO 'albumsrecordingsmap' VALUES (66, 15, 8, 164);
INSERT INTO 'albumsrecordingsmap' VALUES (67, 13, 8, 298);
INSERT INTO 'albumsrecordingsmap' VALUES (68, 14, 8, 305);
INSERT INTO 'albumsrecordingsmap' VALUES (69, 2, 8, 343);
INSERT INTO 'albumsrecordingsmap' VALUES (70, 15, 9, 11);
INSERT INTO 'albumsrecordingsmap' VALUES (71, 3, 9, 31);
INSERT INTO 'albumsrecordingsmap' VALUES (72, 11, 9, 67);
INSERT INTO 'albumsrecordingsmap' VALUES (73, 5, 9, 73);
INSERT INTO 'albumsrecordingsmap' VALUES (74, 9, 9, 87);
INSERT INTO 'albumsrecordingsmap' VALUES (75, 16, 9, 143);
INSERT INTO 'albumsrecordingsmap' VALUES (76, 13, 9, 156);
INSERT INTO 'albumsrecordingsmap' VALUES (77, 2, 9, 162);
INSERT INTO 'albumsrecordingsmap' VALUES (78, 14, 9, 276);
INSERT INTO 'albumsrecordingsmap' VALUES (79, 14, 10, 13);
INSERT INTO 'albumsrecordingsmap' VALUES (80, 13, 10, 22);
INSERT INTO 'albumsrecordingsmap' VALUES (81, 9, 10, 48);
INSERT INTO 'albumsrecordingsmap' VALUES (82, 4, 10, 54);
INSERT INTO 'albumsrecordingsmap' VALUES (83, 12, 10, 96);
INSERT INTO 'albumsrecordingsmap' VALUES (84, 1, 10, 127);
INSERT INTO 'albumsrecordingsmap' VALUES (85, 2, 10, 247);
INSERT INTO 'albumsrecordingsmap' VALUES (86, 5, 10, 248);
INSERT INTO 'albumsrecordingsmap' VALUES (87, 7, 10, 342);
INSERT INTO 'albumsrecordingsmap' VALUES (88, 11, 10, 364);
INSERT INTO 'albumsrecordingsmap' VALUES (89, 3, 11, 6);
INSERT INTO 'albumsrecordingsmap' VALUES (90, 1, 11, 20);
INSERT INTO 'albumsrecordingsmap' VALUES (91, 7, 11, 25);
INSERT INTO 'albumsrecordingsmap' VALUES (92, 4, 11, 36);
INSERT INTO 'albumsrecordingsmap' VALUES (9319, 1, 1017, 8847);
INSERT INTO 'albumsrecordingsmap' VALUES (9320, 2, 1017, 8848);
INSERT INTO 'albumsrecordingsmap' VALUES (9321, 3, 1017, 8849);
INSERT INTO 'albumsrecordingsmap' VALUES (9324, 1, 1018, 1734);
INSERT INTO 'albumsrecordingsmap' VALUES (9325, 2, 1018, 4154);
INSERT INTO 'albumsrecordingsmap' VALUES (9326, 3, 1018, 1735);
INSERT INTO 'albumsrecordingsmap' VALUES (9339, 1, 1019, 8852);
INSERT INTO 'albumsrecordingsmap' VALUES (9340, 2, 1019, 8853);
INSERT INTO 'albumsrecordingsmap' VALUES (9341, 3, 1019, 8854);
INSERT INTO 'albumsrecordingsmap' VALUES (9342, 4, 1019, 8855);
INSERT INTO 'albumsrecordingsmap' VALUES (9343, 5, 1019, 8856);
INSERT INTO 'albumsrecordingsmap' VALUES (9344, 6, 1019, 8857);
INSERT INTO 'albumsrecordingsmap' VALUES (9345, 7, 1019, 8858);
INSERT INTO 'albumsrecordingsmap' VALUES (9346, 8, 1019, 8859);
INSERT INTO 'albumsrecordingsmap' VALUES (9347, 9, 1019, 8860);
INSERT INTO 'albumsrecordingsmap' VALUES (9348, 10, 1019, 8861);
INSERT INTO 'albumsrecordingsmap' VALUES (9349, 11, 1019, 8862);
INSERT INTO 'albumsrecordingsmap' VALUES (9350, 12, 1019, 8863);
INSERT INTO 'albumsrecordingsmap' VALUES (9351, 13, 1019, 8864);
INSERT INTO 'albumsrecordingsmap' VALUES (9352, 14, 1019, 8865);
INSERT INTO 'albumsrecordingsmap' VALUES (9353, 15, 1019, 8866);
INSERT INTO 'albumsrecordingsmap' VALUES (9358, 1, 1020, 8871);
INSERT INTO 'albumsrecordingsmap' VALUES (9359, 2, 1020, 8872);
INSERT INTO 'albumsrecordingsmap' VALUES (9360, 3, 1020, 8873);
INSERT INTO 'albumsrecordingsmap' VALUES (9371, 1, 1021, 8884);
INSERT INTO 'albumsrecordingsmap' VALUES (9372, 2, 1021, 8885);
INSERT INTO 'albumsrecordingsmap' VALUES (9373, 3, 1021, 8886);
INSERT INTO 'albumsrecordingsmap' VALUES (9380, 10, 1021, 8893);
INSERT INTO 'albumsrecordingsmap' VALUES (9381, 11, 1021, 8894);
INSERT INTO 'albumsrecordingsmap' VALUES (9382, 12, 1021, 8895);
INSERT INTO 'albumsrecordingsmap' VALUES (9383, 13, 1021, 8896);
INSERT INTO 'albumsrecordingsmap' VALUES (9384, 14, 1021, 8897);
INSERT INTO 'albumsrecordingsmap' VALUES (9385, 15, 1021, 8898);
INSERT INTO 'albumsrecordingsmap' VALUES (9387, 1, 1022, 8900);
INSERT INTO 'albumsrecordingsmap' VALUES (9388, 2, 1022, 8901);
INSERT INTO 'albumsrecordingsmap' VALUES (9389, 3, 1022, 8902);
INSERT INTO 'albumsrecordingsmap' VALUES (9393, 7, 1022, 8906);
INSERT INTO 'albumsrecordingsmap' VALUES (9394, 8, 1022, 8907);
INSERT INTO 'albumsrecordingsmap' VALUES (9395, 9, 1022, 8908);
INSERT INTO 'albumsrecordingsmap' VALUES (9397, 11, 1022, 8911);
INSERT INTO 'albumsrecordingsmap' VALUES (9398, 12, 1022, 8912);
INSERT INTO 'albumsrecordingsmap' VALUES (9399, 13, 1022, 8913);
INSERT INTO 'albumsrecordingsmap' VALUES (9400, 14, 1022, 8914);
INSERT INTO 'albumsrecordingsmap' VALUES (9401, 15, 1022, 8915);
INSERT INTO 'albumsrecordingsmap' VALUES (9402, 16, 1022, 8916);
INSERT INTO 'albumsrecordingsmap' VALUES (9403, 17, 1022, 8917);
INSERT INTO 'albumsrecordingsmap' VALUES (9404, 1, 1023, 8918);
INSERT INTO 'albumsrecordingsmap' VALUES (9416, 13, 1023, 8930);
INSERT INTO 'albumsrecordingsmap' VALUES (9417, 14, 1023, 8931);
INSERT INTO 'albumsrecordingsmap' VALUES (9426, 3, 1025, 6591);
INSERT INTO 'albumsrecordingsmap' VALUES (9436, 13, 1025, 7785);
INSERT INTO 'albumsrecordingsmap' VALUES (9437, 14, 1025, 7786);
INSERT INTO 'albumsrecordingsmap' VALUES (9438, 15, 1025, 7799);
INSERT INTO 'albumsrecordingsmap' VALUES (9424, 1, 1025, 6874);
INSERT INTO 'albumsrecordingsmap' VALUES (9425, 2, 1025, 6875);
INSERT INTO 'albumsrecordingsmap' VALUES (9443, 14, 494, 8932);
INSERT INTO 'albumsrecordingsmap' VALUES (9453, 1, 1026, 8942);
INSERT INTO 'albumsrecordingsmap' VALUES (9454, 2, 1026, 8943);
INSERT INTO 'albumsrecordingsmap' VALUES (9455, 3, 1026, 8944);
INSERT INTO 'albumsrecordingsmap' VALUES (9459, 7, 1026, 8848);
INSERT INTO 'albumsrecordingsmap' VALUES (9460, 8, 1026, 8945);
INSERT INTO 'albumsrecordingsmap' VALUES (9461, 9, 1026, 8946);
INSERT INTO 'albumsrecordingsmap' VALUES (9462, 10, 1026, 8850);
INSERT INTO 'albumsrecordingsmap' VALUES (9463, 11, 1026, 8947);
INSERT INTO 'albumsrecordingsmap' VALUES (9464, 12, 1026, 8948);
INSERT INTO 'albumsrecordingsmap' VALUES (9466, 1, 1027, 8950);
INSERT INTO 'albumsrecordingsmap' VALUES (9467, 2, 1027, 8951);
INSERT INTO 'albumsrecordingsmap' VALUES (9468, 3, 1027, 8952);
INSERT INTO 'albumsrecordingsmap' VALUES (9469, 4, 1027, 8953);
INSERT INTO 'albumsrecordingsmap' VALUES (9470, 5, 1027, 8954);
INSERT INTO 'albumsrecordingsmap' VALUES (9471, 6, 1027, 8955);
INSERT INTO 'albumsrecordingsmap' VALUES (9472, 7, 1027, 8956);
INSERT INTO 'albumsrecordingsmap' VALUES (9473, 8, 1027, 8957);
INSERT INTO 'albumsrecordingsmap' VALUES (9478, 1, 1028, 8961);
INSERT INTO 'albumsrecordingsmap' VALUES (9479, 2, 1028, 8962);
INSERT INTO 'albumsrecordingsmap' VALUES (9480, 3, 1028, 8963);
INSERT INTO 'albumsrecordingsmap' VALUES (9481, 4, 1028, 8964);
INSERT INTO 'albumsrecordingsmap' VALUES (9482, 5, 1028, 8965);
INSERT INTO 'albumsrecordingsmap' VALUES (93, 12, 11, 58);
INSERT INTO 'albumsrecordingsmap' VALUES (94, 6, 11, 69);
INSERT INTO 'albumsrecordingsmap' VALUES (95, 8, 11, 132);
INSERT INTO 'albumsrecordingsmap' VALUES (96, 5, 11, 208);
INSERT INTO 'albumsrecordingsmap' VALUES (97, 11, 11, 222);
INSERT INTO 'albumsrecordingsmap' VALUES (98, 14, 11, 241);
INSERT INTO 'albumsrecordingsmap' VALUES (99, 2, 11, 260);
INSERT INTO 'albumsrecordingsmap' VALUES (100, 9, 11, 287);
INSERT INTO 'albumsrecordingsmap' VALUES (101, 4, 12, 4);
INSERT INTO 'albumsrecordingsmap' VALUES (102, 3, 12, 5);
INSERT INTO 'albumsrecordingsmap' VALUES (9444, 29, 490, 8933);
INSERT INTO 'albumsrecordingsmap' VALUES (9445, 30, 490, 8934);
INSERT INTO 'albumsrecordingsmap' VALUES (103, 8, 12, 7);
INSERT INTO 'albumsrecordingsmap' VALUES (104, 1, 12, 16);
INSERT INTO 'albumsrecordingsmap' VALUES (105, 14, 12, 178);
INSERT INTO 'albumsrecordingsmap' VALUES (106, 7, 12, 226);
INSERT INTO 'albumsrecordingsmap' VALUES (107, 9, 12, 238);
INSERT INTO 'albumsrecordingsmap' VALUES (108, 13, 12, 255);
INSERT INTO 'albumsrecordingsmap' VALUES (109, 12, 12, 261);
INSERT INTO 'albumsrecordingsmap' VALUES (110, 10, 12, 283);
INSERT INTO 'albumsrecordingsmap' VALUES (111, 9, 13, 1);
INSERT INTO 'albumsrecordingsmap' VALUES (112, 11, 13, 40);
INSERT INTO 'albumsrecordingsmap' VALUES (113, 8, 13, 43);
INSERT INTO 'albumsrecordingsmap' VALUES (114, 10, 13, 55);
INSERT INTO 'albumsrecordingsmap' VALUES (115, 5, 13, 109);
INSERT INTO 'albumsrecordingsmap' VALUES (116, 12, 13, 137);
INSERT INTO 'albumsrecordingsmap' VALUES (117, 14, 13, 199);
INSERT INTO 'albumsrecordingsmap' VALUES (118, 13, 13, 229);
INSERT INTO 'albumsrecordingsmap' VALUES (119, 1, 13, 271);
INSERT INTO 'albumsrecordingsmap' VALUES (120, 6, 13, 317);
INSERT INTO 'albumsrecordingsmap' VALUES (121, 7, 13, 324);
INSERT INTO 'albumsrecordingsmap' VALUES (122, 4, 13, 344);
INSERT INTO 'albumsrecordingsmap' VALUES (123, 2, 13, 368);
INSERT INTO 'albumsrecordingsmap' VALUES (124, 10, 14, 108);
INSERT INTO 'albumsrecordingsmap' VALUES (125, 9, 14, 130);
INSERT INTO 'albumsrecordingsmap' VALUES (126, 4, 14, 175);
INSERT INTO 'albumsrecordingsmap' VALUES (127, 14, 14, 187);
INSERT INTO 'albumsrecordingsmap' VALUES (128, 13, 14, 203);
INSERT INTO 'albumsrecordingsmap' VALUES (129, 3, 14, 221);
INSERT INTO 'albumsrecordingsmap' VALUES (130, 7, 14, 254);
INSERT INTO 'albumsrecordingsmap' VALUES (131, 2, 14, 256);
INSERT INTO 'albumsrecordingsmap' VALUES (132, 1, 14, 354);
INSERT INTO 'albumsrecordingsmap' VALUES (133, 12, 14, 363);
INSERT INTO 'albumsrecordingsmap' VALUES (134, 15, 15, 29);
INSERT INTO 'albumsrecordingsmap' VALUES (135, 5, 15, 44);
INSERT INTO 'albumsrecordingsmap' VALUES (136, 1, 15, 80);
INSERT INTO 'albumsrecordingsmap' VALUES (137, 12, 15, 111);
INSERT INTO 'albumsrecordingsmap' VALUES (138, 10, 15, 118);
INSERT INTO 'albumsrecordingsmap' VALUES (139, 16, 15, 125);
INSERT INTO 'albumsrecordingsmap' VALUES (140, 13, 15, 135);
INSERT INTO 'albumsrecordingsmap' VALUES (141, 8, 15, 174);
INSERT INTO 'albumsrecordingsmap' VALUES (142, 11, 15, 205);
INSERT INTO 'albumsrecordingsmap' VALUES (143, 9, 15, 245);
INSERT INTO 'albumsrecordingsmap' VALUES (144, 17, 15, 262);
INSERT INTO 'albumsrecordingsmap' VALUES (145, 7, 15, 296);
INSERT INTO 'albumsrecordingsmap' VALUES (146, 14, 15, 325);
INSERT INTO 'albumsrecordingsmap' VALUES (147, 3, 15, 356);
INSERT INTO 'albumsrecordingsmap' VALUES (148, 3, 16, 28);
INSERT INTO 'albumsrecordingsmap' VALUES (149, 12, 16, 39);
INSERT INTO 'albumsrecordingsmap' VALUES (150, 5, 16, 61);
INSERT INTO 'albumsrecordingsmap' VALUES (151, 6, 16, 136);
INSERT INTO 'albumsrecordingsmap' VALUES (152, 4, 16, 152);
INSERT INTO 'albumsrecordingsmap' VALUES (153, 11, 16, 177);
INSERT INTO 'albumsrecordingsmap' VALUES (154, 1, 16, 181);
INSERT INTO 'albumsrecordingsmap' VALUES (155, 7, 16, 202);
INSERT INTO 'albumsrecordingsmap' VALUES (156, 8, 16, 224);
INSERT INTO 'albumsrecordingsmap' VALUES (157, 2, 16, 267);
INSERT INTO 'albumsrecordingsmap' VALUES (158, 10, 16, 353);
INSERT INTO 'albumsrecordingsmap' VALUES (159, 12, 17, 9);
INSERT INTO 'albumsrecordingsmap' VALUES (160, 17, 17, 52);
INSERT INTO 'albumsrecordingsmap' VALUES (161, 7, 17, 53);
INSERT INTO 'albumsrecordingsmap' VALUES (162, 4, 17, 57);
INSERT INTO 'albumsrecordingsmap' VALUES (163, 8, 17, 64);
INSERT INTO 'albumsrecordingsmap' VALUES (164, 6, 17, 85);
INSERT INTO 'albumsrecordingsmap' VALUES (165, 14, 17, 104);
INSERT INTO 'albumsrecordingsmap' VALUES (166, 16, 17, 112);
INSERT INTO 'albumsrecordingsmap' VALUES (167, 5, 17, 114);
INSERT INTO 'albumsrecordingsmap' VALUES (168, 2, 17, 148);
INSERT INTO 'albumsrecordingsmap' VALUES (169, 9, 17, 193);
INSERT INTO 'albumsrecordingsmap' VALUES (170, 13, 17, 234);
INSERT INTO 'albumsrecordingsmap' VALUES (171, 10, 17, 257);
INSERT INTO 'albumsrecordingsmap' VALUES (172, 1, 17, 278);
INSERT INTO 'albumsrecordingsmap' VALUES (173, 11, 17, 355);
INSERT INTO 'albumsrecordingsmap' VALUES (174, 8, 18, 105);
INSERT INTO 'albumsrecordingsmap' VALUES (175, 2, 18, 110);
INSERT INTO 'albumsrecordingsmap' VALUES (176, 3, 18, 139);
INSERT INTO 'albumsrecordingsmap' VALUES (177, 1, 18, 184);
INSERT INTO 'albumsrecordingsmap' VALUES (178, 10, 18, 188);
INSERT INTO 'albumsrecordingsmap' VALUES (179, 6, 18, 207);
INSERT INTO 'albumsrecordingsmap' VALUES (180, 7, 18, 228);
INSERT INTO 'albumsrecordingsmap' VALUES (181, 12, 18, 333);
INSERT INTO 'albumsrecordingsmap' VALUES (182, 10, 19, 17);
INSERT INTO 'albumsrecordingsmap' VALUES (183, 4, 19, 82);
INSERT INTO 'albumsrecordingsmap' VALUES (184, 1, 19, 83);
INSERT INTO 'albumsrecordingsmap' VALUES (185, 11, 19, 166);
INSERT INTO 'albumsrecordingsmap' VALUES (9322, 4, 1017, 8850);
INSERT INTO 'albumsrecordingsmap' VALUES (9323, 5, 1017, 8851);
INSERT INTO 'albumsrecordingsmap' VALUES (9327, 4, 1018, 4148);
INSERT INTO 'albumsrecordingsmap' VALUES (9328, 5, 1018, 1732);
INSERT INTO 'albumsrecordingsmap' VALUES (9329, 6, 1018, 4155);
INSERT INTO 'albumsrecordingsmap' VALUES (9354, 16, 1019, 8867);
INSERT INTO 'albumsrecordingsmap' VALUES (9355, 17, 1019, 8868);
INSERT INTO 'albumsrecordingsmap' VALUES (9356, 18, 1019, 8869);
INSERT INTO 'albumsrecordingsmap' VALUES (9361, 4, 1020, 8874);
INSERT INTO 'albumsrecordingsmap' VALUES (9362, 5, 1020, 8875);
INSERT INTO 'albumsrecordingsmap' VALUES (9363, 6, 1020, 8876);
INSERT INTO 'albumsrecordingsmap' VALUES (9374, 4, 1021, 8887);
INSERT INTO 'albumsrecordingsmap' VALUES (9375, 5, 1021, 8888);
INSERT INTO 'albumsrecordingsmap' VALUES (9376, 6, 1021, 8889);
INSERT INTO 'albumsrecordingsmap' VALUES (9386, 16, 1021, 8899);
INSERT INTO 'albumsrecordingsmap' VALUES (9390, 5, 1022, 8903);
INSERT INTO 'albumsrecordingsmap' VALUES (9391, 4, 1022, 8904);
INSERT INTO 'albumsrecordingsmap' VALUES (9405, 2, 1023, 8919);
INSERT INTO 'albumsrecordingsmap' VALUES (9427, 4, 1025, 6592);
INSERT INTO 'albumsrecordingsmap' VALUES (9428, 5, 1025, 6593);
INSERT INTO 'albumsrecordingsmap' VALUES (9429, 6, 1025, 6780);
INSERT INTO 'albumsrecordingsmap' VALUES (9439, 16, 1025, 7800);
INSERT INTO 'albumsrecordingsmap' VALUES (9440, 17, 1025, 7801);
INSERT INTO 'albumsrecordingsmap' VALUES (9456, 4, 1026, 2355);
INSERT INTO 'albumsrecordingsmap' VALUES (9457, 5, 1026, 8847);
INSERT INTO 'albumsrecordingsmap' VALUES (9458, 6, 1026, 8849);
INSERT INTO 'albumsrecordingsmap' VALUES (9465, 13, 1026, 8949);
INSERT INTO 'albumsrecordingsmap' VALUES (9474, 9, 1027, 8958);
INSERT INTO 'albumsrecordingsmap' VALUES (9475, 10, 1027, 8959);
INSERT INTO 'albumsrecordingsmap' VALUES (9476, 11, 1027, 8851);
INSERT INTO 'albumsrecordingsmap' VALUES (9484, 8, 1028, 8967);
INSERT INTO 'albumsrecordingsmap' VALUES (186, 2, 19, 172);
INSERT INTO 'albumsrecordingsmap' VALUES (187, 12, 19, 268);
INSERT INTO 'albumsrecordingsmap' VALUES (188, 5, 19, 293);
INSERT INTO 'albumsrecordingsmap' VALUES (189, 3, 19, 311);
INSERT INTO 'albumsrecordingsmap' VALUES (190, 8, 19, 318);
INSERT INTO 'albumsrecordingsmap' VALUES (191, 9, 19, 322);
INSERT INTO 'albumsrecordingsmap' VALUES (192, 8, 20, 62);
INSERT INTO 'albumsrecordingsmap' VALUES (193, 13, 20, 77);
INSERT INTO 'albumsrecordingsmap' VALUES (194, 9, 20, 211);
INSERT INTO 'albumsrecordingsmap' VALUES (195, 14, 20, 265);
INSERT INTO 'albumsrecordingsmap' VALUES (196, 10, 20, 285);
INSERT INTO 'albumsrecordingsmap' VALUES (197, 6, 20, 319);
INSERT INTO 'albumsrecordingsmap' VALUES (198, 6, 21, 37);
INSERT INTO 'albumsrecordingsmap' VALUES (199, 5, 21, 56);
INSERT INTO 'albumsrecordingsmap' VALUES (200, 7, 21, 79);
INSERT INTO 'albumsrecordingsmap' VALUES (201, 9, 21, 151);
INSERT INTO 'albumsrecordingsmap' VALUES (202, 8, 21, 180);
INSERT INTO 'albumsrecordingsmap' VALUES (203, 11, 21, 251);
INSERT INTO 'albumsrecordingsmap' VALUES (204, 10, 21, 258);
INSERT INTO 'albumsrecordingsmap' VALUES (205, 4, 21, 273);
INSERT INTO 'albumsrecordingsmap' VALUES (206, 3, 21, 281);
INSERT INTO 'albumsrecordingsmap' VALUES (207, 1, 21, 361);
INSERT INTO 'albumsrecordingsmap' VALUES (208, 2, 22, 32);
INSERT INTO 'albumsrecordingsmap' VALUES (209, 3, 22, 38);
INSERT INTO 'albumsrecordingsmap' VALUES (210, 5, 22, 49);
INSERT INTO 'albumsrecordingsmap' VALUES (211, 11, 22, 140);
INSERT INTO 'albumsrecordingsmap' VALUES (212, 6, 22, 206);
INSERT INTO 'albumsrecordingsmap' VALUES (213, 8, 22, 217);
INSERT INTO 'albumsrecordingsmap' VALUES (214, 4, 22, 289);
INSERT INTO 'albumsrecordingsmap' VALUES (215, 10, 22, 312);
INSERT INTO 'albumsrecordingsmap' VALUES (216, 7, 22, 315);
INSERT INTO 'albumsrecordingsmap' VALUES (217, 12, 22, 323);
INSERT INTO 'albumsrecordingsmap' VALUES (218, 9, 22, 326);
INSERT INTO 'albumsrecordingsmap' VALUES (219, 1, 22, 336);
INSERT INTO 'albumsrecordingsmap' VALUES (220, 20, 23, 27);
INSERT INTO 'albumsrecordingsmap' VALUES (221, 21, 23, 47);
INSERT INTO 'albumsrecordingsmap' VALUES (222, 22, 23, 51);
INSERT INTO 'albumsrecordingsmap' VALUES (223, 15, 23, 65);
INSERT INTO 'albumsrecordingsmap' VALUES (224, 23, 23, 75);
INSERT INTO 'albumsrecordingsmap' VALUES (225, 2, 23, 145);
INSERT INTO 'albumsrecordingsmap' VALUES (226, 4, 23, 173);
INSERT INTO 'albumsrecordingsmap' VALUES (227, 3, 23, 190);
INSERT INTO 'albumsrecordingsmap' VALUES (228, 11, 23, 191);
INSERT INTO 'albumsrecordingsmap' VALUES (229, 9, 23, 201);
INSERT INTO 'albumsrecordingsmap' VALUES (230, 18, 23, 204);
INSERT INTO 'albumsrecordingsmap' VALUES (231, 13, 23, 239);
INSERT INTO 'albumsrecordingsmap' VALUES (232, 14, 23, 246);
INSERT INTO 'albumsrecordingsmap' VALUES (233, 8, 23, 291);
INSERT INTO 'albumsrecordingsmap' VALUES (234, 7, 23, 301);
INSERT INTO 'albumsrecordingsmap' VALUES (235, 6, 23, 357);
INSERT INTO 'albumsrecordingsmap' VALUES (236, 19, 24, 2);
INSERT INTO 'albumsrecordingsmap' VALUES (237, 11, 24, 19);
INSERT INTO 'albumsrecordingsmap' VALUES (238, 5, 24, 23);
INSERT INTO 'albumsrecordingsmap' VALUES (239, 3, 24, 92);
INSERT INTO 'albumsrecordingsmap' VALUES (240, 20, 24, 93);
INSERT INTO 'albumsrecordingsmap' VALUES (241, 4, 24, 98);
INSERT INTO 'albumsrecordingsmap' VALUES (242, 8, 24, 121);
INSERT INTO 'albumsrecordingsmap' VALUES (243, 16, 24, 126);
INSERT INTO 'albumsrecordingsmap' VALUES (244, 6, 24, 131);
INSERT INTO 'albumsrecordingsmap' VALUES (245, 18, 24, 159);
INSERT INTO 'albumsrecordingsmap' VALUES (246, 1, 24, 168);
INSERT INTO 'albumsrecordingsmap' VALUES (247, 2, 24, 192);
INSERT INTO 'albumsrecordingsmap' VALUES (248, 14, 24, 225);
INSERT INTO 'albumsrecordingsmap' VALUES (249, 17, 24, 231);
INSERT INTO 'albumsrecordingsmap' VALUES (250, 7, 24, 280);
INSERT INTO 'albumsrecordingsmap' VALUES (251, 9, 24, 334);
INSERT INTO 'albumsrecordingsmap' VALUES (252, 13, 24, 340);
INSERT INTO 'albumsrecordingsmap' VALUES (253, 15, 24, 349);
INSERT INTO 'albumsrecordingsmap' VALUES (254, 8, 25, 41);
INSERT INTO 'albumsrecordingsmap' VALUES (255, 1, 25, 81);
INSERT INTO 'albumsrecordingsmap' VALUES (256, 4, 25, 103);
INSERT INTO 'albumsrecordingsmap' VALUES (257, 2, 25, 113);
INSERT INTO 'albumsrecordingsmap' VALUES (258, 3, 25, 186);
INSERT INTO 'albumsrecordingsmap' VALUES (259, 7, 25, 215);
INSERT INTO 'albumsrecordingsmap' VALUES (260, 6, 25, 250);
INSERT INTO 'albumsrecordingsmap' VALUES (261, 5, 25, 266);
INSERT INTO 'albumsrecordingsmap' VALUES (262, 9, 25, 339);
INSERT INTO 'albumsrecordingsmap' VALUES (263, 12, 26, 10);
INSERT INTO 'albumsrecordingsmap' VALUES (264, 5, 26, 70);
INSERT INTO 'albumsrecordingsmap' VALUES (265, 11, 26, 213);
INSERT INTO 'albumsrecordingsmap' VALUES (266, 6, 26, 216);
INSERT INTO 'albumsrecordingsmap' VALUES (267, 4, 26, 218);
INSERT INTO 'albumsrecordingsmap' VALUES (268, 7, 26, 227);
INSERT INTO 'albumsrecordingsmap' VALUES (269, 9, 26, 233);
INSERT INTO 'albumsrecordingsmap' VALUES (270, 10, 26, 236);
INSERT INTO 'albumsrecordingsmap' VALUES (271, 8, 26, 328);
INSERT INTO 'albumsrecordingsmap' VALUES (272, 3, 26, 331);
INSERT INTO 'albumsrecordingsmap' VALUES (273, 14, 26, 346);
INSERT INTO 'albumsrecordingsmap' VALUES (274, 2, 26, 347);
INSERT INTO 'albumsrecordingsmap' VALUES (275, 13, 26, 358);
INSERT INTO 'albumsrecordingsmap' VALUES (276, 7, 19, 369);
INSERT INTO 'albumsrecordingsmap' VALUES (277, 13, 19, 370);
INSERT INTO 'albumsrecordingsmap' VALUES (9330, 7, 1018, 4157);
INSERT INTO 'albumsrecordingsmap' VALUES (9331, 8, 1018, 1739);
INSERT INTO 'albumsrecordingsmap' VALUES (9332, 9, 1018, 4147);
INSERT INTO 'albumsrecordingsmap' VALUES (9357, 19, 1019, 8870);
INSERT INTO 'albumsrecordingsmap' VALUES (9364, 7, 1020, 8877);
INSERT INTO 'albumsrecordingsmap' VALUES (9365, 8, 1020, 8878);
INSERT INTO 'albumsrecordingsmap' VALUES (9366, 9, 1020, 8879);
INSERT INTO 'albumsrecordingsmap' VALUES (9377, 7, 1021, 8890);
INSERT INTO 'albumsrecordingsmap' VALUES (9378, 8, 1021, 8891);
INSERT INTO 'albumsrecordingsmap' VALUES (9379, 9, 1021, 8892);
INSERT INTO 'albumsrecordingsmap' VALUES (9392, 6, 1022, 8905);
INSERT INTO 'albumsrecordingsmap' VALUES (9406, 3, 1023, 8920);
INSERT INTO 'albumsrecordingsmap' VALUES (9430, 7, 1025, 6781);
INSERT INTO 'albumsrecordingsmap' VALUES (9431, 8, 1025, 6782);
INSERT INTO 'albumsrecordingsmap' VALUES (9432, 9, 1025, 6865);
INSERT INTO 'albumsrecordingsmap' VALUES (9477, 12, 1027, 8960);
INSERT INTO 'albumsrecordingsmap' VALUES (9483, 7, 1028, 8966);
INSERT INTO 'albumsrecordingsmap' VALUES (9485, 9, 1028, 8968);
INSERT INTO 'albumsrecordingsmap' VALUES (9486, 10, 1028, 8969);
INSERT INTO 'albumsrecordingsmap' VALUES (9487, 6, 1028, 8970);
INSERT INTO 'albumsrecordingsmap' VALUES (9488, 11, 1028, 8971);
INSERT INTO 'albumsrecordingsmap' VALUES (9489, 12, 1028, 8972);
INSERT INTO 'albumsrecordingsmap' VALUES (9490, 13, 1028, 8973);
INSERT INTO 'albumsrecordingsmap' VALUES (9491, 1, 1029, 8974);
INSERT INTO 'albumsrecordingsmap' VALUES (9492, 2, 1029, 8975);
INSERT INTO 'albumsrecordingsmap' VALUES (9493, 3, 1029, 8976);
INSERT INTO 'albumsrecordingsmap' VALUES (9494, 4, 1029, 8977);
INSERT INTO 'albumsrecordingsmap' VALUES (9495, 5, 1029, 8978);
INSERT INTO 'albumsrecordingsmap' VALUES (9496, 6, 1029, 8979);
INSERT INTO 'albumsrecordingsmap' VALUES (9497, 7, 1029, 8980);
INSERT INTO 'albumsrecordingsmap' VALUES (9498, 8, 1029, 8981);
INSERT INTO 'albumsrecordingsmap' VALUES (9499, 9, 1029, 8982);
INSERT INTO 'albumsrecordingsmap' VALUES (9500, 10, 1029, 8983);
INSERT INTO 'albumsrecordingsmap' VALUES (9501, 11, 1029, 8984);
INSERT INTO 'albumsrecordingsmap' VALUES (9502, 12, 1029, 8985);
INSERT INTO 'albumsrecordingsmap' VALUES (9508, 1, 1030, 8991);
INSERT INTO 'albumsrecordingsmap' VALUES (9509, 2, 1030, 8992);
INSERT INTO 'albumsrecordingsmap' VALUES (9510, 3, 1030, 8993);
INSERT INTO 'albumsrecordingsmap' VALUES (9511, 4, 1030, 8994);
INSERT INTO 'albumsrecordingsmap' VALUES (9512, 5, 1030, 8995);
INSERT INTO 'albumsrecordingsmap' VALUES (9513, 6, 1030, 8996);
INSERT INTO 'albumsrecordingsmap' VALUES (9514, 7, 1030, 8997);
INSERT INTO 'albumsrecordingsmap' VALUES (9515, 8, 1030, 8998);
INSERT INTO 'albumsrecordingsmap' VALUES (9516, 9, 1030, 8999);
INSERT INTO 'albumsrecordingsmap' VALUES (9517, 10, 1030, 9000);
INSERT INTO 'albumsrecordingsmap' VALUES (9518, 11, 1030, 9001);
INSERT INTO 'albumsrecordingsmap' VALUES (9519, 12, 1030, 9002);
INSERT INTO 'albumsrecordingsmap' VALUES (9523, 16, 1030, 9006);
INSERT INTO 'albumsrecordingsmap' VALUES (9524, 17, 1030, 9007);
INSERT INTO 'albumsrecordingsmap' VALUES (9525, 1, 1031, 9008);
INSERT INTO 'albumsrecordingsmap' VALUES (9526, 2, 1031, 9009);
INSERT INTO 'albumsrecordingsmap' VALUES (9527, 3, 1031, 9010);
INSERT INTO 'albumsrecordingsmap' VALUES (9528, 4, 1031, 9011);
INSERT INTO 'albumsrecordingsmap' VALUES (9529, 5, 1031, 9012);
INSERT INTO 'albumsrecordingsmap' VALUES (9530, 6, 1031, 9013);
INSERT INTO 'albumsrecordingsmap' VALUES (9531, 7, 1031, 9014);
INSERT INTO 'albumsrecordingsmap' VALUES (9532, 8, 1031, 9015);
INSERT INTO 'albumsrecordingsmap' VALUES (9533, 9, 1031, 9016);
INSERT INTO 'albumsrecordingsmap' VALUES (9534, 1, 1032, 9020);
INSERT INTO 'albumsrecordingsmap' VALUES (9535, 2, 1032, 9021);
INSERT INTO 'albumsrecordingsmap' VALUES (9536, 3, 1032, 9022);
INSERT INTO 'albumsrecordingsmap' VALUES (9537, 4, 1032, 9023);
INSERT INTO 'albumsrecordingsmap' VALUES (9538, 5, 1032, 9024);
INSERT INTO 'albumsrecordingsmap' VALUES (9539, 6, 1032, 9025);
INSERT INTO 'albumsrecordingsmap' VALUES (9540, 7, 1032, 9026);
INSERT INTO 'albumsrecordingsmap' VALUES (9541, 8, 1032, 9027);
INSERT INTO 'albumsrecordingsmap' VALUES (9542, 9, 1032, 9028);
INSERT INTO 'albumsrecordingsmap' VALUES (9543, 10, 1032, 9029);
INSERT INTO 'albumsrecordingsmap' VALUES (9544, 11, 1032, 9030);
INSERT INTO 'albumsrecordingsmap' VALUES (9545, 10, 1031, 9031);
INSERT INTO 'albumsrecordingsmap' VALUES (9546, 11, 1031, 9032);
INSERT INTO 'albumsrecordingsmap' VALUES (9547, 12, 1031, 9033);
INSERT INTO 'albumsrecordingsmap' VALUES (9548, 13, 1031, 9034);
INSERT INTO 'albumsrecordingsmap' VALUES (9549, 14, 1031, 9035);
INSERT INTO 'albumsrecordingsmap' VALUES (9550, 15, 1031, 9036);
INSERT INTO 'albumsrecordingsmap' VALUES (9560, 25, 1031, 9046);
INSERT INTO 'albumsrecordingsmap' VALUES (9561, 26, 1031, 9047);
INSERT INTO 'albumsrecordingsmap' VALUES (9562, 27, 1031, 9048);
INSERT INTO 'albumsrecordingsmap' VALUES (9569, 1, 1033, 9055);
INSERT INTO 'albumsrecordingsmap' VALUES (9570, 2, 1033, 9056);
INSERT INTO 'albumsrecordingsmap' VALUES (9571, 3, 1033, 9057);
INSERT INTO 'albumsrecordingsmap' VALUES (9572, 4, 1033, 9058);
INSERT INTO 'albumsrecordingsmap' VALUES (278, 9, 7, 371);
INSERT INTO 'albumsrecordingsmap' VALUES (279, 2, 5, 30);
INSERT INTO 'albumsrecordingsmap' VALUES (280, 2, 6, 35);
INSERT INTO 'albumsrecordingsmap' VALUES (281, 3, 6, 133);
INSERT INTO 'albumsrecordingsmap' VALUES (282, 4, 6, 158);
INSERT INTO 'albumsrecordingsmap' VALUES (283, 6, 6, 165);
INSERT INTO 'albumsrecordingsmap' VALUES (284, 7, 6, 171);
INSERT INTO 'albumsrecordingsmap' VALUES (285, 8, 6, 182);
INSERT INTO 'albumsrecordingsmap' VALUES (286, 9, 6, 196);
INSERT INTO 'albumsrecordingsmap' VALUES (287, 10, 6, 223);
INSERT INTO 'albumsrecordingsmap' VALUES (288, 1, 6, 26);
INSERT INTO 'albumsrecordingsmap' VALUES (289, 11, 6, 244);
INSERT INTO 'albumsrecordingsmap' VALUES (290, 12, 6, 275);
INSERT INTO 'albumsrecordingsmap' VALUES (291, 13, 6, 279);
INSERT INTO 'albumsrecordingsmap' VALUES (292, 14, 6, 277);
INSERT INTO 'albumsrecordingsmap' VALUES (293, 15, 6, 282);
INSERT INTO 'albumsrecordingsmap' VALUES (294, 1, 26, 194);
INSERT INTO 'albumsrecordingsmap' VALUES (295, 19, 23, 373);
INSERT INTO 'albumsrecordingsmap' VALUES (296, 20, 15, 374);
INSERT INTO 'albumsrecordingsmap' VALUES (297, 2, 1, 169);
INSERT INTO 'albumsrecordingsmap' VALUES (298, 10, 1, 167);
INSERT INTO 'albumsrecordingsmap' VALUES (299, 1, 2, 264);
INSERT INTO 'albumsrecordingsmap' VALUES (300, 5, 2, 138);
INSERT INTO 'albumsrecordingsmap' VALUES (301, 7, 2, 269);
INSERT INTO 'albumsrecordingsmap' VALUES (302, 8, 2, 176);
INSERT INTO 'albumsrecordingsmap' VALUES (303, 9, 2, 68);
INSERT INTO 'albumsrecordingsmap' VALUES (304, 11, 2, 288);
INSERT INTO 'albumsrecordingsmap' VALUES (305, 13, 2, 99);
INSERT INTO 'albumsrecordingsmap' VALUES (306, 14, 2, 185);
INSERT INTO 'albumsrecordingsmap' VALUES (307, 6, 2, 189);
INSERT INTO 'albumsrecordingsmap' VALUES (308, 4, 2, 302);
INSERT INTO 'albumsrecordingsmap' VALUES (309, 2, 2, 306);
INSERT INTO 'albumsrecordingsmap' VALUES (310, 7, 3, 84);
INSERT INTO 'albumsrecordingsmap' VALUES (311, 3, 5, 76);
INSERT INTO 'albumsrecordingsmap' VALUES (312, 7, 5, 179);
INSERT INTO 'albumsrecordingsmap' VALUES (313, 4, 8, 66);
INSERT INTO 'albumsrecordingsmap' VALUES (314, 5, 8, 100);
INSERT INTO 'albumsrecordingsmap' VALUES (315, 7, 8, 94);
INSERT INTO 'albumsrecordingsmap' VALUES (316, 10, 8, 153);
INSERT INTO 'albumsrecordingsmap' VALUES (317, 12, 8, 122);
INSERT INTO 'albumsrecordingsmap' VALUES (318, 4, 9, 219);
INSERT INTO 'albumsrecordingsmap' VALUES (319, 7, 9, 292);
INSERT INTO 'albumsrecordingsmap' VALUES (320, 8, 9, 365);
INSERT INTO 'albumsrecordingsmap' VALUES (321, 10, 9, 313);
INSERT INTO 'albumsrecordingsmap' VALUES (322, 12, 9, 115);
INSERT INTO 'albumsrecordingsmap' VALUES (323, 3, 10, 332);
INSERT INTO 'albumsrecordingsmap' VALUES (324, 6, 10, 232);
INSERT INTO 'albumsrecordingsmap' VALUES (325, 8, 10, 63);
INSERT INTO 'albumsrecordingsmap' VALUES (326, 10, 10, 270);
INSERT INTO 'albumsrecordingsmap' VALUES (327, 10, 11, 237);
INSERT INTO 'albumsrecordingsmap' VALUES (328, 13, 11, 359);
INSERT INTO 'albumsrecordingsmap' VALUES (329, 2, 12, 316);
INSERT INTO 'albumsrecordingsmap' VALUES (330, 5, 12, 253);
INSERT INTO 'albumsrecordingsmap' VALUES (331, 6, 12, 212);
INSERT INTO 'albumsrecordingsmap' VALUES (332, 11, 12, 78);
INSERT INTO 'albumsrecordingsmap' VALUES (333, 5, 14, 33);
INSERT INTO 'albumsrecordingsmap' VALUES (334, 6, 14, 320);
INSERT INTO 'albumsrecordingsmap' VALUES (335, 8, 14, 141);
INSERT INTO 'albumsrecordingsmap' VALUES (336, 11, 14, 327);
INSERT INTO 'albumsrecordingsmap' VALUES (337, 18, 15, 101);
INSERT INTO 'albumsrecordingsmap' VALUES (338, 9, 16, 18);
INSERT INTO 'albumsrecordingsmap' VALUES (339, 3, 17, 294);
INSERT INTO 'albumsrecordingsmap' VALUES (340, 6, 19, 360);
INSERT INTO 'albumsrecordingsmap' VALUES (341, 2, 21, 335);
INSERT INTO 'albumsrecordingsmap' VALUES (342, 17, 23, 102);
INSERT INTO 'albumsrecordingsmap' VALUES (343, 5, 6, 378);
INSERT INTO 'albumsrecordingsmap' VALUES (344, 5, 23, 338);
INSERT INTO 'albumsrecordingsmap' VALUES (345, 22, 23, 329);
INSERT INTO 'albumsrecordingsmap' VALUES (346, 2, 15, 330);
INSERT INTO 'albumsrecordingsmap' VALUES (347, 4, 15, 60);
INSERT INTO 'albumsrecordingsmap' VALUES (348, 6, 15, 351);
INSERT INTO 'albumsrecordingsmap' VALUES (349, 19, 15, 379);
INSERT INTO 'albumsrecordingsmap' VALUES (350, 1, 28, 381);
INSERT INTO 'albumsrecordingsmap' VALUES (351, 2, 28, 382);
INSERT INTO 'albumsrecordingsmap' VALUES (352, 3, 28, 383);
INSERT INTO 'albumsrecordingsmap' VALUES (353, 4, 28, 384);
INSERT INTO 'albumsrecordingsmap' VALUES (354, 5, 28, 385);
INSERT INTO 'albumsrecordingsmap' VALUES (355, 6, 28, 386);
INSERT INTO 'albumsrecordingsmap' VALUES (356, 7, 28, 387);
INSERT INTO 'albumsrecordingsmap' VALUES (357, 8, 28, 388);
INSERT INTO 'albumsrecordingsmap' VALUES (358, 9, 28, 389);
INSERT INTO 'albumsrecordingsmap' VALUES (359, 10, 28, 390);
INSERT INTO 'albumsrecordingsmap' VALUES (360, 11, 28, 391);
INSERT INTO 'albumsrecordingsmap' VALUES (361, 1, 30, 392);
INSERT INTO 'albumsrecordingsmap' VALUES (362, 2, 30, 393);
INSERT INTO 'albumsrecordingsmap' VALUES (363, 3, 30, 394);
INSERT INTO 'albumsrecordingsmap' VALUES (364, 4, 30, 395);
INSERT INTO 'albumsrecordingsmap' VALUES (365, 5, 30, 396);
INSERT INTO 'albumsrecordingsmap' VALUES (366, 6, 30, 397);
INSERT INTO 'albumsrecordingsmap' VALUES (367, 7, 30, 398);
INSERT INTO 'albumsrecordingsmap' VALUES (368, 8, 30, 399);
INSERT INTO 'albumsrecordingsmap' VALUES (369, 9, 30, 400);
INSERT INTO 'albumsrecordingsmap' VALUES (370, 10, 30, 401);
INSERT INTO 'albumsrecordingsmap' VALUES (9333, 10, 1018, 1738);
INSERT INTO 'albumsrecordingsmap' VALUES (9334, 11, 1018, 4152);
INSERT INTO 'albumsrecordingsmap' VALUES (9335, 12, 1018, 1731);
INSERT INTO 'albumsrecordingsmap' VALUES (9367, 10, 1020, 8880);
INSERT INTO 'albumsrecordingsmap' VALUES (9368, 11, 1020, 8881);
INSERT INTO 'albumsrecordingsmap' VALUES (9369, 12, 1020, 8882);
INSERT INTO 'albumsrecordingsmap' VALUES (9407, 4, 1023, 8921);
INSERT INTO 'albumsrecordingsmap' VALUES (9408, 5, 1023, 8922);
INSERT INTO 'albumsrecordingsmap' VALUES (9409, 6, 1023, 8923);
INSERT INTO 'albumsrecordingsmap' VALUES (9433, 10, 1025, 6866);
INSERT INTO 'albumsrecordingsmap' VALUES (9434, 11, 1025, 6867);
INSERT INTO 'albumsrecordingsmap' VALUES (9435, 12, 1025, 6876);
INSERT INTO 'albumsrecordingsmap' VALUES (9503, 13, 1029, 8986);
INSERT INTO 'albumsrecordingsmap' VALUES (9504, 14, 1029, 8987);
INSERT INTO 'albumsrecordingsmap' VALUES (9505, 15, 1029, 8988);
INSERT INTO 'albumsrecordingsmap' VALUES (9520, 13, 1030, 9003);
INSERT INTO 'albumsrecordingsmap' VALUES (9521, 14, 1030, 9004);
INSERT INTO 'albumsrecordingsmap' VALUES (9522, 15, 1030, 9005);
INSERT INTO 'albumsrecordingsmap' VALUES (9551, 16, 1031, 9037);
INSERT INTO 'albumsrecordingsmap' VALUES (9552, 17, 1031, 9038);
INSERT INTO 'albumsrecordingsmap' VALUES (9553, 18, 1031, 9039);
INSERT INTO 'albumsrecordingsmap' VALUES (9563, 28, 1031, 9049);
INSERT INTO 'albumsrecordingsmap' VALUES (9564, 29, 1031, 9050);
INSERT INTO 'albumsrecordingsmap' VALUES (9565, 30, 1031, 9051);
INSERT INTO 'albumsrecordingsmap' VALUES (9573, 5, 1033, 9059);
INSERT INTO 'albumsrecordingsmap' VALUES (9574, 6, 1033, 9060);
INSERT INTO 'albumsrecordingsmap' VALUES (371, 11, 30, 402);
INSERT INTO 'albumsrecordingsmap' VALUES (372, 12, 30, 403);
INSERT INTO 'albumsrecordingsmap' VALUES (373, 13, 30, 404);
INSERT INTO 'albumsrecordingsmap' VALUES (374, 14, 30, 405);
INSERT INTO 'albumsrecordingsmap' VALUES (375, 15, 30, 406);
INSERT INTO 'albumsrecordingsmap' VALUES (376, 16, 30, 407);
INSERT INTO 'albumsrecordingsmap' VALUES (377, 17, 30, 408);
INSERT INTO 'albumsrecordingsmap' VALUES (378, 1, 27, 220);
INSERT INTO 'albumsrecordingsmap' VALUES (379, 2, 27, 321);
INSERT INTO 'albumsrecordingsmap' VALUES (380, 3, 27, 375);
INSERT INTO 'albumsrecordingsmap' VALUES (381, 4, 27, 376);
INSERT INTO 'albumsrecordingsmap' VALUES (382, 5, 27, 377);
INSERT INTO 'albumsrecordingsmap' VALUES (383, 6, 27, 409);
INSERT INTO 'albumsrecordingsmap' VALUES (384, 7, 27, 410);
INSERT INTO 'albumsrecordingsmap' VALUES (385, 8, 27, 411);
INSERT INTO 'albumsrecordingsmap' VALUES (386, 9, 27, 412);
INSERT INTO 'albumsrecordingsmap' VALUES (387, 10, 27, 413);
INSERT INTO 'albumsrecordingsmap' VALUES (388, 11, 27, 414);
INSERT INTO 'albumsrecordingsmap' VALUES (389, 12, 27, 415);
INSERT INTO 'albumsrecordingsmap' VALUES (390, 13, 27, 416);
INSERT INTO 'albumsrecordingsmap' VALUES (391, 14, 27, 417);
INSERT INTO 'albumsrecordingsmap' VALUES (392, 15, 27, 419);
INSERT INTO 'albumsrecordingsmap' VALUES (393, 16, 27, 420);
INSERT INTO 'albumsrecordingsmap' VALUES (394, 17, 27, 421);
INSERT INTO 'albumsrecordingsmap' VALUES (395, 18, 27, 422);
INSERT INTO 'albumsrecordingsmap' VALUES (396, 19, 27, 423);
INSERT INTO 'albumsrecordingsmap' VALUES (397, 20, 27, 424);
INSERT INTO 'albumsrecordingsmap' VALUES (398, 21, 27, 425);
INSERT INTO 'albumsrecordingsmap' VALUES (399, 22, 27, 426);
INSERT INTO 'albumsrecordingsmap' VALUES (400, 23, 27, 427);
INSERT INTO 'albumsrecordingsmap' VALUES (401, 24, 27, 428);
INSERT INTO 'albumsrecordingsmap' VALUES (402, 25, 27, 429);
INSERT INTO 'albumsrecordingsmap' VALUES (403, 1, 29, 430);
INSERT INTO 'albumsrecordingsmap' VALUES (404, 2, 29, 431);
INSERT INTO 'albumsrecordingsmap' VALUES (405, 3, 29, 432);
INSERT INTO 'albumsrecordingsmap' VALUES (406, 4, 29, 433);
INSERT INTO 'albumsrecordingsmap' VALUES (407, 5, 29, 434);
INSERT INTO 'albumsrecordingsmap' VALUES (408, 6, 29, 435);
INSERT INTO 'albumsrecordingsmap' VALUES (409, 7, 29, 436);
INSERT INTO 'albumsrecordingsmap' VALUES (410, 8, 29, 437);
INSERT INTO 'albumsrecordingsmap' VALUES (411, 9, 29, 438);
INSERT INTO 'albumsrecordingsmap' VALUES (412, 10, 29, 439);
INSERT INTO 'albumsrecordingsmap' VALUES (413, 11, 29, 440);
INSERT INTO 'albumsrecordingsmap' VALUES (414, 12, 29, 441);
INSERT INTO 'albumsrecordingsmap' VALUES (415, 13, 29, 442);
INSERT INTO 'albumsrecordingsmap' VALUES (416, 14, 29, 443);
INSERT INTO 'albumsrecordingsmap' VALUES (417, 15, 29, 444);
INSERT INTO 'albumsrecordingsmap' VALUES (418, 1, 34, 455);
INSERT INTO 'albumsrecordingsmap' VALUES (426, 1, 35, 467);
INSERT INTO 'albumsrecordingsmap' VALUES (427, 2, 35, 468);
INSERT INTO 'albumsrecordingsmap' VALUES (428, 3, 35, 469);
INSERT INTO 'albumsrecordingsmap' VALUES (429, 4, 35, 470);
INSERT INTO 'albumsrecordingsmap' VALUES (430, 5, 35, 471);
INSERT INTO 'albumsrecordingsmap' VALUES (431, 6, 35, 472);
INSERT INTO 'albumsrecordingsmap' VALUES (432, 7, 35, 473);
INSERT INTO 'albumsrecordingsmap' VALUES (433, 8, 35, 474);
INSERT INTO 'albumsrecordingsmap' VALUES (434, 9, 35, 475);
INSERT INTO 'albumsrecordingsmap' VALUES (435, 10, 35, 476);
INSERT INTO 'albumsrecordingsmap' VALUES (436, 11, 35, 477);
INSERT INTO 'albumsrecordingsmap' VALUES (437, 12, 35, 478);
INSERT INTO 'albumsrecordingsmap' VALUES (438, 1, 37, 496);
INSERT INTO 'albumsrecordingsmap' VALUES (439, 2, 37, 497);
INSERT INTO 'albumsrecordingsmap' VALUES (440, 3, 37, 498);
INSERT INTO 'albumsrecordingsmap' VALUES (441, 4, 37, 499);
INSERT INTO 'albumsrecordingsmap' VALUES (442, 5, 37, 500);
INSERT INTO 'albumsrecordingsmap' VALUES (443, 6, 37, 501);
INSERT INTO 'albumsrecordingsmap' VALUES (444, 7, 37, 502);
INSERT INTO 'albumsrecordingsmap' VALUES (445, 8, 37, 503);
INSERT INTO 'albumsrecordingsmap' VALUES (446, 9, 37, 504);
INSERT INTO 'albumsrecordingsmap' VALUES (447, 10, 37, 505);
INSERT INTO 'albumsrecordingsmap' VALUES (448, 11, 37, 506);
INSERT INTO 'albumsrecordingsmap' VALUES (449, 12, 37, 507);
INSERT INTO 'albumsrecordingsmap' VALUES (450, 13, 37, 508);
INSERT INTO 'albumsrecordingsmap' VALUES (451, 14, 37, 509);
INSERT INTO 'albumsrecordingsmap' VALUES (452, 3, 13, 510);
INSERT INTO 'albumsrecordingsmap' VALUES (453, 1, 31, 418);
INSERT INTO 'albumsrecordingsmap' VALUES (454, 2, 31, 511);
INSERT INTO 'albumsrecordingsmap' VALUES (455, 3, 31, 512);
INSERT INTO 'albumsrecordingsmap' VALUES (456, 4, 31, 513);
INSERT INTO 'albumsrecordingsmap' VALUES (457, 5, 31, 514);
INSERT INTO 'albumsrecordingsmap' VALUES (458, 6, 31, 515);
INSERT INTO 'albumsrecordingsmap' VALUES (459, 7, 31, 516);
INSERT INTO 'albumsrecordingsmap' VALUES (460, 8, 31, 517);
INSERT INTO 'albumsrecordingsmap' VALUES (461, 9, 31, 518);
INSERT INTO 'albumsrecordingsmap' VALUES (462, 10, 31, 519);
INSERT INTO 'albumsrecordingsmap' VALUES (9336, 13, 1018, 4150);
INSERT INTO 'albumsrecordingsmap' VALUES (9337, 14, 1018, 4149);
INSERT INTO 'albumsrecordingsmap' VALUES (9338, 15, 1018, 1736);
INSERT INTO 'albumsrecordingsmap' VALUES (9370, 13, 1020, 8883);
INSERT INTO 'albumsrecordingsmap' VALUES (9410, 7, 1023, 8924);
INSERT INTO 'albumsrecordingsmap' VALUES (9411, 8, 1023, 8925);
INSERT INTO 'albumsrecordingsmap' VALUES (9412, 9, 1023, 8926);
INSERT INTO 'albumsrecordingsmap' VALUES (9506, 16, 1029, 8989);
INSERT INTO 'albumsrecordingsmap' VALUES (9507, 17, 1029, 8990);
INSERT INTO 'albumsrecordingsmap' VALUES (9554, 19, 1031, 9040);
INSERT INTO 'albumsrecordingsmap' VALUES (9555, 20, 1031, 9041);
INSERT INTO 'albumsrecordingsmap' VALUES (9556, 21, 1031, 9042);
INSERT INTO 'albumsrecordingsmap' VALUES (9566, 31, 1031, 9052);
INSERT INTO 'albumsrecordingsmap' VALUES (9567, 32, 1031, 9053);
INSERT INTO 'albumsrecordingsmap' VALUES (9568, 33, 1031, 9054);
INSERT INTO 'albumsrecordingsmap' VALUES (9575, 7, 1033, 9061);
INSERT INTO 'albumsrecordingsmap' VALUES (9576, 8, 1033, 9062);
INSERT INTO 'albumsrecordingsmap' VALUES (9577, 9, 1033, 9063);
INSERT INTO 'albumsrecordingsmap' VALUES (9578, 10, 1033, 9064);
INSERT INTO 'albumsrecordingsmap' VALUES (9579, 11, 1033, 9065);
INSERT INTO 'albumsrecordingsmap' VALUES (9580, 12, 1033, 9066);
INSERT INTO 'albumsrecordingsmap' VALUES (9581, 13, 1033, 9067);
INSERT INTO 'albumsrecordingsmap' VALUES (9582, 14, 1033, 9068);
INSERT INTO 'albumsrecordingsmap' VALUES (9583, 15, 1033, 9069);
INSERT INTO 'albumsrecordingsmap' VALUES (9585, 1, 1034, 9071);
INSERT INTO 'albumsrecordingsmap' VALUES (9586, 2, 1034, 9072);
INSERT INTO 'albumsrecordingsmap' VALUES (9587, 3, 1034, 9073);
INSERT INTO 'albumsrecordingsmap' VALUES (9588, 4, 1034, 9074);
INSERT INTO 'albumsrecordingsmap' VALUES (9589, 5, 1034, 9075);
INSERT INTO 'albumsrecordingsmap' VALUES (9590, 6, 1034, 9076);
INSERT INTO 'albumsrecordingsmap' VALUES (9591, 7, 1034, 9077);
INSERT INTO 'albumsrecordingsmap' VALUES (9592, 8, 1034, 9078);
INSERT INTO 'albumsrecordingsmap' VALUES (9593, 9, 1034, 9079);
INSERT INTO 'albumsrecordingsmap' VALUES (9594, 10, 1034, 9080);
INSERT INTO 'albumsrecordingsmap' VALUES (9595, 11, 1034, 9081);
INSERT INTO 'albumsrecordingsmap' VALUES (9596, 12, 1034, 9082);
INSERT INTO 'albumsrecordingsmap' VALUES (9597, 13, 1034, 9083);
INSERT INTO 'albumsrecordingsmap' VALUES (9598, 14, 1034, 9084);
INSERT INTO 'albumsrecordingsmap' VALUES (9599, 15, 1034, 9085);
INSERT INTO 'albumsrecordingsmap' VALUES (9600, 16, 1034, 9086);
INSERT INTO 'albumsrecordingsmap' VALUES (9601, 17, 1034, 9087);
INSERT INTO 'albumsrecordingsmap' VALUES (9602, 18, 1034, 9088);
INSERT INTO 'albumsrecordingsmap' VALUES (9616, 1, 1036, 9102);
INSERT INTO 'albumsrecordingsmap' VALUES (9617, 2, 1036, 9103);
INSERT INTO 'albumsrecordingsmap' VALUES (9618, 3, 1036, 9104);
INSERT INTO 'albumsrecordingsmap' VALUES (9619, 4, 1036, 9105);
INSERT INTO 'albumsrecordingsmap' VALUES (9620, 5, 1036, 9106);
INSERT INTO 'albumsrecordingsmap' VALUES (9621, 6, 1036, 9107);
INSERT INTO 'albumsrecordingsmap' VALUES (9622, 7, 1036, 9108);
INSERT INTO 'albumsrecordingsmap' VALUES (9623, 8, 1036, 9109);
INSERT INTO 'albumsrecordingsmap' VALUES (9624, 9, 1036, 9110);
INSERT INTO 'albumsrecordingsmap' VALUES (10753, 2, 1110, 10159);
INSERT INTO 'albumsrecordingsmap' VALUES (9625, 10, 1036, 9111);
INSERT INTO 'albumsrecordingsmap' VALUES (9626, 11, 1036, 9112);
INSERT INTO 'albumsrecordingsmap' VALUES (9627, 12, 1036, 9113);
INSERT INTO 'albumsrecordingsmap' VALUES (9629, 1, 1037, 9115);
INSERT INTO 'albumsrecordingsmap' VALUES (9630, 2, 1037, 9116);
INSERT INTO 'albumsrecordingsmap' VALUES (9631, 3, 1037, 9117);
INSERT INTO 'albumsrecordingsmap' VALUES (9632, 4, 1037, 9118);
INSERT INTO 'albumsrecordingsmap' VALUES (9633, 5, 1037, 9119);
INSERT INTO 'albumsrecordingsmap' VALUES (9634, 6, 1037, 9120);
INSERT INTO 'albumsrecordingsmap' VALUES (9635, 7, 1037, 9121);
INSERT INTO 'albumsrecordingsmap' VALUES (9636, 8, 1037, 9122);
INSERT INTO 'albumsrecordingsmap' VALUES (9637, 9, 1037, 9123);
INSERT INTO 'albumsrecordingsmap' VALUES (9638, 10, 1037, 9124);
INSERT INTO 'albumsrecordingsmap' VALUES (9639, 11, 1037, 9125);
INSERT INTO 'albumsrecordingsmap' VALUES (9640, 12, 1037, 9126);
INSERT INTO 'albumsrecordingsmap' VALUES (9641, 13, 1037, 9127);
INSERT INTO 'albumsrecordingsmap' VALUES (9642, 14, 1037, 9128);
INSERT INTO 'albumsrecordingsmap' VALUES (9643, 15, 1037, 9129);
INSERT INTO 'albumsrecordingsmap' VALUES (9644, 16, 1037, 9130);
INSERT INTO 'albumsrecordingsmap' VALUES (9645, 17, 1037, 9131);
INSERT INTO 'albumsrecordingsmap' VALUES (9646, 18, 1037, 9132);
INSERT INTO 'albumsrecordingsmap' VALUES (9649, 1, 1038, 536);
INSERT INTO 'albumsrecordingsmap' VALUES (9650, 2, 1038, 2512);
INSERT INTO 'albumsrecordingsmap' VALUES (9651, 3, 1038, 9135);
INSERT INTO 'albumsrecordingsmap' VALUES (9652, 4, 1038, 9136);
INSERT INTO 'albumsrecordingsmap' VALUES (9653, 5, 1038, 9137);
INSERT INTO 'albumsrecordingsmap' VALUES (9654, 6, 1038, 9138);
INSERT INTO 'albumsrecordingsmap' VALUES (9658, 10, 1038, 9142);
INSERT INTO 'albumsrecordingsmap' VALUES (463, 11, 31, 520);
INSERT INTO 'albumsrecordingsmap' VALUES (464, 12, 31, 521);
INSERT INTO 'albumsrecordingsmap' VALUES (465, 13, 31, 522);
INSERT INTO 'albumsrecordingsmap' VALUES (466, 14, 31, 523);
INSERT INTO 'albumsrecordingsmap' VALUES (467, 1, 33, 524);
INSERT INTO 'albumsrecordingsmap' VALUES (468, 2, 33, 525);
INSERT INTO 'albumsrecordingsmap' VALUES (469, 3, 33, 526);
INSERT INTO 'albumsrecordingsmap' VALUES (470, 4, 33, 527);
INSERT INTO 'albumsrecordingsmap' VALUES (471, 5, 33, 528);
INSERT INTO 'albumsrecordingsmap' VALUES (472, 6, 33, 529);
INSERT INTO 'albumsrecordingsmap' VALUES (473, 8, 33, 531);
INSERT INTO 'albumsrecordingsmap' VALUES (474, 10, 33, 533);
INSERT INTO 'albumsrecordingsmap' VALUES (475, 11, 33, 534);
INSERT INTO 'albumsrecordingsmap' VALUES (476, 14, 33, 537);
INSERT INTO 'albumsrecordingsmap' VALUES (477, 1, 38, 538);
INSERT INTO 'albumsrecordingsmap' VALUES (478, 2, 38, 539);
INSERT INTO 'albumsrecordingsmap' VALUES (479, 3, 38, 540);
INSERT INTO 'albumsrecordingsmap' VALUES (480, 4, 38, 541);
INSERT INTO 'albumsrecordingsmap' VALUES (481, 5, 38, 542);
INSERT INTO 'albumsrecordingsmap' VALUES (482, 6, 38, 543);
INSERT INTO 'albumsrecordingsmap' VALUES (483, 7, 38, 544);
INSERT INTO 'albumsrecordingsmap' VALUES (484, 8, 38, 545);
INSERT INTO 'albumsrecordingsmap' VALUES (485, 9, 38, 546);
INSERT INTO 'albumsrecordingsmap' VALUES (486, 10, 38, 547);
INSERT INTO 'albumsrecordingsmap' VALUES (487, 11, 38, 548);
INSERT INTO 'albumsrecordingsmap' VALUES (488, 12, 38, 549);
INSERT INTO 'albumsrecordingsmap' VALUES (489, 13, 38, 550);
INSERT INTO 'albumsrecordingsmap' VALUES (490, 14, 38, 551);
INSERT INTO 'albumsrecordingsmap' VALUES (491, 1, 39, 552);
INSERT INTO 'albumsrecordingsmap' VALUES (492, 2, 39, 553);
INSERT INTO 'albumsrecordingsmap' VALUES (493, 3, 39, 554);
INSERT INTO 'albumsrecordingsmap' VALUES (494, 4, 39, 555);
INSERT INTO 'albumsrecordingsmap' VALUES (495, 5, 39, 556);
INSERT INTO 'albumsrecordingsmap' VALUES (496, 6, 39, 557);
INSERT INTO 'albumsrecordingsmap' VALUES (497, 7, 39, 558);
INSERT INTO 'albumsrecordingsmap' VALUES (498, 8, 39, 559);
INSERT INTO 'albumsrecordingsmap' VALUES (499, 9, 39, 560);
INSERT INTO 'albumsrecordingsmap' VALUES (500, 10, 39, 561);
INSERT INTO 'albumsrecordingsmap' VALUES (501, 11, 39, 562);
INSERT INTO 'albumsrecordingsmap' VALUES (502, 12, 39, 563);
INSERT INTO 'albumsrecordingsmap' VALUES (503, 13, 39, 564);
INSERT INTO 'albumsrecordingsmap' VALUES (504, 14, 39, 565);
INSERT INTO 'albumsrecordingsmap' VALUES (505, 15, 39, 566);
INSERT INTO 'albumsrecordingsmap' VALUES (506, 16, 39, 567);
INSERT INTO 'albumsrecordingsmap' VALUES (507, 17, 39, 568);
INSERT INTO 'albumsrecordingsmap' VALUES (508, 18, 39, 569);
INSERT INTO 'albumsrecordingsmap' VALUES (509, 19, 39, 570);
INSERT INTO 'albumsrecordingsmap' VALUES (510, 20, 39, 571);
INSERT INTO 'albumsrecordingsmap' VALUES (511, 1, 40, 572);
INSERT INTO 'albumsrecordingsmap' VALUES (512, 2, 40, 573);
INSERT INTO 'albumsrecordingsmap' VALUES (513, 3, 40, 574);
INSERT INTO 'albumsrecordingsmap' VALUES (514, 4, 40, 575);
INSERT INTO 'albumsrecordingsmap' VALUES (515, 5, 40, 576);
INSERT INTO 'albumsrecordingsmap' VALUES (516, 6, 40, 577);
INSERT INTO 'albumsrecordingsmap' VALUES (517, 7, 40, 578);
INSERT INTO 'albumsrecordingsmap' VALUES (518, 8, 40, 579);
INSERT INTO 'albumsrecordingsmap' VALUES (519, 9, 40, 580);
INSERT INTO 'albumsrecordingsmap' VALUES (520, 10, 40, 581);
INSERT INTO 'albumsrecordingsmap' VALUES (521, 11, 40, 582);
INSERT INTO 'albumsrecordingsmap' VALUES (522, 12, 40, 583);
INSERT INTO 'albumsrecordingsmap' VALUES (523, 13, 40, 584);
INSERT INTO 'albumsrecordingsmap' VALUES (524, 5, 41, 34);
INSERT INTO 'albumsrecordingsmap' VALUES (525, 7, 41, 214);
INSERT INTO 'albumsrecordingsmap' VALUES (526, 9, 41, 8);
INSERT INTO 'albumsrecordingsmap' VALUES (527, 1, 41, 585);
INSERT INTO 'albumsrecordingsmap' VALUES (528, 2, 41, 586);
INSERT INTO 'albumsrecordingsmap' VALUES (529, 3, 41, 587);
INSERT INTO 'albumsrecordingsmap' VALUES (530, 4, 41, 588);
INSERT INTO 'albumsrecordingsmap' VALUES (531, 8, 41, 589);
INSERT INTO 'albumsrecordingsmap' VALUES (532, 6, 41, 128);
INSERT INTO 'albumsrecordingsmap' VALUES (533, 1, 42, 590);
INSERT INTO 'albumsrecordingsmap' VALUES (534, 2, 42, 591);
INSERT INTO 'albumsrecordingsmap' VALUES (535, 3, 42, 592);
INSERT INTO 'albumsrecordingsmap' VALUES (536, 4, 42, 593);
INSERT INTO 'albumsrecordingsmap' VALUES (537, 5, 42, 594);
INSERT INTO 'albumsrecordingsmap' VALUES (538, 6, 42, 595);
INSERT INTO 'albumsrecordingsmap' VALUES (539, 7, 42, 596);
INSERT INTO 'albumsrecordingsmap' VALUES (540, 8, 42, 597);
INSERT INTO 'albumsrecordingsmap' VALUES (541, 9, 42, 598);
INSERT INTO 'albumsrecordingsmap' VALUES (542, 11, 42, 599);
INSERT INTO 'albumsrecordingsmap' VALUES (543, 12, 42, 600);
INSERT INTO 'albumsrecordingsmap' VALUES (544, 13, 42, 601);
INSERT INTO 'albumsrecordingsmap' VALUES (545, 10, 42, 194);
INSERT INTO 'albumsrecordingsmap' VALUES (546, 1, 43, 602);
INSERT INTO 'albumsrecordingsmap' VALUES (547, 2, 43, 603);
INSERT INTO 'albumsrecordingsmap' VALUES (548, 7, 43, 104);
INSERT INTO 'albumsrecordingsmap' VALUES (549, 3, 43, 604);
INSERT INTO 'albumsrecordingsmap' VALUES (550, 4, 43, 605);
INSERT INTO 'albumsrecordingsmap' VALUES (551, 5, 43, 177);
INSERT INTO 'albumsrecordingsmap' VALUES (552, 6, 43, 607);
INSERT INTO 'albumsrecordingsmap' VALUES (553, 8, 43, 608);
INSERT INTO 'albumsrecordingsmap' VALUES (554, 9, 43, 609);
INSERT INTO 'albumsrecordingsmap' VALUES (555, 10, 43, 610);
INSERT INTO 'albumsrecordingsmap' VALUES (556, 11, 43, 611);
INSERT INTO 'albumsrecordingsmap' VALUES (557, 12, 43, 612);
INSERT INTO 'albumsrecordingsmap' VALUES (558, 1, 44, 267);
INSERT INTO 'albumsrecordingsmap' VALUES (559, 2, 44, 614);
INSERT INTO 'albumsrecordingsmap' VALUES (560, 3, 44, 152);
INSERT INTO 'albumsrecordingsmap' VALUES (561, 4, 44, 615);
INSERT INTO 'albumsrecordingsmap' VALUES (562, 5, 44, 616);
INSERT INTO 'albumsrecordingsmap' VALUES (563, 6, 44, 617);
INSERT INTO 'albumsrecordingsmap' VALUES (564, 7, 44, 618);
INSERT INTO 'albumsrecordingsmap' VALUES (565, 8, 44, 619);
INSERT INTO 'albumsrecordingsmap' VALUES (566, 1, 45, 620);
INSERT INTO 'albumsrecordingsmap' VALUES (567, 2, 45, 621);
INSERT INTO 'albumsrecordingsmap' VALUES (568, 3, 45, 622);
INSERT INTO 'albumsrecordingsmap' VALUES (569, 4, 45, 623);
INSERT INTO 'albumsrecordingsmap' VALUES (570, 5, 45, 624);
INSERT INTO 'albumsrecordingsmap' VALUES (571, 6, 45, 625);
INSERT INTO 'albumsrecordingsmap' VALUES (572, 7, 45, 626);
INSERT INTO 'albumsrecordingsmap' VALUES (9413, 10, 1023, 8927);
INSERT INTO 'albumsrecordingsmap' VALUES (9414, 11, 1023, 8928);
INSERT INTO 'albumsrecordingsmap' VALUES (9415, 12, 1023, 8929);
INSERT INTO 'albumsrecordingsmap' VALUES (9557, 22, 1031, 9043);
INSERT INTO 'albumsrecordingsmap' VALUES (9558, 23, 1031, 9044);
INSERT INTO 'albumsrecordingsmap' VALUES (9559, 24, 1031, 9045);
INSERT INTO 'albumsrecordingsmap' VALUES (9584, 16, 1033, 9070);
INSERT INTO 'albumsrecordingsmap' VALUES (10758, 8, 1110, 10164);
INSERT INTO 'albumsrecordingsmap' VALUES (10827, 2, 1114, 10233);
INSERT INTO 'albumsrecordingsmap' VALUES (9628, 13, 1036, 9114);
INSERT INTO 'albumsrecordingsmap' VALUES (9647, 19, 1037, 9133);
INSERT INTO 'albumsrecordingsmap' VALUES (9648, 20, 1037, 9134);
INSERT INTO 'albumsrecordingsmap' VALUES (9655, 7, 1038, 9139);
INSERT INTO 'albumsrecordingsmap' VALUES (9656, 8, 1038, 9140);
INSERT INTO 'albumsrecordingsmap' VALUES (9657, 9, 1038, 9141);
INSERT INTO 'albumsrecordingsmap' VALUES (9659, 11, 1038, 9143);
INSERT INTO 'albumsrecordingsmap' VALUES (9660, 12, 1038, 9144);
INSERT INTO 'albumsrecordingsmap' VALUES (573, 8, 45, 627);
INSERT INTO 'albumsrecordingsmap' VALUES (574, 9, 45, 628);
INSERT INTO 'albumsrecordingsmap' VALUES (575, 10, 45, 629);
INSERT INTO 'albumsrecordingsmap' VALUES (576, 11, 45, 630);
INSERT INTO 'albumsrecordingsmap' VALUES (577, 1, 46, 97);
INSERT INTO 'albumsrecordingsmap' VALUES (578, 2, 46, 91);
INSERT INTO 'albumsrecordingsmap' VALUES (579, 3, 46, 21);
INSERT INTO 'albumsrecordingsmap' VALUES (580, 4, 46, 631);
INSERT INTO 'albumsrecordingsmap' VALUES (581, 5, 46, 155);
INSERT INTO 'albumsrecordingsmap' VALUES (582, 6, 46, 286);
INSERT INTO 'albumsrecordingsmap' VALUES (583, 7, 46, 362);
INSERT INTO 'albumsrecordingsmap' VALUES (584, 8, 46, 161);
INSERT INTO 'albumsrecordingsmap' VALUES (585, 9, 46, 116);
INSERT INTO 'albumsrecordingsmap' VALUES (586, 2, 47, 84);
INSERT INTO 'albumsrecordingsmap' VALUES (587, 3, 47, 14);
INSERT INTO 'albumsrecordingsmap' VALUES (588, 7, 47, 46);
INSERT INTO 'albumsrecordingsmap' VALUES (589, 9, 47, 45);
INSERT INTO 'albumsrecordingsmap' VALUES (590, 4, 47, 366);
INSERT INTO 'albumsrecordingsmap' VALUES (591, 1, 47, 632);
INSERT INTO 'albumsrecordingsmap' VALUES (592, 5, 47, 633);
INSERT INTO 'albumsrecordingsmap' VALUES (593, 6, 47, 634);
INSERT INTO 'albumsrecordingsmap' VALUES (594, 8, 47, 635);
INSERT INTO 'albumsrecordingsmap' VALUES (595, 1, 48, 636);
INSERT INTO 'albumsrecordingsmap' VALUES (596, 2, 48, 637);
INSERT INTO 'albumsrecordingsmap' VALUES (597, 3, 48, 638);
INSERT INTO 'albumsrecordingsmap' VALUES (598, 4, 48, 639);
INSERT INTO 'albumsrecordingsmap' VALUES (599, 5, 48, 640);
INSERT INTO 'albumsrecordingsmap' VALUES (600, 6, 48, 641);
INSERT INTO 'albumsrecordingsmap' VALUES (601, 7, 48, 642);
INSERT INTO 'albumsrecordingsmap' VALUES (10828, 3, 1114, 10234);
INSERT INTO 'albumsrecordingsmap' VALUES (602, 8, 48, 643);
INSERT INTO 'albumsrecordingsmap' VALUES (603, 9, 48, 644);
INSERT INTO 'albumsrecordingsmap' VALUES (604, 10, 48, 645);
INSERT INTO 'albumsrecordingsmap' VALUES (605, 11, 48, 646);
INSERT INTO 'albumsrecordingsmap' VALUES (606, 2, 49, 18);
INSERT INTO 'albumsrecordingsmap' VALUES (607, 3, 49, 70);
INSERT INTO 'albumsrecordingsmap' VALUES (608, 8, 49, 39);
INSERT INTO 'albumsrecordingsmap' VALUES (609, 10, 49, 224);
INSERT INTO 'albumsrecordingsmap' VALUES (610, 1, 49, 647);
INSERT INTO 'albumsrecordingsmap' VALUES (611, 4, 49, 648);
INSERT INTO 'albumsrecordingsmap' VALUES (612, 5, 49, 649);
INSERT INTO 'albumsrecordingsmap' VALUES (613, 6, 49, 650);
INSERT INTO 'albumsrecordingsmap' VALUES (614, 7, 49, 651);
INSERT INTO 'albumsrecordingsmap' VALUES (615, 9, 49, 652);
INSERT INTO 'albumsrecordingsmap' VALUES (616, 11, 49, 653);
INSERT INTO 'albumsrecordingsmap' VALUES (617, 12, 49, 654);
INSERT INTO 'albumsrecordingsmap' VALUES (618, 1, 50, 655);
INSERT INTO 'albumsrecordingsmap' VALUES (619, 2, 50, 656);
INSERT INTO 'albumsrecordingsmap' VALUES (620, 3, 50, 657);
INSERT INTO 'albumsrecordingsmap' VALUES (621, 4, 50, 658);
INSERT INTO 'albumsrecordingsmap' VALUES (622, 5, 50, 659);
INSERT INTO 'albumsrecordingsmap' VALUES (623, 6, 50, 660);
INSERT INTO 'albumsrecordingsmap' VALUES (624, 7, 50, 661);
INSERT INTO 'albumsrecordingsmap' VALUES (625, 8, 50, 662);
INSERT INTO 'albumsrecordingsmap' VALUES (626, 1, 51, 663);
INSERT INTO 'albumsrecordingsmap' VALUES (627, 2, 51, 664);
INSERT INTO 'albumsrecordingsmap' VALUES (628, 3, 51, 665);
INSERT INTO 'albumsrecordingsmap' VALUES (629, 4, 51, 666);
INSERT INTO 'albumsrecordingsmap' VALUES (630, 5, 51, 667);
INSERT INTO 'albumsrecordingsmap' VALUES (631, 6, 51, 668);
INSERT INTO 'albumsrecordingsmap' VALUES (632, 7, 51, 669);
INSERT INTO 'albumsrecordingsmap' VALUES (633, 8, 51, 670);
INSERT INTO 'albumsrecordingsmap' VALUES (634, 9, 51, 671);
INSERT INTO 'albumsrecordingsmap' VALUES (635, 10, 51, 672);
INSERT INTO 'albumsrecordingsmap' VALUES (636, 11, 51, 673);
INSERT INTO 'albumsrecordingsmap' VALUES (637, 12, 51, 674);
INSERT INTO 'albumsrecordingsmap' VALUES (638, 13, 51, 675);
INSERT INTO 'albumsrecordingsmap' VALUES (639, 14, 51, 676);
INSERT INTO 'albumsrecordingsmap' VALUES (640, 15, 51, 677);
INSERT INTO 'albumsrecordingsmap' VALUES (641, 1, 52, 678);
INSERT INTO 'albumsrecordingsmap' VALUES (642, 2, 52, 679);
INSERT INTO 'albumsrecordingsmap' VALUES (643, 3, 52, 680);
INSERT INTO 'albumsrecordingsmap' VALUES (644, 4, 52, 681);
INSERT INTO 'albumsrecordingsmap' VALUES (645, 5, 52, 682);
INSERT INTO 'albumsrecordingsmap' VALUES (646, 6, 52, 683);
INSERT INTO 'albumsrecordingsmap' VALUES (647, 7, 52, 684);
INSERT INTO 'albumsrecordingsmap' VALUES (648, 8, 52, 685);
INSERT INTO 'albumsrecordingsmap' VALUES (649, 9, 52, 686);
INSERT INTO 'albumsrecordingsmap' VALUES (650, 10, 52, 687);
INSERT INTO 'albumsrecordingsmap' VALUES (651, 1, 53, 688);
INSERT INTO 'albumsrecordingsmap' VALUES (652, 2, 53, 689);
INSERT INTO 'albumsrecordingsmap' VALUES (653, 3, 53, 690);
INSERT INTO 'albumsrecordingsmap' VALUES (654, 4, 53, 691);
INSERT INTO 'albumsrecordingsmap' VALUES (655, 5, 53, 692);
INSERT INTO 'albumsrecordingsmap' VALUES (656, 6, 53, 693);
INSERT INTO 'albumsrecordingsmap' VALUES (657, 7, 53, 694);
INSERT INTO 'albumsrecordingsmap' VALUES (658, 8, 53, 695);
INSERT INTO 'albumsrecordingsmap' VALUES (659, 9, 53, 696);
INSERT INTO 'albumsrecordingsmap' VALUES (660, 10, 53, 697);
INSERT INTO 'albumsrecordingsmap' VALUES (661, 11, 53, 698);
INSERT INTO 'albumsrecordingsmap' VALUES (662, 12, 53, 699);
INSERT INTO 'albumsrecordingsmap' VALUES (663, 13, 53, 700);
INSERT INTO 'albumsrecordingsmap' VALUES (664, 1, 54, 147);
INSERT INTO 'albumsrecordingsmap' VALUES (9661, 13, 1038, 9145);
INSERT INTO 'albumsrecordingsmap' VALUES (9662, 14, 1038, 9146);
INSERT INTO 'albumsrecordingsmap' VALUES (9663, 15, 1038, 9147);
INSERT INTO 'albumsrecordingsmap' VALUES (9710, 1, 1040, 9194);
INSERT INTO 'albumsrecordingsmap' VALUES (9711, 2, 1040, 9195);
INSERT INTO 'albumsrecordingsmap' VALUES (9712, 3, 1040, 9196);
INSERT INTO 'albumsrecordingsmap' VALUES (9716, 7, 1040, 9200);
INSERT INTO 'albumsrecordingsmap' VALUES (9717, 8, 1040, 9201);
INSERT INTO 'albumsrecordingsmap' VALUES (9718, 9, 1040, 9202);
INSERT INTO 'albumsrecordingsmap' VALUES (9725, 16, 1040, 9209);
INSERT INTO 'albumsrecordingsmap' VALUES (9726, 17, 1040, 9210);
INSERT INTO 'albumsrecordingsmap' VALUES (9727, 18, 1040, 9211);
INSERT INTO 'albumsrecordingsmap' VALUES (9728, 19, 1040, 9212);
INSERT INTO 'albumsrecordingsmap' VALUES (9729, 20, 1040, 9213);
INSERT INTO 'albumsrecordingsmap' VALUES (9730, 21, 1040, 9214);
INSERT INTO 'albumsrecordingsmap' VALUES (9733, 1, 1041, 9217);
INSERT INTO 'albumsrecordingsmap' VALUES (9734, 2, 1041, 9218);
INSERT INTO 'albumsrecordingsmap' VALUES (9735, 3, 1041, 9219);
INSERT INTO 'albumsrecordingsmap' VALUES (9736, 4, 1041, 9220);
INSERT INTO 'albumsrecordingsmap' VALUES (9737, 5, 1041, 9221);
INSERT INTO 'albumsrecordingsmap' VALUES (9738, 6, 1041, 9222);
INSERT INTO 'albumsrecordingsmap' VALUES (9739, 7, 1041, 9223);
INSERT INTO 'albumsrecordingsmap' VALUES (9740, 8, 1041, 9224);
INSERT INTO 'albumsrecordingsmap' VALUES (9741, 9, 1041, 9225);
INSERT INTO 'albumsrecordingsmap' VALUES (9745, 13, 1041, 9229);
INSERT INTO 'albumsrecordingsmap' VALUES (9746, 14, 1041, 9230);
INSERT INTO 'albumsrecordingsmap' VALUES (9747, 15, 1041, 9231);
INSERT INTO 'albumsrecordingsmap' VALUES (9748, 16, 1041, 9232);
INSERT INTO 'albumsrecordingsmap' VALUES (9749, 17, 1041, 9233);
INSERT INTO 'albumsrecordingsmap' VALUES (9750, 1, 1042, 9234);
INSERT INTO 'albumsrecordingsmap' VALUES (9751, 2, 1042, 9235);
INSERT INTO 'albumsrecordingsmap' VALUES (9752, 3, 1042, 9236);
INSERT INTO 'albumsrecordingsmap' VALUES (9753, 4, 1042, 9237);
INSERT INTO 'albumsrecordingsmap' VALUES (9754, 5, 1042, 9238);
INSERT INTO 'albumsrecordingsmap' VALUES (9758, 9, 1042, 9242);
INSERT INTO 'albumsrecordingsmap' VALUES (9759, 10, 1042, 9243);
INSERT INTO 'albumsrecordingsmap' VALUES (9760, 11, 1042, 9244);
INSERT INTO 'albumsrecordingsmap' VALUES (9761, 12, 1042, 9245);
INSERT INTO 'albumsrecordingsmap' VALUES (9762, 13, 1042, 9246);
INSERT INTO 'albumsrecordingsmap' VALUES (9763, 14, 1042, 9247);
INSERT INTO 'albumsrecordingsmap' VALUES (9767, 1, 1043, 9251);
INSERT INTO 'albumsrecordingsmap' VALUES (9768, 2, 1043, 9252);
INSERT INTO 'albumsrecordingsmap' VALUES (9769, 3, 1043, 9253);
INSERT INTO 'albumsrecordingsmap' VALUES (9770, 4, 1043, 9254);
INSERT INTO 'albumsrecordingsmap' VALUES (9771, 5, 1043, 9255);
INSERT INTO 'albumsrecordingsmap' VALUES (9772, 6, 1043, 8663);
INSERT INTO 'albumsrecordingsmap' VALUES (9773, 7, 1043, 9256);
INSERT INTO 'albumsrecordingsmap' VALUES (9774, 8, 1043, 9257);
INSERT INTO 'albumsrecordingsmap' VALUES (9775, 9, 1043, 9258);
INSERT INTO 'albumsrecordingsmap' VALUES (9778, 1, 1044, 2589);
INSERT INTO 'albumsrecordingsmap' VALUES (9779, 2, 1044, 2593);
INSERT INTO 'albumsrecordingsmap' VALUES (9780, 3, 1044, 2594);
INSERT INTO 'albumsrecordingsmap' VALUES (9790, 1, 1045, 2261);
INSERT INTO 'albumsrecordingsmap' VALUES (9791, 2, 1045, 2407);
INSERT INTO 'albumsrecordingsmap' VALUES (9792, 3, 1045, 2259);
INSERT INTO 'albumsrecordingsmap' VALUES (9805, 1, 1046, 2684);
INSERT INTO 'albumsrecordingsmap' VALUES (9806, 2, 1046, 1730);
INSERT INTO 'albumsrecordingsmap' VALUES (9807, 3, 1046, 3057);
INSERT INTO 'albumsrecordingsmap' VALUES (9820, 1, 1047, 9261);
INSERT INTO 'albumsrecordingsmap' VALUES (9821, 2, 1047, 9262);
INSERT INTO 'albumsrecordingsmap' VALUES (9822, 3, 1047, 9263);
INSERT INTO 'albumsrecordingsmap' VALUES (665, 2, 54, 154);
INSERT INTO 'albumsrecordingsmap' VALUES (666, 6, 54, 702);
INSERT INTO 'albumsrecordingsmap' VALUES (667, 9, 54, 150);
INSERT INTO 'albumsrecordingsmap' VALUES (668, 3, 54, 703);
INSERT INTO 'albumsrecordingsmap' VALUES (669, 4, 54, 704);
INSERT INTO 'albumsrecordingsmap' VALUES (670, 5, 54, 705);
INSERT INTO 'albumsrecordingsmap' VALUES (671, 7, 54, 706);
INSERT INTO 'albumsrecordingsmap' VALUES (672, 8, 54, 707);
INSERT INTO 'albumsrecordingsmap' VALUES (673, 1, 55, 708);
INSERT INTO 'albumsrecordingsmap' VALUES (674, 2, 55, 709);
INSERT INTO 'albumsrecordingsmap' VALUES (675, 3, 55, 710);
INSERT INTO 'albumsrecordingsmap' VALUES (676, 4, 55, 711);
INSERT INTO 'albumsrecordingsmap' VALUES (677, 5, 55, 712);
INSERT INTO 'albumsrecordingsmap' VALUES (678, 6, 55, 713);
INSERT INTO 'albumsrecordingsmap' VALUES (679, 7, 55, 714);
INSERT INTO 'albumsrecordingsmap' VALUES (680, 8, 55, 715);
INSERT INTO 'albumsrecordingsmap' VALUES (681, 1, 56, 228);
INSERT INTO 'albumsrecordingsmap' VALUES (682, 4, 56, 188);
INSERT INTO 'albumsrecordingsmap' VALUES (683, 5, 56, 105);
INSERT INTO 'albumsrecordingsmap' VALUES (684, 8, 56, 333);
INSERT INTO 'albumsrecordingsmap' VALUES (685, 2, 56, 717);
INSERT INTO 'albumsrecordingsmap' VALUES (686, 3, 56, 718);
INSERT INTO 'albumsrecordingsmap' VALUES (687, 6, 56, 719);
INSERT INTO 'albumsrecordingsmap' VALUES (688, 7, 56, 720);
INSERT INTO 'albumsrecordingsmap' VALUES (696, 1, 58, 729);
INSERT INTO 'albumsrecordingsmap' VALUES (697, 2, 58, 730);
INSERT INTO 'albumsrecordingsmap' VALUES (698, 3, 58, 731);
INSERT INTO 'albumsrecordingsmap' VALUES (699, 4, 58, 732);
INSERT INTO 'albumsrecordingsmap' VALUES (700, 5, 58, 733);
INSERT INTO 'albumsrecordingsmap' VALUES (701, 6, 58, 734);
INSERT INTO 'albumsrecordingsmap' VALUES (702, 1, 59, 606);
INSERT INTO 'albumsrecordingsmap' VALUES (703, 4, 59, 721);
INSERT INTO 'albumsrecordingsmap' VALUES (704, 5, 59, 353);
INSERT INTO 'albumsrecordingsmap' VALUES (705, 3, 59, 202);
INSERT INTO 'albumsrecordingsmap' VALUES (706, 2, 59, 136);
INSERT INTO 'albumsrecordingsmap' VALUES (707, 7, 59, 735);
INSERT INTO 'albumsrecordingsmap' VALUES (708, 8, 59, 736);
INSERT INTO 'albumsrecordingsmap' VALUES (709, 1, 60, 737);
INSERT INTO 'albumsrecordingsmap' VALUES (710, 2, 60, 738);
INSERT INTO 'albumsrecordingsmap' VALUES (711, 3, 60, 739);
INSERT INTO 'albumsrecordingsmap' VALUES (712, 4, 60, 740);
INSERT INTO 'albumsrecordingsmap' VALUES (713, 5, 60, 741);
INSERT INTO 'albumsrecordingsmap' VALUES (714, 6, 60, 742);
INSERT INTO 'albumsrecordingsmap' VALUES (715, 7, 60, 743);
INSERT INTO 'albumsrecordingsmap' VALUES (716, 8, 60, 744);
INSERT INTO 'albumsrecordingsmap' VALUES (717, 1, 61, 745);
INSERT INTO 'albumsrecordingsmap' VALUES (718, 2, 61, 746);
INSERT INTO 'albumsrecordingsmap' VALUES (719, 3, 61, 747);
INSERT INTO 'albumsrecordingsmap' VALUES (720, 4, 61, 748);
INSERT INTO 'albumsrecordingsmap' VALUES (721, 5, 61, 749);
INSERT INTO 'albumsrecordingsmap' VALUES (722, 6, 61, 750);
INSERT INTO 'albumsrecordingsmap' VALUES (723, 7, 61, 751);
INSERT INTO 'albumsrecordingsmap' VALUES (724, 8, 61, 752);
INSERT INTO 'albumsrecordingsmap' VALUES (725, 9, 61, 753);
INSERT INTO 'albumsrecordingsmap' VALUES (726, 10, 61, 754);
INSERT INTO 'albumsrecordingsmap' VALUES (727, 1, 62, 755);
INSERT INTO 'albumsrecordingsmap' VALUES (728, 2, 62, 756);
INSERT INTO 'albumsrecordingsmap' VALUES (729, 3, 62, 757);
INSERT INTO 'albumsrecordingsmap' VALUES (730, 4, 62, 758);
INSERT INTO 'albumsrecordingsmap' VALUES (731, 5, 62, 759);
INSERT INTO 'albumsrecordingsmap' VALUES (732, 6, 62, 760);
INSERT INTO 'albumsrecordingsmap' VALUES (733, 7, 62, 761);
INSERT INTO 'albumsrecordingsmap' VALUES (734, 8, 62, 762);
INSERT INTO 'albumsrecordingsmap' VALUES (735, 9, 62, 763);
INSERT INTO 'albumsrecordingsmap' VALUES (736, 10, 62, 764);
INSERT INTO 'albumsrecordingsmap' VALUES (737, 11, 62, 765);
INSERT INTO 'albumsrecordingsmap' VALUES (738, 12, 62, 766);
INSERT INTO 'albumsrecordingsmap' VALUES (739, 13, 62, 767);
INSERT INTO 'albumsrecordingsmap' VALUES (740, 1, 63, 768);
INSERT INTO 'albumsrecordingsmap' VALUES (741, 3, 63, 770);
INSERT INTO 'albumsrecordingsmap' VALUES (742, 4, 63, 771);
INSERT INTO 'albumsrecordingsmap' VALUES (743, 5, 63, 772);
INSERT INTO 'albumsrecordingsmap' VALUES (744, 6, 63, 773);
INSERT INTO 'albumsrecordingsmap' VALUES (745, 7, 63, 774);
INSERT INTO 'albumsrecordingsmap' VALUES (746, 8, 63, 775);
INSERT INTO 'albumsrecordingsmap' VALUES (747, 9, 63, 41);
INSERT INTO 'albumsrecordingsmap' VALUES (748, 10, 63, 186);
INSERT INTO 'albumsrecordingsmap' VALUES (749, 11, 63, 777);
INSERT INTO 'albumsrecordingsmap' VALUES (750, 12, 63, 778);
INSERT INTO 'albumsrecordingsmap' VALUES (751, 1, 64, 613);
INSERT INTO 'albumsrecordingsmap' VALUES (752, 2, 64, 716);
INSERT INTO 'albumsrecordingsmap' VALUES (753, 3, 64, 728);
INSERT INTO 'albumsrecordingsmap' VALUES (754, 11, 64, 785);
INSERT INTO 'albumsrecordingsmap' VALUES (755, 1, 65, 786);
INSERT INTO 'albumsrecordingsmap' VALUES (756, 2, 65, 787);
INSERT INTO 'albumsrecordingsmap' VALUES (757, 3, 65, 788);
INSERT INTO 'albumsrecordingsmap' VALUES (9664, 16, 1038, 9148);
INSERT INTO 'albumsrecordingsmap' VALUES (9665, 17, 1038, 9149);
INSERT INTO 'albumsrecordingsmap' VALUES (9666, 18, 1038, 9150);
INSERT INTO 'albumsrecordingsmap' VALUES (9713, 4, 1040, 9197);
INSERT INTO 'albumsrecordingsmap' VALUES (9714, 5, 1040, 9198);
INSERT INTO 'albumsrecordingsmap' VALUES (9715, 6, 1040, 9199);
INSERT INTO 'albumsrecordingsmap' VALUES (9719, 10, 1040, 9203);
INSERT INTO 'albumsrecordingsmap' VALUES (9720, 11, 1040, 9204);
INSERT INTO 'albumsrecordingsmap' VALUES (9721, 12, 1040, 9205);
INSERT INTO 'albumsrecordingsmap' VALUES (9731, 22, 1040, 9215);
INSERT INTO 'albumsrecordingsmap' VALUES (9732, 23, 1040, 9216);
INSERT INTO 'albumsrecordingsmap' VALUES (9742, 10, 1041, 9226);
INSERT INTO 'albumsrecordingsmap' VALUES (9743, 11, 1041, 9227);
INSERT INTO 'albumsrecordingsmap' VALUES (9744, 12, 1041, 9228);
INSERT INTO 'albumsrecordingsmap' VALUES (9755, 6, 1042, 9239);
INSERT INTO 'albumsrecordingsmap' VALUES (9756, 7, 1042, 9240);
INSERT INTO 'albumsrecordingsmap' VALUES (9757, 8, 1042, 9241);
INSERT INTO 'albumsrecordingsmap' VALUES (9764, 15, 1042, 9248);
INSERT INTO 'albumsrecordingsmap' VALUES (9765, 16, 1042, 9249);
INSERT INTO 'albumsrecordingsmap' VALUES (9766, 17, 1042, 9250);
INSERT INTO 'albumsrecordingsmap' VALUES (9776, 10, 1043, 9259);
INSERT INTO 'albumsrecordingsmap' VALUES (9777, 11, 1043, 9260);
INSERT INTO 'albumsrecordingsmap' VALUES (9781, 4, 1044, 2597);
INSERT INTO 'albumsrecordingsmap' VALUES (9782, 5, 1044, 2586);
INSERT INTO 'albumsrecordingsmap' VALUES (9783, 6, 1044, 2595);
INSERT INTO 'albumsrecordingsmap' VALUES (9793, 4, 1045, 2590);
INSERT INTO 'albumsrecordingsmap' VALUES (9794, 5, 1045, 2411);
INSERT INTO 'albumsrecordingsmap' VALUES (9795, 6, 1045, 2588);
INSERT INTO 'albumsrecordingsmap' VALUES (9808, 4, 1046, 3792);
INSERT INTO 'albumsrecordingsmap' VALUES (9809, 5, 1046, 3063);
INSERT INTO 'albumsrecordingsmap' VALUES (9810, 6, 1046, 3790);
INSERT INTO 'albumsrecordingsmap' VALUES (9823, 4, 1047, 9264);
INSERT INTO 'albumsrecordingsmap' VALUES (9824, 5, 1047, 9265);
INSERT INTO 'albumsrecordingsmap' VALUES (9825, 6, 1047, 9266);
INSERT INTO 'albumsrecordingsmap' VALUES (758, 4, 65, 789);
INSERT INTO 'albumsrecordingsmap' VALUES (759, 5, 65, 790);
INSERT INTO 'albumsrecordingsmap' VALUES (760, 6, 65, 791);
INSERT INTO 'albumsrecordingsmap' VALUES (761, 1, 66, 113);
INSERT INTO 'albumsrecordingsmap' VALUES (762, 2, 66, 795);
INSERT INTO 'albumsrecordingsmap' VALUES (763, 3, 66, 769);
INSERT INTO 'albumsrecordingsmap' VALUES (764, 4, 66, 152);
INSERT INTO 'albumsrecordingsmap' VALUES (765, 5, 66, 72);
INSERT INTO 'albumsrecordingsmap' VALUES (766, 7, 66, 796);
INSERT INTO 'albumsrecordingsmap' VALUES (767, 8, 66, 278);
INSERT INTO 'albumsrecordingsmap' VALUES (768, 9, 66, 181);
INSERT INTO 'albumsrecordingsmap' VALUES (769, 10, 66, 88);
INSERT INTO 'albumsrecordingsmap' VALUES (770, 11, 66, 331);
INSERT INTO 'albumsrecordingsmap' VALUES (771, 12, 66, 169);
INSERT INTO 'albumsrecordingsmap' VALUES (772, 13, 66, 218);
INSERT INTO 'albumsrecordingsmap' VALUES (773, 14, 66, 797);
INSERT INTO 'albumsrecordingsmap' VALUES (774, 15, 66, 798);
INSERT INTO 'albumsrecordingsmap' VALUES (779, 1, 67, 445);
INSERT INTO 'albumsrecordingsmap' VALUES (780, 2, 67, 446);
INSERT INTO 'albumsrecordingsmap' VALUES (781, 3, 67, 447);
INSERT INTO 'albumsrecordingsmap' VALUES (782, 4, 67, 448);
INSERT INTO 'albumsrecordingsmap' VALUES (783, 5, 67, 449);
INSERT INTO 'albumsrecordingsmap' VALUES (784, 6, 67, 450);
INSERT INTO 'albumsrecordingsmap' VALUES (785, 7, 67, 451);
INSERT INTO 'albumsrecordingsmap' VALUES (786, 8, 67, 452);
INSERT INTO 'albumsrecordingsmap' VALUES (787, 1, 68, 799);
INSERT INTO 'albumsrecordingsmap' VALUES (788, 2, 68, 800);
INSERT INTO 'albumsrecordingsmap' VALUES (789, 3, 68, 801);
INSERT INTO 'albumsrecordingsmap' VALUES (790, 4, 68, 802);
INSERT INTO 'albumsrecordingsmap' VALUES (791, 5, 68, 803);
INSERT INTO 'albumsrecordingsmap' VALUES (792, 6, 68, 804);
INSERT INTO 'albumsrecordingsmap' VALUES (793, 7, 68, 805);
INSERT INTO 'albumsrecordingsmap' VALUES (794, 8, 68, 806);
INSERT INTO 'albumsrecordingsmap' VALUES (795, 1, 69, 807);
INSERT INTO 'albumsrecordingsmap' VALUES (796, 3, 69, 337);
INSERT INTO 'albumsrecordingsmap' VALUES (797, 5, 69, 169);
INSERT INTO 'albumsrecordingsmap' VALUES (798, 10, 69, 157);
INSERT INTO 'albumsrecordingsmap' VALUES (799, 2, 69, 808);
INSERT INTO 'albumsrecordingsmap' VALUES (800, 4, 69, 809);
INSERT INTO 'albumsrecordingsmap' VALUES (801, 6, 69, 810);
INSERT INTO 'albumsrecordingsmap' VALUES (802, 7, 69, 811);
INSERT INTO 'albumsrecordingsmap' VALUES (803, 8, 69, 812);
INSERT INTO 'albumsrecordingsmap' VALUES (804, 9, 69, 813);
INSERT INTO 'albumsrecordingsmap' VALUES (805, 11, 69, 814);
INSERT INTO 'albumsrecordingsmap' VALUES (806, 12, 69, 815);
INSERT INTO 'albumsrecordingsmap' VALUES (807, 1, 20, 792);
INSERT INTO 'albumsrecordingsmap' VALUES (808, 2, 20, 661);
INSERT INTO 'albumsrecordingsmap' VALUES (809, 3, 20, 658);
INSERT INTO 'albumsrecordingsmap' VALUES (810, 4, 20, 449);
INSERT INTO 'albumsrecordingsmap' VALUES (811, 5, 20, 447);
INSERT INTO 'albumsrecordingsmap' VALUES (812, 7, 20, 445);
INSERT INTO 'albumsrecordingsmap' VALUES (813, 11, 20, 793);
INSERT INTO 'albumsrecordingsmap' VALUES (814, 12, 20, 455);
INSERT INTO 'albumsrecordingsmap' VALUES (815, 1, 70, 816);
INSERT INTO 'albumsrecordingsmap' VALUES (816, 2, 70, 817);
INSERT INTO 'albumsrecordingsmap' VALUES (817, 3, 70, 818);
INSERT INTO 'albumsrecordingsmap' VALUES (818, 4, 70, 819);
INSERT INTO 'albumsrecordingsmap' VALUES (819, 5, 70, 820);
INSERT INTO 'albumsrecordingsmap' VALUES (820, 6, 70, 821);
INSERT INTO 'albumsrecordingsmap' VALUES (821, 7, 70, 822);
INSERT INTO 'albumsrecordingsmap' VALUES (822, 8, 70, 823);
INSERT INTO 'albumsrecordingsmap' VALUES (823, 9, 70, 824);
INSERT INTO 'albumsrecordingsmap' VALUES (824, 10, 70, 825);
INSERT INTO 'albumsrecordingsmap' VALUES (825, 11, 70, 826);
INSERT INTO 'albumsrecordingsmap' VALUES (826, 12, 70, 827);
INSERT INTO 'albumsrecordingsmap' VALUES (827, 13, 70, 828);
INSERT INTO 'albumsrecordingsmap' VALUES (828, 14, 70, 829);
INSERT INTO 'albumsrecordingsmap' VALUES (829, 15, 70, 830);
INSERT INTO 'albumsrecordingsmap' VALUES (775, 3, 34, 50);
INSERT INTO 'albumsrecordingsmap' VALUES (776, 6, 34, 88);
INSERT INTO 'albumsrecordingsmap' VALUES (777, 8, 34, 72);
INSERT INTO 'albumsrecordingsmap' VALUES (778, 2, 34, 345);
INSERT INTO 'albumsrecordingsmap' VALUES (830, 1, 71, 832);
INSERT INTO 'albumsrecordingsmap' VALUES (831, 2, 71, 833);
INSERT INTO 'albumsrecordingsmap' VALUES (832, 3, 71, 834);
INSERT INTO 'albumsrecordingsmap' VALUES (833, 4, 71, 835);
INSERT INTO 'albumsrecordingsmap' VALUES (834, 5, 71, 836);
INSERT INTO 'albumsrecordingsmap' VALUES (835, 6, 71, 837);
INSERT INTO 'albumsrecordingsmap' VALUES (836, 7, 71, 838);
INSERT INTO 'albumsrecordingsmap' VALUES (837, 8, 71, 839);
INSERT INTO 'albumsrecordingsmap' VALUES (838, 9, 71, 840);
INSERT INTO 'albumsrecordingsmap' VALUES (839, 10, 71, 841);
INSERT INTO 'albumsrecordingsmap' VALUES (840, 11, 71, 842);
INSERT INTO 'albumsrecordingsmap' VALUES (841, 12, 71, 843);
INSERT INTO 'albumsrecordingsmap' VALUES (842, 13, 71, 844);
INSERT INTO 'albumsrecordingsmap' VALUES (843, 1, 72, 845);
INSERT INTO 'albumsrecordingsmap' VALUES (844, 2, 72, 846);
INSERT INTO 'albumsrecordingsmap' VALUES (845, 3, 72, 847);
INSERT INTO 'albumsrecordingsmap' VALUES (846, 4, 72, 848);
INSERT INTO 'albumsrecordingsmap' VALUES (847, 5, 72, 849);
INSERT INTO 'albumsrecordingsmap' VALUES (848, 6, 72, 850);
INSERT INTO 'albumsrecordingsmap' VALUES (849, 7, 72, 851);
INSERT INTO 'albumsrecordingsmap' VALUES (9722, 13, 1040, 9206);
INSERT INTO 'albumsrecordingsmap' VALUES (9723, 14, 1040, 9207);
INSERT INTO 'albumsrecordingsmap' VALUES (9724, 15, 1040, 9208);
INSERT INTO 'albumsrecordingsmap' VALUES (9784, 7, 1044, 2590);
INSERT INTO 'albumsrecordingsmap' VALUES (9785, 8, 1044, 2592);
INSERT INTO 'albumsrecordingsmap' VALUES (9786, 9, 1044, 2596);
INSERT INTO 'albumsrecordingsmap' VALUES (9796, 7, 1045, 2408);
INSERT INTO 'albumsrecordingsmap' VALUES (9797, 8, 1045, 2263);
INSERT INTO 'albumsrecordingsmap' VALUES (9798, 9, 1045, 2410);
INSERT INTO 'albumsrecordingsmap' VALUES (9811, 7, 1046, 149);
INSERT INTO 'albumsrecordingsmap' VALUES (9812, 8, 1046, 3781);
INSERT INTO 'albumsrecordingsmap' VALUES (9813, 9, 1046, 3059);
INSERT INTO 'albumsrecordingsmap' VALUES (9826, 7, 1047, 9269);
INSERT INTO 'albumsrecordingsmap' VALUES (9827, 8, 1047, 9270);
INSERT INTO 'albumsrecordingsmap' VALUES (9828, 9, 1047, 9271);
INSERT INTO 'albumsrecordingsmap' VALUES (9832, 13, 1047, 9275);
INSERT INTO 'albumsrecordingsmap' VALUES (9833, 14, 1047, 9276);
INSERT INTO 'albumsrecordingsmap' VALUES (9834, 15, 1047, 9277);
INSERT INTO 'albumsrecordingsmap' VALUES (9835, 16, 1047, 9278);
INSERT INTO 'albumsrecordingsmap' VALUES (9836, 17, 1047, 9279);
INSERT INTO 'albumsrecordingsmap' VALUES (9837, 18, 1047, 9280);
INSERT INTO 'albumsrecordingsmap' VALUES (9838, 19, 1047, 9281);
INSERT INTO 'albumsrecordingsmap' VALUES (9839, 21, 1047, 9282);
INSERT INTO 'albumsrecordingsmap' VALUES (9840, 20, 1047, 9283);
INSERT INTO 'albumsrecordingsmap' VALUES (9841, 22, 1047, 9284);
INSERT INTO 'albumsrecordingsmap' VALUES (9842, 23, 1047, 9285);
INSERT INTO 'albumsrecordingsmap' VALUES (9843, 1, 1048, 9286);
INSERT INTO 'albumsrecordingsmap' VALUES (9844, 2, 1048, 9287);
INSERT INTO 'albumsrecordingsmap' VALUES (9845, 3, 1048, 9288);
INSERT INTO 'albumsrecordingsmap' VALUES (9847, 5, 1048, 9290);
INSERT INTO 'albumsrecordingsmap' VALUES (9848, 6, 1048, 9291);
INSERT INTO 'albumsrecordingsmap' VALUES (9849, 7, 1048, 9292);
INSERT INTO 'albumsrecordingsmap' VALUES (9850, 8, 1048, 9293);
INSERT INTO 'albumsrecordingsmap' VALUES (9851, 9, 1048, 9294);
INSERT INTO 'albumsrecordingsmap' VALUES (9852, 10, 1048, 9295);
INSERT INTO 'albumsrecordingsmap' VALUES (9853, 11, 1048, 9296);
INSERT INTO 'albumsrecordingsmap' VALUES (9854, 12, 1048, 9297);
INSERT INTO 'albumsrecordingsmap' VALUES (9855, 13, 1048, 8830);
INSERT INTO 'albumsrecordingsmap' VALUES (9856, 14, 1048, 9299);
INSERT INTO 'albumsrecordingsmap' VALUES (9857, 15, 1048, 9300);
INSERT INTO 'albumsrecordingsmap' VALUES (9858, 16, 1048, 9301);
INSERT INTO 'albumsrecordingsmap' VALUES (9859, 1, 1049, 4054);
INSERT INTO 'albumsrecordingsmap' VALUES (9860, 3, 1049, 4056);
INSERT INTO 'albumsrecordingsmap' VALUES (9861, 4, 1049, 4057);
INSERT INTO 'albumsrecordingsmap' VALUES (10829, 4, 1114, 10235);
INSERT INTO 'albumsrecordingsmap' VALUES (850, 8, 72, 852);
INSERT INTO 'albumsrecordingsmap' VALUES (851, 9, 72, 853);
INSERT INTO 'albumsrecordingsmap' VALUES (852, 10, 72, 854);
INSERT INTO 'albumsrecordingsmap' VALUES (853, 11, 72, 855);
INSERT INTO 'albumsrecordingsmap' VALUES (854, 12, 72, 856);
INSERT INTO 'albumsrecordingsmap' VALUES (855, 1, 73, 857);
INSERT INTO 'albumsrecordingsmap' VALUES (856, 2, 73, 858);
INSERT INTO 'albumsrecordingsmap' VALUES (857, 3, 73, 859);
INSERT INTO 'albumsrecordingsmap' VALUES (858, 4, 73, 860);
INSERT INTO 'albumsrecordingsmap' VALUES (859, 5, 73, 861);
INSERT INTO 'albumsrecordingsmap' VALUES (860, 6, 73, 862);
INSERT INTO 'albumsrecordingsmap' VALUES (861, 7, 73, 863);
INSERT INTO 'albumsrecordingsmap' VALUES (862, 8, 73, 864);
INSERT INTO 'albumsrecordingsmap' VALUES (863, 9, 73, 865);
INSERT INTO 'albumsrecordingsmap' VALUES (864, 10, 73, 866);
INSERT INTO 'albumsrecordingsmap' VALUES (865, 11, 73, 867);
INSERT INTO 'albumsrecordingsmap' VALUES (866, 13, 73, 868);
INSERT INTO 'albumsrecordingsmap' VALUES (867, 12, 73, 869);
INSERT INTO 'albumsrecordingsmap' VALUES (868, 14, 73, 870);
INSERT INTO 'albumsrecordingsmap' VALUES (869, 1, 74, 12);
INSERT INTO 'albumsrecordingsmap' VALUES (870, 2, 74, 71);
INSERT INTO 'albumsrecordingsmap' VALUES (871, 3, 74, 89);
INSERT INTO 'albumsrecordingsmap' VALUES (872, 4, 74, 242);
INSERT INTO 'albumsrecordingsmap' VALUES (873, 5, 74, 249);
INSERT INTO 'albumsrecordingsmap' VALUES (874, 6, 74, 252);
INSERT INTO 'albumsrecordingsmap' VALUES (875, 7, 74, 274);
INSERT INTO 'albumsrecordingsmap' VALUES (876, 8, 74, 352);
INSERT INTO 'albumsrecordingsmap' VALUES (877, 9, 74, 367);
INSERT INTO 'albumsrecordingsmap' VALUES (878, 10, 74, 372);
INSERT INTO 'albumsrecordingsmap' VALUES (879, 11, 74, 456);
INSERT INTO 'albumsrecordingsmap' VALUES (880, 1, 75, 459);
INSERT INTO 'albumsrecordingsmap' VALUES (881, 2, 75, 461);
INSERT INTO 'albumsrecordingsmap' VALUES (882, 3, 75, 466);
INSERT INTO 'albumsrecordingsmap' VALUES (883, 4, 75, 871);
INSERT INTO 'albumsrecordingsmap' VALUES (884, 5, 75, 872);
INSERT INTO 'albumsrecordingsmap' VALUES (885, 6, 75, 873);
INSERT INTO 'albumsrecordingsmap' VALUES (886, 7, 75, 874);
INSERT INTO 'albumsrecordingsmap' VALUES (887, 8, 75, 875);
INSERT INTO 'albumsrecordingsmap' VALUES (888, 9, 75, 876);
INSERT INTO 'albumsrecordingsmap' VALUES (889, 10, 75, 877);
INSERT INTO 'albumsrecordingsmap' VALUES (890, 11, 75, 878);
INSERT INTO 'albumsrecordingsmap' VALUES (891, 12, 75, 879);
INSERT INTO 'albumsrecordingsmap' VALUES (892, 1, 76, 880);
INSERT INTO 'albumsrecordingsmap' VALUES (893, 2, 76, 881);
INSERT INTO 'albumsrecordingsmap' VALUES (894, 3, 76, 882);
INSERT INTO 'albumsrecordingsmap' VALUES (895, 4, 76, 883);
INSERT INTO 'albumsrecordingsmap' VALUES (896, 5, 76, 884);
INSERT INTO 'albumsrecordingsmap' VALUES (897, 6, 76, 885);
INSERT INTO 'albumsrecordingsmap' VALUES (898, 7, 76, 886);
INSERT INTO 'albumsrecordingsmap' VALUES (899, 8, 76, 887);
INSERT INTO 'albumsrecordingsmap' VALUES (900, 9, 76, 888);
INSERT INTO 'albumsrecordingsmap' VALUES (901, 10, 76, 889);
INSERT INTO 'albumsrecordingsmap' VALUES (902, 11, 76, 890);
INSERT INTO 'albumsrecordingsmap' VALUES (903, 12, 76, 891);
INSERT INTO 'albumsrecordingsmap' VALUES (904, 13, 76, 892);
INSERT INTO 'albumsrecordingsmap' VALUES (10830, 5, 1114, 10236);
INSERT INTO 'albumsrecordingsmap' VALUES (10759, 1, 1110, 10165);
INSERT INTO 'albumsrecordingsmap' VALUES (10760, 4, 1110, 10166);
INSERT INTO 'albumsrecordingsmap' VALUES (10831, 6, 1114, 10237);
INSERT INTO 'albumsrecordingsmap' VALUES (933, 1, 79, 290);
INSERT INTO 'albumsrecordingsmap' VALUES (934, 9, 79, 923);
INSERT INTO 'albumsrecordingsmap' VALUES (938, 1, 80, 200);
INSERT INTO 'albumsrecordingsmap' VALUES (939, 12, 80, 350);
INSERT INTO 'albumsrecordingsmap' VALUES (940, 3, 80, 117);
INSERT INTO 'albumsrecordingsmap' VALUES (941, 8, 80, 167);
INSERT INTO 'albumsrecordingsmap' VALUES (942, 10, 80, 795);
INSERT INTO 'albumsrecordingsmap' VALUES (9787, 10, 1044, 2591);
INSERT INTO 'albumsrecordingsmap' VALUES (9788, 11, 1044, 3415);
INSERT INTO 'albumsrecordingsmap' VALUES (9789, 12, 1044, 2588);
INSERT INTO 'albumsrecordingsmap' VALUES (9799, 10, 1045, 2596);
INSERT INTO 'albumsrecordingsmap' VALUES (9800, 11, 1045, 2409);
INSERT INTO 'albumsrecordingsmap' VALUES (9801, 12, 1045, 2257);
INSERT INTO 'albumsrecordingsmap' VALUES (9814, 10, 1046, 4153);
INSERT INTO 'albumsrecordingsmap' VALUES (9815, 11, 1046, 3780);
INSERT INTO 'albumsrecordingsmap' VALUES (9816, 12, 1046, 3062);
INSERT INTO 'albumsrecordingsmap' VALUES (9829, 10, 1047, 9272);
INSERT INTO 'albumsrecordingsmap' VALUES (9830, 11, 1047, 9273);
INSERT INTO 'albumsrecordingsmap' VALUES (9831, 12, 1047, 9274);
INSERT INTO 'albumsrecordingsmap' VALUES (9697, 31, 1039, 9181);
INSERT INTO 'albumsrecordingsmap' VALUES (9698, 32, 1039, 9182);
INSERT INTO 'albumsrecordingsmap' VALUES (9699, 33, 1039, 9183);
INSERT INTO 'albumsrecordingsmap' VALUES (9700, 34, 1039, 9184);
INSERT INTO 'albumsrecordingsmap' VALUES (9701, 35, 1039, 9185);
INSERT INTO 'albumsrecordingsmap' VALUES (9702, 36, 1039, 9186);
INSERT INTO 'albumsrecordingsmap' VALUES (9709, 43, 1039, 9193);
INSERT INTO 'albumsrecordingsmap' VALUES (9846, 4, 1048, 9289);
INSERT INTO 'albumsrecordingsmap' VALUES (9862, 2, 1049, 4055);
INSERT INTO 'albumsrecordingsmap' VALUES (9863, 5, 1049, 4058);
INSERT INTO 'albumsrecordingsmap' VALUES (9864, 6, 1049, 4059);
INSERT INTO 'albumsrecordingsmap' VALUES (10903, 6, 1121, 1361);
INSERT INTO 'albumsrecordingsmap' VALUES (10904, 7, 1121, 1362);
INSERT INTO 'albumsrecordingsmap' VALUES (10905, 8, 1121, 207);
INSERT INTO 'albumsrecordingsmap' VALUES (943, 2, 80, 927);
INSERT INTO 'albumsrecordingsmap' VALUES (944, 4, 80, 928);
INSERT INTO 'albumsrecordingsmap' VALUES (945, 5, 80, 929);
INSERT INTO 'albumsrecordingsmap' VALUES (946, 6, 80, 930);
INSERT INTO 'albumsrecordingsmap' VALUES (947, 7, 80, 931);
INSERT INTO 'albumsrecordingsmap' VALUES (948, 9, 80, 932);
INSERT INTO 'albumsrecordingsmap' VALUES (949, 11, 80, 933);
INSERT INTO 'albumsrecordingsmap' VALUES (950, 1, 81, 934);
INSERT INTO 'albumsrecordingsmap' VALUES (951, 2, 81, 935);
INSERT INTO 'albumsrecordingsmap' VALUES (952, 3, 81, 936);
INSERT INTO 'albumsrecordingsmap' VALUES (953, 4, 81, 937);
INSERT INTO 'albumsrecordingsmap' VALUES (954, 5, 81, 938);
INSERT INTO 'albumsrecordingsmap' VALUES (955, 6, 81, 939);
INSERT INTO 'albumsrecordingsmap' VALUES (956, 7, 81, 940);
INSERT INTO 'albumsrecordingsmap' VALUES (957, 8, 81, 941);
INSERT INTO 'albumsrecordingsmap' VALUES (958, 9, 81, 942);
INSERT INTO 'albumsrecordingsmap' VALUES (959, 10, 81, 943);
INSERT INTO 'albumsrecordingsmap' VALUES (960, 11, 81, 944);
INSERT INTO 'albumsrecordingsmap' VALUES (961, 12, 81, 945);
INSERT INTO 'albumsrecordingsmap' VALUES (962, 13, 81, 946);
INSERT INTO 'albumsrecordingsmap' VALUES (963, 14, 81, 903);
INSERT INTO 'albumsrecordingsmap' VALUES (964, 15, 81, 905);
INSERT INTO 'albumsrecordingsmap' VALUES (965, 1, 32, 914);
INSERT INTO 'albumsrecordingsmap' VALUES (966, 2, 32, 919);
INSERT INTO 'albumsrecordingsmap' VALUES (967, 3, 32, 921);
INSERT INTO 'albumsrecordingsmap' VALUES (968, 4, 32, 947);
INSERT INTO 'albumsrecordingsmap' VALUES (969, 5, 32, 948);
INSERT INTO 'albumsrecordingsmap' VALUES (970, 6, 32, 949);
INSERT INTO 'albumsrecordingsmap' VALUES (971, 7, 32, 950);
INSERT INTO 'albumsrecordingsmap' VALUES (972, 8, 32, 951);
INSERT INTO 'albumsrecordingsmap' VALUES (973, 9, 32, 952);
INSERT INTO 'albumsrecordingsmap' VALUES (974, 10, 32, 953);
INSERT INTO 'albumsrecordingsmap' VALUES (975, 11, 32, 954);
INSERT INTO 'albumsrecordingsmap' VALUES (976, 14, 53, 174);
INSERT INTO 'albumsrecordingsmap' VALUES (977, 1, 36, 487);
INSERT INTO 'albumsrecordingsmap' VALUES (978, 2, 36, 701);
INSERT INTO 'albumsrecordingsmap' VALUES (979, 3, 36, 955);
INSERT INTO 'albumsrecordingsmap' VALUES (980, 4, 36, 956);
INSERT INTO 'albumsrecordingsmap' VALUES (981, 5, 36, 957);
INSERT INTO 'albumsrecordingsmap' VALUES (982, 6, 36, 958);
INSERT INTO 'albumsrecordingsmap' VALUES (983, 7, 36, 959);
INSERT INTO 'albumsrecordingsmap' VALUES (984, 8, 36, 960);
INSERT INTO 'albumsrecordingsmap' VALUES (985, 9, 36, 961);
INSERT INTO 'albumsrecordingsmap' VALUES (9872, 1, 1050, 9302);
INSERT INTO 'albumsrecordingsmap' VALUES (9873, 2, 1050, 9303);
INSERT INTO 'albumsrecordingsmap' VALUES (9874, 3, 1050, 9304);
INSERT INTO 'albumsrecordingsmap' VALUES (9875, 4, 1050, 9305);
INSERT INTO 'albumsrecordingsmap' VALUES (9876, 5, 1050, 9306);
INSERT INTO 'albumsrecordingsmap' VALUES (9877, 6, 1050, 9307);
INSERT INTO 'albumsrecordingsmap' VALUES (9878, 7, 1050, 9308);
INSERT INTO 'albumsrecordingsmap' VALUES (9879, 8, 1050, 9309);
INSERT INTO 'albumsrecordingsmap' VALUES (9880, 9, 1050, 9310);
INSERT INTO 'albumsrecordingsmap' VALUES (905, 1, 77, 831);
INSERT INTO 'albumsrecordingsmap' VALUES (906, 2, 77, 893);
INSERT INTO 'albumsrecordingsmap' VALUES (907, 3, 77, 894);
INSERT INTO 'albumsrecordingsmap' VALUES (908, 4, 77, 895);
INSERT INTO 'albumsrecordingsmap' VALUES (909, 5, 77, 896);
INSERT INTO 'albumsrecordingsmap' VALUES (910, 6, 77, 897);
INSERT INTO 'albumsrecordingsmap' VALUES (911, 7, 77, 898);
INSERT INTO 'albumsrecordingsmap' VALUES (912, 8, 77, 899);
INSERT INTO 'albumsrecordingsmap' VALUES (913, 9, 77, 900);
INSERT INTO 'albumsrecordingsmap' VALUES (914, 10, 77, 901);
INSERT INTO 'albumsrecordingsmap' VALUES (915, 11, 77, 902);
INSERT INTO 'albumsrecordingsmap' VALUES (986, 10, 36, 962);
INSERT INTO 'albumsrecordingsmap' VALUES (987, 11, 36, 963);
INSERT INTO 'albumsrecordingsmap' VALUES (988, 1, 82, 380);
INSERT INTO 'albumsrecordingsmap' VALUES (989, 2, 82, 964);
INSERT INTO 'albumsrecordingsmap' VALUES (990, 3, 82, 965);
INSERT INTO 'albumsrecordingsmap' VALUES (991, 4, 82, 966);
INSERT INTO 'albumsrecordingsmap' VALUES (992, 5, 82, 967);
INSERT INTO 'albumsrecordingsmap' VALUES (993, 6, 82, 968);
INSERT INTO 'albumsrecordingsmap' VALUES (994, 7, 82, 969);
INSERT INTO 'albumsrecordingsmap' VALUES (995, 8, 82, 970);
INSERT INTO 'albumsrecordingsmap' VALUES (996, 9, 82, 971);
INSERT INTO 'albumsrecordingsmap' VALUES (997, 10, 82, 972);
INSERT INTO 'albumsrecordingsmap' VALUES (998, 11, 82, 973);
INSERT INTO 'albumsrecordingsmap' VALUES (999, 12, 82, 974);
INSERT INTO 'albumsrecordingsmap' VALUES (1000, 13, 82, 975);
INSERT INTO 'albumsrecordingsmap' VALUES (1001, 14, 82, 976);
INSERT INTO 'albumsrecordingsmap' VALUES (1002, 1, 83, 977);
INSERT INTO 'albumsrecordingsmap' VALUES (1003, 2, 83, 978);
INSERT INTO 'albumsrecordingsmap' VALUES (1004, 3, 83, 979);
INSERT INTO 'albumsrecordingsmap' VALUES (1005, 4, 83, 980);
INSERT INTO 'albumsrecordingsmap' VALUES (1006, 5, 83, 981);
INSERT INTO 'albumsrecordingsmap' VALUES (1007, 6, 83, 982);
INSERT INTO 'albumsrecordingsmap' VALUES (1008, 7, 83, 983);
INSERT INTO 'albumsrecordingsmap' VALUES (1009, 8, 83, 984);
INSERT INTO 'albumsrecordingsmap' VALUES (1010, 9, 83, 985);
INSERT INTO 'albumsrecordingsmap' VALUES (1011, 10, 83, 986);
INSERT INTO 'albumsrecordingsmap' VALUES (1012, 11, 83, 987);
INSERT INTO 'albumsrecordingsmap' VALUES (1013, 12, 83, 988);
INSERT INTO 'albumsrecordingsmap' VALUES (1014, 13, 83, 989);
INSERT INTO 'albumsrecordingsmap' VALUES (1015, 14, 83, 990);
INSERT INTO 'albumsrecordingsmap' VALUES (1016, 15, 83, 991);
INSERT INTO 'albumsrecordingsmap' VALUES (1017, 1, 84, 454);
INSERT INTO 'albumsrecordingsmap' VALUES (1018, 2, 84, 992);
INSERT INTO 'albumsrecordingsmap' VALUES (1019, 3, 84, 993);
INSERT INTO 'albumsrecordingsmap' VALUES (1020, 4, 84, 994);
INSERT INTO 'albumsrecordingsmap' VALUES (1021, 5, 84, 995);
INSERT INTO 'albumsrecordingsmap' VALUES (1022, 6, 84, 996);
INSERT INTO 'albumsrecordingsmap' VALUES (1023, 7, 84, 997);
INSERT INTO 'albumsrecordingsmap' VALUES (1024, 8, 84, 998);
INSERT INTO 'albumsrecordingsmap' VALUES (1025, 9, 84, 999);
INSERT INTO 'albumsrecordingsmap' VALUES (1026, 10, 84, 1000);
INSERT INTO 'albumsrecordingsmap' VALUES (1027, 11, 84, 1001);
INSERT INTO 'albumsrecordingsmap' VALUES (1028, 12, 84, 1002);
INSERT INTO 'albumsrecordingsmap' VALUES (1029, 13, 84, 1003);
INSERT INTO 'albumsrecordingsmap' VALUES (1030, 10, 23, 1004);
INSERT INTO 'albumsrecordingsmap' VALUES (1048, 1, 86, 1022);
INSERT INTO 'albumsrecordingsmap' VALUES (1049, 2, 86, 1023);
INSERT INTO 'albumsrecordingsmap' VALUES (1050, 3, 86, 1024);
INSERT INTO 'albumsrecordingsmap' VALUES (1051, 4, 86, 1025);
INSERT INTO 'albumsrecordingsmap' VALUES (1052, 5, 86, 1026);
INSERT INTO 'albumsrecordingsmap' VALUES (1053, 6, 86, 1027);
INSERT INTO 'albumsrecordingsmap' VALUES (1054, 7, 86, 1028);
INSERT INTO 'albumsrecordingsmap' VALUES (1055, 8, 86, 1029);
INSERT INTO 'albumsrecordingsmap' VALUES (1056, 9, 86, 1030);
INSERT INTO 'albumsrecordingsmap' VALUES (1057, 10, 86, 1031);
INSERT INTO 'albumsrecordingsmap' VALUES (1058, 4, 87, 1035);
INSERT INTO 'albumsrecordingsmap' VALUES (1059, 5, 87, 1036);
INSERT INTO 'albumsrecordingsmap' VALUES (1060, 6, 87, 1037);
INSERT INTO 'albumsrecordingsmap' VALUES (1061, 7, 87, 1038);
INSERT INTO 'albumsrecordingsmap' VALUES (9802, 13, 1045, 2405);
INSERT INTO 'albumsrecordingsmap' VALUES (9803, 14, 1045, 2591);
INSERT INTO 'albumsrecordingsmap' VALUES (9804, 15, 1045, 2260);
INSERT INTO 'albumsrecordingsmap' VALUES (9817, 13, 1046, 3789);
INSERT INTO 'albumsrecordingsmap' VALUES (9818, 14, 1046, 4154);
INSERT INTO 'albumsrecordingsmap' VALUES (9819, 15, 1046, 3061);
INSERT INTO 'albumsrecordingsmap' VALUES (9865, 7, 1049, 4047);
INSERT INTO 'albumsrecordingsmap' VALUES (9866, 8, 1049, 4048);
INSERT INTO 'albumsrecordingsmap' VALUES (9867, 9, 1049, 4049);
INSERT INTO 'albumsrecordingsmap' VALUES (1062, 8, 87, 1039);
INSERT INTO 'albumsrecordingsmap' VALUES (1063, 9, 87, 1040);
INSERT INTO 'albumsrecordingsmap' VALUES (1064, 10, 87, 1041);
INSERT INTO 'albumsrecordingsmap' VALUES (1065, 1, 88, 1042);
INSERT INTO 'albumsrecordingsmap' VALUES (1066, 2, 88, 1043);
INSERT INTO 'albumsrecordingsmap' VALUES (1067, 3, 88, 1044);
INSERT INTO 'albumsrecordingsmap' VALUES (1068, 4, 88, 1045);
INSERT INTO 'albumsrecordingsmap' VALUES (1069, 5, 88, 1046);
INSERT INTO 'albumsrecordingsmap' VALUES (1070, 6, 88, 1047);
INSERT INTO 'albumsrecordingsmap' VALUES (1071, 7, 88, 1048);
INSERT INTO 'albumsrecordingsmap' VALUES (1072, 8, 88, 1049);
INSERT INTO 'albumsrecordingsmap' VALUES (1073, 9, 88, 1050);
INSERT INTO 'albumsrecordingsmap' VALUES (1074, 10, 88, 1051);
INSERT INTO 'albumsrecordingsmap' VALUES (1075, 11, 88, 1052);
INSERT INTO 'albumsrecordingsmap' VALUES (1076, 12, 88, 1053);
INSERT INTO 'albumsrecordingsmap' VALUES (1077, 13, 88, 1054);
INSERT INTO 'albumsrecordingsmap' VALUES (1078, 14, 88, 1055);
INSERT INTO 'albumsrecordingsmap' VALUES (1079, 15, 88, 1056);
INSERT INTO 'albumsrecordingsmap' VALUES (1080, 16, 88, 1057);
INSERT INTO 'albumsrecordingsmap' VALUES (1081, 17, 88, 1058);
INSERT INTO 'albumsrecordingsmap' VALUES (1082, 18, 88, 1059);
INSERT INTO 'albumsrecordingsmap' VALUES (1083, 19, 88, 1060);
INSERT INTO 'albumsrecordingsmap' VALUES (1084, 20, 88, 1061);
INSERT INTO 'albumsrecordingsmap' VALUES (1085, 21, 88, 1062);
INSERT INTO 'albumsrecordingsmap' VALUES (1086, 1, 89, 1063);
INSERT INTO 'albumsrecordingsmap' VALUES (1087, 2, 89, 1064);
INSERT INTO 'albumsrecordingsmap' VALUES (1088, 3, 89, 1065);
INSERT INTO 'albumsrecordingsmap' VALUES (1089, 4, 89, 1066);
INSERT INTO 'albumsrecordingsmap' VALUES (1090, 7, 89, 1068);
INSERT INTO 'albumsrecordingsmap' VALUES (1091, 10, 89, 1071);
INSERT INTO 'albumsrecordingsmap' VALUES (1092, 11, 89, 1072);
INSERT INTO 'albumsrecordingsmap' VALUES (1093, 12, 89, 1073);
INSERT INTO 'albumsrecordingsmap' VALUES (1094, 14, 89, 1075);
INSERT INTO 'albumsrecordingsmap' VALUES (1095, 15, 89, 1076);
INSERT INTO 'albumsrecordingsmap' VALUES (1096, 16, 89, 1077);
INSERT INTO 'albumsrecordingsmap' VALUES (1097, 1, 90, 1078);
INSERT INTO 'albumsrecordingsmap' VALUES (1098, 2, 90, 1079);
INSERT INTO 'albumsrecordingsmap' VALUES (1099, 3, 90, 1080);
INSERT INTO 'albumsrecordingsmap' VALUES (1100, 4, 90, 1081);
INSERT INTO 'albumsrecordingsmap' VALUES (1101, 5, 90, 1082);
INSERT INTO 'albumsrecordingsmap' VALUES (1102, 6, 90, 1083);
INSERT INTO 'albumsrecordingsmap' VALUES (1103, 7, 90, 1084);
INSERT INTO 'albumsrecordingsmap' VALUES (1104, 8, 90, 1085);
INSERT INTO 'albumsrecordingsmap' VALUES (1105, 9, 90, 1086);
INSERT INTO 'albumsrecordingsmap' VALUES (1106, 10, 90, 1087);
INSERT INTO 'albumsrecordingsmap' VALUES (1107, 11, 90, 1088);
INSERT INTO 'albumsrecordingsmap' VALUES (1108, 12, 90, 1089);
INSERT INTO 'albumsrecordingsmap' VALUES (1109, 13, 90, 1090);
INSERT INTO 'albumsrecordingsmap' VALUES (1110, 14, 90, 1091);
INSERT INTO 'albumsrecordingsmap' VALUES (1111, 15, 90, 1092);
INSERT INTO 'albumsrecordingsmap' VALUES (1112, 1, 92, 1093);
INSERT INTO 'albumsrecordingsmap' VALUES (1113, 2, 92, 1094);
INSERT INTO 'albumsrecordingsmap' VALUES (1114, 3, 92, 1095);
INSERT INTO 'albumsrecordingsmap' VALUES (1115, 4, 92, 1096);
INSERT INTO 'albumsrecordingsmap' VALUES (1116, 5, 92, 1097);
INSERT INTO 'albumsrecordingsmap' VALUES (1117, 6, 92, 1098);
INSERT INTO 'albumsrecordingsmap' VALUES (1118, 7, 92, 1099);
INSERT INTO 'albumsrecordingsmap' VALUES (1119, 8, 92, 1100);
INSERT INTO 'albumsrecordingsmap' VALUES (1120, 9, 92, 1101);
INSERT INTO 'albumsrecordingsmap' VALUES (1121, 10, 92, 1102);
INSERT INTO 'albumsrecordingsmap' VALUES (1122, 11, 92, 1103);
INSERT INTO 'albumsrecordingsmap' VALUES (1123, 12, 92, 1104);
INSERT INTO 'albumsrecordingsmap' VALUES (10754, 3, 1110, 10160);
INSERT INTO 'albumsrecordingsmap' VALUES (10755, 5, 1110, 10161);
INSERT INTO 'albumsrecordingsmap' VALUES (10756, 6, 1110, 10162);
INSERT INTO 'albumsrecordingsmap' VALUES (10757, 7, 1110, 10163);
INSERT INTO 'albumsrecordingsmap' VALUES (1140, 1, 94, 1121);
INSERT INTO 'albumsrecordingsmap' VALUES (1141, 2, 94, 1122);
INSERT INTO 'albumsrecordingsmap' VALUES (1142, 3, 94, 1123);
INSERT INTO 'albumsrecordingsmap' VALUES (1143, 4, 94, 1124);
INSERT INTO 'albumsrecordingsmap' VALUES (1144, 5, 94, 1125);
INSERT INTO 'albumsrecordingsmap' VALUES (1145, 6, 94, 1126);
INSERT INTO 'albumsrecordingsmap' VALUES (1146, 7, 94, 1127);
INSERT INTO 'albumsrecordingsmap' VALUES (1147, 8, 94, 1128);
INSERT INTO 'albumsrecordingsmap' VALUES (1148, 9, 94, 1129);
INSERT INTO 'albumsrecordingsmap' VALUES (1149, 1, 96, 1138);
INSERT INTO 'albumsrecordingsmap' VALUES (1150, 2, 96, 1139);
INSERT INTO 'albumsrecordingsmap' VALUES (1151, 3, 96, 1140);
INSERT INTO 'albumsrecordingsmap' VALUES (1152, 4, 96, 1141);
INSERT INTO 'albumsrecordingsmap' VALUES (1153, 6, 96, 1142);
INSERT INTO 'albumsrecordingsmap' VALUES (9868, 10, 1049, 4050);
INSERT INTO 'albumsrecordingsmap' VALUES (9869, 11, 1049, 4051);
INSERT INTO 'albumsrecordingsmap' VALUES (9870, 12, 1049, 4052);
INSERT INTO 'albumsrecordingsmap' VALUES (1154, 5, 96, 1143);
INSERT INTO 'albumsrecordingsmap' VALUES (1155, 7, 96, 1144);
INSERT INTO 'albumsrecordingsmap' VALUES (1156, 8, 96, 1145);
INSERT INTO 'albumsrecordingsmap' VALUES (9887, 16, 1050, 9317);
INSERT INTO 'albumsrecordingsmap' VALUES (9888, 17, 1050, 9318);
INSERT INTO 'albumsrecordingsmap' VALUES (10761, 9, 1110, 10167);
INSERT INTO 'albumsrecordingsmap' VALUES (10762, 10, 1110, 10168);
INSERT INTO 'albumsrecordingsmap' VALUES (1157, 1, 97, 1146);
INSERT INTO 'albumsrecordingsmap' VALUES (1158, 2, 97, 1147);
INSERT INTO 'albumsrecordingsmap' VALUES (1159, 4, 97, 1148);
INSERT INTO 'albumsrecordingsmap' VALUES (1160, 5, 97, 1149);
INSERT INTO 'albumsrecordingsmap' VALUES (1161, 6, 97, 1150);
INSERT INTO 'albumsrecordingsmap' VALUES (1162, 7, 97, 1151);
INSERT INTO 'albumsrecordingsmap' VALUES (1163, 8, 97, 1152);
INSERT INTO 'albumsrecordingsmap' VALUES (1164, 9, 97, 1153);
INSERT INTO 'albumsrecordingsmap' VALUES (1165, 10, 97, 1154);
INSERT INTO 'albumsrecordingsmap' VALUES (1166, 11, 97, 1155);
INSERT INTO 'albumsrecordingsmap' VALUES (1167, 12, 97, 1156);
INSERT INTO 'albumsrecordingsmap' VALUES (1168, 13, 97, 1157);
INSERT INTO 'albumsrecordingsmap' VALUES (1169, 1, 99, 1169);
INSERT INTO 'albumsrecordingsmap' VALUES (1170, 2, 99, 1170);
INSERT INTO 'albumsrecordingsmap' VALUES (1171, 3, 99, 1171);
INSERT INTO 'albumsrecordingsmap' VALUES (1172, 4, 99, 1172);
INSERT INTO 'albumsrecordingsmap' VALUES (1173, 5, 99, 1173);
INSERT INTO 'albumsrecordingsmap' VALUES (1174, 6, 99, 1174);
INSERT INTO 'albumsrecordingsmap' VALUES (1175, 7, 99, 1175);
INSERT INTO 'albumsrecordingsmap' VALUES (1176, 8, 99, 1176);
INSERT INTO 'albumsrecordingsmap' VALUES (1177, 9, 99, 1177);
INSERT INTO 'albumsrecordingsmap' VALUES (1178, 1, 100, 1178);
INSERT INTO 'albumsrecordingsmap' VALUES (1179, 2, 100, 1179);
INSERT INTO 'albumsrecordingsmap' VALUES (1180, 3, 100, 1180);
INSERT INTO 'albumsrecordingsmap' VALUES (1181, 4, 100, 1181);
INSERT INTO 'albumsrecordingsmap' VALUES (1182, 5, 100, 1182);
INSERT INTO 'albumsrecordingsmap' VALUES (1183, 6, 100, 1183);
INSERT INTO 'albumsrecordingsmap' VALUES (1184, 7, 100, 1184);
INSERT INTO 'albumsrecordingsmap' VALUES (1185, 8, 100, 1185);
INSERT INTO 'albumsrecordingsmap' VALUES (1186, 9, 100, 1186);
INSERT INTO 'albumsrecordingsmap' VALUES (1187, 10, 100, 1187);
INSERT INTO 'albumsrecordingsmap' VALUES (1188, 11, 100, 1188);
INSERT INTO 'albumsrecordingsmap' VALUES (1189, 12, 100, 1189);
INSERT INTO 'albumsrecordingsmap' VALUES (1190, 13, 100, 1190);
INSERT INTO 'albumsrecordingsmap' VALUES (1191, 14, 100, 1191);
INSERT INTO 'albumsrecordingsmap' VALUES (1192, 15, 100, 1192);
INSERT INTO 'albumsrecordingsmap' VALUES (1193, 16, 100, 1193);
INSERT INTO 'albumsrecordingsmap' VALUES (1194, 17, 100, 1194);
INSERT INTO 'albumsrecordingsmap' VALUES (1195, 18, 100, 1195);
INSERT INTO 'albumsrecordingsmap' VALUES (1196, 1, 101, 1196);
INSERT INTO 'albumsrecordingsmap' VALUES (1197, 2, 101, 1197);
INSERT INTO 'albumsrecordingsmap' VALUES (1198, 3, 101, 1198);
INSERT INTO 'albumsrecordingsmap' VALUES (1199, 4, 101, 1199);
INSERT INTO 'albumsrecordingsmap' VALUES (1200, 5, 101, 1200);
INSERT INTO 'albumsrecordingsmap' VALUES (1201, 6, 101, 1201);
INSERT INTO 'albumsrecordingsmap' VALUES (1202, 7, 101, 1202);
INSERT INTO 'albumsrecordingsmap' VALUES (1203, 8, 101, 1203);
INSERT INTO 'albumsrecordingsmap' VALUES (1204, 9, 101, 1204);
INSERT INTO 'albumsrecordingsmap' VALUES (1205, 10, 101, 1205);
INSERT INTO 'albumsrecordingsmap' VALUES (1206, 11, 101, 1206);
INSERT INTO 'albumsrecordingsmap' VALUES (1207, 12, 101, 1207);
INSERT INTO 'albumsrecordingsmap' VALUES (1208, 13, 101, 1208);
INSERT INTO 'albumsrecordingsmap' VALUES (1209, 14, 101, 1209);
INSERT INTO 'albumsrecordingsmap' VALUES (1212, 2, 102, 1213);
INSERT INTO 'albumsrecordingsmap' VALUES (1213, 3, 102, 1214);
INSERT INTO 'albumsrecordingsmap' VALUES (1214, 4, 102, 1215);
INSERT INTO 'albumsrecordingsmap' VALUES (1215, 5, 102, 1216);
INSERT INTO 'albumsrecordingsmap' VALUES (1216, 6, 102, 1217);
INSERT INTO 'albumsrecordingsmap' VALUES (1217, 7, 102, 1218);
INSERT INTO 'albumsrecordingsmap' VALUES (1218, 8, 102, 1219);
INSERT INTO 'albumsrecordingsmap' VALUES (1219, 11, 102, 1221);
INSERT INTO 'albumsrecordingsmap' VALUES (1220, 12, 102, 1222);
INSERT INTO 'albumsrecordingsmap' VALUES (1221, 14, 102, 1224);
INSERT INTO 'albumsrecordingsmap' VALUES (1222, 15, 102, 1225);
INSERT INTO 'albumsrecordingsmap' VALUES (1223, 1, 103, 1226);
INSERT INTO 'albumsrecordingsmap' VALUES (1224, 2, 103, 1227);
INSERT INTO 'albumsrecordingsmap' VALUES (1225, 3, 103, 1228);
INSERT INTO 'albumsrecordingsmap' VALUES (1226, 4, 103, 1229);
INSERT INTO 'albumsrecordingsmap' VALUES (1227, 5, 103, 1230);
INSERT INTO 'albumsrecordingsmap' VALUES (1228, 6, 103, 1231);
INSERT INTO 'albumsrecordingsmap' VALUES (1229, 7, 103, 1232);
INSERT INTO 'albumsrecordingsmap' VALUES (1230, 8, 103, 1233);
INSERT INTO 'albumsrecordingsmap' VALUES (1231, 9, 103, 1234);
INSERT INTO 'albumsrecordingsmap' VALUES (1232, 10, 103, 1235);
INSERT INTO 'albumsrecordingsmap' VALUES (1233, 11, 103, 1236);
INSERT INTO 'albumsrecordingsmap' VALUES (1234, 1, 104, 1237);
INSERT INTO 'albumsrecordingsmap' VALUES (1235, 2, 104, 1238);
INSERT INTO 'albumsrecordingsmap' VALUES (1236, 3, 104, 1239);
INSERT INTO 'albumsrecordingsmap' VALUES (1237, 4, 104, 1240);
INSERT INTO 'albumsrecordingsmap' VALUES (1238, 5, 104, 1241);
INSERT INTO 'albumsrecordingsmap' VALUES (1239, 6, 104, 1242);
INSERT INTO 'albumsrecordingsmap' VALUES (1240, 7, 104, 1243);
INSERT INTO 'albumsrecordingsmap' VALUES (1241, 8, 104, 1244);
INSERT INTO 'albumsrecordingsmap' VALUES (1242, 9, 104, 1245);
INSERT INTO 'albumsrecordingsmap' VALUES (1243, 10, 104, 1246);
INSERT INTO 'albumsrecordingsmap' VALUES (1244, 11, 104, 1247);
INSERT INTO 'albumsrecordingsmap' VALUES (1245, 12, 104, 1248);
INSERT INTO 'albumsrecordingsmap' VALUES (1246, 1, 105, 1249);
INSERT INTO 'albumsrecordingsmap' VALUES (9871, 13, 1049, 4053);
INSERT INTO 'albumsrecordingsmap' VALUES (1247, 3, 105, 1251);
INSERT INTO 'albumsrecordingsmap' VALUES (1248, 4, 105, 1252);
INSERT INTO 'albumsrecordingsmap' VALUES (1249, 5, 105, 1253);
INSERT INTO 'albumsrecordingsmap' VALUES (1250, 6, 105, 1254);
INSERT INTO 'albumsrecordingsmap' VALUES (1251, 8, 105, 1256);
INSERT INTO 'albumsrecordingsmap' VALUES (1252, 9, 105, 1257);
INSERT INTO 'albumsrecordingsmap' VALUES (1253, 10, 105, 1258);
INSERT INTO 'albumsrecordingsmap' VALUES (1254, 11, 105, 1259);
INSERT INTO 'albumsrecordingsmap' VALUES (1255, 12, 105, 1260);
INSERT INTO 'albumsrecordingsmap' VALUES (1256, 1, 106, 1261);
INSERT INTO 'albumsrecordingsmap' VALUES (1257, 2, 106, 1262);
INSERT INTO 'albumsrecordingsmap' VALUES (1258, 3, 106, 1263);
INSERT INTO 'albumsrecordingsmap' VALUES (1259, 4, 106, 1264);
INSERT INTO 'albumsrecordingsmap' VALUES (1260, 5, 106, 1265);
INSERT INTO 'albumsrecordingsmap' VALUES (1261, 6, 106, 1266);
INSERT INTO 'albumsrecordingsmap' VALUES (1262, 7, 106, 1267);
INSERT INTO 'albumsrecordingsmap' VALUES (1263, 9, 106, 1269);
INSERT INTO 'albumsrecordingsmap' VALUES (1264, 10, 106, 1270);
INSERT INTO 'albumsrecordingsmap' VALUES (1265, 11, 106, 1271);
INSERT INTO 'albumsrecordingsmap' VALUES (1266, 12, 106, 1272);
INSERT INTO 'albumsrecordingsmap' VALUES (1267, 2, 105, 113);
INSERT INTO 'albumsrecordingsmap' VALUES (1268, 7, 105, 266);
INSERT INTO 'albumsrecordingsmap' VALUES (1269, 8, 106, 250);
INSERT INTO 'albumsrecordingsmap' VALUES (1270, 2, 107, 1273);
INSERT INTO 'albumsrecordingsmap' VALUES (1271, 3, 107, 1274);
INSERT INTO 'albumsrecordingsmap' VALUES (1272, 4, 107, 1275);
INSERT INTO 'albumsrecordingsmap' VALUES (1273, 5, 107, 1276);
INSERT INTO 'albumsrecordingsmap' VALUES (1274, 6, 107, 1277);
INSERT INTO 'albumsrecordingsmap' VALUES (1275, 7, 107, 1278);
INSERT INTO 'albumsrecordingsmap' VALUES (1276, 10, 107, 1279);
INSERT INTO 'albumsrecordingsmap' VALUES (1277, 11, 107, 1280);
INSERT INTO 'albumsrecordingsmap' VALUES (1278, 12, 107, 1281);
INSERT INTO 'albumsrecordingsmap' VALUES (1279, 1, 108, 1282);
INSERT INTO 'albumsrecordingsmap' VALUES (1280, 2, 108, 1283);
INSERT INTO 'albumsrecordingsmap' VALUES (1281, 3, 108, 1284);
INSERT INTO 'albumsrecordingsmap' VALUES (1282, 4, 108, 1285);
INSERT INTO 'albumsrecordingsmap' VALUES (1283, 5, 108, 1286);
INSERT INTO 'albumsrecordingsmap' VALUES (1284, 11, 108, 797);
INSERT INTO 'albumsrecordingsmap' VALUES (1285, 6, 108, 1287);
INSERT INTO 'albumsrecordingsmap' VALUES (1286, 7, 108, 1288);
INSERT INTO 'albumsrecordingsmap' VALUES (1287, 8, 108, 1289);
INSERT INTO 'albumsrecordingsmap' VALUES (1288, 9, 108, 1290);
INSERT INTO 'albumsrecordingsmap' VALUES (1289, 10, 108, 1291);
INSERT INTO 'albumsrecordingsmap' VALUES (1290, 12, 108, 1292);
INSERT INTO 'albumsrecordingsmap' VALUES (1291, 1, 109, 1293);
INSERT INTO 'albumsrecordingsmap' VALUES (1292, 6, 109, 181);
INSERT INTO 'albumsrecordingsmap' VALUES (1293, 2, 109, 1294);
INSERT INTO 'albumsrecordingsmap' VALUES (1294, 3, 109, 1295);
INSERT INTO 'albumsrecordingsmap' VALUES (1295, 4, 109, 1296);
INSERT INTO 'albumsrecordingsmap' VALUES (1296, 5, 109, 1297);
INSERT INTO 'albumsrecordingsmap' VALUES (1297, 7, 109, 1298);
INSERT INTO 'albumsrecordingsmap' VALUES (1298, 8, 109, 1299);
INSERT INTO 'albumsrecordingsmap' VALUES (1299, 9, 109, 1300);
INSERT INTO 'albumsrecordingsmap' VALUES (1300, 10, 109, 1301);
INSERT INTO 'albumsrecordingsmap' VALUES (1301, 11, 109, 1302);
INSERT INTO 'albumsrecordingsmap' VALUES (1302, 12, 109, 1303);
INSERT INTO 'albumsrecordingsmap' VALUES (1303, 2, 110, 61);
INSERT INTO 'albumsrecordingsmap' VALUES (1304, 5, 110, 796);
INSERT INTO 'albumsrecordingsmap' VALUES (1305, 6, 110, 28);
INSERT INTO 'albumsrecordingsmap' VALUES (1306, 1, 110, 1304);
INSERT INTO 'albumsrecordingsmap' VALUES (1307, 3, 110, 1305);
INSERT INTO 'albumsrecordingsmap' VALUES (1308, 4, 110, 1306);
INSERT INTO 'albumsrecordingsmap' VALUES (1309, 1, 111, 236);
INSERT INTO 'albumsrecordingsmap' VALUES (1310, 3, 111, 62);
INSERT INTO 'albumsrecordingsmap' VALUES (1311, 8, 111, 233);
INSERT INTO 'albumsrecordingsmap' VALUES (1312, 10, 111, 346);
INSERT INTO 'albumsrecordingsmap' VALUES (1313, 12, 111, 347);
INSERT INTO 'albumsrecordingsmap' VALUES (1314, 2, 111, 1307);
INSERT INTO 'albumsrecordingsmap' VALUES (1315, 4, 111, 1308);
INSERT INTO 'albumsrecordingsmap' VALUES (1316, 5, 111, 1309);
INSERT INTO 'albumsrecordingsmap' VALUES (1317, 6, 111, 1310);
INSERT INTO 'albumsrecordingsmap' VALUES (1318, 7, 111, 1311);
INSERT INTO 'albumsrecordingsmap' VALUES (1319, 11, 111, 1312);
INSERT INTO 'albumsrecordingsmap' VALUES (1320, 9, 111, 1313);
INSERT INTO 'albumsrecordingsmap' VALUES (1321, 1, 112, 1314);
INSERT INTO 'albumsrecordingsmap' VALUES (1322, 2, 112, 1315);
INSERT INTO 'albumsrecordingsmap' VALUES (1323, 3, 112, 1316);
INSERT INTO 'albumsrecordingsmap' VALUES (1324, 4, 112, 1317);
INSERT INTO 'albumsrecordingsmap' VALUES (1325, 5, 112, 1318);
INSERT INTO 'albumsrecordingsmap' VALUES (1326, 6, 112, 1319);
INSERT INTO 'albumsrecordingsmap' VALUES (1327, 7, 112, 1320);
INSERT INTO 'albumsrecordingsmap' VALUES (1328, 8, 112, 1321);
INSERT INTO 'albumsrecordingsmap' VALUES (1329, 9, 112, 1322);
INSERT INTO 'albumsrecordingsmap' VALUES (1330, 10, 112, 1323);
INSERT INTO 'albumsrecordingsmap' VALUES (1331, 11, 112, 1324);
INSERT INTO 'albumsrecordingsmap' VALUES (1332, 12, 112, 1325);
INSERT INTO 'albumsrecordingsmap' VALUES (1333, 7, 113, 278);
INSERT INTO 'albumsrecordingsmap' VALUES (1334, 9, 113, 294);
INSERT INTO 'albumsrecordingsmap' VALUES (1335, 1, 113, 1326);
INSERT INTO 'albumsrecordingsmap' VALUES (1336, 2, 113, 1327);
INSERT INTO 'albumsrecordingsmap' VALUES (1337, 3, 113, 1328);
INSERT INTO 'albumsrecordingsmap' VALUES (1338, 4, 113, 1329);
INSERT INTO 'albumsrecordingsmap' VALUES (1339, 10, 113, 148);
INSERT INTO 'albumsrecordingsmap' VALUES (1340, 5, 113, 1330);
INSERT INTO 'albumsrecordingsmap' VALUES (1341, 6, 113, 1331);
INSERT INTO 'albumsrecordingsmap' VALUES (1342, 8, 113, 1332);
INSERT INTO 'albumsrecordingsmap' VALUES (1343, 11, 113, 1333);
INSERT INTO 'albumsrecordingsmap' VALUES (1344, 12, 113, 1334);
INSERT INTO 'albumsrecordingsmap' VALUES (1345, 1, 114, 1335);
INSERT INTO 'albumsrecordingsmap' VALUES (1346, 2, 114, 1336);
INSERT INTO 'albumsrecordingsmap' VALUES (1347, 3, 114, 1337);
INSERT INTO 'albumsrecordingsmap' VALUES (1348, 4, 114, 1338);
INSERT INTO 'albumsrecordingsmap' VALUES (1349, 5, 114, 234);
INSERT INTO 'albumsrecordingsmap' VALUES (1350, 6, 114, 1339);
INSERT INTO 'albumsrecordingsmap' VALUES (1351, 7, 114, 1340);
INSERT INTO 'albumsrecordingsmap' VALUES (1352, 8, 114, 57);
INSERT INTO 'albumsrecordingsmap' VALUES (1353, 9, 114, 1341);
INSERT INTO 'albumsrecordingsmap' VALUES (1354, 10, 114, 1342);
INSERT INTO 'albumsrecordingsmap' VALUES (1355, 11, 114, 1343);
INSERT INTO 'albumsrecordingsmap' VALUES (1356, 12, 114, 1344);
INSERT INTO 'albumsrecordingsmap' VALUES (1357, 1, 115, 453);
INSERT INTO 'albumsrecordingsmap' VALUES (1358, 2, 115, 1250);
INSERT INTO 'albumsrecordingsmap' VALUES (1359, 3, 115, 355);
INSERT INTO 'albumsrecordingsmap' VALUES (1360, 4, 115, 85);
INSERT INTO 'albumsrecordingsmap' VALUES (1361, 5, 115, 1255);
INSERT INTO 'albumsrecordingsmap' VALUES (1362, 6, 115, 1268);
INSERT INTO 'albumsrecordingsmap' VALUES (1363, 7, 115, 1345);
INSERT INTO 'albumsrecordingsmap' VALUES (1364, 8, 115, 1346);
INSERT INTO 'albumsrecordingsmap' VALUES (1365, 9, 115, 114);
INSERT INTO 'albumsrecordingsmap' VALUES (1366, 10, 115, 1347);
INSERT INTO 'albumsrecordingsmap' VALUES (1367, 1, 116, 1348);
INSERT INTO 'albumsrecordingsmap' VALUES (1368, 2, 116, 1349);
INSERT INTO 'albumsrecordingsmap' VALUES (1369, 3, 116, 1350);
INSERT INTO 'albumsrecordingsmap' VALUES (1370, 4, 116, 1351);
INSERT INTO 'albumsrecordingsmap' VALUES (1371, 5, 116, 1352);
INSERT INTO 'albumsrecordingsmap' VALUES (1372, 6, 116, 1353);
INSERT INTO 'albumsrecordingsmap' VALUES (1373, 7, 116, 112);
INSERT INTO 'albumsrecordingsmap' VALUES (1374, 8, 116, 1354);
INSERT INTO 'albumsrecordingsmap' VALUES (1375, 9, 116, 1355);
INSERT INTO 'albumsrecordingsmap' VALUES (1376, 1, 117, 64);
INSERT INTO 'albumsrecordingsmap' VALUES (1377, 2, 117, 53);
INSERT INTO 'albumsrecordingsmap' VALUES (1378, 3, 117, 193);
INSERT INTO 'albumsrecordingsmap' VALUES (1379, 4, 117, 257);
INSERT INTO 'albumsrecordingsmap' VALUES (1380, 5, 117, 9);
INSERT INTO 'albumsrecordingsmap' VALUES (1381, 6, 117, 1356);
INSERT INTO 'albumsrecordingsmap' VALUES (1382, 7, 117, 1357);
INSERT INTO 'albumsrecordingsmap' VALUES (1383, 8, 117, 1358);
INSERT INTO 'albumsrecordingsmap' VALUES (1392, 1, 119, 1363);
INSERT INTO 'albumsrecordingsmap' VALUES (1393, 2, 119, 1364);
INSERT INTO 'albumsrecordingsmap' VALUES (1394, 3, 119, 1365);
INSERT INTO 'albumsrecordingsmap' VALUES (1395, 4, 119, 1366);
INSERT INTO 'albumsrecordingsmap' VALUES (1396, 5, 119, 1367);
INSERT INTO 'albumsrecordingsmap' VALUES (1397, 6, 119, 1368);
INSERT INTO 'albumsrecordingsmap' VALUES (1398, 7, 119, 1369);
INSERT INTO 'albumsrecordingsmap' VALUES (1399, 8, 119, 1370);
INSERT INTO 'albumsrecordingsmap' VALUES (1400, 9, 119, 1371);
INSERT INTO 'albumsrecordingsmap' VALUES (1401, 10, 119, 1372);
INSERT INTO 'albumsrecordingsmap' VALUES (1402, 11, 119, 1373);
INSERT INTO 'albumsrecordingsmap' VALUES (1403, 12, 119, 1374);
INSERT INTO 'albumsrecordingsmap' VALUES (1404, 1, 120, 1375);
INSERT INTO 'albumsrecordingsmap' VALUES (1405, 2, 120, 1376);
INSERT INTO 'albumsrecordingsmap' VALUES (1406, 3, 120, 1377);
INSERT INTO 'albumsrecordingsmap' VALUES (1407, 4, 120, 1378);
INSERT INTO 'albumsrecordingsmap' VALUES (1408, 6, 120, 1380);
INSERT INTO 'albumsrecordingsmap' VALUES (1409, 7, 120, 1381);
INSERT INTO 'albumsrecordingsmap' VALUES (1410, 8, 120, 1382);
INSERT INTO 'albumsrecordingsmap' VALUES (1411, 2, 121, 1384);
INSERT INTO 'albumsrecordingsmap' VALUES (1412, 3, 121, 1385);
INSERT INTO 'albumsrecordingsmap' VALUES (1413, 6, 121, 1388);
INSERT INTO 'albumsrecordingsmap' VALUES (1414, 7, 121, 1389);
INSERT INTO 'albumsrecordingsmap' VALUES (1415, 8, 121, 1390);
INSERT INTO 'albumsrecordingsmap' VALUES (1416, 2, 122, 1392);
INSERT INTO 'albumsrecordingsmap' VALUES (1417, 3, 122, 1393);
INSERT INTO 'albumsrecordingsmap' VALUES (1418, 5, 122, 1395);
INSERT INTO 'albumsrecordingsmap' VALUES (1419, 6, 122, 1396);
INSERT INTO 'albumsrecordingsmap' VALUES (1420, 7, 122, 1397);
INSERT INTO 'albumsrecordingsmap' VALUES (1421, 8, 122, 1398);
INSERT INTO 'albumsrecordingsmap' VALUES (1422, 9, 122, 1399);
INSERT INTO 'albumsrecordingsmap' VALUES (1423, 1, 123, 1400);
INSERT INTO 'albumsrecordingsmap' VALUES (1424, 2, 123, 1401);
INSERT INTO 'albumsrecordingsmap' VALUES (1425, 4, 123, 1403);
INSERT INTO 'albumsrecordingsmap' VALUES (1426, 5, 123, 1404);
INSERT INTO 'albumsrecordingsmap' VALUES (1427, 10, 123, 1409);
INSERT INTO 'albumsrecordingsmap' VALUES (1428, 5, 120, 798);
INSERT INTO 'albumsrecordingsmap' VALUES (1429, 1, 121, 319);
INSERT INTO 'albumsrecordingsmap' VALUES (1430, 4, 121, 285);
INSERT INTO 'albumsrecordingsmap' VALUES (1431, 5, 121, 227);
INSERT INTO 'albumsrecordingsmap' VALUES (1432, 1, 122, 211);
INSERT INTO 'albumsrecordingsmap' VALUES (1433, 4, 122, 77);
INSERT INTO 'albumsrecordingsmap' VALUES (1434, 6, 123, 103);
INSERT INTO 'albumsrecordingsmap' VALUES (1435, 7, 123, 331);
INSERT INTO 'albumsrecordingsmap' VALUES (1436, 8, 123, 213);
INSERT INTO 'albumsrecordingsmap' VALUES (1437, 9, 123, 216);
INSERT INTO 'albumsrecordingsmap' VALUES (1438, 12, 23, 23);
INSERT INTO 'albumsrecordingsmap' VALUES (1439, 5, 18, 801);
INSERT INTO 'albumsrecordingsmap' VALUES (1440, 1, 23, 168);
INSERT INTO 'albumsrecordingsmap' VALUES (1441, 9, 18, 802);
INSERT INTO 'albumsrecordingsmap' VALUES (1442, 10, 24, 239);
INSERT INTO 'albumsrecordingsmap' VALUES (1443, 1, 125, 24);
INSERT INTO 'albumsrecordingsmap' VALUES (1444, 2, 125, 107);
INSERT INTO 'albumsrecordingsmap' VALUES (1445, 3, 125, 123);
INSERT INTO 'albumsrecordingsmap' VALUES (1446, 4, 125, 170);
INSERT INTO 'albumsrecordingsmap' VALUES (1447, 5, 125, 235);
INSERT INTO 'albumsrecordingsmap' VALUES (1448, 6, 125, 240);
INSERT INTO 'albumsrecordingsmap' VALUES (1449, 7, 125, 922);
INSERT INTO 'albumsrecordingsmap' VALUES (1450, 9, 125, 1383);
INSERT INTO 'albumsrecordingsmap' VALUES (1451, 10, 125, 1386);
INSERT INTO 'albumsrecordingsmap' VALUES (1452, 11, 125, 1387);
INSERT INTO 'albumsrecordingsmap' VALUES (1453, 12, 125, 1391);
INSERT INTO 'albumsrecordingsmap' VALUES (1454, 13, 125, 1394);
INSERT INTO 'albumsrecordingsmap' VALUES (1455, 14, 125, 1405);
INSERT INTO 'albumsrecordingsmap' VALUES (1456, 15, 125, 1406);
INSERT INTO 'albumsrecordingsmap' VALUES (1457, 16, 125, 1407);
INSERT INTO 'albumsrecordingsmap' VALUES (1458, 7, 95, 1136);
INSERT INTO 'albumsrecordingsmap' VALUES (1459, 1, 95, 1130);
INSERT INTO 'albumsrecordingsmap' VALUES (1460, 8, 95, 1137);
INSERT INTO 'albumsrecordingsmap' VALUES (1461, 5, 95, 1134);
INSERT INTO 'albumsrecordingsmap' VALUES (1462, 3, 95, 1132);
INSERT INTO 'albumsrecordingsmap' VALUES (1463, 4, 95, 1133);
INSERT INTO 'albumsrecordingsmap' VALUES (1464, 2, 95, 1131);
INSERT INTO 'albumsrecordingsmap' VALUES (1465, 6, 95, 1135);
INSERT INTO 'albumsrecordingsmap' VALUES (1466, 6, 206, 1410);
INSERT INTO 'albumsrecordingsmap' VALUES (1467, 4, 206, 1411);
INSERT INTO 'albumsrecordingsmap' VALUES (1468, 3, 206, 1412);
INSERT INTO 'albumsrecordingsmap' VALUES (1469, 5, 206, 1413);
INSERT INTO 'albumsrecordingsmap' VALUES (1470, 1, 206, 1414);
INSERT INTO 'albumsrecordingsmap' VALUES (1471, 9, 206, 1415);
INSERT INTO 'albumsrecordingsmap' VALUES (1472, 7, 206, 1416);
INSERT INTO 'albumsrecordingsmap' VALUES (1473, 2, 206, 1417);
INSERT INTO 'albumsrecordingsmap' VALUES (1474, 8, 206, 1418);
INSERT INTO 'albumsrecordingsmap' VALUES (1475, 8, 125, 1379);
INSERT INTO 'albumsrecordingsmap' VALUES (1476, 6, 155, 1419);
INSERT INTO 'albumsrecordingsmap' VALUES (1477, 1, 155, 1420);
INSERT INTO 'albumsrecordingsmap' VALUES (1478, 4, 155, 1421);
INSERT INTO 'albumsrecordingsmap' VALUES (1479, 8, 155, 1422);
INSERT INTO 'albumsrecordingsmap' VALUES (1480, 3, 155, 1423);
INSERT INTO 'albumsrecordingsmap' VALUES (1481, 7, 155, 1424);
INSERT INTO 'albumsrecordingsmap' VALUES (1482, 5, 155, 1425);
INSERT INTO 'albumsrecordingsmap' VALUES (1483, 2, 155, 1426);
INSERT INTO 'albumsrecordingsmap' VALUES (1484, 5, 166, 1427);
INSERT INTO 'albumsrecordingsmap' VALUES (1485, 6, 166, 1428);
INSERT INTO 'albumsrecordingsmap' VALUES (1486, 4, 166, 1429);
INSERT INTO 'albumsrecordingsmap' VALUES (1487, 8, 166, 1430);
INSERT INTO 'albumsrecordingsmap' VALUES (1488, 2, 166, 1431);
INSERT INTO 'albumsrecordingsmap' VALUES (1489, 9, 166, 1432);
INSERT INTO 'albumsrecordingsmap' VALUES (1490, 1, 166, 1433);
INSERT INTO 'albumsrecordingsmap' VALUES (1491, 7, 166, 1434);
INSERT INTO 'albumsrecordingsmap' VALUES (1492, 3, 166, 1435);
INSERT INTO 'albumsrecordingsmap' VALUES (1493, 4, 156, 1436);
INSERT INTO 'albumsrecordingsmap' VALUES (1494, 7, 156, 1437);
INSERT INTO 'albumsrecordingsmap' VALUES (1495, 2, 156, 1438);
INSERT INTO 'albumsrecordingsmap' VALUES (1496, 1, 156, 1439);
INSERT INTO 'albumsrecordingsmap' VALUES (1497, 3, 156, 1440);
INSERT INTO 'albumsrecordingsmap' VALUES (1498, 8, 156, 1441);
INSERT INTO 'albumsrecordingsmap' VALUES (1499, 6, 156, 1442);
INSERT INTO 'albumsrecordingsmap' VALUES (1500, 5, 156, 1443);
INSERT INTO 'albumsrecordingsmap' VALUES (1501, 9, 156, 1444);
INSERT INTO 'albumsrecordingsmap' VALUES (1502, 1, 204, 1445);
INSERT INTO 'albumsrecordingsmap' VALUES (1503, 5, 204, 1446);
INSERT INTO 'albumsrecordingsmap' VALUES (1504, 8, 204, 1447);
INSERT INTO 'albumsrecordingsmap' VALUES (1505, 6, 204, 1448);
INSERT INTO 'albumsrecordingsmap' VALUES (1506, 4, 204, 1449);
INSERT INTO 'albumsrecordingsmap' VALUES (1507, 2, 204, 1450);
INSERT INTO 'albumsrecordingsmap' VALUES (1508, 7, 204, 1452);
INSERT INTO 'albumsrecordingsmap' VALUES (1509, 1, 160, 1453);
INSERT INTO 'albumsrecordingsmap' VALUES (1510, 2, 160, 1454);
INSERT INTO 'albumsrecordingsmap' VALUES (1511, 3, 160, 1455);
INSERT INTO 'albumsrecordingsmap' VALUES (1512, 4, 160, 1456);
INSERT INTO 'albumsrecordingsmap' VALUES (1513, 5, 160, 1457);
INSERT INTO 'albumsrecordingsmap' VALUES (1514, 6, 160, 1458);
INSERT INTO 'albumsrecordingsmap' VALUES (1515, 7, 160, 1459);
INSERT INTO 'albumsrecordingsmap' VALUES (1516, 8, 160, 1460);
INSERT INTO 'albumsrecordingsmap' VALUES (1517, 9, 160, 1461);
INSERT INTO 'albumsrecordingsmap' VALUES (1518, 10, 160, 1462);
INSERT INTO 'albumsrecordingsmap' VALUES (1519, 11, 160, 1463);
INSERT INTO 'albumsrecordingsmap' VALUES (1520, 12, 160, 1464);
INSERT INTO 'albumsrecordingsmap' VALUES (1521, 6, 59, 1465);
INSERT INTO 'albumsrecordingsmap' VALUES (1522, 7, 165, 1466);
INSERT INTO 'albumsrecordingsmap' VALUES (1523, 11, 165, 1467);
INSERT INTO 'albumsrecordingsmap' VALUES (1524, 8, 165, 1469);
INSERT INTO 'albumsrecordingsmap' VALUES (1525, 10, 165, 1470);
INSERT INTO 'albumsrecordingsmap' VALUES (1526, 1, 165, 1471);
INSERT INTO 'albumsrecordingsmap' VALUES (1527, 4, 165, 1472);
INSERT INTO 'albumsrecordingsmap' VALUES (1528, 5, 165, 1473);
INSERT INTO 'albumsrecordingsmap' VALUES (1529, 2, 165, 1474);
INSERT INTO 'albumsrecordingsmap' VALUES (1530, 3, 165, 1475);
INSERT INTO 'albumsrecordingsmap' VALUES (1531, 9, 165, 1476);
INSERT INTO 'albumsrecordingsmap' VALUES (1532, 6, 165, 1477);
INSERT INTO 'albumsrecordingsmap' VALUES (1533, 4, 126, 1489);
INSERT INTO 'albumsrecordingsmap' VALUES (1534, 7, 126, 1490);
INSERT INTO 'albumsrecordingsmap' VALUES (1535, 5, 126, 1491);
INSERT INTO 'albumsrecordingsmap' VALUES (1536, 2, 126, 1492);
INSERT INTO 'albumsrecordingsmap' VALUES (1537, 1, 126, 1493);
INSERT INTO 'albumsrecordingsmap' VALUES (1538, 3, 126, 1494);
INSERT INTO 'albumsrecordingsmap' VALUES (1539, 6, 126, 1495);
INSERT INTO 'albumsrecordingsmap' VALUES (1540, 1, 240, 1496);
INSERT INTO 'albumsrecordingsmap' VALUES (1541, 2, 240, 1497);
INSERT INTO 'albumsrecordingsmap' VALUES (1542, 3, 240, 1498);
INSERT INTO 'albumsrecordingsmap' VALUES (1543, 4, 240, 1499);
INSERT INTO 'albumsrecordingsmap' VALUES (1544, 5, 240, 1500);
INSERT INTO 'albumsrecordingsmap' VALUES (1545, 6, 240, 1501);
INSERT INTO 'albumsrecordingsmap' VALUES (1546, 7, 240, 1502);
INSERT INTO 'albumsrecordingsmap' VALUES (1547, 8, 240, 1503);
INSERT INTO 'albumsrecordingsmap' VALUES (1548, 9, 240, 1504);
INSERT INTO 'albumsrecordingsmap' VALUES (1549, 10, 240, 1505);
INSERT INTO 'albumsrecordingsmap' VALUES (1550, 11, 240, 1506);
INSERT INTO 'albumsrecordingsmap' VALUES (1551, 12, 240, 1507);
INSERT INTO 'albumsrecordingsmap' VALUES (1552, 13, 240, 1508);
INSERT INTO 'albumsrecordingsmap' VALUES (1553, 14, 240, 1509);
INSERT INTO 'albumsrecordingsmap' VALUES (1554, 8, 176, 1510);
INSERT INTO 'albumsrecordingsmap' VALUES (1555, 2, 176, 1511);
INSERT INTO 'albumsrecordingsmap' VALUES (1556, 10, 176, 1512);
INSERT INTO 'albumsrecordingsmap' VALUES (1557, 11, 176, 1513);
INSERT INTO 'albumsrecordingsmap' VALUES (1558, 12, 176, 1514);
INSERT INTO 'albumsrecordingsmap' VALUES (1559, 13, 176, 1515);
INSERT INTO 'albumsrecordingsmap' VALUES (1560, 14, 176, 1516);
INSERT INTO 'albumsrecordingsmap' VALUES (1561, 1, 176, 1517);
INSERT INTO 'albumsrecordingsmap' VALUES (1562, 9, 176, 1518);
INSERT INTO 'albumsrecordingsmap' VALUES (1563, 3, 176, 1519);
INSERT INTO 'albumsrecordingsmap' VALUES (1564, 4, 176, 1520);
INSERT INTO 'albumsrecordingsmap' VALUES (1565, 5, 176, 1521);
INSERT INTO 'albumsrecordingsmap' VALUES (1566, 6, 176, 1522);
INSERT INTO 'albumsrecordingsmap' VALUES (1567, 7, 176, 1523);
INSERT INTO 'albumsrecordingsmap' VALUES (1568, 4, 194, 1524);
INSERT INTO 'albumsrecordingsmap' VALUES (1569, 8, 194, 1525);
INSERT INTO 'albumsrecordingsmap' VALUES (1570, 5, 194, 1526);
INSERT INTO 'albumsrecordingsmap' VALUES (1571, 3, 194, 1527);
INSERT INTO 'albumsrecordingsmap' VALUES (1572, 1, 194, 1528);
INSERT INTO 'albumsrecordingsmap' VALUES (1573, 6, 194, 1529);
INSERT INTO 'albumsrecordingsmap' VALUES (1574, 2, 194, 1530);
INSERT INTO 'albumsrecordingsmap' VALUES (1575, 7, 194, 1531);
INSERT INTO 'albumsrecordingsmap' VALUES (1576, 5, 185, 1532);
INSERT INTO 'albumsrecordingsmap' VALUES (1577, 8, 185, 1533);
INSERT INTO 'albumsrecordingsmap' VALUES (1578, 2, 185, 1534);
INSERT INTO 'albumsrecordingsmap' VALUES (1579, 10, 185, 1535);
INSERT INTO 'albumsrecordingsmap' VALUES (1580, 1, 185, 1536);
INSERT INTO 'albumsrecordingsmap' VALUES (1581, 9, 185, 1537);
INSERT INTO 'albumsrecordingsmap' VALUES (1582, 6, 185, 1538);
INSERT INTO 'albumsrecordingsmap' VALUES (1583, 4, 185, 1539);
INSERT INTO 'albumsrecordingsmap' VALUES (1584, 3, 185, 1540);
INSERT INTO 'albumsrecordingsmap' VALUES (1585, 7, 185, 1541);
INSERT INTO 'albumsrecordingsmap' VALUES (1586, 2, 141, 1542);
INSERT INTO 'albumsrecordingsmap' VALUES (1587, 7, 141, 1543);
INSERT INTO 'albumsrecordingsmap' VALUES (1588, 4, 141, 1544);
INSERT INTO 'albumsrecordingsmap' VALUES (1589, 9, 141, 1545);
INSERT INTO 'albumsrecordingsmap' VALUES (1590, 1, 141, 1546);
INSERT INTO 'albumsrecordingsmap' VALUES (1591, 6, 141, 1547);
INSERT INTO 'albumsrecordingsmap' VALUES (1592, 10, 141, 1548);
INSERT INTO 'albumsrecordingsmap' VALUES (1593, 8, 141, 1549);
INSERT INTO 'albumsrecordingsmap' VALUES (1594, 3, 141, 1550);
INSERT INTO 'albumsrecordingsmap' VALUES (1595, 5, 141, 1551);
INSERT INTO 'albumsrecordingsmap' VALUES (1596, 1, 148, 1552);
INSERT INTO 'albumsrecordingsmap' VALUES (1597, 2, 148, 1553);
INSERT INTO 'albumsrecordingsmap' VALUES (1598, 3, 148, 1554);
INSERT INTO 'albumsrecordingsmap' VALUES (1599, 4, 148, 1555);
INSERT INTO 'albumsrecordingsmap' VALUES (1600, 5, 148, 1556);
INSERT INTO 'albumsrecordingsmap' VALUES (1601, 6, 148, 1557);
INSERT INTO 'albumsrecordingsmap' VALUES (1602, 7, 148, 1558);
INSERT INTO 'albumsrecordingsmap' VALUES (1603, 8, 148, 1559);
INSERT INTO 'albumsrecordingsmap' VALUES (1604, 9, 148, 1560);
INSERT INTO 'albumsrecordingsmap' VALUES (1605, 10, 148, 1561);
INSERT INTO 'albumsrecordingsmap' VALUES (1606, 11, 148, 1562);
INSERT INTO 'albumsrecordingsmap' VALUES (1607, 12, 148, 1563);
INSERT INTO 'albumsrecordingsmap' VALUES (1608, 13, 148, 1564);
INSERT INTO 'albumsrecordingsmap' VALUES (1609, 6, 246, 1565);
INSERT INTO 'albumsrecordingsmap' VALUES (1610, 5, 246, 1566);
INSERT INTO 'albumsrecordingsmap' VALUES (1611, 2, 246, 1567);
INSERT INTO 'albumsrecordingsmap' VALUES (1612, 11, 246, 1568);
INSERT INTO 'albumsrecordingsmap' VALUES (1613, 4, 246, 1569);
INSERT INTO 'albumsrecordingsmap' VALUES (1614, 7, 246, 1570);
INSERT INTO 'albumsrecordingsmap' VALUES (1615, 12, 246, 1571);
INSERT INTO 'albumsrecordingsmap' VALUES (1616, 10, 246, 1572);
INSERT INTO 'albumsrecordingsmap' VALUES (1617, 1, 246, 1573);
INSERT INTO 'albumsrecordingsmap' VALUES (1618, 13, 246, 1574);
INSERT INTO 'albumsrecordingsmap' VALUES (1619, 8, 246, 1575);
INSERT INTO 'albumsrecordingsmap' VALUES (1620, 9, 246, 1576);
INSERT INTO 'albumsrecordingsmap' VALUES (1621, 3, 246, 1577);
INSERT INTO 'albumsrecordingsmap' VALUES (1629, 5, 247, 1594);
INSERT INTO 'albumsrecordingsmap' VALUES (1630, 3, 247, 1595);
INSERT INTO 'albumsrecordingsmap' VALUES (1631, 9, 247, 1596);
INSERT INTO 'albumsrecordingsmap' VALUES (1632, 1, 247, 1598);
INSERT INTO 'albumsrecordingsmap' VALUES (1633, 7, 247, 1599);
INSERT INTO 'albumsrecordingsmap' VALUES (1634, 4, 247, 1600);
INSERT INTO 'albumsrecordingsmap' VALUES (1635, 8, 247, 1601);
INSERT INTO 'albumsrecordingsmap' VALUES (1636, 2, 247, 1602);
INSERT INTO 'albumsrecordingsmap' VALUES (1637, 1, 174, 1603);
INSERT INTO 'albumsrecordingsmap' VALUES (1638, 5, 202, 1488);
INSERT INTO 'albumsrecordingsmap' VALUES (1639, 3, 202, 1579);
INSERT INTO 'albumsrecordingsmap' VALUES (1640, 8, 202, 1580);
INSERT INTO 'albumsrecordingsmap' VALUES (1641, 7, 202, 1581);
INSERT INTO 'albumsrecordingsmap' VALUES (1642, 1, 202, 1582);
INSERT INTO 'albumsrecordingsmap' VALUES (1643, 4, 202, 1583);
INSERT INTO 'albumsrecordingsmap' VALUES (1644, 2, 202, 1584);
INSERT INTO 'albumsrecordingsmap' VALUES (1645, 6, 202, 1586);
INSERT INTO 'albumsrecordingsmap' VALUES (1646, 8, 179, 1604);
INSERT INTO 'albumsrecordingsmap' VALUES (1647, 2, 179, 1605);
INSERT INTO 'albumsrecordingsmap' VALUES (1648, 6, 179, 1606);
INSERT INTO 'albumsrecordingsmap' VALUES (1649, 4, 179, 1607);
INSERT INTO 'albumsrecordingsmap' VALUES (1650, 5, 179, 1608);
INSERT INTO 'albumsrecordingsmap' VALUES (1651, 1, 179, 1609);
INSERT INTO 'albumsrecordingsmap' VALUES (1652, 7, 179, 1610);
INSERT INTO 'albumsrecordingsmap' VALUES (1653, 3, 179, 1611);
INSERT INTO 'albumsrecordingsmap' VALUES (1665, 6, 136, 1623);
INSERT INTO 'albumsrecordingsmap' VALUES (1666, 8, 136, 1624);
INSERT INTO 'albumsrecordingsmap' VALUES (1667, 10, 136, 1625);
INSERT INTO 'albumsrecordingsmap' VALUES (1668, 5, 136, 1626);
INSERT INTO 'albumsrecordingsmap' VALUES (1669, 13, 136, 1627);
INSERT INTO 'albumsrecordingsmap' VALUES (1670, 11, 136, 1628);
INSERT INTO 'albumsrecordingsmap' VALUES (1671, 12, 136, 1629);
INSERT INTO 'albumsrecordingsmap' VALUES (1672, 1, 136, 1630);
INSERT INTO 'albumsrecordingsmap' VALUES (1673, 7, 136, 1631);
INSERT INTO 'albumsrecordingsmap' VALUES (1674, 3, 136, 1632);
INSERT INTO 'albumsrecordingsmap' VALUES (1675, 2, 136, 1633);
INSERT INTO 'albumsrecordingsmap' VALUES (1676, 9, 136, 1634);
INSERT INTO 'albumsrecordingsmap' VALUES (1677, 4, 136, 1635);
INSERT INTO 'albumsrecordingsmap' VALUES (1678, 1, 242, 1636);
INSERT INTO 'albumsrecordingsmap' VALUES (1679, 2, 242, 1637);
INSERT INTO 'albumsrecordingsmap' VALUES (1680, 3, 242, 1638);
INSERT INTO 'albumsrecordingsmap' VALUES (1681, 4, 242, 1639);
INSERT INTO 'albumsrecordingsmap' VALUES (1682, 5, 242, 1640);
INSERT INTO 'albumsrecordingsmap' VALUES (1683, 6, 242, 1641);
INSERT INTO 'albumsrecordingsmap' VALUES (1684, 7, 242, 1642);
INSERT INTO 'albumsrecordingsmap' VALUES (1685, 8, 242, 1643);
INSERT INTO 'albumsrecordingsmap' VALUES (1686, 9, 242, 1644);
INSERT INTO 'albumsrecordingsmap' VALUES (1687, 10, 242, 1645);
INSERT INTO 'albumsrecordingsmap' VALUES (1688, 1, 232, 1646);
INSERT INTO 'albumsrecordingsmap' VALUES (1689, 2, 232, 1647);
INSERT INTO 'albumsrecordingsmap' VALUES (1690, 3, 232, 1648);
INSERT INTO 'albumsrecordingsmap' VALUES (1691, 4, 232, 1649);
INSERT INTO 'albumsrecordingsmap' VALUES (1692, 5, 232, 1650);
INSERT INTO 'albumsrecordingsmap' VALUES (1693, 6, 232, 1651);
INSERT INTO 'albumsrecordingsmap' VALUES (1694, 7, 232, 1652);
INSERT INTO 'albumsrecordingsmap' VALUES (1695, 1, 200, 1653);
INSERT INTO 'albumsrecordingsmap' VALUES (1696, 2, 200, 1654);
INSERT INTO 'albumsrecordingsmap' VALUES (1697, 3, 200, 1655);
INSERT INTO 'albumsrecordingsmap' VALUES (1698, 4, 200, 1656);
INSERT INTO 'albumsrecordingsmap' VALUES (1699, 5, 200, 1657);
INSERT INTO 'albumsrecordingsmap' VALUES (1700, 6, 200, 1658);
INSERT INTO 'albumsrecordingsmap' VALUES (1701, 7, 200, 1659);
INSERT INTO 'albumsrecordingsmap' VALUES (1702, 8, 200, 1660);
INSERT INTO 'albumsrecordingsmap' VALUES (1703, 9, 200, 1661);
INSERT INTO 'albumsrecordingsmap' VALUES (1704, 10, 200, 1662);
INSERT INTO 'albumsrecordingsmap' VALUES (1705, 11, 200, 1663);
INSERT INTO 'albumsrecordingsmap' VALUES (1706, 12, 200, 1664);
INSERT INTO 'albumsrecordingsmap' VALUES (1707, 13, 200, 1665);
INSERT INTO 'albumsrecordingsmap' VALUES (1708, 14, 200, 1666);
INSERT INTO 'albumsrecordingsmap' VALUES (1709, 15, 200, 1667);
INSERT INTO 'albumsrecordingsmap' VALUES (1710, 3, 203, 1669);
INSERT INTO 'albumsrecordingsmap' VALUES (1718, 1, 171, 1677);
INSERT INTO 'albumsrecordingsmap' VALUES (1719, 2, 171, 1678);
INSERT INTO 'albumsrecordingsmap' VALUES (1720, 3, 171, 1679);
INSERT INTO 'albumsrecordingsmap' VALUES (1721, 4, 171, 1668);
INSERT INTO 'albumsrecordingsmap' VALUES (1722, 5, 171, 1680);
INSERT INTO 'albumsrecordingsmap' VALUES (1723, 6, 171, 1681);
INSERT INTO 'albumsrecordingsmap' VALUES (1724, 7, 171, 1682);
INSERT INTO 'albumsrecordingsmap' VALUES (1725, 8, 171, 1683);
INSERT INTO 'albumsrecordingsmap' VALUES (1726, 9, 171, 1684);
INSERT INTO 'albumsrecordingsmap' VALUES (1727, 10, 171, 1685);
INSERT INTO 'albumsrecordingsmap' VALUES (1728, 11, 171, 1686);
INSERT INTO 'albumsrecordingsmap' VALUES (1729, 12, 171, 1687);
INSERT INTO 'albumsrecordingsmap' VALUES (1730, 3, 182, 1688);
INSERT INTO 'albumsrecordingsmap' VALUES (1731, 6, 182, 1689);
INSERT INTO 'albumsrecordingsmap' VALUES (1732, 7, 182, 1690);
INSERT INTO 'albumsrecordingsmap' VALUES (1733, 1, 182, 1691);
INSERT INTO 'albumsrecordingsmap' VALUES (1734, 2, 182, 1692);
INSERT INTO 'albumsrecordingsmap' VALUES (1735, 5, 182, 1693);
INSERT INTO 'albumsrecordingsmap' VALUES (1736, 8, 182, 1694);
INSERT INTO 'albumsrecordingsmap' VALUES (1737, 4, 182, 1695);
INSERT INTO 'albumsrecordingsmap' VALUES (1738, 1, 236, 1696);
INSERT INTO 'albumsrecordingsmap' VALUES (1739, 2, 236, 1697);
INSERT INTO 'albumsrecordingsmap' VALUES (1740, 3, 236, 1698);
INSERT INTO 'albumsrecordingsmap' VALUES (1741, 4, 236, 1699);
INSERT INTO 'albumsrecordingsmap' VALUES (1742, 5, 236, 1700);
INSERT INTO 'albumsrecordingsmap' VALUES (1743, 6, 236, 1701);
INSERT INTO 'albumsrecordingsmap' VALUES (1744, 7, 236, 1702);
INSERT INTO 'albumsrecordingsmap' VALUES (1745, 8, 236, 1703);
INSERT INTO 'albumsrecordingsmap' VALUES (1746, 9, 236, 1704);
INSERT INTO 'albumsrecordingsmap' VALUES (1747, 10, 236, 1705);
INSERT INTO 'albumsrecordingsmap' VALUES (1748, 5, 170, 1717);
INSERT INTO 'albumsrecordingsmap' VALUES (1749, 2, 170, 1718);
INSERT INTO 'albumsrecordingsmap' VALUES (1750, 12, 170, 1719);
INSERT INTO 'albumsrecordingsmap' VALUES (1751, 4, 170, 1720);
INSERT INTO 'albumsrecordingsmap' VALUES (1752, 11, 170, 1721);
INSERT INTO 'albumsrecordingsmap' VALUES (1753, 1, 170, 1722);
INSERT INTO 'albumsrecordingsmap' VALUES (1754, 6, 170, 1723);
INSERT INTO 'albumsrecordingsmap' VALUES (1755, 9, 170, 1724);
INSERT INTO 'albumsrecordingsmap' VALUES (1756, 7, 170, 1725);
INSERT INTO 'albumsrecordingsmap' VALUES (1757, 10, 170, 1726);
INSERT INTO 'albumsrecordingsmap' VALUES (1758, 3, 170, 1727);
INSERT INTO 'albumsrecordingsmap' VALUES (1759, 7, 150, 1728);
INSERT INTO 'albumsrecordingsmap' VALUES (1760, 13, 150, 1729);
INSERT INTO 'albumsrecordingsmap' VALUES (1761, 14, 150, 1730);
INSERT INTO 'albumsrecordingsmap' VALUES (1762, 12, 150, 1731);
INSERT INTO 'albumsrecordingsmap' VALUES (1763, 6, 150, 1732);
INSERT INTO 'albumsrecordingsmap' VALUES (1764, 1, 150, 1733);
INSERT INTO 'albumsrecordingsmap' VALUES (1765, 3, 150, 1734);
INSERT INTO 'albumsrecordingsmap' VALUES (1766, 8, 150, 1735);
INSERT INTO 'albumsrecordingsmap' VALUES (1767, 5, 150, 1736);
INSERT INTO 'albumsrecordingsmap' VALUES (1768, 10, 150, 1737);
INSERT INTO 'albumsrecordingsmap' VALUES (1769, 11, 150, 1738);
INSERT INTO 'albumsrecordingsmap' VALUES (1770, 4, 150, 1739);
INSERT INTO 'albumsrecordingsmap' VALUES (1771, 9, 150, 1740);
INSERT INTO 'albumsrecordingsmap' VALUES (1772, 2, 150, 1741);
INSERT INTO 'albumsrecordingsmap' VALUES (1773, 6, 196, 1742);
INSERT INTO 'albumsrecordingsmap' VALUES (1774, 1, 196, 1743);
INSERT INTO 'albumsrecordingsmap' VALUES (1775, 3, 196, 1744);
INSERT INTO 'albumsrecordingsmap' VALUES (1776, 5, 196, 1745);
INSERT INTO 'albumsrecordingsmap' VALUES (1777, 8, 196, 1746);
INSERT INTO 'albumsrecordingsmap' VALUES (1778, 4, 196, 1747);
INSERT INTO 'albumsrecordingsmap' VALUES (1779, 7, 196, 1748);
INSERT INTO 'albumsrecordingsmap' VALUES (1780, 2, 196, 1749);
INSERT INTO 'albumsrecordingsmap' VALUES (1781, 12, 226, 1750);
INSERT INTO 'albumsrecordingsmap' VALUES (1782, 10, 226, 1751);
INSERT INTO 'albumsrecordingsmap' VALUES (1783, 6, 226, 1752);
INSERT INTO 'albumsrecordingsmap' VALUES (1784, 8, 226, 1753);
INSERT INTO 'albumsrecordingsmap' VALUES (1785, 3, 226, 1754);
INSERT INTO 'albumsrecordingsmap' VALUES (1786, 4, 226, 1755);
INSERT INTO 'albumsrecordingsmap' VALUES (1787, 2, 226, 1756);
INSERT INTO 'albumsrecordingsmap' VALUES (1788, 9, 226, 1757);
INSERT INTO 'albumsrecordingsmap' VALUES (1789, 11, 226, 1758);
INSERT INTO 'albumsrecordingsmap' VALUES (1790, 1, 226, 1759);
INSERT INTO 'albumsrecordingsmap' VALUES (1791, 5, 226, 1760);
INSERT INTO 'albumsrecordingsmap' VALUES (1792, 7, 226, 1761);
INSERT INTO 'albumsrecordingsmap' VALUES (1793, 2, 216, 1762);
INSERT INTO 'albumsrecordingsmap' VALUES (1794, 6, 216, 1763);
INSERT INTO 'albumsrecordingsmap' VALUES (1795, 8, 216, 1764);
INSERT INTO 'albumsrecordingsmap' VALUES (1796, 5, 216, 1765);
INSERT INTO 'albumsrecordingsmap' VALUES (1797, 1, 216, 1766);
INSERT INTO 'albumsrecordingsmap' VALUES (1798, 4, 216, 1767);
INSERT INTO 'albumsrecordingsmap' VALUES (1799, 7, 216, 1768);
INSERT INTO 'albumsrecordingsmap' VALUES (1800, 3, 216, 1769);
INSERT INTO 'albumsrecordingsmap' VALUES (1801, 1, 191, 1770);
INSERT INTO 'albumsrecordingsmap' VALUES (1802, 2, 191, 1771);
INSERT INTO 'albumsrecordingsmap' VALUES (1803, 13, 191, 1772);
INSERT INTO 'albumsrecordingsmap' VALUES (1804, 9, 191, 1773);
INSERT INTO 'albumsrecordingsmap' VALUES (1805, 8, 191, 1774);
INSERT INTO 'albumsrecordingsmap' VALUES (1806, 7, 191, 1775);
INSERT INTO 'albumsrecordingsmap' VALUES (1807, 6, 191, 1776);
INSERT INTO 'albumsrecordingsmap' VALUES (1808, 12, 191, 1777);
INSERT INTO 'albumsrecordingsmap' VALUES (1809, 3, 137, 1778);
INSERT INTO 'albumsrecordingsmap' VALUES (1810, 8, 137, 1779);
INSERT INTO 'albumsrecordingsmap' VALUES (1811, 6, 137, 1780);
INSERT INTO 'albumsrecordingsmap' VALUES (1812, 1, 137, 1781);
INSERT INTO 'albumsrecordingsmap' VALUES (1813, 5, 137, 1782);
INSERT INTO 'albumsrecordingsmap' VALUES (1814, 10, 137, 1783);
INSERT INTO 'albumsrecordingsmap' VALUES (1815, 2, 137, 1784);
INSERT INTO 'albumsrecordingsmap' VALUES (1816, 9, 137, 1785);
INSERT INTO 'albumsrecordingsmap' VALUES (1817, 7, 137, 1786);
INSERT INTO 'albumsrecordingsmap' VALUES (1818, 4, 137, 1787);
INSERT INTO 'albumsrecordingsmap' VALUES (1819, 5, 138, 1788);
INSERT INTO 'albumsrecordingsmap' VALUES (1820, 8, 138, 1789);
INSERT INTO 'albumsrecordingsmap' VALUES (1821, 4, 138, 1790);
INSERT INTO 'albumsrecordingsmap' VALUES (1822, 2, 138, 1791);
INSERT INTO 'albumsrecordingsmap' VALUES (1823, 6, 138, 1792);
INSERT INTO 'albumsrecordingsmap' VALUES (1824, 9, 138, 1793);
INSERT INTO 'albumsrecordingsmap' VALUES (1825, 7, 138, 1794);
INSERT INTO 'albumsrecordingsmap' VALUES (1826, 3, 138, 1795);
INSERT INTO 'albumsrecordingsmap' VALUES (1827, 8, 238, 1796);
INSERT INTO 'albumsrecordingsmap' VALUES (1828, 3, 238, 1797);
INSERT INTO 'albumsrecordingsmap' VALUES (1829, 5, 238, 1798);
INSERT INTO 'albumsrecordingsmap' VALUES (1830, 1, 238, 1799);
INSERT INTO 'albumsrecordingsmap' VALUES (1831, 6, 238, 1800);
INSERT INTO 'albumsrecordingsmap' VALUES (1832, 4, 238, 1801);
INSERT INTO 'albumsrecordingsmap' VALUES (1833, 9, 238, 1802);
INSERT INTO 'albumsrecordingsmap' VALUES (1834, 7, 238, 1803);
INSERT INTO 'albumsrecordingsmap' VALUES (1835, 2, 238, 1804);
INSERT INTO 'albumsrecordingsmap' VALUES (1844, 7, 230, 1813);
INSERT INTO 'albumsrecordingsmap' VALUES (1845, 2, 230, 1814);
INSERT INTO 'albumsrecordingsmap' VALUES (1846, 8, 230, 1815);
INSERT INTO 'albumsrecordingsmap' VALUES (1847, 3, 230, 1816);
INSERT INTO 'albumsrecordingsmap' VALUES (1848, 1, 230, 1817);
INSERT INTO 'albumsrecordingsmap' VALUES (1849, 10, 230, 1818);
INSERT INTO 'albumsrecordingsmap' VALUES (1850, 6, 230, 1819);
INSERT INTO 'albumsrecordingsmap' VALUES (1851, 5, 230, 1820);
INSERT INTO 'albumsrecordingsmap' VALUES (1852, 9, 230, 1821);
INSERT INTO 'albumsrecordingsmap' VALUES (1853, 4, 230, 1822);
INSERT INTO 'albumsrecordingsmap' VALUES (1854, 1, 192, 1823);
INSERT INTO 'albumsrecordingsmap' VALUES (1855, 2, 192, 1824);
INSERT INTO 'albumsrecordingsmap' VALUES (1856, 3, 192, 1825);
INSERT INTO 'albumsrecordingsmap' VALUES (1857, 4, 192, 1826);
INSERT INTO 'albumsrecordingsmap' VALUES (1858, 5, 192, 1827);
INSERT INTO 'albumsrecordingsmap' VALUES (1859, 6, 192, 1828);
INSERT INTO 'albumsrecordingsmap' VALUES (1860, 7, 192, 1829);
INSERT INTO 'albumsrecordingsmap' VALUES (1861, 8, 192, 1830);
INSERT INTO 'albumsrecordingsmap' VALUES (1862, 9, 192, 1831);
INSERT INTO 'albumsrecordingsmap' VALUES (1863, 10, 192, 1832);
INSERT INTO 'albumsrecordingsmap' VALUES (1864, 11, 192, 1833);
INSERT INTO 'albumsrecordingsmap' VALUES (1865, 12, 192, 1834);
INSERT INTO 'albumsrecordingsmap' VALUES (1866, 13, 192, 1835);
INSERT INTO 'albumsrecordingsmap' VALUES (1867, 14, 192, 1836);
INSERT INTO 'albumsrecordingsmap' VALUES (1868, 15, 192, 1837);
INSERT INTO 'albumsrecordingsmap' VALUES (1869, 7, 181, 1838);
INSERT INTO 'albumsrecordingsmap' VALUES (1870, 12, 181, 1839);
INSERT INTO 'albumsrecordingsmap' VALUES (1871, 11, 181, 1840);
INSERT INTO 'albumsrecordingsmap' VALUES (1872, 9, 181, 1841);
INSERT INTO 'albumsrecordingsmap' VALUES (1873, 1, 181, 1842);
INSERT INTO 'albumsrecordingsmap' VALUES (1874, 4, 181, 1843);
INSERT INTO 'albumsrecordingsmap' VALUES (1875, 6, 181, 1844);
INSERT INTO 'albumsrecordingsmap' VALUES (1876, 2, 181, 1845);
INSERT INTO 'albumsrecordingsmap' VALUES (1877, 5, 181, 1846);
INSERT INTO 'albumsrecordingsmap' VALUES (1878, 10, 181, 1847);
INSERT INTO 'albumsrecordingsmap' VALUES (1879, 3, 181, 1848);
INSERT INTO 'albumsrecordingsmap' VALUES (1880, 8, 181, 1849);
INSERT INTO 'albumsrecordingsmap' VALUES (1890, 5, 218, 1859);
INSERT INTO 'albumsrecordingsmap' VALUES (1891, 2, 218, 1860);
INSERT INTO 'albumsrecordingsmap' VALUES (1892, 8, 218, 1861);
INSERT INTO 'albumsrecordingsmap' VALUES (1893, 6, 218, 1862);
INSERT INTO 'albumsrecordingsmap' VALUES (1894, 4, 218, 1863);
INSERT INTO 'albumsrecordingsmap' VALUES (1895, 1, 218, 1864);
INSERT INTO 'albumsrecordingsmap' VALUES (1896, 3, 218, 1865);
INSERT INTO 'albumsrecordingsmap' VALUES (1897, 7, 218, 1866);
INSERT INTO 'albumsrecordingsmap' VALUES (1898, 5, 139, 1867);
INSERT INTO 'albumsrecordingsmap' VALUES (1899, 1, 139, 1868);
INSERT INTO 'albumsrecordingsmap' VALUES (1900, 4, 139, 1869);
INSERT INTO 'albumsrecordingsmap' VALUES (1901, 10, 139, 1870);
INSERT INTO 'albumsrecordingsmap' VALUES (1902, 6, 139, 1871);
INSERT INTO 'albumsrecordingsmap' VALUES (1903, 3, 139, 1872);
INSERT INTO 'albumsrecordingsmap' VALUES (1904, 2, 139, 1873);
INSERT INTO 'albumsrecordingsmap' VALUES (1905, 9, 139, 1874);
INSERT INTO 'albumsrecordingsmap' VALUES (1906, 7, 139, 1875);
INSERT INTO 'albumsrecordingsmap' VALUES (1907, 8, 139, 1876);
INSERT INTO 'albumsrecordingsmap' VALUES (1908, 1, 138, 1877);
INSERT INTO 'albumsrecordingsmap' VALUES (1909, 7, 220, 1878);
INSERT INTO 'albumsrecordingsmap' VALUES (1910, 2, 220, 1879);
INSERT INTO 'albumsrecordingsmap' VALUES (1911, 1, 220, 1880);
INSERT INTO 'albumsrecordingsmap' VALUES (1912, 9, 220, 1881);
INSERT INTO 'albumsrecordingsmap' VALUES (1913, 4, 220, 1882);
INSERT INTO 'albumsrecordingsmap' VALUES (1914, 6, 220, 1883);
INSERT INTO 'albumsrecordingsmap' VALUES (1915, 3, 220, 1884);
INSERT INTO 'albumsrecordingsmap' VALUES (1916, 8, 220, 1885);
INSERT INTO 'albumsrecordingsmap' VALUES (1917, 5, 220, 1886);
INSERT INTO 'albumsrecordingsmap' VALUES (1918, 6, 223, 1887);
INSERT INTO 'albumsrecordingsmap' VALUES (1919, 1, 223, 1888);
INSERT INTO 'albumsrecordingsmap' VALUES (1920, 5, 223, 1889);
INSERT INTO 'albumsrecordingsmap' VALUES (1921, 8, 223, 1890);
INSERT INTO 'albumsrecordingsmap' VALUES (1922, 4, 223, 1891);
INSERT INTO 'albumsrecordingsmap' VALUES (1923, 2, 223, 1892);
INSERT INTO 'albumsrecordingsmap' VALUES (1924, 7, 223, 1893);
INSERT INTO 'albumsrecordingsmap' VALUES (1925, 3, 223, 1894);
INSERT INTO 'albumsrecordingsmap' VALUES (1926, 7, 205, 1895);
INSERT INTO 'albumsrecordingsmap' VALUES (1927, 6, 205, 1896);
INSERT INTO 'albumsrecordingsmap' VALUES (1928, 10, 205, 1897);
INSERT INTO 'albumsrecordingsmap' VALUES (1929, 13, 205, 1898);
INSERT INTO 'albumsrecordingsmap' VALUES (1930, 1, 205, 1899);
INSERT INTO 'albumsrecordingsmap' VALUES (1931, 9, 205, 1900);
INSERT INTO 'albumsrecordingsmap' VALUES (1932, 4, 205, 1901);
INSERT INTO 'albumsrecordingsmap' VALUES (1933, 12, 205, 1902);
INSERT INTO 'albumsrecordingsmap' VALUES (1934, 14, 205, 1903);
INSERT INTO 'albumsrecordingsmap' VALUES (1935, 8, 205, 1904);
INSERT INTO 'albumsrecordingsmap' VALUES (1936, 2, 205, 1905);
INSERT INTO 'albumsrecordingsmap' VALUES (1937, 5, 205, 1906);
INSERT INTO 'albumsrecordingsmap' VALUES (1938, 3, 205, 1907);
INSERT INTO 'albumsrecordingsmap' VALUES (1939, 11, 205, 1908);
INSERT INTO 'albumsrecordingsmap' VALUES (1940, 1, 128, 1909);
INSERT INTO 'albumsrecordingsmap' VALUES (1941, 2, 128, 1910);
INSERT INTO 'albumsrecordingsmap' VALUES (1942, 3, 128, 1911);
INSERT INTO 'albumsrecordingsmap' VALUES (1943, 4, 128, 1912);
INSERT INTO 'albumsrecordingsmap' VALUES (1944, 5, 128, 1913);
INSERT INTO 'albumsrecordingsmap' VALUES (1945, 6, 128, 1914);
INSERT INTO 'albumsrecordingsmap' VALUES (1946, 7, 128, 1915);
INSERT INTO 'albumsrecordingsmap' VALUES (1947, 8, 128, 1916);
INSERT INTO 'albumsrecordingsmap' VALUES (1948, 9, 128, 1917);
INSERT INTO 'albumsrecordingsmap' VALUES (1949, 10, 128, 1918);
INSERT INTO 'albumsrecordingsmap' VALUES (1950, 11, 128, 1919);
INSERT INTO 'albumsrecordingsmap' VALUES (1951, 12, 128, 1920);
INSERT INTO 'albumsrecordingsmap' VALUES (1952, 13, 128, 1921);
INSERT INTO 'albumsrecordingsmap' VALUES (1953, 6, 197, 1922);
INSERT INTO 'albumsrecordingsmap' VALUES (1954, 7, 197, 1923);
INSERT INTO 'albumsrecordingsmap' VALUES (1955, 9, 197, 1924);
INSERT INTO 'albumsrecordingsmap' VALUES (1956, 4, 197, 1925);
INSERT INTO 'albumsrecordingsmap' VALUES (1957, 1, 197, 1926);
INSERT INTO 'albumsrecordingsmap' VALUES (1958, 11, 197, 1927);
INSERT INTO 'albumsrecordingsmap' VALUES (1959, 2, 197, 1928);
INSERT INTO 'albumsrecordingsmap' VALUES (1960, 8, 197, 1929);
INSERT INTO 'albumsrecordingsmap' VALUES (1961, 13, 197, 1930);
INSERT INTO 'albumsrecordingsmap' VALUES (1962, 12, 197, 1931);
INSERT INTO 'albumsrecordingsmap' VALUES (1963, 5, 197, 1933);
INSERT INTO 'albumsrecordingsmap' VALUES (1964, 3, 197, 1934);
INSERT INTO 'albumsrecordingsmap' VALUES (1881, 1, 167, 1850);
INSERT INTO 'albumsrecordingsmap' VALUES (1882, 2, 167, 1851);
INSERT INTO 'albumsrecordingsmap' VALUES (1883, 3, 167, 1852);
INSERT INTO 'albumsrecordingsmap' VALUES (1884, 4, 167, 1853);
INSERT INTO 'albumsrecordingsmap' VALUES (1885, 5, 167, 1854);
INSERT INTO 'albumsrecordingsmap' VALUES (1886, 6, 167, 1855);
INSERT INTO 'albumsrecordingsmap' VALUES (1887, 7, 167, 1856);
INSERT INTO 'albumsrecordingsmap' VALUES (1965, 10, 197, 1935);
INSERT INTO 'albumsrecordingsmap' VALUES (1966, 4, 129, 1936);
INSERT INTO 'albumsrecordingsmap' VALUES (1967, 6, 129, 1937);
INSERT INTO 'albumsrecordingsmap' VALUES (1968, 2, 129, 1938);
INSERT INTO 'albumsrecordingsmap' VALUES (1969, 10, 129, 1939);
INSERT INTO 'albumsrecordingsmap' VALUES (1970, 13, 129, 1940);
INSERT INTO 'albumsrecordingsmap' VALUES (1971, 1, 129, 1941);
INSERT INTO 'albumsrecordingsmap' VALUES (1972, 3, 129, 1942);
INSERT INTO 'albumsrecordingsmap' VALUES (1973, 8, 129, 1943);
INSERT INTO 'albumsrecordingsmap' VALUES (1974, 14, 129, 1944);
INSERT INTO 'albumsrecordingsmap' VALUES (1975, 7, 129, 1945);
INSERT INTO 'albumsrecordingsmap' VALUES (1976, 5, 129, 1946);
INSERT INTO 'albumsrecordingsmap' VALUES (1977, 9, 129, 1947);
INSERT INTO 'albumsrecordingsmap' VALUES (1978, 5, 158, 1948);
INSERT INTO 'albumsrecordingsmap' VALUES (1979, 2, 158, 1949);
INSERT INTO 'albumsrecordingsmap' VALUES (1980, 4, 158, 1950);
INSERT INTO 'albumsrecordingsmap' VALUES (1981, 1, 158, 1951);
INSERT INTO 'albumsrecordingsmap' VALUES (1982, 6, 158, 1952);
INSERT INTO 'albumsrecordingsmap' VALUES (1983, 3, 158, 1953);
INSERT INTO 'albumsrecordingsmap' VALUES (1984, 15, 225, 1954);
INSERT INTO 'albumsrecordingsmap' VALUES (1985, 10, 225, 1955);
INSERT INTO 'albumsrecordingsmap' VALUES (1986, 6, 225, 1957);
INSERT INTO 'albumsrecordingsmap' VALUES (1987, 2, 225, 1959);
INSERT INTO 'albumsrecordingsmap' VALUES (1988, 9, 225, 1960);
INSERT INTO 'albumsrecordingsmap' VALUES (1989, 13, 225, 1962);
INSERT INTO 'albumsrecordingsmap' VALUES (1990, 11, 225, 1963);
INSERT INTO 'albumsrecordingsmap' VALUES (1991, 1, 225, 1965);
INSERT INTO 'albumsrecordingsmap' VALUES (1992, 8, 225, 1966);
INSERT INTO 'albumsrecordingsmap' VALUES (1993, 1, 132, 1969);
INSERT INTO 'albumsrecordingsmap' VALUES (1994, 2, 132, 1970);
INSERT INTO 'albumsrecordingsmap' VALUES (1995, 3, 132, 1971);
INSERT INTO 'albumsrecordingsmap' VALUES (1996, 4, 132, 1972);
INSERT INTO 'albumsrecordingsmap' VALUES (1997, 5, 132, 1973);
INSERT INTO 'albumsrecordingsmap' VALUES (1998, 6, 132, 1974);
INSERT INTO 'albumsrecordingsmap' VALUES (1999, 7, 132, 1975);
INSERT INTO 'albumsrecordingsmap' VALUES (2000, 8, 132, 1976);
INSERT INTO 'albumsrecordingsmap' VALUES (2001, 9, 132, 1977);
INSERT INTO 'albumsrecordingsmap' VALUES (2002, 10, 132, 1978);
INSERT INTO 'albumsrecordingsmap' VALUES (2003, 11, 132, 1979);
INSERT INTO 'albumsrecordingsmap' VALUES (2004, 12, 132, 1980);
INSERT INTO 'albumsrecordingsmap' VALUES (2005, 13, 132, 1981);
INSERT INTO 'albumsrecordingsmap' VALUES (2006, 14, 132, 1982);
INSERT INTO 'albumsrecordingsmap' VALUES (2007, 1, 127, 1983);
INSERT INTO 'albumsrecordingsmap' VALUES (2008, 2, 127, 1984);
INSERT INTO 'albumsrecordingsmap' VALUES (2009, 3, 127, 1985);
INSERT INTO 'albumsrecordingsmap' VALUES (2010, 4, 127, 1986);
INSERT INTO 'albumsrecordingsmap' VALUES (2011, 5, 127, 1987);
INSERT INTO 'albumsrecordingsmap' VALUES (2012, 8, 127, 1988);
INSERT INTO 'albumsrecordingsmap' VALUES (2013, 9, 127, 1989);
INSERT INTO 'albumsrecordingsmap' VALUES (2014, 6, 127, 1990);
INSERT INTO 'albumsrecordingsmap' VALUES (2015, 10, 127, 1991);
INSERT INTO 'albumsrecordingsmap' VALUES (2016, 11, 127, 1992);
INSERT INTO 'albumsrecordingsmap' VALUES (2017, 12, 127, 1993);
INSERT INTO 'albumsrecordingsmap' VALUES (2018, 3, 153, 1994);
INSERT INTO 'albumsrecordingsmap' VALUES (2019, 7, 153, 1995);
INSERT INTO 'albumsrecordingsmap' VALUES (2020, 5, 153, 1996);
INSERT INTO 'albumsrecordingsmap' VALUES (2021, 9, 153, 1997);
INSERT INTO 'albumsrecordingsmap' VALUES (2022, 1, 153, 1998);
INSERT INTO 'albumsrecordingsmap' VALUES (2023, 8, 153, 1999);
INSERT INTO 'albumsrecordingsmap' VALUES (2024, 4, 153, 2000);
INSERT INTO 'albumsrecordingsmap' VALUES (2025, 6, 153, 2001);
INSERT INTO 'albumsrecordingsmap' VALUES (2026, 10, 153, 2002);
INSERT INTO 'albumsrecordingsmap' VALUES (2027, 2, 153, 2003);
INSERT INTO 'albumsrecordingsmap' VALUES (2028, 1, 212, 2004);
INSERT INTO 'albumsrecordingsmap' VALUES (2029, 9, 212, 2005);
INSERT INTO 'albumsrecordingsmap' VALUES (2030, 7, 212, 2006);
INSERT INTO 'albumsrecordingsmap' VALUES (2031, 12, 212, 2007);
INSERT INTO 'albumsrecordingsmap' VALUES (2032, 3, 212, 2008);
INSERT INTO 'albumsrecordingsmap' VALUES (2033, 4, 212, 2009);
INSERT INTO 'albumsrecordingsmap' VALUES (2034, 10, 212, 2010);
INSERT INTO 'albumsrecordingsmap' VALUES (2035, 11, 212, 2011);
INSERT INTO 'albumsrecordingsmap' VALUES (2036, 6, 212, 2012);
INSERT INTO 'albumsrecordingsmap' VALUES (2037, 2, 212, 2013);
INSERT INTO 'albumsrecordingsmap' VALUES (2038, 8, 212, 2014);
INSERT INTO 'albumsrecordingsmap' VALUES (2039, 5, 212, 2015);
INSERT INTO 'albumsrecordingsmap' VALUES (2040, 12, 183, 2016);
INSERT INTO 'albumsrecordingsmap' VALUES (2041, 4, 183, 2017);
INSERT INTO 'albumsrecordingsmap' VALUES (2042, 14, 183, 2018);
INSERT INTO 'albumsrecordingsmap' VALUES (2043, 2, 183, 2019);
INSERT INTO 'albumsrecordingsmap' VALUES (2044, 8, 183, 2020);
INSERT INTO 'albumsrecordingsmap' VALUES (2045, 3, 183, 2021);
INSERT INTO 'albumsrecordingsmap' VALUES (2046, 9, 183, 2022);
INSERT INTO 'albumsrecordingsmap' VALUES (2047, 11, 183, 2023);
INSERT INTO 'albumsrecordingsmap' VALUES (2048, 5, 183, 2024);
INSERT INTO 'albumsrecordingsmap' VALUES (2049, 1, 183, 2025);
INSERT INTO 'albumsrecordingsmap' VALUES (2050, 13, 183, 2026);
INSERT INTO 'albumsrecordingsmap' VALUES (2051, 6, 183, 2027);
INSERT INTO 'albumsrecordingsmap' VALUES (2052, 7, 183, 2028);
INSERT INTO 'albumsrecordingsmap' VALUES (2053, 1, 193, 2030);
INSERT INTO 'albumsrecordingsmap' VALUES (2054, 2, 193, 2031);
INSERT INTO 'albumsrecordingsmap' VALUES (2055, 3, 193, 2032);
INSERT INTO 'albumsrecordingsmap' VALUES (2056, 4, 193, 2033);
INSERT INTO 'albumsrecordingsmap' VALUES (2057, 6, 193, 2035);
INSERT INTO 'albumsrecordingsmap' VALUES (2058, 7, 193, 2036);
INSERT INTO 'albumsrecordingsmap' VALUES (2059, 9, 193, 2039);
INSERT INTO 'albumsrecordingsmap' VALUES (2060, 10, 193, 2040);
INSERT INTO 'albumsrecordingsmap' VALUES (2061, 12, 193, 2042);
INSERT INTO 'albumsrecordingsmap' VALUES (2062, 3, 143, 2043);
INSERT INTO 'albumsrecordingsmap' VALUES (2063, 10, 143, 2044);
INSERT INTO 'albumsrecordingsmap' VALUES (2064, 7, 143, 2045);
INSERT INTO 'albumsrecordingsmap' VALUES (2065, 6, 143, 2046);
INSERT INTO 'albumsrecordingsmap' VALUES (2066, 9, 143, 2047);
INSERT INTO 'albumsrecordingsmap' VALUES (2067, 1, 143, 2048);
INSERT INTO 'albumsrecordingsmap' VALUES (2068, 5, 143, 2049);
INSERT INTO 'albumsrecordingsmap' VALUES (2069, 4, 143, 2050);
INSERT INTO 'albumsrecordingsmap' VALUES (2070, 2, 143, 2051);
INSERT INTO 'albumsrecordingsmap' VALUES (2071, 8, 143, 2052);
INSERT INTO 'albumsrecordingsmap' VALUES (2072, 1, 87, 2053);
INSERT INTO 'albumsrecordingsmap' VALUES (2073, 2, 87, 2054);
INSERT INTO 'albumsrecordingsmap' VALUES (2074, 3, 87, 2055);
INSERT INTO 'albumsrecordingsmap' VALUES (2075, 1, 189, 2056);
INSERT INTO 'albumsrecordingsmap' VALUES (2076, 2, 189, 2057);
INSERT INTO 'albumsrecordingsmap' VALUES (2077, 3, 189, 2058);
INSERT INTO 'albumsrecordingsmap' VALUES (2078, 4, 189, 2059);
INSERT INTO 'albumsrecordingsmap' VALUES (2079, 5, 189, 2060);
INSERT INTO 'albumsrecordingsmap' VALUES (2080, 6, 189, 2061);
INSERT INTO 'albumsrecordingsmap' VALUES (2081, 7, 189, 2062);
INSERT INTO 'albumsrecordingsmap' VALUES (2082, 8, 189, 2063);
INSERT INTO 'albumsrecordingsmap' VALUES (2083, 9, 189, 2064);
INSERT INTO 'albumsrecordingsmap' VALUES (2084, 10, 189, 2065);
INSERT INTO 'albumsrecordingsmap' VALUES (2085, 11, 189, 2066);
INSERT INTO 'albumsrecordingsmap' VALUES (2086, 13, 189, 2067);
INSERT INTO 'albumsrecordingsmap' VALUES (2087, 14, 189, 2068);
INSERT INTO 'albumsrecordingsmap' VALUES (2088, 15, 189, 2069);
INSERT INTO 'albumsrecordingsmap' VALUES (2089, 16, 189, 2070);
INSERT INTO 'albumsrecordingsmap' VALUES (2090, 17, 189, 2071);
INSERT INTO 'albumsrecordingsmap' VALUES (2091, 18, 189, 2072);
INSERT INTO 'albumsrecordingsmap' VALUES (2092, 3, 210, 2073);
INSERT INTO 'albumsrecordingsmap' VALUES (2093, 10, 210, 2074);
INSERT INTO 'albumsrecordingsmap' VALUES (2094, 9, 210, 2075);
INSERT INTO 'albumsrecordingsmap' VALUES (2095, 1, 210, 2076);
INSERT INTO 'albumsrecordingsmap' VALUES (2096, 6, 210, 2077);
INSERT INTO 'albumsrecordingsmap' VALUES (2097, 5, 210, 2078);
INSERT INTO 'albumsrecordingsmap' VALUES (2098, 12, 210, 2079);
INSERT INTO 'albumsrecordingsmap' VALUES (2099, 7, 210, 2080);
INSERT INTO 'albumsrecordingsmap' VALUES (2100, 11, 210, 2081);
INSERT INTO 'albumsrecordingsmap' VALUES (2101, 2, 210, 2082);
INSERT INTO 'albumsrecordingsmap' VALUES (2102, 4, 210, 2083);
INSERT INTO 'albumsrecordingsmap' VALUES (2103, 7, 221, 2084);
INSERT INTO 'albumsrecordingsmap' VALUES (2104, 2, 221, 2085);
INSERT INTO 'albumsrecordingsmap' VALUES (2105, 8, 221, 2086);
INSERT INTO 'albumsrecordingsmap' VALUES (2106, 1, 221, 2087);
INSERT INTO 'albumsrecordingsmap' VALUES (2107, 5, 221, 2088);
INSERT INTO 'albumsrecordingsmap' VALUES (2108, 4, 221, 2089);
INSERT INTO 'albumsrecordingsmap' VALUES (2109, 3, 221, 2090);
INSERT INTO 'albumsrecordingsmap' VALUES (2110, 6, 221, 2091);
INSERT INTO 'albumsrecordingsmap' VALUES (2111, 1, 239, 2092);
INSERT INTO 'albumsrecordingsmap' VALUES (2112, 2, 239, 2093);
INSERT INTO 'albumsrecordingsmap' VALUES (2113, 3, 239, 2094);
INSERT INTO 'albumsrecordingsmap' VALUES (2114, 4, 239, 2095);
INSERT INTO 'albumsrecordingsmap' VALUES (2115, 5, 239, 2096);
INSERT INTO 'albumsrecordingsmap' VALUES (2116, 6, 239, 2097);
INSERT INTO 'albumsrecordingsmap' VALUES (2117, 7, 239, 2098);
INSERT INTO 'albumsrecordingsmap' VALUES (2118, 8, 239, 2099);
INSERT INTO 'albumsrecordingsmap' VALUES (2119, 9, 239, 2100);
INSERT INTO 'albumsrecordingsmap' VALUES (2120, 10, 239, 2101);
INSERT INTO 'albumsrecordingsmap' VALUES (2121, 11, 239, 2102);
INSERT INTO 'albumsrecordingsmap' VALUES (2122, 12, 239, 2103);
INSERT INTO 'albumsrecordingsmap' VALUES (2123, 13, 239, 2104);
INSERT INTO 'albumsrecordingsmap' VALUES (2124, 14, 239, 2105);
INSERT INTO 'albumsrecordingsmap' VALUES (2125, 15, 239, 2106);
INSERT INTO 'albumsrecordingsmap' VALUES (2126, 10, 243, 2107);
INSERT INTO 'albumsrecordingsmap' VALUES (2127, 7, 243, 2108);
INSERT INTO 'albumsrecordingsmap' VALUES (2128, 5, 243, 2109);
INSERT INTO 'albumsrecordingsmap' VALUES (2129, 8, 243, 2110);
INSERT INTO 'albumsrecordingsmap' VALUES (2130, 11, 243, 2111);
INSERT INTO 'albumsrecordingsmap' VALUES (2131, 9, 243, 2112);
INSERT INTO 'albumsrecordingsmap' VALUES (2132, 1, 243, 2113);
INSERT INTO 'albumsrecordingsmap' VALUES (2133, 12, 243, 2114);
INSERT INTO 'albumsrecordingsmap' VALUES (2134, 3, 243, 2115);
INSERT INTO 'albumsrecordingsmap' VALUES (2135, 14, 243, 2116);
INSERT INTO 'albumsrecordingsmap' VALUES (2136, 6, 243, 2117);
INSERT INTO 'albumsrecordingsmap' VALUES (2137, 2, 243, 2118);
INSERT INTO 'albumsrecordingsmap' VALUES (2138, 13, 243, 2119);
INSERT INTO 'albumsrecordingsmap' VALUES (2139, 4, 243, 2120);
INSERT INTO 'albumsrecordingsmap' VALUES (2140, 1, 190, 2121);
INSERT INTO 'albumsrecordingsmap' VALUES (2141, 2, 190, 2122);
INSERT INTO 'albumsrecordingsmap' VALUES (2142, 3, 190, 2123);
INSERT INTO 'albumsrecordingsmap' VALUES (2143, 4, 190, 2124);
INSERT INTO 'albumsrecordingsmap' VALUES (2144, 5, 190, 2125);
INSERT INTO 'albumsrecordingsmap' VALUES (2145, 6, 190, 2126);
INSERT INTO 'albumsrecordingsmap' VALUES (2146, 7, 190, 2127);
INSERT INTO 'albumsrecordingsmap' VALUES (2147, 8, 190, 2128);
INSERT INTO 'albumsrecordingsmap' VALUES (2148, 9, 190, 2129);
INSERT INTO 'albumsrecordingsmap' VALUES (2149, 10, 190, 2130);
INSERT INTO 'albumsrecordingsmap' VALUES (2150, 11, 190, 2131);
INSERT INTO 'albumsrecordingsmap' VALUES (2151, 12, 190, 2132);
INSERT INTO 'albumsrecordingsmap' VALUES (2152, 13, 190, 2133);
INSERT INTO 'albumsrecordingsmap' VALUES (2153, 14, 190, 2134);
INSERT INTO 'albumsrecordingsmap' VALUES (2154, 1, 228, 2135);
INSERT INTO 'albumsrecordingsmap' VALUES (2155, 2, 228, 2136);
INSERT INTO 'albumsrecordingsmap' VALUES (2156, 3, 228, 2137);
INSERT INTO 'albumsrecordingsmap' VALUES (2157, 4, 228, 2138);
INSERT INTO 'albumsrecordingsmap' VALUES (2158, 5, 228, 2139);
INSERT INTO 'albumsrecordingsmap' VALUES (2159, 6, 228, 2140);
INSERT INTO 'albumsrecordingsmap' VALUES (2160, 7, 228, 2141);
INSERT INTO 'albumsrecordingsmap' VALUES (2161, 8, 228, 2142);
INSERT INTO 'albumsrecordingsmap' VALUES (2162, 9, 228, 2143);
INSERT INTO 'albumsrecordingsmap' VALUES (2163, 10, 228, 2144);
INSERT INTO 'albumsrecordingsmap' VALUES (2164, 11, 228, 2145);
INSERT INTO 'albumsrecordingsmap' VALUES (2165, 12, 228, 2146);
INSERT INTO 'albumsrecordingsmap' VALUES (2166, 13, 228, 2147);
INSERT INTO 'albumsrecordingsmap' VALUES (2167, 14, 228, 2148);
INSERT INTO 'albumsrecordingsmap' VALUES (2168, 8, 201, 73);
INSERT INTO 'albumsrecordingsmap' VALUES (2169, 10, 201, 100);
INSERT INTO 'albumsrecordingsmap' VALUES (2170, 9, 201, 153);
INSERT INTO 'albumsrecordingsmap' VALUES (2171, 11, 201, 163);
INSERT INTO 'albumsrecordingsmap' VALUES (2172, 3, 201, 343);
INSERT INTO 'albumsrecordingsmap' VALUES (2173, 1, 201, 94);
INSERT INTO 'albumsrecordingsmap' VALUES (2174, 7, 201, 129);
INSERT INTO 'albumsrecordingsmap' VALUES (2175, 5, 201, 134);
INSERT INTO 'albumsrecordingsmap' VALUES (2176, 4, 201, 1117);
INSERT INTO 'albumsrecordingsmap' VALUES (2177, 6, 130, 2151);
INSERT INTO 'albumsrecordingsmap' VALUES (2178, 2, 130, 2152);
INSERT INTO 'albumsrecordingsmap' VALUES (2179, 9, 130, 2153);
INSERT INTO 'albumsrecordingsmap' VALUES (2180, 8, 130, 2154);
INSERT INTO 'albumsrecordingsmap' VALUES (2181, 3, 130, 2155);
INSERT INTO 'albumsrecordingsmap' VALUES (2182, 11, 130, 2156);
INSERT INTO 'albumsrecordingsmap' VALUES (2183, 1, 130, 2157);
INSERT INTO 'albumsrecordingsmap' VALUES (2184, 5, 130, 2158);
INSERT INTO 'albumsrecordingsmap' VALUES (2185, 4, 130, 2159);
INSERT INTO 'albumsrecordingsmap' VALUES (2186, 7, 130, 2160);
INSERT INTO 'albumsrecordingsmap' VALUES (2187, 10, 130, 2161);
INSERT INTO 'albumsrecordingsmap' VALUES (2188, 1, 152, 2162);
INSERT INTO 'albumsrecordingsmap' VALUES (2189, 2, 152, 2163);
INSERT INTO 'albumsrecordingsmap' VALUES (2190, 3, 152, 2164);
INSERT INTO 'albumsrecordingsmap' VALUES (2191, 4, 152, 2165);
INSERT INTO 'albumsrecordingsmap' VALUES (2192, 5, 152, 2166);
INSERT INTO 'albumsrecordingsmap' VALUES (2193, 6, 152, 2167);
INSERT INTO 'albumsrecordingsmap' VALUES (2194, 9, 152, 2169);
INSERT INTO 'albumsrecordingsmap' VALUES (2196, 11, 152, 2171);
INSERT INTO 'albumsrecordingsmap' VALUES (2197, 1, 173, 2172);
INSERT INTO 'albumsrecordingsmap' VALUES (2198, 2, 173, 2173);
INSERT INTO 'albumsrecordingsmap' VALUES (2199, 3, 173, 2174);
INSERT INTO 'albumsrecordingsmap' VALUES (2200, 4, 173, 2175);
INSERT INTO 'albumsrecordingsmap' VALUES (2201, 5, 173, 2176);
INSERT INTO 'albumsrecordingsmap' VALUES (2202, 6, 173, 2177);
INSERT INTO 'albumsrecordingsmap' VALUES (2203, 7, 173, 2178);
INSERT INTO 'albumsrecordingsmap' VALUES (2204, 8, 173, 2179);
INSERT INTO 'albumsrecordingsmap' VALUES (2205, 9, 173, 2180);
INSERT INTO 'albumsrecordingsmap' VALUES (2206, 10, 173, 2181);
INSERT INTO 'albumsrecordingsmap' VALUES (2207, 11, 173, 2182);
INSERT INTO 'albumsrecordingsmap' VALUES (2208, 12, 173, 2183);
INSERT INTO 'albumsrecordingsmap' VALUES (2209, 13, 173, 2184);
INSERT INTO 'albumsrecordingsmap' VALUES (2210, 14, 173, 2185);
INSERT INTO 'albumsrecordingsmap' VALUES (2211, 15, 173, 2186);
INSERT INTO 'albumsrecordingsmap' VALUES (2212, 6, 829, 2187);
INSERT INTO 'albumsrecordingsmap' VALUES (2213, 2, 829, 2188);
INSERT INTO 'albumsrecordingsmap' VALUES (2214, 9, 829, 2189);
INSERT INTO 'albumsrecordingsmap' VALUES (2215, 8, 829, 2190);
INSERT INTO 'albumsrecordingsmap' VALUES (2216, 5, 829, 2191);
INSERT INTO 'albumsrecordingsmap' VALUES (2217, 1, 829, 2192);
INSERT INTO 'albumsrecordingsmap' VALUES (2218, 4, 829, 2193);
INSERT INTO 'albumsrecordingsmap' VALUES (2219, 7, 829, 2194);
INSERT INTO 'albumsrecordingsmap' VALUES (2220, 3, 829, 2195);
INSERT INTO 'albumsrecordingsmap' VALUES (2221, 1, 219, 2196);
INSERT INTO 'albumsrecordingsmap' VALUES (2222, 2, 219, 2197);
INSERT INTO 'albumsrecordingsmap' VALUES (2223, 3, 219, 2198);
INSERT INTO 'albumsrecordingsmap' VALUES (2224, 4, 219, 2199);
INSERT INTO 'albumsrecordingsmap' VALUES (2225, 5, 219, 2200);
INSERT INTO 'albumsrecordingsmap' VALUES (2226, 6, 219, 2201);
INSERT INTO 'albumsrecordingsmap' VALUES (2227, 7, 219, 2202);
INSERT INTO 'albumsrecordingsmap' VALUES (2228, 8, 219, 2203);
INSERT INTO 'albumsrecordingsmap' VALUES (2229, 9, 219, 2204);
INSERT INTO 'albumsrecordingsmap' VALUES (2230, 10, 219, 2205);
INSERT INTO 'albumsrecordingsmap' VALUES (2231, 11, 219, 2206);
INSERT INTO 'albumsrecordingsmap' VALUES (2232, 6, 222, 2207);
INSERT INTO 'albumsrecordingsmap' VALUES (2233, 2, 222, 2208);
INSERT INTO 'albumsrecordingsmap' VALUES (2234, 3, 222, 2209);
INSERT INTO 'albumsrecordingsmap' VALUES (2235, 8, 222, 2210);
INSERT INTO 'albumsrecordingsmap' VALUES (2236, 1, 222, 2211);
INSERT INTO 'albumsrecordingsmap' VALUES (2237, 4, 222, 2212);
INSERT INTO 'albumsrecordingsmap' VALUES (2238, 5, 222, 2213);
INSERT INTO 'albumsrecordingsmap' VALUES (2239, 7, 222, 2214);
INSERT INTO 'albumsrecordingsmap' VALUES (2240, 1, 224, 2215);
INSERT INTO 'albumsrecordingsmap' VALUES (2241, 2, 224, 2216);
INSERT INTO 'albumsrecordingsmap' VALUES (2242, 4, 224, 2217);
INSERT INTO 'albumsrecordingsmap' VALUES (2243, 5, 224, 2218);
INSERT INTO 'albumsrecordingsmap' VALUES (2244, 8, 224, 2219);
INSERT INTO 'albumsrecordingsmap' VALUES (2245, 6, 224, 2220);
INSERT INTO 'albumsrecordingsmap' VALUES (2246, 7, 224, 2221);
INSERT INTO 'albumsrecordingsmap' VALUES (2247, 3, 224, 2222);
INSERT INTO 'albumsrecordingsmap' VALUES (2248, 12, 227, 2223);
INSERT INTO 'albumsrecordingsmap' VALUES (2249, 6, 227, 2224);
INSERT INTO 'albumsrecordingsmap' VALUES (2250, 10, 227, 2225);
INSERT INTO 'albumsrecordingsmap' VALUES (2251, 9, 227, 2226);
INSERT INTO 'albumsrecordingsmap' VALUES (2252, 3, 227, 2227);
INSERT INTO 'albumsrecordingsmap' VALUES (2253, 11, 227, 2228);
INSERT INTO 'albumsrecordingsmap' VALUES (2254, 8, 227, 2229);
INSERT INTO 'albumsrecordingsmap' VALUES (2255, 4, 227, 2230);
INSERT INTO 'albumsrecordingsmap' VALUES (2256, 2, 227, 2231);
INSERT INTO 'albumsrecordingsmap' VALUES (2257, 1, 227, 2232);
INSERT INTO 'albumsrecordingsmap' VALUES (2258, 7, 227, 2233);
INSERT INTO 'albumsrecordingsmap' VALUES (2259, 5, 227, 2234);
INSERT INTO 'albumsrecordingsmap' VALUES (2261, 10, 207, 2236);
INSERT INTO 'albumsrecordingsmap' VALUES (2262, 3, 207, 2237);
INSERT INTO 'albumsrecordingsmap' VALUES (2263, 8, 207, 2238);
INSERT INTO 'albumsrecordingsmap' VALUES (2264, 5, 207, 2239);
INSERT INTO 'albumsrecordingsmap' VALUES (2265, 1, 207, 2240);
INSERT INTO 'albumsrecordingsmap' VALUES (2266, 6, 207, 2241);
INSERT INTO 'albumsrecordingsmap' VALUES (2267, 9, 207, 2242);
INSERT INTO 'albumsrecordingsmap' VALUES (2268, 4, 207, 2243);
INSERT INTO 'albumsrecordingsmap' VALUES (2269, 2, 207, 2244);
INSERT INTO 'albumsrecordingsmap' VALUES (2270, 7, 207, 2245);
INSERT INTO 'albumsrecordingsmap' VALUES (2271, 3, 178, 2246);
INSERT INTO 'albumsrecordingsmap' VALUES (2272, 9, 178, 2247);
INSERT INTO 'albumsrecordingsmap' VALUES (2273, 6, 178, 2248);
INSERT INTO 'albumsrecordingsmap' VALUES (2274, 5, 178, 2249);
INSERT INTO 'albumsrecordingsmap' VALUES (2275, 8, 178, 2250);
INSERT INTO 'albumsrecordingsmap' VALUES (2276, 1, 178, 2251);
INSERT INTO 'albumsrecordingsmap' VALUES (2277, 4, 178, 2252);
INSERT INTO 'albumsrecordingsmap' VALUES (2278, 7, 178, 2253);
INSERT INTO 'albumsrecordingsmap' VALUES (2279, 2, 178, 2254);
INSERT INTO 'albumsrecordingsmap' VALUES (2280, 11, 231, 2255);
INSERT INTO 'albumsrecordingsmap' VALUES (2281, 4, 231, 2256);
INSERT INTO 'albumsrecordingsmap' VALUES (2282, 12, 231, 2257);
INSERT INTO 'albumsrecordingsmap' VALUES (2283, 6, 231, 2258);
INSERT INTO 'albumsrecordingsmap' VALUES (2284, 9, 231, 2259);
INSERT INTO 'albumsrecordingsmap' VALUES (2285, 1, 231, 2260);
INSERT INTO 'albumsrecordingsmap' VALUES (2286, 7, 231, 2261);
INSERT INTO 'albumsrecordingsmap' VALUES (2287, 8, 231, 2262);
INSERT INTO 'albumsrecordingsmap' VALUES (2288, 2, 231, 2263);
INSERT INTO 'albumsrecordingsmap' VALUES (2289, 3, 231, 2264);
INSERT INTO 'albumsrecordingsmap' VALUES (2290, 10, 231, 2265);
INSERT INTO 'albumsrecordingsmap' VALUES (2300, 1, 169, 2288);
INSERT INTO 'albumsrecordingsmap' VALUES (2301, 2, 169, 2289);
INSERT INTO 'albumsrecordingsmap' VALUES (2302, 3, 169, 2290);
INSERT INTO 'albumsrecordingsmap' VALUES (2303, 4, 169, 2291);
INSERT INTO 'albumsrecordingsmap' VALUES (2304, 5, 169, 2292);
INSERT INTO 'albumsrecordingsmap' VALUES (2305, 6, 169, 2293);
INSERT INTO 'albumsrecordingsmap' VALUES (2306, 7, 169, 2294);
INSERT INTO 'albumsrecordingsmap' VALUES (2307, 8, 169, 2295);
INSERT INTO 'albumsrecordingsmap' VALUES (2308, 9, 169, 2296);
INSERT INTO 'albumsrecordingsmap' VALUES (2309, 10, 169, 2297);
INSERT INTO 'albumsrecordingsmap' VALUES (2310, 11, 169, 2298);
INSERT INTO 'albumsrecordingsmap' VALUES (2311, 12, 169, 2299);
INSERT INTO 'albumsrecordingsmap' VALUES (2312, 13, 169, 2300);
INSERT INTO 'albumsrecordingsmap' VALUES (2313, 1, 162, 1032);
INSERT INTO 'albumsrecordingsmap' VALUES (2314, 2, 162, 1033);
INSERT INTO 'albumsrecordingsmap' VALUES (2315, 3, 162, 1034);
INSERT INTO 'albumsrecordingsmap' VALUES (2316, 4, 162, 1478);
INSERT INTO 'albumsrecordingsmap' VALUES (2317, 5, 162, 1479);
INSERT INTO 'albumsrecordingsmap' VALUES (2318, 6, 162, 1480);
INSERT INTO 'albumsrecordingsmap' VALUES (2319, 7, 162, 1481);
INSERT INTO 'albumsrecordingsmap' VALUES (2320, 8, 162, 1482);
INSERT INTO 'albumsrecordingsmap' VALUES (2321, 9, 162, 1483);
INSERT INTO 'albumsrecordingsmap' VALUES (2322, 10, 162, 1484);
INSERT INTO 'albumsrecordingsmap' VALUES (2323, 11, 162, 1485);
INSERT INTO 'albumsrecordingsmap' VALUES (2324, 12, 162, 1486);
INSERT INTO 'albumsrecordingsmap' VALUES (2325, 13, 162, 1487);
INSERT INTO 'albumsrecordingsmap' VALUES (2326, 14, 162, 1585);
INSERT INTO 'albumsrecordingsmap' VALUES (2327, 15, 162, 2266);
INSERT INTO 'albumsrecordingsmap' VALUES (2328, 16, 162, 2301);
INSERT INTO 'albumsrecordingsmap' VALUES (2329, 9, 729, 2302);
INSERT INTO 'albumsrecordingsmap' VALUES (2330, 5, 729, 2303);
INSERT INTO 'albumsrecordingsmap' VALUES (2331, 4, 729, 2304);
INSERT INTO 'albumsrecordingsmap' VALUES (2332, 1, 729, 2305);
INSERT INTO 'albumsrecordingsmap' VALUES (2333, 7, 729, 2306);
INSERT INTO 'albumsrecordingsmap' VALUES (2334, 6, 729, 2307);
INSERT INTO 'albumsrecordingsmap' VALUES (2335, 3, 729, 2308);
INSERT INTO 'albumsrecordingsmap' VALUES (2336, 8, 729, 2309);
INSERT INTO 'albumsrecordingsmap' VALUES (2337, 2, 729, 2310);
INSERT INTO 'albumsrecordingsmap' VALUES (2338, 5, 214, 2311);
INSERT INTO 'albumsrecordingsmap' VALUES (2339, 8, 214, 2312);
INSERT INTO 'albumsrecordingsmap' VALUES (2340, 2, 214, 2313);
INSERT INTO 'albumsrecordingsmap' VALUES (2341, 1, 214, 2314);
INSERT INTO 'albumsrecordingsmap' VALUES (2343, 4, 214, 2316);
INSERT INTO 'albumsrecordingsmap' VALUES (2344, 7, 214, 2317);
INSERT INTO 'albumsrecordingsmap' VALUES (2345, 3, 214, 2318);
INSERT INTO 'albumsrecordingsmap' VALUES (2346, 7, 149, 2319);
INSERT INTO 'albumsrecordingsmap' VALUES (2347, 3, 149, 2320);
INSERT INTO 'albumsrecordingsmap' VALUES (2348, 12, 149, 2321);
INSERT INTO 'albumsrecordingsmap' VALUES (2349, 5, 149, 2322);
INSERT INTO 'albumsrecordingsmap' VALUES (2350, 6, 149, 2323);
INSERT INTO 'albumsrecordingsmap' VALUES (2351, 9, 149, 2324);
INSERT INTO 'albumsrecordingsmap' VALUES (2352, 11, 149, 2325);
INSERT INTO 'albumsrecordingsmap' VALUES (2353, 1, 149, 2326);
INSERT INTO 'albumsrecordingsmap' VALUES (2354, 8, 149, 2327);
INSERT INTO 'albumsrecordingsmap' VALUES (2355, 10, 149, 2328);
INSERT INTO 'albumsrecordingsmap' VALUES (2356, 2, 149, 2329);
INSERT INTO 'albumsrecordingsmap' VALUES (2357, 4, 149, 2330);
INSERT INTO 'albumsrecordingsmap' VALUES (2358, 3, 215, 2343);
INSERT INTO 'albumsrecordingsmap' VALUES (2359, 2, 215, 2344);
INSERT INTO 'albumsrecordingsmap' VALUES (2360, 4, 215, 2345);
INSERT INTO 'albumsrecordingsmap' VALUES (2361, 1, 215, 2346);
INSERT INTO 'albumsrecordingsmap' VALUES (2362, 9, 215, 2347);
INSERT INTO 'albumsrecordingsmap' VALUES (2363, 10, 215, 2348);
INSERT INTO 'albumsrecordingsmap' VALUES (2364, 8, 215, 2349);
INSERT INTO 'albumsrecordingsmap' VALUES (2365, 7, 215, 2350);
INSERT INTO 'albumsrecordingsmap' VALUES (2366, 5, 215, 2351);
INSERT INTO 'albumsrecordingsmap' VALUES (2367, 6, 215, 2352);
INSERT INTO 'albumsrecordingsmap' VALUES (2368, 1, 209, 2353);
INSERT INTO 'albumsrecordingsmap' VALUES (2369, 2, 209, 2354);
INSERT INTO 'albumsrecordingsmap' VALUES (2370, 3, 209, 2355);
INSERT INTO 'albumsrecordingsmap' VALUES (2371, 4, 209, 2356);
INSERT INTO 'albumsrecordingsmap' VALUES (2372, 5, 209, 2357);
INSERT INTO 'albumsrecordingsmap' VALUES (2373, 6, 209, 2358);
INSERT INTO 'albumsrecordingsmap' VALUES (2374, 7, 209, 2359);
INSERT INTO 'albumsrecordingsmap' VALUES (2375, 8, 209, 2360);
INSERT INTO 'albumsrecordingsmap' VALUES (2376, 9, 209, 2361);
INSERT INTO 'albumsrecordingsmap' VALUES (2377, 10, 209, 2362);
INSERT INTO 'albumsrecordingsmap' VALUES (2378, 11, 209, 2363);
INSERT INTO 'albumsrecordingsmap' VALUES (2379, 12, 209, 2364);
INSERT INTO 'albumsrecordingsmap' VALUES (2380, 13, 209, 2365);
INSERT INTO 'albumsrecordingsmap' VALUES (2381, 7, 174, 2367);
INSERT INTO 'albumsrecordingsmap' VALUES (2382, 9, 174, 2368);
INSERT INTO 'albumsrecordingsmap' VALUES (2383, 4, 174, 2369);
INSERT INTO 'albumsrecordingsmap' VALUES (2384, 5, 174, 2370);
INSERT INTO 'albumsrecordingsmap' VALUES (2385, 8, 174, 2371);
INSERT INTO 'albumsrecordingsmap' VALUES (2386, 6, 174, 2372);
INSERT INTO 'albumsrecordingsmap' VALUES (2387, 2, 174, 2373);
INSERT INTO 'albumsrecordingsmap' VALUES (2388, 3, 174, 2374);
INSERT INTO 'albumsrecordingsmap' VALUES (2389, 10, 163, 2375);
INSERT INTO 'albumsrecordingsmap' VALUES (2390, 3, 163, 2376);
INSERT INTO 'albumsrecordingsmap' VALUES (2391, 7, 163, 2377);
INSERT INTO 'albumsrecordingsmap' VALUES (2392, 5, 163, 2378);
INSERT INTO 'albumsrecordingsmap' VALUES (2393, 1, 163, 2379);
INSERT INTO 'albumsrecordingsmap' VALUES (2394, 9, 163, 2380);
INSERT INTO 'albumsrecordingsmap' VALUES (2395, 6, 163, 2381);
INSERT INTO 'albumsrecordingsmap' VALUES (2396, 8, 163, 2382);
INSERT INTO 'albumsrecordingsmap' VALUES (2397, 2, 163, 2383);
INSERT INTO 'albumsrecordingsmap' VALUES (2398, 4, 163, 2384);
INSERT INTO 'albumsrecordingsmap' VALUES (2399, 1, 161, 2385);
INSERT INTO 'albumsrecordingsmap' VALUES (2400, 2, 161, 2386);
INSERT INTO 'albumsrecordingsmap' VALUES (2401, 3, 161, 2387);
INSERT INTO 'albumsrecordingsmap' VALUES (2402, 4, 161, 2388);
INSERT INTO 'albumsrecordingsmap' VALUES (2403, 5, 161, 2389);
INSERT INTO 'albumsrecordingsmap' VALUES (2404, 6, 161, 2390);
INSERT INTO 'albumsrecordingsmap' VALUES (2405, 7, 161, 2391);
INSERT INTO 'albumsrecordingsmap' VALUES (2406, 8, 161, 2392);
INSERT INTO 'albumsrecordingsmap' VALUES (2407, 9, 161, 2393);
INSERT INTO 'albumsrecordingsmap' VALUES (2408, 10, 161, 2394);
INSERT INTO 'albumsrecordingsmap' VALUES (2409, 11, 161, 2395);
INSERT INTO 'albumsrecordingsmap' VALUES (2410, 6, 721, 2396);
INSERT INTO 'albumsrecordingsmap' VALUES (2411, 1, 721, 2397);
INSERT INTO 'albumsrecordingsmap' VALUES (2412, 7, 721, 2398);
INSERT INTO 'albumsrecordingsmap' VALUES (2413, 5, 721, 2399);
INSERT INTO 'albumsrecordingsmap' VALUES (2414, 3, 721, 2400);
INSERT INTO 'albumsrecordingsmap' VALUES (2415, 9, 721, 2401);
INSERT INTO 'albumsrecordingsmap' VALUES (2416, 2, 721, 2402);
INSERT INTO 'albumsrecordingsmap' VALUES (2417, 4, 721, 2403);
INSERT INTO 'albumsrecordingsmap' VALUES (2418, 8, 721, 2404);
INSERT INTO 'albumsrecordingsmap' VALUES (2419, 1, 154, 2405);
INSERT INTO 'albumsrecordingsmap' VALUES (2420, 5, 154, 2406);
INSERT INTO 'albumsrecordingsmap' VALUES (2421, 7, 154, 2407);
INSERT INTO 'albumsrecordingsmap' VALUES (2422, 3, 154, 2408);
INSERT INTO 'albumsrecordingsmap' VALUES (2423, 8, 154, 2409);
INSERT INTO 'albumsrecordingsmap' VALUES (2424, 4, 154, 2410);
INSERT INTO 'albumsrecordingsmap' VALUES (2425, 2, 154, 2411);
INSERT INTO 'albumsrecordingsmap' VALUES (2426, 6, 154, 2412);
INSERT INTO 'albumsrecordingsmap' VALUES (2427, 1, 159, 2413);
INSERT INTO 'albumsrecordingsmap' VALUES (2428, 2, 159, 2414);
INSERT INTO 'albumsrecordingsmap' VALUES (2429, 3, 159, 2415);
INSERT INTO 'albumsrecordingsmap' VALUES (2430, 4, 159, 2416);
INSERT INTO 'albumsrecordingsmap' VALUES (2431, 5, 159, 2417);
INSERT INTO 'albumsrecordingsmap' VALUES (2432, 6, 159, 2418);
INSERT INTO 'albumsrecordingsmap' VALUES (2433, 7, 159, 2419);
INSERT INTO 'albumsrecordingsmap' VALUES (2434, 8, 159, 2420);
INSERT INTO 'albumsrecordingsmap' VALUES (2435, 9, 134, 2421);
INSERT INTO 'albumsrecordingsmap' VALUES (2436, 1, 134, 2422);
INSERT INTO 'albumsrecordingsmap' VALUES (2437, 8, 134, 2425);
INSERT INTO 'albumsrecordingsmap' VALUES (2438, 2, 134, 2427);
INSERT INTO 'albumsrecordingsmap' VALUES (2439, 10, 134, 2428);
INSERT INTO 'albumsrecordingsmap' VALUES (2440, 13, 134, 2429);
INSERT INTO 'albumsrecordingsmap' VALUES (2441, 4, 134, 2431);
INSERT INTO 'albumsrecordingsmap' VALUES (2442, 1, 229, 2433);
INSERT INTO 'albumsrecordingsmap' VALUES (2443, 2, 229, 2434);
INSERT INTO 'albumsrecordingsmap' VALUES (2444, 3, 229, 2435);
INSERT INTO 'albumsrecordingsmap' VALUES (2445, 5, 229, 2436);
INSERT INTO 'albumsrecordingsmap' VALUES (2446, 4, 229, 2437);
INSERT INTO 'albumsrecordingsmap' VALUES (2447, 6, 229, 2438);
INSERT INTO 'albumsrecordingsmap' VALUES (2448, 7, 229, 2439);
INSERT INTO 'albumsrecordingsmap' VALUES (2449, 8, 229, 2440);
INSERT INTO 'albumsrecordingsmap' VALUES (2450, 9, 229, 2441);
INSERT INTO 'albumsrecordingsmap' VALUES (2451, 10, 229, 2442);
INSERT INTO 'albumsrecordingsmap' VALUES (2452, 11, 229, 2443);
INSERT INTO 'albumsrecordingsmap' VALUES (2453, 1, 131, 2444);
INSERT INTO 'albumsrecordingsmap' VALUES (2454, 11, 131, 2445);
INSERT INTO 'albumsrecordingsmap' VALUES (2455, 2, 131, 2446);
INSERT INTO 'albumsrecordingsmap' VALUES (2456, 3, 131, 2447);
INSERT INTO 'albumsrecordingsmap' VALUES (2457, 4, 131, 2448);
INSERT INTO 'albumsrecordingsmap' VALUES (2458, 5, 131, 2449);
INSERT INTO 'albumsrecordingsmap' VALUES (2459, 6, 131, 2450);
INSERT INTO 'albumsrecordingsmap' VALUES (2460, 7, 131, 2451);
INSERT INTO 'albumsrecordingsmap' VALUES (2461, 8, 131, 2452);
INSERT INTO 'albumsrecordingsmap' VALUES (2462, 9, 131, 2453);
INSERT INTO 'albumsrecordingsmap' VALUES (2463, 10, 131, 2454);
INSERT INTO 'albumsrecordingsmap' VALUES (2464, 9, 195, 2455);
INSERT INTO 'albumsrecordingsmap' VALUES (2465, 7, 195, 2456);
INSERT INTO 'albumsrecordingsmap' VALUES (2466, 6, 195, 2457);
INSERT INTO 'albumsrecordingsmap' VALUES (2467, 3, 195, 2458);
INSERT INTO 'albumsrecordingsmap' VALUES (2468, 1, 195, 2459);
INSERT INTO 'albumsrecordingsmap' VALUES (2469, 5, 195, 2460);
INSERT INTO 'albumsrecordingsmap' VALUES (2470, 2, 195, 2461);
INSERT INTO 'albumsrecordingsmap' VALUES (2471, 8, 195, 2462);
INSERT INTO 'albumsrecordingsmap' VALUES (2472, 4, 195, 2463);
INSERT INTO 'albumsrecordingsmap' VALUES (10766, 14, 1110, 10172);
INSERT INTO 'albumsrecordingsmap' VALUES (6236, 2, 455, 5748);
INSERT INTO 'albumsrecordingsmap' VALUES (6237, 3, 455, 5749);
INSERT INTO 'albumsrecordingsmap' VALUES (6238, 4, 455, 5750);
INSERT INTO 'albumsrecordingsmap' VALUES (6239, 5, 455, 5751);
INSERT INTO 'albumsrecordingsmap' VALUES (6240, 6, 455, 5752);
INSERT INTO 'albumsrecordingsmap' VALUES (6241, 7, 455, 5753);
INSERT INTO 'albumsrecordingsmap' VALUES (6242, 8, 455, 5754);
INSERT INTO 'albumsrecordingsmap' VALUES (6243, 9, 455, 5755);
INSERT INTO 'albumsrecordingsmap' VALUES (6244, 10, 455, 5756);
INSERT INTO 'albumsrecordingsmap' VALUES (2495, 4, 237, 2489);
INSERT INTO 'albumsrecordingsmap' VALUES (2496, 1, 237, 2490);
INSERT INTO 'albumsrecordingsmap' VALUES (2497, 10, 237, 2491);
INSERT INTO 'albumsrecordingsmap' VALUES (2498, 6, 237, 2492);
INSERT INTO 'albumsrecordingsmap' VALUES (2499, 7, 237, 2493);
INSERT INTO 'albumsrecordingsmap' VALUES (2500, 2, 237, 2494);
INSERT INTO 'albumsrecordingsmap' VALUES (2501, 8, 237, 2495);
INSERT INTO 'albumsrecordingsmap' VALUES (2502, 11, 237, 2496);
INSERT INTO 'albumsrecordingsmap' VALUES (2503, 5, 237, 2497);
INSERT INTO 'albumsrecordingsmap' VALUES (2504, 9, 237, 2498);
INSERT INTO 'albumsrecordingsmap' VALUES (2505, 3, 237, 2499);
INSERT INTO 'albumsrecordingsmap' VALUES (2506, 12, 237, 2500);
INSERT INTO 'albumsrecordingsmap' VALUES (2523, 6, 144, 2532);
INSERT INTO 'albumsrecordingsmap' VALUES (2524, 1, 144, 2533);
INSERT INTO 'albumsrecordingsmap' VALUES (2525, 11, 144, 2534);
INSERT INTO 'albumsrecordingsmap' VALUES (2526, 12, 144, 2535);
INSERT INTO 'albumsrecordingsmap' VALUES (2527, 7, 144, 2536);
INSERT INTO 'albumsrecordingsmap' VALUES (2528, 14, 144, 2537);
INSERT INTO 'albumsrecordingsmap' VALUES (2529, 8, 144, 2538);
INSERT INTO 'albumsrecordingsmap' VALUES (2530, 3, 144, 2539);
INSERT INTO 'albumsrecordingsmap' VALUES (2531, 5, 144, 2540);
INSERT INTO 'albumsrecordingsmap' VALUES (2532, 13, 144, 2541);
INSERT INTO 'albumsrecordingsmap' VALUES (2533, 4, 144, 2542);
INSERT INTO 'albumsrecordingsmap' VALUES (2534, 8, 147, 2544);
INSERT INTO 'albumsrecordingsmap' VALUES (2535, 5, 147, 2545);
INSERT INTO 'albumsrecordingsmap' VALUES (2536, 2, 147, 2546);
INSERT INTO 'albumsrecordingsmap' VALUES (2537, 10, 147, 2548);
INSERT INTO 'albumsrecordingsmap' VALUES (2538, 1, 147, 2549);
INSERT INTO 'albumsrecordingsmap' VALUES (2539, 6, 147, 2550);
INSERT INTO 'albumsrecordingsmap' VALUES (2540, 4, 147, 2551);
INSERT INTO 'albumsrecordingsmap' VALUES (2541, 3, 147, 2552);
INSERT INTO 'albumsrecordingsmap' VALUES (2542, 9, 147, 2553);
INSERT INTO 'albumsrecordingsmap' VALUES (2543, 7, 147, 2554);
INSERT INTO 'albumsrecordingsmap' VALUES (2544, 5, 180, 2555);
INSERT INTO 'albumsrecordingsmap' VALUES (2545, 8, 180, 2556);
INSERT INTO 'albumsrecordingsmap' VALUES (2546, 4, 180, 2557);
INSERT INTO 'albumsrecordingsmap' VALUES (2547, 6, 180, 2558);
INSERT INTO 'albumsrecordingsmap' VALUES (2548, 3, 180, 2559);
INSERT INTO 'albumsrecordingsmap' VALUES (2549, 1, 180, 2560);
INSERT INTO 'albumsrecordingsmap' VALUES (2550, 2, 180, 2561);
INSERT INTO 'albumsrecordingsmap' VALUES (2551, 7, 180, 2562);
INSERT INTO 'albumsrecordingsmap' VALUES (2552, 1, 135, 2563);
INSERT INTO 'albumsrecordingsmap' VALUES (2553, 2, 135, 2564);
INSERT INTO 'albumsrecordingsmap' VALUES (2554, 3, 135, 2565);
INSERT INTO 'albumsrecordingsmap' VALUES (2555, 4, 135, 2566);
INSERT INTO 'albumsrecordingsmap' VALUES (2556, 5, 135, 2567);
INSERT INTO 'albumsrecordingsmap' VALUES (2557, 7, 135, 2569);
INSERT INTO 'albumsrecordingsmap' VALUES (2558, 8, 135, 2570);
INSERT INTO 'albumsrecordingsmap' VALUES (2559, 11, 727, 2571);
INSERT INTO 'albumsrecordingsmap' VALUES (2560, 1, 727, 2572);
INSERT INTO 'albumsrecordingsmap' VALUES (2561, 14, 727, 2573);
INSERT INTO 'albumsrecordingsmap' VALUES (2562, 2, 727, 2574);
INSERT INTO 'albumsrecordingsmap' VALUES (2563, 15, 727, 2575);
INSERT INTO 'albumsrecordingsmap' VALUES (2564, 7, 727, 2576);
INSERT INTO 'albumsrecordingsmap' VALUES (2565, 13, 727, 2577);
INSERT INTO 'albumsrecordingsmap' VALUES (2566, 8, 727, 2578);
INSERT INTO 'albumsrecordingsmap' VALUES (2567, 6, 727, 2579);
INSERT INTO 'albumsrecordingsmap' VALUES (2568, 10, 727, 2580);
INSERT INTO 'albumsrecordingsmap' VALUES (2569, 4, 727, 2581);
INSERT INTO 'albumsrecordingsmap' VALUES (2570, 9, 727, 2582);
INSERT INTO 'albumsrecordingsmap' VALUES (2571, 12, 727, 2583);
INSERT INTO 'albumsrecordingsmap' VALUES (2572, 5, 727, 2584);
INSERT INTO 'albumsrecordingsmap' VALUES (2573, 3, 727, 2585);
INSERT INTO 'albumsrecordingsmap' VALUES (2574, 1, 184, 2586);
INSERT INTO 'albumsrecordingsmap' VALUES (2575, 2, 184, 2587);
INSERT INTO 'albumsrecordingsmap' VALUES (2576, 3, 184, 2588);
INSERT INTO 'albumsrecordingsmap' VALUES (2577, 4, 184, 2589);
INSERT INTO 'albumsrecordingsmap' VALUES (2578, 5, 184, 2590);
INSERT INTO 'albumsrecordingsmap' VALUES (2579, 6, 184, 2591);
INSERT INTO 'albumsrecordingsmap' VALUES (2580, 7, 184, 2592);
INSERT INTO 'albumsrecordingsmap' VALUES (2581, 8, 184, 2593);
INSERT INTO 'albumsrecordingsmap' VALUES (2582, 9, 184, 2594);
INSERT INTO 'albumsrecordingsmap' VALUES (2583, 10, 184, 2595);
INSERT INTO 'albumsrecordingsmap' VALUES (2584, 11, 184, 2596);
INSERT INTO 'albumsrecordingsmap' VALUES (2585, 12, 184, 2597);
INSERT INTO 'albumsrecordingsmap' VALUES (2586, 6, 241, 2598);
INSERT INTO 'albumsrecordingsmap' VALUES (2587, 1, 241, 2599);
INSERT INTO 'albumsrecordingsmap' VALUES (2588, 10, 241, 2600);
INSERT INTO 'albumsrecordingsmap' VALUES (2589, 9, 241, 2601);
INSERT INTO 'albumsrecordingsmap' VALUES (2590, 7, 241, 2602);
INSERT INTO 'albumsrecordingsmap' VALUES (2591, 3, 241, 2603);
INSERT INTO 'albumsrecordingsmap' VALUES (2592, 4, 241, 2604);
INSERT INTO 'albumsrecordingsmap' VALUES (2593, 2, 241, 2605);
INSERT INTO 'albumsrecordingsmap' VALUES (2594, 8, 241, 2606);
INSERT INTO 'albumsrecordingsmap' VALUES (2595, 5, 241, 2607);
INSERT INTO 'albumsrecordingsmap' VALUES (2601, 1, 140, 2613);
INSERT INTO 'albumsrecordingsmap' VALUES (2604, 8, 235, 2616);
INSERT INTO 'albumsrecordingsmap' VALUES (2605, 7, 235, 2617);
INSERT INTO 'albumsrecordingsmap' VALUES (2606, 10, 235, 2618);
INSERT INTO 'albumsrecordingsmap' VALUES (2607, 2, 235, 2619);
INSERT INTO 'albumsrecordingsmap' VALUES (2608, 9, 235, 2620);
INSERT INTO 'albumsrecordingsmap' VALUES (2609, 1, 235, 2621);
INSERT INTO 'albumsrecordingsmap' VALUES (2610, 3, 235, 2622);
INSERT INTO 'albumsrecordingsmap' VALUES (2611, 11, 235, 2623);
INSERT INTO 'albumsrecordingsmap' VALUES (2612, 4, 235, 2624);
INSERT INTO 'albumsrecordingsmap' VALUES (2613, 12, 235, 2625);
INSERT INTO 'albumsrecordingsmap' VALUES (2614, 6, 235, 2626);
INSERT INTO 'albumsrecordingsmap' VALUES (2615, 5, 235, 2627);
INSERT INTO 'albumsrecordingsmap' VALUES (2616, 1, 133, 1158);
INSERT INTO 'albumsrecordingsmap' VALUES (2617, 2, 133, 1160);
INSERT INTO 'albumsrecordingsmap' VALUES (2618, 3, 133, 1162);
INSERT INTO 'albumsrecordingsmap' VALUES (2619, 4, 133, 1163);
INSERT INTO 'albumsrecordingsmap' VALUES (2620, 5, 133, 1164);
INSERT INTO 'albumsrecordingsmap' VALUES (2621, 6, 133, 1165);
INSERT INTO 'albumsrecordingsmap' VALUES (2622, 7, 133, 1167);
INSERT INTO 'albumsrecordingsmap' VALUES (2623, 8, 133, 2332);
INSERT INTO 'albumsrecordingsmap' VALUES (2624, 9, 133, 2339);
INSERT INTO 'albumsrecordingsmap' VALUES (2625, 10, 133, 2628);
INSERT INTO 'albumsrecordingsmap' VALUES (2626, 11, 133, 2629);
INSERT INTO 'albumsrecordingsmap' VALUES (2627, 1, 145, 2630);
INSERT INTO 'albumsrecordingsmap' VALUES (2628, 2, 145, 2631);
INSERT INTO 'albumsrecordingsmap' VALUES (2629, 3, 145, 2632);
INSERT INTO 'albumsrecordingsmap' VALUES (2630, 4, 145, 2633);
INSERT INTO 'albumsrecordingsmap' VALUES (2631, 5, 145, 2634);
INSERT INTO 'albumsrecordingsmap' VALUES (2632, 6, 145, 2635);
INSERT INTO 'albumsrecordingsmap' VALUES (2633, 7, 145, 2636);
INSERT INTO 'albumsrecordingsmap' VALUES (2634, 8, 145, 2637);
INSERT INTO 'albumsrecordingsmap' VALUES (2635, 9, 145, 2638);
INSERT INTO 'albumsrecordingsmap' VALUES (2636, 1, 146, 2639);
INSERT INTO 'albumsrecordingsmap' VALUES (2637, 2, 146, 2640);
INSERT INTO 'albumsrecordingsmap' VALUES (2638, 3, 146, 2641);
INSERT INTO 'albumsrecordingsmap' VALUES (2639, 4, 146, 2642);
INSERT INTO 'albumsrecordingsmap' VALUES (2640, 5, 146, 2643);
INSERT INTO 'albumsrecordingsmap' VALUES (2641, 6, 146, 2644);
INSERT INTO 'albumsrecordingsmap' VALUES (2642, 7, 146, 2645);
INSERT INTO 'albumsrecordingsmap' VALUES (2596, 5, 140, 2608);
INSERT INTO 'albumsrecordingsmap' VALUES (2516, 6, 175, 2523);
INSERT INTO 'albumsrecordingsmap' VALUES (2517, 2, 175, 2524);
INSERT INTO 'albumsrecordingsmap' VALUES (2518, 8, 175, 2525);
INSERT INTO 'albumsrecordingsmap' VALUES (2519, 1, 175, 2526);
INSERT INTO 'albumsrecordingsmap' VALUES (2520, 4, 175, 2527);
INSERT INTO 'albumsrecordingsmap' VALUES (2521, 7, 175, 2529);
INSERT INTO 'albumsrecordingsmap' VALUES (2522, 3, 175, 2530);
INSERT INTO 'albumsrecordingsmap' VALUES (2597, 13, 140, 2609);
INSERT INTO 'albumsrecordingsmap' VALUES (2598, 11, 140, 2610);
INSERT INTO 'albumsrecordingsmap' VALUES (2599, 12, 140, 2611);
INSERT INTO 'albumsrecordingsmap' VALUES (2600, 7, 140, 2612);
INSERT INTO 'albumsrecordingsmap' VALUES (2602, 9, 140, 2614);
INSERT INTO 'albumsrecordingsmap' VALUES (2603, 3, 140, 2615);
INSERT INTO 'albumsrecordingsmap' VALUES (2643, 8, 146, 2646);
INSERT INTO 'albumsrecordingsmap' VALUES (2644, 9, 146, 2647);
INSERT INTO 'albumsrecordingsmap' VALUES (2645, 10, 146, 2648);
INSERT INTO 'albumsrecordingsmap' VALUES (2646, 11, 146, 2649);
INSERT INTO 'albumsrecordingsmap' VALUES (2647, 12, 146, 2650);
INSERT INTO 'albumsrecordingsmap' VALUES (2648, 13, 146, 2651);
INSERT INTO 'albumsrecordingsmap' VALUES (2649, 1, 168, 2652);
INSERT INTO 'albumsrecordingsmap' VALUES (2650, 2, 168, 2653);
INSERT INTO 'albumsrecordingsmap' VALUES (2651, 3, 168, 2654);
INSERT INTO 'albumsrecordingsmap' VALUES (2652, 4, 168, 2655);
INSERT INTO 'albumsrecordingsmap' VALUES (2653, 5, 168, 2656);
INSERT INTO 'albumsrecordingsmap' VALUES (2654, 6, 168, 2657);
INSERT INTO 'albumsrecordingsmap' VALUES (2655, 7, 168, 2658);
INSERT INTO 'albumsrecordingsmap' VALUES (2656, 8, 168, 2659);
INSERT INTO 'albumsrecordingsmap' VALUES (2657, 9, 168, 2660);
INSERT INTO 'albumsrecordingsmap' VALUES (2658, 10, 168, 2661);
INSERT INTO 'albumsrecordingsmap' VALUES (2659, 11, 168, 2662);
INSERT INTO 'albumsrecordingsmap' VALUES (2660, 12, 168, 2663);
INSERT INTO 'albumsrecordingsmap' VALUES (10767, 1, 1109, 10173);
INSERT INTO 'albumsrecordingsmap' VALUES (10768, 2, 1109, 10174);
INSERT INTO 'albumsrecordingsmap' VALUES (10769, 3, 1109, 10175);
INSERT INTO 'albumsrecordingsmap' VALUES (10770, 4, 1109, 10176);
INSERT INTO 'albumsrecordingsmap' VALUES (10771, 5, 1109, 10177);
INSERT INTO 'albumsrecordingsmap' VALUES (10772, 6, 1109, 10178);
INSERT INTO 'albumsrecordingsmap' VALUES (10773, 7, 1109, 10179);
INSERT INTO 'albumsrecordingsmap' VALUES (10774, 8, 1109, 10180);
INSERT INTO 'albumsrecordingsmap' VALUES (10775, 9, 1109, 10181);
INSERT INTO 'albumsrecordingsmap' VALUES (10776, 10, 1109, 10182);
INSERT INTO 'albumsrecordingsmap' VALUES (10777, 11, 1109, 10183);
INSERT INTO 'albumsrecordingsmap' VALUES (10778, 12, 1109, 10184);
INSERT INTO 'albumsrecordingsmap' VALUES (10779, 13, 1109, 10185);
INSERT INTO 'albumsrecordingsmap' VALUES (2678, 1, 187, 2681);
INSERT INTO 'albumsrecordingsmap' VALUES (2681, 18, 188, 2684);
INSERT INTO 'albumsrecordingsmap' VALUES (2682, 9, 188, 2685);
INSERT INTO 'albumsrecordingsmap' VALUES (2683, 7, 188, 2686);
INSERT INTO 'albumsrecordingsmap' VALUES (2684, 4, 188, 2687);
INSERT INTO 'albumsrecordingsmap' VALUES (2685, 3, 188, 2688);
INSERT INTO 'albumsrecordingsmap' VALUES (2686, 10, 188, 2689);
INSERT INTO 'albumsrecordingsmap' VALUES (2687, 12, 188, 2690);
INSERT INTO 'albumsrecordingsmap' VALUES (2688, 17, 188, 2691);
INSERT INTO 'albumsrecordingsmap' VALUES (2689, 19, 188, 2692);
INSERT INTO 'albumsrecordingsmap' VALUES (2704, 4, 211, 2707);
INSERT INTO 'albumsrecordingsmap' VALUES (2705, 17, 211, 2708);
INSERT INTO 'albumsrecordingsmap' VALUES (2706, 15, 211, 2709);
INSERT INTO 'albumsrecordingsmap' VALUES (2707, 8, 211, 2710);
INSERT INTO 'albumsrecordingsmap' VALUES (2708, 10, 211, 2711);
INSERT INTO 'albumsrecordingsmap' VALUES (2709, 1, 213, 2712);
INSERT INTO 'albumsrecordingsmap' VALUES (2710, 2, 213, 2713);
INSERT INTO 'albumsrecordingsmap' VALUES (2711, 13, 213, 2714);
INSERT INTO 'albumsrecordingsmap' VALUES (2712, 12, 213, 2715);
INSERT INTO 'albumsrecordingsmap' VALUES (2713, 8, 213, 2716);
INSERT INTO 'albumsrecordingsmap' VALUES (2714, 9, 213, 2717);
INSERT INTO 'albumsrecordingsmap' VALUES (2715, 3, 213, 2718);
INSERT INTO 'albumsrecordingsmap' VALUES (2716, 4, 213, 2719);
INSERT INTO 'albumsrecordingsmap' VALUES (2717, 6, 213, 2720);
INSERT INTO 'albumsrecordingsmap' VALUES (2718, 7, 213, 2721);
INSERT INTO 'albumsrecordingsmap' VALUES (2719, 17, 213, 2722);
INSERT INTO 'albumsrecordingsmap' VALUES (2720, 15, 213, 2724);
INSERT INTO 'albumsrecordingsmap' VALUES (2721, 10, 213, 2725);
INSERT INTO 'albumsrecordingsmap' VALUES (2722, 11, 213, 2726);
INSERT INTO 'albumsrecordingsmap' VALUES (2723, 1, 248, 2727);
INSERT INTO 'albumsrecordingsmap' VALUES (2724, 2, 248, 2728);
INSERT INTO 'albumsrecordingsmap' VALUES (2725, 3, 248, 2729);
INSERT INTO 'albumsrecordingsmap' VALUES (2726, 4, 248, 2730);
INSERT INTO 'albumsrecordingsmap' VALUES (2727, 1, 249, 2501);
INSERT INTO 'albumsrecordingsmap' VALUES (2728, 10, 249, 2502);
INSERT INTO 'albumsrecordingsmap' VALUES (2729, 11, 249, 2503);
INSERT INTO 'albumsrecordingsmap' VALUES (2730, 12, 249, 2504);
INSERT INTO 'albumsrecordingsmap' VALUES (2731, 2, 249, 2505);
INSERT INTO 'albumsrecordingsmap' VALUES (2732, 4, 249, 2506);
INSERT INTO 'albumsrecordingsmap' VALUES (2733, 5, 249, 2507);
INSERT INTO 'albumsrecordingsmap' VALUES (2734, 6, 249, 2508);
INSERT INTO 'albumsrecordingsmap' VALUES (2735, 7, 249, 2509);
INSERT INTO 'albumsrecordingsmap' VALUES (2736, 8, 249, 2510);
INSERT INTO 'albumsrecordingsmap' VALUES (2737, 9, 249, 2511);
INSERT INTO 'albumsrecordingsmap' VALUES (2738, 3, 249, 2512);
INSERT INTO 'albumsrecordingsmap' VALUES (2739, 1, 250, 2513);
INSERT INTO 'albumsrecordingsmap' VALUES (2740, 2, 250, 2731);
INSERT INTO 'albumsrecordingsmap' VALUES (2741, 3, 250, 2732);
INSERT INTO 'albumsrecordingsmap' VALUES (2742, 4, 250, 2733);
INSERT INTO 'albumsrecordingsmap' VALUES (2743, 8, 250, 2734);
INSERT INTO 'albumsrecordingsmap' VALUES (2744, 9, 250, 2735);
INSERT INTO 'albumsrecordingsmap' VALUES (2745, 6, 250, 2736);
INSERT INTO 'albumsrecordingsmap' VALUES (2746, 5, 250, 2737);
INSERT INTO 'albumsrecordingsmap' VALUES (2747, 10, 250, 2738);
INSERT INTO 'albumsrecordingsmap' VALUES (2748, 1, 251, 2739);
INSERT INTO 'albumsrecordingsmap' VALUES (2749, 3, 251, 2740);
INSERT INTO 'albumsrecordingsmap' VALUES (2750, 4, 251, 2741);
INSERT INTO 'albumsrecordingsmap' VALUES (2751, 6, 251, 2742);
INSERT INTO 'albumsrecordingsmap' VALUES (2752, 7, 251, 2743);
INSERT INTO 'albumsrecordingsmap' VALUES (2753, 8, 251, 2744);
INSERT INTO 'albumsrecordingsmap' VALUES (2754, 9, 251, 2745);
INSERT INTO 'albumsrecordingsmap' VALUES (2755, 10, 251, 2746);
INSERT INTO 'albumsrecordingsmap' VALUES (2756, 12, 251, 2747);
INSERT INTO 'albumsrecordingsmap' VALUES (2757, 5, 251, 2748);
INSERT INTO 'albumsrecordingsmap' VALUES (2758, 11, 251, 2749);
INSERT INTO 'albumsrecordingsmap' VALUES (2759, 2, 251, 2750);
INSERT INTO 'albumsrecordingsmap' VALUES (2760, 1, 781, 2751);
INSERT INTO 'albumsrecordingsmap' VALUES (2761, 3, 781, 2752);
INSERT INTO 'albumsrecordingsmap' VALUES (2762, 4, 781, 2753);
INSERT INTO 'albumsrecordingsmap' VALUES (2763, 5, 781, 2754);
INSERT INTO 'albumsrecordingsmap' VALUES (2764, 6, 781, 2755);
INSERT INTO 'albumsrecordingsmap' VALUES (2765, 7, 781, 2756);
INSERT INTO 'albumsrecordingsmap' VALUES (2766, 9, 781, 2757);
INSERT INTO 'albumsrecordingsmap' VALUES (2767, 1, 255, 2766);
INSERT INTO 'albumsrecordingsmap' VALUES (2768, 2, 255, 2767);
INSERT INTO 'albumsrecordingsmap' VALUES (2769, 3, 255, 2768);
INSERT INTO 'albumsrecordingsmap' VALUES (2770, 4, 255, 2769);
INSERT INTO 'albumsrecordingsmap' VALUES (2771, 5, 255, 2770);
INSERT INTO 'albumsrecordingsmap' VALUES (2772, 6, 255, 2771);
INSERT INTO 'albumsrecordingsmap' VALUES (2773, 7, 255, 2772);
INSERT INTO 'albumsrecordingsmap' VALUES (2774, 8, 255, 2773);
INSERT INTO 'albumsrecordingsmap' VALUES (2775, 9, 255, 2774);
INSERT INTO 'albumsrecordingsmap' VALUES (2776, 10, 255, 2775);
INSERT INTO 'albumsrecordingsmap' VALUES (2777, 11, 255, 2776);
INSERT INTO 'albumsrecordingsmap' VALUES (2778, 12, 255, 2777);
INSERT INTO 'albumsrecordingsmap' VALUES (2779, 1, 256, 2779);
INSERT INTO 'albumsrecordingsmap' VALUES (2780, 2, 256, 2780);
INSERT INTO 'albumsrecordingsmap' VALUES (2781, 3, 256, 2781);
INSERT INTO 'albumsrecordingsmap' VALUES (2782, 4, 256, 2782);
INSERT INTO 'albumsrecordingsmap' VALUES (2783, 5, 256, 2783);
INSERT INTO 'albumsrecordingsmap' VALUES (2784, 6, 256, 2784);
INSERT INTO 'albumsrecordingsmap' VALUES (2785, 7, 256, 2785);
INSERT INTO 'albumsrecordingsmap' VALUES (2786, 8, 256, 2786);
INSERT INTO 'albumsrecordingsmap' VALUES (2787, 10, 256, 2787);
INSERT INTO 'albumsrecordingsmap' VALUES (2788, 11, 256, 2788);
INSERT INTO 'albumsrecordingsmap' VALUES (2789, 12, 256, 2789);
INSERT INTO 'albumsrecordingsmap' VALUES (2790, 13, 256, 2790);
INSERT INTO 'albumsrecordingsmap' VALUES (2791, 9, 256, 2791);
INSERT INTO 'albumsrecordingsmap' VALUES (2792, 1, 257, 2792);
INSERT INTO 'albumsrecordingsmap' VALUES (2793, 2, 257, 2793);
INSERT INTO 'albumsrecordingsmap' VALUES (2794, 3, 257, 2794);
INSERT INTO 'albumsrecordingsmap' VALUES (2795, 4, 257, 2795);
INSERT INTO 'albumsrecordingsmap' VALUES (2796, 5, 257, 2796);
INSERT INTO 'albumsrecordingsmap' VALUES (2797, 16, 257, 2797);
INSERT INTO 'albumsrecordingsmap' VALUES (2798, 8, 257, 2798);
INSERT INTO 'albumsrecordingsmap' VALUES (2799, 9, 257, 2799);
INSERT INTO 'albumsrecordingsmap' VALUES (2800, 10, 257, 2800);
INSERT INTO 'albumsrecordingsmap' VALUES (2801, 11, 257, 2801);
INSERT INTO 'albumsrecordingsmap' VALUES (2802, 12, 257, 2802);
INSERT INTO 'albumsrecordingsmap' VALUES (2803, 13, 257, 2803);
INSERT INTO 'albumsrecordingsmap' VALUES (2804, 14, 257, 2804);
INSERT INTO 'albumsrecordingsmap' VALUES (2805, 6, 257, 2805);
INSERT INTO 'albumsrecordingsmap' VALUES (2806, 1, 258, 2806);
INSERT INTO 'albumsrecordingsmap' VALUES (2807, 2, 258, 2807);
INSERT INTO 'albumsrecordingsmap' VALUES (2808, 3, 258, 2808);
INSERT INTO 'albumsrecordingsmap' VALUES (2809, 4, 258, 2809);
INSERT INTO 'albumsrecordingsmap' VALUES (2810, 5, 258, 2810);
INSERT INTO 'albumsrecordingsmap' VALUES (2811, 6, 258, 2811);
INSERT INTO 'albumsrecordingsmap' VALUES (2812, 7, 258, 2812);
INSERT INTO 'albumsrecordingsmap' VALUES (2813, 8, 258, 2813);
INSERT INTO 'albumsrecordingsmap' VALUES (2814, 9, 258, 2814);
INSERT INTO 'albumsrecordingsmap' VALUES (2815, 10, 258, 2815);
INSERT INTO 'albumsrecordingsmap' VALUES (2816, 11, 258, 2816);
INSERT INTO 'albumsrecordingsmap' VALUES (2817, 2, 259, 2817);
INSERT INTO 'albumsrecordingsmap' VALUES (2818, 13, 259, 2818);
INSERT INTO 'albumsrecordingsmap' VALUES (2819, 19, 259, 2819);
INSERT INTO 'albumsrecordingsmap' VALUES (2820, 16, 259, 2820);
INSERT INTO 'albumsrecordingsmap' VALUES (2821, 4, 259, 2821);
INSERT INTO 'albumsrecordingsmap' VALUES (2822, 1, 260, 2822);
INSERT INTO 'albumsrecordingsmap' VALUES (2823, 6, 260, 2823);
INSERT INTO 'albumsrecordingsmap' VALUES (2824, 10, 260, 2824);
INSERT INTO 'albumsrecordingsmap' VALUES (2825, 3, 204, 2825);
INSERT INTO 'albumsrecordingsmap' VALUES (2837, 9, 262, 2836);
INSERT INTO 'albumsrecordingsmap' VALUES (2838, 11, 262, 2837);
INSERT INTO 'albumsrecordingsmap' VALUES (2839, 3, 262, 2838);
INSERT INTO 'albumsrecordingsmap' VALUES (2840, 1, 263, 2839);
INSERT INTO 'albumsrecordingsmap' VALUES (2841, 2, 263, 2840);
INSERT INTO 'albumsrecordingsmap' VALUES (2842, 3, 263, 2841);
INSERT INTO 'albumsrecordingsmap' VALUES (2843, 4, 263, 2842);
INSERT INTO 'albumsrecordingsmap' VALUES (2844, 5, 263, 2843);
INSERT INTO 'albumsrecordingsmap' VALUES (2845, 6, 263, 2844);
INSERT INTO 'albumsrecordingsmap' VALUES (2846, 7, 263, 2845);
INSERT INTO 'albumsrecordingsmap' VALUES (2847, 8, 263, 2846);
INSERT INTO 'albumsrecordingsmap' VALUES (2848, 10, 263, 2847);
INSERT INTO 'albumsrecordingsmap' VALUES (2849, 9, 263, 2848);
INSERT INTO 'albumsrecordingsmap' VALUES (2850, 1, 264, 2849);
INSERT INTO 'albumsrecordingsmap' VALUES (2851, 2, 264, 2850);
INSERT INTO 'albumsrecordingsmap' VALUES (2852, 3, 264, 2851);
INSERT INTO 'albumsrecordingsmap' VALUES (2853, 4, 264, 2852);
INSERT INTO 'albumsrecordingsmap' VALUES (2854, 5, 264, 2853);
INSERT INTO 'albumsrecordingsmap' VALUES (2855, 6, 264, 2854);
INSERT INTO 'albumsrecordingsmap' VALUES (2856, 7, 264, 2855);
INSERT INTO 'albumsrecordingsmap' VALUES (2857, 8, 264, 2856);
INSERT INTO 'albumsrecordingsmap' VALUES (2858, 9, 264, 2857);
INSERT INTO 'albumsrecordingsmap' VALUES (2859, 10, 264, 2858);
INSERT INTO 'albumsrecordingsmap' VALUES (2860, 11, 264, 2859);
INSERT INTO 'albumsrecordingsmap' VALUES (2861, 4, 266, 2867);
INSERT INTO 'albumsrecordingsmap' VALUES (2862, 1, 266, 2864);
INSERT INTO 'albumsrecordingsmap' VALUES (2863, 2, 266, 2865);
INSERT INTO 'albumsrecordingsmap' VALUES (2864, 3, 266, 2866);
INSERT INTO 'albumsrecordingsmap' VALUES (2865, 5, 266, 2868);
INSERT INTO 'albumsrecordingsmap' VALUES (2866, 1, 267, 2869);
INSERT INTO 'albumsrecordingsmap' VALUES (2867, 2, 267, 2870);
INSERT INTO 'albumsrecordingsmap' VALUES (2868, 3, 267, 2871);
INSERT INTO 'albumsrecordingsmap' VALUES (2869, 4, 267, 2872);
INSERT INTO 'albumsrecordingsmap' VALUES (2870, 5, 267, 2873);
INSERT INTO 'albumsrecordingsmap' VALUES (2871, 6, 267, 2874);
INSERT INTO 'albumsrecordingsmap' VALUES (2872, 7, 267, 2875);
INSERT INTO 'albumsrecordingsmap' VALUES (2873, 8, 267, 2876);
INSERT INTO 'albumsrecordingsmap' VALUES (2874, 9, 267, 2877);
INSERT INTO 'albumsrecordingsmap' VALUES (2875, 10, 267, 2878);
INSERT INTO 'albumsrecordingsmap' VALUES (2876, 1, 91, 1451);
INSERT INTO 'albumsrecordingsmap' VALUES (2877, 2, 91, 2758);
INSERT INTO 'albumsrecordingsmap' VALUES (2878, 3, 91, 2759);
INSERT INTO 'albumsrecordingsmap' VALUES (2879, 4, 91, 2760);
INSERT INTO 'albumsrecordingsmap' VALUES (2696, 10, 208, 2699);
INSERT INTO 'albumsrecordingsmap' VALUES (2697, 2, 208, 2700);
INSERT INTO 'albumsrecordingsmap' VALUES (2698, 5, 208, 2701);
INSERT INTO 'albumsrecordingsmap' VALUES (2699, 11, 208, 2702);
INSERT INTO 'albumsrecordingsmap' VALUES (2700, 13, 208, 2703);
INSERT INTO 'albumsrecordingsmap' VALUES (2701, 8, 208, 2704);
INSERT INTO 'albumsrecordingsmap' VALUES (2702, 9, 208, 2705);
INSERT INTO 'albumsrecordingsmap' VALUES (2703, 12, 208, 2706);
INSERT INTO 'albumsrecordingsmap' VALUES (2880, 5, 91, 2761);
INSERT INTO 'albumsrecordingsmap' VALUES (2881, 6, 91, 2879);
INSERT INTO 'albumsrecordingsmap' VALUES (2882, 7, 91, 2880);
INSERT INTO 'albumsrecordingsmap' VALUES (2883, 8, 91, 2881);
INSERT INTO 'albumsrecordingsmap' VALUES (2884, 9, 91, 2882);
INSERT INTO 'albumsrecordingsmap' VALUES (2885, 10, 91, 2883);
INSERT INTO 'albumsrecordingsmap' VALUES (2886, 1, 253, 2884);
INSERT INTO 'albumsrecordingsmap' VALUES (2887, 2, 253, 2885);
INSERT INTO 'albumsrecordingsmap' VALUES (2888, 3, 253, 2886);
INSERT INTO 'albumsrecordingsmap' VALUES (2889, 4, 253, 2887);
INSERT INTO 'albumsrecordingsmap' VALUES (2890, 5, 253, 2888);
INSERT INTO 'albumsrecordingsmap' VALUES (2891, 6, 253, 2889);
INSERT INTO 'albumsrecordingsmap' VALUES (2892, 7, 253, 2890);
INSERT INTO 'albumsrecordingsmap' VALUES (2893, 8, 253, 2891);
INSERT INTO 'albumsrecordingsmap' VALUES (2894, 9, 253, 2892);
INSERT INTO 'albumsrecordingsmap' VALUES (2913, 1, 270, 2912);
INSERT INTO 'albumsrecordingsmap' VALUES (2914, 2, 270, 2913);
INSERT INTO 'albumsrecordingsmap' VALUES (2915, 3, 270, 2914);
INSERT INTO 'albumsrecordingsmap' VALUES (2916, 4, 270, 2915);
INSERT INTO 'albumsrecordingsmap' VALUES (2917, 5, 270, 2916);
INSERT INTO 'albumsrecordingsmap' VALUES (2918, 6, 270, 2917);
INSERT INTO 'albumsrecordingsmap' VALUES (2919, 7, 270, 2918);
INSERT INTO 'albumsrecordingsmap' VALUES (2920, 8, 270, 2919);
INSERT INTO 'albumsrecordingsmap' VALUES (2921, 9, 270, 2920);
INSERT INTO 'albumsrecordingsmap' VALUES (2922, 10, 270, 2921);
INSERT INTO 'albumsrecordingsmap' VALUES (2923, 11, 270, 2922);
INSERT INTO 'albumsrecordingsmap' VALUES (2924, 12, 270, 2923);
INSERT INTO 'albumsrecordingsmap' VALUES (2925, 1, 271, 2924);
INSERT INTO 'albumsrecordingsmap' VALUES (2926, 2, 271, 2925);
INSERT INTO 'albumsrecordingsmap' VALUES (2927, 3, 271, 2926);
INSERT INTO 'albumsrecordingsmap' VALUES (2928, 4, 271, 2927);
INSERT INTO 'albumsrecordingsmap' VALUES (2929, 5, 271, 2928);
INSERT INTO 'albumsrecordingsmap' VALUES (2930, 6, 271, 2929);
INSERT INTO 'albumsrecordingsmap' VALUES (2931, 7, 271, 2930);
INSERT INTO 'albumsrecordingsmap' VALUES (2932, 8, 271, 2931);
INSERT INTO 'albumsrecordingsmap' VALUES (2933, 9, 271, 2932);
INSERT INTO 'albumsrecordingsmap' VALUES (2934, 10, 271, 2933);
INSERT INTO 'albumsrecordingsmap' VALUES (2935, 11, 271, 2934);
INSERT INTO 'albumsrecordingsmap' VALUES (2936, 12, 271, 2935);
INSERT INTO 'albumsrecordingsmap' VALUES (2937, 13, 271, 2936);
INSERT INTO 'albumsrecordingsmap' VALUES (2938, 1, 272, 2937);
INSERT INTO 'albumsrecordingsmap' VALUES (2939, 6, 272, 2938);
INSERT INTO 'albumsrecordingsmap' VALUES (2940, 11, 272, 2939);
INSERT INTO 'albumsrecordingsmap' VALUES (2941, 12, 272, 2940);
INSERT INTO 'albumsrecordingsmap' VALUES (2942, 3, 272, 2941);
INSERT INTO 'albumsrecordingsmap' VALUES (2943, 5, 272, 2942);
INSERT INTO 'albumsrecordingsmap' VALUES (2944, 7, 272, 2943);
INSERT INTO 'albumsrecordingsmap' VALUES (2945, 8, 272, 2944);
INSERT INTO 'albumsrecordingsmap' VALUES (2946, 9, 272, 2945);
INSERT INTO 'albumsrecordingsmap' VALUES (2947, 10, 272, 2946);
INSERT INTO 'albumsrecordingsmap' VALUES (2948, 2, 272, 2947);
INSERT INTO 'albumsrecordingsmap' VALUES (2949, 4, 272, 2948);
INSERT INTO 'albumsrecordingsmap' VALUES (2950, 1, 273, 2949);
INSERT INTO 'albumsrecordingsmap' VALUES (2951, 2, 273, 2950);
INSERT INTO 'albumsrecordingsmap' VALUES (2952, 3, 273, 2951);
INSERT INTO 'albumsrecordingsmap' VALUES (2907, 1, 269, 9689);
INSERT INTO 'albumsrecordingsmap' VALUES (2953, 4, 273, 2952);
INSERT INTO 'albumsrecordingsmap' VALUES (2954, 5, 273, 2953);
INSERT INTO 'albumsrecordingsmap' VALUES (2955, 6, 273, 2954);
INSERT INTO 'albumsrecordingsmap' VALUES (2956, 7, 273, 2955);
INSERT INTO 'albumsrecordingsmap' VALUES (2957, 8, 273, 2956);
INSERT INTO 'albumsrecordingsmap' VALUES (2958, 1, 274, 2957);
INSERT INTO 'albumsrecordingsmap' VALUES (2959, 2, 274, 2958);
INSERT INTO 'albumsrecordingsmap' VALUES (2960, 3, 274, 2959);
INSERT INTO 'albumsrecordingsmap' VALUES (2961, 4, 274, 2960);
INSERT INTO 'albumsrecordingsmap' VALUES (2962, 5, 274, 2961);
INSERT INTO 'albumsrecordingsmap' VALUES (2963, 6, 274, 2962);
INSERT INTO 'albumsrecordingsmap' VALUES (2964, 7, 274, 2963);
INSERT INTO 'albumsrecordingsmap' VALUES (2965, 8, 274, 2964);
INSERT INTO 'albumsrecordingsmap' VALUES (2966, 9, 274, 2965);
INSERT INTO 'albumsrecordingsmap' VALUES (2967, 10, 274, 2966);
INSERT INTO 'albumsrecordingsmap' VALUES (2968, 1, 275, 2967);
INSERT INTO 'albumsrecordingsmap' VALUES (2969, 2, 275, 2968);
INSERT INTO 'albumsrecordingsmap' VALUES (2970, 3, 275, 2969);
INSERT INTO 'albumsrecordingsmap' VALUES (2971, 4, 275, 2970);
INSERT INTO 'albumsrecordingsmap' VALUES (2972, 5, 275, 2971);
INSERT INTO 'albumsrecordingsmap' VALUES (2973, 6, 275, 2972);
INSERT INTO 'albumsrecordingsmap' VALUES (2974, 7, 275, 2973);
INSERT INTO 'albumsrecordingsmap' VALUES (2975, 1, 276, 2974);
INSERT INTO 'albumsrecordingsmap' VALUES (2976, 2, 276, 2975);
INSERT INTO 'albumsrecordingsmap' VALUES (2977, 5, 276, 2976);
INSERT INTO 'albumsrecordingsmap' VALUES (2978, 7, 276, 2977);
INSERT INTO 'albumsrecordingsmap' VALUES (2979, 8, 276, 2978);
INSERT INTO 'albumsrecordingsmap' VALUES (2980, 12, 276, 2979);
INSERT INTO 'albumsrecordingsmap' VALUES (2981, 14, 276, 2980);
INSERT INTO 'albumsrecordingsmap' VALUES (2982, 3, 277, 2981);
INSERT INTO 'albumsrecordingsmap' VALUES (2983, 1, 277, 2982);
INSERT INTO 'albumsrecordingsmap' VALUES (2984, 2, 277, 2983);
INSERT INTO 'albumsrecordingsmap' VALUES (2985, 4, 277, 2984);
INSERT INTO 'albumsrecordingsmap' VALUES (2986, 5, 277, 2985);
INSERT INTO 'albumsrecordingsmap' VALUES (2987, 6, 277, 2986);
INSERT INTO 'albumsrecordingsmap' VALUES (2988, 7, 277, 2987);
INSERT INTO 'albumsrecordingsmap' VALUES (2989, 8, 277, 2988);
INSERT INTO 'albumsrecordingsmap' VALUES (2990, 9, 277, 2989);
INSERT INTO 'albumsrecordingsmap' VALUES (2991, 10, 277, 2990);
INSERT INTO 'albumsrecordingsmap' VALUES (2992, 11, 277, 2991);
INSERT INTO 'albumsrecordingsmap' VALUES (2993, 1, 278, 2992);
INSERT INTO 'albumsrecordingsmap' VALUES (2994, 2, 278, 2993);
INSERT INTO 'albumsrecordingsmap' VALUES (2995, 3, 278, 2994);
INSERT INTO 'albumsrecordingsmap' VALUES (2996, 4, 278, 2995);
INSERT INTO 'albumsrecordingsmap' VALUES (2997, 5, 278, 2996);
INSERT INTO 'albumsrecordingsmap' VALUES (2998, 6, 278, 2997);
INSERT INTO 'albumsrecordingsmap' VALUES (2999, 7, 278, 2998);
INSERT INTO 'albumsrecordingsmap' VALUES (3000, 8, 278, 2999);
INSERT INTO 'albumsrecordingsmap' VALUES (3001, 1, 279, 3000);
INSERT INTO 'albumsrecordingsmap' VALUES (3002, 2, 279, 3001);
INSERT INTO 'albumsrecordingsmap' VALUES (3003, 3, 279, 3002);
INSERT INTO 'albumsrecordingsmap' VALUES (3004, 4, 279, 3003);
INSERT INTO 'albumsrecordingsmap' VALUES (3005, 5, 279, 3004);
INSERT INTO 'albumsrecordingsmap' VALUES (3006, 6, 279, 3005);
INSERT INTO 'albumsrecordingsmap' VALUES (3007, 7, 279, 3006);
INSERT INTO 'albumsrecordingsmap' VALUES (3008, 8, 279, 3007);
INSERT INTO 'albumsrecordingsmap' VALUES (3009, 9, 279, 3008);
INSERT INTO 'albumsrecordingsmap' VALUES (3010, 10, 279, 3009);
INSERT INTO 'albumsrecordingsmap' VALUES (3011, 11, 279, 3010);
INSERT INTO 'albumsrecordingsmap' VALUES (3012, 1, 280, 3011);
INSERT INTO 'albumsrecordingsmap' VALUES (3013, 2, 280, 3012);
INSERT INTO 'albumsrecordingsmap' VALUES (3014, 3, 280, 3013);
INSERT INTO 'albumsrecordingsmap' VALUES (3015, 4, 280, 3014);
INSERT INTO 'albumsrecordingsmap' VALUES (3016, 5, 280, 3015);
INSERT INTO 'albumsrecordingsmap' VALUES (3017, 6, 280, 3016);
INSERT INTO 'albumsrecordingsmap' VALUES (3018, 7, 280, 3017);
INSERT INTO 'albumsrecordingsmap' VALUES (3019, 8, 280, 3018);
INSERT INTO 'albumsrecordingsmap' VALUES (3029, 1, 283, 3040);
INSERT INTO 'albumsrecordingsmap' VALUES (3030, 3, 283, 3041);
INSERT INTO 'albumsrecordingsmap' VALUES (3031, 6, 283, 3042);
INSERT INTO 'albumsrecordingsmap' VALUES (3032, 7, 283, 3043);
INSERT INTO 'albumsrecordingsmap' VALUES (3033, 8, 283, 3044);
INSERT INTO 'albumsrecordingsmap' VALUES (3034, 12, 283, 3045);
INSERT INTO 'albumsrecordingsmap' VALUES (3035, 1, 284, 3046);
INSERT INTO 'albumsrecordingsmap' VALUES (3036, 2, 284, 3047);
INSERT INTO 'albumsrecordingsmap' VALUES (3037, 3, 284, 3048);
INSERT INTO 'albumsrecordingsmap' VALUES (3038, 4, 284, 3049);
INSERT INTO 'albumsrecordingsmap' VALUES (3039, 5, 284, 3050);
INSERT INTO 'albumsrecordingsmap' VALUES (3040, 6, 284, 3051);
INSERT INTO 'albumsrecordingsmap' VALUES (3041, 7, 284, 3052);
INSERT INTO 'albumsrecordingsmap' VALUES (3042, 8, 284, 3053);
INSERT INTO 'albumsrecordingsmap' VALUES (3043, 9, 284, 3054);
INSERT INTO 'albumsrecordingsmap' VALUES (3044, 10, 284, 3055);
INSERT INTO 'albumsrecordingsmap' VALUES (3045, 1, 285, 3056);
INSERT INTO 'albumsrecordingsmap' VALUES (3046, 2, 285, 3057);
INSERT INTO 'albumsrecordingsmap' VALUES (3047, 3, 285, 3058);
INSERT INTO 'albumsrecordingsmap' VALUES (3048, 4, 285, 3059);
INSERT INTO 'albumsrecordingsmap' VALUES (3049, 5, 285, 3060);
INSERT INTO 'albumsrecordingsmap' VALUES (3050, 6, 285, 3061);
INSERT INTO 'albumsrecordingsmap' VALUES (3051, 7, 285, 3062);
INSERT INTO 'albumsrecordingsmap' VALUES (3052, 8, 285, 3063);
INSERT INTO 'albumsrecordingsmap' VALUES (3053, 9, 285, 3064);
INSERT INTO 'albumsrecordingsmap' VALUES (3054, 10, 285, 3065);
INSERT INTO 'albumsrecordingsmap' VALUES (3055, 1, 286, 3066);
INSERT INTO 'albumsrecordingsmap' VALUES (3056, 2, 286, 3067);
INSERT INTO 'albumsrecordingsmap' VALUES (3057, 3, 286, 3068);
INSERT INTO 'albumsrecordingsmap' VALUES (3058, 4, 286, 3069);
INSERT INTO 'albumsrecordingsmap' VALUES (3059, 5, 286, 3070);
INSERT INTO 'albumsrecordingsmap' VALUES (3060, 6, 286, 3071);
INSERT INTO 'albumsrecordingsmap' VALUES (3061, 7, 286, 3072);
INSERT INTO 'albumsrecordingsmap' VALUES (3062, 8, 286, 3073);
INSERT INTO 'albumsrecordingsmap' VALUES (3063, 9, 286, 3074);
INSERT INTO 'albumsrecordingsmap' VALUES (3064, 10, 286, 3075);
INSERT INTO 'albumsrecordingsmap' VALUES (3065, 11, 286, 3076);
INSERT INTO 'albumsrecordingsmap' VALUES (3066, 12, 286, 3077);
INSERT INTO 'albumsrecordingsmap' VALUES (3068, 1, 287, 3079);
INSERT INTO 'albumsrecordingsmap' VALUES (3069, 2, 287, 3080);
INSERT INTO 'albumsrecordingsmap' VALUES (3070, 3, 287, 3081);
INSERT INTO 'albumsrecordingsmap' VALUES (3077, 1, 289, 3090);
INSERT INTO 'albumsrecordingsmap' VALUES (3078, 2, 289, 3091);
INSERT INTO 'albumsrecordingsmap' VALUES (3079, 3, 289, 3092);
INSERT INTO 'albumsrecordingsmap' VALUES (3080, 4, 289, 3093);
INSERT INTO 'albumsrecordingsmap' VALUES (3081, 5, 289, 3094);
INSERT INTO 'albumsrecordingsmap' VALUES (3082, 6, 289, 3095);
INSERT INTO 'albumsrecordingsmap' VALUES (3083, 7, 289, 3096);
INSERT INTO 'albumsrecordingsmap' VALUES (3084, 8, 289, 3097);
INSERT INTO 'albumsrecordingsmap' VALUES (3085, 9, 289, 3098);
INSERT INTO 'albumsrecordingsmap' VALUES (3086, 10, 289, 3099);
INSERT INTO 'albumsrecordingsmap' VALUES (3087, 11, 289, 3100);
INSERT INTO 'albumsrecordingsmap' VALUES (3088, 1, 282, 2366);
INSERT INTO 'albumsrecordingsmap' VALUES (3089, 2, 282, 2474);
INSERT INTO 'albumsrecordingsmap' VALUES (3090, 4, 282, 3029);
INSERT INTO 'albumsrecordingsmap' VALUES (3091, 5, 282, 3030);
INSERT INTO 'albumsrecordingsmap' VALUES (3092, 6, 282, 3031);
INSERT INTO 'albumsrecordingsmap' VALUES (3093, 9, 282, 3034);
INSERT INTO 'albumsrecordingsmap' VALUES (3094, 10, 282, 3035);
INSERT INTO 'albumsrecordingsmap' VALUES (3095, 1, 290, 3037);
INSERT INTO 'albumsrecordingsmap' VALUES (3096, 2, 290, 3038);
INSERT INTO 'albumsrecordingsmap' VALUES (3097, 3, 290, 3039);
INSERT INTO 'albumsrecordingsmap' VALUES (3098, 4, 290, 3101);
INSERT INTO 'albumsrecordingsmap' VALUES (3099, 5, 290, 3102);
INSERT INTO 'albumsrecordingsmap' VALUES (3100, 6, 290, 3103);
INSERT INTO 'albumsrecordingsmap' VALUES (3101, 7, 290, 3104);
INSERT INTO 'albumsrecordingsmap' VALUES (3102, 9, 290, 3106);
INSERT INTO 'albumsrecordingsmap' VALUES (3103, 10, 290, 3107);
INSERT INTO 'albumsrecordingsmap' VALUES (3104, 11, 290, 3108);
INSERT INTO 'albumsrecordingsmap' VALUES (3105, 1, 291, 3109);
INSERT INTO 'albumsrecordingsmap' VALUES (3106, 2, 291, 3110);
INSERT INTO 'albumsrecordingsmap' VALUES (3107, 4, 291, 3111);
INSERT INTO 'albumsrecordingsmap' VALUES (3108, 5, 291, 525);
INSERT INTO 'albumsrecordingsmap' VALUES (3109, 6, 291, 531);
INSERT INTO 'albumsrecordingsmap' VALUES (3110, 10, 291, 528);
INSERT INTO 'albumsrecordingsmap' VALUES (3111, 7, 291, 3031);
INSERT INTO 'albumsrecordingsmap' VALUES (3112, 9, 291, 3114);
INSERT INTO 'albumsrecordingsmap' VALUES (3113, 3, 292, 3116);
INSERT INTO 'albumsrecordingsmap' VALUES (3114, 4, 292, 3117);
INSERT INTO 'albumsrecordingsmap' VALUES (3115, 5, 292, 3118);
INSERT INTO 'albumsrecordingsmap' VALUES (3116, 6, 292, 3119);
INSERT INTO 'albumsrecordingsmap' VALUES (3117, 7, 292, 3120);
INSERT INTO 'albumsrecordingsmap' VALUES (3118, 8, 292, 3121);
INSERT INTO 'albumsrecordingsmap' VALUES (3119, 9, 292, 3122);
INSERT INTO 'albumsrecordingsmap' VALUES (3120, 10, 292, 3123);
INSERT INTO 'albumsrecordingsmap' VALUES (3121, 11, 292, 3124);
INSERT INTO 'albumsrecordingsmap' VALUES (3122, 12, 292, 3125);
INSERT INTO 'albumsrecordingsmap' VALUES (3123, 13, 292, 3126);
INSERT INTO 'albumsrecordingsmap' VALUES (3133, 1, 294, 3136);
INSERT INTO 'albumsrecordingsmap' VALUES (3134, 2, 294, 3137);
INSERT INTO 'albumsrecordingsmap' VALUES (3135, 3, 294, 3138);
INSERT INTO 'albumsrecordingsmap' VALUES (3136, 4, 294, 3139);
INSERT INTO 'albumsrecordingsmap' VALUES (3137, 5, 294, 3140);
INSERT INTO 'albumsrecordingsmap' VALUES (3138, 6, 294, 3141);
INSERT INTO 'albumsrecordingsmap' VALUES (3139, 7, 294, 3142);
INSERT INTO 'albumsrecordingsmap' VALUES (3140, 1, 295, 3143);
INSERT INTO 'albumsrecordingsmap' VALUES (3141, 2, 295, 3144);
INSERT INTO 'albumsrecordingsmap' VALUES (3142, 3, 295, 3145);
INSERT INTO 'albumsrecordingsmap' VALUES (3143, 4, 295, 3146);
INSERT INTO 'albumsrecordingsmap' VALUES (3144, 5, 295, 3147);
INSERT INTO 'albumsrecordingsmap' VALUES (3145, 6, 295, 3148);
INSERT INTO 'albumsrecordingsmap' VALUES (3146, 7, 295, 3149);
INSERT INTO 'albumsrecordingsmap' VALUES (3147, 8, 295, 3150);
INSERT INTO 'albumsrecordingsmap' VALUES (3148, 2, 144, 3151);
INSERT INTO 'albumsrecordingsmap' VALUES (3149, 1, 296, 3152);
INSERT INTO 'albumsrecordingsmap' VALUES (3150, 2, 296, 3153);
INSERT INTO 'albumsrecordingsmap' VALUES (3151, 3, 296, 3154);
INSERT INTO 'albumsrecordingsmap' VALUES (3152, 4, 296, 3155);
INSERT INTO 'albumsrecordingsmap' VALUES (3153, 5, 296, 3156);
INSERT INTO 'albumsrecordingsmap' VALUES (3154, 6, 296, 3157);
INSERT INTO 'albumsrecordingsmap' VALUES (3155, 1, 297, 2372);
INSERT INTO 'albumsrecordingsmap' VALUES (3156, 2, 297, 3094);
INSERT INTO 'albumsrecordingsmap' VALUES (3157, 3, 297, 3093);
INSERT INTO 'albumsrecordingsmap' VALUES (3158, 4, 297, 3099);
INSERT INTO 'albumsrecordingsmap' VALUES (3159, 5, 297, 3095);
INSERT INTO 'albumsrecordingsmap' VALUES (3160, 6, 297, 2368);
INSERT INTO 'albumsrecordingsmap' VALUES (3161, 7, 297, 3090);
INSERT INTO 'albumsrecordingsmap' VALUES (3162, 8, 297, 1595);
INSERT INTO 'albumsrecordingsmap' VALUES (3163, 9, 297, 1600);
INSERT INTO 'albumsrecordingsmap' VALUES (3164, 10, 297, 3056);
INSERT INTO 'albumsrecordingsmap' VALUES (3165, 11, 297, 3064);
INSERT INTO 'albumsrecordingsmap' VALUES (3166, 12, 297, 1596);
INSERT INTO 'albumsrecordingsmap' VALUES (3167, 8, 290, 19);
INSERT INTO 'albumsrecordingsmap' VALUES (3168, 9, 33, 93);
INSERT INTO 'albumsrecordingsmap' VALUES (3169, 7, 33, 126);
INSERT INTO 'albumsrecordingsmap' VALUES (3170, 11, 282, 168);
INSERT INTO 'albumsrecordingsmap' VALUES (3171, 12, 24, 2366);
INSERT INTO 'albumsrecordingsmap' VALUES (3172, 3, 282, 225);
INSERT INTO 'albumsrecordingsmap' VALUES (3173, 1, 298, 209);
INSERT INTO 'albumsrecordingsmap' VALUES (3174, 2, 298, 530);
INSERT INTO 'albumsrecordingsmap' VALUES (3175, 3, 298, 532);
INSERT INTO 'albumsrecordingsmap' VALUES (3176, 4, 298, 3028);
INSERT INTO 'albumsrecordingsmap' VALUES (3177, 2, 265, 1779);
INSERT INTO 'albumsrecordingsmap' VALUES (3178, 12, 134, 31);
INSERT INTO 'albumsrecordingsmap' VALUES (3179, 3, 8, 2427);
INSERT INTO 'albumsrecordingsmap' VALUES (3180, 1, 300, 3159);
INSERT INTO 'albumsrecordingsmap' VALUES (3181, 2, 300, 3160);
INSERT INTO 'albumsrecordingsmap' VALUES (3182, 3, 300, 3161);
INSERT INTO 'albumsrecordingsmap' VALUES (3183, 4, 300, 3162);
INSERT INTO 'albumsrecordingsmap' VALUES (3184, 5, 300, 3163);
INSERT INTO 'albumsrecordingsmap' VALUES (3185, 6, 300, 3164);
INSERT INTO 'albumsrecordingsmap' VALUES (3186, 7, 300, 3165);
INSERT INTO 'albumsrecordingsmap' VALUES (3187, 3, 301, 3166);
INSERT INTO 'albumsrecordingsmap' VALUES (3188, 6, 301, 3167);
INSERT INTO 'albumsrecordingsmap' VALUES (3189, 11, 301, 3168);
INSERT INTO 'albumsrecordingsmap' VALUES (3190, 1, 302, 3169);
INSERT INTO 'albumsrecordingsmap' VALUES (3191, 2, 302, 3170);
INSERT INTO 'albumsrecordingsmap' VALUES (3192, 3, 302, 3171);
INSERT INTO 'albumsrecordingsmap' VALUES (3193, 4, 302, 3172);
INSERT INTO 'albumsrecordingsmap' VALUES (3194, 6, 302, 1159);
INSERT INTO 'albumsrecordingsmap' VALUES (3195, 7, 302, 1161);
INSERT INTO 'albumsrecordingsmap' VALUES (3196, 8, 302, 1168);
INSERT INTO 'albumsrecordingsmap' VALUES (3071, 1, 833, 3082);
INSERT INTO 'albumsrecordingsmap' VALUES (3197, 9, 302, 2430);
INSERT INTO 'albumsrecordingsmap' VALUES (3198, 10, 302, 2476);
INSERT INTO 'albumsrecordingsmap' VALUES (3199, 1, 299, 2861);
INSERT INTO 'albumsrecordingsmap' VALUES (3200, 5, 299, 3174);
INSERT INTO 'albumsrecordingsmap' VALUES (3201, 2, 299, 3036);
INSERT INTO 'albumsrecordingsmap' VALUES (3202, 3, 299, 3158);
INSERT INTO 'albumsrecordingsmap' VALUES (3203, 4, 299, 3173);
INSERT INTO 'albumsrecordingsmap' VALUES (3204, 6, 299, 3175);
INSERT INTO 'albumsrecordingsmap' VALUES (3205, 7, 299, 3176);
INSERT INTO 'albumsrecordingsmap' VALUES (3206, 8, 299, 3177);
INSERT INTO 'albumsrecordingsmap' VALUES (3207, 9, 299, 3178);
INSERT INTO 'albumsrecordingsmap' VALUES (3208, 1, 303, 3179);
INSERT INTO 'albumsrecordingsmap' VALUES (3209, 2, 303, 3180);
INSERT INTO 'albumsrecordingsmap' VALUES (3210, 3, 303, 3181);
INSERT INTO 'albumsrecordingsmap' VALUES (3211, 4, 303, 3182);
INSERT INTO 'albumsrecordingsmap' VALUES (3212, 5, 303, 3183);
INSERT INTO 'albumsrecordingsmap' VALUES (3213, 6, 303, 3184);
INSERT INTO 'albumsrecordingsmap' VALUES (3214, 7, 303, 3185);
INSERT INTO 'albumsrecordingsmap' VALUES (3215, 8, 303, 3186);
INSERT INTO 'albumsrecordingsmap' VALUES (3216, 9, 303, 3187);
INSERT INTO 'albumsrecordingsmap' VALUES (3217, 10, 303, 3188);
INSERT INTO 'albumsrecordingsmap' VALUES (3218, 2, 304, 1962);
INSERT INTO 'albumsrecordingsmap' VALUES (3219, 3, 304, 3189);
INSERT INTO 'albumsrecordingsmap' VALUES (3220, 5, 304, 3190);
INSERT INTO 'albumsrecordingsmap' VALUES (3221, 6, 304, 3191);
INSERT INTO 'albumsrecordingsmap' VALUES (3222, 8, 304, 3192);
INSERT INTO 'albumsrecordingsmap' VALUES (3223, 7, 282, 159);
INSERT INTO 'albumsrecordingsmap' VALUES (3224, 1, 305, 3193);
INSERT INTO 'albumsrecordingsmap' VALUES (3225, 2, 305, 3194);
INSERT INTO 'albumsrecordingsmap' VALUES (3226, 3, 305, 3195);
INSERT INTO 'albumsrecordingsmap' VALUES (3227, 4, 305, 3196);
INSERT INTO 'albumsrecordingsmap' VALUES (3228, 6, 305, 3197);
INSERT INTO 'albumsrecordingsmap' VALUES (3229, 9, 305, 3198);
INSERT INTO 'albumsrecordingsmap' VALUES (3230, 8, 305, 3199);
INSERT INTO 'albumsrecordingsmap' VALUES (3232, 1, 306, 3201);
INSERT INTO 'albumsrecordingsmap' VALUES (3233, 2, 306, 3202);
INSERT INTO 'albumsrecordingsmap' VALUES (3234, 4, 306, 3203);
INSERT INTO 'albumsrecordingsmap' VALUES (3235, 5, 306, 3204);
INSERT INTO 'albumsrecordingsmap' VALUES (3236, 6, 306, 3205);
INSERT INTO 'albumsrecordingsmap' VALUES (3237, 7, 306, 3206);
INSERT INTO 'albumsrecordingsmap' VALUES (3238, 8, 306, 3207);
INSERT INTO 'albumsrecordingsmap' VALUES (3239, 9, 306, 3208);
INSERT INTO 'albumsrecordingsmap' VALUES (3240, 10, 306, 3209);
INSERT INTO 'albumsrecordingsmap' VALUES (3241, 11, 306, 3210);
INSERT INTO 'albumsrecordingsmap' VALUES (3242, 12, 306, 3211);
INSERT INTO 'albumsrecordingsmap' VALUES (3243, 6, 309, 3217);
INSERT INTO 'albumsrecordingsmap' VALUES (3244, 1, 309, 3212);
INSERT INTO 'albumsrecordingsmap' VALUES (3245, 2, 309, 3213);
INSERT INTO 'albumsrecordingsmap' VALUES (3246, 3, 309, 3214);
INSERT INTO 'albumsrecordingsmap' VALUES (3247, 4, 309, 3215);
INSERT INTO 'albumsrecordingsmap' VALUES (3248, 5, 309, 3216);
INSERT INTO 'albumsrecordingsmap' VALUES (3249, 7, 309, 3218);
INSERT INTO 'albumsrecordingsmap' VALUES (3250, 10, 309, 3219);
INSERT INTO 'albumsrecordingsmap' VALUES (3251, 12, 309, 3220);
INSERT INTO 'albumsrecordingsmap' VALUES (3252, 16, 309, 3221);
INSERT INTO 'albumsrecordingsmap' VALUES (3253, 17, 309, 3222);
INSERT INTO 'albumsrecordingsmap' VALUES (3254, 1, 824, 3228);
INSERT INTO 'albumsrecordingsmap' VALUES (3255, 2, 824, 3229);
INSERT INTO 'albumsrecordingsmap' VALUES (3256, 3, 824, 3230);
INSERT INTO 'albumsrecordingsmap' VALUES (3257, 4, 824, 3231);
INSERT INTO 'albumsrecordingsmap' VALUES (3258, 5, 824, 3232);
INSERT INTO 'albumsrecordingsmap' VALUES (3259, 6, 824, 3233);
INSERT INTO 'albumsrecordingsmap' VALUES (3260, 7, 824, 3234);
INSERT INTO 'albumsrecordingsmap' VALUES (3261, 8, 824, 3235);
INSERT INTO 'albumsrecordingsmap' VALUES (3262, 9, 824, 3236);
INSERT INTO 'albumsrecordingsmap' VALUES (3263, 10, 824, 3237);
INSERT INTO 'albumsrecordingsmap' VALUES (3264, 1, 314, 3238);
INSERT INTO 'albumsrecordingsmap' VALUES (3265, 2, 314, 3239);
INSERT INTO 'albumsrecordingsmap' VALUES (3266, 3, 314, 3240);
INSERT INTO 'albumsrecordingsmap' VALUES (3267, 4, 314, 3241);
INSERT INTO 'albumsrecordingsmap' VALUES (3268, 5, 314, 3242);
INSERT INTO 'albumsrecordingsmap' VALUES (6245, 11, 455, 5757);
INSERT INTO 'albumsrecordingsmap' VALUES (10790, 11, 1111, 10196);
INSERT INTO 'albumsrecordingsmap' VALUES (6246, 12, 455, 5758);
INSERT INTO 'albumsrecordingsmap' VALUES (6247, 13, 455, 5759);
INSERT INTO 'albumsrecordingsmap' VALUES (3274, 1, 316, 3248);
INSERT INTO 'albumsrecordingsmap' VALUES (3275, 2, 316, 3249);
INSERT INTO 'albumsrecordingsmap' VALUES (3276, 3, 316, 3250);
INSERT INTO 'albumsrecordingsmap' VALUES (3277, 4, 316, 3251);
INSERT INTO 'albumsrecordingsmap' VALUES (3278, 5, 316, 3252);
INSERT INTO 'albumsrecordingsmap' VALUES (3279, 6, 316, 3253);
INSERT INTO 'albumsrecordingsmap' VALUES (3280, 7, 316, 3254);
INSERT INTO 'albumsrecordingsmap' VALUES (3281, 8, 316, 3255);
INSERT INTO 'albumsrecordingsmap' VALUES (3282, 9, 316, 3256);
INSERT INTO 'albumsrecordingsmap' VALUES (3283, 10, 316, 3257);
INSERT INTO 'albumsrecordingsmap' VALUES (3284, 2, 307, 3223);
INSERT INTO 'albumsrecordingsmap' VALUES (3285, 3, 307, 3224);
INSERT INTO 'albumsrecordingsmap' VALUES (3286, 4, 307, 3225);
INSERT INTO 'albumsrecordingsmap' VALUES (3287, 5, 307, 3226);
INSERT INTO 'albumsrecordingsmap' VALUES (3288, 6, 307, 3227);
INSERT INTO 'albumsrecordingsmap' VALUES (3289, 1, 307, 3032);
INSERT INTO 'albumsrecordingsmap' VALUES (3290, 7, 307, 3258);
INSERT INTO 'albumsrecordingsmap' VALUES (3291, 8, 307, 3259);
INSERT INTO 'albumsrecordingsmap' VALUES (3292, 9, 307, 3260);
INSERT INTO 'albumsrecordingsmap' VALUES (3293, 10, 307, 3261);
INSERT INTO 'albumsrecordingsmap' VALUES (3294, 11, 307, 3262);
INSERT INTO 'albumsrecordingsmap' VALUES (3295, 10, 25, 3263);
INSERT INTO 'albumsrecordingsmap' VALUES (3296, 3, 123, 1402);
INSERT INTO 'albumsrecordingsmap' VALUES (3297, 6, 9, 2429);
INSERT INTO 'albumsrecordingsmap' VALUES (3298, 1, 9, 2428);
INSERT INTO 'albumsrecordingsmap' VALUES (3299, 11, 134, 162);
INSERT INTO 'albumsrecordingsmap' VALUES (3300, 7, 134, 219);
INSERT INTO 'albumsrecordingsmap' VALUES (3313, 1, 383, 120);
INSERT INTO 'albumsrecordingsmap' VALUES (3314, 2, 383, 146);
INSERT INTO 'albumsrecordingsmap' VALUES (3315, 3, 383, 2423);
INSERT INTO 'albumsrecordingsmap' VALUES (3316, 4, 383, 2426);
INSERT INTO 'albumsrecordingsmap' VALUES (3317, 5, 383, 3264);
INSERT INTO 'albumsrecordingsmap' VALUES (3318, 6, 383, 3265);
INSERT INTO 'albumsrecordingsmap' VALUES (3319, 7, 383, 3266);
INSERT INTO 'albumsrecordingsmap' VALUES (3320, 8, 383, 3267);
INSERT INTO 'albumsrecordingsmap' VALUES (3321, 9, 383, 3268);
INSERT INTO 'albumsrecordingsmap' VALUES (3322, 10, 383, 3269);
INSERT INTO 'albumsrecordingsmap' VALUES (3323, 11, 383, 3270);
INSERT INTO 'albumsrecordingsmap' VALUES (3324, 1, 847, 3271);
INSERT INTO 'albumsrecordingsmap' VALUES (3325, 2, 847, 3272);
INSERT INTO 'albumsrecordingsmap' VALUES (3326, 3, 847, 3273);
INSERT INTO 'albumsrecordingsmap' VALUES (3327, 4, 847, 3274);
INSERT INTO 'albumsrecordingsmap' VALUES (3328, 5, 847, 3275);
INSERT INTO 'albumsrecordingsmap' VALUES (3329, 6, 847, 3276);
INSERT INTO 'albumsrecordingsmap' VALUES (3330, 7, 847, 3277);
INSERT INTO 'albumsrecordingsmap' VALUES (3331, 8, 847, 3278);
INSERT INTO 'albumsrecordingsmap' VALUES (3332, 9, 847, 3279);
INSERT INTO 'albumsrecordingsmap' VALUES (3333, 10, 847, 3280);
INSERT INTO 'albumsrecordingsmap' VALUES (3334, 11, 847, 3281);
INSERT INTO 'albumsrecordingsmap' VALUES (3335, 12, 847, 3282);
INSERT INTO 'albumsrecordingsmap' VALUES (3336, 1, 756, 3283);
INSERT INTO 'albumsrecordingsmap' VALUES (3337, 2, 756, 3284);
INSERT INTO 'albumsrecordingsmap' VALUES (3338, 3, 756, 3285);
INSERT INTO 'albumsrecordingsmap' VALUES (3339, 4, 756, 3286);
INSERT INTO 'albumsrecordingsmap' VALUES (3340, 5, 756, 3287);
INSERT INTO 'albumsrecordingsmap' VALUES (3341, 6, 756, 3288);
INSERT INTO 'albumsrecordingsmap' VALUES (3342, 1, 705, 3289);
INSERT INTO 'albumsrecordingsmap' VALUES (3343, 2, 705, 3290);
INSERT INTO 'albumsrecordingsmap' VALUES (3344, 3, 705, 3291);
INSERT INTO 'albumsrecordingsmap' VALUES (3345, 4, 705, 3292);
INSERT INTO 'albumsrecordingsmap' VALUES (3346, 5, 705, 3293);
INSERT INTO 'albumsrecordingsmap' VALUES (3347, 6, 705, 3294);
INSERT INTO 'albumsrecordingsmap' VALUES (3348, 7, 705, 3295);
INSERT INTO 'albumsrecordingsmap' VALUES (3349, 8, 705, 3296);
INSERT INTO 'albumsrecordingsmap' VALUES (3350, 9, 705, 3297);
INSERT INTO 'albumsrecordingsmap' VALUES (3351, 10, 705, 3298);
INSERT INTO 'albumsrecordingsmap' VALUES (3352, 11, 705, 3299);
INSERT INTO 'albumsrecordingsmap' VALUES (3353, 12, 705, 3300);
INSERT INTO 'albumsrecordingsmap' VALUES (3354, 13, 705, 3301);
INSERT INTO 'albumsrecordingsmap' VALUES (3355, 14, 705, 3302);
INSERT INTO 'albumsrecordingsmap' VALUES (3356, 15, 705, 3303);
INSERT INTO 'albumsrecordingsmap' VALUES (3357, 1, 385, 3304);
INSERT INTO 'albumsrecordingsmap' VALUES (3358, 2, 385, 3305);
INSERT INTO 'albumsrecordingsmap' VALUES (3359, 3, 385, 3306);
INSERT INTO 'albumsrecordingsmap' VALUES (3360, 4, 385, 3307);
INSERT INTO 'albumsrecordingsmap' VALUES (3361, 6, 385, 3308);
INSERT INTO 'albumsrecordingsmap' VALUES (3362, 7, 385, 3309);
INSERT INTO 'albumsrecordingsmap' VALUES (3363, 8, 385, 3310);
INSERT INTO 'albumsrecordingsmap' VALUES (3364, 9, 385, 3311);
INSERT INTO 'albumsrecordingsmap' VALUES (3365, 10, 385, 3312);
INSERT INTO 'albumsrecordingsmap' VALUES (3366, 11, 385, 3313);
INSERT INTO 'albumsrecordingsmap' VALUES (3367, 12, 385, 3314);
INSERT INTO 'albumsrecordingsmap' VALUES (3368, 13, 385, 3315);
INSERT INTO 'albumsrecordingsmap' VALUES (3369, 14, 385, 3316);
INSERT INTO 'albumsrecordingsmap' VALUES (3370, 15, 385, 3317);
INSERT INTO 'albumsrecordingsmap' VALUES (3371, 16, 385, 3318);
INSERT INTO 'albumsrecordingsmap' VALUES (3231, 5, 175, 3200);
INSERT INTO 'albumsrecordingsmap' VALUES (10907, 9, 118, 10304);
INSERT INTO 'albumsrecordingsmap' VALUES (3385, 6, 66, 3332);
INSERT INTO 'albumsrecordingsmap' VALUES (3386, 2, 63, 3333);
INSERT INTO 'albumsrecordingsmap' VALUES (3387, 1, 849, 3334);
INSERT INTO 'albumsrecordingsmap' VALUES (3388, 2, 849, 3335);
INSERT INTO 'albumsrecordingsmap' VALUES (3389, 3, 849, 3336);
INSERT INTO 'albumsrecordingsmap' VALUES (3390, 4, 849, 3337);
INSERT INTO 'albumsrecordingsmap' VALUES (3391, 5, 849, 3338);
INSERT INTO 'albumsrecordingsmap' VALUES (3392, 6, 849, 3339);
INSERT INTO 'albumsrecordingsmap' VALUES (3393, 7, 849, 3340);
INSERT INTO 'albumsrecordingsmap' VALUES (3394, 8, 849, 3341);
INSERT INTO 'albumsrecordingsmap' VALUES (3395, 9, 849, 3342);
INSERT INTO 'albumsrecordingsmap' VALUES (3396, 10, 849, 3343);
INSERT INTO 'albumsrecordingsmap' VALUES (3397, 11, 849, 3344);
INSERT INTO 'albumsrecordingsmap' VALUES (3398, 12, 849, 3345);
INSERT INTO 'albumsrecordingsmap' VALUES (3399, 13, 849, 3346);
INSERT INTO 'albumsrecordingsmap' VALUES (3400, 14, 849, 3347);
INSERT INTO 'albumsrecordingsmap' VALUES (3401, 15, 849, 3348);
INSERT INTO 'albumsrecordingsmap' VALUES (3413, 1, 788, 3360);
INSERT INTO 'albumsrecordingsmap' VALUES (3414, 2, 788, 3361);
INSERT INTO 'albumsrecordingsmap' VALUES (3415, 3, 788, 3362);
INSERT INTO 'albumsrecordingsmap' VALUES (3416, 4, 788, 3363);
INSERT INTO 'albumsrecordingsmap' VALUES (3417, 1, 826, 3364);
INSERT INTO 'albumsrecordingsmap' VALUES (3418, 2, 826, 3365);
INSERT INTO 'albumsrecordingsmap' VALUES (3419, 3, 826, 3366);
INSERT INTO 'albumsrecordingsmap' VALUES (3420, 4, 826, 3367);
INSERT INTO 'albumsrecordingsmap' VALUES (3421, 5, 826, 3368);
INSERT INTO 'albumsrecordingsmap' VALUES (3422, 6, 826, 3369);
INSERT INTO 'albumsrecordingsmap' VALUES (3423, 7, 826, 3370);
INSERT INTO 'albumsrecordingsmap' VALUES (3424, 8, 826, 3371);
INSERT INTO 'albumsrecordingsmap' VALUES (3425, 9, 826, 3372);
INSERT INTO 'albumsrecordingsmap' VALUES (3426, 10, 826, 3373);
INSERT INTO 'albumsrecordingsmap' VALUES (3427, 11, 826, 3374);
INSERT INTO 'albumsrecordingsmap' VALUES (3428, 12, 826, 3375);
INSERT INTO 'albumsrecordingsmap' VALUES (3429, 13, 826, 3376);
INSERT INTO 'albumsrecordingsmap' VALUES (3430, 1, 852, 3377);
INSERT INTO 'albumsrecordingsmap' VALUES (3431, 2, 852, 3378);
INSERT INTO 'albumsrecordingsmap' VALUES (3432, 3, 852, 3379);
INSERT INTO 'albumsrecordingsmap' VALUES (3433, 4, 852, 3380);
INSERT INTO 'albumsrecordingsmap' VALUES (3434, 5, 852, 3381);
INSERT INTO 'albumsrecordingsmap' VALUES (3443, 2, 781, 3390);
INSERT INTO 'albumsrecordingsmap' VALUES (3444, 8, 781, 3391);
INSERT INTO 'albumsrecordingsmap' VALUES (3445, 1, 875, 3392);
INSERT INTO 'albumsrecordingsmap' VALUES (3446, 2, 875, 3393);
INSERT INTO 'albumsrecordingsmap' VALUES (3447, 3, 875, 3394);
INSERT INTO 'albumsrecordingsmap' VALUES (3448, 4, 875, 3395);
INSERT INTO 'albumsrecordingsmap' VALUES (3449, 5, 875, 3396);
INSERT INTO 'albumsrecordingsmap' VALUES (3450, 6, 875, 3397);
INSERT INTO 'albumsrecordingsmap' VALUES (3451, 7, 875, 3398);
INSERT INTO 'albumsrecordingsmap' VALUES (3452, 8, 875, 3399);
INSERT INTO 'albumsrecordingsmap' VALUES (3453, 9, 875, 3400);
INSERT INTO 'albumsrecordingsmap' VALUES (3454, 10, 875, 3401);
INSERT INTO 'albumsrecordingsmap' VALUES (3455, 11, 875, 3402);
INSERT INTO 'albumsrecordingsmap' VALUES (3456, 12, 875, 3403);
INSERT INTO 'albumsrecordingsmap' VALUES (3457, 3, 97, 3404);
INSERT INTO 'albumsrecordingsmap' VALUES (3435, 1, 838, 3382);
INSERT INTO 'albumsrecordingsmap' VALUES (3436, 2, 838, 3383);
INSERT INTO 'albumsrecordingsmap' VALUES (3437, 3, 838, 3384);
INSERT INTO 'albumsrecordingsmap' VALUES (3438, 6, 838, 3385);
INSERT INTO 'albumsrecordingsmap' VALUES (3439, 7, 838, 3386);
INSERT INTO 'albumsrecordingsmap' VALUES (3440, 8, 838, 3387);
INSERT INTO 'albumsrecordingsmap' VALUES (3441, 10, 838, 3388);
INSERT INTO 'albumsrecordingsmap' VALUES (3442, 11, 838, 3389);
INSERT INTO 'albumsrecordingsmap' VALUES (3458, 1, 388, 3405);
INSERT INTO 'albumsrecordingsmap' VALUES (3459, 2, 388, 3406);
INSERT INTO 'albumsrecordingsmap' VALUES (3460, 3, 388, 3407);
INSERT INTO 'albumsrecordingsmap' VALUES (3461, 4, 388, 3408);
INSERT INTO 'albumsrecordingsmap' VALUES (3462, 5, 388, 3409);
INSERT INTO 'albumsrecordingsmap' VALUES (3463, 6, 388, 3410);
INSERT INTO 'albumsrecordingsmap' VALUES (3464, 7, 388, 3411);
INSERT INTO 'albumsrecordingsmap' VALUES (3465, 8, 388, 3412);
INSERT INTO 'albumsrecordingsmap' VALUES (3466, 9, 388, 3413);
INSERT INTO 'albumsrecordingsmap' VALUES (3467, 10, 388, 3414);
INSERT INTO 'albumsrecordingsmap' VALUES (3468, 11, 388, 3415);
INSERT INTO 'albumsrecordingsmap' VALUES (3469, 12, 388, 3416);
INSERT INTO 'albumsrecordingsmap' VALUES (3470, 13, 388, 3417);
INSERT INTO 'albumsrecordingsmap' VALUES (3471, 14, 388, 3418);
INSERT INTO 'albumsrecordingsmap' VALUES (3472, 15, 388, 3419);
INSERT INTO 'albumsrecordingsmap' VALUES (3473, 16, 388, 3420);
INSERT INTO 'albumsrecordingsmap' VALUES (3474, 17, 388, 3421);
INSERT INTO 'albumsrecordingsmap' VALUES (3475, 8, 64, 2044);
INSERT INTO 'albumsrecordingsmap' VALUES (3476, 1, 876, 783);
INSERT INTO 'albumsrecordingsmap' VALUES (3477, 2, 876, 2528);
INSERT INTO 'albumsrecordingsmap' VALUES (3478, 3, 876, 3422);
INSERT INTO 'albumsrecordingsmap' VALUES (3479, 4, 876, 3423);
INSERT INTO 'albumsrecordingsmap' VALUES (3480, 5, 876, 3424);
INSERT INTO 'albumsrecordingsmap' VALUES (3481, 6, 876, 3425);
INSERT INTO 'albumsrecordingsmap' VALUES (3482, 7, 876, 3426);
INSERT INTO 'albumsrecordingsmap' VALUES (3483, 8, 876, 3427);
INSERT INTO 'albumsrecordingsmap' VALUES (3484, 9, 876, 3428);
INSERT INTO 'albumsrecordingsmap' VALUES (3485, 10, 876, 3429);
INSERT INTO 'albumsrecordingsmap' VALUES (3486, 11, 876, 3430);
INSERT INTO 'albumsrecordingsmap' VALUES (3487, 12, 876, 3431);
INSERT INTO 'albumsrecordingsmap' VALUES (3488, 13, 876, 3432);
INSERT INTO 'albumsrecordingsmap' VALUES (3489, 14, 876, 3433);
INSERT INTO 'albumsrecordingsmap' VALUES (3490, 15, 876, 3434);
INSERT INTO 'albumsrecordingsmap' VALUES (3491, 16, 876, 3435);
INSERT INTO 'albumsrecordingsmap' VALUES (3492, 1, 871, 3436);
INSERT INTO 'albumsrecordingsmap' VALUES (3493, 2, 871, 3437);
INSERT INTO 'albumsrecordingsmap' VALUES (3494, 3, 871, 3438);
INSERT INTO 'albumsrecordingsmap' VALUES (3495, 4, 871, 3439);
INSERT INTO 'albumsrecordingsmap' VALUES (3496, 5, 871, 3440);
INSERT INTO 'albumsrecordingsmap' VALUES (3497, 6, 871, 3441);
INSERT INTO 'albumsrecordingsmap' VALUES (3498, 7, 871, 3442);
INSERT INTO 'albumsrecordingsmap' VALUES (3499, 8, 871, 3443);
INSERT INTO 'albumsrecordingsmap' VALUES (3500, 9, 871, 3444);
INSERT INTO 'albumsrecordingsmap' VALUES (3501, 10, 871, 3445);
INSERT INTO 'albumsrecordingsmap' VALUES (3502, 11, 871, 3446);
INSERT INTO 'albumsrecordingsmap' VALUES (3503, 12, 871, 3447);
INSERT INTO 'albumsrecordingsmap' VALUES (3504, 13, 871, 3448);
INSERT INTO 'albumsrecordingsmap' VALUES (3505, 14, 871, 3449);
INSERT INTO 'albumsrecordingsmap' VALUES (3506, 15, 871, 3450);
INSERT INTO 'albumsrecordingsmap' VALUES (3507, 1, 869, 3451);
INSERT INTO 'albumsrecordingsmap' VALUES (3508, 2, 869, 3452);
INSERT INTO 'albumsrecordingsmap' VALUES (3509, 3, 869, 3453);
INSERT INTO 'albumsrecordingsmap' VALUES (3510, 4, 869, 3454);
INSERT INTO 'albumsrecordingsmap' VALUES (3511, 5, 869, 3455);
INSERT INTO 'albumsrecordingsmap' VALUES (3512, 6, 869, 3456);
INSERT INTO 'albumsrecordingsmap' VALUES (3513, 7, 869, 3457);
INSERT INTO 'albumsrecordingsmap' VALUES (3514, 8, 869, 3458);
INSERT INTO 'albumsrecordingsmap' VALUES (3515, 9, 869, 3459);
INSERT INTO 'albumsrecordingsmap' VALUES (3516, 10, 869, 3460);
INSERT INTO 'albumsrecordingsmap' VALUES (3517, 11, 869, 3461);
INSERT INTO 'albumsrecordingsmap' VALUES (3518, 12, 869, 3462);
INSERT INTO 'albumsrecordingsmap' VALUES (3519, 1, 870, 3463);
INSERT INTO 'albumsrecordingsmap' VALUES (3520, 2, 870, 3464);
INSERT INTO 'albumsrecordingsmap' VALUES (3521, 3, 870, 3465);
INSERT INTO 'albumsrecordingsmap' VALUES (3522, 4, 870, 3466);
INSERT INTO 'albumsrecordingsmap' VALUES (3523, 5, 870, 3467);
INSERT INTO 'albumsrecordingsmap' VALUES (3524, 6, 870, 3468);
INSERT INTO 'albumsrecordingsmap' VALUES (3525, 7, 870, 3469);
INSERT INTO 'albumsrecordingsmap' VALUES (3526, 8, 870, 3470);
INSERT INTO 'albumsrecordingsmap' VALUES (3527, 9, 870, 3471);
INSERT INTO 'albumsrecordingsmap' VALUES (3528, 10, 870, 3472);
INSERT INTO 'albumsrecordingsmap' VALUES (3529, 11, 870, 3473);
INSERT INTO 'albumsrecordingsmap' VALUES (3530, 12, 870, 3474);
INSERT INTO 'albumsrecordingsmap' VALUES (3531, 1, 868, 3475);
INSERT INTO 'albumsrecordingsmap' VALUES (3532, 2, 868, 3476);
INSERT INTO 'albumsrecordingsmap' VALUES (3533, 3, 868, 3477);
INSERT INTO 'albumsrecordingsmap' VALUES (3534, 4, 868, 3478);
INSERT INTO 'albumsrecordingsmap' VALUES (3535, 5, 868, 3479);
INSERT INTO 'albumsrecordingsmap' VALUES (3536, 6, 868, 3480);
INSERT INTO 'albumsrecordingsmap' VALUES (3537, 7, 868, 3481);
INSERT INTO 'albumsrecordingsmap' VALUES (3538, 8, 868, 3482);
INSERT INTO 'albumsrecordingsmap' VALUES (3539, 9, 868, 3483);
INSERT INTO 'albumsrecordingsmap' VALUES (3540, 10, 868, 3484);
INSERT INTO 'albumsrecordingsmap' VALUES (3541, 11, 868, 3485);
INSERT INTO 'albumsrecordingsmap' VALUES (3542, 12, 868, 3486);
INSERT INTO 'albumsrecordingsmap' VALUES (3543, 13, 868, 3487);
INSERT INTO 'albumsrecordingsmap' VALUES (3544, 14, 868, 3488);
INSERT INTO 'albumsrecordingsmap' VALUES (3545, 1, 324, 3489);
INSERT INTO 'albumsrecordingsmap' VALUES (3546, 2, 324, 3490);
INSERT INTO 'albumsrecordingsmap' VALUES (3547, 3, 324, 3491);
INSERT INTO 'albumsrecordingsmap' VALUES (3548, 4, 324, 3492);
INSERT INTO 'albumsrecordingsmap' VALUES (3549, 5, 324, 3493);
INSERT INTO 'albumsrecordingsmap' VALUES (3550, 6, 324, 3494);
INSERT INTO 'albumsrecordingsmap' VALUES (3551, 7, 324, 3495);
INSERT INTO 'albumsrecordingsmap' VALUES (3552, 8, 324, 3496);
INSERT INTO 'albumsrecordingsmap' VALUES (3553, 9, 324, 3497);
INSERT INTO 'albumsrecordingsmap' VALUES (3554, 10, 324, 3498);
INSERT INTO 'albumsrecordingsmap' VALUES (3555, 11, 324, 3499);
INSERT INTO 'albumsrecordingsmap' VALUES (3556, 12, 324, 3500);
INSERT INTO 'albumsrecordingsmap' VALUES (3557, 13, 324, 3501);
INSERT INTO 'albumsrecordingsmap' VALUES (3558, 14, 324, 3502);
INSERT INTO 'albumsrecordingsmap' VALUES (3559, 15, 324, 3503);
INSERT INTO 'albumsrecordingsmap' VALUES (3560, 16, 324, 3504);
INSERT INTO 'albumsrecordingsmap' VALUES (3561, 1, 774, 3505);
INSERT INTO 'albumsrecordingsmap' VALUES (3562, 2, 774, 3506);
INSERT INTO 'albumsrecordingsmap' VALUES (3563, 3, 774, 3507);
INSERT INTO 'albumsrecordingsmap' VALUES (3564, 4, 774, 3508);
INSERT INTO 'albumsrecordingsmap' VALUES (3565, 5, 774, 3509);
INSERT INTO 'albumsrecordingsmap' VALUES (3566, 6, 774, 3510);
INSERT INTO 'albumsrecordingsmap' VALUES (3567, 7, 774, 3511);
INSERT INTO 'albumsrecordingsmap' VALUES (3568, 8, 774, 3512);
INSERT INTO 'albumsrecordingsmap' VALUES (3569, 9, 774, 3513);
INSERT INTO 'albumsrecordingsmap' VALUES (3570, 10, 774, 3514);
INSERT INTO 'albumsrecordingsmap' VALUES (3571, 11, 774, 3515);
INSERT INTO 'albumsrecordingsmap' VALUES (3572, 12, 774, 3516);
INSERT INTO 'albumsrecordingsmap' VALUES (3573, 13, 774, 3517);
INSERT INTO 'albumsrecordingsmap' VALUES (3574, 14, 774, 3518);
INSERT INTO 'albumsrecordingsmap' VALUES (3575, 15, 774, 3519);
INSERT INTO 'albumsrecordingsmap' VALUES (3576, 16, 774, 3520);
INSERT INTO 'albumsrecordingsmap' VALUES (3577, 17, 774, 3521);
INSERT INTO 'albumsrecordingsmap' VALUES (3578, 18, 774, 3522);
INSERT INTO 'albumsrecordingsmap' VALUES (3579, 19, 774, 3523);
INSERT INTO 'albumsrecordingsmap' VALUES (3580, 20, 774, 3524);
INSERT INTO 'albumsrecordingsmap' VALUES (3581, 21, 774, 3525);
INSERT INTO 'albumsrecordingsmap' VALUES (3582, 22, 774, 3526);
INSERT INTO 'albumsrecordingsmap' VALUES (3583, 23, 774, 3527);
INSERT INTO 'albumsrecordingsmap' VALUES (3584, 24, 774, 3528);
INSERT INTO 'albumsrecordingsmap' VALUES (3585, 26, 774, 3529);
INSERT INTO 'albumsrecordingsmap' VALUES (3586, 27, 774, 3530);
INSERT INTO 'albumsrecordingsmap' VALUES (3587, 28, 774, 3531);
INSERT INTO 'albumsrecordingsmap' VALUES (3588, 1, 775, 3532);
INSERT INTO 'albumsrecordingsmap' VALUES (3589, 2, 775, 3533);
INSERT INTO 'albumsrecordingsmap' VALUES (3590, 3, 775, 3534);
INSERT INTO 'albumsrecordingsmap' VALUES (3591, 4, 775, 3535);
INSERT INTO 'albumsrecordingsmap' VALUES (3592, 5, 775, 3536);
INSERT INTO 'albumsrecordingsmap' VALUES (3593, 6, 775, 3537);
INSERT INTO 'albumsrecordingsmap' VALUES (3594, 7, 775, 3538);
INSERT INTO 'albumsrecordingsmap' VALUES (3595, 8, 775, 3539);
INSERT INTO 'albumsrecordingsmap' VALUES (3596, 9, 775, 3540);
INSERT INTO 'albumsrecordingsmap' VALUES (3597, 10, 775, 3541);
INSERT INTO 'albumsrecordingsmap' VALUES (3598, 11, 775, 3542);
INSERT INTO 'albumsrecordingsmap' VALUES (3599, 12, 775, 3543);
INSERT INTO 'albumsrecordingsmap' VALUES (3600, 13, 775, 3544);
INSERT INTO 'albumsrecordingsmap' VALUES (3601, 14, 775, 3545);
INSERT INTO 'albumsrecordingsmap' VALUES (3602, 15, 775, 3546);
INSERT INTO 'albumsrecordingsmap' VALUES (3603, 16, 775, 3547);
INSERT INTO 'albumsrecordingsmap' VALUES (3604, 1, 872, 3548);
INSERT INTO 'albumsrecordingsmap' VALUES (3605, 2, 872, 3549);
INSERT INTO 'albumsrecordingsmap' VALUES (3606, 3, 872, 3550);
INSERT INTO 'albumsrecordingsmap' VALUES (3607, 4, 872, 3551);
INSERT INTO 'albumsrecordingsmap' VALUES (3608, 5, 872, 3552);
INSERT INTO 'albumsrecordingsmap' VALUES (3609, 6, 872, 3553);
INSERT INTO 'albumsrecordingsmap' VALUES (3610, 7, 872, 3554);
INSERT INTO 'albumsrecordingsmap' VALUES (3611, 8, 872, 3555);
INSERT INTO 'albumsrecordingsmap' VALUES (3612, 9, 872, 3556);
INSERT INTO 'albumsrecordingsmap' VALUES (3613, 10, 872, 3557);
INSERT INTO 'albumsrecordingsmap' VALUES (3614, 11, 872, 3558);
INSERT INTO 'albumsrecordingsmap' VALUES (3615, 12, 872, 3559);
INSERT INTO 'albumsrecordingsmap' VALUES (3616, 13, 872, 3560);
INSERT INTO 'albumsrecordingsmap' VALUES (3617, 14, 872, 3561);
INSERT INTO 'albumsrecordingsmap' VALUES (3618, 1, 785, 3562);
INSERT INTO 'albumsrecordingsmap' VALUES (3619, 2, 785, 3563);
INSERT INTO 'albumsrecordingsmap' VALUES (3620, 3, 785, 3564);
INSERT INTO 'albumsrecordingsmap' VALUES (3621, 4, 785, 3565);
INSERT INTO 'albumsrecordingsmap' VALUES (3622, 5, 785, 3566);
INSERT INTO 'albumsrecordingsmap' VALUES (3623, 6, 785, 3567);
INSERT INTO 'albumsrecordingsmap' VALUES (3624, 7, 785, 3568);
INSERT INTO 'albumsrecordingsmap' VALUES (3625, 8, 785, 3569);
INSERT INTO 'albumsrecordingsmap' VALUES (3626, 9, 785, 3570);
INSERT INTO 'albumsrecordingsmap' VALUES (3627, 10, 785, 3571);
INSERT INTO 'albumsrecordingsmap' VALUES (3628, 11, 785, 3572);
INSERT INTO 'albumsrecordingsmap' VALUES (3629, 1, 856, 3573);
INSERT INTO 'albumsrecordingsmap' VALUES (3630, 2, 856, 3574);
INSERT INTO 'albumsrecordingsmap' VALUES (3631, 3, 856, 3575);
INSERT INTO 'albumsrecordingsmap' VALUES (3632, 4, 856, 3576);
INSERT INTO 'albumsrecordingsmap' VALUES (3633, 5, 856, 3577);
INSERT INTO 'albumsrecordingsmap' VALUES (3634, 6, 856, 3578);
INSERT INTO 'albumsrecordingsmap' VALUES (3635, 7, 856, 3579);
INSERT INTO 'albumsrecordingsmap' VALUES (3636, 8, 856, 3580);
INSERT INTO 'albumsrecordingsmap' VALUES (3637, 9, 856, 3581);
INSERT INTO 'albumsrecordingsmap' VALUES (3638, 10, 856, 3582);
INSERT INTO 'albumsrecordingsmap' VALUES (3639, 11, 856, 3583);
INSERT INTO 'albumsrecordingsmap' VALUES (3640, 12, 856, 3584);
INSERT INTO 'albumsrecordingsmap' VALUES (3641, 13, 856, 3585);
INSERT INTO 'albumsrecordingsmap' VALUES (3642, 14, 856, 3586);
INSERT INTO 'albumsrecordingsmap' VALUES (3643, 1, 398, 3587);
INSERT INTO 'albumsrecordingsmap' VALUES (3644, 2, 398, 3588);
INSERT INTO 'albumsrecordingsmap' VALUES (3645, 3, 398, 3589);
INSERT INTO 'albumsrecordingsmap' VALUES (3646, 4, 398, 3590);
INSERT INTO 'albumsrecordingsmap' VALUES (3647, 5, 398, 3591);
INSERT INTO 'albumsrecordingsmap' VALUES (3648, 6, 398, 3592);
INSERT INTO 'albumsrecordingsmap' VALUES (3649, 7, 398, 3593);
INSERT INTO 'albumsrecordingsmap' VALUES (3650, 8, 398, 3594);
INSERT INTO 'albumsrecordingsmap' VALUES (3651, 9, 398, 3595);
INSERT INTO 'albumsrecordingsmap' VALUES (3652, 10, 398, 3596);
INSERT INTO 'albumsrecordingsmap' VALUES (3653, 8, 309, 3597);
INSERT INTO 'albumsrecordingsmap' VALUES (3654, 9, 309, 3598);
INSERT INTO 'albumsrecordingsmap' VALUES (3655, 11, 309, 3599);
INSERT INTO 'albumsrecordingsmap' VALUES (3656, 13, 309, 3600);
INSERT INTO 'albumsrecordingsmap' VALUES (3657, 14, 309, 3601);
INSERT INTO 'albumsrecordingsmap' VALUES (3658, 15, 309, 3602);
INSERT INTO 'albumsrecordingsmap' VALUES (3659, 18, 309, 3603);
INSERT INTO 'albumsrecordingsmap' VALUES (3660, 2, 283, 3604);
INSERT INTO 'albumsrecordingsmap' VALUES (3661, 4, 283, 3605);
INSERT INTO 'albumsrecordingsmap' VALUES (3662, 5, 283, 3606);
INSERT INTO 'albumsrecordingsmap' VALUES (3663, 9, 283, 3607);
INSERT INTO 'albumsrecordingsmap' VALUES (3664, 10, 283, 3608);
INSERT INTO 'albumsrecordingsmap' VALUES (3665, 11, 283, 3609);
INSERT INTO 'albumsrecordingsmap' VALUES (3666, 8, 210, 3610);
INSERT INTO 'albumsrecordingsmap' VALUES (3667, 1, 340, 3611);
INSERT INTO 'albumsrecordingsmap' VALUES (3668, 2, 340, 3612);
INSERT INTO 'albumsrecordingsmap' VALUES (3669, 3, 340, 3613);
INSERT INTO 'albumsrecordingsmap' VALUES (3670, 4, 340, 3614);
INSERT INTO 'albumsrecordingsmap' VALUES (3671, 5, 340, 3615);
INSERT INTO 'albumsrecordingsmap' VALUES (3672, 6, 340, 3616);
INSERT INTO 'albumsrecordingsmap' VALUES (3673, 7, 340, 3617);
INSERT INTO 'albumsrecordingsmap' VALUES (3674, 10, 340, 3620);
INSERT INTO 'albumsrecordingsmap' VALUES (3675, 11, 340, 3621);
INSERT INTO 'albumsrecordingsmap' VALUES (3677, 7, 127, 1578);
INSERT INTO 'albumsrecordingsmap' VALUES (3678, 13, 127, 2778);
INSERT INTO 'albumsrecordingsmap' VALUES (3679, 11, 250, 3623);
INSERT INTO 'albumsrecordingsmap' VALUES (3680, 16, 239, 3624);
INSERT INTO 'albumsrecordingsmap' VALUES (3681, 8, 275, 3625);
INSERT INTO 'albumsrecordingsmap' VALUES (3682, 1, 735, 3626);
INSERT INTO 'albumsrecordingsmap' VALUES (3683, 2, 735, 3627);
INSERT INTO 'albumsrecordingsmap' VALUES (3684, 3, 735, 3628);
INSERT INTO 'albumsrecordingsmap' VALUES (3685, 4, 735, 3629);
INSERT INTO 'albumsrecordingsmap' VALUES (3686, 5, 735, 3630);
INSERT INTO 'albumsrecordingsmap' VALUES (3687, 6, 735, 3631);
INSERT INTO 'albumsrecordingsmap' VALUES (3688, 7, 735, 3632);
INSERT INTO 'albumsrecordingsmap' VALUES (3689, 8, 735, 3633);
INSERT INTO 'albumsrecordingsmap' VALUES (3690, 9, 735, 3634);
INSERT INTO 'albumsrecordingsmap' VALUES (3691, 10, 735, 3635);
INSERT INTO 'albumsrecordingsmap' VALUES (3692, 11, 735, 3636);
INSERT INTO 'albumsrecordingsmap' VALUES (3693, 12, 735, 3637);
INSERT INTO 'albumsrecordingsmap' VALUES (3694, 1, 712, 3638);
INSERT INTO 'albumsrecordingsmap' VALUES (3695, 2, 712, 3639);
INSERT INTO 'albumsrecordingsmap' VALUES (3696, 4, 712, 3640);
INSERT INTO 'albumsrecordingsmap' VALUES (3697, 5, 712, 3641);
INSERT INTO 'albumsrecordingsmap' VALUES (3698, 6, 712, 3642);
INSERT INTO 'albumsrecordingsmap' VALUES (3699, 7, 712, 3643);
INSERT INTO 'albumsrecordingsmap' VALUES (3700, 8, 712, 3644);
INSERT INTO 'albumsrecordingsmap' VALUES (3701, 9, 712, 3645);
INSERT INTO 'albumsrecordingsmap' VALUES (3702, 10, 712, 3646);
INSERT INTO 'albumsrecordingsmap' VALUES (3703, 11, 712, 3647);
INSERT INTO 'albumsrecordingsmap' VALUES (3704, 12, 712, 3648);
INSERT INTO 'albumsrecordingsmap' VALUES (3705, 1, 717, 3650);
INSERT INTO 'albumsrecordingsmap' VALUES (3706, 2, 717, 3651);
INSERT INTO 'albumsrecordingsmap' VALUES (3707, 3, 717, 3652);
INSERT INTO 'albumsrecordingsmap' VALUES (3708, 4, 717, 3653);
INSERT INTO 'albumsrecordingsmap' VALUES (3709, 5, 717, 3654);
INSERT INTO 'albumsrecordingsmap' VALUES (3710, 6, 717, 3655);
INSERT INTO 'albumsrecordingsmap' VALUES (3711, 7, 717, 3656);
INSERT INTO 'albumsrecordingsmap' VALUES (3712, 1, 718, 3657);
INSERT INTO 'albumsrecordingsmap' VALUES (3713, 2, 718, 3658);
INSERT INTO 'albumsrecordingsmap' VALUES (3714, 3, 718, 3659);
INSERT INTO 'albumsrecordingsmap' VALUES (3715, 4, 718, 3660);
INSERT INTO 'albumsrecordingsmap' VALUES (3716, 5, 718, 3661);
INSERT INTO 'albumsrecordingsmap' VALUES (3717, 6, 718, 3662);
INSERT INTO 'albumsrecordingsmap' VALUES (3718, 7, 718, 3663);
INSERT INTO 'albumsrecordingsmap' VALUES (3719, 8, 718, 3664);
INSERT INTO 'albumsrecordingsmap' VALUES (3720, 9, 718, 3665);
INSERT INTO 'albumsrecordingsmap' VALUES (3721, 12, 718, 3667);
INSERT INTO 'albumsrecordingsmap' VALUES (3722, 8, 717, 3668);
INSERT INTO 'albumsrecordingsmap' VALUES (3723, 9, 717, 3669);
INSERT INTO 'albumsrecordingsmap' VALUES (3724, 10, 717, 3670);
INSERT INTO 'albumsrecordingsmap' VALUES (3725, 11, 717, 3671);
INSERT INTO 'albumsrecordingsmap' VALUES (3726, 12, 717, 3672);
INSERT INTO 'albumsrecordingsmap' VALUES (3727, 13, 717, 3673);
INSERT INTO 'albumsrecordingsmap' VALUES (3728, 1, 372, 3674);
INSERT INTO 'albumsrecordingsmap' VALUES (3729, 2, 372, 3675);
INSERT INTO 'albumsrecordingsmap' VALUES (3730, 3, 372, 3676);
INSERT INTO 'albumsrecordingsmap' VALUES (3731, 4, 372, 3677);
INSERT INTO 'albumsrecordingsmap' VALUES (3732, 5, 372, 3678);
INSERT INTO 'albumsrecordingsmap' VALUES (3733, 6, 372, 3679);
INSERT INTO 'albumsrecordingsmap' VALUES (3734, 7, 372, 3680);
INSERT INTO 'albumsrecordingsmap' VALUES (3735, 8, 372, 3681);
INSERT INTO 'albumsrecordingsmap' VALUES (3736, 9, 372, 3682);
INSERT INTO 'albumsrecordingsmap' VALUES (3737, 10, 372, 3683);
INSERT INTO 'albumsrecordingsmap' VALUES (3738, 11, 372, 3684);
INSERT INTO 'albumsrecordingsmap' VALUES (3739, 12, 372, 3685);
INSERT INTO 'albumsrecordingsmap' VALUES (3740, 1, 745, 3686);
INSERT INTO 'albumsrecordingsmap' VALUES (3741, 2, 745, 3687);
INSERT INTO 'albumsrecordingsmap' VALUES (3742, 5, 745, 3689);
INSERT INTO 'albumsrecordingsmap' VALUES (3743, 6, 745, 3690);
INSERT INTO 'albumsrecordingsmap' VALUES (3744, 7, 745, 3691);
INSERT INTO 'albumsrecordingsmap' VALUES (3745, 8, 745, 3692);
INSERT INTO 'albumsrecordingsmap' VALUES (3746, 9, 745, 3693);
INSERT INTO 'albumsrecordingsmap' VALUES (3747, 10, 745, 3694);
INSERT INTO 'albumsrecordingsmap' VALUES (3748, 11, 745, 3695);
INSERT INTO 'albumsrecordingsmap' VALUES (3749, 1, 746, 3696);
INSERT INTO 'albumsrecordingsmap' VALUES (3750, 2, 746, 3697);
INSERT INTO 'albumsrecordingsmap' VALUES (3751, 3, 746, 3698);
INSERT INTO 'albumsrecordingsmap' VALUES (3752, 4, 746, 3699);
INSERT INTO 'albumsrecordingsmap' VALUES (3753, 5, 746, 3700);
INSERT INTO 'albumsrecordingsmap' VALUES (3754, 6, 746, 3701);
INSERT INTO 'albumsrecordingsmap' VALUES (3755, 7, 746, 3702);
INSERT INTO 'albumsrecordingsmap' VALUES (3756, 8, 746, 3703);
INSERT INTO 'albumsrecordingsmap' VALUES (3757, 9, 746, 1932);
INSERT INTO 'albumsrecordingsmap' VALUES (3758, 10, 746, 2287);
INSERT INTO 'albumsrecordingsmap' VALUES (3759, 11, 746, 2827);
INSERT INTO 'albumsrecordingsmap' VALUES (3760, 1, 749, 2331);
INSERT INTO 'albumsrecordingsmap' VALUES (3761, 10, 749, 2340);
INSERT INTO 'albumsrecordingsmap' VALUES (3762, 3, 749, 2333);
INSERT INTO 'albumsrecordingsmap' VALUES (3763, 4, 749, 2334);
INSERT INTO 'albumsrecordingsmap' VALUES (3764, 5, 749, 2335);
INSERT INTO 'albumsrecordingsmap' VALUES (3765, 6, 749, 2336);
INSERT INTO 'albumsrecordingsmap' VALUES (3766, 7, 749, 2337);
INSERT INTO 'albumsrecordingsmap' VALUES (3767, 8, 749, 2338);
INSERT INTO 'albumsrecordingsmap' VALUES (3768, 9, 749, 1166);
INSERT INTO 'albumsrecordingsmap' VALUES (3769, 11, 749, 2341);
INSERT INTO 'albumsrecordingsmap' VALUES (3770, 12, 749, 2342);
INSERT INTO 'albumsrecordingsmap' VALUES (3771, 1, 304, 3705);
INSERT INTO 'albumsrecordingsmap' VALUES (3772, 4, 304, 3706);
INSERT INTO 'albumsrecordingsmap' VALUES (3773, 1, 740, 3708);
INSERT INTO 'albumsrecordingsmap' VALUES (3774, 2, 740, 3709);
INSERT INTO 'albumsrecordingsmap' VALUES (3775, 3, 740, 3710);
INSERT INTO 'albumsrecordingsmap' VALUES (3776, 4, 740, 3711);
INSERT INTO 'albumsrecordingsmap' VALUES (3777, 5, 740, 3712);
INSERT INTO 'albumsrecordingsmap' VALUES (3778, 6, 740, 3713);
INSERT INTO 'albumsrecordingsmap' VALUES (3779, 7, 740, 3714);
INSERT INTO 'albumsrecordingsmap' VALUES (3780, 8, 740, 3715);
INSERT INTO 'albumsrecordingsmap' VALUES (3781, 9, 740, 3716);
INSERT INTO 'albumsrecordingsmap' VALUES (3782, 10, 740, 3717);
INSERT INTO 'albumsrecordingsmap' VALUES (3783, 11, 740, 3718);
INSERT INTO 'albumsrecordingsmap' VALUES (3784, 12, 740, 3719);
INSERT INTO 'albumsrecordingsmap' VALUES (3785, 1, 741, 3720);
INSERT INTO 'albumsrecordingsmap' VALUES (3786, 2, 741, 3721);
INSERT INTO 'albumsrecordingsmap' VALUES (3787, 3, 741, 3722);
INSERT INTO 'albumsrecordingsmap' VALUES (3788, 4, 741, 3723);
INSERT INTO 'albumsrecordingsmap' VALUES (3789, 5, 741, 3724);
INSERT INTO 'albumsrecordingsmap' VALUES (3790, 6, 741, 3725);
INSERT INTO 'albumsrecordingsmap' VALUES (3791, 7, 741, 3726);
INSERT INTO 'albumsrecordingsmap' VALUES (3792, 8, 741, 3727);
INSERT INTO 'albumsrecordingsmap' VALUES (3793, 9, 741, 3728);
INSERT INTO 'albumsrecordingsmap' VALUES (3794, 10, 741, 3729);
INSERT INTO 'albumsrecordingsmap' VALUES (3795, 11, 741, 3730);
INSERT INTO 'albumsrecordingsmap' VALUES (3796, 12, 741, 3731);
INSERT INTO 'albumsrecordingsmap' VALUES (3797, 13, 741, 3732);
INSERT INTO 'albumsrecordingsmap' VALUES (3798, 14, 741, 3733);
INSERT INTO 'albumsrecordingsmap' VALUES (3799, 1, 790, 3734);
INSERT INTO 'albumsrecordingsmap' VALUES (3800, 2, 790, 3735);
INSERT INTO 'albumsrecordingsmap' VALUES (3801, 5, 790, 3737);
INSERT INTO 'albumsrecordingsmap' VALUES (3802, 6, 790, 3738);
INSERT INTO 'albumsrecordingsmap' VALUES (3803, 7, 790, 3739);
INSERT INTO 'albumsrecordingsmap' VALUES (3804, 8, 790, 3740);
INSERT INTO 'albumsrecordingsmap' VALUES (3805, 9, 790, 3741);
INSERT INTO 'albumsrecordingsmap' VALUES (3806, 10, 790, 3742);
INSERT INTO 'albumsrecordingsmap' VALUES (3807, 11, 790, 3743);
INSERT INTO 'albumsrecordingsmap' VALUES (3808, 12, 790, 3744);
INSERT INTO 'albumsrecordingsmap' VALUES (3809, 13, 790, 3745);
INSERT INTO 'albumsrecordingsmap' VALUES (3810, 14, 790, 3746);
INSERT INTO 'albumsrecordingsmap' VALUES (3811, 15, 790, 3747);
INSERT INTO 'albumsrecordingsmap' VALUES (3812, 12, 189, 3748);
INSERT INTO 'albumsrecordingsmap' VALUES (3813, 1, 706, 3749);
INSERT INTO 'albumsrecordingsmap' VALUES (3814, 2, 706, 3750);
INSERT INTO 'albumsrecordingsmap' VALUES (3815, 3, 706, 3751);
INSERT INTO 'albumsrecordingsmap' VALUES (3816, 4, 706, 3752);
INSERT INTO 'albumsrecordingsmap' VALUES (3817, 5, 706, 3753);
INSERT INTO 'albumsrecordingsmap' VALUES (3818, 6, 706, 3754);
INSERT INTO 'albumsrecordingsmap' VALUES (3819, 7, 706, 3755);
INSERT INTO 'albumsrecordingsmap' VALUES (3820, 1, 811, 3756);
INSERT INTO 'albumsrecordingsmap' VALUES (3821, 2, 811, 3757);
INSERT INTO 'albumsrecordingsmap' VALUES (3822, 3, 811, 3758);
INSERT INTO 'albumsrecordingsmap' VALUES (3823, 4, 811, 3759);
INSERT INTO 'albumsrecordingsmap' VALUES (3824, 5, 811, 3760);
INSERT INTO 'albumsrecordingsmap' VALUES (3825, 6, 811, 3761);
INSERT INTO 'albumsrecordingsmap' VALUES (3826, 7, 811, 3762);
INSERT INTO 'albumsrecordingsmap' VALUES (3841, 1, 379, 2366);
INSERT INTO 'albumsrecordingsmap' VALUES (3842, 2, 379, 340);
INSERT INTO 'albumsrecordingsmap' VALUES (3843, 3, 379, 225);
INSERT INTO 'albumsrecordingsmap' VALUES (3844, 4, 379, 349);
INSERT INTO 'albumsrecordingsmap' VALUES (3845, 5, 379, 3778);
INSERT INTO 'albumsrecordingsmap' VALUES (3846, 6, 379, 126);
INSERT INTO 'albumsrecordingsmap' VALUES (3847, 7, 379, 159);
INSERT INTO 'albumsrecordingsmap' VALUES (3848, 8, 379, 3779);
INSERT INTO 'albumsrecordingsmap' VALUES (3849, 9, 379, 231);
INSERT INTO 'albumsrecordingsmap' VALUES (3850, 10, 379, 121);
INSERT INTO 'albumsrecordingsmap' VALUES (3851, 11, 379, 2);
INSERT INTO 'albumsrecordingsmap' VALUES (3852, 12, 379, 93);
INSERT INTO 'albumsrecordingsmap' VALUES (3853, 1, 827, 3780);
INSERT INTO 'albumsrecordingsmap' VALUES (3854, 2, 827, 3781);
INSERT INTO 'albumsrecordingsmap' VALUES (3855, 3, 827, 3782);
INSERT INTO 'albumsrecordingsmap' VALUES (3856, 4, 827, 3783);
INSERT INTO 'albumsrecordingsmap' VALUES (3857, 5, 827, 3784);
INSERT INTO 'albumsrecordingsmap' VALUES (3858, 6, 827, 3785);
INSERT INTO 'albumsrecordingsmap' VALUES (3859, 7, 827, 3786);
INSERT INTO 'albumsrecordingsmap' VALUES (3860, 8, 827, 3787);
INSERT INTO 'albumsrecordingsmap' VALUES (3861, 9, 827, 3788);
INSERT INTO 'albumsrecordingsmap' VALUES (3862, 10, 827, 3789);
INSERT INTO 'albumsrecordingsmap' VALUES (3863, 11, 827, 3790);
INSERT INTO 'albumsrecordingsmap' VALUES (3864, 12, 827, 3791);
INSERT INTO 'albumsrecordingsmap' VALUES (3865, 13, 827, 3792);
INSERT INTO 'albumsrecordingsmap' VALUES (3868, 1, 719, 3799);
INSERT INTO 'albumsrecordingsmap' VALUES (3869, 2, 719, 3800);
INSERT INTO 'albumsrecordingsmap' VALUES (3870, 3, 719, 3801);
INSERT INTO 'albumsrecordingsmap' VALUES (3871, 4, 719, 3802);
INSERT INTO 'albumsrecordingsmap' VALUES (3872, 5, 719, 3803);
INSERT INTO 'albumsrecordingsmap' VALUES (3873, 6, 719, 3804);
INSERT INTO 'albumsrecordingsmap' VALUES (3874, 7, 719, 3805);
INSERT INTO 'albumsrecordingsmap' VALUES (3875, 8, 719, 3806);
INSERT INTO 'albumsrecordingsmap' VALUES (3876, 9, 719, 3807);
INSERT INTO 'albumsrecordingsmap' VALUES (3877, 10, 719, 3808);
INSERT INTO 'albumsrecordingsmap' VALUES (3878, 11, 719, 3809);
INSERT INTO 'albumsrecordingsmap' VALUES (3879, 12, 719, 3810);
INSERT INTO 'albumsrecordingsmap' VALUES (3880, 13, 719, 3811);
INSERT INTO 'albumsrecordingsmap' VALUES (3881, 14, 719, 3812);
INSERT INTO 'albumsrecordingsmap' VALUES (3882, 15, 719, 3813);
INSERT INTO 'albumsrecordingsmap' VALUES (3883, 1, 753, 101);
INSERT INTO 'albumsrecordingsmap' VALUES (3884, 5, 753, 3814);
INSERT INTO 'albumsrecordingsmap' VALUES (3885, 8, 753, 3815);
INSERT INTO 'albumsrecordingsmap' VALUES (3886, 10, 753, 3816);
INSERT INTO 'albumsrecordingsmap' VALUES (3887, 1, 724, 3817);
INSERT INTO 'albumsrecordingsmap' VALUES (3888, 2, 724, 3818);
INSERT INTO 'albumsrecordingsmap' VALUES (3889, 4, 724, 3819);
INSERT INTO 'albumsrecordingsmap' VALUES (3890, 8, 724, 3820);
INSERT INTO 'albumsrecordingsmap' VALUES (3891, 1, 758, 3821);
INSERT INTO 'albumsrecordingsmap' VALUES (3892, 2, 758, 3822);
INSERT INTO 'albumsrecordingsmap' VALUES (3893, 3, 758, 3823);
INSERT INTO 'albumsrecordingsmap' VALUES (3894, 4, 758, 3824);
INSERT INTO 'albumsrecordingsmap' VALUES (3901, 1, 878, 455);
INSERT INTO 'albumsrecordingsmap' VALUES (3902, 2, 878, 1373);
INSERT INTO 'albumsrecordingsmap' VALUES (3903, 3, 878, 1247);
INSERT INTO 'albumsrecordingsmap' VALUES (3904, 4, 878, 1283);
INSERT INTO 'albumsrecordingsmap' VALUES (3905, 5, 878, 267);
INSERT INTO 'albumsrecordingsmap' VALUES (3906, 6, 878, 290);
INSERT INTO 'albumsrecordingsmap' VALUES (3907, 7, 878, 61);
INSERT INTO 'albumsrecordingsmap' VALUES (3908, 8, 878, 3831);
INSERT INTO 'albumsrecordingsmap' VALUES (3909, 9, 878, 3832);
INSERT INTO 'albumsrecordingsmap' VALUES (3910, 10, 878, 3833);
INSERT INTO 'albumsrecordingsmap' VALUES (3911, 11, 878, 3834);
INSERT INTO 'albumsrecordingsmap' VALUES (3912, 12, 878, 3835);
INSERT INTO 'albumsrecordingsmap' VALUES (3913, 13, 878, 3836);
INSERT INTO 'albumsrecordingsmap' VALUES (3914, 14, 878, 3837);
INSERT INTO 'albumsrecordingsmap' VALUES (3915, 15, 878, 3838);
INSERT INTO 'albumsrecordingsmap' VALUES (3916, 8, 282, 231);
INSERT INTO 'albumsrecordingsmap' VALUES (3917, 1, 748, 3839);
INSERT INTO 'albumsrecordingsmap' VALUES (3918, 2, 748, 3840);
INSERT INTO 'albumsrecordingsmap' VALUES (3919, 3, 748, 3841);
INSERT INTO 'albumsrecordingsmap' VALUES (3920, 4, 748, 3842);
INSERT INTO 'albumsrecordingsmap' VALUES (3921, 5, 748, 3843);
INSERT INTO 'albumsrecordingsmap' VALUES (3922, 6, 748, 3844);
INSERT INTO 'albumsrecordingsmap' VALUES (3923, 1, 780, 3845);
INSERT INTO 'albumsrecordingsmap' VALUES (3924, 2, 780, 3846);
INSERT INTO 'albumsrecordingsmap' VALUES (3925, 3, 780, 3847);
INSERT INTO 'albumsrecordingsmap' VALUES (3926, 4, 780, 3848);
INSERT INTO 'albumsrecordingsmap' VALUES (3927, 5, 780, 3849);
INSERT INTO 'albumsrecordingsmap' VALUES (3928, 6, 780, 3850);
INSERT INTO 'albumsrecordingsmap' VALUES (3929, 7, 780, 3851);
INSERT INTO 'albumsrecordingsmap' VALUES (3930, 8, 780, 3852);
INSERT INTO 'albumsrecordingsmap' VALUES (3931, 9, 780, 3853);
INSERT INTO 'albumsrecordingsmap' VALUES (3932, 1, 730, 3854);
INSERT INTO 'albumsrecordingsmap' VALUES (3933, 2, 730, 3855);
INSERT INTO 'albumsrecordingsmap' VALUES (3934, 3, 730, 3856);
INSERT INTO 'albumsrecordingsmap' VALUES (3935, 4, 730, 3857);
INSERT INTO 'albumsrecordingsmap' VALUES (3936, 2, 406, 3859);
INSERT INTO 'albumsrecordingsmap' VALUES (3937, 4, 406, 3861);
INSERT INTO 'albumsrecordingsmap' VALUES (3938, 5, 406, 3862);
INSERT INTO 'albumsrecordingsmap' VALUES (3939, 6, 406, 3863);
INSERT INTO 'albumsrecordingsmap' VALUES (3940, 8, 406, 3865);
INSERT INTO 'albumsrecordingsmap' VALUES (3941, 10, 406, 3867);
INSERT INTO 'albumsrecordingsmap' VALUES (3942, 11, 406, 3868);
INSERT INTO 'albumsrecordingsmap' VALUES (3943, 12, 406, 3869);
INSERT INTO 'albumsrecordingsmap' VALUES (3944, 1, 406, 124);
INSERT INTO 'albumsrecordingsmap' VALUES (3945, 3, 134, 3862);
INSERT INTO 'albumsrecordingsmap' VALUES (3946, 7, 406, 2427);
INSERT INTO 'albumsrecordingsmap' VALUES (3947, 3, 406, 11);
INSERT INTO 'albumsrecordingsmap' VALUES (3948, 9, 406, 313);
INSERT INTO 'albumsrecordingsmap' VALUES (3949, 1, 343, 3870);
INSERT INTO 'albumsrecordingsmap' VALUES (3950, 2, 343, 3871);
INSERT INTO 'albumsrecordingsmap' VALUES (3951, 3, 343, 3872);
INSERT INTO 'albumsrecordingsmap' VALUES (3952, 4, 343, 3873);
INSERT INTO 'albumsrecordingsmap' VALUES (3953, 5, 343, 3874);
INSERT INTO 'albumsrecordingsmap' VALUES (3954, 6, 343, 3875);
INSERT INTO 'albumsrecordingsmap' VALUES (3955, 7, 343, 3876);
INSERT INTO 'albumsrecordingsmap' VALUES (3956, 8, 343, 3877);
INSERT INTO 'albumsrecordingsmap' VALUES (3957, 9, 343, 3878);
INSERT INTO 'albumsrecordingsmap' VALUES (3958, 10, 343, 3879);
INSERT INTO 'albumsrecordingsmap' VALUES (3959, 11, 343, 3880);
INSERT INTO 'albumsrecordingsmap' VALUES (3960, 12, 343, 3881);
INSERT INTO 'albumsrecordingsmap' VALUES (3961, 6, 728, 2162);
INSERT INTO 'albumsrecordingsmap' VALUES (3962, 7, 728, 2163);
INSERT INTO 'albumsrecordingsmap' VALUES (3963, 8, 728, 2164);
INSERT INTO 'albumsrecordingsmap' VALUES (3964, 9, 728, 2165);
INSERT INTO 'albumsrecordingsmap' VALUES (3965, 10, 728, 2166);
INSERT INTO 'albumsrecordingsmap' VALUES (3966, 11, 728, 2167);
INSERT INTO 'albumsrecordingsmap' VALUES (3967, 13, 728, 2169);
INSERT INTO 'albumsrecordingsmap' VALUES (3969, 15, 728, 2171);
INSERT INTO 'albumsrecordingsmap' VALUES (3970, 1, 728, 3882);
INSERT INTO 'albumsrecordingsmap' VALUES (3971, 2, 728, 3884);
INSERT INTO 'albumsrecordingsmap' VALUES (3972, 3, 728, 3885);
INSERT INTO 'albumsrecordingsmap' VALUES (3973, 4, 728, 3886);
INSERT INTO 'albumsrecordingsmap' VALUES (3974, 5, 728, 3887);
INSERT INTO 'albumsrecordingsmap' VALUES (3975, 1, 777, 3888);
INSERT INTO 'albumsrecordingsmap' VALUES (3976, 2, 777, 3889);
INSERT INTO 'albumsrecordingsmap' VALUES (3977, 3, 777, 3890);
INSERT INTO 'albumsrecordingsmap' VALUES (3978, 4, 777, 3891);
INSERT INTO 'albumsrecordingsmap' VALUES (3979, 5, 777, 3892);
INSERT INTO 'albumsrecordingsmap' VALUES (3980, 6, 777, 3893);
INSERT INTO 'albumsrecordingsmap' VALUES (3981, 7, 777, 3894);
INSERT INTO 'albumsrecordingsmap' VALUES (3982, 8, 777, 3895);
INSERT INTO 'albumsrecordingsmap' VALUES (3983, 9, 777, 3896);
INSERT INTO 'albumsrecordingsmap' VALUES (3984, 10, 777, 3897);
INSERT INTO 'albumsrecordingsmap' VALUES (3985, 11, 777, 3898);
INSERT INTO 'albumsrecordingsmap' VALUES (3986, 12, 777, 3899);
INSERT INTO 'albumsrecordingsmap' VALUES (3987, 2, 408, 3901);
INSERT INTO 'albumsrecordingsmap' VALUES (3988, 1, 408, 3900);
INSERT INTO 'albumsrecordingsmap' VALUES (3989, 3, 408, 3902);
INSERT INTO 'albumsrecordingsmap' VALUES (3990, 4, 408, 3903);
INSERT INTO 'albumsrecordingsmap' VALUES (3991, 5, 408, 3904);
INSERT INTO 'albumsrecordingsmap' VALUES (3992, 6, 408, 3905);
INSERT INTO 'albumsrecordingsmap' VALUES (3993, 7, 408, 3906);
INSERT INTO 'albumsrecordingsmap' VALUES (3994, 8, 408, 3907);
INSERT INTO 'albumsrecordingsmap' VALUES (3995, 9, 408, 3908);
INSERT INTO 'albumsrecordingsmap' VALUES (3996, 10, 408, 2432);
INSERT INTO 'albumsrecordingsmap' VALUES (3997, 11, 408, 2547);
INSERT INTO 'albumsrecordingsmap' VALUES (3998, 12, 408, 2568);
INSERT INTO 'albumsrecordingsmap' VALUES (3999, 13, 408, 3033);
INSERT INTO 'albumsrecordingsmap' VALUES (4000, 14, 408, 3084);
INSERT INTO 'albumsrecordingsmap' VALUES (4001, 1, 771, 3087);
INSERT INTO 'albumsrecordingsmap' VALUES (4002, 2, 771, 3793);
INSERT INTO 'albumsrecordingsmap' VALUES (4003, 3, 771, 3794);
INSERT INTO 'albumsrecordingsmap' VALUES (4004, 4, 771, 3796);
INSERT INTO 'albumsrecordingsmap' VALUES (4005, 5, 771, 3797);
INSERT INTO 'albumsrecordingsmap' VALUES (4006, 6, 771, 3858);
INSERT INTO 'albumsrecordingsmap' VALUES (4007, 7, 771, 3860);
INSERT INTO 'albumsrecordingsmap' VALUES (4008, 8, 771, 3864);
INSERT INTO 'albumsrecordingsmap' VALUES (4009, 9, 771, 3866);
INSERT INTO 'albumsrecordingsmap' VALUES (4010, 10, 771, 3883);
INSERT INTO 'albumsrecordingsmap' VALUES (4011, 11, 771, 3909);
INSERT INTO 'albumsrecordingsmap' VALUES (4012, 12, 771, 3910);
INSERT INTO 'albumsrecordingsmap' VALUES (4013, 13, 771, 3911);
INSERT INTO 'albumsrecordingsmap' VALUES (4014, 14, 771, 3912);
INSERT INTO 'albumsrecordingsmap' VALUES (4015, 15, 771, 3913);
INSERT INTO 'albumsrecordingsmap' VALUES (4016, 16, 771, 3914);
INSERT INTO 'albumsrecordingsmap' VALUES (4017, 17, 771, 2723);
INSERT INTO 'albumsrecordingsmap' VALUES (4018, 1, 841, 3916);
INSERT INTO 'albumsrecordingsmap' VALUES (4019, 2, 841, 3917);
INSERT INTO 'albumsrecordingsmap' VALUES (4020, 3, 841, 3918);
INSERT INTO 'albumsrecordingsmap' VALUES (4021, 4, 841, 3919);
INSERT INTO 'albumsrecordingsmap' VALUES (4022, 5, 841, 3920);
INSERT INTO 'albumsrecordingsmap' VALUES (4023, 6, 841, 3921);
INSERT INTO 'albumsrecordingsmap' VALUES (4024, 7, 841, 3922);
INSERT INTO 'albumsrecordingsmap' VALUES (4025, 8, 841, 3923);
INSERT INTO 'albumsrecordingsmap' VALUES (4026, 9, 841, 3924);
INSERT INTO 'albumsrecordingsmap' VALUES (4027, 10, 841, 3925);
INSERT INTO 'albumsrecordingsmap' VALUES (4028, 11, 841, 3926);
INSERT INTO 'albumsrecordingsmap' VALUES (4029, 1, 751, 3927);
INSERT INTO 'albumsrecordingsmap' VALUES (4030, 2, 751, 3928);
INSERT INTO 'albumsrecordingsmap' VALUES (4031, 6, 751, 3929);
INSERT INTO 'albumsrecordingsmap' VALUES (4032, 8, 751, 3930);
INSERT INTO 'albumsrecordingsmap' VALUES (4033, 11, 751, 3931);
INSERT INTO 'albumsrecordingsmap' VALUES (4034, 1, 301, 3932);
INSERT INTO 'albumsrecordingsmap' VALUES (4035, 16, 301, 3933);
INSERT INTO 'albumsrecordingsmap' VALUES (4036, 18, 301, 3934);
INSERT INTO 'albumsrecordingsmap' VALUES (4037, 1, 399, 3082);
INSERT INTO 'albumsrecordingsmap' VALUES (4038, 2, 399, 3083);
INSERT INTO 'albumsrecordingsmap' VALUES (4039, 3, 399, 3795);
INSERT INTO 'albumsrecordingsmap' VALUES (4040, 4, 399, 3085);
INSERT INTO 'albumsrecordingsmap' VALUES (4041, 5, 399, 3086);
INSERT INTO 'albumsrecordingsmap' VALUES (4042, 6, 399, 3798);
INSERT INTO 'albumsrecordingsmap' VALUES (4043, 7, 399, 3088);
INSERT INTO 'albumsrecordingsmap' VALUES (4044, 8, 399, 3089);
INSERT INTO 'albumsrecordingsmap' VALUES (4045, 1, 715, 3649);
INSERT INTO 'albumsrecordingsmap' VALUES (4046, 2, 715, 3935);
INSERT INTO 'albumsrecordingsmap' VALUES (4047, 3, 715, 3936);
INSERT INTO 'albumsrecordingsmap' VALUES (4048, 4, 715, 3937);
INSERT INTO 'albumsrecordingsmap' VALUES (4049, 5, 715, 3938);
INSERT INTO 'albumsrecordingsmap' VALUES (4050, 6, 715, 3939);
INSERT INTO 'albumsrecordingsmap' VALUES (4051, 7, 715, 3940);
INSERT INTO 'albumsrecordingsmap' VALUES (4052, 8, 715, 3941);
INSERT INTO 'albumsrecordingsmap' VALUES (4053, 9, 715, 3942);
INSERT INTO 'albumsrecordingsmap' VALUES (4054, 10, 715, 3943);
INSERT INTO 'albumsrecordingsmap' VALUES (4055, 11, 715, 3944);
INSERT INTO 'albumsrecordingsmap' VALUES (4056, 12, 715, 3945);
INSERT INTO 'albumsrecordingsmap' VALUES (4057, 1, 832, 3946);
INSERT INTO 'albumsrecordingsmap' VALUES (4058, 2, 832, 3947);
INSERT INTO 'albumsrecordingsmap' VALUES (4059, 3, 832, 3948);
INSERT INTO 'albumsrecordingsmap' VALUES (4060, 4, 832, 3949);
INSERT INTO 'albumsrecordingsmap' VALUES (4061, 5, 832, 3950);
INSERT INTO 'albumsrecordingsmap' VALUES (4062, 6, 832, 3951);
INSERT INTO 'albumsrecordingsmap' VALUES (4063, 7, 832, 3952);
INSERT INTO 'albumsrecordingsmap' VALUES (4064, 8, 832, 3953);
INSERT INTO 'albumsrecordingsmap' VALUES (4065, 9, 832, 3954);
INSERT INTO 'albumsrecordingsmap' VALUES (4066, 10, 832, 3955);
INSERT INTO 'albumsrecordingsmap' VALUES (4067, 11, 832, 3956);
INSERT INTO 'albumsrecordingsmap' VALUES (4068, 12, 832, 3957);
INSERT INTO 'albumsrecordingsmap' VALUES (4069, 13, 832, 3958);
INSERT INTO 'albumsrecordingsmap' VALUES (4070, 14, 832, 3959);
INSERT INTO 'albumsrecordingsmap' VALUES (4071, 15, 832, 3960);
INSERT INTO 'albumsrecordingsmap' VALUES (4072, 16, 832, 3961);
INSERT INTO 'albumsrecordingsmap' VALUES (4073, 1, 805, 3962);
INSERT INTO 'albumsrecordingsmap' VALUES (4074, 2, 805, 3963);
INSERT INTO 'albumsrecordingsmap' VALUES (4075, 3, 805, 3964);
INSERT INTO 'albumsrecordingsmap' VALUES (4076, 4, 805, 3965);
INSERT INTO 'albumsrecordingsmap' VALUES (4077, 5, 805, 3966);
INSERT INTO 'albumsrecordingsmap' VALUES (4078, 6, 805, 3967);
INSERT INTO 'albumsrecordingsmap' VALUES (4079, 7, 805, 3968);
INSERT INTO 'albumsrecordingsmap' VALUES (4080, 8, 805, 3969);
INSERT INTO 'albumsrecordingsmap' VALUES (4081, 9, 805, 3970);
INSERT INTO 'albumsrecordingsmap' VALUES (4082, 10, 805, 3971);
INSERT INTO 'albumsrecordingsmap' VALUES (4083, 11, 805, 3972);
INSERT INTO 'albumsrecordingsmap' VALUES (4084, 12, 805, 3973);
INSERT INTO 'albumsrecordingsmap' VALUES (4085, 1, 703, 3974);
INSERT INTO 'albumsrecordingsmap' VALUES (4086, 2, 703, 3975);
INSERT INTO 'albumsrecordingsmap' VALUES (4087, 3, 703, 3976);
INSERT INTO 'albumsrecordingsmap' VALUES (4088, 4, 703, 3977);
INSERT INTO 'albumsrecordingsmap' VALUES (4089, 5, 703, 3978);
INSERT INTO 'albumsrecordingsmap' VALUES (4090, 6, 703, 3979);
INSERT INTO 'albumsrecordingsmap' VALUES (4091, 7, 703, 3980);
INSERT INTO 'albumsrecordingsmap' VALUES (4092, 8, 703, 3981);
INSERT INTO 'albumsrecordingsmap' VALUES (4093, 1, 803, 3982);
INSERT INTO 'albumsrecordingsmap' VALUES (4094, 2, 803, 3983);
INSERT INTO 'albumsrecordingsmap' VALUES (4095, 3, 803, 3984);
INSERT INTO 'albumsrecordingsmap' VALUES (4096, 4, 803, 3985);
INSERT INTO 'albumsrecordingsmap' VALUES (4097, 5, 803, 3986);
INSERT INTO 'albumsrecordingsmap' VALUES (4098, 6, 803, 3987);
INSERT INTO 'albumsrecordingsmap' VALUES (4099, 7, 803, 3988);
INSERT INTO 'albumsrecordingsmap' VALUES (4100, 8, 803, 3989);
INSERT INTO 'albumsrecordingsmap' VALUES (4101, 9, 803, 3990);
INSERT INTO 'albumsrecordingsmap' VALUES (4102, 10, 803, 3991);
INSERT INTO 'albumsrecordingsmap' VALUES (4103, 11, 803, 3992);
INSERT INTO 'albumsrecordingsmap' VALUES (4104, 12, 803, 3993);
INSERT INTO 'albumsrecordingsmap' VALUES (4105, 13, 803, 3994);
INSERT INTO 'albumsrecordingsmap' VALUES (4106, 1, 743, 3995);
INSERT INTO 'albumsrecordingsmap' VALUES (4107, 2, 743, 3996);
INSERT INTO 'albumsrecordingsmap' VALUES (4108, 3, 743, 3997);
INSERT INTO 'albumsrecordingsmap' VALUES (4109, 4, 743, 3998);
INSERT INTO 'albumsrecordingsmap' VALUES (4110, 5, 743, 3999);
INSERT INTO 'albumsrecordingsmap' VALUES (4111, 6, 743, 4000);
INSERT INTO 'albumsrecordingsmap' VALUES (4112, 7, 743, 4001);
INSERT INTO 'albumsrecordingsmap' VALUES (4113, 8, 743, 4002);
INSERT INTO 'albumsrecordingsmap' VALUES (4114, 9, 743, 4003);
INSERT INTO 'albumsrecordingsmap' VALUES (4115, 10, 743, 4004);
INSERT INTO 'albumsrecordingsmap' VALUES (4116, 11, 743, 4005);
INSERT INTO 'albumsrecordingsmap' VALUES (4117, 12, 743, 4006);
INSERT INTO 'albumsrecordingsmap' VALUES (4118, 13, 743, 4007);
INSERT INTO 'albumsrecordingsmap' VALUES (4119, 14, 743, 4008);
INSERT INTO 'albumsrecordingsmap' VALUES (4120, 15, 743, 4009);
INSERT INTO 'albumsrecordingsmap' VALUES (4121, 16, 743, 4010);
INSERT INTO 'albumsrecordingsmap' VALUES (4122, 17, 743, 4011);
INSERT INTO 'albumsrecordingsmap' VALUES (4123, 18, 743, 4012);
INSERT INTO 'albumsrecordingsmap' VALUES (4124, 19, 743, 4013);
INSERT INTO 'albumsrecordingsmap' VALUES (4125, 20, 743, 4014);
INSERT INTO 'albumsrecordingsmap' VALUES (4126, 21, 743, 4015);
INSERT INTO 'albumsrecordingsmap' VALUES (4127, 22, 743, 4016);
INSERT INTO 'albumsrecordingsmap' VALUES (4128, 23, 743, 4017);
INSERT INTO 'albumsrecordingsmap' VALUES (4131, 1, 755, 4021);
INSERT INTO 'albumsrecordingsmap' VALUES (4132, 2, 755, 4022);
INSERT INTO 'albumsrecordingsmap' VALUES (4133, 4, 755, 4024);
INSERT INTO 'albumsrecordingsmap' VALUES (4134, 5, 755, 4025);
INSERT INTO 'albumsrecordingsmap' VALUES (4135, 6, 755, 4026);
INSERT INTO 'albumsrecordingsmap' VALUES (4136, 7, 755, 4027);
INSERT INTO 'albumsrecordingsmap' VALUES (4137, 9, 755, 4029);
INSERT INTO 'albumsrecordingsmap' VALUES (4138, 10, 755, 4030);
INSERT INTO 'albumsrecordingsmap' VALUES (4139, 11, 755, 4031);
INSERT INTO 'albumsrecordingsmap' VALUES (4140, 12, 755, 4032);
INSERT INTO 'albumsrecordingsmap' VALUES (4141, 13, 755, 4033);
INSERT INTO 'albumsrecordingsmap' VALUES (4142, 14, 755, 4034);
INSERT INTO 'albumsrecordingsmap' VALUES (4143, 1, 754, 4035);
INSERT INTO 'albumsrecordingsmap' VALUES (4144, 2, 754, 4036);
INSERT INTO 'albumsrecordingsmap' VALUES (4145, 3, 754, 4037);
INSERT INTO 'albumsrecordingsmap' VALUES (4146, 4, 754, 4038);
INSERT INTO 'albumsrecordingsmap' VALUES (4147, 5, 754, 4039);
INSERT INTO 'albumsrecordingsmap' VALUES (4148, 6, 754, 4040);
INSERT INTO 'albumsrecordingsmap' VALUES (4149, 7, 754, 4041);
INSERT INTO 'albumsrecordingsmap' VALUES (4150, 8, 754, 4042);
INSERT INTO 'albumsrecordingsmap' VALUES (4151, 9, 754, 4043);
INSERT INTO 'albumsrecordingsmap' VALUES (4152, 17, 200, 4044);
INSERT INTO 'albumsrecordingsmap' VALUES (4153, 3, 414, 4046);
INSERT INTO 'albumsrecordingsmap' VALUES (4154, 1, 368, 4047);
INSERT INTO 'albumsrecordingsmap' VALUES (4155, 2, 368, 4048);
INSERT INTO 'albumsrecordingsmap' VALUES (4156, 3, 368, 4049);
INSERT INTO 'albumsrecordingsmap' VALUES (4157, 4, 368, 4050);
INSERT INTO 'albumsrecordingsmap' VALUES (4158, 5, 368, 4051);
INSERT INTO 'albumsrecordingsmap' VALUES (4159, 6, 368, 4052);
INSERT INTO 'albumsrecordingsmap' VALUES (4160, 7, 368, 4053);
INSERT INTO 'albumsrecordingsmap' VALUES (4161, 8, 368, 4054);
INSERT INTO 'albumsrecordingsmap' VALUES (4162, 9, 368, 4055);
INSERT INTO 'albumsrecordingsmap' VALUES (4163, 10, 368, 4056);
INSERT INTO 'albumsrecordingsmap' VALUES (4164, 11, 368, 4057);
INSERT INTO 'albumsrecordingsmap' VALUES (4165, 12, 368, 4058);
INSERT INTO 'albumsrecordingsmap' VALUES (4166, 13, 368, 4059);
INSERT INTO 'albumsrecordingsmap' VALUES (4167, 1, 417, 4060);
INSERT INTO 'albumsrecordingsmap' VALUES (4168, 2, 417, 4061);
INSERT INTO 'albumsrecordingsmap' VALUES (4169, 3, 417, 4062);
INSERT INTO 'albumsrecordingsmap' VALUES (4170, 4, 417, 4063);
INSERT INTO 'albumsrecordingsmap' VALUES (4171, 5, 417, 4064);
INSERT INTO 'albumsrecordingsmap' VALUES (4172, 6, 417, 4065);
INSERT INTO 'albumsrecordingsmap' VALUES (4173, 7, 417, 4066);
INSERT INTO 'albumsrecordingsmap' VALUES (4174, 8, 417, 4067);
INSERT INTO 'albumsrecordingsmap' VALUES (4175, 9, 417, 4068);
INSERT INTO 'albumsrecordingsmap' VALUES (4176, 10, 417, 4069);
INSERT INTO 'albumsrecordingsmap' VALUES (4177, 11, 417, 4070);
INSERT INTO 'albumsrecordingsmap' VALUES (4178, 12, 417, 4071);
INSERT INTO 'albumsrecordingsmap' VALUES (4179, 1, 418, 2378);
INSERT INTO 'albumsrecordingsmap' VALUES (4180, 2, 418, 4072);
INSERT INTO 'albumsrecordingsmap' VALUES (4181, 6, 247, 23);
INSERT INTO 'albumsrecordingsmap' VALUES (4182, 3, 418, 23);
INSERT INTO 'albumsrecordingsmap' VALUES (4183, 1, 419, 4080);
INSERT INTO 'albumsrecordingsmap' VALUES (4184, 2, 419, 4081);
INSERT INTO 'albumsrecordingsmap' VALUES (4185, 3, 419, 4082);
INSERT INTO 'albumsrecordingsmap' VALUES (4186, 4, 419, 4083);
INSERT INTO 'albumsrecordingsmap' VALUES (4187, 5, 419, 4084);
INSERT INTO 'albumsrecordingsmap' VALUES (4188, 6, 419, 4085);
INSERT INTO 'albumsrecordingsmap' VALUES (4189, 7, 419, 4086);
INSERT INTO 'albumsrecordingsmap' VALUES (4190, 9, 419, 4087);
INSERT INTO 'albumsrecordingsmap' VALUES (4191, 10, 419, 4088);
INSERT INTO 'albumsrecordingsmap' VALUES (4192, 11, 419, 4089);
INSERT INTO 'albumsrecordingsmap' VALUES (4193, 12, 419, 4090);
INSERT INTO 'albumsrecordingsmap' VALUES (4194, 13, 419, 4091);
INSERT INTO 'albumsrecordingsmap' VALUES (4195, 14, 419, 4092);
INSERT INTO 'albumsrecordingsmap' VALUES (4196, 15, 419, 4093);
INSERT INTO 'albumsrecordingsmap' VALUES (4197, 16, 419, 4094);
INSERT INTO 'albumsrecordingsmap' VALUES (4198, 8, 755, 2030);
INSERT INTO 'albumsrecordingsmap' VALUES (4199, 3, 755, 2032);
INSERT INTO 'albumsrecordingsmap' VALUES (4200, 5, 193, 4029);
INSERT INTO 'albumsrecordingsmap' VALUES (4201, 8, 193, 2016);
INSERT INTO 'albumsrecordingsmap' VALUES (4202, 10, 183, 2040);
INSERT INTO 'albumsrecordingsmap' VALUES (4203, 11, 193, 4022);
INSERT INTO 'albumsrecordingsmap' VALUES (4204, 1, 420, 4095);
INSERT INTO 'albumsrecordingsmap' VALUES (4205, 2, 420, 4096);
INSERT INTO 'albumsrecordingsmap' VALUES (4206, 3, 420, 4097);
INSERT INTO 'albumsrecordingsmap' VALUES (4207, 4, 420, 4098);
INSERT INTO 'albumsrecordingsmap' VALUES (4208, 5, 420, 4099);
INSERT INTO 'albumsrecordingsmap' VALUES (4209, 6, 420, 4100);
INSERT INTO 'albumsrecordingsmap' VALUES (4210, 7, 420, 4101);
INSERT INTO 'albumsrecordingsmap' VALUES (4211, 8, 420, 4102);
INSERT INTO 'albumsrecordingsmap' VALUES (4212, 1, 421, 4103);
INSERT INTO 'albumsrecordingsmap' VALUES (4213, 2, 421, 4104);
INSERT INTO 'albumsrecordingsmap' VALUES (4214, 3, 421, 4105);
INSERT INTO 'albumsrecordingsmap' VALUES (4215, 4, 421, 4106);
INSERT INTO 'albumsrecordingsmap' VALUES (4216, 5, 421, 4107);
INSERT INTO 'albumsrecordingsmap' VALUES (4217, 6, 421, 4108);
INSERT INTO 'albumsrecordingsmap' VALUES (4218, 7, 421, 4109);
INSERT INTO 'albumsrecordingsmap' VALUES (4219, 8, 421, 4110);
INSERT INTO 'albumsrecordingsmap' VALUES (4220, 9, 421, 1597);
INSERT INTO 'albumsrecordingsmap' VALUES (4221, 10, 421, 2029);
INSERT INTO 'albumsrecordingsmap' VALUES (4222, 11, 421, 2034);
INSERT INTO 'albumsrecordingsmap' VALUES (4223, 12, 421, 2038);
INSERT INTO 'albumsrecordingsmap' VALUES (4224, 1, 107, 2041);
INSERT INTO 'albumsrecordingsmap' VALUES (4225, 8, 107, 4023);
INSERT INTO 'albumsrecordingsmap' VALUES (4226, 9, 107, 4028);
INSERT INTO 'albumsrecordingsmap' VALUES (4227, 1, 124, 4111);
INSERT INTO 'albumsrecordingsmap' VALUES (4228, 2, 124, 4112);
INSERT INTO 'albumsrecordingsmap' VALUES (4229, 3, 124, 4113);
INSERT INTO 'albumsrecordingsmap' VALUES (4230, 6, 124, 4115);
INSERT INTO 'albumsrecordingsmap' VALUES (4231, 7, 124, 4116);
INSERT INTO 'albumsrecordingsmap' VALUES (4232, 8, 124, 4117);
INSERT INTO 'albumsrecordingsmap' VALUES (4233, 9, 124, 4118);
INSERT INTO 'albumsrecordingsmap' VALUES (4234, 10, 124, 4119);
INSERT INTO 'albumsrecordingsmap' VALUES (4235, 11, 124, 4120);
INSERT INTO 'albumsrecordingsmap' VALUES (4236, 12, 124, 4121);
INSERT INTO 'albumsrecordingsmap' VALUES (4237, 13, 124, 4122);
INSERT INTO 'albumsrecordingsmap' VALUES (4238, 1, 370, 4123);
INSERT INTO 'albumsrecordingsmap' VALUES (4239, 3, 370, 4125);
INSERT INTO 'albumsrecordingsmap' VALUES (4240, 2, 370, 1955);
INSERT INTO 'albumsrecordingsmap' VALUES (4241, 5, 370, 4127);
INSERT INTO 'albumsrecordingsmap' VALUES (4242, 6, 370, 4128);
INSERT INTO 'albumsrecordingsmap' VALUES (4243, 7, 370, 4129);
INSERT INTO 'albumsrecordingsmap' VALUES (4244, 8, 370, 4130);
INSERT INTO 'albumsrecordingsmap' VALUES (4245, 5, 213, 4131);
INSERT INTO 'albumsrecordingsmap' VALUES (4246, 14, 213, 4132);
INSERT INTO 'albumsrecordingsmap' VALUES (4247, 16, 213, 4133);
INSERT INTO 'albumsrecordingsmap' VALUES (4248, 18, 213, 4134);
INSERT INTO 'albumsrecordingsmap' VALUES (4249, 1, 864, 4135);
INSERT INTO 'albumsrecordingsmap' VALUES (4250, 2, 864, 4136);
INSERT INTO 'albumsrecordingsmap' VALUES (4251, 3, 864, 4137);
INSERT INTO 'albumsrecordingsmap' VALUES (4252, 4, 864, 4138);
INSERT INTO 'albumsrecordingsmap' VALUES (4253, 5, 864, 4139);
INSERT INTO 'albumsrecordingsmap' VALUES (4254, 6, 864, 4140);
INSERT INTO 'albumsrecordingsmap' VALUES (4255, 7, 864, 4141);
INSERT INTO 'albumsrecordingsmap' VALUES (4256, 8, 864, 4142);
INSERT INTO 'albumsrecordingsmap' VALUES (4257, 9, 864, 4143);
INSERT INTO 'albumsrecordingsmap' VALUES (4258, 10, 864, 4144);
INSERT INTO 'albumsrecordingsmap' VALUES (4259, 11, 864, 4145);
INSERT INTO 'albumsrecordingsmap' VALUES (4260, 12, 864, 4146);
INSERT INTO 'albumsrecordingsmap' VALUES (4261, 1, 723, 4147);
INSERT INTO 'albumsrecordingsmap' VALUES (4262, 2, 723, 4148);
INSERT INTO 'albumsrecordingsmap' VALUES (4263, 3, 723, 4149);
INSERT INTO 'albumsrecordingsmap' VALUES (4264, 4, 723, 4150);
INSERT INTO 'albumsrecordingsmap' VALUES (4265, 5, 723, 4151);
INSERT INTO 'albumsrecordingsmap' VALUES (4266, 6, 723, 4152);
INSERT INTO 'albumsrecordingsmap' VALUES (4267, 7, 723, 4153);
INSERT INTO 'albumsrecordingsmap' VALUES (4268, 8, 723, 4154);
INSERT INTO 'albumsrecordingsmap' VALUES (4269, 9, 723, 4155);
INSERT INTO 'albumsrecordingsmap' VALUES (4270, 10, 723, 4156);
INSERT INTO 'albumsrecordingsmap' VALUES (4271, 11, 723, 4157);
INSERT INTO 'albumsrecordingsmap' VALUES (4272, 12, 723, 4158);
INSERT INTO 'albumsrecordingsmap' VALUES (4273, 15, 747, 1954);
INSERT INTO 'albumsrecordingsmap' VALUES (4274, 1, 747, 1965);
INSERT INTO 'albumsrecordingsmap' VALUES (4275, 2, 747, 1959);
INSERT INTO 'albumsrecordingsmap' VALUES (4276, 3, 225, 4127);
INSERT INTO 'albumsrecordingsmap' VALUES (4277, 3, 747, 4127);
INSERT INTO 'albumsrecordingsmap' VALUES (4278, 4, 747, 3105);
INSERT INTO 'albumsrecordingsmap' VALUES (4279, 4, 225, 3105);
INSERT INTO 'albumsrecordingsmap' VALUES (4280, 5, 225, 4130);
INSERT INTO 'albumsrecordingsmap' VALUES (4281, 5, 747, 4130);
INSERT INTO 'albumsrecordingsmap' VALUES (4282, 6, 747, 1957);
INSERT INTO 'albumsrecordingsmap' VALUES (4283, 7, 747, 3192);
INSERT INTO 'albumsrecordingsmap' VALUES (4284, 7, 225, 3192);
INSERT INTO 'albumsrecordingsmap' VALUES (4285, 8, 747, 1966);
INSERT INTO 'albumsrecordingsmap' VALUES (4287, 9, 747, 1960);
INSERT INTO 'albumsrecordingsmap' VALUES (4288, 4, 370, 1963);
INSERT INTO 'albumsrecordingsmap' VALUES (4289, 11, 747, 1963);
INSERT INTO 'albumsrecordingsmap' VALUES (4290, 12, 225, 4170);
INSERT INTO 'albumsrecordingsmap' VALUES (4291, 10, 747, 1955);
INSERT INTO 'albumsrecordingsmap' VALUES (4292, 14, 225, 4172);
INSERT INTO 'albumsrecordingsmap' VALUES (4293, 14, 747, 4172);
INSERT INTO 'albumsrecordingsmap' VALUES (4294, 7, 304, 4172);
INSERT INTO 'albumsrecordingsmap' VALUES (4295, 13, 747, 1962);
INSERT INTO 'albumsrecordingsmap' VALUES (4296, 12, 747, 4170);
INSERT INTO 'albumsrecordingsmap' VALUES (4297, 12, 33, 3056);
INSERT INTO 'albumsrecordingsmap' VALUES (4298, 13, 33, 3064);
INSERT INTO 'albumsrecordingsmap' VALUES (4300, 2, 326, 536);
INSERT INTO 'albumsrecordingsmap' VALUES (4301, 3, 326, 1956);
INSERT INTO 'albumsrecordingsmap' VALUES (4302, 4, 326, 1958);
INSERT INTO 'albumsrecordingsmap' VALUES (4303, 5, 326, 1961);
INSERT INTO 'albumsrecordingsmap' VALUES (4304, 6, 326, 1964);
INSERT INTO 'albumsrecordingsmap' VALUES (4305, 7, 326, 1967);
INSERT INTO 'albumsrecordingsmap' VALUES (4306, 8, 326, 1968);
INSERT INTO 'albumsrecordingsmap' VALUES (4307, 9, 326, 3112);
INSERT INTO 'albumsrecordingsmap' VALUES (4308, 10, 326, 3707);
INSERT INTO 'albumsrecordingsmap' VALUES (4309, 11, 326, 4019);
INSERT INTO 'albumsrecordingsmap' VALUES (4310, 12, 326, 4126);
INSERT INTO 'albumsrecordingsmap' VALUES (4311, 1, 374, 4159);
INSERT INTO 'albumsrecordingsmap' VALUES (4312, 2, 374, 4160);
INSERT INTO 'albumsrecordingsmap' VALUES (4313, 3, 374, 4161);
INSERT INTO 'albumsrecordingsmap' VALUES (4314, 4, 374, 4162);
INSERT INTO 'albumsrecordingsmap' VALUES (4315, 5, 374, 4163);
INSERT INTO 'albumsrecordingsmap' VALUES (4316, 6, 374, 4164);
INSERT INTO 'albumsrecordingsmap' VALUES (4317, 7, 374, 4165);
INSERT INTO 'albumsrecordingsmap' VALUES (4318, 8, 374, 4166);
INSERT INTO 'albumsrecordingsmap' VALUES (4319, 9, 374, 4167);
INSERT INTO 'albumsrecordingsmap' VALUES (4320, 5, 302, 74);
INSERT INTO 'albumsrecordingsmap' VALUES (4321, 8, 340, 613);
INSERT INTO 'albumsrecordingsmap' VALUES (4322, 9, 340, 716);
INSERT INTO 'albumsrecordingsmap' VALUES (4299, 1, 326, 7529);
INSERT INTO 'albumsrecordingsmap' VALUES (10782, 3, 1111, 10188);
INSERT INTO 'albumsrecordingsmap' VALUES (10783, 4, 1111, 10189);
INSERT INTO 'albumsrecordingsmap' VALUES (10784, 5, 1111, 10190);
INSERT INTO 'albumsrecordingsmap' VALUES (10785, 6, 1111, 10191);
INSERT INTO 'albumsrecordingsmap' VALUES (10786, 7, 1111, 10192);
INSERT INTO 'albumsrecordingsmap' VALUES (4339, 1, 836, 4173);
INSERT INTO 'albumsrecordingsmap' VALUES (4340, 2, 836, 4174);
INSERT INTO 'albumsrecordingsmap' VALUES (4341, 3, 836, 4176);
INSERT INTO 'albumsrecordingsmap' VALUES (4342, 4, 836, 4175);
INSERT INTO 'albumsrecordingsmap' VALUES (4343, 5, 836, 4177);
INSERT INTO 'albumsrecordingsmap' VALUES (4344, 6, 836, 4178);
INSERT INTO 'albumsrecordingsmap' VALUES (4345, 7, 836, 4179);
INSERT INTO 'albumsrecordingsmap' VALUES (4346, 8, 836, 4180);
INSERT INTO 'albumsrecordingsmap' VALUES (4347, 9, 836, 4181);
INSERT INTO 'albumsrecordingsmap' VALUES (4348, 10, 836, 4182);
INSERT INTO 'albumsrecordingsmap' VALUES (4349, 11, 836, 4183);
INSERT INTO 'albumsrecordingsmap' VALUES (4350, 12, 836, 4184);
INSERT INTO 'albumsrecordingsmap' VALUES (4351, 13, 836, 4185);
INSERT INTO 'albumsrecordingsmap' VALUES (4352, 14, 836, 4186);
INSERT INTO 'albumsrecordingsmap' VALUES (4353, 1, 734, 4187);
INSERT INTO 'albumsrecordingsmap' VALUES (4354, 2, 734, 4188);
INSERT INTO 'albumsrecordingsmap' VALUES (4355, 3, 734, 4189);
INSERT INTO 'albumsrecordingsmap' VALUES (4356, 4, 734, 4190);
INSERT INTO 'albumsrecordingsmap' VALUES (4357, 5, 734, 4191);
INSERT INTO 'albumsrecordingsmap' VALUES (4358, 6, 734, 4192);
INSERT INTO 'albumsrecordingsmap' VALUES (4359, 7, 734, 4193);
INSERT INTO 'albumsrecordingsmap' VALUES (4360, 8, 734, 4194);
INSERT INTO 'albumsrecordingsmap' VALUES (4361, 1, 750, 4195);
INSERT INTO 'albumsrecordingsmap' VALUES (4362, 2, 750, 4196);
INSERT INTO 'albumsrecordingsmap' VALUES (4363, 3, 750, 4197);
INSERT INTO 'albumsrecordingsmap' VALUES (4364, 4, 750, 4198);
INSERT INTO 'albumsrecordingsmap' VALUES (4365, 5, 750, 4199);
INSERT INTO 'albumsrecordingsmap' VALUES (4366, 6, 750, 4200);
INSERT INTO 'albumsrecordingsmap' VALUES (4367, 7, 750, 4201);
INSERT INTO 'albumsrecordingsmap' VALUES (4368, 8, 750, 4202);
INSERT INTO 'albumsrecordingsmap' VALUES (4369, 9, 750, 4203);
INSERT INTO 'albumsrecordingsmap' VALUES (4370, 10, 750, 4204);
INSERT INTO 'albumsrecordingsmap' VALUES (4371, 11, 750, 4205);
INSERT INTO 'albumsrecordingsmap' VALUES (4372, 12, 750, 4206);
INSERT INTO 'albumsrecordingsmap' VALUES (4373, 13, 750, 4207);
INSERT INTO 'albumsrecordingsmap' VALUES (4374, 14, 750, 4208);
INSERT INTO 'albumsrecordingsmap' VALUES (4375, 15, 750, 4209);
INSERT INTO 'albumsrecordingsmap' VALUES (4376, 16, 750, 4210);
INSERT INTO 'albumsrecordingsmap' VALUES (4377, 17, 750, 4211);
INSERT INTO 'albumsrecordingsmap' VALUES (4378, 18, 750, 4212);
INSERT INTO 'albumsrecordingsmap' VALUES (4379, 1, 376, 4213);
INSERT INTO 'albumsrecordingsmap' VALUES (4380, 2, 376, 4214);
INSERT INTO 'albumsrecordingsmap' VALUES (4381, 3, 376, 4215);
INSERT INTO 'albumsrecordingsmap' VALUES (4382, 4, 376, 4216);
INSERT INTO 'albumsrecordingsmap' VALUES (4383, 5, 376, 4217);
INSERT INTO 'albumsrecordingsmap' VALUES (4384, 6, 376, 4218);
INSERT INTO 'albumsrecordingsmap' VALUES (4385, 7, 376, 4219);
INSERT INTO 'albumsrecordingsmap' VALUES (4386, 8, 376, 4220);
INSERT INTO 'albumsrecordingsmap' VALUES (4387, 9, 376, 4221);
INSERT INTO 'albumsrecordingsmap' VALUES (4388, 10, 376, 4222);
INSERT INTO 'albumsrecordingsmap' VALUES (4389, 11, 376, 4223);
INSERT INTO 'albumsrecordingsmap' VALUES (4390, 12, 376, 4224);
INSERT INTO 'albumsrecordingsmap' VALUES (4391, 5, 305, 4225);
INSERT INTO 'albumsrecordingsmap' VALUES (4392, 7, 305, 4226);
INSERT INTO 'albumsrecordingsmap' VALUES (4393, 10, 305, 4227);
INSERT INTO 'albumsrecordingsmap' VALUES (4394, 11, 305, 4228);
INSERT INTO 'albumsrecordingsmap' VALUES (4395, 12, 305, 4229);
INSERT INTO 'albumsrecordingsmap' VALUES (4396, 1, 381, 168);
INSERT INTO 'albumsrecordingsmap' VALUES (4397, 2, 381, 192);
INSERT INTO 'albumsrecordingsmap' VALUES (4398, 3, 381, 92);
INSERT INTO 'albumsrecordingsmap' VALUES (4399, 4, 381, 98);
INSERT INTO 'albumsrecordingsmap' VALUES (4400, 6, 381, 23);
INSERT INTO 'albumsrecordingsmap' VALUES (4401, 7, 381, 131);
INSERT INTO 'albumsrecordingsmap' VALUES (4402, 8, 381, 280);
INSERT INTO 'albumsrecordingsmap' VALUES (4403, 9, 381, 121);
INSERT INTO 'albumsrecordingsmap' VALUES (4404, 11, 381, 334);
INSERT INTO 'albumsrecordingsmap' VALUES (4405, 12, 381, 239);
INSERT INTO 'albumsrecordingsmap' VALUES (4406, 13, 381, 19);
INSERT INTO 'albumsrecordingsmap' VALUES (4407, 1, 709, 4230);
INSERT INTO 'albumsrecordingsmap' VALUES (4408, 2, 709, 4231);
INSERT INTO 'albumsrecordingsmap' VALUES (4409, 3, 709, 4232);
INSERT INTO 'albumsrecordingsmap' VALUES (4410, 4, 709, 4233);
INSERT INTO 'albumsrecordingsmap' VALUES (4411, 5, 709, 4234);
INSERT INTO 'albumsrecordingsmap' VALUES (4412, 6, 709, 4235);
INSERT INTO 'albumsrecordingsmap' VALUES (4413, 7, 709, 4236);
INSERT INTO 'albumsrecordingsmap' VALUES (4414, 8, 709, 4237);
INSERT INTO 'albumsrecordingsmap' VALUES (4415, 9, 709, 4238);
INSERT INTO 'albumsrecordingsmap' VALUES (4416, 10, 709, 4239);
INSERT INTO 'albumsrecordingsmap' VALUES (4417, 11, 709, 4240);
INSERT INTO 'albumsrecordingsmap' VALUES (4418, 12, 709, 4241);
INSERT INTO 'albumsrecordingsmap' VALUES (4419, 1, 415, 4242);
INSERT INTO 'albumsrecordingsmap' VALUES (4420, 2, 415, 1408);
INSERT INTO 'albumsrecordingsmap' VALUES (4421, 3, 415, 4243);
INSERT INTO 'albumsrecordingsmap' VALUES (4422, 4, 415, 4244);
INSERT INTO 'albumsrecordingsmap' VALUES (4423, 5, 415, 4245);
INSERT INTO 'albumsrecordingsmap' VALUES (4424, 6, 415, 4246);
INSERT INTO 'albumsrecordingsmap' VALUES (4425, 7, 415, 4247);
INSERT INTO 'albumsrecordingsmap' VALUES (4426, 8, 415, 4248);
INSERT INTO 'albumsrecordingsmap' VALUES (4427, 9, 415, 4249);
INSERT INTO 'albumsrecordingsmap' VALUES (4428, 10, 415, 4250);
INSERT INTO 'albumsrecordingsmap' VALUES (4429, 11, 415, 4251);
INSERT INTO 'albumsrecordingsmap' VALUES (4430, 12, 415, 4252);
INSERT INTO 'albumsrecordingsmap' VALUES (4431, 2, 269, 4253);
INSERT INTO 'albumsrecordingsmap' VALUES (4435, 1, 702, 4257);
INSERT INTO 'albumsrecordingsmap' VALUES (4436, 2, 702, 4258);
INSERT INTO 'albumsrecordingsmap' VALUES (4437, 3, 702, 4259);
INSERT INTO 'albumsrecordingsmap' VALUES (4438, 4, 702, 4260);
INSERT INTO 'albumsrecordingsmap' VALUES (4439, 5, 702, 4261);
INSERT INTO 'albumsrecordingsmap' VALUES (4440, 6, 702, 4262);
INSERT INTO 'albumsrecordingsmap' VALUES (4441, 7, 702, 4263);
INSERT INTO 'albumsrecordingsmap' VALUES (4442, 8, 702, 4264);
INSERT INTO 'albumsrecordingsmap' VALUES (4443, 9, 702, 4265);
INSERT INTO 'albumsrecordingsmap' VALUES (4444, 10, 702, 4266);
INSERT INTO 'albumsrecordingsmap' VALUES (4445, 11, 702, 4267);
INSERT INTO 'albumsrecordingsmap' VALUES (4446, 12, 702, 4268);
INSERT INTO 'albumsrecordingsmap' VALUES (4447, 13, 702, 4269);
INSERT INTO 'albumsrecordingsmap' VALUES (4448, 14, 702, 4270);
INSERT INTO 'albumsrecordingsmap' VALUES (4449, 15, 702, 4271);
INSERT INTO 'albumsrecordingsmap' VALUES (4451, 5, 89, 338);
INSERT INTO 'albumsrecordingsmap' VALUES (4452, 6, 89, 3767);
INSERT INTO 'albumsrecordingsmap' VALUES (4453, 8, 89, 3777);
INSERT INTO 'albumsrecordingsmap' VALUES (4454, 9, 89, 2905);
INSERT INTO 'albumsrecordingsmap' VALUES (4455, 13, 89, 2927);
INSERT INTO 'albumsrecordingsmap' VALUES (4456, 1, 732, 4273);
INSERT INTO 'albumsrecordingsmap' VALUES (4457, 3, 732, 4274);
INSERT INTO 'albumsrecordingsmap' VALUES (4458, 4, 732, 4275);
INSERT INTO 'albumsrecordingsmap' VALUES (4459, 5, 732, 4276);
INSERT INTO 'albumsrecordingsmap' VALUES (4460, 6, 732, 4277);
INSERT INTO 'albumsrecordingsmap' VALUES (4461, 7, 732, 4278);
INSERT INTO 'albumsrecordingsmap' VALUES (4462, 8, 732, 4279);
INSERT INTO 'albumsrecordingsmap' VALUES (4463, 9, 732, 4280);
INSERT INTO 'albumsrecordingsmap' VALUES (4286, 9, 800, 1960);
INSERT INTO 'albumsrecordingsmap' VALUES (4464, 10, 732, 4281);
INSERT INTO 'albumsrecordingsmap' VALUES (4465, 2, 732, 4282);
INSERT INTO 'albumsrecordingsmap' VALUES (4466, 11, 732, 4283);
INSERT INTO 'albumsrecordingsmap' VALUES (4467, 12, 732, 4284);
INSERT INTO 'albumsrecordingsmap' VALUES (4468, 13, 732, 4285);
INSERT INTO 'albumsrecordingsmap' VALUES (4469, 14, 732, 4286);
INSERT INTO 'albumsrecordingsmap' VALUES (4470, 15, 732, 4287);
INSERT INTO 'albumsrecordingsmap' VALUES (4471, 16, 732, 4288);
INSERT INTO 'albumsrecordingsmap' VALUES (4472, 17, 732, 4289);
INSERT INTO 'albumsrecordingsmap' VALUES (4473, 18, 732, 4290);
INSERT INTO 'albumsrecordingsmap' VALUES (4474, 1, 854, 1067);
INSERT INTO 'albumsrecordingsmap' VALUES (4475, 2, 854, 1069);
INSERT INTO 'albumsrecordingsmap' VALUES (4476, 3, 854, 1070);
INSERT INTO 'albumsrecordingsmap' VALUES (4477, 4, 854, 1074);
INSERT INTO 'albumsrecordingsmap' VALUES (4478, 5, 854, 3769);
INSERT INTO 'albumsrecordingsmap' VALUES (4479, 6, 854, 4291);
INSERT INTO 'albumsrecordingsmap' VALUES (4480, 7, 854, 4292);
INSERT INTO 'albumsrecordingsmap' VALUES (4481, 9, 854, 4293);
INSERT INTO 'albumsrecordingsmap' VALUES (4482, 8, 854, 3863);
INSERT INTO 'albumsrecordingsmap' VALUES (4483, 10, 854, 4294);
INSERT INTO 'albumsrecordingsmap' VALUES (4484, 11, 854, 4295);
INSERT INTO 'albumsrecordingsmap' VALUES (4485, 12, 854, 4296);
INSERT INTO 'albumsrecordingsmap' VALUES (4486, 13, 854, 4297);
INSERT INTO 'albumsrecordingsmap' VALUES (4487, 1, 716, 4025);
INSERT INTO 'albumsrecordingsmap' VALUES (4488, 13, 716, 4298);
INSERT INTO 'albumsrecordingsmap' VALUES (4489, 3, 716, 4299);
INSERT INTO 'albumsrecordingsmap' VALUES (4490, 4, 716, 4300);
INSERT INTO 'albumsrecordingsmap' VALUES (4491, 6, 716, 4301);
INSERT INTO 'albumsrecordingsmap' VALUES (4492, 8, 716, 4302);
INSERT INTO 'albumsrecordingsmap' VALUES (4493, 10, 716, 4303);
INSERT INTO 'albumsrecordingsmap' VALUES (4494, 1, 98, 4304);
INSERT INTO 'albumsrecordingsmap' VALUES (4495, 2, 98, 4305);
INSERT INTO 'albumsrecordingsmap' VALUES (4496, 3, 98, 4306);
INSERT INTO 'albumsrecordingsmap' VALUES (4497, 4, 98, 4307);
INSERT INTO 'albumsrecordingsmap' VALUES (4498, 5, 98, 4308);
INSERT INTO 'albumsrecordingsmap' VALUES (4499, 6, 98, 4309);
INSERT INTO 'albumsrecordingsmap' VALUES (4500, 7, 98, 4310);
INSERT INTO 'albumsrecordingsmap' VALUES (4501, 8, 98, 4311);
INSERT INTO 'albumsrecordingsmap' VALUES (4502, 9, 98, 4312);
INSERT INTO 'albumsrecordingsmap' VALUES (4503, 10, 98, 4313);
INSERT INTO 'albumsrecordingsmap' VALUES (4504, 11, 98, 4314);
INSERT INTO 'albumsrecordingsmap' VALUES (4505, 12, 98, 4315);
INSERT INTO 'albumsrecordingsmap' VALUES (4506, 6, 314, 4316);
INSERT INTO 'albumsrecordingsmap' VALUES (4507, 7, 314, 4317);
INSERT INTO 'albumsrecordingsmap' VALUES (4508, 1, 853, 4318);
INSERT INTO 'albumsrecordingsmap' VALUES (4509, 2, 853, 4319);
INSERT INTO 'albumsrecordingsmap' VALUES (4510, 3, 853, 4320);
INSERT INTO 'albumsrecordingsmap' VALUES (4511, 4, 853, 4321);
INSERT INTO 'albumsrecordingsmap' VALUES (4512, 5, 853, 4322);
INSERT INTO 'albumsrecordingsmap' VALUES (4513, 6, 853, 4323);
INSERT INTO 'albumsrecordingsmap' VALUES (4514, 7, 853, 4324);
INSERT INTO 'albumsrecordingsmap' VALUES (4515, 8, 853, 4325);
INSERT INTO 'albumsrecordingsmap' VALUES (4516, 9, 853, 4326);
INSERT INTO 'albumsrecordingsmap' VALUES (4517, 10, 853, 4327);
INSERT INTO 'albumsrecordingsmap' VALUES (4518, 11, 853, 4328);
INSERT INTO 'albumsrecordingsmap' VALUES (4519, 12, 853, 4329);
INSERT INTO 'albumsrecordingsmap' VALUES (4520, 13, 853, 4330);
INSERT INTO 'albumsrecordingsmap' VALUES (4521, 14, 853, 4331);
INSERT INTO 'albumsrecordingsmap' VALUES (4522, 15, 853, 1390);
INSERT INTO 'albumsrecordingsmap' VALUES (4523, 16, 853, 4332);
INSERT INTO 'albumsrecordingsmap' VALUES (4524, 17, 853, 4333);
INSERT INTO 'albumsrecordingsmap' VALUES (4525, 18, 853, 4334);
INSERT INTO 'albumsrecordingsmap' VALUES (4526, 19, 853, 4335);
INSERT INTO 'albumsrecordingsmap' VALUES (4527, 20, 853, 4336);
INSERT INTO 'albumsrecordingsmap' VALUES (4529, 6, 64, 2046);
INSERT INTO 'albumsrecordingsmap' VALUES (4530, 3, 321, 1210);
INSERT INTO 'albumsrecordingsmap' VALUES (4531, 1, 321, 780);
INSERT INTO 'albumsrecordingsmap' VALUES (4532, 2, 321, 4170);
INSERT INTO 'albumsrecordingsmap' VALUES (4533, 4, 321, 1966);
INSERT INTO 'albumsrecordingsmap' VALUES (4534, 6, 321, 1954);
INSERT INTO 'albumsrecordingsmap' VALUES (4535, 7, 321, 4338);
INSERT INTO 'albumsrecordingsmap' VALUES (4536, 8, 321, 4339);
INSERT INTO 'albumsrecordingsmap' VALUES (4537, 9, 321, 3105);
INSERT INTO 'albumsrecordingsmap' VALUES (4538, 5, 321, 1211);
INSERT INTO 'albumsrecordingsmap' VALUES (4539, 1, 327, 313);
INSERT INTO 'albumsrecordingsmap' VALUES (4540, 2, 327, 11);
INSERT INTO 'albumsrecordingsmap' VALUES (4541, 3, 327, 67);
INSERT INTO 'albumsrecordingsmap' VALUES (4542, 4, 327, 115);
INSERT INTO 'albumsrecordingsmap' VALUES (4543, 5, 327, 87);
INSERT INTO 'albumsrecordingsmap' VALUES (4544, 6, 327, 156);
INSERT INTO 'albumsrecordingsmap' VALUES (4545, 7, 327, 4340);
INSERT INTO 'albumsrecordingsmap' VALUES (4546, 8, 327, 276);
INSERT INTO 'albumsrecordingsmap' VALUES (4547, 9, 327, 4341);
INSERT INTO 'albumsrecordingsmap' VALUES (4548, 10, 327, 4342);
INSERT INTO 'albumsrecordingsmap' VALUES (4549, 1, 329, 4343);
INSERT INTO 'albumsrecordingsmap' VALUES (4550, 2, 329, 4344);
INSERT INTO 'albumsrecordingsmap' VALUES (4551, 3, 329, 4345);
INSERT INTO 'albumsrecordingsmap' VALUES (4552, 4, 329, 4346);
INSERT INTO 'albumsrecordingsmap' VALUES (4553, 5, 329, 4347);
INSERT INTO 'albumsrecordingsmap' VALUES (4554, 6, 329, 4348);
INSERT INTO 'albumsrecordingsmap' VALUES (4555, 7, 329, 4349);
INSERT INTO 'albumsrecordingsmap' VALUES (4556, 8, 329, 4350);
INSERT INTO 'albumsrecordingsmap' VALUES (4557, 9, 329, 4351);
INSERT INTO 'albumsrecordingsmap' VALUES (4558, 10, 329, 4352);
INSERT INTO 'albumsrecordingsmap' VALUES (4559, 11, 329, 4353);
INSERT INTO 'albumsrecordingsmap' VALUES (4560, 12, 329, 4354);
INSERT INTO 'albumsrecordingsmap' VALUES (4561, 13, 329, 4355);
INSERT INTO 'albumsrecordingsmap' VALUES (4562, 14, 329, 4356);
INSERT INTO 'albumsrecordingsmap' VALUES (4563, 15, 329, 4357);
INSERT INTO 'albumsrecordingsmap' VALUES (4564, 16, 329, 4358);
INSERT INTO 'albumsrecordingsmap' VALUES (4565, 17, 329, 4359);
INSERT INTO 'albumsrecordingsmap' VALUES (4566, 18, 329, 4360);
INSERT INTO 'albumsrecordingsmap' VALUES (4567, 19, 329, 4361);
INSERT INTO 'albumsrecordingsmap' VALUES (4568, 1, 333, 4362);
INSERT INTO 'albumsrecordingsmap' VALUES (4569, 2, 333, 2169);
INSERT INTO 'albumsrecordingsmap' VALUES (4571, 4, 333, 2171);
INSERT INTO 'albumsrecordingsmap' VALUES (4572, 8, 152, 4362);
INSERT INTO 'albumsrecordingsmap' VALUES (4573, 12, 728, 4362);
INSERT INTO 'albumsrecordingsmap' VALUES (4574, 1, 334, 4363);
INSERT INTO 'albumsrecordingsmap' VALUES (4575, 2, 334, 4364);
INSERT INTO 'albumsrecordingsmap' VALUES (4576, 3, 334, 4365);
INSERT INTO 'albumsrecordingsmap' VALUES (4577, 4, 334, 4366);
INSERT INTO 'albumsrecordingsmap' VALUES (4578, 5, 334, 4367);
INSERT INTO 'albumsrecordingsmap' VALUES (4579, 6, 334, 4368);
INSERT INTO 'albumsrecordingsmap' VALUES (4580, 1, 822, 2378);
INSERT INTO 'albumsrecordingsmap' VALUES (4581, 2, 822, 4072);
INSERT INTO 'albumsrecordingsmap' VALUES (4582, 3, 822, 23);
INSERT INTO 'albumsrecordingsmap' VALUES (4583, 4, 822, 4073);
INSERT INTO 'albumsrecordingsmap' VALUES (4584, 5, 822, 4074);
INSERT INTO 'albumsrecordingsmap' VALUES (4585, 6, 822, 3135);
INSERT INTO 'albumsrecordingsmap' VALUES (4586, 7, 822, 4075);
INSERT INTO 'albumsrecordingsmap' VALUES (4587, 8, 822, 4076);
INSERT INTO 'albumsrecordingsmap' VALUES (4588, 9, 822, 4077);
INSERT INTO 'albumsrecordingsmap' VALUES (4589, 10, 822, 4078);
INSERT INTO 'albumsrecordingsmap' VALUES (4590, 11, 822, 4079);
INSERT INTO 'albumsrecordingsmap' VALUES (4591, 12, 822, 4369);
INSERT INTO 'albumsrecordingsmap' VALUES (4592, 4, 418, 4073);
INSERT INTO 'albumsrecordingsmap' VALUES (4593, 6, 418, 4075);
INSERT INTO 'albumsrecordingsmap' VALUES (4594, 5, 418, 4074);
INSERT INTO 'albumsrecordingsmap' VALUES (4595, 7, 418, 4076);
INSERT INTO 'albumsrecordingsmap' VALUES (4596, 8, 418, 4077);
INSERT INTO 'albumsrecordingsmap' VALUES (4597, 9, 418, 4078);
INSERT INTO 'albumsrecordingsmap' VALUES (4598, 10, 418, 4079);
INSERT INTO 'albumsrecordingsmap' VALUES (4599, 8, 170, 4370);
INSERT INTO 'albumsrecordingsmap' VALUES (4600, 1, 345, 4371);
INSERT INTO 'albumsrecordingsmap' VALUES (4601, 2, 345, 4372);
INSERT INTO 'albumsrecordingsmap' VALUES (4602, 6, 724, 4373);
INSERT INTO 'albumsrecordingsmap' VALUES (4603, 1, 142, 4374);
INSERT INTO 'albumsrecordingsmap' VALUES (4604, 2, 142, 4375);
INSERT INTO 'albumsrecordingsmap' VALUES (4605, 3, 142, 4376);
INSERT INTO 'albumsrecordingsmap' VALUES (4606, 4, 142, 4377);
INSERT INTO 'albumsrecordingsmap' VALUES (4607, 5, 142, 4378);
INSERT INTO 'albumsrecordingsmap' VALUES (4608, 6, 142, 4379);
INSERT INTO 'albumsrecordingsmap' VALUES (4609, 1, 725, 4380);
INSERT INTO 'albumsrecordingsmap' VALUES (4610, 2, 725, 4381);
INSERT INTO 'albumsrecordingsmap' VALUES (4611, 3, 725, 4382);
INSERT INTO 'albumsrecordingsmap' VALUES (4612, 4, 725, 4383);
INSERT INTO 'albumsrecordingsmap' VALUES (4613, 6, 725, 4385);
INSERT INTO 'albumsrecordingsmap' VALUES (4614, 7, 725, 4386);
INSERT INTO 'albumsrecordingsmap' VALUES (4616, 7, 724, 4390);
INSERT INTO 'albumsrecordingsmap' VALUES (4617, 5, 724, 4391);
INSERT INTO 'albumsrecordingsmap' VALUES (4618, 3, 724, 4392);
INSERT INTO 'albumsrecordingsmap' VALUES (4619, 1, 151, 4393);
INSERT INTO 'albumsrecordingsmap' VALUES (4620, 2, 151, 4394);
INSERT INTO 'albumsrecordingsmap' VALUES (4621, 3, 151, 4395);
INSERT INTO 'albumsrecordingsmap' VALUES (4622, 5, 151, 4396);
INSERT INTO 'albumsrecordingsmap' VALUES (4623, 6, 151, 4397);
INSERT INTO 'albumsrecordingsmap' VALUES (4624, 7, 151, 4398);
INSERT INTO 'albumsrecordingsmap' VALUES (4625, 8, 151, 4399);
INSERT INTO 'albumsrecordingsmap' VALUES (4626, 9, 151, 4400);
INSERT INTO 'albumsrecordingsmap' VALUES (4627, 10, 151, 4401);
INSERT INTO 'albumsrecordingsmap' VALUES (4628, 11, 151, 4402);
INSERT INTO 'albumsrecordingsmap' VALUES (4629, 12, 151, 4403);
INSERT INTO 'albumsrecordingsmap' VALUES (4630, 13, 151, 4404);
INSERT INTO 'albumsrecordingsmap' VALUES (4631, 14, 151, 4405);
INSERT INTO 'albumsrecordingsmap' VALUES (4632, 15, 151, 4406);
INSERT INTO 'albumsrecordingsmap' VALUES (4633, 16, 151, 4407);
INSERT INTO 'albumsrecordingsmap' VALUES (4634, 17, 151, 4408);
INSERT INTO 'albumsrecordingsmap' VALUES (4635, 1, 102, 2984);
INSERT INTO 'albumsrecordingsmap' VALUES (4636, 10, 102, 2316);
INSERT INTO 'albumsrecordingsmap' VALUES (4637, 13, 102, 2991);
INSERT INTO 'albumsrecordingsmap' VALUES (4638, 7, 257, 4409);
INSERT INTO 'albumsrecordingsmap' VALUES (4639, 15, 257, 4410);
INSERT INTO 'albumsrecordingsmap' VALUES (4640, 1, 157, 4411);
INSERT INTO 'albumsrecordingsmap' VALUES (4641, 2, 157, 4412);
INSERT INTO 'albumsrecordingsmap' VALUES (4642, 3, 157, 4413);
INSERT INTO 'albumsrecordingsmap' VALUES (4643, 4, 157, 4414);
INSERT INTO 'albumsrecordingsmap' VALUES (4644, 5, 157, 4415);
INSERT INTO 'albumsrecordingsmap' VALUES (4528, 7, 711, 4337);
INSERT INTO 'albumsrecordingsmap' VALUES (4645, 6, 157, 4416);
INSERT INTO 'albumsrecordingsmap' VALUES (4646, 7, 157, 4417);
INSERT INTO 'albumsrecordingsmap' VALUES (4647, 8, 157, 4418);
INSERT INTO 'albumsrecordingsmap' VALUES (4648, 9, 157, 4419);
INSERT INTO 'albumsrecordingsmap' VALUES (4649, 10, 157, 4420);
INSERT INTO 'albumsrecordingsmap' VALUES (4650, 11, 157, 4421);
INSERT INTO 'albumsrecordingsmap' VALUES (4651, 12, 157, 4422);
INSERT INTO 'albumsrecordingsmap' VALUES (4652, 13, 157, 4423);
INSERT INTO 'albumsrecordingsmap' VALUES (4653, 14, 157, 4424);
INSERT INTO 'albumsrecordingsmap' VALUES (4654, 15, 157, 4425);
INSERT INTO 'albumsrecordingsmap' VALUES (4655, 16, 157, 4426);
INSERT INTO 'albumsrecordingsmap' VALUES (4656, 1, 737, 1212);
INSERT INTO 'albumsrecordingsmap' VALUES (4657, 2, 737, 1220);
INSERT INTO 'albumsrecordingsmap' VALUES (4658, 3, 737, 1223);
INSERT INTO 'albumsrecordingsmap' VALUES (4659, 4, 737, 2168);
INSERT INTO 'albumsrecordingsmap' VALUES (4660, 5, 737, 3109);
INSERT INTO 'albumsrecordingsmap' VALUES (4661, 6, 737, 4427);
INSERT INTO 'albumsrecordingsmap' VALUES (4662, 8, 291, 1212);
INSERT INTO 'albumsrecordingsmap' VALUES (4663, 7, 737, 4428);
INSERT INTO 'albumsrecordingsmap' VALUES (4664, 10, 737, 4430);
INSERT INTO 'albumsrecordingsmap' VALUES (4665, 11, 737, 4431);
INSERT INTO 'albumsrecordingsmap' VALUES (4666, 12, 737, 4432);
INSERT INTO 'albumsrecordingsmap' VALUES (4667, 13, 737, 4433);
INSERT INTO 'albumsrecordingsmap' VALUES (4668, 14, 737, 4434);
INSERT INTO 'albumsrecordingsmap' VALUES (4669, 1, 199, 4435);
INSERT INTO 'albumsrecordingsmap' VALUES (4670, 2, 199, 4436);
INSERT INTO 'albumsrecordingsmap' VALUES (4671, 3, 199, 4437);
INSERT INTO 'albumsrecordingsmap' VALUES (4672, 4, 199, 4438);
INSERT INTO 'albumsrecordingsmap' VALUES (4673, 5, 199, 4439);
INSERT INTO 'albumsrecordingsmap' VALUES (4674, 6, 199, 4440);
INSERT INTO 'albumsrecordingsmap' VALUES (4675, 7, 199, 4441);
INSERT INTO 'albumsrecordingsmap' VALUES (4676, 8, 199, 4442);
INSERT INTO 'albumsrecordingsmap' VALUES (4677, 9, 199, 4443);
INSERT INTO 'albumsrecordingsmap' VALUES (4678, 10, 199, 4444);
INSERT INTO 'albumsrecordingsmap' VALUES (4679, 11, 199, 4445);
INSERT INTO 'albumsrecordingsmap' VALUES (4680, 12, 199, 4446);
INSERT INTO 'albumsrecordingsmap' VALUES (4681, 13, 199, 4447);
INSERT INTO 'albumsrecordingsmap' VALUES (4682, 14, 199, 4448);
INSERT INTO 'albumsrecordingsmap' VALUES (4683, 15, 199, 4449);
INSERT INTO 'albumsrecordingsmap' VALUES (4684, 16, 199, 4450);
INSERT INTO 'albumsrecordingsmap' VALUES (4685, 17, 199, 4451);
INSERT INTO 'albumsrecordingsmap' VALUES (4686, 18, 199, 4452);
INSERT INTO 'albumsrecordingsmap' VALUES (4687, 19, 199, 4453);
INSERT INTO 'albumsrecordingsmap' VALUES (4688, 20, 199, 4454);
INSERT INTO 'albumsrecordingsmap' VALUES (4689, 21, 199, 4455);
INSERT INTO 'albumsrecordingsmap' VALUES (4690, 22, 199, 4456);
INSERT INTO 'albumsrecordingsmap' VALUES (4691, 1, 217, 4457);
INSERT INTO 'albumsrecordingsmap' VALUES (4692, 2, 217, 4458);
INSERT INTO 'albumsrecordingsmap' VALUES (4693, 3, 217, 4459);
INSERT INTO 'albumsrecordingsmap' VALUES (4694, 4, 217, 4460);
INSERT INTO 'albumsrecordingsmap' VALUES (4695, 5, 217, 4461);
INSERT INTO 'albumsrecordingsmap' VALUES (4696, 6, 217, 4462);
INSERT INTO 'albumsrecordingsmap' VALUES (4697, 7, 217, 4463);
INSERT INTO 'albumsrecordingsmap' VALUES (4698, 8, 217, 4464);
INSERT INTO 'albumsrecordingsmap' VALUES (4699, 9, 217, 4465);
INSERT INTO 'albumsrecordingsmap' VALUES (4700, 10, 217, 4466);
INSERT INTO 'albumsrecordingsmap' VALUES (4701, 11, 217, 4467);
INSERT INTO 'albumsrecordingsmap' VALUES (4702, 12, 217, 4468);
INSERT INTO 'albumsrecordingsmap' VALUES (4703, 1, 244, 4469);
INSERT INTO 'albumsrecordingsmap' VALUES (4704, 2, 244, 4470);
INSERT INTO 'albumsrecordingsmap' VALUES (4705, 3, 244, 4471);
INSERT INTO 'albumsrecordingsmap' VALUES (4706, 4, 244, 4472);
INSERT INTO 'albumsrecordingsmap' VALUES (4707, 5, 244, 4473);
INSERT INTO 'albumsrecordingsmap' VALUES (4708, 6, 244, 4474);
INSERT INTO 'albumsrecordingsmap' VALUES (4709, 7, 244, 4475);
INSERT INTO 'albumsrecordingsmap' VALUES (4710, 8, 244, 4476);
INSERT INTO 'albumsrecordingsmap' VALUES (4711, 9, 244, 4477);
INSERT INTO 'albumsrecordingsmap' VALUES (4712, 10, 244, 4478);
INSERT INTO 'albumsrecordingsmap' VALUES (4713, 11, 244, 4479);
INSERT INTO 'albumsrecordingsmap' VALUES (4714, 12, 244, 4480);
INSERT INTO 'albumsrecordingsmap' VALUES (4715, 13, 244, 4481);
INSERT INTO 'albumsrecordingsmap' VALUES (4716, 14, 244, 4482);
INSERT INTO 'albumsrecordingsmap' VALUES (4717, 15, 244, 4483);
INSERT INTO 'albumsrecordingsmap' VALUES (4718, 16, 244, 4484);
INSERT INTO 'albumsrecordingsmap' VALUES (4719, 17, 244, 4485);
INSERT INTO 'albumsrecordingsmap' VALUES (4720, 18, 244, 4486);
INSERT INTO 'albumsrecordingsmap' VALUES (4721, 1, 252, 4487);
INSERT INTO 'albumsrecordingsmap' VALUES (4722, 2, 252, 4488);
INSERT INTO 'albumsrecordingsmap' VALUES (4723, 3, 252, 4489);
INSERT INTO 'albumsrecordingsmap' VALUES (4724, 4, 252, 4490);
INSERT INTO 'albumsrecordingsmap' VALUES (4725, 5, 252, 4491);
INSERT INTO 'albumsrecordingsmap' VALUES (4726, 6, 252, 4492);
INSERT INTO 'albumsrecordingsmap' VALUES (4727, 7, 252, 4493);
INSERT INTO 'albumsrecordingsmap' VALUES (4728, 8, 252, 4494);
INSERT INTO 'albumsrecordingsmap' VALUES (4729, 9, 252, 4495);
INSERT INTO 'albumsrecordingsmap' VALUES (4730, 10, 252, 4496);
INSERT INTO 'albumsrecordingsmap' VALUES (4731, 11, 252, 4497);
INSERT INTO 'albumsrecordingsmap' VALUES (4732, 12, 252, 4498);
INSERT INTO 'albumsrecordingsmap' VALUES (4733, 13, 252, 4499);
INSERT INTO 'albumsrecordingsmap' VALUES (4734, 14, 252, 4500);
INSERT INTO 'albumsrecordingsmap' VALUES (4735, 1, 288, 1424);
INSERT INTO 'albumsrecordingsmap' VALUES (4736, 2, 288, 1426);
INSERT INTO 'albumsrecordingsmap' VALUES (4737, 3, 288, 1423);
INSERT INTO 'albumsrecordingsmap' VALUES (4738, 4, 288, 1421);
INSERT INTO 'albumsrecordingsmap' VALUES (4739, 5, 288, 1425);
INSERT INTO 'albumsrecordingsmap' VALUES (4740, 6, 288, 1419);
INSERT INTO 'albumsrecordingsmap' VALUES (4741, 7, 288, 1420);
INSERT INTO 'albumsrecordingsmap' VALUES (4742, 8, 288, 1422);
INSERT INTO 'albumsrecordingsmap' VALUES (4743, 1, 308, 4501);
INSERT INTO 'albumsrecordingsmap' VALUES (4744, 2, 308, 4502);
INSERT INTO 'albumsrecordingsmap' VALUES (4745, 3, 308, 3730);
INSERT INTO 'albumsrecordingsmap' VALUES (4746, 4, 308, 3723);
INSERT INTO 'albumsrecordingsmap' VALUES (4747, 5, 308, 3661);
INSERT INTO 'albumsrecordingsmap' VALUES (4748, 11, 718, 2009);
INSERT INTO 'albumsrecordingsmap' VALUES (4749, 6, 308, 3663);
INSERT INTO 'albumsrecordingsmap' VALUES (4750, 7, 308, 4503);
INSERT INTO 'albumsrecordingsmap' VALUES (4751, 8, 308, 4504);
INSERT INTO 'albumsrecordingsmap' VALUES (4752, 1, 265, 3693);
INSERT INTO 'albumsrecordingsmap' VALUES (4753, 3, 745, 1779);
INSERT INTO 'albumsrecordingsmap' VALUES (4754, 3, 265, 3690);
INSERT INTO 'albumsrecordingsmap' VALUES (4755, 5, 265, 3695);
INSERT INTO 'albumsrecordingsmap' VALUES (4756, 10, 308, 4506);
INSERT INTO 'albumsrecordingsmap' VALUES (4757, 11, 308, 4507);
INSERT INTO 'albumsrecordingsmap' VALUES (4758, 12, 308, 4508);
INSERT INTO 'albumsrecordingsmap' VALUES (4759, 13, 308, 4509);
INSERT INTO 'albumsrecordingsmap' VALUES (4760, 4, 790, 2839);
INSERT INTO 'albumsrecordingsmap' VALUES (4761, 1, 310, 4510);
INSERT INTO 'albumsrecordingsmap' VALUES (4762, 2, 310, 4511);
INSERT INTO 'albumsrecordingsmap' VALUES (4763, 3, 310, 4512);
INSERT INTO 'albumsrecordingsmap' VALUES (4764, 4, 310, 4513);
INSERT INTO 'albumsrecordingsmap' VALUES (4765, 5, 310, 4514);
INSERT INTO 'albumsrecordingsmap' VALUES (4766, 6, 310, 4515);
INSERT INTO 'albumsrecordingsmap' VALUES (4767, 7, 310, 4516);
INSERT INTO 'albumsrecordingsmap' VALUES (4768, 8, 310, 4517);
INSERT INTO 'albumsrecordingsmap' VALUES (4769, 9, 310, 4518);
INSERT INTO 'albumsrecordingsmap' VALUES (4770, 10, 310, 4519);
INSERT INTO 'albumsrecordingsmap' VALUES (4771, 11, 310, 4520);
INSERT INTO 'albumsrecordingsmap' VALUES (4772, 12, 310, 4521);
INSERT INTO 'albumsrecordingsmap' VALUES (4773, 1, 311, 4522);
INSERT INTO 'albumsrecordingsmap' VALUES (4774, 2, 311, 4523);
INSERT INTO 'albumsrecordingsmap' VALUES (4775, 3, 311, 4524);
INSERT INTO 'albumsrecordingsmap' VALUES (4776, 4, 311, 4525);
INSERT INTO 'albumsrecordingsmap' VALUES (4777, 5, 311, 4526);
INSERT INTO 'albumsrecordingsmap' VALUES (4778, 6, 311, 4527);
INSERT INTO 'albumsrecordingsmap' VALUES (4779, 7, 311, 4528);
INSERT INTO 'albumsrecordingsmap' VALUES (4780, 8, 311, 4529);
INSERT INTO 'albumsrecordingsmap' VALUES (4781, 9, 311, 4530);
INSERT INTO 'albumsrecordingsmap' VALUES (4782, 10, 311, 4531);
INSERT INTO 'albumsrecordingsmap' VALUES (4783, 11, 311, 4532);
INSERT INTO 'albumsrecordingsmap' VALUES (4784, 12, 311, 4533);
INSERT INTO 'albumsrecordingsmap' VALUES (4785, 13, 311, 4534);
INSERT INTO 'albumsrecordingsmap' VALUES (4786, 14, 311, 4535);
INSERT INTO 'albumsrecordingsmap' VALUES (4787, 15, 311, 4536);
INSERT INTO 'albumsrecordingsmap' VALUES (4788, 17, 419, 2860);
INSERT INTO 'albumsrecordingsmap' VALUES (4789, 25, 774, 2862);
INSERT INTO 'albumsrecordingsmap' VALUES (4790, 4, 151, 2863);
INSERT INTO 'albumsrecordingsmap' VALUES (4791, 5, 231, 3113);
INSERT INTO 'albumsrecordingsmap' VALUES (4792, 2, 201, 3666);
INSERT INTO 'albumsrecordingsmap' VALUES (4793, 6, 201, 298);
INSERT INTO 'albumsrecordingsmap' VALUES (4794, 12, 201, 305);
INSERT INTO 'albumsrecordingsmap' VALUES (4795, 5, 385, 3688);
INSERT INTO 'albumsrecordingsmap' VALUES (4796, 1, 313, 4552);
INSERT INTO 'albumsrecordingsmap' VALUES (4797, 2, 313, 4553);
INSERT INTO 'albumsrecordingsmap' VALUES (4798, 3, 313, 4554);
INSERT INTO 'albumsrecordingsmap' VALUES (4799, 4, 313, 4555);
INSERT INTO 'albumsrecordingsmap' VALUES (4800, 5, 313, 4556);
INSERT INTO 'albumsrecordingsmap' VALUES (4801, 6, 313, 4557);
INSERT INTO 'albumsrecordingsmap' VALUES (4802, 7, 313, 4558);
INSERT INTO 'albumsrecordingsmap' VALUES (4803, 8, 313, 4559);
INSERT INTO 'albumsrecordingsmap' VALUES (4804, 9, 313, 4560);
INSERT INTO 'albumsrecordingsmap' VALUES (4805, 10, 313, 4561);
INSERT INTO 'albumsrecordingsmap' VALUES (4806, 11, 313, 4562);
INSERT INTO 'albumsrecordingsmap' VALUES (4807, 12, 313, 4563);
INSERT INTO 'albumsrecordingsmap' VALUES (4808, 13, 313, 4564);
INSERT INTO 'albumsrecordingsmap' VALUES (4809, 14, 313, 4565);
INSERT INTO 'albumsrecordingsmap' VALUES (4810, 1, 312, 3736);
INSERT INTO 'albumsrecordingsmap' VALUES (4811, 7, 312, 4542);
INSERT INTO 'albumsrecordingsmap' VALUES (4812, 15, 312, 4550);
INSERT INTO 'albumsrecordingsmap' VALUES (4813, 12, 312, 4547);
INSERT INTO 'albumsrecordingsmap' VALUES (4814, 9, 312, 4544);
INSERT INTO 'albumsrecordingsmap' VALUES (4815, 2, 312, 4537);
INSERT INTO 'albumsrecordingsmap' VALUES (4816, 5, 312, 4540);
INSERT INTO 'albumsrecordingsmap' VALUES (4817, 13, 312, 4548);
INSERT INTO 'albumsrecordingsmap' VALUES (4818, 8, 312, 4543);
INSERT INTO 'albumsrecordingsmap' VALUES (4819, 10, 312, 4545);
INSERT INTO 'albumsrecordingsmap' VALUES (4820, 16, 312, 4551);
INSERT INTO 'albumsrecordingsmap' VALUES (4821, 4, 312, 4539);
INSERT INTO 'albumsrecordingsmap' VALUES (4822, 11, 312, 4546);
INSERT INTO 'albumsrecordingsmap' VALUES (4823, 3, 312, 4538);
INSERT INTO 'albumsrecordingsmap' VALUES (4824, 6, 312, 4541);
INSERT INTO 'albumsrecordingsmap' VALUES (4825, 14, 312, 4549);
INSERT INTO 'albumsrecordingsmap' VALUES (4826, 1, 317, 4566);
INSERT INTO 'albumsrecordingsmap' VALUES (4827, 2, 317, 4567);
INSERT INTO 'albumsrecordingsmap' VALUES (4828, 3, 317, 4568);
INSERT INTO 'albumsrecordingsmap' VALUES (4829, 5, 317, 4570);
INSERT INTO 'albumsrecordingsmap' VALUES (4830, 6, 317, 4571);
INSERT INTO 'albumsrecordingsmap' VALUES (4831, 7, 317, 4572);
INSERT INTO 'albumsrecordingsmap' VALUES (4832, 8, 317, 4573);
INSERT INTO 'albumsrecordingsmap' VALUES (4833, 9, 317, 4574);
INSERT INTO 'albumsrecordingsmap' VALUES (4834, 10, 317, 4575);
INSERT INTO 'albumsrecordingsmap' VALUES (4835, 11, 317, 4576);
INSERT INTO 'albumsrecordingsmap' VALUES (4836, 12, 317, 4577);
INSERT INTO 'albumsrecordingsmap' VALUES (4837, 13, 317, 4578);
INSERT INTO 'albumsrecordingsmap' VALUES (4838, 14, 317, 4579);
INSERT INTO 'albumsrecordingsmap' VALUES (4839, 1, 318, 4580);
INSERT INTO 'albumsrecordingsmap' VALUES (4840, 2, 318, 4581);
INSERT INTO 'albumsrecordingsmap' VALUES (4841, 3, 318, 4582);
INSERT INTO 'albumsrecordingsmap' VALUES (4842, 4, 318, 4583);
INSERT INTO 'albumsrecordingsmap' VALUES (4843, 5, 318, 4584);
INSERT INTO 'albumsrecordingsmap' VALUES (4844, 6, 318, 4585);
INSERT INTO 'albumsrecordingsmap' VALUES (4845, 7, 318, 4586);
INSERT INTO 'albumsrecordingsmap' VALUES (4846, 8, 318, 4587);
INSERT INTO 'albumsrecordingsmap' VALUES (4847, 9, 318, 4588);
INSERT INTO 'albumsrecordingsmap' VALUES (4848, 10, 318, 4589);
INSERT INTO 'albumsrecordingsmap' VALUES (4849, 11, 318, 4590);
INSERT INTO 'albumsrecordingsmap' VALUES (4850, 12, 318, 4591);
INSERT INTO 'albumsrecordingsmap' VALUES (4851, 13, 318, 4592);
INSERT INTO 'albumsrecordingsmap' VALUES (4852, 14, 318, 4593);
INSERT INTO 'albumsrecordingsmap' VALUES (4853, 1, 319, 1468);
INSERT INTO 'albumsrecordingsmap' VALUES (4854, 2, 319, 2149);
INSERT INTO 'albumsrecordingsmap' VALUES (4855, 3, 319, 2150);
INSERT INTO 'albumsrecordingsmap' VALUES (4856, 4, 319, 2762);
INSERT INTO 'albumsrecordingsmap' VALUES (4857, 5, 319, 2763);
INSERT INTO 'albumsrecordingsmap' VALUES (4858, 6, 319, 2764);
INSERT INTO 'albumsrecordingsmap' VALUES (4859, 7, 319, 2765);
INSERT INTO 'albumsrecordingsmap' VALUES (4860, 8, 319, 4594);
INSERT INTO 'albumsrecordingsmap' VALUES (4861, 9, 319, 4595);
INSERT INTO 'albumsrecordingsmap' VALUES (4862, 10, 319, 4596);
INSERT INTO 'albumsrecordingsmap' VALUES (4863, 11, 319, 4597);
INSERT INTO 'albumsrecordingsmap' VALUES (4864, 12, 319, 4598);
INSERT INTO 'albumsrecordingsmap' VALUES (4865, 4, 317, 4624);
INSERT INTO 'albumsrecordingsmap' VALUES (4866, 1, 254, 4569);
INSERT INTO 'albumsrecordingsmap' VALUES (4867, 2, 254, 4613);
INSERT INTO 'albumsrecordingsmap' VALUES (4868, 3, 254, 4614);
INSERT INTO 'albumsrecordingsmap' VALUES (4869, 4, 254, 4615);
INSERT INTO 'albumsrecordingsmap' VALUES (4870, 5, 254, 4616);
INSERT INTO 'albumsrecordingsmap' VALUES (4871, 6, 254, 4617);
INSERT INTO 'albumsrecordingsmap' VALUES (4872, 7, 254, 4618);
INSERT INTO 'albumsrecordingsmap' VALUES (4873, 8, 254, 4619);
INSERT INTO 'albumsrecordingsmap' VALUES (4874, 9, 254, 4620);
INSERT INTO 'albumsrecordingsmap' VALUES (4875, 10, 254, 4621);
INSERT INTO 'albumsrecordingsmap' VALUES (4876, 11, 254, 4622);
INSERT INTO 'albumsrecordingsmap' VALUES (4877, 12, 254, 4623);
INSERT INTO 'albumsrecordingsmap' VALUES (4878, 13, 254, 4625);
INSERT INTO 'albumsrecordingsmap' VALUES (4879, 1, 320, 4626);
INSERT INTO 'albumsrecordingsmap' VALUES (4880, 2, 320, 4627);
INSERT INTO 'albumsrecordingsmap' VALUES (4881, 3, 320, 4628);
INSERT INTO 'albumsrecordingsmap' VALUES (4882, 4, 320, 4629);
INSERT INTO 'albumsrecordingsmap' VALUES (4883, 5, 320, 4630);
INSERT INTO 'albumsrecordingsmap' VALUES (4884, 6, 320, 4631);
INSERT INTO 'albumsrecordingsmap' VALUES (4885, 7, 320, 4632);
INSERT INTO 'albumsrecordingsmap' VALUES (4886, 8, 320, 4633);
INSERT INTO 'albumsrecordingsmap' VALUES (4887, 9, 320, 4634);
INSERT INTO 'albumsrecordingsmap' VALUES (4888, 10, 320, 4635);
INSERT INTO 'albumsrecordingsmap' VALUES (4889, 11, 320, 4636);
INSERT INTO 'albumsrecordingsmap' VALUES (4890, 12, 320, 4637);
INSERT INTO 'albumsrecordingsmap' VALUES (4891, 13, 320, 4638);
INSERT INTO 'albumsrecordingsmap' VALUES (4892, 14, 320, 4639);
INSERT INTO 'albumsrecordingsmap' VALUES (4893, 15, 320, 4640);
INSERT INTO 'albumsrecordingsmap' VALUES (4894, 16, 320, 4641);
INSERT INTO 'albumsrecordingsmap' VALUES (4895, 1, 322, 4642);
INSERT INTO 'albumsrecordingsmap' VALUES (4896, 2, 322, 4643);
INSERT INTO 'albumsrecordingsmap' VALUES (4897, 3, 322, 4644);
INSERT INTO 'albumsrecordingsmap' VALUES (4898, 4, 322, 4645);
INSERT INTO 'albumsrecordingsmap' VALUES (4899, 5, 322, 4646);
INSERT INTO 'albumsrecordingsmap' VALUES (4900, 6, 322, 4647);
INSERT INTO 'albumsrecordingsmap' VALUES (4901, 7, 322, 4648);
INSERT INTO 'albumsrecordingsmap' VALUES (4902, 8, 322, 4649);
INSERT INTO 'albumsrecordingsmap' VALUES (4903, 9, 322, 4650);
INSERT INTO 'albumsrecordingsmap' VALUES (4904, 10, 322, 4651);
INSERT INTO 'albumsrecordingsmap' VALUES (4905, 11, 322, 4652);
INSERT INTO 'albumsrecordingsmap' VALUES (4906, 12, 322, 4653);
INSERT INTO 'albumsrecordingsmap' VALUES (4907, 13, 322, 4654);
INSERT INTO 'albumsrecordingsmap' VALUES (4908, 14, 322, 4655);
INSERT INTO 'albumsrecordingsmap' VALUES (4909, 5, 323, 4656);
INSERT INTO 'albumsrecordingsmap' VALUES (4910, 6, 323, 4657);
INSERT INTO 'albumsrecordingsmap' VALUES (4911, 7, 323, 4658);
INSERT INTO 'albumsrecordingsmap' VALUES (4912, 13, 323, 4659);
INSERT INTO 'albumsrecordingsmap' VALUES (4913, 2, 323, 4660);
INSERT INTO 'albumsrecordingsmap' VALUES (4914, 9, 323, 4661);
INSERT INTO 'albumsrecordingsmap' VALUES (4915, 8, 323, 4662);
INSERT INTO 'albumsrecordingsmap' VALUES (4916, 3, 323, 4663);
INSERT INTO 'albumsrecordingsmap' VALUES (4917, 11, 323, 4664);
INSERT INTO 'albumsrecordingsmap' VALUES (4918, 10, 323, 4665);
INSERT INTO 'albumsrecordingsmap' VALUES (4919, 1, 323, 4666);
INSERT INTO 'albumsrecordingsmap' VALUES (4920, 12, 323, 4667);
INSERT INTO 'albumsrecordingsmap' VALUES (4921, 14, 323, 4668);
INSERT INTO 'albumsrecordingsmap' VALUES (4922, 4, 323, 4669);
INSERT INTO 'albumsrecordingsmap' VALUES (4923, 4, 325, 4670);
INSERT INTO 'albumsrecordingsmap' VALUES (4924, 12, 325, 4671);
INSERT INTO 'albumsrecordingsmap' VALUES (4925, 6, 325, 4672);
INSERT INTO 'albumsrecordingsmap' VALUES (4926, 1, 325, 4673);
INSERT INTO 'albumsrecordingsmap' VALUES (4927, 2, 325, 4674);
INSERT INTO 'albumsrecordingsmap' VALUES (4928, 8, 325, 4675);
INSERT INTO 'albumsrecordingsmap' VALUES (4929, 10, 325, 4676);
INSERT INTO 'albumsrecordingsmap' VALUES (4930, 9, 325, 4677);
INSERT INTO 'albumsrecordingsmap' VALUES (4931, 3, 325, 4678);
INSERT INTO 'albumsrecordingsmap' VALUES (4932, 7, 325, 4679);
INSERT INTO 'albumsrecordingsmap' VALUES (4933, 5, 325, 4680);
INSERT INTO 'albumsrecordingsmap' VALUES (4934, 11, 325, 4681);
INSERT INTO 'albumsrecordingsmap' VALUES (4935, 13, 325, 4682);
INSERT INTO 'albumsrecordingsmap' VALUES (4936, 14, 325, 4683);
INSERT INTO 'albumsrecordingsmap' VALUES (4937, 1, 328, 4684);
INSERT INTO 'albumsrecordingsmap' VALUES (4938, 2, 328, 4685);
INSERT INTO 'albumsrecordingsmap' VALUES (4939, 3, 328, 4686);
INSERT INTO 'albumsrecordingsmap' VALUES (4940, 4, 328, 4687);
INSERT INTO 'albumsrecordingsmap' VALUES (4941, 5, 328, 4688);
INSERT INTO 'albumsrecordingsmap' VALUES (4942, 6, 328, 4689);
INSERT INTO 'albumsrecordingsmap' VALUES (4943, 7, 328, 4690);
INSERT INTO 'albumsrecordingsmap' VALUES (4944, 8, 328, 4691);
INSERT INTO 'albumsrecordingsmap' VALUES (4945, 9, 328, 4692);
INSERT INTO 'albumsrecordingsmap' VALUES (4946, 10, 328, 4693);
INSERT INTO 'albumsrecordingsmap' VALUES (4947, 11, 328, 4694);
INSERT INTO 'albumsrecordingsmap' VALUES (4948, 12, 328, 4695);
INSERT INTO 'albumsrecordingsmap' VALUES (4949, 13, 328, 4696);
INSERT INTO 'albumsrecordingsmap' VALUES (4964, 1, 331, 4711);
INSERT INTO 'albumsrecordingsmap' VALUES (4965, 2, 331, 4712);
INSERT INTO 'albumsrecordingsmap' VALUES (4966, 3, 331, 4713);
INSERT INTO 'albumsrecordingsmap' VALUES (4967, 4, 331, 4714);
INSERT INTO 'albumsrecordingsmap' VALUES (4968, 5, 331, 4715);
INSERT INTO 'albumsrecordingsmap' VALUES (4969, 6, 331, 4716);
INSERT INTO 'albumsrecordingsmap' VALUES (4970, 7, 331, 4717);
INSERT INTO 'albumsrecordingsmap' VALUES (4971, 8, 331, 4718);
INSERT INTO 'albumsrecordingsmap' VALUES (4972, 1, 259, 4719);
INSERT INTO 'albumsrecordingsmap' VALUES (4973, 2, 332, 4721);
INSERT INTO 'albumsrecordingsmap' VALUES (4974, 1, 332, 4720);
INSERT INTO 'albumsrecordingsmap' VALUES (4975, 3, 332, 4722);
INSERT INTO 'albumsrecordingsmap' VALUES (4976, 6, 332, 4723);
INSERT INTO 'albumsrecordingsmap' VALUES (4977, 7, 332, 4724);
INSERT INTO 'albumsrecordingsmap' VALUES (4978, 8, 332, 4725);
INSERT INTO 'albumsrecordingsmap' VALUES (4979, 9, 332, 4726);
INSERT INTO 'albumsrecordingsmap' VALUES (4980, 10, 332, 4727);
INSERT INTO 'albumsrecordingsmap' VALUES (4981, 11, 332, 4728);
INSERT INTO 'albumsrecordingsmap' VALUES (4982, 13, 332, 4729);
INSERT INTO 'albumsrecordingsmap' VALUES (4983, 14, 332, 4730);
INSERT INTO 'albumsrecordingsmap' VALUES (4984, 13, 297, 4731);
INSERT INTO 'albumsrecordingsmap' VALUES (4985, 1, 335, 4732);
INSERT INTO 'albumsrecordingsmap' VALUES (4986, 2, 335, 4733);
INSERT INTO 'albumsrecordingsmap' VALUES (4987, 3, 335, 4734);
INSERT INTO 'albumsrecordingsmap' VALUES (4988, 4, 335, 4735);
INSERT INTO 'albumsrecordingsmap' VALUES (4989, 5, 335, 4736);
INSERT INTO 'albumsrecordingsmap' VALUES (4990, 6, 335, 4737);
INSERT INTO 'albumsrecordingsmap' VALUES (4991, 7, 335, 4738);
INSERT INTO 'albumsrecordingsmap' VALUES (4992, 8, 335, 4739);
INSERT INTO 'albumsrecordingsmap' VALUES (4993, 9, 335, 4740);
INSERT INTO 'albumsrecordingsmap' VALUES (4994, 10, 335, 4741);
INSERT INTO 'albumsrecordingsmap' VALUES (4995, 1, 336, 3704);
INSERT INTO 'albumsrecordingsmap' VALUES (4996, 2, 336, 4742);
INSERT INTO 'albumsrecordingsmap' VALUES (4997, 3, 336, 4743);
INSERT INTO 'albumsrecordingsmap' VALUES (4998, 4, 336, 4744);
INSERT INTO 'albumsrecordingsmap' VALUES (4999, 5, 336, 4745);
INSERT INTO 'albumsrecordingsmap' VALUES (5000, 6, 336, 4746);
INSERT INTO 'albumsrecordingsmap' VALUES (5001, 7, 336, 4747);
INSERT INTO 'albumsrecordingsmap' VALUES (5002, 8, 336, 4748);
INSERT INTO 'albumsrecordingsmap' VALUES (5003, 9, 336, 4749);
INSERT INTO 'albumsrecordingsmap' VALUES (5004, 10, 336, 4750);
INSERT INTO 'albumsrecordingsmap' VALUES (5005, 1, 722, 4599);
INSERT INTO 'albumsrecordingsmap' VALUES (5006, 2, 722, 4600);
INSERT INTO 'albumsrecordingsmap' VALUES (5007, 3, 722, 4601);
INSERT INTO 'albumsrecordingsmap' VALUES (5008, 4, 722, 4602);
INSERT INTO 'albumsrecordingsmap' VALUES (5009, 5, 722, 4603);
INSERT INTO 'albumsrecordingsmap' VALUES (5010, 6, 722, 4604);
INSERT INTO 'albumsrecordingsmap' VALUES (5011, 7, 722, 4606);
INSERT INTO 'albumsrecordingsmap' VALUES (5012, 8, 722, 4607);
INSERT INTO 'albumsrecordingsmap' VALUES (5013, 9, 722, 4608);
INSERT INTO 'albumsrecordingsmap' VALUES (5014, 10, 722, 4609);
INSERT INTO 'albumsrecordingsmap' VALUES (5015, 1, 337, 4610);
INSERT INTO 'albumsrecordingsmap' VALUES (5016, 2, 337, 4611);
INSERT INTO 'albumsrecordingsmap' VALUES (5017, 3, 337, 4751);
INSERT INTO 'albumsrecordingsmap' VALUES (5018, 4, 337, 4752);
INSERT INTO 'albumsrecordingsmap' VALUES (5019, 5, 337, 4753);
INSERT INTO 'albumsrecordingsmap' VALUES (5020, 6, 337, 4754);
INSERT INTO 'albumsrecordingsmap' VALUES (5021, 7, 337, 4755);
INSERT INTO 'albumsrecordingsmap' VALUES (5022, 8, 337, 4756);
INSERT INTO 'albumsrecordingsmap' VALUES (5023, 4, 338, 4760);
INSERT INTO 'albumsrecordingsmap' VALUES (5024, 1, 338, 4757);
INSERT INTO 'albumsrecordingsmap' VALUES (5025, 2, 338, 4758);
INSERT INTO 'albumsrecordingsmap' VALUES (5026, 3, 338, 4759);
INSERT INTO 'albumsrecordingsmap' VALUES (5027, 5, 338, 4761);
INSERT INTO 'albumsrecordingsmap' VALUES (5028, 6, 338, 4762);
INSERT INTO 'albumsrecordingsmap' VALUES (5029, 7, 338, 4763);
INSERT INTO 'albumsrecordingsmap' VALUES (5030, 8, 338, 4764);
INSERT INTO 'albumsrecordingsmap' VALUES (5031, 9, 338, 4765);
INSERT INTO 'albumsrecordingsmap' VALUES (5032, 10, 338, 4766);
INSERT INTO 'albumsrecordingsmap' VALUES (5033, 1, 339, 4767);
INSERT INTO 'albumsrecordingsmap' VALUES (5034, 2, 339, 4768);
INSERT INTO 'albumsrecordingsmap' VALUES (5035, 3, 339, 4769);
INSERT INTO 'albumsrecordingsmap' VALUES (5036, 4, 339, 4770);
INSERT INTO 'albumsrecordingsmap' VALUES (5037, 5, 339, 4771);
INSERT INTO 'albumsrecordingsmap' VALUES (5038, 6, 339, 4772);
INSERT INTO 'albumsrecordingsmap' VALUES (5039, 1, 341, 4773);
INSERT INTO 'albumsrecordingsmap' VALUES (5040, 2, 341, 4774);
INSERT INTO 'albumsrecordingsmap' VALUES (5041, 3, 341, 4775);
INSERT INTO 'albumsrecordingsmap' VALUES (5042, 4, 341, 4776);
INSERT INTO 'albumsrecordingsmap' VALUES (5043, 5, 341, 4777);
INSERT INTO 'albumsrecordingsmap' VALUES (5044, 6, 341, 4778);
INSERT INTO 'albumsrecordingsmap' VALUES (5045, 7, 341, 4779);
INSERT INTO 'albumsrecordingsmap' VALUES (5046, 8, 341, 4780);
INSERT INTO 'albumsrecordingsmap' VALUES (5047, 9, 341, 4781);
INSERT INTO 'albumsrecordingsmap' VALUES (5048, 1, 342, 4782);
INSERT INTO 'albumsrecordingsmap' VALUES (5049, 2, 342, 4783);
INSERT INTO 'albumsrecordingsmap' VALUES (5050, 3, 342, 4784);
INSERT INTO 'albumsrecordingsmap' VALUES (5051, 4, 342, 4785);
INSERT INTO 'albumsrecordingsmap' VALUES (5052, 5, 342, 4786);
INSERT INTO 'albumsrecordingsmap' VALUES (5053, 6, 342, 4787);
INSERT INTO 'albumsrecordingsmap' VALUES (5054, 7, 342, 4788);
INSERT INTO 'albumsrecordingsmap' VALUES (5055, 8, 342, 4789);
INSERT INTO 'albumsrecordingsmap' VALUES (5056, 9, 342, 4790);
INSERT INTO 'albumsrecordingsmap' VALUES (5057, 10, 342, 4791);
INSERT INTO 'albumsrecordingsmap' VALUES (5058, 11, 342, 4792);
INSERT INTO 'albumsrecordingsmap' VALUES (5059, 1, 344, 4793);
INSERT INTO 'albumsrecordingsmap' VALUES (5060, 2, 344, 4794);
INSERT INTO 'albumsrecordingsmap' VALUES (5061, 8, 344, 4795);
INSERT INTO 'albumsrecordingsmap' VALUES (5062, 1, 786, 4796);
INSERT INTO 'albumsrecordingsmap' VALUES (5063, 2, 786, 4797);
INSERT INTO 'albumsrecordingsmap' VALUES (5064, 3, 786, 4798);
INSERT INTO 'albumsrecordingsmap' VALUES (5065, 4, 786, 4799);
INSERT INTO 'albumsrecordingsmap' VALUES (5066, 5, 786, 4800);
INSERT INTO 'albumsrecordingsmap' VALUES (5067, 6, 786, 4801);
INSERT INTO 'albumsrecordingsmap' VALUES (5068, 7, 786, 4802);
INSERT INTO 'albumsrecordingsmap' VALUES (5069, 8, 786, 4803);
INSERT INTO 'albumsrecordingsmap' VALUES (5070, 9, 786, 4804);
INSERT INTO 'albumsrecordingsmap' VALUES (5071, 10, 786, 4805);
INSERT INTO 'albumsrecordingsmap' VALUES (5072, 11, 786, 4806);
INSERT INTO 'albumsrecordingsmap' VALUES (5073, 12, 786, 4807);
INSERT INTO 'albumsrecordingsmap' VALUES (5074, 13, 786, 4808);
INSERT INTO 'albumsrecordingsmap' VALUES (5075, 1, 346, 4809);
INSERT INTO 'albumsrecordingsmap' VALUES (5076, 2, 346, 4810);
INSERT INTO 'albumsrecordingsmap' VALUES (5077, 3, 346, 4811);
INSERT INTO 'albumsrecordingsmap' VALUES (5078, 4, 346, 4812);
INSERT INTO 'albumsrecordingsmap' VALUES (5079, 5, 346, 4813);
INSERT INTO 'albumsrecordingsmap' VALUES (5080, 6, 346, 4814);
INSERT INTO 'albumsrecordingsmap' VALUES (5081, 7, 346, 4815);
INSERT INTO 'albumsrecordingsmap' VALUES (5082, 8, 346, 4816);
INSERT INTO 'albumsrecordingsmap' VALUES (5083, 9, 346, 4817);
INSERT INTO 'albumsrecordingsmap' VALUES (5084, 10, 346, 4818);
INSERT INTO 'albumsrecordingsmap' VALUES (5085, 11, 346, 4819);
INSERT INTO 'albumsrecordingsmap' VALUES (5086, 12, 346, 4820);
INSERT INTO 'albumsrecordingsmap' VALUES (5087, 2, 414, 4821);
INSERT INTO 'albumsrecordingsmap' VALUES (5088, 14, 414, 4822);
INSERT INTO 'albumsrecordingsmap' VALUES (5089, 10, 414, 4823);
INSERT INTO 'albumsrecordingsmap' VALUES (5090, 11, 414, 4824);
INSERT INTO 'albumsrecordingsmap' VALUES (5101, 1, 349, 4835);
INSERT INTO 'albumsrecordingsmap' VALUES (5102, 2, 349, 4836);
INSERT INTO 'albumsrecordingsmap' VALUES (5103, 3, 349, 4837);
INSERT INTO 'albumsrecordingsmap' VALUES (5104, 4, 349, 4838);
INSERT INTO 'albumsrecordingsmap' VALUES (5105, 5, 349, 4839);
INSERT INTO 'albumsrecordingsmap' VALUES (5106, 6, 349, 4840);
INSERT INTO 'albumsrecordingsmap' VALUES (5107, 7, 349, 4841);
INSERT INTO 'albumsrecordingsmap' VALUES (5108, 8, 349, 4842);
INSERT INTO 'albumsrecordingsmap' VALUES (5109, 9, 349, 4843);
INSERT INTO 'albumsrecordingsmap' VALUES (5110, 10, 349, 4844);
INSERT INTO 'albumsrecordingsmap' VALUES (5111, 11, 349, 4845);
INSERT INTO 'albumsrecordingsmap' VALUES (5112, 12, 349, 4846);
INSERT INTO 'albumsrecordingsmap' VALUES (5113, 1, 350, 4847);
INSERT INTO 'albumsrecordingsmap' VALUES (5114, 2, 350, 4848);
INSERT INTO 'albumsrecordingsmap' VALUES (5115, 3, 350, 4849);
INSERT INTO 'albumsrecordingsmap' VALUES (5116, 4, 350, 4850);
INSERT INTO 'albumsrecordingsmap' VALUES (5117, 5, 350, 4851);
INSERT INTO 'albumsrecordingsmap' VALUES (5118, 6, 350, 4852);
INSERT INTO 'albumsrecordingsmap' VALUES (5119, 7, 350, 4853);
INSERT INTO 'albumsrecordingsmap' VALUES (5120, 8, 350, 4854);
INSERT INTO 'albumsrecordingsmap' VALUES (5121, 9, 350, 4855);
INSERT INTO 'albumsrecordingsmap' VALUES (5122, 10, 350, 4856);
INSERT INTO 'albumsrecordingsmap' VALUES (5123, 11, 350, 4857);
INSERT INTO 'albumsrecordingsmap' VALUES (5124, 12, 350, 4858);
INSERT INTO 'albumsrecordingsmap' VALUES (5125, 13, 350, 4859);
INSERT INTO 'albumsrecordingsmap' VALUES (5126, 1, 351, 4860);
INSERT INTO 'albumsrecordingsmap' VALUES (5127, 2, 351, 4861);
INSERT INTO 'albumsrecordingsmap' VALUES (5128, 3, 351, 4862);
INSERT INTO 'albumsrecordingsmap' VALUES (5129, 4, 351, 4863);
INSERT INTO 'albumsrecordingsmap' VALUES (5130, 5, 351, 4864);
INSERT INTO 'albumsrecordingsmap' VALUES (5131, 6, 351, 4865);
INSERT INTO 'albumsrecordingsmap' VALUES (5132, 7, 351, 4866);
INSERT INTO 'albumsrecordingsmap' VALUES (5133, 8, 351, 4867);
INSERT INTO 'albumsrecordingsmap' VALUES (10780, 1, 1111, 10186);
INSERT INTO 'albumsrecordingsmap' VALUES (10781, 2, 1111, 10187);
INSERT INTO 'albumsrecordingsmap' VALUES (10787, 8, 1111, 10193);
INSERT INTO 'albumsrecordingsmap' VALUES (10788, 9, 1111, 10194);
INSERT INTO 'albumsrecordingsmap' VALUES (10789, 10, 1111, 10195);
INSERT INTO 'albumsrecordingsmap' VALUES (10791, 12, 1111, 10197);
INSERT INTO 'albumsrecordingsmap' VALUES (10792, 13, 1111, 10198);
INSERT INTO 'albumsrecordingsmap' VALUES (10793, 14, 1111, 10199);
INSERT INTO 'albumsrecordingsmap' VALUES (10794, 15, 1111, 10200);
INSERT INTO 'albumsrecordingsmap' VALUES (10795, 16, 1111, 10201);
INSERT INTO 'albumsrecordingsmap' VALUES (10796, 17, 1111, 10202);
INSERT INTO 'albumsrecordingsmap' VALUES (10763, 11, 1110, 10169);
INSERT INTO 'albumsrecordingsmap' VALUES (10764, 12, 1110, 10170);
INSERT INTO 'albumsrecordingsmap' VALUES (10765, 13, 1110, 10171);
INSERT INTO 'albumsrecordingsmap' VALUES (5148, 1, 353, 4882);
INSERT INTO 'albumsrecordingsmap' VALUES (5149, 2, 353, 4883);
INSERT INTO 'albumsrecordingsmap' VALUES (5150, 3, 353, 4884);
INSERT INTO 'albumsrecordingsmap' VALUES (5151, 4, 353, 4885);
INSERT INTO 'albumsrecordingsmap' VALUES (5152, 5, 353, 4886);
INSERT INTO 'albumsrecordingsmap' VALUES (5153, 6, 353, 4887);
INSERT INTO 'albumsrecordingsmap' VALUES (5154, 7, 353, 4888);
INSERT INTO 'albumsrecordingsmap' VALUES (5155, 8, 353, 4889);
INSERT INTO 'albumsrecordingsmap' VALUES (5156, 9, 353, 4890);
INSERT INTO 'albumsrecordingsmap' VALUES (5157, 10, 353, 4891);
INSERT INTO 'albumsrecordingsmap' VALUES (5158, 11, 353, 4892);
INSERT INTO 'albumsrecordingsmap' VALUES (5159, 12, 353, 4893);
INSERT INTO 'albumsrecordingsmap' VALUES (5160, 13, 353, 4894);
INSERT INTO 'albumsrecordingsmap' VALUES (5161, 14, 353, 4895);
INSERT INTO 'albumsrecordingsmap' VALUES (5162, 15, 353, 4896);
INSERT INTO 'albumsrecordingsmap' VALUES (5163, 16, 353, 4897);
INSERT INTO 'albumsrecordingsmap' VALUES (5164, 17, 353, 4898);
INSERT INTO 'albumsrecordingsmap' VALUES (5165, 18, 353, 4899);
INSERT INTO 'albumsrecordingsmap' VALUES (5166, 1, 347, 4900);
INSERT INTO 'albumsrecordingsmap' VALUES (5167, 2, 347, 4901);
INSERT INTO 'albumsrecordingsmap' VALUES (5168, 3, 347, 4902);
INSERT INTO 'albumsrecordingsmap' VALUES (5169, 4, 347, 4903);
INSERT INTO 'albumsrecordingsmap' VALUES (5170, 5, 347, 4904);
INSERT INTO 'albumsrecordingsmap' VALUES (5171, 6, 347, 4905);
INSERT INTO 'albumsrecordingsmap' VALUES (5172, 7, 347, 4906);
INSERT INTO 'albumsrecordingsmap' VALUES (5173, 8, 347, 4907);
INSERT INTO 'albumsrecordingsmap' VALUES (5174, 9, 347, 4908);
INSERT INTO 'albumsrecordingsmap' VALUES (5175, 10, 347, 4909);
INSERT INTO 'albumsrecordingsmap' VALUES (5176, 11, 347, 4910);
INSERT INTO 'albumsrecordingsmap' VALUES (5177, 12, 347, 4911);
INSERT INTO 'albumsrecordingsmap' VALUES (5178, 1, 354, 4912);
INSERT INTO 'albumsrecordingsmap' VALUES (5179, 2, 354, 4913);
INSERT INTO 'albumsrecordingsmap' VALUES (5180, 3, 354, 4914);
INSERT INTO 'albumsrecordingsmap' VALUES (5181, 4, 354, 4915);
INSERT INTO 'albumsrecordingsmap' VALUES (5182, 5, 354, 4916);
INSERT INTO 'albumsrecordingsmap' VALUES (5183, 6, 354, 4917);
INSERT INTO 'albumsrecordingsmap' VALUES (5184, 7, 354, 4918);
INSERT INTO 'albumsrecordingsmap' VALUES (5185, 8, 354, 4919);
INSERT INTO 'albumsrecordingsmap' VALUES (5186, 9, 354, 4920);
INSERT INTO 'albumsrecordingsmap' VALUES (5187, 10, 354, 4921);
INSERT INTO 'albumsrecordingsmap' VALUES (5188, 11, 354, 4922);
INSERT INTO 'albumsrecordingsmap' VALUES (5189, 12, 354, 4923);
INSERT INTO 'albumsrecordingsmap' VALUES (5190, 13, 354, 4924);
INSERT INTO 'albumsrecordingsmap' VALUES (5191, 14, 354, 4925);
INSERT INTO 'albumsrecordingsmap' VALUES (5192, 15, 354, 4926);
INSERT INTO 'albumsrecordingsmap' VALUES (5193, 16, 354, 4927);
INSERT INTO 'albumsrecordingsmap' VALUES (5194, 17, 354, 4928);
INSERT INTO 'albumsrecordingsmap' VALUES (5195, 18, 354, 4929);
INSERT INTO 'albumsrecordingsmap' VALUES (5196, 19, 354, 4930);
INSERT INTO 'albumsrecordingsmap' VALUES (5197, 20, 354, 4931);
INSERT INTO 'albumsrecordingsmap' VALUES (5198, 1, 714, 2958);
INSERT INTO 'albumsrecordingsmap' VALUES (5199, 2, 714, 2959);
INSERT INTO 'albumsrecordingsmap' VALUES (5200, 3, 714, 4932);
INSERT INTO 'albumsrecordingsmap' VALUES (5201, 4, 714, 2957);
INSERT INTO 'albumsrecordingsmap' VALUES (5202, 5, 714, 2960);
INSERT INTO 'albumsrecordingsmap' VALUES (5203, 6, 714, 2961);
INSERT INTO 'albumsrecordingsmap' VALUES (5204, 7, 714, 2963);
INSERT INTO 'albumsrecordingsmap' VALUES (5205, 8, 714, 2964);
INSERT INTO 'albumsrecordingsmap' VALUES (5206, 9, 714, 4933);
INSERT INTO 'albumsrecordingsmap' VALUES (5207, 10, 714, 2962);
INSERT INTO 'albumsrecordingsmap' VALUES (5208, 1, 355, 4045);
INSERT INTO 'albumsrecordingsmap' VALUES (5209, 2, 355, 4934);
INSERT INTO 'albumsrecordingsmap' VALUES (5210, 3, 355, 4935);
INSERT INTO 'albumsrecordingsmap' VALUES (5211, 4, 355, 4936);
INSERT INTO 'albumsrecordingsmap' VALUES (5212, 5, 355, 4937);
INSERT INTO 'albumsrecordingsmap' VALUES (5213, 6, 355, 4938);
INSERT INTO 'albumsrecordingsmap' VALUES (5214, 7, 355, 4939);
INSERT INTO 'albumsrecordingsmap' VALUES (5215, 8, 355, 4940);
INSERT INTO 'albumsrecordingsmap' VALUES (5216, 9, 355, 4941);
INSERT INTO 'albumsrecordingsmap' VALUES (5217, 10, 355, 4942);
INSERT INTO 'albumsrecordingsmap' VALUES (5218, 11, 355, 4943);
INSERT INTO 'albumsrecordingsmap' VALUES (5219, 12, 355, 4944);
INSERT INTO 'albumsrecordingsmap' VALUES (5220, 13, 355, 4945);
INSERT INTO 'albumsrecordingsmap' VALUES (5221, 1, 356, 4946);
INSERT INTO 'albumsrecordingsmap' VALUES (5222, 2, 356, 4947);
INSERT INTO 'albumsrecordingsmap' VALUES (5223, 3, 356, 4948);
INSERT INTO 'albumsrecordingsmap' VALUES (5224, 4, 356, 4949);
INSERT INTO 'albumsrecordingsmap' VALUES (5225, 5, 356, 4950);
INSERT INTO 'albumsrecordingsmap' VALUES (5226, 6, 356, 4951);
INSERT INTO 'albumsrecordingsmap' VALUES (5227, 7, 356, 4952);
INSERT INTO 'albumsrecordingsmap' VALUES (5228, 8, 356, 4953);
INSERT INTO 'albumsrecordingsmap' VALUES (5229, 9, 356, 4954);
INSERT INTO 'albumsrecordingsmap' VALUES (5230, 10, 356, 4955);
INSERT INTO 'albumsrecordingsmap' VALUES (5231, 11, 356, 4956);
INSERT INTO 'albumsrecordingsmap' VALUES (5232, 12, 356, 4957);
INSERT INTO 'albumsrecordingsmap' VALUES (5233, 13, 356, 4958);
INSERT INTO 'albumsrecordingsmap' VALUES (5234, 14, 356, 4959);
INSERT INTO 'albumsrecordingsmap' VALUES (5235, 1, 357, 4960);
INSERT INTO 'albumsrecordingsmap' VALUES (5236, 2, 357, 4961);
INSERT INTO 'albumsrecordingsmap' VALUES (5237, 3, 357, 4962);
INSERT INTO 'albumsrecordingsmap' VALUES (5238, 4, 357, 4963);
INSERT INTO 'albumsrecordingsmap' VALUES (5239, 5, 357, 4964);
INSERT INTO 'albumsrecordingsmap' VALUES (5240, 6, 357, 4965);
INSERT INTO 'albumsrecordingsmap' VALUES (5241, 7, 357, 4966);
INSERT INTO 'albumsrecordingsmap' VALUES (5242, 8, 357, 4967);
INSERT INTO 'albumsrecordingsmap' VALUES (5243, 9, 357, 4968);
INSERT INTO 'albumsrecordingsmap' VALUES (5244, 10, 357, 4969);
INSERT INTO 'albumsrecordingsmap' VALUES (5245, 11, 357, 4970);
INSERT INTO 'albumsrecordingsmap' VALUES (5246, 12, 357, 4971);
INSERT INTO 'albumsrecordingsmap' VALUES (5247, 13, 357, 4972);
INSERT INTO 'albumsrecordingsmap' VALUES (5248, 14, 357, 4973);
INSERT INTO 'albumsrecordingsmap' VALUES (5249, 15, 357, 4974);
INSERT INTO 'albumsrecordingsmap' VALUES (5250, 16, 357, 4975);
INSERT INTO 'albumsrecordingsmap' VALUES (5251, 1, 358, 4976);
INSERT INTO 'albumsrecordingsmap' VALUES (5252, 2, 358, 4977);
INSERT INTO 'albumsrecordingsmap' VALUES (5253, 3, 358, 4978);
INSERT INTO 'albumsrecordingsmap' VALUES (5254, 4, 358, 4979);
INSERT INTO 'albumsrecordingsmap' VALUES (5255, 5, 358, 4980);
INSERT INTO 'albumsrecordingsmap' VALUES (5256, 6, 358, 4981);
INSERT INTO 'albumsrecordingsmap' VALUES (5257, 7, 358, 4982);
INSERT INTO 'albumsrecordingsmap' VALUES (5258, 8, 358, 4983);
INSERT INTO 'albumsrecordingsmap' VALUES (5259, 9, 358, 4984);
INSERT INTO 'albumsrecordingsmap' VALUES (5260, 10, 358, 4985);
INSERT INTO 'albumsrecordingsmap' VALUES (5261, 11, 358, 4986);
INSERT INTO 'albumsrecordingsmap' VALUES (5262, 12, 358, 4987);
INSERT INTO 'albumsrecordingsmap' VALUES (5288, 1, 361, 5012);
INSERT INTO 'albumsrecordingsmap' VALUES (5289, 2, 361, 5013);
INSERT INTO 'albumsrecordingsmap' VALUES (5290, 3, 361, 5014);
INSERT INTO 'albumsrecordingsmap' VALUES (5291, 4, 361, 5015);
INSERT INTO 'albumsrecordingsmap' VALUES (5292, 5, 361, 5016);
INSERT INTO 'albumsrecordingsmap' VALUES (5293, 6, 361, 5017);
INSERT INTO 'albumsrecordingsmap' VALUES (5294, 7, 361, 5018);
INSERT INTO 'albumsrecordingsmap' VALUES (5295, 8, 361, 5019);
INSERT INTO 'albumsrecordingsmap' VALUES (5296, 9, 361, 5020);
INSERT INTO 'albumsrecordingsmap' VALUES (5297, 10, 361, 5021);
INSERT INTO 'albumsrecordingsmap' VALUES (5298, 11, 361, 5022);
INSERT INTO 'albumsrecordingsmap' VALUES (5299, 12, 361, 5023);
INSERT INTO 'albumsrecordingsmap' VALUES (5300, 13, 361, 5024);
INSERT INTO 'albumsrecordingsmap' VALUES (5301, 14, 361, 5025);
INSERT INTO 'albumsrecordingsmap' VALUES (5302, 1, 362, 5026);
INSERT INTO 'albumsrecordingsmap' VALUES (5303, 2, 362, 5027);
INSERT INTO 'albumsrecordingsmap' VALUES (5304, 3, 362, 5028);
INSERT INTO 'albumsrecordingsmap' VALUES (5305, 4, 362, 5029);
INSERT INTO 'albumsrecordingsmap' VALUES (5306, 5, 362, 5030);
INSERT INTO 'albumsrecordingsmap' VALUES (5307, 6, 362, 5031);
INSERT INTO 'albumsrecordingsmap' VALUES (5308, 7, 362, 5032);
INSERT INTO 'albumsrecordingsmap' VALUES (5309, 8, 362, 5033);
INSERT INTO 'albumsrecordingsmap' VALUES (5310, 9, 362, 5034);
INSERT INTO 'albumsrecordingsmap' VALUES (5311, 10, 362, 5035);
INSERT INTO 'albumsrecordingsmap' VALUES (5312, 11, 362, 5036);
INSERT INTO 'albumsrecordingsmap' VALUES (5313, 12, 362, 5037);
INSERT INTO 'albumsrecordingsmap' VALUES (5314, 13, 362, 5038);
INSERT INTO 'albumsrecordingsmap' VALUES (5315, 14, 362, 5039);
INSERT INTO 'albumsrecordingsmap' VALUES (5316, 15, 362, 5040);
INSERT INTO 'albumsrecordingsmap' VALUES (5317, 16, 362, 5041);
INSERT INTO 'albumsrecordingsmap' VALUES (5318, 1, 363, 5042);
INSERT INTO 'albumsrecordingsmap' VALUES (5319, 2, 363, 5043);
INSERT INTO 'albumsrecordingsmap' VALUES (5320, 3, 363, 5044);
INSERT INTO 'albumsrecordingsmap' VALUES (5321, 4, 363, 5045);
INSERT INTO 'albumsrecordingsmap' VALUES (5322, 5, 363, 5046);
INSERT INTO 'albumsrecordingsmap' VALUES (5323, 6, 363, 5047);
INSERT INTO 'albumsrecordingsmap' VALUES (5324, 7, 363, 5048);
INSERT INTO 'albumsrecordingsmap' VALUES (5325, 8, 363, 5049);
INSERT INTO 'albumsrecordingsmap' VALUES (5326, 9, 363, 5050);
INSERT INTO 'albumsrecordingsmap' VALUES (5327, 10, 363, 5051);
INSERT INTO 'albumsrecordingsmap' VALUES (5328, 11, 363, 5052);
INSERT INTO 'albumsrecordingsmap' VALUES (5329, 12, 363, 5053);
INSERT INTO 'albumsrecordingsmap' VALUES (5330, 13, 363, 5054);
INSERT INTO 'albumsrecordingsmap' VALUES (5331, 1, 364, 5055);
INSERT INTO 'albumsrecordingsmap' VALUES (5332, 2, 364, 5056);
INSERT INTO 'albumsrecordingsmap' VALUES (5333, 3, 364, 5057);
INSERT INTO 'albumsrecordingsmap' VALUES (5334, 4, 364, 5058);
INSERT INTO 'albumsrecordingsmap' VALUES (5335, 5, 364, 5059);
INSERT INTO 'albumsrecordingsmap' VALUES (5336, 6, 364, 5060);
INSERT INTO 'albumsrecordingsmap' VALUES (5337, 7, 364, 5061);
INSERT INTO 'albumsrecordingsmap' VALUES (5338, 8, 364, 5062);
INSERT INTO 'albumsrecordingsmap' VALUES (5339, 9, 364, 5063);
INSERT INTO 'albumsrecordingsmap' VALUES (5340, 10, 364, 5064);
INSERT INTO 'albumsrecordingsmap' VALUES (5341, 11, 364, 5065);
INSERT INTO 'albumsrecordingsmap' VALUES (5342, 12, 364, 5066);
INSERT INTO 'albumsrecordingsmap' VALUES (5343, 1, 367, 1121);
INSERT INTO 'albumsrecordingsmap' VALUES (5344, 2, 367, 1122);
INSERT INTO 'albumsrecordingsmap' VALUES (5345, 3, 367, 1123);
INSERT INTO 'albumsrecordingsmap' VALUES (5346, 4, 367, 1124);
INSERT INTO 'albumsrecordingsmap' VALUES (5347, 5, 367, 1125);
INSERT INTO 'albumsrecordingsmap' VALUES (5348, 6, 367, 1126);
INSERT INTO 'albumsrecordingsmap' VALUES (5349, 7, 367, 1127);
INSERT INTO 'albumsrecordingsmap' VALUES (5350, 8, 367, 1128);
INSERT INTO 'albumsrecordingsmap' VALUES (5351, 9, 367, 1129);
INSERT INTO 'albumsrecordingsmap' VALUES (5352, 10, 367, 1130);
INSERT INTO 'albumsrecordingsmap' VALUES (5353, 11, 367, 1131);
INSERT INTO 'albumsrecordingsmap' VALUES (5354, 12, 367, 1132);
INSERT INTO 'albumsrecordingsmap' VALUES (5355, 13, 367, 1133);
INSERT INTO 'albumsrecordingsmap' VALUES (5356, 14, 367, 1134);
INSERT INTO 'albumsrecordingsmap' VALUES (5357, 15, 367, 1135);
INSERT INTO 'albumsrecordingsmap' VALUES (5358, 16, 367, 1136);
INSERT INTO 'albumsrecordingsmap' VALUES (5359, 17, 367, 1137);
INSERT INTO 'albumsrecordingsmap' VALUES (5360, 18, 367, 1138);
INSERT INTO 'albumsrecordingsmap' VALUES (5361, 19, 367, 1139);
INSERT INTO 'albumsrecordingsmap' VALUES (5362, 20, 367, 1140);
INSERT INTO 'albumsrecordingsmap' VALUES (5363, 21, 367, 1141);
INSERT INTO 'albumsrecordingsmap' VALUES (5364, 23, 367, 1142);
INSERT INTO 'albumsrecordingsmap' VALUES (5365, 22, 367, 1143);
INSERT INTO 'albumsrecordingsmap' VALUES (5366, 24, 367, 1144);
INSERT INTO 'albumsrecordingsmap' VALUES (5367, 25, 367, 1145);
INSERT INTO 'albumsrecordingsmap' VALUES (5381, 1, 373, 5080);
INSERT INTO 'albumsrecordingsmap' VALUES (5382, 2, 373, 5081);
INSERT INTO 'albumsrecordingsmap' VALUES (5383, 3, 373, 5082);
INSERT INTO 'albumsrecordingsmap' VALUES (5384, 4, 373, 5083);
INSERT INTO 'albumsrecordingsmap' VALUES (5385, 5, 373, 5084);
INSERT INTO 'albumsrecordingsmap' VALUES (5386, 6, 373, 5085);
INSERT INTO 'albumsrecordingsmap' VALUES (5387, 7, 373, 5086);
INSERT INTO 'albumsrecordingsmap' VALUES (5388, 8, 373, 5087);
INSERT INTO 'albumsrecordingsmap' VALUES (5389, 9, 373, 5088);
INSERT INTO 'albumsrecordingsmap' VALUES (5390, 10, 373, 5089);
INSERT INTO 'albumsrecordingsmap' VALUES (5391, 11, 373, 5090);
INSERT INTO 'albumsrecordingsmap' VALUES (5392, 12, 373, 5091);
INSERT INTO 'albumsrecordingsmap' VALUES (5393, 13, 373, 5092);
INSERT INTO 'albumsrecordingsmap' VALUES (5394, 14, 373, 5093);
INSERT INTO 'albumsrecordingsmap' VALUES (5395, 15, 373, 5094);
INSERT INTO 'albumsrecordingsmap' VALUES (5396, 16, 373, 5095);
INSERT INTO 'albumsrecordingsmap' VALUES (5397, 17, 373, 5096);
INSERT INTO 'albumsrecordingsmap' VALUES (5272, 1, 360, 4997);
INSERT INTO 'albumsrecordingsmap' VALUES (5273, 2, 360, 4998);
INSERT INTO 'albumsrecordingsmap' VALUES (5274, 3, 360, 4999);
INSERT INTO 'albumsrecordingsmap' VALUES (5275, 4, 360, 5000);
INSERT INTO 'albumsrecordingsmap' VALUES (5276, 5, 360, 5001);
INSERT INTO 'albumsrecordingsmap' VALUES (5277, 6, 360, 5002);
INSERT INTO 'albumsrecordingsmap' VALUES (5278, 7, 360, 5003);
INSERT INTO 'albumsrecordingsmap' VALUES (5279, 8, 360, 5004);
INSERT INTO 'albumsrecordingsmap' VALUES (5411, 1, 377, 5099);
INSERT INTO 'albumsrecordingsmap' VALUES (5412, 2, 377, 5100);
INSERT INTO 'albumsrecordingsmap' VALUES (5413, 3, 377, 5101);
INSERT INTO 'albumsrecordingsmap' VALUES (5414, 4, 377, 5102);
INSERT INTO 'albumsrecordingsmap' VALUES (5415, 5, 377, 5103);
INSERT INTO 'albumsrecordingsmap' VALUES (5416, 6, 377, 5104);
INSERT INTO 'albumsrecordingsmap' VALUES (5417, 7, 377, 5105);
INSERT INTO 'albumsrecordingsmap' VALUES (5418, 8, 377, 5106);
INSERT INTO 'albumsrecordingsmap' VALUES (5419, 9, 377, 5107);
INSERT INTO 'albumsrecordingsmap' VALUES (5420, 10, 377, 5108);
INSERT INTO 'albumsrecordingsmap' VALUES (5421, 11, 377, 5109);
INSERT INTO 'albumsrecordingsmap' VALUES (5422, 12, 377, 5110);
INSERT INTO 'albumsrecordingsmap' VALUES (5423, 13, 377, 5111);
INSERT INTO 'albumsrecordingsmap' VALUES (5424, 14, 377, 5112);
INSERT INTO 'albumsrecordingsmap' VALUES (5425, 15, 377, 5113);
INSERT INTO 'albumsrecordingsmap' VALUES (5426, 16, 377, 5114);
INSERT INTO 'albumsrecordingsmap' VALUES (5427, 17, 377, 5115);
INSERT INTO 'albumsrecordingsmap' VALUES (5428, 1, 369, 5116);
INSERT INTO 'albumsrecordingsmap' VALUES (5429, 2, 369, 5117);
INSERT INTO 'albumsrecordingsmap' VALUES (5430, 3, 369, 5118);
INSERT INTO 'albumsrecordingsmap' VALUES (5431, 4, 369, 5119);
INSERT INTO 'albumsrecordingsmap' VALUES (5432, 5, 369, 5120);
INSERT INTO 'albumsrecordingsmap' VALUES (5433, 6, 369, 5121);
INSERT INTO 'albumsrecordingsmap' VALUES (5434, 7, 369, 5122);
INSERT INTO 'albumsrecordingsmap' VALUES (5435, 8, 369, 5123);
INSERT INTO 'albumsrecordingsmap' VALUES (5436, 9, 369, 5124);
INSERT INTO 'albumsrecordingsmap' VALUES (5437, 10, 369, 5125);
INSERT INTO 'albumsrecordingsmap' VALUES (5438, 5, 725, 1036);
INSERT INTO 'albumsrecordingsmap' VALUES (5441, 1, 378, 2487);
INSERT INTO 'albumsrecordingsmap' VALUES (5442, 2, 378, 2531);
INSERT INTO 'albumsrecordingsmap' VALUES (5443, 3, 378, 4384);
INSERT INTO 'albumsrecordingsmap' VALUES (5444, 1, 380, 4388);
INSERT INTO 'albumsrecordingsmap' VALUES (5445, 2, 380, 5097);
INSERT INTO 'albumsrecordingsmap' VALUES (5446, 3, 380, 5126);
INSERT INTO 'albumsrecordingsmap' VALUES (5447, 4, 380, 5127);
INSERT INTO 'albumsrecordingsmap' VALUES (5448, 5, 380, 5128);
INSERT INTO 'albumsrecordingsmap' VALUES (5449, 6, 380, 5129);
INSERT INTO 'albumsrecordingsmap' VALUES (5450, 7, 380, 5130);
INSERT INTO 'albumsrecordingsmap' VALUES (5451, 1, 382, 5131);
INSERT INTO 'albumsrecordingsmap' VALUES (5452, 2, 382, 5132);
INSERT INTO 'albumsrecordingsmap' VALUES (5453, 3, 382, 5133);
INSERT INTO 'albumsrecordingsmap' VALUES (5454, 4, 382, 5134);
INSERT INTO 'albumsrecordingsmap' VALUES (5455, 5, 382, 5135);
INSERT INTO 'albumsrecordingsmap' VALUES (5456, 6, 382, 5136);
INSERT INTO 'albumsrecordingsmap' VALUES (5457, 7, 382, 5137);
INSERT INTO 'albumsrecordingsmap' VALUES (5458, 8, 382, 5138);
INSERT INTO 'albumsrecordingsmap' VALUES (5459, 9, 382, 5139);
INSERT INTO 'albumsrecordingsmap' VALUES (5460, 10, 382, 5140);
INSERT INTO 'albumsrecordingsmap' VALUES (5461, 11, 382, 5141);
INSERT INTO 'albumsrecordingsmap' VALUES (5462, 12, 382, 5142);
INSERT INTO 'albumsrecordingsmap' VALUES (5463, 13, 382, 5143);
INSERT INTO 'albumsrecordingsmap' VALUES (5464, 1, 384, 5144);
INSERT INTO 'albumsrecordingsmap' VALUES (5465, 2, 384, 5145);
INSERT INTO 'albumsrecordingsmap' VALUES (5466, 3, 384, 5146);
INSERT INTO 'albumsrecordingsmap' VALUES (5467, 4, 384, 5147);
INSERT INTO 'albumsrecordingsmap' VALUES (5468, 5, 384, 5148);
INSERT INTO 'albumsrecordingsmap' VALUES (5469, 6, 384, 5149);
INSERT INTO 'albumsrecordingsmap' VALUES (5470, 7, 384, 5150);
INSERT INTO 'albumsrecordingsmap' VALUES (5471, 8, 384, 5151);
INSERT INTO 'albumsrecordingsmap' VALUES (5472, 9, 384, 5152);
INSERT INTO 'albumsrecordingsmap' VALUES (5473, 10, 384, 5153);
INSERT INTO 'albumsrecordingsmap' VALUES (5474, 11, 384, 5154);
INSERT INTO 'albumsrecordingsmap' VALUES (5475, 12, 384, 5155);
INSERT INTO 'albumsrecordingsmap' VALUES (5476, 13, 384, 5156);
INSERT INTO 'albumsrecordingsmap' VALUES (5477, 14, 384, 5157);
INSERT INTO 'albumsrecordingsmap' VALUES (5478, 15, 384, 5158);
INSERT INTO 'albumsrecordingsmap' VALUES (5479, 2, 386, 5159);
INSERT INTO 'albumsrecordingsmap' VALUES (5480, 5, 386, 5160);
INSERT INTO 'albumsrecordingsmap' VALUES (5481, 5, 386, 5161);
INSERT INTO 'albumsrecordingsmap' VALUES (5482, 6, 386, 5162);
INSERT INTO 'albumsrecordingsmap' VALUES (5483, 8, 386, 5163);
INSERT INTO 'albumsrecordingsmap' VALUES (5484, 10, 386, 5164);
INSERT INTO 'albumsrecordingsmap' VALUES (5485, 12, 386, 5165);
INSERT INTO 'albumsrecordingsmap' VALUES (5486, 13, 386, 5166);
INSERT INTO 'albumsrecordingsmap' VALUES (5487, 15, 386, 5167);
INSERT INTO 'albumsrecordingsmap' VALUES (5488, 17, 386, 5168);
INSERT INTO 'albumsrecordingsmap' VALUES (5489, 18, 386, 5169);
INSERT INTO 'albumsrecordingsmap' VALUES (5490, 1, 387, 1453);
INSERT INTO 'albumsrecordingsmap' VALUES (5491, 2, 387, 1454);
INSERT INTO 'albumsrecordingsmap' VALUES (5492, 3, 387, 1455);
INSERT INTO 'albumsrecordingsmap' VALUES (5493, 4, 387, 1456);
INSERT INTO 'albumsrecordingsmap' VALUES (5494, 5, 387, 1457);
INSERT INTO 'albumsrecordingsmap' VALUES (5495, 6, 387, 1458);
INSERT INTO 'albumsrecordingsmap' VALUES (5496, 7, 387, 1459);
INSERT INTO 'albumsrecordingsmap' VALUES (5497, 8, 387, 1460);
INSERT INTO 'albumsrecordingsmap' VALUES (5498, 9, 387, 1461);
INSERT INTO 'albumsrecordingsmap' VALUES (5499, 10, 387, 1462);
INSERT INTO 'albumsrecordingsmap' VALUES (5500, 11, 387, 1463);
INSERT INTO 'albumsrecordingsmap' VALUES (5501, 12, 387, 1464);
INSERT INTO 'albumsrecordingsmap' VALUES (5502, 13, 387, 1989);
INSERT INTO 'albumsrecordingsmap' VALUES (5503, 14, 387, 1987);
INSERT INTO 'albumsrecordingsmap' VALUES (5504, 1, 389, 5170);
INSERT INTO 'albumsrecordingsmap' VALUES (5505, 2, 389, 5171);
INSERT INTO 'albumsrecordingsmap' VALUES (5506, 3, 389, 5172);
INSERT INTO 'albumsrecordingsmap' VALUES (5507, 4, 389, 5173);
INSERT INTO 'albumsrecordingsmap' VALUES (5508, 5, 389, 5174);
INSERT INTO 'albumsrecordingsmap' VALUES (5509, 6, 389, 5175);
INSERT INTO 'albumsrecordingsmap' VALUES (5510, 7, 389, 5176);
INSERT INTO 'albumsrecordingsmap' VALUES (5511, 8, 389, 5177);
INSERT INTO 'albumsrecordingsmap' VALUES (5512, 9, 389, 5178);
INSERT INTO 'albumsrecordingsmap' VALUES (5513, 10, 389, 5179);
INSERT INTO 'albumsrecordingsmap' VALUES (5514, 11, 389, 5180);
INSERT INTO 'albumsrecordingsmap' VALUES (5515, 12, 389, 5181);
INSERT INTO 'albumsrecordingsmap' VALUES (5516, 13, 389, 5182);
INSERT INTO 'albumsrecordingsmap' VALUES (5517, 15, 387, 1992);
INSERT INTO 'albumsrecordingsmap' VALUES (5518, 16, 387, 1983);
INSERT INTO 'albumsrecordingsmap' VALUES (5519, 17, 387, 2778);
INSERT INTO 'albumsrecordingsmap' VALUES (5520, 1, 390, 5183);
INSERT INTO 'albumsrecordingsmap' VALUES (5521, 2, 390, 5184);
INSERT INTO 'albumsrecordingsmap' VALUES (5522, 3, 390, 5185);
INSERT INTO 'albumsrecordingsmap' VALUES (5523, 4, 390, 5186);
INSERT INTO 'albumsrecordingsmap' VALUES (5524, 5, 390, 5187);
INSERT INTO 'albumsrecordingsmap' VALUES (5525, 6, 390, 5188);
INSERT INTO 'albumsrecordingsmap' VALUES (5526, 7, 390, 5189);
INSERT INTO 'albumsrecordingsmap' VALUES (5527, 8, 390, 5190);
INSERT INTO 'albumsrecordingsmap' VALUES (5528, 9, 390, 5191);
INSERT INTO 'albumsrecordingsmap' VALUES (5529, 10, 390, 5192);
INSERT INTO 'albumsrecordingsmap' VALUES (5530, 11, 390, 5193);
INSERT INTO 'albumsrecordingsmap' VALUES (5531, 12, 390, 5194);
INSERT INTO 'albumsrecordingsmap' VALUES (5532, 1, 391, 5195);
INSERT INTO 'albumsrecordingsmap' VALUES (5533, 2, 391, 5196);
INSERT INTO 'albumsrecordingsmap' VALUES (5534, 3, 391, 5197);
INSERT INTO 'albumsrecordingsmap' VALUES (5535, 4, 391, 5198);
INSERT INTO 'albumsrecordingsmap' VALUES (5536, 5, 391, 5199);
INSERT INTO 'albumsrecordingsmap' VALUES (5537, 6, 391, 5200);
INSERT INTO 'albumsrecordingsmap' VALUES (5538, 7, 391, 5201);
INSERT INTO 'albumsrecordingsmap' VALUES (5539, 8, 391, 5202);
INSERT INTO 'albumsrecordingsmap' VALUES (5540, 9, 391, 5203);
INSERT INTO 'albumsrecordingsmap' VALUES (5541, 10, 391, 5204);
INSERT INTO 'albumsrecordingsmap' VALUES (5542, 11, 391, 5205);
INSERT INTO 'albumsrecordingsmap' VALUES (5543, 12, 391, 5206);
INSERT INTO 'albumsrecordingsmap' VALUES (5544, 13, 391, 5207);
INSERT INTO 'albumsrecordingsmap' VALUES (5545, 2, 749, 5208);
INSERT INTO 'albumsrecordingsmap' VALUES (5546, 7, 392, 2245);
INSERT INTO 'albumsrecordingsmap' VALUES (5547, 8, 392, 2238);
INSERT INTO 'albumsrecordingsmap' VALUES (5548, 9, 392, 2242);
INSERT INTO 'albumsrecordingsmap' VALUES (5549, 10, 392, 2236);
INSERT INTO 'albumsrecordingsmap' VALUES (5550, 11, 392, 5209);
INSERT INTO 'albumsrecordingsmap' VALUES (5551, 12, 392, 5210);
INSERT INTO 'albumsrecordingsmap' VALUES (5552, 13, 392, 5211);
INSERT INTO 'albumsrecordingsmap' VALUES (5553, 14, 392, 5212);
INSERT INTO 'albumsrecordingsmap' VALUES (5554, 1, 392, 2240);
INSERT INTO 'albumsrecordingsmap' VALUES (5555, 2, 392, 2244);
INSERT INTO 'albumsrecordingsmap' VALUES (5556, 3, 392, 2237);
INSERT INTO 'albumsrecordingsmap' VALUES (5557, 4, 392, 2243);
INSERT INTO 'albumsrecordingsmap' VALUES (5558, 5, 392, 2239);
INSERT INTO 'albumsrecordingsmap' VALUES (5559, 6, 392, 2241);
INSERT INTO 'albumsrecordingsmap' VALUES (5560, 1, 393, 5213);
INSERT INTO 'albumsrecordingsmap' VALUES (5561, 2, 393, 5214);
INSERT INTO 'albumsrecordingsmap' VALUES (5562, 3, 393, 5215);
INSERT INTO 'albumsrecordingsmap' VALUES (5563, 4, 393, 5216);
INSERT INTO 'albumsrecordingsmap' VALUES (5564, 5, 393, 5217);
INSERT INTO 'albumsrecordingsmap' VALUES (5565, 6, 393, 5218);
INSERT INTO 'albumsrecordingsmap' VALUES (5566, 7, 393, 5219);
INSERT INTO 'albumsrecordingsmap' VALUES (5567, 8, 393, 5220);
INSERT INTO 'albumsrecordingsmap' VALUES (5568, 9, 393, 5221);
INSERT INTO 'albumsrecordingsmap' VALUES (5569, 10, 393, 5222);
INSERT INTO 'albumsrecordingsmap' VALUES (5570, 11, 393, 5223);
INSERT INTO 'albumsrecordingsmap' VALUES (5571, 12, 393, 5224);
INSERT INTO 'albumsrecordingsmap' VALUES (5587, 1, 395, 5240);
INSERT INTO 'albumsrecordingsmap' VALUES (5588, 2, 395, 5241);
INSERT INTO 'albumsrecordingsmap' VALUES (5589, 3, 395, 5242);
INSERT INTO 'albumsrecordingsmap' VALUES (5590, 4, 395, 5243);
INSERT INTO 'albumsrecordingsmap' VALUES (5591, 5, 395, 5244);
INSERT INTO 'albumsrecordingsmap' VALUES (5592, 6, 395, 5245);
INSERT INTO 'albumsrecordingsmap' VALUES (5593, 7, 395, 5246);
INSERT INTO 'albumsrecordingsmap' VALUES (5594, 8, 395, 5247);
INSERT INTO 'albumsrecordingsmap' VALUES (5595, 9, 395, 5248);
INSERT INTO 'albumsrecordingsmap' VALUES (5596, 10, 395, 5249);
INSERT INTO 'albumsrecordingsmap' VALUES (5597, 11, 395, 5250);
INSERT INTO 'albumsrecordingsmap' VALUES (5598, 12, 395, 5251);
INSERT INTO 'albumsrecordingsmap' VALUES (5599, 13, 395, 5252);
INSERT INTO 'albumsrecordingsmap' VALUES (5600, 14, 395, 5253);
INSERT INTO 'albumsrecordingsmap' VALUES (5601, 15, 395, 5254);
INSERT INTO 'albumsrecordingsmap' VALUES (5602, 16, 395, 5255);
INSERT INTO 'albumsrecordingsmap' VALUES (5603, 17, 395, 5256);
INSERT INTO 'albumsrecordingsmap' VALUES (5604, 18, 395, 5257);
INSERT INTO 'albumsrecordingsmap' VALUES (10797, 1, 1112, 10203);
INSERT INTO 'albumsrecordingsmap' VALUES (10798, 2, 1112, 10204);
INSERT INTO 'albumsrecordingsmap' VALUES (10799, 3, 1112, 10205);
INSERT INTO 'albumsrecordingsmap' VALUES (5440, 6, 234, 2626);
INSERT INTO 'albumsrecordingsmap' VALUES (10898, 1, 1121, 1359);
INSERT INTO 'albumsrecordingsmap' VALUES (10899, 2, 1121, 1360);
INSERT INTO 'albumsrecordingsmap' VALUES (10900, 3, 1121, 184);
INSERT INTO 'albumsrecordingsmap' VALUES (10901, 4, 1121, 110);
INSERT INTO 'albumsrecordingsmap' VALUES (10902, 5, 1121, 139);
INSERT INTO 'albumsrecordingsmap' VALUES (5605, 19, 395, 5258);
INSERT INTO 'albumsrecordingsmap' VALUES (5606, 20, 395, 5259);
INSERT INTO 'albumsrecordingsmap' VALUES (5607, 21, 395, 5260);
INSERT INTO 'albumsrecordingsmap' VALUES (5608, 22, 395, 5261);
INSERT INTO 'albumsrecordingsmap' VALUES (5609, 23, 395, 5262);
INSERT INTO 'albumsrecordingsmap' VALUES (5610, 24, 395, 5263);
INSERT INTO 'albumsrecordingsmap' VALUES (5611, 1, 396, 1400);
INSERT INTO 'albumsrecordingsmap' VALUES (5612, 2, 396, 1404);
INSERT INTO 'albumsrecordingsmap' VALUES (5613, 3, 396, 1401);
INSERT INTO 'albumsrecordingsmap' VALUES (5614, 4, 396, 1403);
INSERT INTO 'albumsrecordingsmap' VALUES (5615, 5, 396, 1381);
INSERT INTO 'albumsrecordingsmap' VALUES (5616, 6, 396, 798);
INSERT INTO 'albumsrecordingsmap' VALUES (5617, 7, 396, 1376);
INSERT INTO 'albumsrecordingsmap' VALUES (5618, 8, 396, 1377);
INSERT INTO 'albumsrecordingsmap' VALUES (5619, 9, 396, 1375);
INSERT INTO 'albumsrecordingsmap' VALUES (5620, 10, 396, 227);
INSERT INTO 'albumsrecordingsmap' VALUES (5621, 11, 396, 1388);
INSERT INTO 'albumsrecordingsmap' VALUES (5622, 12, 396, 216);
INSERT INTO 'albumsrecordingsmap' VALUES (5623, 1, 397, 5264);
INSERT INTO 'albumsrecordingsmap' VALUES (5624, 2, 397, 5265);
INSERT INTO 'albumsrecordingsmap' VALUES (5625, 3, 397, 5266);
INSERT INTO 'albumsrecordingsmap' VALUES (5626, 4, 397, 5267);
INSERT INTO 'albumsrecordingsmap' VALUES (5627, 5, 397, 5268);
INSERT INTO 'albumsrecordingsmap' VALUES (5628, 6, 397, 5269);
INSERT INTO 'albumsrecordingsmap' VALUES (5629, 7, 397, 5270);
INSERT INTO 'albumsrecordingsmap' VALUES (5630, 8, 397, 5271);
INSERT INTO 'albumsrecordingsmap' VALUES (5631, 9, 397, 5272);
INSERT INTO 'albumsrecordingsmap' VALUES (5632, 10, 397, 5273);
INSERT INTO 'albumsrecordingsmap' VALUES (5633, 11, 397, 5274);
INSERT INTO 'albumsrecordingsmap' VALUES (5634, 12, 397, 5275);
INSERT INTO 'albumsrecordingsmap' VALUES (5635, 13, 397, 5276);
INSERT INTO 'albumsrecordingsmap' VALUES (5636, 1, 400, 5277);
INSERT INTO 'albumsrecordingsmap' VALUES (5637, 2, 400, 5278);
INSERT INTO 'albumsrecordingsmap' VALUES (5638, 3, 400, 5279);
INSERT INTO 'albumsrecordingsmap' VALUES (5639, 4, 400, 5280);
INSERT INTO 'albumsrecordingsmap' VALUES (5640, 5, 400, 5281);
INSERT INTO 'albumsrecordingsmap' VALUES (5641, 6, 400, 5282);
INSERT INTO 'albumsrecordingsmap' VALUES (5642, 7, 400, 5283);
INSERT INTO 'albumsrecordingsmap' VALUES (5643, 8, 400, 5284);
INSERT INTO 'albumsrecordingsmap' VALUES (5644, 9, 400, 5285);
INSERT INTO 'albumsrecordingsmap' VALUES (5645, 10, 400, 5286);
INSERT INTO 'albumsrecordingsmap' VALUES (5646, 11, 400, 5287);
INSERT INTO 'albumsrecordingsmap' VALUES (5647, 12, 400, 5288);
INSERT INTO 'albumsrecordingsmap' VALUES (5648, 13, 400, 5289);
INSERT INTO 'albumsrecordingsmap' VALUES (5649, 14, 400, 5290);
INSERT INTO 'albumsrecordingsmap' VALUES (5650, 15, 400, 5291);
INSERT INTO 'albumsrecordingsmap' VALUES (5651, 1, 401, 5292);
INSERT INTO 'albumsrecordingsmap' VALUES (5652, 2, 401, 5293);
INSERT INTO 'albumsrecordingsmap' VALUES (5653, 3, 401, 5294);
INSERT INTO 'albumsrecordingsmap' VALUES (5654, 4, 401, 5295);
INSERT INTO 'albumsrecordingsmap' VALUES (5655, 5, 401, 5296);
INSERT INTO 'albumsrecordingsmap' VALUES (5656, 6, 401, 5297);
INSERT INTO 'albumsrecordingsmap' VALUES (5657, 7, 401, 5298);
INSERT INTO 'albumsrecordingsmap' VALUES (5658, 8, 401, 5299);
INSERT INTO 'albumsrecordingsmap' VALUES (5659, 9, 401, 5300);
INSERT INTO 'albumsrecordingsmap' VALUES (5660, 10, 401, 5301);
INSERT INTO 'albumsrecordingsmap' VALUES (5661, 11, 401, 5302);
INSERT INTO 'albumsrecordingsmap' VALUES (5662, 1, 402, 5303);
INSERT INTO 'albumsrecordingsmap' VALUES (5663, 2, 402, 5304);
INSERT INTO 'albumsrecordingsmap' VALUES (5664, 3, 402, 5305);
INSERT INTO 'albumsrecordingsmap' VALUES (5665, 4, 402, 5306);
INSERT INTO 'albumsrecordingsmap' VALUES (5666, 5, 402, 5307);
INSERT INTO 'albumsrecordingsmap' VALUES (5667, 6, 402, 5308);
INSERT INTO 'albumsrecordingsmap' VALUES (5668, 7, 402, 5309);
INSERT INTO 'albumsrecordingsmap' VALUES (5669, 8, 402, 5310);
INSERT INTO 'albumsrecordingsmap' VALUES (5670, 9, 402, 5311);
INSERT INTO 'albumsrecordingsmap' VALUES (5671, 10, 402, 5312);
INSERT INTO 'albumsrecordingsmap' VALUES (5672, 11, 402, 5313);
INSERT INTO 'albumsrecordingsmap' VALUES (5673, 12, 402, 5314);
INSERT INTO 'albumsrecordingsmap' VALUES (5674, 13, 402, 5315);
INSERT INTO 'albumsrecordingsmap' VALUES (5675, 14, 402, 5316);
INSERT INTO 'albumsrecordingsmap' VALUES (5676, 15, 402, 5317);
INSERT INTO 'albumsrecordingsmap' VALUES (5689, 1, 404, 5318);
INSERT INTO 'albumsrecordingsmap' VALUES (5690, 2, 404, 5319);
INSERT INTO 'albumsrecordingsmap' VALUES (5691, 3, 404, 5320);
INSERT INTO 'albumsrecordingsmap' VALUES (5692, 4, 404, 5321);
INSERT INTO 'albumsrecordingsmap' VALUES (5693, 5, 404, 5322);
INSERT INTO 'albumsrecordingsmap' VALUES (5694, 6, 404, 5323);
INSERT INTO 'albumsrecordingsmap' VALUES (5695, 7, 404, 5324);
INSERT INTO 'albumsrecordingsmap' VALUES (5696, 8, 404, 5325);
INSERT INTO 'albumsrecordingsmap' VALUES (5697, 9, 404, 5326);
INSERT INTO 'albumsrecordingsmap' VALUES (5698, 10, 404, 5327);
INSERT INTO 'albumsrecordingsmap' VALUES (5699, 11, 404, 5328);
INSERT INTO 'albumsrecordingsmap' VALUES (5700, 12, 404, 5329);
INSERT INTO 'albumsrecordingsmap' VALUES (5701, 13, 404, 5330);
INSERT INTO 'albumsrecordingsmap' VALUES (5702, 14, 404, 5331);
INSERT INTO 'albumsrecordingsmap' VALUES (5703, 15, 404, 5332);
INSERT INTO 'albumsrecordingsmap' VALUES (5704, 16, 404, 5333);
INSERT INTO 'albumsrecordingsmap' VALUES (5705, 17, 404, 5334);
INSERT INTO 'albumsrecordingsmap' VALUES (5706, 1, 405, 5335);
INSERT INTO 'albumsrecordingsmap' VALUES (5707, 2, 405, 5336);
INSERT INTO 'albumsrecordingsmap' VALUES (5708, 3, 405, 5337);
INSERT INTO 'albumsrecordingsmap' VALUES (5709, 4, 405, 5338);
INSERT INTO 'albumsrecordingsmap' VALUES (5710, 5, 405, 5339);
INSERT INTO 'albumsrecordingsmap' VALUES (5711, 6, 405, 5340);
INSERT INTO 'albumsrecordingsmap' VALUES (5712, 7, 405, 5341);
INSERT INTO 'albumsrecordingsmap' VALUES (5713, 8, 405, 5342);
INSERT INTO 'albumsrecordingsmap' VALUES (5714, 9, 405, 5343);
INSERT INTO 'albumsrecordingsmap' VALUES (5715, 10, 405, 5344);
INSERT INTO 'albumsrecordingsmap' VALUES (5716, 11, 405, 5345);
INSERT INTO 'albumsrecordingsmap' VALUES (5717, 12, 405, 5346);
INSERT INTO 'albumsrecordingsmap' VALUES (5718, 1, 407, 1389);
INSERT INTO 'albumsrecordingsmap' VALUES (5719, 2, 407, 1384);
INSERT INTO 'albumsrecordingsmap' VALUES (5720, 3, 407, 1385);
INSERT INTO 'albumsrecordingsmap' VALUES (5721, 4, 407, 1390);
INSERT INTO 'albumsrecordingsmap' VALUES (5722, 5, 407, 319);
INSERT INTO 'albumsrecordingsmap' VALUES (5723, 6, 407, 285);
INSERT INTO 'albumsrecordingsmap' VALUES (5724, 7, 407, 1395);
INSERT INTO 'albumsrecordingsmap' VALUES (5725, 8, 407, 1398);
INSERT INTO 'albumsrecordingsmap' VALUES (5726, 9, 407, 1397);
INSERT INTO 'albumsrecordingsmap' VALUES (5727, 10, 407, 1382);
INSERT INTO 'albumsrecordingsmap' VALUES (5728, 1, 409, 5347);
INSERT INTO 'albumsrecordingsmap' VALUES (5729, 2, 409, 5348);
INSERT INTO 'albumsrecordingsmap' VALUES (5730, 3, 409, 5349);
INSERT INTO 'albumsrecordingsmap' VALUES (5731, 10, 64, 2552);
INSERT INTO 'albumsrecordingsmap' VALUES (5732, 1, 410, 784);
INSERT INTO 'albumsrecordingsmap' VALUES (5733, 2, 410, 4605);
INSERT INTO 'albumsrecordingsmap' VALUES (5734, 3, 410, 4612);
INSERT INTO 'albumsrecordingsmap' VALUES (5735, 4, 410, 5350);
INSERT INTO 'albumsrecordingsmap' VALUES (5736, 5, 410, 5351);
INSERT INTO 'albumsrecordingsmap' VALUES (5737, 6, 410, 5352);
INSERT INTO 'albumsrecordingsmap' VALUES (5738, 7, 410, 5353);
INSERT INTO 'albumsrecordingsmap' VALUES (5739, 8, 410, 5354);
INSERT INTO 'albumsrecordingsmap' VALUES (5740, 9, 410, 5355);
INSERT INTO 'albumsrecordingsmap' VALUES (5741, 10, 410, 5356);
INSERT INTO 'albumsrecordingsmap' VALUES (5742, 11, 410, 5357);
INSERT INTO 'albumsrecordingsmap' VALUES (5743, 12, 410, 5358);
INSERT INTO 'albumsrecordingsmap' VALUES (5744, 13, 410, 5359);
INSERT INTO 'albumsrecordingsmap' VALUES (5745, 14, 410, 5360);
INSERT INTO 'albumsrecordingsmap' VALUES (5746, 15, 410, 5361);
INSERT INTO 'albumsrecordingsmap' VALUES (5747, 16, 410, 5362);
INSERT INTO 'albumsrecordingsmap' VALUES (5748, 1, 411, 977);
INSERT INTO 'albumsrecordingsmap' VALUES (5749, 2, 411, 978);
INSERT INTO 'albumsrecordingsmap' VALUES (5750, 3, 411, 979);
INSERT INTO 'albumsrecordingsmap' VALUES (5751, 4, 411, 980);
INSERT INTO 'albumsrecordingsmap' VALUES (5752, 5, 411, 981);
INSERT INTO 'albumsrecordingsmap' VALUES (5753, 6, 411, 985);
INSERT INTO 'albumsrecordingsmap' VALUES (5754, 7, 411, 986);
INSERT INTO 'albumsrecordingsmap' VALUES (5755, 8, 411, 987);
INSERT INTO 'albumsrecordingsmap' VALUES (5756, 9, 411, 5363);
INSERT INTO 'albumsrecordingsmap' VALUES (5757, 10, 411, 5364);
INSERT INTO 'albumsrecordingsmap' VALUES (5758, 11, 411, 5365);
INSERT INTO 'albumsrecordingsmap' VALUES (5759, 12, 411, 5366);
INSERT INTO 'albumsrecordingsmap' VALUES (5760, 13, 411, 5367);
INSERT INTO 'albumsrecordingsmap' VALUES (5761, 14, 411, 5368);
INSERT INTO 'albumsrecordingsmap' VALUES (5762, 15, 411, 5369);
INSERT INTO 'albumsrecordingsmap' VALUES (5763, 16, 411, 5370);
INSERT INTO 'albumsrecordingsmap' VALUES (5764, 1, 412, 5371);
INSERT INTO 'albumsrecordingsmap' VALUES (5765, 2, 412, 5372);
INSERT INTO 'albumsrecordingsmap' VALUES (5766, 3, 412, 5373);
INSERT INTO 'albumsrecordingsmap' VALUES (5767, 4, 412, 5374);
INSERT INTO 'albumsrecordingsmap' VALUES (5768, 5, 412, 5375);
INSERT INTO 'albumsrecordingsmap' VALUES (5769, 6, 412, 5376);
INSERT INTO 'albumsrecordingsmap' VALUES (5770, 7, 412, 5377);
INSERT INTO 'albumsrecordingsmap' VALUES (5771, 8, 412, 5378);
INSERT INTO 'albumsrecordingsmap' VALUES (5772, 9, 412, 5379);
INSERT INTO 'albumsrecordingsmap' VALUES (5773, 10, 412, 5380);
INSERT INTO 'albumsrecordingsmap' VALUES (5774, 11, 412, 5381);
INSERT INTO 'albumsrecordingsmap' VALUES (5775, 12, 412, 5382);
INSERT INTO 'albumsrecordingsmap' VALUES (5776, 13, 412, 5383);
INSERT INTO 'albumsrecordingsmap' VALUES (5777, 14, 412, 5384);
INSERT INTO 'albumsrecordingsmap' VALUES (5778, 15, 412, 5385);
INSERT INTO 'albumsrecordingsmap' VALUES (5779, 16, 412, 5386);
INSERT INTO 'albumsrecordingsmap' VALUES (5780, 17, 412, 5387);
INSERT INTO 'albumsrecordingsmap' VALUES (5781, 4, 409, 5388);
INSERT INTO 'albumsrecordingsmap' VALUES (5782, 5, 409, 5389);
INSERT INTO 'albumsrecordingsmap' VALUES (5783, 6, 409, 5390);
INSERT INTO 'albumsrecordingsmap' VALUES (5784, 7, 409, 5391);
INSERT INTO 'albumsrecordingsmap' VALUES (5785, 8, 409, 5392);
INSERT INTO 'albumsrecordingsmap' VALUES (5786, 9, 409, 5393);
INSERT INTO 'albumsrecordingsmap' VALUES (5787, 10, 409, 5394);
INSERT INTO 'albumsrecordingsmap' VALUES (5788, 1, 413, 1169);
INSERT INTO 'albumsrecordingsmap' VALUES (5789, 2, 413, 1172);
INSERT INTO 'albumsrecordingsmap' VALUES (10800, 4, 1112, 10206);
INSERT INTO 'albumsrecordingsmap' VALUES (10801, 5, 1112, 10207);
INSERT INTO 'albumsrecordingsmap' VALUES (10802, 6, 1112, 10208);
INSERT INTO 'albumsrecordingsmap' VALUES (5790, 3, 413, 554);
INSERT INTO 'albumsrecordingsmap' VALUES (5791, 4, 413, 555);
INSERT INTO 'albumsrecordingsmap' VALUES (5792, 5, 413, 1174);
INSERT INTO 'albumsrecordingsmap' VALUES (5793, 6, 413, 557);
INSERT INTO 'albumsrecordingsmap' VALUES (5794, 7, 413, 558);
INSERT INTO 'albumsrecordingsmap' VALUES (5795, 8, 413, 559);
INSERT INTO 'albumsrecordingsmap' VALUES (5796, 9, 413, 560);
INSERT INTO 'albumsrecordingsmap' VALUES (5797, 10, 413, 561);
INSERT INTO 'albumsrecordingsmap' VALUES (5798, 11, 413, 1170);
INSERT INTO 'albumsrecordingsmap' VALUES (5799, 12, 413, 563);
INSERT INTO 'albumsrecordingsmap' VALUES (5800, 13, 413, 564);
INSERT INTO 'albumsrecordingsmap' VALUES (5801, 14, 413, 1176);
INSERT INTO 'albumsrecordingsmap' VALUES (5802, 15, 413, 566);
INSERT INTO 'albumsrecordingsmap' VALUES (5803, 16, 413, 567);
INSERT INTO 'albumsrecordingsmap' VALUES (5804, 17, 413, 568);
INSERT INTO 'albumsrecordingsmap' VALUES (5805, 18, 413, 569);
INSERT INTO 'albumsrecordingsmap' VALUES (5806, 19, 413, 570);
INSERT INTO 'albumsrecordingsmap' VALUES (5807, 20, 413, 1177);
INSERT INTO 'albumsrecordingsmap' VALUES (5808, 1, 416, 5395);
INSERT INTO 'albumsrecordingsmap' VALUES (5809, 2, 416, 5396);
INSERT INTO 'albumsrecordingsmap' VALUES (5810, 3, 416, 5397);
INSERT INTO 'albumsrecordingsmap' VALUES (5811, 4, 416, 5398);
INSERT INTO 'albumsrecordingsmap' VALUES (5812, 5, 416, 5399);
INSERT INTO 'albumsrecordingsmap' VALUES (5813, 6, 416, 5400);
INSERT INTO 'albumsrecordingsmap' VALUES (5814, 7, 416, 5401);
INSERT INTO 'albumsrecordingsmap' VALUES (5815, 8, 416, 5402);
INSERT INTO 'albumsrecordingsmap' VALUES (5816, 9, 416, 5403);
INSERT INTO 'albumsrecordingsmap' VALUES (5817, 10, 416, 5404);
INSERT INTO 'albumsrecordingsmap' VALUES (5818, 11, 416, 5405);
INSERT INTO 'albumsrecordingsmap' VALUES (5819, 12, 416, 5406);
INSERT INTO 'albumsrecordingsmap' VALUES (5820, 13, 416, 5407);
INSERT INTO 'albumsrecordingsmap' VALUES (5821, 14, 416, 5408);
INSERT INTO 'albumsrecordingsmap' VALUES (5822, 1, 422, 5409);
INSERT INTO 'albumsrecordingsmap' VALUES (5823, 2, 422, 5410);
INSERT INTO 'albumsrecordingsmap' VALUES (5824, 3, 422, 5411);
INSERT INTO 'albumsrecordingsmap' VALUES (5825, 4, 422, 5412);
INSERT INTO 'albumsrecordingsmap' VALUES (5826, 5, 422, 5413);
INSERT INTO 'albumsrecordingsmap' VALUES (5827, 6, 422, 5414);
INSERT INTO 'albumsrecordingsmap' VALUES (5828, 7, 422, 5415);
INSERT INTO 'albumsrecordingsmap' VALUES (5829, 8, 422, 5416);
INSERT INTO 'albumsrecordingsmap' VALUES (5830, 9, 422, 5417);
INSERT INTO 'albumsrecordingsmap' VALUES (5831, 10, 422, 5418);
INSERT INTO 'albumsrecordingsmap' VALUES (5832, 11, 422, 5419);
INSERT INTO 'albumsrecordingsmap' VALUES (5833, 12, 422, 5420);
INSERT INTO 'albumsrecordingsmap' VALUES (5834, 13, 422, 5421);
INSERT INTO 'albumsrecordingsmap' VALUES (5835, 14, 422, 5422);
INSERT INTO 'albumsrecordingsmap' VALUES (5836, 15, 422, 5423);
INSERT INTO 'albumsrecordingsmap' VALUES (5837, 16, 422, 5424);
INSERT INTO 'albumsrecordingsmap' VALUES (5838, 17, 422, 5425);
INSERT INTO 'albumsrecordingsmap' VALUES (5839, 18, 422, 5426);
INSERT INTO 'albumsrecordingsmap' VALUES (5840, 19, 422, 5427);
INSERT INTO 'albumsrecordingsmap' VALUES (5841, 20, 422, 5428);
INSERT INTO 'albumsrecordingsmap' VALUES (5842, 1, 423, 5429);
INSERT INTO 'albumsrecordingsmap' VALUES (5843, 2, 423, 5430);
INSERT INTO 'albumsrecordingsmap' VALUES (5844, 3, 423, 5431);
INSERT INTO 'albumsrecordingsmap' VALUES (5845, 4, 423, 5432);
INSERT INTO 'albumsrecordingsmap' VALUES (5846, 5, 423, 5433);
INSERT INTO 'albumsrecordingsmap' VALUES (5847, 6, 423, 5434);
INSERT INTO 'albumsrecordingsmap' VALUES (5848, 7, 423, 5435);
INSERT INTO 'albumsrecordingsmap' VALUES (5849, 8, 423, 5436);
INSERT INTO 'albumsrecordingsmap' VALUES (5850, 9, 423, 5437);
INSERT INTO 'albumsrecordingsmap' VALUES (5851, 10, 423, 5438);
INSERT INTO 'albumsrecordingsmap' VALUES (5852, 11, 423, 5439);
INSERT INTO 'albumsrecordingsmap' VALUES (5853, 12, 423, 5440);
INSERT INTO 'albumsrecordingsmap' VALUES (5854, 1, 424, 5441);
INSERT INTO 'albumsrecordingsmap' VALUES (5855, 3, 424, 5443);
INSERT INTO 'albumsrecordingsmap' VALUES (5856, 5, 424, 5445);
INSERT INTO 'albumsrecordingsmap' VALUES (5857, 6, 424, 5446);
INSERT INTO 'albumsrecordingsmap' VALUES (5858, 7, 424, 5447);
INSERT INTO 'albumsrecordingsmap' VALUES (5859, 8, 424, 5448);
INSERT INTO 'albumsrecordingsmap' VALUES (5860, 9, 424, 5449);
INSERT INTO 'albumsrecordingsmap' VALUES (5861, 10, 424, 5450);
INSERT INTO 'albumsrecordingsmap' VALUES (5862, 11, 424, 5451);
INSERT INTO 'albumsrecordingsmap' VALUES (5863, 12, 424, 5452);
INSERT INTO 'albumsrecordingsmap' VALUES (5864, 1, 425, 5453);
INSERT INTO 'albumsrecordingsmap' VALUES (5865, 2, 425, 5454);
INSERT INTO 'albumsrecordingsmap' VALUES (5866, 3, 425, 5455);
INSERT INTO 'albumsrecordingsmap' VALUES (5867, 4, 425, 5456);
INSERT INTO 'albumsrecordingsmap' VALUES (5868, 5, 425, 5457);
INSERT INTO 'albumsrecordingsmap' VALUES (5869, 6, 425, 5458);
INSERT INTO 'albumsrecordingsmap' VALUES (5870, 7, 425, 5459);
INSERT INTO 'albumsrecordingsmap' VALUES (5871, 8, 425, 5460);
INSERT INTO 'albumsrecordingsmap' VALUES (5872, 9, 425, 5461);
INSERT INTO 'albumsrecordingsmap' VALUES (5873, 10, 425, 5462);
INSERT INTO 'albumsrecordingsmap' VALUES (5874, 11, 425, 5463);
INSERT INTO 'albumsrecordingsmap' VALUES (5875, 12, 425, 5464);
INSERT INTO 'albumsrecordingsmap' VALUES (5876, 2, 424, 5442);
INSERT INTO 'albumsrecordingsmap' VALUES (5877, 4, 424, 5444);
INSERT INTO 'albumsrecordingsmap' VALUES (5878, 1, 426, 479);
INSERT INTO 'albumsrecordingsmap' VALUES (5879, 2, 426, 480);
INSERT INTO 'albumsrecordingsmap' VALUES (5880, 3, 426, 481);
INSERT INTO 'albumsrecordingsmap' VALUES (5881, 4, 426, 482);
INSERT INTO 'albumsrecordingsmap' VALUES (5882, 5, 426, 483);
INSERT INTO 'albumsrecordingsmap' VALUES (5883, 6, 426, 484);
INSERT INTO 'albumsrecordingsmap' VALUES (5884, 1, 427, 485);
INSERT INTO 'albumsrecordingsmap' VALUES (5885, 2, 427, 486);
INSERT INTO 'albumsrecordingsmap' VALUES (5886, 3, 427, 488);
INSERT INTO 'albumsrecordingsmap' VALUES (5887, 4, 427, 489);
INSERT INTO 'albumsrecordingsmap' VALUES (5888, 5, 427, 490);
INSERT INTO 'albumsrecordingsmap' VALUES (5889, 6, 427, 491);
INSERT INTO 'albumsrecordingsmap' VALUES (5890, 7, 427, 492);
INSERT INTO 'albumsrecordingsmap' VALUES (5891, 8, 427, 493);
INSERT INTO 'albumsrecordingsmap' VALUES (5892, 9, 427, 494);
INSERT INTO 'albumsrecordingsmap' VALUES (5893, 10, 427, 495);
INSERT INTO 'albumsrecordingsmap' VALUES (5894, 1, 428, 1714);
INSERT INTO 'albumsrecordingsmap' VALUES (5895, 2, 428, 2037);
INSERT INTO 'albumsrecordingsmap' VALUES (5896, 3, 428, 2908);
INSERT INTO 'albumsrecordingsmap' VALUES (5897, 4, 428, 3915);
INSERT INTO 'albumsrecordingsmap' VALUES (5898, 5, 428, 4124);
INSERT INTO 'albumsrecordingsmap' VALUES (5899, 6, 428, 5465);
INSERT INTO 'albumsrecordingsmap' VALUES (5900, 7, 428, 5466);
INSERT INTO 'albumsrecordingsmap' VALUES (5901, 8, 428, 5467);
INSERT INTO 'albumsrecordingsmap' VALUES (5902, 9, 428, 5468);
INSERT INTO 'albumsrecordingsmap' VALUES (5903, 10, 428, 5469);
INSERT INTO 'albumsrecordingsmap' VALUES (5904, 11, 428, 5470);
INSERT INTO 'albumsrecordingsmap' VALUES (5905, 12, 428, 5471);
INSERT INTO 'albumsrecordingsmap' VALUES (5906, 13, 428, 5472);
INSERT INTO 'albumsrecordingsmap' VALUES (5907, 14, 428, 5473);
INSERT INTO 'albumsrecordingsmap' VALUES (5908, 15, 428, 5474);
INSERT INTO 'albumsrecordingsmap' VALUES (5909, 1, 429, 5475);
INSERT INTO 'albumsrecordingsmap' VALUES (5910, 2, 429, 5476);
INSERT INTO 'albumsrecordingsmap' VALUES (5911, 3, 429, 5477);
INSERT INTO 'albumsrecordingsmap' VALUES (5912, 4, 429, 5478);
INSERT INTO 'albumsrecordingsmap' VALUES (5913, 5, 429, 5479);
INSERT INTO 'albumsrecordingsmap' VALUES (5914, 6, 429, 5480);
INSERT INTO 'albumsrecordingsmap' VALUES (5915, 7, 429, 5481);
INSERT INTO 'albumsrecordingsmap' VALUES (5916, 8, 429, 5482);
INSERT INTO 'albumsrecordingsmap' VALUES (5917, 9, 429, 5483);
INSERT INTO 'albumsrecordingsmap' VALUES (5918, 10, 429, 5484);
INSERT INTO 'albumsrecordingsmap' VALUES (5919, 11, 429, 5485);
INSERT INTO 'albumsrecordingsmap' VALUES (5920, 12, 429, 5486);
INSERT INTO 'albumsrecordingsmap' VALUES (5921, 13, 429, 5487);
INSERT INTO 'albumsrecordingsmap' VALUES (5922, 14, 429, 5488);
INSERT INTO 'albumsrecordingsmap' VALUES (5923, 15, 429, 5489);
INSERT INTO 'albumsrecordingsmap' VALUES (5924, 16, 429, 5490);
INSERT INTO 'albumsrecordingsmap' VALUES (5925, 6, 134, 164);
INSERT INTO 'albumsrecordingsmap' VALUES (5926, 1, 430, 5491);
INSERT INTO 'albumsrecordingsmap' VALUES (5927, 2, 430, 5492);
INSERT INTO 'albumsrecordingsmap' VALUES (5928, 3, 430, 5493);
INSERT INTO 'albumsrecordingsmap' VALUES (5929, 4, 430, 5494);
INSERT INTO 'albumsrecordingsmap' VALUES (5930, 5, 430, 5495);
INSERT INTO 'albumsrecordingsmap' VALUES (5931, 6, 430, 5496);
INSERT INTO 'albumsrecordingsmap' VALUES (5932, 7, 430, 5497);
INSERT INTO 'albumsrecordingsmap' VALUES (5933, 8, 430, 5498);
INSERT INTO 'albumsrecordingsmap' VALUES (5934, 9, 430, 5499);
INSERT INTO 'albumsrecordingsmap' VALUES (5935, 10, 430, 5500);
INSERT INTO 'albumsrecordingsmap' VALUES (5936, 11, 430, 5501);
INSERT INTO 'albumsrecordingsmap' VALUES (5937, 12, 430, 5502);
INSERT INTO 'albumsrecordingsmap' VALUES (5938, 13, 430, 5503);
INSERT INTO 'albumsrecordingsmap' VALUES (5939, 1, 431, 5504);
INSERT INTO 'albumsrecordingsmap' VALUES (5940, 2, 431, 5505);
INSERT INTO 'albumsrecordingsmap' VALUES (5941, 3, 431, 5506);
INSERT INTO 'albumsrecordingsmap' VALUES (5942, 4, 431, 5507);
INSERT INTO 'albumsrecordingsmap' VALUES (5943, 5, 431, 5508);
INSERT INTO 'albumsrecordingsmap' VALUES (5944, 6, 431, 5509);
INSERT INTO 'albumsrecordingsmap' VALUES (5945, 7, 431, 5510);
INSERT INTO 'albumsrecordingsmap' VALUES (5946, 8, 431, 5511);
INSERT INTO 'albumsrecordingsmap' VALUES (5947, 1, 432, 5512);
INSERT INTO 'albumsrecordingsmap' VALUES (5948, 2, 432, 5513);
INSERT INTO 'albumsrecordingsmap' VALUES (5949, 3, 432, 5514);
INSERT INTO 'albumsrecordingsmap' VALUES (5950, 4, 432, 5515);
INSERT INTO 'albumsrecordingsmap' VALUES (5951, 5, 432, 5516);
INSERT INTO 'albumsrecordingsmap' VALUES (5952, 6, 432, 5517);
INSERT INTO 'albumsrecordingsmap' VALUES (5953, 7, 432, 5518);
INSERT INTO 'albumsrecordingsmap' VALUES (5954, 8, 432, 5519);
INSERT INTO 'albumsrecordingsmap' VALUES (5965, 1, 434, 5530);
INSERT INTO 'albumsrecordingsmap' VALUES (5966, 2, 434, 5531);
INSERT INTO 'albumsrecordingsmap' VALUES (5967, 3, 434, 5532);
INSERT INTO 'albumsrecordingsmap' VALUES (5968, 4, 434, 5533);
INSERT INTO 'albumsrecordingsmap' VALUES (5969, 5, 434, 5534);
INSERT INTO 'albumsrecordingsmap' VALUES (5970, 6, 434, 5535);
INSERT INTO 'albumsrecordingsmap' VALUES (5971, 7, 434, 5536);
INSERT INTO 'albumsrecordingsmap' VALUES (5972, 8, 434, 5537);
INSERT INTO 'albumsrecordingsmap' VALUES (5973, 9, 434, 5538);
INSERT INTO 'albumsrecordingsmap' VALUES (5974, 10, 434, 5539);
INSERT INTO 'albumsrecordingsmap' VALUES (5975, 11, 434, 5540);
INSERT INTO 'albumsrecordingsmap' VALUES (5976, 12, 434, 5541);
INSERT INTO 'albumsrecordingsmap' VALUES (5977, 13, 434, 5542);
INSERT INTO 'albumsrecordingsmap' VALUES (5978, 14, 434, 5543);
INSERT INTO 'albumsrecordingsmap' VALUES (5979, 4, 124, 3845);
INSERT INTO 'albumsrecordingsmap' VALUES (5980, 1, 435, 3845);
INSERT INTO 'albumsrecordingsmap' VALUES (5981, 2, 435, 2961);
INSERT INTO 'albumsrecordingsmap' VALUES (5982, 3, 435, 4113);
INSERT INTO 'albumsrecordingsmap' VALUES (5983, 4, 435, 3849);
INSERT INTO 'albumsrecordingsmap' VALUES (5984, 5, 435, 5544);
INSERT INTO 'albumsrecordingsmap' VALUES (5985, 6, 435, 5545);
INSERT INTO 'albumsrecordingsmap' VALUES (5986, 7, 435, 5546);
INSERT INTO 'albumsrecordingsmap' VALUES (5987, 8, 435, 5547);
INSERT INTO 'albumsrecordingsmap' VALUES (5988, 9, 435, 5548);
INSERT INTO 'albumsrecordingsmap' VALUES (5989, 10, 435, 5549);
INSERT INTO 'albumsrecordingsmap' VALUES (5990, 11, 435, 5550);
INSERT INTO 'albumsrecordingsmap' VALUES (5991, 13, 435, 3850);
INSERT INTO 'albumsrecordingsmap' VALUES (5992, 14, 435, 5552);
INSERT INTO 'albumsrecordingsmap' VALUES (5993, 15, 435, 5553);
INSERT INTO 'albumsrecordingsmap' VALUES (5994, 12, 435, 5551);
INSERT INTO 'albumsrecordingsmap' VALUES (5995, 16, 435, 4117);
INSERT INTO 'albumsrecordingsmap' VALUES (5996, 17, 435, 4932);
INSERT INTO 'albumsrecordingsmap' VALUES (5997, 19, 435, 5555);
INSERT INTO 'albumsrecordingsmap' VALUES (5998, 20, 435, 5556);
INSERT INTO 'albumsrecordingsmap' VALUES (5999, 18, 435, 5554);
INSERT INTO 'albumsrecordingsmap' VALUES (6012, 1, 437, 168);
INSERT INTO 'albumsrecordingsmap' VALUES (6013, 2, 437, 145);
INSERT INTO 'albumsrecordingsmap' VALUES (6014, 3, 437, 190);
INSERT INTO 'albumsrecordingsmap' VALUES (6015, 4, 437, 173);
INSERT INTO 'albumsrecordingsmap' VALUES (6016, 5, 437, 338);
INSERT INTO 'albumsrecordingsmap' VALUES (6017, 6, 437, 357);
INSERT INTO 'albumsrecordingsmap' VALUES (6018, 7, 437, 51);
INSERT INTO 'albumsrecordingsmap' VALUES (6019, 8, 437, 75);
INSERT INTO 'albumsrecordingsmap' VALUES (6020, 9, 437, 246);
INSERT INTO 'albumsrecordingsmap' VALUES (6021, 10, 437, 65);
INSERT INTO 'albumsrecordingsmap' VALUES (6022, 12, 437, 102);
INSERT INTO 'albumsrecordingsmap' VALUES (6023, 11, 437, 329);
INSERT INTO 'albumsrecordingsmap' VALUES (2898, 4, 268, 2896);
INSERT INTO 'albumsrecordingsmap' VALUES (2899, 5, 268, 2897);
INSERT INTO 'albumsrecordingsmap' VALUES (2900, 6, 268, 2898);
INSERT INTO 'albumsrecordingsmap' VALUES (6066, 9, 308, 420);
INSERT INTO 'albumsrecordingsmap' VALUES (6067, 1, 442, 5609);
INSERT INTO 'albumsrecordingsmap' VALUES (6068, 2, 442, 5610);
INSERT INTO 'albumsrecordingsmap' VALUES (6069, 3, 442, 5611);
INSERT INTO 'albumsrecordingsmap' VALUES (6070, 4, 442, 5612);
INSERT INTO 'albumsrecordingsmap' VALUES (6071, 5, 442, 5613);
INSERT INTO 'albumsrecordingsmap' VALUES (6072, 6, 442, 5614);
INSERT INTO 'albumsrecordingsmap' VALUES (6073, 7, 442, 5615);
INSERT INTO 'albumsrecordingsmap' VALUES (6074, 8, 442, 5616);
INSERT INTO 'albumsrecordingsmap' VALUES (6075, 9, 442, 5617);
INSERT INTO 'albumsrecordingsmap' VALUES (6076, 10, 442, 5618);
INSERT INTO 'albumsrecordingsmap' VALUES (6077, 11, 442, 5619);
INSERT INTO 'albumsrecordingsmap' VALUES (6078, 12, 442, 5620);
INSERT INTO 'albumsrecordingsmap' VALUES (6079, 13, 442, 5621);
INSERT INTO 'albumsrecordingsmap' VALUES (6080, 14, 442, 5622);
INSERT INTO 'albumsrecordingsmap' VALUES (6081, 1, 441, 5623);
INSERT INTO 'albumsrecordingsmap' VALUES (6082, 2, 441, 5624);
INSERT INTO 'albumsrecordingsmap' VALUES (6083, 3, 441, 5625);
INSERT INTO 'albumsrecordingsmap' VALUES (6084, 4, 441, 5626);
INSERT INTO 'albumsrecordingsmap' VALUES (6085, 5, 441, 5627);
INSERT INTO 'albumsrecordingsmap' VALUES (6086, 6, 441, 5628);
INSERT INTO 'albumsrecordingsmap' VALUES (6087, 7, 441, 5629);
INSERT INTO 'albumsrecordingsmap' VALUES (6088, 8, 441, 5630);
INSERT INTO 'albumsrecordingsmap' VALUES (6089, 9, 441, 5631);
INSERT INTO 'albumsrecordingsmap' VALUES (6090, 10, 441, 5632);
INSERT INTO 'albumsrecordingsmap' VALUES (6091, 11, 441, 5633);
INSERT INTO 'albumsrecordingsmap' VALUES (6092, 12, 441, 5634);
INSERT INTO 'albumsrecordingsmap' VALUES (6093, 13, 441, 5635);
INSERT INTO 'albumsrecordingsmap' VALUES (6094, 14, 441, 5636);
INSERT INTO 'albumsrecordingsmap' VALUES (6095, 15, 441, 5637);
INSERT INTO 'albumsrecordingsmap' VALUES (6111, 1, 444, 5653);
INSERT INTO 'albumsrecordingsmap' VALUES (6112, 2, 444, 5654);
INSERT INTO 'albumsrecordingsmap' VALUES (6113, 3, 444, 5655);
INSERT INTO 'albumsrecordingsmap' VALUES (6114, 4, 444, 5656);
INSERT INTO 'albumsrecordingsmap' VALUES (6115, 5, 444, 5657);
INSERT INTO 'albumsrecordingsmap' VALUES (6116, 7, 444, 5658);
INSERT INTO 'albumsrecordingsmap' VALUES (6117, 6, 444, 5659);
INSERT INTO 'albumsrecordingsmap' VALUES (6118, 8, 444, 5660);
INSERT INTO 'albumsrecordingsmap' VALUES (6119, 9, 444, 5661);
INSERT INTO 'albumsrecordingsmap' VALUES (6120, 10, 444, 5662);
INSERT INTO 'albumsrecordingsmap' VALUES (6121, 11, 444, 5663);
INSERT INTO 'albumsrecordingsmap' VALUES (6122, 12, 444, 5664);
INSERT INTO 'albumsrecordingsmap' VALUES (6123, 13, 444, 5665);
INSERT INTO 'albumsrecordingsmap' VALUES (6124, 7, 64, 2045);
INSERT INTO 'albumsrecordingsmap' VALUES (6125, 4, 64, 2050);
INSERT INTO 'albumsrecordingsmap' VALUES (6126, 5, 64, 2048);
INSERT INTO 'albumsrecordingsmap' VALUES (6127, 9, 64, 2051);
INSERT INTO 'albumsrecordingsmap' VALUES (6128, 1, 445, 776);
INSERT INTO 'albumsrecordingsmap' VALUES (6129, 2, 445, 779);
INSERT INTO 'albumsrecordingsmap' VALUES (6130, 3, 445, 781);
INSERT INTO 'albumsrecordingsmap' VALUES (6131, 4, 445, 782);
INSERT INTO 'albumsrecordingsmap' VALUES (6132, 5, 445, 4505);
INSERT INTO 'albumsrecordingsmap' VALUES (6133, 6, 445, 5666);
INSERT INTO 'albumsrecordingsmap' VALUES (6134, 7, 445, 5667);
INSERT INTO 'albumsrecordingsmap' VALUES (6135, 8, 445, 5668);
INSERT INTO 'albumsrecordingsmap' VALUES (6136, 9, 445, 5669);
INSERT INTO 'albumsrecordingsmap' VALUES (6137, 10, 445, 5670);
INSERT INTO 'albumsrecordingsmap' VALUES (6138, 11, 445, 5671);
INSERT INTO 'albumsrecordingsmap' VALUES (6139, 12, 445, 5672);
INSERT INTO 'albumsrecordingsmap' VALUES (6140, 1, 446, 5673);
INSERT INTO 'albumsrecordingsmap' VALUES (6141, 2, 446, 5674);
INSERT INTO 'albumsrecordingsmap' VALUES (6142, 3, 446, 5675);
INSERT INTO 'albumsrecordingsmap' VALUES (6143, 4, 446, 5676);
INSERT INTO 'albumsrecordingsmap' VALUES (6144, 5, 446, 5677);
INSERT INTO 'albumsrecordingsmap' VALUES (6145, 6, 446, 5678);
INSERT INTO 'albumsrecordingsmap' VALUES (6146, 7, 446, 5679);
INSERT INTO 'albumsrecordingsmap' VALUES (6147, 8, 446, 5680);
INSERT INTO 'albumsrecordingsmap' VALUES (6148, 9, 446, 5681);
INSERT INTO 'albumsrecordingsmap' VALUES (6149, 10, 446, 5682);
INSERT INTO 'albumsrecordingsmap' VALUES (6150, 11, 446, 5683);
INSERT INTO 'albumsrecordingsmap' VALUES (6151, 12, 446, 5684);
INSERT INTO 'albumsrecordingsmap' VALUES (6152, 13, 446, 5685);
INSERT INTO 'albumsrecordingsmap' VALUES (6153, 14, 446, 5686);
INSERT INTO 'albumsrecordingsmap' VALUES (6155, 1, 447, 5687);
INSERT INTO 'albumsrecordingsmap' VALUES (6053, 1, 440, 5596);
INSERT INTO 'albumsrecordingsmap' VALUES (6054, 2, 440, 5597);
INSERT INTO 'albumsrecordingsmap' VALUES (6055, 3, 440, 5598);
INSERT INTO 'albumsrecordingsmap' VALUES (6056, 5, 440, 5599);
INSERT INTO 'albumsrecordingsmap' VALUES (6057, 6, 440, 5600);
INSERT INTO 'albumsrecordingsmap' VALUES (6058, 8, 440, 5601);
INSERT INTO 'albumsrecordingsmap' VALUES (6059, 7, 440, 5602);
INSERT INTO 'albumsrecordingsmap' VALUES (6060, 9, 440, 5603);
INSERT INTO 'albumsrecordingsmap' VALUES (6061, 10, 440, 5604);
INSERT INTO 'albumsrecordingsmap' VALUES (6062, 11, 440, 5605);
INSERT INTO 'albumsrecordingsmap' VALUES (6063, 12, 440, 5606);
INSERT INTO 'albumsrecordingsmap' VALUES (6064, 4, 440, 5607);
INSERT INTO 'albumsrecordingsmap' VALUES (6065, 13, 440, 5608);
INSERT INTO 'albumsrecordingsmap' VALUES (6156, 2, 447, 5688);
INSERT INTO 'albumsrecordingsmap' VALUES (6157, 3, 447, 5689);
INSERT INTO 'albumsrecordingsmap' VALUES (6158, 4, 447, 5690);
INSERT INTO 'albumsrecordingsmap' VALUES (6159, 5, 447, 5691);
INSERT INTO 'albumsrecordingsmap' VALUES (6000, 1, 436, 2424);
INSERT INTO 'albumsrecordingsmap' VALUES (6001, 2, 436, 4114);
INSERT INTO 'albumsrecordingsmap' VALUES (6002, 3, 436, 5557);
INSERT INTO 'albumsrecordingsmap' VALUES (6003, 4, 436, 5558);
INSERT INTO 'albumsrecordingsmap' VALUES (6004, 5, 436, 5559);
INSERT INTO 'albumsrecordingsmap' VALUES (6005, 6, 436, 5560);
INSERT INTO 'albumsrecordingsmap' VALUES (2895, 1, 268, 2893);
INSERT INTO 'albumsrecordingsmap' VALUES (2896, 2, 268, 2894);
INSERT INTO 'albumsrecordingsmap' VALUES (2897, 3, 268, 2895);
INSERT INTO 'albumsrecordingsmap' VALUES (2901, 7, 268, 2899);
INSERT INTO 'albumsrecordingsmap' VALUES (2902, 8, 268, 2900);
INSERT INTO 'albumsrecordingsmap' VALUES (2903, 9, 268, 2901);
INSERT INTO 'albumsrecordingsmap' VALUES (2904, 10, 268, 2902);
INSERT INTO 'albumsrecordingsmap' VALUES (2905, 11, 268, 2903);
INSERT INTO 'albumsrecordingsmap' VALUES (2906, 12, 268, 2904);
INSERT INTO 'albumsrecordingsmap' VALUES (6235, 1, 455, 5747);
INSERT INTO 'albumsrecordingsmap' VALUES (6170, 1, 448, 445);
INSERT INTO 'albumsrecordingsmap' VALUES (6171, 3, 448, 447);
INSERT INTO 'albumsrecordingsmap' VALUES (6172, 7, 448, 448);
INSERT INTO 'albumsrecordingsmap' VALUES (6173, 2, 448, 5702);
INSERT INTO 'albumsrecordingsmap' VALUES (6174, 4, 448, 5703);
INSERT INTO 'albumsrecordingsmap' VALUES (6175, 5, 448, 5704);
INSERT INTO 'albumsrecordingsmap' VALUES (6176, 6, 448, 5705);
INSERT INTO 'albumsrecordingsmap' VALUES (6177, 8, 448, 5706);
INSERT INTO 'albumsrecordingsmap' VALUES (6096, 1, 443, 5638);
INSERT INTO 'albumsrecordingsmap' VALUES (6097, 2, 443, 5639);
INSERT INTO 'albumsrecordingsmap' VALUES (6178, 1, 449, 5707);
INSERT INTO 'albumsrecordingsmap' VALUES (6179, 2, 449, 5708);
INSERT INTO 'albumsrecordingsmap' VALUES (6180, 3, 449, 5709);
INSERT INTO 'albumsrecordingsmap' VALUES (6181, 4, 449, 5710);
INSERT INTO 'albumsrecordingsmap' VALUES (6182, 5, 449, 5711);
INSERT INTO 'albumsrecordingsmap' VALUES (6183, 6, 449, 5712);
INSERT INTO 'albumsrecordingsmap' VALUES (6184, 7, 449, 5713);
INSERT INTO 'albumsrecordingsmap' VALUES (6185, 8, 449, 5714);
INSERT INTO 'albumsrecordingsmap' VALUES (6186, 9, 449, 5715);
INSERT INTO 'albumsrecordingsmap' VALUES (6187, 10, 449, 5716);
INSERT INTO 'albumsrecordingsmap' VALUES (6188, 11, 449, 5717);
INSERT INTO 'albumsrecordingsmap' VALUES (6189, 12, 449, 5718);
INSERT INTO 'albumsrecordingsmap' VALUES (6196, 1, 450, 5725);
INSERT INTO 'albumsrecordingsmap' VALUES (6197, 2, 450, 5726);
INSERT INTO 'albumsrecordingsmap' VALUES (6198, 3, 450, 5727);
INSERT INTO 'albumsrecordingsmap' VALUES (6199, 4, 450, 5728);
INSERT INTO 'albumsrecordingsmap' VALUES (6200, 5, 450, 5729);
INSERT INTO 'albumsrecordingsmap' VALUES (6201, 6, 450, 5730);
INSERT INTO 'albumsrecordingsmap' VALUES (6202, 7, 450, 5731);
INSERT INTO 'albumsrecordingsmap' VALUES (6203, 8, 450, 5732);
INSERT INTO 'albumsrecordingsmap' VALUES (6204, 9, 450, 5733);
INSERT INTO 'albumsrecordingsmap' VALUES (6205, 10, 450, 5734);
INSERT INTO 'albumsrecordingsmap' VALUES (6206, 11, 450, 5735);
INSERT INTO 'albumsrecordingsmap' VALUES (6207, 12, 450, 5736);
INSERT INTO 'albumsrecordingsmap' VALUES (6208, 1, 451, 585);
INSERT INTO 'albumsrecordingsmap' VALUES (6209, 2, 451, 706);
INSERT INTO 'albumsrecordingsmap' VALUES (6210, 3, 451, 631);
INSERT INTO 'albumsrecordingsmap' VALUES (6211, 4, 451, 703);
INSERT INTO 'albumsrecordingsmap' VALUES (6212, 5, 451, 704);
INSERT INTO 'albumsrecordingsmap' VALUES (6213, 6, 451, 633);
INSERT INTO 'albumsrecordingsmap' VALUES (6214, 7, 451, 707);
INSERT INTO 'albumsrecordingsmap' VALUES (6215, 8, 451, 586);
INSERT INTO 'albumsrecordingsmap' VALUES (6216, 9, 451, 705);
INSERT INTO 'albumsrecordingsmap' VALUES (6217, 10, 451, 588);
INSERT INTO 'albumsrecordingsmap' VALUES (6218, 1, 452, 5737);
INSERT INTO 'albumsrecordingsmap' VALUES (6219, 2, 452, 5738);
INSERT INTO 'albumsrecordingsmap' VALUES (6220, 3, 452, 5739);
INSERT INTO 'albumsrecordingsmap' VALUES (6221, 4, 452, 5740);
INSERT INTO 'albumsrecordingsmap' VALUES (6222, 5, 452, 5741);
INSERT INTO 'albumsrecordingsmap' VALUES (6223, 6, 452, 5742);
INSERT INTO 'albumsrecordingsmap' VALUES (6224, 7, 452, 5743);
INSERT INTO 'albumsrecordingsmap' VALUES (6225, 8, 452, 5744);
INSERT INTO 'albumsrecordingsmap' VALUES (6226, 9, 452, 5745);
INSERT INTO 'albumsrecordingsmap' VALUES (6227, 10, 452, 5746);
INSERT INTO 'albumsrecordingsmap' VALUES (6228, 11, 18, 711);
INSERT INTO 'albumsrecordingsmap' VALUES (6229, 13, 18, 710);
INSERT INTO 'albumsrecordingsmap' VALUES (6230, 14, 18, 708);
INSERT INTO 'albumsrecordingsmap' VALUES (6231, 4, 18, 806);
INSERT INTO 'albumsrecordingsmap' VALUES (6248, 1, 453, 5760);
INSERT INTO 'albumsrecordingsmap' VALUES (6249, 2, 453, 5761);
INSERT INTO 'albumsrecordingsmap' VALUES (6250, 3, 453, 5762);
INSERT INTO 'albumsrecordingsmap' VALUES (6251, 4, 453, 5763);
INSERT INTO 'albumsrecordingsmap' VALUES (6252, 5, 453, 5764);
INSERT INTO 'albumsrecordingsmap' VALUES (6253, 6, 453, 5765);
INSERT INTO 'albumsrecordingsmap' VALUES (6254, 7, 453, 5766);
INSERT INTO 'albumsrecordingsmap' VALUES (6255, 8, 453, 5767);
INSERT INTO 'albumsrecordingsmap' VALUES (6256, 9, 453, 5768);
INSERT INTO 'albumsrecordingsmap' VALUES (6257, 10, 453, 5769);
INSERT INTO 'albumsrecordingsmap' VALUES (6258, 11, 453, 5770);
INSERT INTO 'albumsrecordingsmap' VALUES (6259, 12, 453, 5771);
INSERT INTO 'albumsrecordingsmap' VALUES (6260, 13, 453, 5772);
INSERT INTO 'albumsrecordingsmap' VALUES (6261, 14, 453, 5773);
INSERT INTO 'albumsrecordingsmap' VALUES (6262, 15, 453, 5774);
INSERT INTO 'albumsrecordingsmap' VALUES (6263, 16, 453, 5775);
INSERT INTO 'albumsrecordingsmap' VALUES (6264, 17, 453, 5776);
INSERT INTO 'albumsrecordingsmap' VALUES (6265, 1, 456, 5777);
INSERT INTO 'albumsrecordingsmap' VALUES (6266, 2, 456, 5778);
INSERT INTO 'albumsrecordingsmap' VALUES (6267, 3, 456, 5779);
INSERT INTO 'albumsrecordingsmap' VALUES (6268, 4, 456, 5780);
INSERT INTO 'albumsrecordingsmap' VALUES (6269, 5, 456, 5781);
INSERT INTO 'albumsrecordingsmap' VALUES (6270, 6, 456, 5782);
INSERT INTO 'albumsrecordingsmap' VALUES (6271, 7, 456, 5783);
INSERT INTO 'albumsrecordingsmap' VALUES (6272, 8, 456, 5784);
INSERT INTO 'albumsrecordingsmap' VALUES (6273, 9, 456, 5785);
INSERT INTO 'albumsrecordingsmap' VALUES (6274, 10, 456, 5786);
INSERT INTO 'albumsrecordingsmap' VALUES (6275, 12, 456, 722);
INSERT INTO 'albumsrecordingsmap' VALUES (6276, 13, 456, 726);
INSERT INTO 'albumsrecordingsmap' VALUES (6277, 11, 456, 5787);
INSERT INTO 'albumsrecordingsmap' VALUES (6279, 14, 456, 5788);
INSERT INTO 'albumsrecordingsmap' VALUES (6280, 15, 456, 725);
INSERT INTO 'albumsrecordingsmap' VALUES (6281, 16, 456, 5789);
INSERT INTO 'albumsrecordingsmap' VALUES (6282, 17, 456, 724);
INSERT INTO 'albumsrecordingsmap' VALUES (6283, 18, 456, 723);
INSERT INTO 'albumsrecordingsmap' VALUES (6284, 19, 456, 52);
INSERT INTO 'albumsrecordingsmap' VALUES (6285, 1, 457, 5790);
INSERT INTO 'albumsrecordingsmap' VALUES (6286, 2, 457, 5791);
INSERT INTO 'albumsrecordingsmap' VALUES (6287, 3, 457, 5792);
INSERT INTO 'albumsrecordingsmap' VALUES (6288, 4, 457, 5793);
INSERT INTO 'albumsrecordingsmap' VALUES (6289, 5, 457, 5794);
INSERT INTO 'albumsrecordingsmap' VALUES (6290, 6, 457, 5795);
INSERT INTO 'albumsrecordingsmap' VALUES (6291, 7, 457, 5796);
INSERT INTO 'albumsrecordingsmap' VALUES (6292, 8, 457, 5797);
INSERT INTO 'albumsrecordingsmap' VALUES (6293, 9, 457, 5798);
INSERT INTO 'albumsrecordingsmap' VALUES (6294, 10, 457, 5799);
INSERT INTO 'albumsrecordingsmap' VALUES (6295, 11, 457, 5800);
INSERT INTO 'albumsrecordingsmap' VALUES (6296, 12, 457, 5801);
INSERT INTO 'albumsrecordingsmap' VALUES (6297, 1, 458, 5802);
INSERT INTO 'albumsrecordingsmap' VALUES (6298, 2, 458, 5803);
INSERT INTO 'albumsrecordingsmap' VALUES (6299, 3, 458, 5804);
INSERT INTO 'albumsrecordingsmap' VALUES (6300, 4, 458, 5805);
INSERT INTO 'albumsrecordingsmap' VALUES (6301, 5, 458, 5806);
INSERT INTO 'albumsrecordingsmap' VALUES (6302, 6, 458, 5807);
INSERT INTO 'albumsrecordingsmap' VALUES (6303, 7, 458, 5808);
INSERT INTO 'albumsrecordingsmap' VALUES (6304, 8, 458, 5809);
INSERT INTO 'albumsrecordingsmap' VALUES (6305, 9, 458, 5810);
INSERT INTO 'albumsrecordingsmap' VALUES (6306, 10, 458, 5811);
INSERT INTO 'albumsrecordingsmap' VALUES (6307, 11, 458, 5812);
INSERT INTO 'albumsrecordingsmap' VALUES (6308, 12, 458, 5813);
INSERT INTO 'albumsrecordingsmap' VALUES (6309, 13, 458, 5814);
INSERT INTO 'albumsrecordingsmap' VALUES (6310, 14, 458, 5815);
INSERT INTO 'albumsrecordingsmap' VALUES (6311, 15, 458, 5816);
INSERT INTO 'albumsrecordingsmap' VALUES (6312, 1, 459, 5817);
INSERT INTO 'albumsrecordingsmap' VALUES (6313, 2, 459, 5818);
INSERT INTO 'albumsrecordingsmap' VALUES (6314, 3, 459, 5819);
INSERT INTO 'albumsrecordingsmap' VALUES (6315, 4, 459, 5820);
INSERT INTO 'albumsrecordingsmap' VALUES (6316, 5, 459, 5821);
INSERT INTO 'albumsrecordingsmap' VALUES (6317, 6, 459, 5822);
INSERT INTO 'albumsrecordingsmap' VALUES (6318, 7, 459, 5823);
INSERT INTO 'albumsrecordingsmap' VALUES (6319, 8, 459, 5824);
INSERT INTO 'albumsrecordingsmap' VALUES (6320, 9, 459, 5825);
INSERT INTO 'albumsrecordingsmap' VALUES (6321, 10, 459, 5826);
INSERT INTO 'albumsrecordingsmap' VALUES (6322, 11, 459, 5827);
INSERT INTO 'albumsrecordingsmap' VALUES (6323, 12, 459, 5828);
INSERT INTO 'albumsrecordingsmap' VALUES (6324, 13, 459, 5829);
INSERT INTO 'albumsrecordingsmap' VALUES (6325, 1, 460, 5830);
INSERT INTO 'albumsrecordingsmap' VALUES (6326, 2, 460, 5831);
INSERT INTO 'albumsrecordingsmap' VALUES (6327, 3, 460, 5832);
INSERT INTO 'albumsrecordingsmap' VALUES (6328, 4, 460, 5833);
INSERT INTO 'albumsrecordingsmap' VALUES (6329, 5, 460, 5834);
INSERT INTO 'albumsrecordingsmap' VALUES (6330, 6, 460, 5835);
INSERT INTO 'albumsrecordingsmap' VALUES (6331, 7, 460, 5836);
INSERT INTO 'albumsrecordingsmap' VALUES (6332, 8, 460, 5837);
INSERT INTO 'albumsrecordingsmap' VALUES (6333, 9, 460, 5838);
INSERT INTO 'albumsrecordingsmap' VALUES (6334, 10, 460, 5839);
INSERT INTO 'albumsrecordingsmap' VALUES (6335, 11, 460, 5840);
INSERT INTO 'albumsrecordingsmap' VALUES (6336, 12, 460, 5841);
INSERT INTO 'albumsrecordingsmap' VALUES (6337, 13, 460, 5842);
INSERT INTO 'albumsrecordingsmap' VALUES (6338, 14, 460, 5843);
INSERT INTO 'albumsrecordingsmap' VALUES (6339, 15, 460, 5844);
INSERT INTO 'albumsrecordingsmap' VALUES (6340, 1, 461, 1363);
INSERT INTO 'albumsrecordingsmap' VALUES (6341, 2, 461, 1364);
INSERT INTO 'albumsrecordingsmap' VALUES (6342, 3, 461, 1365);
INSERT INTO 'albumsrecordingsmap' VALUES (6343, 4, 461, 1366);
INSERT INTO 'albumsrecordingsmap' VALUES (6344, 5, 461, 1367);
INSERT INTO 'albumsrecordingsmap' VALUES (6345, 6, 461, 1368);
INSERT INTO 'albumsrecordingsmap' VALUES (6346, 7, 461, 1369);
INSERT INTO 'albumsrecordingsmap' VALUES (6347, 8, 461, 1370);
INSERT INTO 'albumsrecordingsmap' VALUES (6348, 9, 461, 1371);
INSERT INTO 'albumsrecordingsmap' VALUES (6349, 10, 461, 1372);
INSERT INTO 'albumsrecordingsmap' VALUES (6350, 11, 461, 1373);
INSERT INTO 'albumsrecordingsmap' VALUES (6351, 12, 461, 1374);
INSERT INTO 'albumsrecordingsmap' VALUES (6352, 13, 461, 5845);
INSERT INTO 'albumsrecordingsmap' VALUES (6353, 14, 461, 5846);
INSERT INTO 'albumsrecordingsmap' VALUES (6354, 15, 461, 5847);
INSERT INTO 'albumsrecordingsmap' VALUES (6355, 16, 461, 5848);
INSERT INTO 'albumsrecordingsmap' VALUES (6356, 17, 461, 5849);
INSERT INTO 'albumsrecordingsmap' VALUES (6357, 18, 461, 5850);
INSERT INTO 'albumsrecordingsmap' VALUES (6358, 19, 461, 5851);
INSERT INTO 'albumsrecordingsmap' VALUES (6359, 20, 461, 5852);
INSERT INTO 'albumsrecordingsmap' VALUES (6360, 21, 461, 5853);
INSERT INTO 'albumsrecordingsmap' VALUES (6361, 22, 461, 5854);
INSERT INTO 'albumsrecordingsmap' VALUES (6362, 23, 461, 5855);
INSERT INTO 'albumsrecordingsmap' VALUES (6363, 24, 461, 5856);
INSERT INTO 'albumsrecordingsmap' VALUES (6366, 2, 292, 4610);
INSERT INTO 'albumsrecordingsmap' VALUES (9960, 1, 1056, 9387);
INSERT INTO 'albumsrecordingsmap' VALUES (10803, 7, 1112, 10209);
INSERT INTO 'albumsrecordingsmap' VALUES (10804, 8, 1112, 10210);
INSERT INTO 'albumsrecordingsmap' VALUES (10805, 9, 1112, 10211);
INSERT INTO 'albumsrecordingsmap' VALUES (6382, 1, 463, 5872);
INSERT INTO 'albumsrecordingsmap' VALUES (6383, 2, 463, 5873);
INSERT INTO 'albumsrecordingsmap' VALUES (6384, 3, 463, 5874);
INSERT INTO 'albumsrecordingsmap' VALUES (6385, 4, 463, 5875);
INSERT INTO 'albumsrecordingsmap' VALUES (6386, 5, 463, 5876);
INSERT INTO 'albumsrecordingsmap' VALUES (6387, 6, 463, 5877);
INSERT INTO 'albumsrecordingsmap' VALUES (6388, 7, 463, 5878);
INSERT INTO 'albumsrecordingsmap' VALUES (6389, 8, 463, 5879);
INSERT INTO 'albumsrecordingsmap' VALUES (6390, 9, 463, 5880);
INSERT INTO 'albumsrecordingsmap' VALUES (6391, 10, 463, 5881);
INSERT INTO 'albumsrecordingsmap' VALUES (6392, 11, 463, 5882);
INSERT INTO 'albumsrecordingsmap' VALUES (1654, 1, 177, 1612);
INSERT INTO 'albumsrecordingsmap' VALUES (1655, 2, 177, 1613);
INSERT INTO 'albumsrecordingsmap' VALUES (1656, 3, 177, 1614);
INSERT INTO 'albumsrecordingsmap' VALUES (10852, 12, 1116, 10258);
INSERT INTO 'albumsrecordingsmap' VALUES (10853, 13, 1116, 10259);
INSERT INTO 'albumsrecordingsmap' VALUES (10854, 14, 1116, 10260);
INSERT INTO 'albumsrecordingsmap' VALUES (10855, 15, 1116, 10261);
INSERT INTO 'albumsrecordingsmap' VALUES (6195, 18, 449, 5724);
INSERT INTO 'albumsrecordingsmap' VALUES (6278, 2, 57, 5787);
INSERT INTO 'albumsrecordingsmap' VALUES (6393, 12, 463, 5883);
INSERT INTO 'albumsrecordingsmap' VALUES (6394, 13, 463, 5884);
INSERT INTO 'albumsrecordingsmap' VALUES (6395, 14, 463, 5885);
INSERT INTO 'albumsrecordingsmap' VALUES (6396, 15, 463, 5886);
INSERT INTO 'albumsrecordingsmap' VALUES (6397, 16, 463, 5887);
INSERT INTO 'albumsrecordingsmap' VALUES (6398, 17, 463, 5888);
INSERT INTO 'albumsrecordingsmap' VALUES (6399, 1, 465, 5889);
INSERT INTO 'albumsrecordingsmap' VALUES (6400, 2, 465, 5890);
INSERT INTO 'albumsrecordingsmap' VALUES (6401, 3, 465, 5891);
INSERT INTO 'albumsrecordingsmap' VALUES (6402, 4, 465, 5892);
INSERT INTO 'albumsrecordingsmap' VALUES (6403, 5, 465, 5893);
INSERT INTO 'albumsrecordingsmap' VALUES (6404, 6, 465, 5894);
INSERT INTO 'albumsrecordingsmap' VALUES (6405, 7, 465, 5895);
INSERT INTO 'albumsrecordingsmap' VALUES (6406, 8, 465, 5896);
INSERT INTO 'albumsrecordingsmap' VALUES (6407, 9, 465, 5897);
INSERT INTO 'albumsrecordingsmap' VALUES (6408, 10, 465, 5898);
INSERT INTO 'albumsrecordingsmap' VALUES (6409, 11, 465, 5899);
INSERT INTO 'albumsrecordingsmap' VALUES (6410, 12, 465, 5900);
INSERT INTO 'albumsrecordingsmap' VALUES (6411, 13, 465, 5901);
INSERT INTO 'albumsrecordingsmap' VALUES (6412, 14, 465, 5902);
INSERT INTO 'albumsrecordingsmap' VALUES (6413, 15, 465, 5903);
INSERT INTO 'albumsrecordingsmap' VALUES (6414, 16, 465, 5904);
INSERT INTO 'albumsrecordingsmap' VALUES (6415, 1, 466, 5905);
INSERT INTO 'albumsrecordingsmap' VALUES (6416, 2, 466, 5906);
INSERT INTO 'albumsrecordingsmap' VALUES (6417, 3, 466, 5907);
INSERT INTO 'albumsrecordingsmap' VALUES (6418, 4, 466, 5908);
INSERT INTO 'albumsrecordingsmap' VALUES (6419, 5, 466, 5909);
INSERT INTO 'albumsrecordingsmap' VALUES (6420, 6, 466, 5910);
INSERT INTO 'albumsrecordingsmap' VALUES (6421, 7, 466, 5911);
INSERT INTO 'albumsrecordingsmap' VALUES (6422, 8, 466, 5912);
INSERT INTO 'albumsrecordingsmap' VALUES (6423, 9, 466, 5913);
INSERT INTO 'albumsrecordingsmap' VALUES (6424, 10, 466, 5914);
INSERT INTO 'albumsrecordingsmap' VALUES (6425, 11, 466, 5915);
INSERT INTO 'albumsrecordingsmap' VALUES (6426, 12, 466, 5916);
INSERT INTO 'albumsrecordingsmap' VALUES (6427, 13, 466, 5917);
INSERT INTO 'albumsrecordingsmap' VALUES (6428, 1, 467, 5918);
INSERT INTO 'albumsrecordingsmap' VALUES (6429, 2, 467, 5919);
INSERT INTO 'albumsrecordingsmap' VALUES (6430, 3, 467, 5920);
INSERT INTO 'albumsrecordingsmap' VALUES (6431, 4, 467, 5921);
INSERT INTO 'albumsrecordingsmap' VALUES (6432, 5, 467, 5922);
INSERT INTO 'albumsrecordingsmap' VALUES (6433, 6, 467, 5923);
INSERT INTO 'albumsrecordingsmap' VALUES (6434, 7, 467, 5924);
INSERT INTO 'albumsrecordingsmap' VALUES (6435, 8, 467, 5925);
INSERT INTO 'albumsrecordingsmap' VALUES (6436, 9, 467, 5926);
INSERT INTO 'albumsrecordingsmap' VALUES (6437, 10, 467, 5927);
INSERT INTO 'albumsrecordingsmap' VALUES (6438, 11, 467, 5928);
INSERT INTO 'albumsrecordingsmap' VALUES (6439, 12, 467, 5929);
INSERT INTO 'albumsrecordingsmap' VALUES (6440, 13, 467, 5930);
INSERT INTO 'albumsrecordingsmap' VALUES (6441, 14, 467, 5931);
INSERT INTO 'albumsrecordingsmap' VALUES (6442, 15, 467, 5932);
INSERT INTO 'albumsrecordingsmap' VALUES (6443, 16, 467, 5933);
INSERT INTO 'albumsrecordingsmap' VALUES (6444, 17, 467, 5934);
INSERT INTO 'albumsrecordingsmap' VALUES (6445, 1, 468, 5935);
INSERT INTO 'albumsrecordingsmap' VALUES (6446, 2, 468, 5936);
INSERT INTO 'albumsrecordingsmap' VALUES (6447, 3, 468, 5937);
INSERT INTO 'albumsrecordingsmap' VALUES (6448, 4, 468, 5938);
INSERT INTO 'albumsrecordingsmap' VALUES (6449, 5, 468, 5939);
INSERT INTO 'albumsrecordingsmap' VALUES (6450, 6, 468, 5940);
INSERT INTO 'albumsrecordingsmap' VALUES (6451, 7, 468, 5941);
INSERT INTO 'albumsrecordingsmap' VALUES (6452, 8, 468, 5942);
INSERT INTO 'albumsrecordingsmap' VALUES (6453, 9, 468, 5943);
INSERT INTO 'albumsrecordingsmap' VALUES (6454, 10, 468, 5944);
INSERT INTO 'albumsrecordingsmap' VALUES (6455, 11, 468, 5945);
INSERT INTO 'albumsrecordingsmap' VALUES (6456, 12, 468, 5946);
INSERT INTO 'albumsrecordingsmap' VALUES (6457, 13, 468, 5947);
INSERT INTO 'albumsrecordingsmap' VALUES (6458, 14, 468, 5948);
INSERT INTO 'albumsrecordingsmap' VALUES (6459, 1, 469, 142);
INSERT INTO 'albumsrecordingsmap' VALUES (6460, 2, 469, 243);
INSERT INTO 'albumsrecordingsmap' VALUES (6461, 3, 469, 3115);
INSERT INTO 'albumsrecordingsmap' VALUES (6462, 4, 469, 4272);
INSERT INTO 'albumsrecordingsmap' VALUES (6463, 5, 469, 5949);
INSERT INTO 'albumsrecordingsmap' VALUES (6464, 6, 469, 5950);
INSERT INTO 'albumsrecordingsmap' VALUES (6465, 7, 469, 5951);
INSERT INTO 'albumsrecordingsmap' VALUES (6466, 8, 469, 5952);
INSERT INTO 'albumsrecordingsmap' VALUES (6467, 9, 469, 5953);
INSERT INTO 'albumsrecordingsmap' VALUES (6468, 10, 469, 5954);
INSERT INTO 'albumsrecordingsmap' VALUES (6469, 11, 469, 5955);
INSERT INTO 'albumsrecordingsmap' VALUES (6470, 12, 469, 5956);
INSERT INTO 'albumsrecordingsmap' VALUES (6471, 13, 469, 5957);
INSERT INTO 'albumsrecordingsmap' VALUES (6472, 14, 469, 5958);
INSERT INTO 'albumsrecordingsmap' VALUES (6473, 15, 469, 5959);
INSERT INTO 'albumsrecordingsmap' VALUES (6474, 1, 470, 5960);
INSERT INTO 'albumsrecordingsmap' VALUES (6475, 2, 470, 5961);
INSERT INTO 'albumsrecordingsmap' VALUES (6476, 3, 470, 5962);
INSERT INTO 'albumsrecordingsmap' VALUES (6477, 4, 470, 5963);
INSERT INTO 'albumsrecordingsmap' VALUES (6478, 1, 471, 5964);
INSERT INTO 'albumsrecordingsmap' VALUES (6479, 2, 471, 5965);
INSERT INTO 'albumsrecordingsmap' VALUES (6480, 3, 471, 5966);
INSERT INTO 'albumsrecordingsmap' VALUES (6481, 4, 471, 5967);
INSERT INTO 'albumsrecordingsmap' VALUES (6482, 1, 472, 5968);
INSERT INTO 'albumsrecordingsmap' VALUES (6483, 2, 472, 5969);
INSERT INTO 'albumsrecordingsmap' VALUES (6484, 3, 472, 5970);
INSERT INTO 'albumsrecordingsmap' VALUES (6485, 4, 472, 5971);
INSERT INTO 'albumsrecordingsmap' VALUES (6486, 5, 472, 5972);
INSERT INTO 'albumsrecordingsmap' VALUES (6487, 6, 472, 5973);
INSERT INTO 'albumsrecordingsmap' VALUES (6488, 7, 472, 5974);
INSERT INTO 'albumsrecordingsmap' VALUES (6489, 8, 472, 5975);
INSERT INTO 'albumsrecordingsmap' VALUES (6490, 9, 472, 5976);
INSERT INTO 'albumsrecordingsmap' VALUES (6491, 10, 472, 5977);
INSERT INTO 'albumsrecordingsmap' VALUES (6492, 11, 472, 5978);
INSERT INTO 'albumsrecordingsmap' VALUES (6493, 12, 472, 5979);
INSERT INTO 'albumsrecordingsmap' VALUES (6494, 13, 472, 5980);
INSERT INTO 'albumsrecordingsmap' VALUES (6495, 14, 472, 5981);
INSERT INTO 'albumsrecordingsmap' VALUES (6496, 15, 472, 5982);
INSERT INTO 'albumsrecordingsmap' VALUES (6497, 16, 472, 5983);
INSERT INTO 'albumsrecordingsmap' VALUES (6498, 1, 473, 5984);
INSERT INTO 'albumsrecordingsmap' VALUES (6499, 2, 473, 5985);
INSERT INTO 'albumsrecordingsmap' VALUES (6500, 3, 473, 5986);
INSERT INTO 'albumsrecordingsmap' VALUES (6501, 4, 473, 5987);
INSERT INTO 'albumsrecordingsmap' VALUES (6502, 5, 473, 5988);
INSERT INTO 'albumsrecordingsmap' VALUES (6503, 6, 473, 5989);
INSERT INTO 'albumsrecordingsmap' VALUES (6504, 7, 473, 5990);
INSERT INTO 'albumsrecordingsmap' VALUES (6505, 8, 473, 5991);
INSERT INTO 'albumsrecordingsmap' VALUES (6506, 9, 473, 5992);
INSERT INTO 'albumsrecordingsmap' VALUES (6507, 10, 473, 5993);
INSERT INTO 'albumsrecordingsmap' VALUES (6508, 11, 473, 5994);
INSERT INTO 'albumsrecordingsmap' VALUES (6509, 12, 473, 5995);
INSERT INTO 'albumsrecordingsmap' VALUES (6510, 13, 473, 5996);
INSERT INTO 'albumsrecordingsmap' VALUES (6511, 14, 473, 5997);
INSERT INTO 'albumsrecordingsmap' VALUES (6512, 1, 474, 5998);
INSERT INTO 'albumsrecordingsmap' VALUES (6513, 2, 474, 5999);
INSERT INTO 'albumsrecordingsmap' VALUES (6514, 3, 474, 6000);
INSERT INTO 'albumsrecordingsmap' VALUES (6515, 4, 474, 6001);
INSERT INTO 'albumsrecordingsmap' VALUES (6516, 5, 474, 6002);
INSERT INTO 'albumsrecordingsmap' VALUES (6517, 6, 474, 6003);
INSERT INTO 'albumsrecordingsmap' VALUES (6518, 7, 474, 6004);
INSERT INTO 'albumsrecordingsmap' VALUES (6519, 8, 474, 6005);
INSERT INTO 'albumsrecordingsmap' VALUES (6520, 9, 474, 6006);
INSERT INTO 'albumsrecordingsmap' VALUES (6521, 10, 474, 6007);
INSERT INTO 'albumsrecordingsmap' VALUES (6522, 1, 475, 6008);
INSERT INTO 'albumsrecordingsmap' VALUES (6523, 2, 475, 6009);
INSERT INTO 'albumsrecordingsmap' VALUES (6524, 3, 475, 6010);
INSERT INTO 'albumsrecordingsmap' VALUES (6525, 4, 475, 6011);
INSERT INTO 'albumsrecordingsmap' VALUES (6526, 5, 475, 6012);
INSERT INTO 'albumsrecordingsmap' VALUES (6527, 1, 476, 524);
INSERT INTO 'albumsrecordingsmap' VALUES (6528, 2, 476, 525);
INSERT INTO 'albumsrecordingsmap' VALUES (6529, 3, 476, 526);
INSERT INTO 'albumsrecordingsmap' VALUES (10806, 10, 1112, 10212);
INSERT INTO 'albumsrecordingsmap' VALUES (6367, 1, 462, 5857);
INSERT INTO 'albumsrecordingsmap' VALUES (10807, 11, 1112, 10213);
INSERT INTO 'albumsrecordingsmap' VALUES (10808, 12, 1112, 10214);
INSERT INTO 'albumsrecordingsmap' VALUES (9961, 2, 1056, 9388);
INSERT INTO 'albumsrecordingsmap' VALUES (9962, 3, 1056, 9389);
INSERT INTO 'albumsrecordingsmap' VALUES (6530, 4, 476, 527);
INSERT INTO 'albumsrecordingsmap' VALUES (6531, 5, 476, 528);
INSERT INTO 'albumsrecordingsmap' VALUES (6532, 6, 476, 529);
INSERT INTO 'albumsrecordingsmap' VALUES (6533, 7, 476, 126);
INSERT INTO 'albumsrecordingsmap' VALUES (6534, 9, 476, 93);
INSERT INTO 'albumsrecordingsmap' VALUES (6535, 8, 476, 531);
INSERT INTO 'albumsrecordingsmap' VALUES (6553, 1, 478, 6013);
INSERT INTO 'albumsrecordingsmap' VALUES (6554, 2, 478, 6014);
INSERT INTO 'albumsrecordingsmap' VALUES (6555, 3, 478, 6015);
INSERT INTO 'albumsrecordingsmap' VALUES (6560, 9, 737, 6017);
INSERT INTO 'albumsrecordingsmap' VALUES (6564, 1, 479, 6020);
INSERT INTO 'albumsrecordingsmap' VALUES (6565, 2, 479, 6021);
INSERT INTO 'albumsrecordingsmap' VALUES (6566, 3, 479, 6022);
INSERT INTO 'albumsrecordingsmap' VALUES (6567, 4, 479, 6023);
INSERT INTO 'albumsrecordingsmap' VALUES (6568, 5, 479, 6024);
INSERT INTO 'albumsrecordingsmap' VALUES (6569, 6, 479, 6025);
INSERT INTO 'albumsrecordingsmap' VALUES (6570, 7, 479, 6026);
INSERT INTO 'albumsrecordingsmap' VALUES (6571, 8, 479, 6027);
INSERT INTO 'albumsrecordingsmap' VALUES (6572, 9, 479, 6028);
INSERT INTO 'albumsrecordingsmap' VALUES (6573, 10, 479, 6029);
INSERT INTO 'albumsrecordingsmap' VALUES (6574, 11, 479, 6030);
INSERT INTO 'albumsrecordingsmap' VALUES (6575, 12, 479, 6031);
INSERT INTO 'albumsrecordingsmap' VALUES (6576, 13, 479, 6032);
INSERT INTO 'albumsrecordingsmap' VALUES (6577, 14, 479, 6033);
INSERT INTO 'albumsrecordingsmap' VALUES (6578, 15, 479, 6034);
INSERT INTO 'albumsrecordingsmap' VALUES (6579, 16, 479, 6035);
INSERT INTO 'albumsrecordingsmap' VALUES (6580, 17, 479, 6036);
INSERT INTO 'albumsrecordingsmap' VALUES (6581, 18, 479, 6037);
INSERT INTO 'albumsrecordingsmap' VALUES (6582, 1, 480, 4429);
INSERT INTO 'albumsrecordingsmap' VALUES (6583, 2, 480, 6019);
INSERT INTO 'albumsrecordingsmap' VALUES (6584, 3, 480, 6038);
INSERT INTO 'albumsrecordingsmap' VALUES (6585, 4, 480, 6039);
INSERT INTO 'albumsrecordingsmap' VALUES (6586, 5, 480, 6040);
INSERT INTO 'albumsrecordingsmap' VALUES (6587, 6, 480, 6041);
INSERT INTO 'albumsrecordingsmap' VALUES (6588, 7, 480, 6042);
INSERT INTO 'albumsrecordingsmap' VALUES (6589, 8, 480, 6043);
INSERT INTO 'albumsrecordingsmap' VALUES (6590, 9, 480, 6044);
INSERT INTO 'albumsrecordingsmap' VALUES (6591, 10, 480, 6045);
INSERT INTO 'albumsrecordingsmap' VALUES (6592, 11, 480, 6046);
INSERT INTO 'albumsrecordingsmap' VALUES (6593, 12, 480, 6047);
INSERT INTO 'albumsrecordingsmap' VALUES (6594, 13, 480, 6048);
INSERT INTO 'albumsrecordingsmap' VALUES (6595, 1, 481, 149);
INSERT INTO 'albumsrecordingsmap' VALUES (6596, 2, 481, 912);
INSERT INTO 'albumsrecordingsmap' VALUES (6597, 3, 481, 106);
INSERT INTO 'albumsrecordingsmap' VALUES (6598, 4, 481, 910);
INSERT INTO 'albumsrecordingsmap' VALUES (6599, 5, 481, 6049);
INSERT INTO 'albumsrecordingsmap' VALUES (6600, 6, 481, 906);
INSERT INTO 'albumsrecordingsmap' VALUES (6601, 7, 481, 908);
INSERT INTO 'albumsrecordingsmap' VALUES (6602, 8, 481, 909);
INSERT INTO 'albumsrecordingsmap' VALUES (6603, 9, 481, 6050);
INSERT INTO 'albumsrecordingsmap' VALUES (6604, 10, 481, 6051);
INSERT INTO 'albumsrecordingsmap' VALUES (6605, 11, 481, 904);
INSERT INTO 'albumsrecordingsmap' VALUES (6606, 12, 481, 3533);
INSERT INTO 'albumsrecordingsmap' VALUES (6607, 1, 482, 927);
INSERT INTO 'albumsrecordingsmap' VALUES (6608, 2, 482, 200);
INSERT INTO 'albumsrecordingsmap' VALUES (6609, 3, 482, 929);
INSERT INTO 'albumsrecordingsmap' VALUES (6610, 4, 482, 930);
INSERT INTO 'albumsrecordingsmap' VALUES (6611, 5, 482, 167);
INSERT INTO 'albumsrecordingsmap' VALUES (6612, 6, 482, 6052);
INSERT INTO 'albumsrecordingsmap' VALUES (6613, 7, 482, 928);
INSERT INTO 'albumsrecordingsmap' VALUES (6614, 8, 482, 350);
INSERT INTO 'albumsrecordingsmap' VALUES (6615, 9, 482, 931);
INSERT INTO 'albumsrecordingsmap' VALUES (6616, 10, 482, 117);
INSERT INTO 'albumsrecordingsmap' VALUES (6617, 11, 482, 933);
INSERT INTO 'albumsrecordingsmap' VALUES (6618, 12, 482, 795);
INSERT INTO 'albumsrecordingsmap' VALUES (6619, 1, 483, 6053);
INSERT INTO 'albumsrecordingsmap' VALUES (6620, 2, 483, 6054);
INSERT INTO 'albumsrecordingsmap' VALUES (6621, 3, 483, 6055);
INSERT INTO 'albumsrecordingsmap' VALUES (6622, 4, 483, 6056);
INSERT INTO 'albumsrecordingsmap' VALUES (6623, 5, 483, 6057);
INSERT INTO 'albumsrecordingsmap' VALUES (6624, 6, 483, 6058);
INSERT INTO 'albumsrecordingsmap' VALUES (6625, 7, 483, 6059);
INSERT INTO 'albumsrecordingsmap' VALUES (6626, 8, 483, 6060);
INSERT INTO 'albumsrecordingsmap' VALUES (6627, 9, 483, 6061);
INSERT INTO 'albumsrecordingsmap' VALUES (6628, 10, 483, 6062);
INSERT INTO 'albumsrecordingsmap' VALUES (6629, 11, 483, 6063);
INSERT INTO 'albumsrecordingsmap' VALUES (6630, 12, 483, 6064);
INSERT INTO 'albumsrecordingsmap' VALUES (6631, 13, 483, 6065);
INSERT INTO 'albumsrecordingsmap' VALUES (6632, 14, 483, 6066);
INSERT INTO 'albumsrecordingsmap' VALUES (6633, 15, 483, 6067);
INSERT INTO 'albumsrecordingsmap' VALUES (6634, 16, 483, 6068);
INSERT INTO 'albumsrecordingsmap' VALUES (6635, 1, 485, 6069);
INSERT INTO 'albumsrecordingsmap' VALUES (6636, 2, 485, 6070);
INSERT INTO 'albumsrecordingsmap' VALUES (6637, 3, 485, 6071);
INSERT INTO 'albumsrecordingsmap' VALUES (6638, 4, 485, 6072);
INSERT INTO 'albumsrecordingsmap' VALUES (6639, 5, 485, 6073);
INSERT INTO 'albumsrecordingsmap' VALUES (6640, 6, 485, 6074);
INSERT INTO 'albumsrecordingsmap' VALUES (6641, 7, 485, 6075);
INSERT INTO 'albumsrecordingsmap' VALUES (6642, 8, 485, 6076);
INSERT INTO 'albumsrecordingsmap' VALUES (6643, 9, 485, 6077);
INSERT INTO 'albumsrecordingsmap' VALUES (6644, 10, 485, 6078);
INSERT INTO 'albumsrecordingsmap' VALUES (6645, 11, 485, 6079);
INSERT INTO 'albumsrecordingsmap' VALUES (6646, 12, 485, 6080);
INSERT INTO 'albumsrecordingsmap' VALUES (6647, 13, 485, 6081);
INSERT INTO 'albumsrecordingsmap' VALUES (6648, 14, 485, 6082);
INSERT INTO 'albumsrecordingsmap' VALUES (6649, 15, 485, 6083);
INSERT INTO 'albumsrecordingsmap' VALUES (6650, 1, 487, 6084);
INSERT INTO 'albumsrecordingsmap' VALUES (6651, 2, 487, 6085);
INSERT INTO 'albumsrecordingsmap' VALUES (6652, 3, 487, 6086);
INSERT INTO 'albumsrecordingsmap' VALUES (6653, 4, 487, 6087);
INSERT INTO 'albumsrecordingsmap' VALUES (6654, 5, 487, 6088);
INSERT INTO 'albumsrecordingsmap' VALUES (6655, 6, 487, 6089);
INSERT INTO 'albumsrecordingsmap' VALUES (6656, 7, 487, 6090);
INSERT INTO 'albumsrecordingsmap' VALUES (6657, 8, 487, 6091);
INSERT INTO 'albumsrecordingsmap' VALUES (6658, 9, 487, 6092);
INSERT INTO 'albumsrecordingsmap' VALUES (6659, 10, 487, 6093);
INSERT INTO 'albumsrecordingsmap' VALUES (6660, 11, 487, 6094);
INSERT INTO 'albumsrecordingsmap' VALUES (6661, 12, 487, 6095);
INSERT INTO 'albumsrecordingsmap' VALUES (6662, 13, 487, 6096);
INSERT INTO 'albumsrecordingsmap' VALUES (6663, 14, 487, 6097);
INSERT INTO 'albumsrecordingsmap' VALUES (6664, 1, 488, 6098);
INSERT INTO 'albumsrecordingsmap' VALUES (6665, 2, 488, 6099);
INSERT INTO 'albumsrecordingsmap' VALUES (6666, 3, 488, 6100);
INSERT INTO 'albumsrecordingsmap' VALUES (6667, 4, 488, 6101);
INSERT INTO 'albumsrecordingsmap' VALUES (6668, 5, 488, 6102);
INSERT INTO 'albumsrecordingsmap' VALUES (6669, 6, 488, 6103);
INSERT INTO 'albumsrecordingsmap' VALUES (6670, 7, 488, 6104);
INSERT INTO 'albumsrecordingsmap' VALUES (6671, 9, 488, 6105);
INSERT INTO 'albumsrecordingsmap' VALUES (6672, 10, 488, 6106);
INSERT INTO 'albumsrecordingsmap' VALUES (6673, 11, 488, 6107);
INSERT INTO 'albumsrecordingsmap' VALUES (6674, 12, 488, 6108);
INSERT INTO 'albumsrecordingsmap' VALUES (6675, 13, 488, 6109);
INSERT INTO 'albumsrecordingsmap' VALUES (6676, 14, 488, 6110);
INSERT INTO 'albumsrecordingsmap' VALUES (6677, 15, 488, 6111);
INSERT INTO 'albumsrecordingsmap' VALUES (6678, 8, 488, 6112);
INSERT INTO 'albumsrecordingsmap' VALUES (6679, 1, 486, 6113);
INSERT INTO 'albumsrecordingsmap' VALUES (6680, 2, 486, 6114);
INSERT INTO 'albumsrecordingsmap' VALUES (6681, 3, 486, 6115);
INSERT INTO 'albumsrecordingsmap' VALUES (6682, 4, 486, 6116);
INSERT INTO 'albumsrecordingsmap' VALUES (6683, 5, 486, 6117);
INSERT INTO 'albumsrecordingsmap' VALUES (6684, 6, 486, 6118);
INSERT INTO 'albumsrecordingsmap' VALUES (6685, 7, 486, 6119);
INSERT INTO 'albumsrecordingsmap' VALUES (6686, 8, 486, 6120);
INSERT INTO 'albumsrecordingsmap' VALUES (6687, 9, 486, 6121);
INSERT INTO 'albumsrecordingsmap' VALUES (6688, 10, 486, 6122);
INSERT INTO 'albumsrecordingsmap' VALUES (6689, 11, 486, 6123);
INSERT INTO 'albumsrecordingsmap' VALUES (6690, 12, 486, 6124);
INSERT INTO 'albumsrecordingsmap' VALUES (6691, 13, 486, 6125);
INSERT INTO 'albumsrecordingsmap' VALUES (6692, 14, 486, 6126);
INSERT INTO 'albumsrecordingsmap' VALUES (6693, 15, 486, 6127);
INSERT INTO 'albumsrecordingsmap' VALUES (6694, 16, 486, 6128);
INSERT INTO 'albumsrecordingsmap' VALUES (6695, 1, 489, 6129);
INSERT INTO 'albumsrecordingsmap' VALUES (6696, 2, 489, 6130);
INSERT INTO 'albumsrecordingsmap' VALUES (6697, 3, 489, 6131);
INSERT INTO 'albumsrecordingsmap' VALUES (6698, 4, 489, 6132);
INSERT INTO 'albumsrecordingsmap' VALUES (6699, 5, 489, 6133);
INSERT INTO 'albumsrecordingsmap' VALUES (6700, 6, 489, 6134);
INSERT INTO 'albumsrecordingsmap' VALUES (6701, 7, 489, 6135);
INSERT INTO 'albumsrecordingsmap' VALUES (6702, 8, 489, 6136);
INSERT INTO 'albumsrecordingsmap' VALUES (6703, 9, 489, 6137);
INSERT INTO 'albumsrecordingsmap' VALUES (6704, 10, 489, 6138);
INSERT INTO 'albumsrecordingsmap' VALUES (6705, 11, 489, 6139);
INSERT INTO 'albumsrecordingsmap' VALUES (6706, 12, 489, 6140);
INSERT INTO 'albumsrecordingsmap' VALUES (6735, 1, 491, 6169);
INSERT INTO 'albumsrecordingsmap' VALUES (6736, 2, 491, 6170);
INSERT INTO 'albumsrecordingsmap' VALUES (6737, 3, 491, 6171);
INSERT INTO 'albumsrecordingsmap' VALUES (6738, 4, 491, 6172);
INSERT INTO 'albumsrecordingsmap' VALUES (6739, 5, 491, 6173);
INSERT INTO 'albumsrecordingsmap' VALUES (6740, 6, 491, 6174);
INSERT INTO 'albumsrecordingsmap' VALUES (6741, 7, 491, 6175);
INSERT INTO 'albumsrecordingsmap' VALUES (6742, 8, 491, 6176);
INSERT INTO 'albumsrecordingsmap' VALUES (6743, 9, 491, 6177);
INSERT INTO 'albumsrecordingsmap' VALUES (6744, 10, 491, 6178);
INSERT INTO 'albumsrecordingsmap' VALUES (6745, 11, 491, 6179);
INSERT INTO 'albumsrecordingsmap' VALUES (6746, 12, 491, 6180);
INSERT INTO 'albumsrecordingsmap' VALUES (6747, 13, 491, 6181);
INSERT INTO 'albumsrecordingsmap' VALUES (6748, 14, 491, 6182);
INSERT INTO 'albumsrecordingsmap' VALUES (6749, 15, 491, 6183);
INSERT INTO 'albumsrecordingsmap' VALUES (6750, 16, 491, 6184);
INSERT INTO 'albumsrecordingsmap' VALUES (6751, 17, 491, 6185);
INSERT INTO 'albumsrecordingsmap' VALUES (6752, 1, 492, 6186);
INSERT INTO 'albumsrecordingsmap' VALUES (6753, 2, 492, 6187);
INSERT INTO 'albumsrecordingsmap' VALUES (6754, 3, 492, 6188);
INSERT INTO 'albumsrecordingsmap' VALUES (6755, 4, 492, 6189);
INSERT INTO 'albumsrecordingsmap' VALUES (6756, 5, 492, 6190);
INSERT INTO 'albumsrecordingsmap' VALUES (6757, 6, 492, 6191);
INSERT INTO 'albumsrecordingsmap' VALUES (6758, 7, 492, 6192);
INSERT INTO 'albumsrecordingsmap' VALUES (6759, 10, 492, 6193);
INSERT INTO 'albumsrecordingsmap' VALUES (6760, 8, 492, 6194);
INSERT INTO 'albumsrecordingsmap' VALUES (6761, 9, 492, 6195);
INSERT INTO 'albumsrecordingsmap' VALUES (6762, 11, 492, 6196);
INSERT INTO 'albumsrecordingsmap' VALUES (6763, 12, 492, 6197);
INSERT INTO 'albumsrecordingsmap' VALUES (6764, 13, 492, 6198);
INSERT INTO 'albumsrecordingsmap' VALUES (6765, 14, 492, 6199);
INSERT INTO 'albumsrecordingsmap' VALUES (6766, 15, 492, 6200);
INSERT INTO 'albumsrecordingsmap' VALUES (6767, 1, 493, 6201);
INSERT INTO 'albumsrecordingsmap' VALUES (6768, 2, 493, 6202);
INSERT INTO 'albumsrecordingsmap' VALUES (6769, 3, 493, 6203);
INSERT INTO 'albumsrecordingsmap' VALUES (6770, 4, 493, 6204);
INSERT INTO 'albumsrecordingsmap' VALUES (6771, 5, 493, 6205);
INSERT INTO 'albumsrecordingsmap' VALUES (6772, 6, 493, 6206);
INSERT INTO 'albumsrecordingsmap' VALUES (6773, 7, 493, 6207);
INSERT INTO 'albumsrecordingsmap' VALUES (6774, 8, 493, 6208);
INSERT INTO 'albumsrecordingsmap' VALUES (6775, 9, 493, 6209);
INSERT INTO 'albumsrecordingsmap' VALUES (6776, 10, 493, 6210);
INSERT INTO 'albumsrecordingsmap' VALUES (6777, 11, 493, 6211);
INSERT INTO 'albumsrecordingsmap' VALUES (6778, 12, 493, 6212);
INSERT INTO 'albumsrecordingsmap' VALUES (6779, 13, 493, 6213);
INSERT INTO 'albumsrecordingsmap' VALUES (6780, 14, 493, 6214);
INSERT INTO 'albumsrecordingsmap' VALUES (6781, 15, 493, 6215);
INSERT INTO 'albumsrecordingsmap' VALUES (6782, 16, 493, 6216);
INSERT INTO 'albumsrecordingsmap' VALUES (6783, 17, 493, 6217);
INSERT INTO 'albumsrecordingsmap' VALUES (6784, 18, 493, 6218);
INSERT INTO 'albumsrecordingsmap' VALUES (6785, 19, 493, 6219);
INSERT INTO 'albumsrecordingsmap' VALUES (6786, 20, 493, 6220);
INSERT INTO 'albumsrecordingsmap' VALUES (6787, 21, 493, 6221);
INSERT INTO 'albumsrecordingsmap' VALUES (6788, 22, 493, 6222);
INSERT INTO 'albumsrecordingsmap' VALUES (6789, 23, 493, 6223);
INSERT INTO 'albumsrecordingsmap' VALUES (6790, 24, 493, 6224);
INSERT INTO 'albumsrecordingsmap' VALUES (6791, 25, 493, 6225);
INSERT INTO 'albumsrecordingsmap' VALUES (6792, 26, 493, 6226);
INSERT INTO 'albumsrecordingsmap' VALUES (6793, 27, 493, 6227);
INSERT INTO 'albumsrecordingsmap' VALUES (6794, 1, 494, 6228);
INSERT INTO 'albumsrecordingsmap' VALUES (6795, 2, 494, 6229);
INSERT INTO 'albumsrecordingsmap' VALUES (6796, 3, 494, 6230);
INSERT INTO 'albumsrecordingsmap' VALUES (6797, 4, 494, 6231);
INSERT INTO 'albumsrecordingsmap' VALUES (6798, 5, 494, 6232);
INSERT INTO 'albumsrecordingsmap' VALUES (6799, 6, 494, 6233);
INSERT INTO 'albumsrecordingsmap' VALUES (6800, 7, 494, 6234);
INSERT INTO 'albumsrecordingsmap' VALUES (6801, 8, 494, 6235);
INSERT INTO 'albumsrecordingsmap' VALUES (6802, 9, 494, 6236);
INSERT INTO 'albumsrecordingsmap' VALUES (6803, 10, 494, 6237);
INSERT INTO 'albumsrecordingsmap' VALUES (6804, 11, 494, 6238);
INSERT INTO 'albumsrecordingsmap' VALUES (6805, 12, 494, 6239);
INSERT INTO 'albumsrecordingsmap' VALUES (6806, 13, 494, 6240);
INSERT INTO 'albumsrecordingsmap' VALUES (6809, 1, 495, 6243);
INSERT INTO 'albumsrecordingsmap' VALUES (6810, 2, 495, 6244);
INSERT INTO 'albumsrecordingsmap' VALUES (6811, 3, 495, 6245);
INSERT INTO 'albumsrecordingsmap' VALUES (6812, 4, 495, 6246);
INSERT INTO 'albumsrecordingsmap' VALUES (6813, 5, 495, 6247);
INSERT INTO 'albumsrecordingsmap' VALUES (6814, 6, 495, 6248);
INSERT INTO 'albumsrecordingsmap' VALUES (6815, 7, 495, 6249);
INSERT INTO 'albumsrecordingsmap' VALUES (6816, 8, 495, 6250);
INSERT INTO 'albumsrecordingsmap' VALUES (6817, 9, 495, 6251);
INSERT INTO 'albumsrecordingsmap' VALUES (6818, 10, 495, 6252);
INSERT INTO 'albumsrecordingsmap' VALUES (6819, 11, 495, 6253);
INSERT INTO 'albumsrecordingsmap' VALUES (6820, 12, 495, 6254);
INSERT INTO 'albumsrecordingsmap' VALUES (6821, 13, 495, 6255);
INSERT INTO 'albumsrecordingsmap' VALUES (6822, 1, 496, 6256);
INSERT INTO 'albumsrecordingsmap' VALUES (6823, 2, 496, 6257);
INSERT INTO 'albumsrecordingsmap' VALUES (6824, 3, 496, 6258);
INSERT INTO 'albumsrecordingsmap' VALUES (6825, 4, 496, 6259);
INSERT INTO 'albumsrecordingsmap' VALUES (6807, 15, 494, 6241);
INSERT INTO 'albumsrecordingsmap' VALUES (6808, 16, 494, 6242);
INSERT INTO 'albumsrecordingsmap' VALUES (6826, 5, 496, 6260);
INSERT INTO 'albumsrecordingsmap' VALUES (6827, 6, 496, 6261);
INSERT INTO 'albumsrecordingsmap' VALUES (6828, 7, 496, 6262);
INSERT INTO 'albumsrecordingsmap' VALUES (6829, 8, 496, 6263);
INSERT INTO 'albumsrecordingsmap' VALUES (6830, 9, 496, 6264);
INSERT INTO 'albumsrecordingsmap' VALUES (6831, 10, 496, 6265);
INSERT INTO 'albumsrecordingsmap' VALUES (6832, 11, 496, 6266);
INSERT INTO 'albumsrecordingsmap' VALUES (6833, 1, 497, 6267);
INSERT INTO 'albumsrecordingsmap' VALUES (6834, 2, 497, 6268);
INSERT INTO 'albumsrecordingsmap' VALUES (6835, 3, 497, 6269);
INSERT INTO 'albumsrecordingsmap' VALUES (6836, 4, 497, 6270);
INSERT INTO 'albumsrecordingsmap' VALUES (6837, 5, 497, 6271);
INSERT INTO 'albumsrecordingsmap' VALUES (6838, 6, 497, 6272);
INSERT INTO 'albumsrecordingsmap' VALUES (6839, 7, 497, 6273);
INSERT INTO 'albumsrecordingsmap' VALUES (6840, 8, 497, 6274);
INSERT INTO 'albumsrecordingsmap' VALUES (6841, 9, 497, 6275);
INSERT INTO 'albumsrecordingsmap' VALUES (6842, 10, 497, 6276);
INSERT INTO 'albumsrecordingsmap' VALUES (6843, 1, 498, 6277);
INSERT INTO 'albumsrecordingsmap' VALUES (6844, 2, 498, 6278);
INSERT INTO 'albumsrecordingsmap' VALUES (6845, 3, 498, 6279);
INSERT INTO 'albumsrecordingsmap' VALUES (6846, 4, 498, 6280);
INSERT INTO 'albumsrecordingsmap' VALUES (6847, 7, 65, 791);
INSERT INTO 'albumsrecordingsmap' VALUES (6848, 8, 65, 792);
INSERT INTO 'albumsrecordingsmap' VALUES (6849, 9, 65, 793);
INSERT INTO 'albumsrecordingsmap' VALUES (6850, 10, 65, 793);
INSERT INTO 'albumsrecordingsmap' VALUES (6851, 11, 65, 794);
INSERT INTO 'albumsrecordingsmap' VALUES (6852, 1, 500, 6282);
INSERT INTO 'albumsrecordingsmap' VALUES (6853, 2, 500, 6283);
INSERT INTO 'albumsrecordingsmap' VALUES (6854, 3, 500, 6284);
INSERT INTO 'albumsrecordingsmap' VALUES (6855, 4, 500, 6285);
INSERT INTO 'albumsrecordingsmap' VALUES (6856, 5, 500, 6286);
INSERT INTO 'albumsrecordingsmap' VALUES (6857, 6, 500, 6287);
INSERT INTO 'albumsrecordingsmap' VALUES (6858, 7, 500, 6289);
INSERT INTO 'albumsrecordingsmap' VALUES (6859, 8, 500, 6288);
INSERT INTO 'albumsrecordingsmap' VALUES (6860, 9, 500, 6290);
INSERT INTO 'albumsrecordingsmap' VALUES (6861, 10, 500, 6291);
INSERT INTO 'albumsrecordingsmap' VALUES (6862, 11, 500, 6292);
INSERT INTO 'albumsrecordingsmap' VALUES (6863, 12, 500, 6293);
INSERT INTO 'albumsrecordingsmap' VALUES (6864, 13, 500, 6294);
INSERT INTO 'albumsrecordingsmap' VALUES (6865, 14, 500, 6295);
INSERT INTO 'albumsrecordingsmap' VALUES (6866, 15, 500, 6296);
INSERT INTO 'albumsrecordingsmap' VALUES (6867, 16, 500, 6297);
INSERT INTO 'albumsrecordingsmap' VALUES (6868, 17, 500, 6298);
INSERT INTO 'albumsrecordingsmap' VALUES (6869, 1, 501, 6299);
INSERT INTO 'albumsrecordingsmap' VALUES (6870, 2, 501, 6300);
INSERT INTO 'albumsrecordingsmap' VALUES (6871, 3, 501, 6301);
INSERT INTO 'albumsrecordingsmap' VALUES (6872, 4, 501, 6302);
INSERT INTO 'albumsrecordingsmap' VALUES (6873, 5, 501, 6303);
INSERT INTO 'albumsrecordingsmap' VALUES (6874, 6, 501, 6304);
INSERT INTO 'albumsrecordingsmap' VALUES (6875, 7, 501, 6305);
INSERT INTO 'albumsrecordingsmap' VALUES (6876, 8, 501, 6306);
INSERT INTO 'albumsrecordingsmap' VALUES (6877, 9, 501, 6307);
INSERT INTO 'albumsrecordingsmap' VALUES (6878, 10, 501, 6308);
INSERT INTO 'albumsrecordingsmap' VALUES (6879, 11, 501, 6309);
INSERT INTO 'albumsrecordingsmap' VALUES (6880, 12, 501, 6310);
INSERT INTO 'albumsrecordingsmap' VALUES (6881, 1, 502, 6311);
INSERT INTO 'albumsrecordingsmap' VALUES (6882, 2, 502, 6312);
INSERT INTO 'albumsrecordingsmap' VALUES (6883, 3, 502, 6313);
INSERT INTO 'albumsrecordingsmap' VALUES (6884, 4, 502, 6314);
INSERT INTO 'albumsrecordingsmap' VALUES (6885, 5, 502, 6315);
INSERT INTO 'albumsrecordingsmap' VALUES (6886, 6, 502, 6316);
INSERT INTO 'albumsrecordingsmap' VALUES (6887, 7, 502, 6317);
INSERT INTO 'albumsrecordingsmap' VALUES (6888, 8, 502, 6318);
INSERT INTO 'albumsrecordingsmap' VALUES (6889, 9, 502, 6319);
INSERT INTO 'albumsrecordingsmap' VALUES (6890, 10, 502, 6320);
INSERT INTO 'albumsrecordingsmap' VALUES (6891, 11, 502, 6321);
INSERT INTO 'albumsrecordingsmap' VALUES (6892, 12, 502, 6322);
INSERT INTO 'albumsrecordingsmap' VALUES (6893, 13, 502, 6323);
INSERT INTO 'albumsrecordingsmap' VALUES (6894, 14, 502, 6324);
INSERT INTO 'albumsrecordingsmap' VALUES (6895, 15, 502, 6325);
INSERT INTO 'albumsrecordingsmap' VALUES (6896, 1, 503, 6326);
INSERT INTO 'albumsrecordingsmap' VALUES (6897, 2, 503, 6327);
INSERT INTO 'albumsrecordingsmap' VALUES (6898, 3, 503, 6328);
INSERT INTO 'albumsrecordingsmap' VALUES (6899, 4, 503, 6329);
INSERT INTO 'albumsrecordingsmap' VALUES (6900, 5, 503, 6330);
INSERT INTO 'albumsrecordingsmap' VALUES (6901, 6, 503, 6331);
INSERT INTO 'albumsrecordingsmap' VALUES (6902, 7, 503, 6332);
INSERT INTO 'albumsrecordingsmap' VALUES (6903, 8, 503, 6333);
INSERT INTO 'albumsrecordingsmap' VALUES (6904, 9, 503, 6334);
INSERT INTO 'albumsrecordingsmap' VALUES (6905, 10, 503, 6335);
INSERT INTO 'albumsrecordingsmap' VALUES (6906, 12, 503, 6337);
INSERT INTO 'albumsrecordingsmap' VALUES (6907, 11, 503, 6336);
INSERT INTO 'albumsrecordingsmap' VALUES (6908, 13, 503, 6338);
INSERT INTO 'albumsrecordingsmap' VALUES (6909, 1, 504, 6339);
INSERT INTO 'albumsrecordingsmap' VALUES (6910, 2, 504, 6340);
INSERT INTO 'albumsrecordingsmap' VALUES (6911, 3, 504, 6341);
INSERT INTO 'albumsrecordingsmap' VALUES (6912, 4, 504, 6342);
INSERT INTO 'albumsrecordingsmap' VALUES (6913, 5, 504, 6343);
INSERT INTO 'albumsrecordingsmap' VALUES (6914, 6, 504, 6344);
INSERT INTO 'albumsrecordingsmap' VALUES (6915, 7, 504, 6345);
INSERT INTO 'albumsrecordingsmap' VALUES (6916, 8, 504, 6346);
INSERT INTO 'albumsrecordingsmap' VALUES (6917, 9, 504, 6347);
INSERT INTO 'albumsrecordingsmap' VALUES (6918, 10, 504, 6348);
INSERT INTO 'albumsrecordingsmap' VALUES (6919, 11, 504, 6349);
INSERT INTO 'albumsrecordingsmap' VALUES (6920, 12, 504, 6350);
INSERT INTO 'albumsrecordingsmap' VALUES (6921, 13, 504, 6351);
INSERT INTO 'albumsrecordingsmap' VALUES (6922, 14, 504, 6352);
INSERT INTO 'albumsrecordingsmap' VALUES (6923, 1, 507, 6353);
INSERT INTO 'albumsrecordingsmap' VALUES (6924, 2, 507, 6354);
INSERT INTO 'albumsrecordingsmap' VALUES (6925, 3, 507, 6355);
INSERT INTO 'albumsrecordingsmap' VALUES (6926, 4, 507, 6356);
INSERT INTO 'albumsrecordingsmap' VALUES (6927, 5, 507, 6357);
INSERT INTO 'albumsrecordingsmap' VALUES (6928, 6, 507, 6358);
INSERT INTO 'albumsrecordingsmap' VALUES (6929, 7, 507, 6359);
INSERT INTO 'albumsrecordingsmap' VALUES (6930, 8, 507, 6360);
INSERT INTO 'albumsrecordingsmap' VALUES (6931, 9, 507, 6361);
INSERT INTO 'albumsrecordingsmap' VALUES (6932, 10, 507, 6362);
INSERT INTO 'albumsrecordingsmap' VALUES (6933, 11, 507, 6363);
INSERT INTO 'albumsrecordingsmap' VALUES (6934, 12, 507, 6364);
INSERT INTO 'albumsrecordingsmap' VALUES (6935, 13, 507, 6365);
INSERT INTO 'albumsrecordingsmap' VALUES (6939, 1, 505, 6375);
INSERT INTO 'albumsrecordingsmap' VALUES (6940, 2, 505, 6376);
INSERT INTO 'albumsrecordingsmap' VALUES (6941, 3, 505, 6377);
INSERT INTO 'albumsrecordingsmap' VALUES (6942, 4, 505, 6378);
INSERT INTO 'albumsrecordingsmap' VALUES (6943, 5, 505, 6379);
INSERT INTO 'albumsrecordingsmap' VALUES (6944, 6, 505, 6380);
INSERT INTO 'albumsrecordingsmap' VALUES (6945, 7, 505, 6381);
INSERT INTO 'albumsrecordingsmap' VALUES (6946, 8, 505, 6382);
INSERT INTO 'albumsrecordingsmap' VALUES (6947, 9, 505, 6383);
INSERT INTO 'albumsrecordingsmap' VALUES (6948, 10, 505, 6384);
INSERT INTO 'albumsrecordingsmap' VALUES (6949, 11, 505, 6385);
INSERT INTO 'albumsrecordingsmap' VALUES (6950, 12, 505, 6386);
INSERT INTO 'albumsrecordingsmap' VALUES (6951, 13, 505, 6387);
INSERT INTO 'albumsrecordingsmap' VALUES (6952, 14, 505, 6388);
INSERT INTO 'albumsrecordingsmap' VALUES (6953, 1, 508, 6389);
INSERT INTO 'albumsrecordingsmap' VALUES (6954, 2, 508, 6390);
INSERT INTO 'albumsrecordingsmap' VALUES (6955, 3, 508, 6391);
INSERT INTO 'albumsrecordingsmap' VALUES (6956, 4, 508, 6392);
INSERT INTO 'albumsrecordingsmap' VALUES (6957, 5, 508, 6393);
INSERT INTO 'albumsrecordingsmap' VALUES (6958, 6, 508, 6394);
INSERT INTO 'albumsrecordingsmap' VALUES (6959, 7, 508, 6395);
INSERT INTO 'albumsrecordingsmap' VALUES (6960, 8, 508, 6396);
INSERT INTO 'albumsrecordingsmap' VALUES (6961, 9, 508, 6397);
INSERT INTO 'albumsrecordingsmap' VALUES (6962, 10, 508, 6398);
INSERT INTO 'albumsrecordingsmap' VALUES (6963, 11, 508, 6399);
INSERT INTO 'albumsrecordingsmap' VALUES (6964, 12, 508, 6400);
INSERT INTO 'albumsrecordingsmap' VALUES (6965, 13, 508, 6401);
INSERT INTO 'albumsrecordingsmap' VALUES (6966, 14, 508, 6402);
INSERT INTO 'albumsrecordingsmap' VALUES (6967, 15, 508, 6403);
INSERT INTO 'albumsrecordingsmap' VALUES (6968, 1, 509, 6404);
INSERT INTO 'albumsrecordingsmap' VALUES (6969, 2, 509, 6405);
INSERT INTO 'albumsrecordingsmap' VALUES (6970, 3, 509, 6406);
INSERT INTO 'albumsrecordingsmap' VALUES (6971, 4, 509, 6407);
INSERT INTO 'albumsrecordingsmap' VALUES (6972, 5, 509, 6408);
INSERT INTO 'albumsrecordingsmap' VALUES (6973, 6, 509, 6409);
INSERT INTO 'albumsrecordingsmap' VALUES (6974, 7, 509, 6410);
INSERT INTO 'albumsrecordingsmap' VALUES (6975, 8, 509, 6411);
INSERT INTO 'albumsrecordingsmap' VALUES (6976, 9, 509, 6412);
INSERT INTO 'albumsrecordingsmap' VALUES (6977, 10, 509, 6413);
INSERT INTO 'albumsrecordingsmap' VALUES (6978, 11, 509, 6414);
INSERT INTO 'albumsrecordingsmap' VALUES (6979, 12, 509, 6415);
INSERT INTO 'albumsrecordingsmap' VALUES (6980, 13, 509, 6416);
INSERT INTO 'albumsrecordingsmap' VALUES (6981, 14, 509, 6417);
INSERT INTO 'albumsrecordingsmap' VALUES (6982, 15, 509, 6418);
INSERT INTO 'albumsrecordingsmap' VALUES (9963, 4, 1056, 9390);
INSERT INTO 'albumsrecordingsmap' VALUES (6994, 1, 510, 6424);
INSERT INTO 'albumsrecordingsmap' VALUES (6995, 2, 510, 6425);
INSERT INTO 'albumsrecordingsmap' VALUES (6996, 3, 510, 6426);
INSERT INTO 'albumsrecordingsmap' VALUES (6997, 4, 510, 6427);
INSERT INTO 'albumsrecordingsmap' VALUES (6998, 5, 510, 6428);
INSERT INTO 'albumsrecordingsmap' VALUES (6999, 6, 510, 6429);
INSERT INTO 'albumsrecordingsmap' VALUES (7000, 7, 510, 6430);
INSERT INTO 'albumsrecordingsmap' VALUES (7001, 8, 510, 6431);
INSERT INTO 'albumsrecordingsmap' VALUES (7002, 9, 510, 6432);
INSERT INTO 'albumsrecordingsmap' VALUES (7003, 10, 510, 6433);
INSERT INTO 'albumsrecordingsmap' VALUES (7004, 11, 510, 6434);
INSERT INTO 'albumsrecordingsmap' VALUES (7005, 12, 510, 6435);
INSERT INTO 'albumsrecordingsmap' VALUES (7006, 13, 510, 6436);
INSERT INTO 'albumsrecordingsmap' VALUES (7007, 14, 510, 6437);
INSERT INTO 'albumsrecordingsmap' VALUES (7008, 15, 510, 6438);
INSERT INTO 'albumsrecordingsmap' VALUES (7009, 16, 510, 6439);
INSERT INTO 'albumsrecordingsmap' VALUES (7010, 1, 511, 6440);
INSERT INTO 'albumsrecordingsmap' VALUES (7011, 2, 511, 6441);
INSERT INTO 'albumsrecordingsmap' VALUES (7012, 3, 511, 6442);
INSERT INTO 'albumsrecordingsmap' VALUES (7013, 4, 511, 6443);
INSERT INTO 'albumsrecordingsmap' VALUES (7014, 5, 511, 6444);
INSERT INTO 'albumsrecordingsmap' VALUES (7015, 6, 511, 6445);
INSERT INTO 'albumsrecordingsmap' VALUES (7016, 7, 511, 6446);
INSERT INTO 'albumsrecordingsmap' VALUES (7017, 8, 511, 6447);
INSERT INTO 'albumsrecordingsmap' VALUES (7018, 9, 511, 6448);
INSERT INTO 'albumsrecordingsmap' VALUES (7019, 10, 511, 6449);
INSERT INTO 'albumsrecordingsmap' VALUES (7020, 11, 511, 6450);
INSERT INTO 'albumsrecordingsmap' VALUES (7021, 12, 511, 6451);
INSERT INTO 'albumsrecordingsmap' VALUES (7022, 13, 511, 6452);
INSERT INTO 'albumsrecordingsmap' VALUES (7023, 1, 513, 6453);
INSERT INTO 'albumsrecordingsmap' VALUES (7024, 2, 513, 6454);
INSERT INTO 'albumsrecordingsmap' VALUES (7025, 3, 513, 6455);
INSERT INTO 'albumsrecordingsmap' VALUES (7026, 4, 513, 6456);
INSERT INTO 'albumsrecordingsmap' VALUES (7027, 5, 513, 6457);
INSERT INTO 'albumsrecordingsmap' VALUES (7028, 6, 513, 6458);
INSERT INTO 'albumsrecordingsmap' VALUES (7029, 7, 513, 6459);
INSERT INTO 'albumsrecordingsmap' VALUES (7030, 8, 513, 6460);
INSERT INTO 'albumsrecordingsmap' VALUES (7031, 9, 513, 6461);
INSERT INTO 'albumsrecordingsmap' VALUES (7032, 10, 513, 6462);
INSERT INTO 'albumsrecordingsmap' VALUES (7033, 11, 513, 6463);
INSERT INTO 'albumsrecordingsmap' VALUES (7034, 12, 513, 6464);
INSERT INTO 'albumsrecordingsmap' VALUES (7035, 13, 513, 6465);
INSERT INTO 'albumsrecordingsmap' VALUES (7036, 14, 513, 6466);
INSERT INTO 'albumsrecordingsmap' VALUES (7037, 10, 144, 6106);
INSERT INTO 'albumsrecordingsmap' VALUES (7038, 1, 512, 2543);
INSERT INTO 'albumsrecordingsmap' VALUES (7039, 2, 512, 6467);
INSERT INTO 'albumsrecordingsmap' VALUES (7040, 3, 512, 6468);
INSERT INTO 'albumsrecordingsmap' VALUES (7041, 4, 512, 6469);
INSERT INTO 'albumsrecordingsmap' VALUES (7042, 5, 512, 6470);
INSERT INTO 'albumsrecordingsmap' VALUES (7044, 7, 512, 1647);
INSERT INTO 'albumsrecordingsmap' VALUES (7045, 8, 512, 1648);
INSERT INTO 'albumsrecordingsmap' VALUES (7046, 9, 512, 1649);
INSERT INTO 'albumsrecordingsmap' VALUES (7047, 10, 512, 1650);
INSERT INTO 'albumsrecordingsmap' VALUES (7048, 11, 512, 1651);
INSERT INTO 'albumsrecordingsmap' VALUES (7043, 6, 512, 1646);
INSERT INTO 'albumsrecordingsmap' VALUES (7049, 12, 512, 1652);
INSERT INTO 'albumsrecordingsmap' VALUES (7075, 1, 516, 6494);
INSERT INTO 'albumsrecordingsmap' VALUES (7076, 2, 516, 6495);
INSERT INTO 'albumsrecordingsmap' VALUES (7077, 3, 516, 6496);
INSERT INTO 'albumsrecordingsmap' VALUES (7078, 4, 516, 6497);
INSERT INTO 'albumsrecordingsmap' VALUES (7079, 5, 516, 6498);
INSERT INTO 'albumsrecordingsmap' VALUES (7080, 6, 516, 6499);
INSERT INTO 'albumsrecordingsmap' VALUES (7081, 7, 516, 6500);
INSERT INTO 'albumsrecordingsmap' VALUES (7082, 8, 516, 6501);
INSERT INTO 'albumsrecordingsmap' VALUES (7083, 9, 516, 6502);
INSERT INTO 'albumsrecordingsmap' VALUES (7084, 10, 516, 6503);
INSERT INTO 'albumsrecordingsmap' VALUES (7085, 11, 516, 6504);
INSERT INTO 'albumsrecordingsmap' VALUES (7086, 12, 516, 6505);
INSERT INTO 'albumsrecordingsmap' VALUES (7087, 13, 516, 6506);
INSERT INTO 'albumsrecordingsmap' VALUES (7088, 14, 516, 6507);
INSERT INTO 'albumsrecordingsmap' VALUES (7089, 15, 17, 5787);
INSERT INTO 'albumsrecordingsmap' VALUES (7090, 1, 879, 6508);
INSERT INTO 'albumsrecordingsmap' VALUES (7091, 2, 879, 6509);
INSERT INTO 'albumsrecordingsmap' VALUES (9964, 5, 1056, 9391);
INSERT INTO 'albumsrecordingsmap' VALUES (9965, 6, 1056, 9392);
INSERT INTO 'albumsrecordingsmap' VALUES (9966, 7, 1056, 9393);
INSERT INTO 'albumsrecordingsmap' VALUES (9967, 8, 1056, 9394);
INSERT INTO 'albumsrecordingsmap' VALUES (9968, 9, 1056, 9395);
INSERT INTO 'albumsrecordingsmap' VALUES (9969, 10, 1056, 9396);
INSERT INTO 'albumsrecordingsmap' VALUES (7092, 3, 879, 6510);
INSERT INTO 'albumsrecordingsmap' VALUES (7093, 4, 879, 6511);
INSERT INTO 'albumsrecordingsmap' VALUES (7094, 5, 879, 6512);
INSERT INTO 'albumsrecordingsmap' VALUES (7095, 6, 879, 6513);
INSERT INTO 'albumsrecordingsmap' VALUES (7096, 7, 879, 6514);
INSERT INTO 'albumsrecordingsmap' VALUES (7097, 8, 879, 6515);
INSERT INTO 'albumsrecordingsmap' VALUES (7098, 9, 879, 6516);
INSERT INTO 'albumsrecordingsmap' VALUES (7099, 10, 879, 6517);
INSERT INTO 'albumsrecordingsmap' VALUES (7100, 11, 879, 6518);
INSERT INTO 'albumsrecordingsmap' VALUES (7101, 12, 879, 6519);
INSERT INTO 'albumsrecordingsmap' VALUES (7102, 13, 879, 6520);
INSERT INTO 'albumsrecordingsmap' VALUES (7103, 1, 880, 6521);
INSERT INTO 'albumsrecordingsmap' VALUES (7104, 2, 880, 6522);
INSERT INTO 'albumsrecordingsmap' VALUES (7105, 3, 880, 6523);
INSERT INTO 'albumsrecordingsmap' VALUES (7106, 4, 880, 6524);
INSERT INTO 'albumsrecordingsmap' VALUES (7107, 5, 880, 6525);
INSERT INTO 'albumsrecordingsmap' VALUES (7108, 6, 880, 6526);
INSERT INTO 'albumsrecordingsmap' VALUES (7109, 7, 880, 6527);
INSERT INTO 'albumsrecordingsmap' VALUES (7110, 8, 880, 6528);
INSERT INTO 'albumsrecordingsmap' VALUES (7111, 9, 880, 6529);
INSERT INTO 'albumsrecordingsmap' VALUES (7112, 10, 880, 6530);
INSERT INTO 'albumsrecordingsmap' VALUES (7113, 11, 880, 6531);
INSERT INTO 'albumsrecordingsmap' VALUES (7114, 1, 881, 6532);
INSERT INTO 'albumsrecordingsmap' VALUES (7115, 2, 881, 6533);
INSERT INTO 'albumsrecordingsmap' VALUES (7116, 3, 881, 6534);
INSERT INTO 'albumsrecordingsmap' VALUES (7117, 4, 881, 6535);
INSERT INTO 'albumsrecordingsmap' VALUES (7118, 5, 881, 6536);
INSERT INTO 'albumsrecordingsmap' VALUES (7119, 6, 881, 6537);
INSERT INTO 'albumsrecordingsmap' VALUES (7120, 7, 881, 6538);
INSERT INTO 'albumsrecordingsmap' VALUES (7121, 8, 881, 6539);
INSERT INTO 'albumsrecordingsmap' VALUES (7122, 9, 881, 6540);
INSERT INTO 'albumsrecordingsmap' VALUES (7123, 10, 881, 6541);
INSERT INTO 'albumsrecordingsmap' VALUES (7124, 11, 881, 6542);
INSERT INTO 'albumsrecordingsmap' VALUES (7125, 12, 881, 6543);
INSERT INTO 'albumsrecordingsmap' VALUES (7126, 1, 882, 6544);
INSERT INTO 'albumsrecordingsmap' VALUES (7127, 2, 882, 6545);
INSERT INTO 'albumsrecordingsmap' VALUES (7128, 3, 882, 6546);
INSERT INTO 'albumsrecordingsmap' VALUES (7129, 4, 882, 6547);
INSERT INTO 'albumsrecordingsmap' VALUES (7130, 5, 882, 6548);
INSERT INTO 'albumsrecordingsmap' VALUES (7131, 6, 882, 6549);
INSERT INTO 'albumsrecordingsmap' VALUES (7132, 7, 882, 6550);
INSERT INTO 'albumsrecordingsmap' VALUES (7133, 8, 882, 6551);
INSERT INTO 'albumsrecordingsmap' VALUES (7134, 9, 882, 6552);
INSERT INTO 'albumsrecordingsmap' VALUES (7135, 10, 882, 6553);
INSERT INTO 'albumsrecordingsmap' VALUES (7136, 11, 882, 6554);
INSERT INTO 'albumsrecordingsmap' VALUES (7137, 12, 882, 6555);
INSERT INTO 'albumsrecordingsmap' VALUES (7138, 1, 883, 6556);
INSERT INTO 'albumsrecordingsmap' VALUES (7139, 2, 883, 6557);
INSERT INTO 'albumsrecordingsmap' VALUES (7140, 3, 883, 6558);
INSERT INTO 'albumsrecordingsmap' VALUES (7141, 4, 883, 6559);
INSERT INTO 'albumsrecordingsmap' VALUES (7142, 5, 883, 6560);
INSERT INTO 'albumsrecordingsmap' VALUES (7143, 6, 883, 6561);
INSERT INTO 'albumsrecordingsmap' VALUES (7144, 7, 883, 6562);
INSERT INTO 'albumsrecordingsmap' VALUES (7145, 8, 883, 6563);
INSERT INTO 'albumsrecordingsmap' VALUES (7146, 9, 883, 6564);
INSERT INTO 'albumsrecordingsmap' VALUES (7147, 10, 883, 6565);
INSERT INTO 'albumsrecordingsmap' VALUES (7148, 11, 883, 6566);
INSERT INTO 'albumsrecordingsmap' VALUES (7149, 12, 883, 6567);
INSERT INTO 'albumsrecordingsmap' VALUES (7150, 1, 884, 6568);
INSERT INTO 'albumsrecordingsmap' VALUES (7151, 2, 884, 6569);
INSERT INTO 'albumsrecordingsmap' VALUES (7152, 3, 884, 6570);
INSERT INTO 'albumsrecordingsmap' VALUES (7153, 4, 884, 6571);
INSERT INTO 'albumsrecordingsmap' VALUES (7154, 5, 884, 6572);
INSERT INTO 'albumsrecordingsmap' VALUES (7155, 6, 884, 6573);
INSERT INTO 'albumsrecordingsmap' VALUES (7156, 7, 884, 6574);
INSERT INTO 'albumsrecordingsmap' VALUES (7157, 8, 884, 6575);
INSERT INTO 'albumsrecordingsmap' VALUES (7158, 9, 884, 6576);
INSERT INTO 'albumsrecordingsmap' VALUES (7159, 10, 884, 6577);
INSERT INTO 'albumsrecordingsmap' VALUES (7160, 11, 884, 6578);
INSERT INTO 'albumsrecordingsmap' VALUES (7161, 12, 884, 6579);
INSERT INTO 'albumsrecordingsmap' VALUES (7162, 13, 884, 6580);
INSERT INTO 'albumsrecordingsmap' VALUES (7163, 14, 884, 6581);
INSERT INTO 'albumsrecordingsmap' VALUES (7164, 1, 885, 6582);
INSERT INTO 'albumsrecordingsmap' VALUES (7165, 2, 885, 6583);
INSERT INTO 'albumsrecordingsmap' VALUES (7166, 3, 885, 6584);
INSERT INTO 'albumsrecordingsmap' VALUES (7167, 4, 885, 6585);
INSERT INTO 'albumsrecordingsmap' VALUES (7168, 5, 885, 6586);
INSERT INTO 'albumsrecordingsmap' VALUES (7169, 6, 885, 6587);
INSERT INTO 'albumsrecordingsmap' VALUES (7170, 7, 885, 6588);
INSERT INTO 'albumsrecordingsmap' VALUES (7171, 8, 885, 6589);
INSERT INTO 'albumsrecordingsmap' VALUES (7172, 9, 885, 6590);
INSERT INTO 'albumsrecordingsmap' VALUES (7173, 10, 885, 6591);
INSERT INTO 'albumsrecordingsmap' VALUES (7174, 11, 885, 6592);
INSERT INTO 'albumsrecordingsmap' VALUES (7175, 12, 885, 6593);
INSERT INTO 'albumsrecordingsmap' VALUES (7176, 1, 886, 6594);
INSERT INTO 'albumsrecordingsmap' VALUES (7177, 2, 886, 6595);
INSERT INTO 'albumsrecordingsmap' VALUES (7178, 3, 886, 6596);
INSERT INTO 'albumsrecordingsmap' VALUES (7179, 4, 886, 6597);
INSERT INTO 'albumsrecordingsmap' VALUES (7180, 5, 886, 6598);
INSERT INTO 'albumsrecordingsmap' VALUES (7181, 6, 886, 6599);
INSERT INTO 'albumsrecordingsmap' VALUES (7182, 7, 886, 6600);
INSERT INTO 'albumsrecordingsmap' VALUES (7183, 8, 886, 6601);
INSERT INTO 'albumsrecordingsmap' VALUES (7184, 9, 886, 6602);
INSERT INTO 'albumsrecordingsmap' VALUES (7185, 10, 886, 6603);
INSERT INTO 'albumsrecordingsmap' VALUES (7186, 11, 886, 6604);
INSERT INTO 'albumsrecordingsmap' VALUES (7187, 12, 886, 6605);
INSERT INTO 'albumsrecordingsmap' VALUES (7188, 13, 886, 6606);
INSERT INTO 'albumsrecordingsmap' VALUES (7189, 14, 886, 6607);
INSERT INTO 'albumsrecordingsmap' VALUES (7190, 15, 886, 6608);
INSERT INTO 'albumsrecordingsmap' VALUES (7221, 1, 888, 6639);
INSERT INTO 'albumsrecordingsmap' VALUES (7222, 2, 888, 6640);
INSERT INTO 'albumsrecordingsmap' VALUES (7223, 3, 888, 6641);
INSERT INTO 'albumsrecordingsmap' VALUES (7224, 4, 888, 6642);
INSERT INTO 'albumsrecordingsmap' VALUES (7225, 5, 888, 6643);
INSERT INTO 'albumsrecordingsmap' VALUES (7226, 6, 888, 6644);
INSERT INTO 'albumsrecordingsmap' VALUES (7227, 7, 888, 6645);
INSERT INTO 'albumsrecordingsmap' VALUES (7228, 8, 888, 6646);
INSERT INTO 'albumsrecordingsmap' VALUES (7229, 9, 888, 6647);
INSERT INTO 'albumsrecordingsmap' VALUES (7230, 10, 888, 6648);
INSERT INTO 'albumsrecordingsmap' VALUES (7231, 11, 888, 6649);
INSERT INTO 'albumsrecordingsmap' VALUES (7232, 12, 888, 6650);
INSERT INTO 'albumsrecordingsmap' VALUES (7233, 13, 888, 6651);
INSERT INTO 'albumsrecordingsmap' VALUES (7234, 14, 888, 6652);
INSERT INTO 'albumsrecordingsmap' VALUES (7235, 15, 888, 6653);
INSERT INTO 'albumsrecordingsmap' VALUES (7236, 16, 888, 6654);
INSERT INTO 'albumsrecordingsmap' VALUES (7237, 17, 888, 6655);
INSERT INTO 'albumsrecordingsmap' VALUES (7238, 18, 888, 6656);
INSERT INTO 'albumsrecordingsmap' VALUES (7239, 1, 889, 6657);
INSERT INTO 'albumsrecordingsmap' VALUES (7240, 2, 889, 6658);
INSERT INTO 'albumsrecordingsmap' VALUES (7241, 3, 889, 6659);
INSERT INTO 'albumsrecordingsmap' VALUES (7242, 4, 889, 6660);
INSERT INTO 'albumsrecordingsmap' VALUES (7243, 5, 889, 6661);
INSERT INTO 'albumsrecordingsmap' VALUES (7244, 6, 889, 6662);
INSERT INTO 'albumsrecordingsmap' VALUES (7245, 7, 889, 6663);
INSERT INTO 'albumsrecordingsmap' VALUES (7246, 8, 889, 6664);
INSERT INTO 'albumsrecordingsmap' VALUES (7247, 9, 889, 6665);
INSERT INTO 'albumsrecordingsmap' VALUES (7248, 10, 889, 6666);
INSERT INTO 'albumsrecordingsmap' VALUES (7249, 11, 889, 6667);
INSERT INTO 'albumsrecordingsmap' VALUES (7250, 12, 889, 6668);
INSERT INTO 'albumsrecordingsmap' VALUES (7251, 13, 889, 6669);
INSERT INTO 'albumsrecordingsmap' VALUES (7252, 14, 889, 6670);
INSERT INTO 'albumsrecordingsmap' VALUES (7253, 15, 889, 6671);
INSERT INTO 'albumsrecordingsmap' VALUES (7254, 16, 889, 6672);
INSERT INTO 'albumsrecordingsmap' VALUES (7255, 1, 890, 6673);
INSERT INTO 'albumsrecordingsmap' VALUES (7256, 2, 890, 6674);
INSERT INTO 'albumsrecordingsmap' VALUES (7257, 3, 890, 6675);
INSERT INTO 'albumsrecordingsmap' VALUES (7258, 4, 890, 6676);
INSERT INTO 'albumsrecordingsmap' VALUES (7259, 5, 890, 6677);
INSERT INTO 'albumsrecordingsmap' VALUES (7260, 6, 890, 6678);
INSERT INTO 'albumsrecordingsmap' VALUES (7261, 7, 890, 6679);
INSERT INTO 'albumsrecordingsmap' VALUES (7262, 8, 890, 6680);
INSERT INTO 'albumsrecordingsmap' VALUES (7263, 9, 890, 6681);
INSERT INTO 'albumsrecordingsmap' VALUES (7264, 1, 891, 6682);
INSERT INTO 'albumsrecordingsmap' VALUES (7265, 2, 891, 6683);
INSERT INTO 'albumsrecordingsmap' VALUES (7266, 3, 891, 6684);
INSERT INTO 'albumsrecordingsmap' VALUES (7267, 4, 891, 6685);
INSERT INTO 'albumsrecordingsmap' VALUES (7268, 5, 891, 6686);
INSERT INTO 'albumsrecordingsmap' VALUES (7269, 6, 891, 6687);
INSERT INTO 'albumsrecordingsmap' VALUES (7270, 7, 891, 6688);
INSERT INTO 'albumsrecordingsmap' VALUES (7271, 8, 891, 6689);
INSERT INTO 'albumsrecordingsmap' VALUES (7272, 9, 891, 6690);
INSERT INTO 'albumsrecordingsmap' VALUES (7273, 10, 891, 6691);
INSERT INTO 'albumsrecordingsmap' VALUES (7274, 11, 891, 6692);
INSERT INTO 'albumsrecordingsmap' VALUES (7275, 12, 891, 6693);
INSERT INTO 'albumsrecordingsmap' VALUES (7276, 1, 892, 6694);
INSERT INTO 'albumsrecordingsmap' VALUES (7277, 2, 892, 6695);
INSERT INTO 'albumsrecordingsmap' VALUES (7278, 3, 892, 6696);
INSERT INTO 'albumsrecordingsmap' VALUES (7279, 4, 892, 6697);
INSERT INTO 'albumsrecordingsmap' VALUES (7280, 5, 892, 6698);
INSERT INTO 'albumsrecordingsmap' VALUES (7281, 6, 892, 6699);
INSERT INTO 'albumsrecordingsmap' VALUES (7282, 7, 892, 6700);
INSERT INTO 'albumsrecordingsmap' VALUES (7283, 8, 892, 6701);
INSERT INTO 'albumsrecordingsmap' VALUES (7284, 9, 892, 6702);
INSERT INTO 'albumsrecordingsmap' VALUES (7285, 10, 892, 6703);
INSERT INTO 'albumsrecordingsmap' VALUES (7286, 11, 892, 6704);
INSERT INTO 'albumsrecordingsmap' VALUES (7287, 12, 892, 6705);
INSERT INTO 'albumsrecordingsmap' VALUES (7288, 13, 892, 6706);
INSERT INTO 'albumsrecordingsmap' VALUES (7289, 14, 892, 6707);
INSERT INTO 'albumsrecordingsmap' VALUES (7290, 15, 892, 6708);
INSERT INTO 'albumsrecordingsmap' VALUES (7291, 16, 892, 6709);
INSERT INTO 'albumsrecordingsmap' VALUES (7292, 1, 893, 6710);
INSERT INTO 'albumsrecordingsmap' VALUES (7293, 2, 893, 6711);
INSERT INTO 'albumsrecordingsmap' VALUES (7294, 3, 893, 6712);
INSERT INTO 'albumsrecordingsmap' VALUES (7295, 4, 893, 6713);
INSERT INTO 'albumsrecordingsmap' VALUES (7296, 5, 893, 6714);
INSERT INTO 'albumsrecordingsmap' VALUES (7297, 6, 893, 6715);
INSERT INTO 'albumsrecordingsmap' VALUES (7298, 7, 893, 6716);
INSERT INTO 'albumsrecordingsmap' VALUES (7299, 8, 893, 6717);
INSERT INTO 'albumsrecordingsmap' VALUES (7300, 9, 893, 6718);
INSERT INTO 'albumsrecordingsmap' VALUES (7301, 10, 893, 6719);
INSERT INTO 'albumsrecordingsmap' VALUES (7302, 11, 893, 6720);
INSERT INTO 'albumsrecordingsmap' VALUES (7303, 12, 893, 6721);
INSERT INTO 'albumsrecordingsmap' VALUES (7304, 1, 894, 6722);
INSERT INTO 'albumsrecordingsmap' VALUES (7305, 2, 894, 6723);
INSERT INTO 'albumsrecordingsmap' VALUES (7306, 3, 894, 6724);
INSERT INTO 'albumsrecordingsmap' VALUES (7307, 4, 894, 6725);
INSERT INTO 'albumsrecordingsmap' VALUES (7308, 5, 894, 6726);
INSERT INTO 'albumsrecordingsmap' VALUES (7309, 6, 894, 6727);
INSERT INTO 'albumsrecordingsmap' VALUES (7310, 7, 894, 6728);
INSERT INTO 'albumsrecordingsmap' VALUES (7311, 8, 894, 6729);
INSERT INTO 'albumsrecordingsmap' VALUES (7312, 9, 894, 6730);
INSERT INTO 'albumsrecordingsmap' VALUES (7313, 10, 894, 6731);
INSERT INTO 'albumsrecordingsmap' VALUES (7314, 11, 894, 6732);
INSERT INTO 'albumsrecordingsmap' VALUES (7315, 12, 894, 6733);
INSERT INTO 'albumsrecordingsmap' VALUES (7316, 13, 894, 6734);
INSERT INTO 'albumsrecordingsmap' VALUES (7317, 14, 894, 6735);
INSERT INTO 'albumsrecordingsmap' VALUES (7318, 15, 894, 6736);
INSERT INTO 'albumsrecordingsmap' VALUES (7319, 16, 894, 6737);
INSERT INTO 'albumsrecordingsmap' VALUES (7320, 17, 894, 6738);
INSERT INTO 'albumsrecordingsmap' VALUES (7321, 18, 894, 6739);
INSERT INTO 'albumsrecordingsmap' VALUES (7322, 19, 894, 6740);
INSERT INTO 'albumsrecordingsmap' VALUES (7323, 1, 895, 6741);
INSERT INTO 'albumsrecordingsmap' VALUES (7324, 2, 895, 6742);
INSERT INTO 'albumsrecordingsmap' VALUES (7325, 3, 895, 6743);
INSERT INTO 'albumsrecordingsmap' VALUES (7326, 4, 895, 6744);
INSERT INTO 'albumsrecordingsmap' VALUES (7327, 5, 895, 6745);
INSERT INTO 'albumsrecordingsmap' VALUES (7328, 6, 895, 6746);
INSERT INTO 'albumsrecordingsmap' VALUES (7329, 7, 895, 6747);
INSERT INTO 'albumsrecordingsmap' VALUES (7330, 8, 895, 6748);
INSERT INTO 'albumsrecordingsmap' VALUES (7331, 9, 895, 6749);
INSERT INTO 'albumsrecordingsmap' VALUES (7332, 10, 895, 6750);
INSERT INTO 'albumsrecordingsmap' VALUES (7333, 11, 895, 6751);
INSERT INTO 'albumsrecordingsmap' VALUES (7334, 12, 895, 6752);
INSERT INTO 'albumsrecordingsmap' VALUES (7335, 13, 895, 6753);
INSERT INTO 'albumsrecordingsmap' VALUES (7336, 14, 895, 6754);
INSERT INTO 'albumsrecordingsmap' VALUES (7337, 15, 895, 6755);
INSERT INTO 'albumsrecordingsmap' VALUES (7338, 1, 896, 6756);
INSERT INTO 'albumsrecordingsmap' VALUES (7339, 2, 896, 6757);
INSERT INTO 'albumsrecordingsmap' VALUES (7340, 3, 896, 6758);
INSERT INTO 'albumsrecordingsmap' VALUES (7341, 4, 896, 6759);
INSERT INTO 'albumsrecordingsmap' VALUES (7342, 5, 896, 6760);
INSERT INTO 'albumsrecordingsmap' VALUES (7343, 6, 896, 6761);
INSERT INTO 'albumsrecordingsmap' VALUES (7344, 7, 896, 6762);
INSERT INTO 'albumsrecordingsmap' VALUES (7345, 8, 896, 6763);
INSERT INTO 'albumsrecordingsmap' VALUES (7346, 9, 896, 6764);
INSERT INTO 'albumsrecordingsmap' VALUES (7347, 10, 896, 6765);
INSERT INTO 'albumsrecordingsmap' VALUES (7348, 11, 896, 6766);
INSERT INTO 'albumsrecordingsmap' VALUES (7349, 12, 896, 6767);
INSERT INTO 'albumsrecordingsmap' VALUES (7350, 13, 896, 6768);
INSERT INTO 'albumsrecordingsmap' VALUES (7351, 14, 896, 6769);
INSERT INTO 'albumsrecordingsmap' VALUES (7352, 15, 896, 6770);
INSERT INTO 'albumsrecordingsmap' VALUES (7353, 16, 896, 6771);
INSERT INTO 'albumsrecordingsmap' VALUES (7354, 1, 897, 6772);
INSERT INTO 'albumsrecordingsmap' VALUES (7355, 2, 897, 6773);
INSERT INTO 'albumsrecordingsmap' VALUES (7356, 3, 897, 6774);
INSERT INTO 'albumsrecordingsmap' VALUES (7357, 4, 897, 6775);
INSERT INTO 'albumsrecordingsmap' VALUES (7358, 5, 897, 6776);
INSERT INTO 'albumsrecordingsmap' VALUES (7359, 6, 897, 6777);
INSERT INTO 'albumsrecordingsmap' VALUES (7360, 7, 897, 6778);
INSERT INTO 'albumsrecordingsmap' VALUES (7361, 8, 897, 6779);
INSERT INTO 'albumsrecordingsmap' VALUES (7362, 9, 897, 6780);
INSERT INTO 'albumsrecordingsmap' VALUES (7363, 10, 897, 6781);
INSERT INTO 'albumsrecordingsmap' VALUES (7364, 11, 897, 6782);
INSERT INTO 'albumsrecordingsmap' VALUES (7365, 1, 898, 6783);
INSERT INTO 'albumsrecordingsmap' VALUES (7366, 2, 898, 6784);
INSERT INTO 'albumsrecordingsmap' VALUES (7367, 3, 898, 6785);
INSERT INTO 'albumsrecordingsmap' VALUES (7368, 4, 898, 6786);
INSERT INTO 'albumsrecordingsmap' VALUES (7369, 5, 898, 6787);
INSERT INTO 'albumsrecordingsmap' VALUES (7370, 6, 898, 6788);
INSERT INTO 'albumsrecordingsmap' VALUES (7371, 7, 898, 6789);
INSERT INTO 'albumsrecordingsmap' VALUES (7372, 8, 898, 6790);
INSERT INTO 'albumsrecordingsmap' VALUES (7373, 9, 898, 6791);
INSERT INTO 'albumsrecordingsmap' VALUES (7374, 10, 898, 6792);
INSERT INTO 'albumsrecordingsmap' VALUES (7375, 11, 898, 6793);
INSERT INTO 'albumsrecordingsmap' VALUES (7376, 12, 898, 6794);
INSERT INTO 'albumsrecordingsmap' VALUES (7377, 13, 898, 6795);
INSERT INTO 'albumsrecordingsmap' VALUES (7378, 14, 898, 6796);
INSERT INTO 'albumsrecordingsmap' VALUES (7379, 1, 899, 6809);
INSERT INTO 'albumsrecordingsmap' VALUES (7380, 2, 899, 6810);
INSERT INTO 'albumsrecordingsmap' VALUES (7381, 3, 899, 6811);
INSERT INTO 'albumsrecordingsmap' VALUES (7382, 4, 899, 6812);
INSERT INTO 'albumsrecordingsmap' VALUES (7383, 5, 899, 6813);
INSERT INTO 'albumsrecordingsmap' VALUES (7384, 6, 899, 6814);
INSERT INTO 'albumsrecordingsmap' VALUES (7385, 7, 899, 6815);
INSERT INTO 'albumsrecordingsmap' VALUES (7386, 8, 899, 6816);
INSERT INTO 'albumsrecordingsmap' VALUES (7387, 9, 899, 6817);
INSERT INTO 'albumsrecordingsmap' VALUES (7388, 10, 899, 6818);
INSERT INTO 'albumsrecordingsmap' VALUES (7389, 11, 899, 6819);
INSERT INTO 'albumsrecordingsmap' VALUES (7390, 12, 899, 6820);
INSERT INTO 'albumsrecordingsmap' VALUES (7391, 1, 900, 6821);
INSERT INTO 'albumsrecordingsmap' VALUES (7392, 2, 900, 6822);
INSERT INTO 'albumsrecordingsmap' VALUES (7393, 3, 900, 6823);
INSERT INTO 'albumsrecordingsmap' VALUES (7394, 4, 900, 6824);
INSERT INTO 'albumsrecordingsmap' VALUES (7395, 5, 900, 6825);
INSERT INTO 'albumsrecordingsmap' VALUES (7396, 6, 900, 6826);
INSERT INTO 'albumsrecordingsmap' VALUES (7397, 7, 900, 6827);
INSERT INTO 'albumsrecordingsmap' VALUES (7398, 8, 900, 6828);
INSERT INTO 'albumsrecordingsmap' VALUES (7399, 9, 900, 6829);
INSERT INTO 'albumsrecordingsmap' VALUES (7400, 10, 900, 6830);
INSERT INTO 'albumsrecordingsmap' VALUES (7401, 11, 900, 6831);
INSERT INTO 'albumsrecordingsmap' VALUES (7402, 12, 900, 6832);
INSERT INTO 'albumsrecordingsmap' VALUES (7403, 1, 901, 6859);
INSERT INTO 'albumsrecordingsmap' VALUES (7404, 2, 901, 6860);
INSERT INTO 'albumsrecordingsmap' VALUES (7405, 3, 901, 6861);
INSERT INTO 'albumsrecordingsmap' VALUES (7406, 4, 901, 6862);
INSERT INTO 'albumsrecordingsmap' VALUES (7407, 5, 901, 6863);
INSERT INTO 'albumsrecordingsmap' VALUES (7408, 6, 901, 6864);
INSERT INTO 'albumsrecordingsmap' VALUES (7409, 7, 901, 6865);
INSERT INTO 'albumsrecordingsmap' VALUES (7410, 8, 901, 6866);
INSERT INTO 'albumsrecordingsmap' VALUES (7411, 9, 901, 6867);
INSERT INTO 'albumsrecordingsmap' VALUES (7412, 10, 901, 6868);
INSERT INTO 'albumsrecordingsmap' VALUES (7413, 11, 901, 6869);
INSERT INTO 'albumsrecordingsmap' VALUES (7414, 12, 901, 6870);
INSERT INTO 'albumsrecordingsmap' VALUES (7415, 13, 901, 6871);
INSERT INTO 'albumsrecordingsmap' VALUES (7416, 14, 901, 6872);
INSERT INTO 'albumsrecordingsmap' VALUES (7417, 15, 901, 6873);
INSERT INTO 'albumsrecordingsmap' VALUES (7418, 16, 901, 6874);
INSERT INTO 'albumsrecordingsmap' VALUES (7419, 17, 901, 6875);
INSERT INTO 'albumsrecordingsmap' VALUES (7420, 18, 901, 6876);
INSERT INTO 'albumsrecordingsmap' VALUES (7421, 1, 902, 6891);
INSERT INTO 'albumsrecordingsmap' VALUES (7422, 2, 902, 6892);
INSERT INTO 'albumsrecordingsmap' VALUES (7423, 3, 902, 6893);
INSERT INTO 'albumsrecordingsmap' VALUES (7424, 4, 902, 6894);
INSERT INTO 'albumsrecordingsmap' VALUES (7425, 5, 902, 6895);
INSERT INTO 'albumsrecordingsmap' VALUES (7426, 6, 902, 6896);
INSERT INTO 'albumsrecordingsmap' VALUES (7427, 7, 902, 6897);
INSERT INTO 'albumsrecordingsmap' VALUES (7428, 8, 902, 6898);
INSERT INTO 'albumsrecordingsmap' VALUES (7429, 9, 902, 6899);
INSERT INTO 'albumsrecordingsmap' VALUES (7430, 10, 902, 6900);
INSERT INTO 'albumsrecordingsmap' VALUES (7431, 11, 902, 6901);
INSERT INTO 'albumsrecordingsmap' VALUES (7432, 12, 902, 6902);
INSERT INTO 'albumsrecordingsmap' VALUES (7433, 13, 902, 6903);
INSERT INTO 'albumsrecordingsmap' VALUES (7434, 14, 902, 6904);
INSERT INTO 'albumsrecordingsmap' VALUES (7435, 1, 903, 6905);
INSERT INTO 'albumsrecordingsmap' VALUES (7436, 2, 903, 6906);
INSERT INTO 'albumsrecordingsmap' VALUES (7437, 3, 903, 6907);
INSERT INTO 'albumsrecordingsmap' VALUES (7438, 4, 903, 6908);
INSERT INTO 'albumsrecordingsmap' VALUES (7439, 5, 903, 6909);
INSERT INTO 'albumsrecordingsmap' VALUES (7440, 6, 903, 6910);
INSERT INTO 'albumsrecordingsmap' VALUES (7441, 7, 903, 6911);
INSERT INTO 'albumsrecordingsmap' VALUES (7442, 8, 903, 6912);
INSERT INTO 'albumsrecordingsmap' VALUES (7443, 9, 903, 6913);
INSERT INTO 'albumsrecordingsmap' VALUES (7444, 10, 903, 6914);
INSERT INTO 'albumsrecordingsmap' VALUES (7445, 11, 903, 6915);
INSERT INTO 'albumsrecordingsmap' VALUES (7446, 12, 903, 6916);
INSERT INTO 'albumsrecordingsmap' VALUES (7447, 13, 903, 6917);
INSERT INTO 'albumsrecordingsmap' VALUES (7448, 14, 903, 6918);
INSERT INTO 'albumsrecordingsmap' VALUES (7449, 15, 903, 6919);
INSERT INTO 'albumsrecordingsmap' VALUES (7450, 16, 903, 6920);
INSERT INTO 'albumsrecordingsmap' VALUES (7451, 17, 903, 6921);
INSERT INTO 'albumsrecordingsmap' VALUES (7452, 18, 903, 6922);
INSERT INTO 'albumsrecordingsmap' VALUES (7453, 19, 903, 6923);
INSERT INTO 'albumsrecordingsmap' VALUES (7454, 20, 903, 6924);
INSERT INTO 'albumsrecordingsmap' VALUES (7455, 1, 904, 6925);
INSERT INTO 'albumsrecordingsmap' VALUES (7456, 2, 904, 6926);
INSERT INTO 'albumsrecordingsmap' VALUES (7457, 3, 904, 6927);
INSERT INTO 'albumsrecordingsmap' VALUES (7458, 4, 904, 6928);
INSERT INTO 'albumsrecordingsmap' VALUES (7459, 5, 904, 6929);
INSERT INTO 'albumsrecordingsmap' VALUES (7460, 6, 904, 6930);
INSERT INTO 'albumsrecordingsmap' VALUES (7461, 7, 904, 6931);
INSERT INTO 'albumsrecordingsmap' VALUES (7462, 8, 904, 6932);
INSERT INTO 'albumsrecordingsmap' VALUES (7463, 9, 904, 6933);
INSERT INTO 'albumsrecordingsmap' VALUES (7464, 10, 904, 6934);
INSERT INTO 'albumsrecordingsmap' VALUES (7465, 11, 904, 6935);
INSERT INTO 'albumsrecordingsmap' VALUES (7466, 12, 904, 6936);
INSERT INTO 'albumsrecordingsmap' VALUES (7467, 13, 904, 6937);
INSERT INTO 'albumsrecordingsmap' VALUES (7468, 14, 904, 6938);
INSERT INTO 'albumsrecordingsmap' VALUES (7469, 15, 904, 6939);
INSERT INTO 'albumsrecordingsmap' VALUES (7470, 16, 904, 6940);
INSERT INTO 'albumsrecordingsmap' VALUES (7471, 1, 905, 6941);
INSERT INTO 'albumsrecordingsmap' VALUES (7472, 2, 905, 6942);
INSERT INTO 'albumsrecordingsmap' VALUES (7473, 3, 905, 6943);
INSERT INTO 'albumsrecordingsmap' VALUES (7474, 4, 905, 6944);
INSERT INTO 'albumsrecordingsmap' VALUES (7475, 5, 905, 6945);
INSERT INTO 'albumsrecordingsmap' VALUES (7476, 6, 905, 6946);
INSERT INTO 'albumsrecordingsmap' VALUES (7477, 7, 905, 6947);
INSERT INTO 'albumsrecordingsmap' VALUES (7478, 8, 905, 6948);
INSERT INTO 'albumsrecordingsmap' VALUES (7479, 9, 905, 6949);
INSERT INTO 'albumsrecordingsmap' VALUES (7480, 10, 905, 6950);
INSERT INTO 'albumsrecordingsmap' VALUES (7481, 11, 905, 6951);
INSERT INTO 'albumsrecordingsmap' VALUES (7482, 12, 905, 6952);
INSERT INTO 'albumsrecordingsmap' VALUES (7483, 13, 905, 6953);
INSERT INTO 'albumsrecordingsmap' VALUES (7484, 14, 905, 6954);
INSERT INTO 'albumsrecordingsmap' VALUES (7485, 15, 905, 6955);
INSERT INTO 'albumsrecordingsmap' VALUES (7486, 1, 906, 6956);
INSERT INTO 'albumsrecordingsmap' VALUES (7487, 2, 906, 6957);
INSERT INTO 'albumsrecordingsmap' VALUES (7488, 3, 906, 6958);
INSERT INTO 'albumsrecordingsmap' VALUES (7489, 4, 906, 6959);
INSERT INTO 'albumsrecordingsmap' VALUES (7490, 5, 906, 6960);
INSERT INTO 'albumsrecordingsmap' VALUES (7491, 6, 906, 6961);
INSERT INTO 'albumsrecordingsmap' VALUES (7492, 7, 906, 6962);
INSERT INTO 'albumsrecordingsmap' VALUES (7493, 8, 906, 6963);
INSERT INTO 'albumsrecordingsmap' VALUES (7494, 9, 906, 6964);
INSERT INTO 'albumsrecordingsmap' VALUES (7495, 10, 906, 6965);
INSERT INTO 'albumsrecordingsmap' VALUES (7496, 11, 906, 6966);
INSERT INTO 'albumsrecordingsmap' VALUES (7497, 12, 906, 6967);
INSERT INTO 'albumsrecordingsmap' VALUES (7498, 13, 906, 6968);
INSERT INTO 'albumsrecordingsmap' VALUES (7499, 14, 906, 6969);
INSERT INTO 'albumsrecordingsmap' VALUES (7500, 15, 906, 6970);
INSERT INTO 'albumsrecordingsmap' VALUES (7501, 1, 907, 6971);
INSERT INTO 'albumsrecordingsmap' VALUES (7502, 2, 907, 6972);
INSERT INTO 'albumsrecordingsmap' VALUES (7503, 3, 907, 6973);
INSERT INTO 'albumsrecordingsmap' VALUES (7504, 4, 907, 6974);
INSERT INTO 'albumsrecordingsmap' VALUES (7505, 5, 907, 6975);
INSERT INTO 'albumsrecordingsmap' VALUES (7506, 6, 907, 6976);
INSERT INTO 'albumsrecordingsmap' VALUES (7507, 7, 907, 6977);
INSERT INTO 'albumsrecordingsmap' VALUES (7508, 8, 907, 6978);
INSERT INTO 'albumsrecordingsmap' VALUES (7509, 9, 907, 6979);
INSERT INTO 'albumsrecordingsmap' VALUES (7510, 10, 907, 6980);
INSERT INTO 'albumsrecordingsmap' VALUES (7511, 11, 907, 6981);
INSERT INTO 'albumsrecordingsmap' VALUES (7512, 12, 907, 6982);
INSERT INTO 'albumsrecordingsmap' VALUES (7513, 13, 907, 6983);
INSERT INTO 'albumsrecordingsmap' VALUES (7514, 14, 907, 6984);
INSERT INTO 'albumsrecordingsmap' VALUES (7515, 15, 907, 6985);
INSERT INTO 'albumsrecordingsmap' VALUES (7516, 16, 907, 6986);
INSERT INTO 'albumsrecordingsmap' VALUES (7517, 17, 907, 6987);
INSERT INTO 'albumsrecordingsmap' VALUES (9970, 11, 1056, 9397);
INSERT INTO 'albumsrecordingsmap' VALUES (9971, 12, 1056, 9398);
INSERT INTO 'albumsrecordingsmap' VALUES (9972, 13, 1056, 9399);
INSERT INTO 'albumsrecordingsmap' VALUES (9973, 14, 1056, 9400);
INSERT INTO 'albumsrecordingsmap' VALUES (9974, 15, 1056, 9401);
INSERT INTO 'albumsrecordingsmap' VALUES (10818, 10, 1113, 10224);
INSERT INTO 'albumsrecordingsmap' VALUES (10819, 11, 1113, 10225);
INSERT INTO 'albumsrecordingsmap' VALUES (10820, 12, 1113, 10226);
INSERT INTO 'albumsrecordingsmap' VALUES (7533, 1, 909, 7003);
INSERT INTO 'albumsrecordingsmap' VALUES (7534, 2, 909, 7004);
INSERT INTO 'albumsrecordingsmap' VALUES (7535, 3, 909, 7005);
INSERT INTO 'albumsrecordingsmap' VALUES (7536, 4, 909, 7006);
INSERT INTO 'albumsrecordingsmap' VALUES (7537, 5, 909, 7007);
INSERT INTO 'albumsrecordingsmap' VALUES (7538, 6, 909, 7008);
INSERT INTO 'albumsrecordingsmap' VALUES (7539, 7, 909, 7009);
INSERT INTO 'albumsrecordingsmap' VALUES (7540, 8, 909, 7010);
INSERT INTO 'albumsrecordingsmap' VALUES (7541, 9, 909, 7011);
INSERT INTO 'albumsrecordingsmap' VALUES (7542, 10, 909, 7012);
INSERT INTO 'albumsrecordingsmap' VALUES (7543, 11, 909, 7013);
INSERT INTO 'albumsrecordingsmap' VALUES (7544, 12, 909, 7014);
INSERT INTO 'albumsrecordingsmap' VALUES (7545, 13, 909, 7015);
INSERT INTO 'albumsrecordingsmap' VALUES (7546, 14, 909, 7016);
INSERT INTO 'albumsrecordingsmap' VALUES (7547, 1, 910, 7017);
INSERT INTO 'albumsrecordingsmap' VALUES (7548, 2, 910, 7018);
INSERT INTO 'albumsrecordingsmap' VALUES (7549, 3, 910, 7019);
INSERT INTO 'albumsrecordingsmap' VALUES (7550, 4, 910, 7020);
INSERT INTO 'albumsrecordingsmap' VALUES (7551, 5, 910, 7021);
INSERT INTO 'albumsrecordingsmap' VALUES (7552, 6, 910, 7022);
INSERT INTO 'albumsrecordingsmap' VALUES (7553, 7, 910, 7023);
INSERT INTO 'albumsrecordingsmap' VALUES (7554, 8, 910, 7024);
INSERT INTO 'albumsrecordingsmap' VALUES (7555, 9, 910, 7025);
INSERT INTO 'albumsrecordingsmap' VALUES (7556, 10, 910, 7026);
INSERT INTO 'albumsrecordingsmap' VALUES (7557, 11, 910, 7027);
INSERT INTO 'albumsrecordingsmap' VALUES (7558, 12, 910, 7028);
INSERT INTO 'albumsrecordingsmap' VALUES (7559, 1, 911, 7029);
INSERT INTO 'albumsrecordingsmap' VALUES (7560, 2, 911, 7030);
INSERT INTO 'albumsrecordingsmap' VALUES (7561, 3, 911, 7031);
INSERT INTO 'albumsrecordingsmap' VALUES (7562, 4, 911, 7032);
INSERT INTO 'albumsrecordingsmap' VALUES (7563, 5, 911, 7033);
INSERT INTO 'albumsrecordingsmap' VALUES (7564, 6, 911, 7034);
INSERT INTO 'albumsrecordingsmap' VALUES (7565, 7, 911, 7035);
INSERT INTO 'albumsrecordingsmap' VALUES (7566, 8, 911, 7036);
INSERT INTO 'albumsrecordingsmap' VALUES (7567, 9, 911, 7037);
INSERT INTO 'albumsrecordingsmap' VALUES (7568, 10, 911, 7038);
INSERT INTO 'albumsrecordingsmap' VALUES (7569, 11, 911, 7039);
INSERT INTO 'albumsrecordingsmap' VALUES (7570, 12, 911, 7040);
INSERT INTO 'albumsrecordingsmap' VALUES (7571, 13, 911, 7041);
INSERT INTO 'albumsrecordingsmap' VALUES (7572, 14, 911, 7042);
INSERT INTO 'albumsrecordingsmap' VALUES (7573, 15, 911, 7043);
INSERT INTO 'albumsrecordingsmap' VALUES (7574, 16, 911, 7044);
INSERT INTO 'albumsrecordingsmap' VALUES (7602, 1, 913, 7072);
INSERT INTO 'albumsrecordingsmap' VALUES (7603, 2, 913, 7073);
INSERT INTO 'albumsrecordingsmap' VALUES (7604, 3, 913, 7074);
INSERT INTO 'albumsrecordingsmap' VALUES (7605, 4, 913, 7075);
INSERT INTO 'albumsrecordingsmap' VALUES (7606, 5, 913, 7076);
INSERT INTO 'albumsrecordingsmap' VALUES (7607, 6, 913, 7077);
INSERT INTO 'albumsrecordingsmap' VALUES (7608, 7, 913, 7078);
INSERT INTO 'albumsrecordingsmap' VALUES (7609, 8, 913, 7079);
INSERT INTO 'albumsrecordingsmap' VALUES (7610, 9, 913, 7080);
INSERT INTO 'albumsrecordingsmap' VALUES (7611, 10, 913, 7081);
INSERT INTO 'albumsrecordingsmap' VALUES (7612, 1, 914, 7082);
INSERT INTO 'albumsrecordingsmap' VALUES (7613, 2, 914, 7083);
INSERT INTO 'albumsrecordingsmap' VALUES (7614, 3, 914, 7084);
INSERT INTO 'albumsrecordingsmap' VALUES (7615, 4, 914, 7085);
INSERT INTO 'albumsrecordingsmap' VALUES (7616, 5, 914, 7086);
INSERT INTO 'albumsrecordingsmap' VALUES (7617, 6, 914, 7087);
INSERT INTO 'albumsrecordingsmap' VALUES (7618, 7, 914, 7088);
INSERT INTO 'albumsrecordingsmap' VALUES (7619, 8, 914, 7089);
INSERT INTO 'albumsrecordingsmap' VALUES (7620, 9, 914, 7090);
INSERT INTO 'albumsrecordingsmap' VALUES (7621, 10, 914, 7091);
INSERT INTO 'albumsrecordingsmap' VALUES (7622, 11, 914, 7092);
INSERT INTO 'albumsrecordingsmap' VALUES (7623, 12, 914, 7093);
INSERT INTO 'albumsrecordingsmap' VALUES (7624, 1, 915, 7094);
INSERT INTO 'albumsrecordingsmap' VALUES (7625, 2, 915, 7095);
INSERT INTO 'albumsrecordingsmap' VALUES (7626, 3, 915, 7096);
INSERT INTO 'albumsrecordingsmap' VALUES (7627, 4, 915, 7097);
INSERT INTO 'albumsrecordingsmap' VALUES (7628, 5, 915, 7098);
INSERT INTO 'albumsrecordingsmap' VALUES (7629, 6, 915, 7099);
INSERT INTO 'albumsrecordingsmap' VALUES (7630, 7, 915, 7100);
INSERT INTO 'albumsrecordingsmap' VALUES (7631, 8, 915, 7101);
INSERT INTO 'albumsrecordingsmap' VALUES (7632, 9, 915, 7102);
INSERT INTO 'albumsrecordingsmap' VALUES (7633, 10, 915, 7103);
INSERT INTO 'albumsrecordingsmap' VALUES (7634, 11, 915, 7104);
INSERT INTO 'albumsrecordingsmap' VALUES (7635, 12, 915, 7105);
INSERT INTO 'albumsrecordingsmap' VALUES (7636, 13, 915, 7106);
INSERT INTO 'albumsrecordingsmap' VALUES (7637, 14, 915, 7107);
INSERT INTO 'albumsrecordingsmap' VALUES (7638, 1, 916, 7108);
INSERT INTO 'albumsrecordingsmap' VALUES (7639, 2, 916, 7109);
INSERT INTO 'albumsrecordingsmap' VALUES (7640, 3, 916, 7110);
INSERT INTO 'albumsrecordingsmap' VALUES (7641, 4, 916, 7111);
INSERT INTO 'albumsrecordingsmap' VALUES (7642, 5, 916, 7112);
INSERT INTO 'albumsrecordingsmap' VALUES (7643, 6, 916, 7113);
INSERT INTO 'albumsrecordingsmap' VALUES (7644, 7, 916, 7114);
INSERT INTO 'albumsrecordingsmap' VALUES (7645, 8, 916, 7115);
INSERT INTO 'albumsrecordingsmap' VALUES (7646, 9, 916, 7116);
INSERT INTO 'albumsrecordingsmap' VALUES (10859, 1, 1118, 10265);
INSERT INTO 'albumsrecordingsmap' VALUES (10860, 2, 1118, 10266);
INSERT INTO 'albumsrecordingsmap' VALUES (10861, 3, 1118, 10267);
INSERT INTO 'albumsrecordingsmap' VALUES (7647, 10, 916, 7117);
INSERT INTO 'albumsrecordingsmap' VALUES (7648, 11, 916, 7118);
INSERT INTO 'albumsrecordingsmap' VALUES (7649, 12, 916, 7119);
INSERT INTO 'albumsrecordingsmap' VALUES (7650, 13, 916, 7120);
INSERT INTO 'albumsrecordingsmap' VALUES (7651, 14, 916, 7121);
INSERT INTO 'albumsrecordingsmap' VALUES (7652, 15, 916, 7122);
INSERT INTO 'albumsrecordingsmap' VALUES (7653, 16, 916, 7123);
INSERT INTO 'albumsrecordingsmap' VALUES (7654, 17, 916, 7124);
INSERT INTO 'albumsrecordingsmap' VALUES (7655, 18, 916, 7125);
INSERT INTO 'albumsrecordingsmap' VALUES (7656, 19, 916, 7126);
INSERT INTO 'albumsrecordingsmap' VALUES (7657, 20, 916, 7127);
INSERT INTO 'albumsrecordingsmap' VALUES (7658, 21, 916, 7128);
INSERT INTO 'albumsrecordingsmap' VALUES (7659, 1, 917, 7129);
INSERT INTO 'albumsrecordingsmap' VALUES (7660, 2, 917, 7130);
INSERT INTO 'albumsrecordingsmap' VALUES (7661, 3, 917, 7131);
INSERT INTO 'albumsrecordingsmap' VALUES (7662, 4, 917, 7132);
INSERT INTO 'albumsrecordingsmap' VALUES (7663, 5, 917, 7133);
INSERT INTO 'albumsrecordingsmap' VALUES (7664, 6, 917, 7134);
INSERT INTO 'albumsrecordingsmap' VALUES (7665, 7, 917, 7135);
INSERT INTO 'albumsrecordingsmap' VALUES (7666, 8, 917, 7136);
INSERT INTO 'albumsrecordingsmap' VALUES (7667, 9, 917, 7137);
INSERT INTO 'albumsrecordingsmap' VALUES (7668, 10, 917, 7138);
INSERT INTO 'albumsrecordingsmap' VALUES (7669, 11, 917, 7139);
INSERT INTO 'albumsrecordingsmap' VALUES (7670, 12, 917, 7140);
INSERT INTO 'albumsrecordingsmap' VALUES (7671, 13, 917, 7141);
INSERT INTO 'albumsrecordingsmap' VALUES (7672, 14, 917, 7142);
INSERT INTO 'albumsrecordingsmap' VALUES (7673, 1, 918, 7143);
INSERT INTO 'albumsrecordingsmap' VALUES (7674, 2, 918, 7144);
INSERT INTO 'albumsrecordingsmap' VALUES (7675, 3, 918, 7145);
INSERT INTO 'albumsrecordingsmap' VALUES (7676, 4, 918, 7146);
INSERT INTO 'albumsrecordingsmap' VALUES (7677, 5, 918, 7147);
INSERT INTO 'albumsrecordingsmap' VALUES (7678, 6, 918, 7148);
INSERT INTO 'albumsrecordingsmap' VALUES (7679, 7, 918, 7149);
INSERT INTO 'albumsrecordingsmap' VALUES (7680, 8, 918, 7150);
INSERT INTO 'albumsrecordingsmap' VALUES (7731, 1, 922, 7201);
INSERT INTO 'albumsrecordingsmap' VALUES (7732, 2, 922, 7202);
INSERT INTO 'albumsrecordingsmap' VALUES (7733, 3, 922, 7203);
INSERT INTO 'albumsrecordingsmap' VALUES (7734, 4, 922, 7204);
INSERT INTO 'albumsrecordingsmap' VALUES (7735, 5, 922, 7205);
INSERT INTO 'albumsrecordingsmap' VALUES (7736, 6, 922, 7206);
INSERT INTO 'albumsrecordingsmap' VALUES (7737, 7, 922, 7207);
INSERT INTO 'albumsrecordingsmap' VALUES (7738, 8, 922, 7208);
INSERT INTO 'albumsrecordingsmap' VALUES (7739, 9, 922, 7209);
INSERT INTO 'albumsrecordingsmap' VALUES (7740, 10, 922, 7210);
INSERT INTO 'albumsrecordingsmap' VALUES (7741, 11, 922, 7211);
INSERT INTO 'albumsrecordingsmap' VALUES (7742, 12, 922, 7212);
INSERT INTO 'albumsrecordingsmap' VALUES (7743, 13, 922, 7213);
INSERT INTO 'albumsrecordingsmap' VALUES (7744, 14, 922, 7214);
INSERT INTO 'albumsrecordingsmap' VALUES (7745, 15, 922, 7215);
INSERT INTO 'albumsrecordingsmap' VALUES (7746, 16, 922, 7216);
INSERT INTO 'albumsrecordingsmap' VALUES (7747, 17, 922, 7217);
INSERT INTO 'albumsrecordingsmap' VALUES (7748, 1, 923, 7218);
INSERT INTO 'albumsrecordingsmap' VALUES (7749, 2, 923, 7219);
INSERT INTO 'albumsrecordingsmap' VALUES (7750, 3, 923, 7220);
INSERT INTO 'albumsrecordingsmap' VALUES (7751, 4, 923, 7221);
INSERT INTO 'albumsrecordingsmap' VALUES (7752, 5, 923, 7222);
INSERT INTO 'albumsrecordingsmap' VALUES (7753, 6, 923, 7223);
INSERT INTO 'albumsrecordingsmap' VALUES (7754, 7, 923, 7224);
INSERT INTO 'albumsrecordingsmap' VALUES (7755, 8, 923, 7225);
INSERT INTO 'albumsrecordingsmap' VALUES (7756, 9, 923, 7226);
INSERT INTO 'albumsrecordingsmap' VALUES (7757, 10, 923, 7227);
INSERT INTO 'albumsrecordingsmap' VALUES (7758, 11, 923, 7228);
INSERT INTO 'albumsrecordingsmap' VALUES (7759, 12, 923, 7229);
INSERT INTO 'albumsrecordingsmap' VALUES (7760, 13, 923, 7230);
INSERT INTO 'albumsrecordingsmap' VALUES (7761, 14, 923, 7231);
INSERT INTO 'albumsrecordingsmap' VALUES (7762, 15, 923, 7232);
INSERT INTO 'albumsrecordingsmap' VALUES (7763, 16, 923, 7233);
INSERT INTO 'albumsrecordingsmap' VALUES (7764, 17, 923, 7234);
INSERT INTO 'albumsrecordingsmap' VALUES (7765, 18, 923, 7235);
INSERT INTO 'albumsrecordingsmap' VALUES (7766, 1, 924, 7236);
INSERT INTO 'albumsrecordingsmap' VALUES (7767, 2, 924, 7237);
INSERT INTO 'albumsrecordingsmap' VALUES (7768, 3, 924, 7238);
INSERT INTO 'albumsrecordingsmap' VALUES (7769, 4, 924, 7239);
INSERT INTO 'albumsrecordingsmap' VALUES (7770, 5, 924, 7240);
INSERT INTO 'albumsrecordingsmap' VALUES (7771, 6, 924, 7241);
INSERT INTO 'albumsrecordingsmap' VALUES (7772, 7, 924, 7242);
INSERT INTO 'albumsrecordingsmap' VALUES (7773, 8, 924, 7243);
INSERT INTO 'albumsrecordingsmap' VALUES (7774, 9, 924, 7244);
INSERT INTO 'albumsrecordingsmap' VALUES (7775, 10, 924, 7245);
INSERT INTO 'albumsrecordingsmap' VALUES (7776, 11, 924, 7246);
INSERT INTO 'albumsrecordingsmap' VALUES (7777, 12, 924, 7247);
INSERT INTO 'albumsrecordingsmap' VALUES (7778, 13, 924, 7248);
INSERT INTO 'albumsrecordingsmap' VALUES (7779, 14, 924, 7249);
INSERT INTO 'albumsrecordingsmap' VALUES (7780, 15, 924, 7250);
INSERT INTO 'albumsrecordingsmap' VALUES (7781, 16, 924, 7251);
INSERT INTO 'albumsrecordingsmap' VALUES (7782, 17, 924, 7252);
INSERT INTO 'albumsrecordingsmap' VALUES (7783, 18, 924, 7253);
INSERT INTO 'albumsrecordingsmap' VALUES (7784, 19, 924, 7254);
INSERT INTO 'albumsrecordingsmap' VALUES (7785, 20, 924, 7255);
INSERT INTO 'albumsrecordingsmap' VALUES (7786, 1, 925, 7256);
INSERT INTO 'albumsrecordingsmap' VALUES (7787, 2, 925, 7257);
INSERT INTO 'albumsrecordingsmap' VALUES (7788, 3, 925, 7258);
INSERT INTO 'albumsrecordingsmap' VALUES (7789, 4, 925, 7259);
INSERT INTO 'albumsrecordingsmap' VALUES (7790, 5, 925, 7260);
INSERT INTO 'albumsrecordingsmap' VALUES (7791, 6, 925, 7261);
INSERT INTO 'albumsrecordingsmap' VALUES (7792, 7, 925, 7262);
INSERT INTO 'albumsrecordingsmap' VALUES (7793, 8, 925, 7263);
INSERT INTO 'albumsrecordingsmap' VALUES (7794, 9, 925, 7264);
INSERT INTO 'albumsrecordingsmap' VALUES (7795, 10, 925, 7265);
INSERT INTO 'albumsrecordingsmap' VALUES (7796, 11, 925, 7266);
INSERT INTO 'albumsrecordingsmap' VALUES (7797, 12, 925, 7267);
INSERT INTO 'albumsrecordingsmap' VALUES (7798, 13, 925, 7268);
INSERT INTO 'albumsrecordingsmap' VALUES (7799, 1, 926, 7269);
INSERT INTO 'albumsrecordingsmap' VALUES (7800, 2, 926, 7270);
INSERT INTO 'albumsrecordingsmap' VALUES (7801, 3, 926, 7271);
INSERT INTO 'albumsrecordingsmap' VALUES (7802, 4, 926, 7272);
INSERT INTO 'albumsrecordingsmap' VALUES (7803, 5, 926, 7273);
INSERT INTO 'albumsrecordingsmap' VALUES (7804, 6, 926, 7274);
INSERT INTO 'albumsrecordingsmap' VALUES (7805, 7, 926, 7275);
INSERT INTO 'albumsrecordingsmap' VALUES (7806, 8, 926, 7276);
INSERT INTO 'albumsrecordingsmap' VALUES (7807, 9, 926, 7277);
INSERT INTO 'albumsrecordingsmap' VALUES (7808, 10, 926, 7278);
INSERT INTO 'albumsrecordingsmap' VALUES (7809, 11, 926, 7279);
INSERT INTO 'albumsrecordingsmap' VALUES (7810, 1, 927, 7280);
INSERT INTO 'albumsrecordingsmap' VALUES (7811, 2, 927, 7281);
INSERT INTO 'albumsrecordingsmap' VALUES (7812, 3, 927, 7282);
INSERT INTO 'albumsrecordingsmap' VALUES (7813, 4, 927, 7283);
INSERT INTO 'albumsrecordingsmap' VALUES (7814, 5, 927, 7284);
INSERT INTO 'albumsrecordingsmap' VALUES (7815, 6, 927, 7285);
INSERT INTO 'albumsrecordingsmap' VALUES (7816, 7, 927, 7286);
INSERT INTO 'albumsrecordingsmap' VALUES (7817, 8, 927, 7287);
INSERT INTO 'albumsrecordingsmap' VALUES (7818, 9, 927, 7288);
INSERT INTO 'albumsrecordingsmap' VALUES (7819, 10, 927, 7289);
INSERT INTO 'albumsrecordingsmap' VALUES (7820, 11, 927, 7290);
INSERT INTO 'albumsrecordingsmap' VALUES (7821, 12, 927, 7291);
INSERT INTO 'albumsrecordingsmap' VALUES (7822, 13, 927, 7292);
INSERT INTO 'albumsrecordingsmap' VALUES (7823, 14, 927, 7293);
INSERT INTO 'albumsrecordingsmap' VALUES (7824, 1, 928, 7294);
INSERT INTO 'albumsrecordingsmap' VALUES (7825, 2, 928, 7295);
INSERT INTO 'albumsrecordingsmap' VALUES (7826, 3, 928, 7296);
INSERT INTO 'albumsrecordingsmap' VALUES (7827, 4, 928, 7297);
INSERT INTO 'albumsrecordingsmap' VALUES (7828, 5, 928, 7298);
INSERT INTO 'albumsrecordingsmap' VALUES (7829, 6, 928, 7299);
INSERT INTO 'albumsrecordingsmap' VALUES (7830, 7, 928, 7300);
INSERT INTO 'albumsrecordingsmap' VALUES (7831, 8, 928, 7301);
INSERT INTO 'albumsrecordingsmap' VALUES (7832, 9, 928, 7302);
INSERT INTO 'albumsrecordingsmap' VALUES (7833, 10, 928, 7303);
INSERT INTO 'albumsrecordingsmap' VALUES (7834, 11, 928, 7304);
INSERT INTO 'albumsrecordingsmap' VALUES (7835, 12, 928, 7305);
INSERT INTO 'albumsrecordingsmap' VALUES (7836, 13, 928, 7306);
INSERT INTO 'albumsrecordingsmap' VALUES (7837, 14, 928, 7307);
INSERT INTO 'albumsrecordingsmap' VALUES (7838, 15, 928, 7308);
INSERT INTO 'albumsrecordingsmap' VALUES (7839, 16, 928, 7309);
INSERT INTO 'albumsrecordingsmap' VALUES (7840, 1, 929, 7310);
INSERT INTO 'albumsrecordingsmap' VALUES (7841, 2, 929, 7311);
INSERT INTO 'albumsrecordingsmap' VALUES (7842, 3, 929, 7312);
INSERT INTO 'albumsrecordingsmap' VALUES (7843, 4, 929, 7313);
INSERT INTO 'albumsrecordingsmap' VALUES (7844, 5, 929, 7314);
INSERT INTO 'albumsrecordingsmap' VALUES (7845, 6, 929, 7315);
INSERT INTO 'albumsrecordingsmap' VALUES (7846, 7, 929, 7316);
INSERT INTO 'albumsrecordingsmap' VALUES (7847, 8, 929, 7317);
INSERT INTO 'albumsrecordingsmap' VALUES (7848, 9, 929, 7318);
INSERT INTO 'albumsrecordingsmap' VALUES (7849, 10, 929, 7319);
INSERT INTO 'albumsrecordingsmap' VALUES (7850, 11, 929, 7320);
INSERT INTO 'albumsrecordingsmap' VALUES (7851, 12, 929, 7321);
INSERT INTO 'albumsrecordingsmap' VALUES (7852, 13, 929, 7322);
INSERT INTO 'albumsrecordingsmap' VALUES (7853, 14, 929, 7323);
INSERT INTO 'albumsrecordingsmap' VALUES (7854, 1, 930, 7324);
INSERT INTO 'albumsrecordingsmap' VALUES (7855, 2, 930, 7325);
INSERT INTO 'albumsrecordingsmap' VALUES (7856, 3, 930, 7326);
INSERT INTO 'albumsrecordingsmap' VALUES (7857, 4, 930, 7327);
INSERT INTO 'albumsrecordingsmap' VALUES (7858, 5, 930, 7328);
INSERT INTO 'albumsrecordingsmap' VALUES (7859, 6, 930, 7329);
INSERT INTO 'albumsrecordingsmap' VALUES (7681, 9, 918, 7151);
INSERT INTO 'albumsrecordingsmap' VALUES (7682, 10, 918, 7152);
INSERT INTO 'albumsrecordingsmap' VALUES (7683, 11, 918, 7153);
INSERT INTO 'albumsrecordingsmap' VALUES (10821, 13, 1113, 10227);
INSERT INTO 'albumsrecordingsmap' VALUES (10822, 14, 1113, 10228);
INSERT INTO 'albumsrecordingsmap' VALUES (10823, 15, 1113, 10229);
INSERT INTO 'albumsrecordingsmap' VALUES (7860, 7, 930, 7330);
INSERT INTO 'albumsrecordingsmap' VALUES (7861, 8, 930, 7331);
INSERT INTO 'albumsrecordingsmap' VALUES (7862, 9, 930, 7332);
INSERT INTO 'albumsrecordingsmap' VALUES (7863, 10, 930, 7333);
INSERT INTO 'albumsrecordingsmap' VALUES (7864, 11, 930, 7334);
INSERT INTO 'albumsrecordingsmap' VALUES (7865, 12, 930, 7335);
INSERT INTO 'albumsrecordingsmap' VALUES (7866, 13, 930, 7336);
INSERT INTO 'albumsrecordingsmap' VALUES (7867, 14, 930, 7337);
INSERT INTO 'albumsrecordingsmap' VALUES (7868, 15, 930, 7338);
INSERT INTO 'albumsrecordingsmap' VALUES (7869, 16, 930, 7339);
INSERT INTO 'albumsrecordingsmap' VALUES (7870, 1, 931, 7340);
INSERT INTO 'albumsrecordingsmap' VALUES (7871, 2, 931, 7341);
INSERT INTO 'albumsrecordingsmap' VALUES (7872, 3, 931, 7342);
INSERT INTO 'albumsrecordingsmap' VALUES (7873, 4, 931, 7343);
INSERT INTO 'albumsrecordingsmap' VALUES (7874, 5, 931, 7344);
INSERT INTO 'albumsrecordingsmap' VALUES (7875, 6, 931, 7345);
INSERT INTO 'albumsrecordingsmap' VALUES (7876, 7, 931, 7346);
INSERT INTO 'albumsrecordingsmap' VALUES (7877, 8, 931, 7347);
INSERT INTO 'albumsrecordingsmap' VALUES (7878, 9, 931, 7348);
INSERT INTO 'albumsrecordingsmap' VALUES (7879, 10, 931, 7349);
INSERT INTO 'albumsrecordingsmap' VALUES (7880, 11, 931, 7350);
INSERT INTO 'albumsrecordingsmap' VALUES (7881, 12, 931, 7351);
INSERT INTO 'albumsrecordingsmap' VALUES (7882, 13, 931, 7352);
INSERT INTO 'albumsrecordingsmap' VALUES (7883, 14, 931, 7353);
INSERT INTO 'albumsrecordingsmap' VALUES (7884, 15, 931, 7354);
INSERT INTO 'albumsrecordingsmap' VALUES (7885, 16, 931, 7355);
INSERT INTO 'albumsrecordingsmap' VALUES (7886, 1, 932, 7356);
INSERT INTO 'albumsrecordingsmap' VALUES (7887, 2, 932, 7357);
INSERT INTO 'albumsrecordingsmap' VALUES (7888, 3, 932, 7358);
INSERT INTO 'albumsrecordingsmap' VALUES (7889, 4, 932, 7359);
INSERT INTO 'albumsrecordingsmap' VALUES (7890, 5, 932, 7360);
INSERT INTO 'albumsrecordingsmap' VALUES (7891, 6, 932, 7361);
INSERT INTO 'albumsrecordingsmap' VALUES (7892, 7, 932, 7362);
INSERT INTO 'albumsrecordingsmap' VALUES (7893, 8, 932, 7363);
INSERT INTO 'albumsrecordingsmap' VALUES (7894, 9, 932, 7364);
INSERT INTO 'albumsrecordingsmap' VALUES (7895, 10, 932, 7365);
INSERT INTO 'albumsrecordingsmap' VALUES (7896, 11, 932, 7366);
INSERT INTO 'albumsrecordingsmap' VALUES (7897, 12, 932, 7367);
INSERT INTO 'albumsrecordingsmap' VALUES (7898, 13, 932, 7368);
INSERT INTO 'albumsrecordingsmap' VALUES (7899, 14, 932, 7369);
INSERT INTO 'albumsrecordingsmap' VALUES (7900, 15, 932, 7370);
INSERT INTO 'albumsrecordingsmap' VALUES (7901, 16, 932, 7371);
INSERT INTO 'albumsrecordingsmap' VALUES (7902, 17, 932, 7372);
INSERT INTO 'albumsrecordingsmap' VALUES (7903, 1, 933, 7373);
INSERT INTO 'albumsrecordingsmap' VALUES (7904, 2, 933, 7374);
INSERT INTO 'albumsrecordingsmap' VALUES (7905, 3, 933, 7375);
INSERT INTO 'albumsrecordingsmap' VALUES (7906, 4, 933, 7376);
INSERT INTO 'albumsrecordingsmap' VALUES (7907, 5, 933, 7377);
INSERT INTO 'albumsrecordingsmap' VALUES (7908, 6, 933, 7378);
INSERT INTO 'albumsrecordingsmap' VALUES (7909, 7, 933, 7379);
INSERT INTO 'albumsrecordingsmap' VALUES (7910, 8, 933, 7380);
INSERT INTO 'albumsrecordingsmap' VALUES (7911, 9, 933, 7381);
INSERT INTO 'albumsrecordingsmap' VALUES (7912, 10, 933, 7382);
INSERT INTO 'albumsrecordingsmap' VALUES (7913, 11, 933, 7383);
INSERT INTO 'albumsrecordingsmap' VALUES (7914, 12, 933, 7384);
INSERT INTO 'albumsrecordingsmap' VALUES (7915, 13, 933, 7385);
INSERT INTO 'albumsrecordingsmap' VALUES (7916, 1, 934, 7386);
INSERT INTO 'albumsrecordingsmap' VALUES (7917, 2, 934, 7387);
INSERT INTO 'albumsrecordingsmap' VALUES (7918, 3, 934, 7388);
INSERT INTO 'albumsrecordingsmap' VALUES (7919, 4, 934, 7389);
INSERT INTO 'albumsrecordingsmap' VALUES (7920, 5, 934, 7390);
INSERT INTO 'albumsrecordingsmap' VALUES (7921, 1, 935, 7391);
INSERT INTO 'albumsrecordingsmap' VALUES (7922, 2, 935, 7392);
INSERT INTO 'albumsrecordingsmap' VALUES (7923, 3, 935, 7393);
INSERT INTO 'albumsrecordingsmap' VALUES (7924, 4, 935, 7394);
INSERT INTO 'albumsrecordingsmap' VALUES (7925, 5, 935, 7395);
INSERT INTO 'albumsrecordingsmap' VALUES (7926, 6, 935, 7396);
INSERT INTO 'albumsrecordingsmap' VALUES (7927, 7, 935, 7397);
INSERT INTO 'albumsrecordingsmap' VALUES (7928, 8, 935, 7398);
INSERT INTO 'albumsrecordingsmap' VALUES (7929, 9, 935, 7399);
INSERT INTO 'albumsrecordingsmap' VALUES (7930, 10, 935, 7400);
INSERT INTO 'albumsrecordingsmap' VALUES (7931, 11, 935, 7401);
INSERT INTO 'albumsrecordingsmap' VALUES (7932, 12, 935, 7402);
INSERT INTO 'albumsrecordingsmap' VALUES (7933, 13, 935, 7403);
INSERT INTO 'albumsrecordingsmap' VALUES (7934, 14, 935, 7404);
INSERT INTO 'albumsrecordingsmap' VALUES (7935, 15, 935, 7405);
INSERT INTO 'albumsrecordingsmap' VALUES (7936, 16, 935, 7406);
INSERT INTO 'albumsrecordingsmap' VALUES (7937, 1, 936, 7407);
INSERT INTO 'albumsrecordingsmap' VALUES (7938, 2, 936, 7408);
INSERT INTO 'albumsrecordingsmap' VALUES (7939, 3, 936, 7409);
INSERT INTO 'albumsrecordingsmap' VALUES (7940, 4, 936, 7410);
INSERT INTO 'albumsrecordingsmap' VALUES (7941, 5, 936, 7411);
INSERT INTO 'albumsrecordingsmap' VALUES (7942, 6, 936, 7412);
INSERT INTO 'albumsrecordingsmap' VALUES (7943, 7, 936, 7413);
INSERT INTO 'albumsrecordingsmap' VALUES (7944, 8, 936, 7414);
INSERT INTO 'albumsrecordingsmap' VALUES (7945, 9, 936, 7415);
INSERT INTO 'albumsrecordingsmap' VALUES (7946, 10, 936, 7416);
INSERT INTO 'albumsrecordingsmap' VALUES (7947, 11, 936, 7417);
INSERT INTO 'albumsrecordingsmap' VALUES (7948, 12, 936, 7418);
INSERT INTO 'albumsrecordingsmap' VALUES (7949, 13, 936, 7419);
INSERT INTO 'albumsrecordingsmap' VALUES (7950, 14, 936, 7420);
INSERT INTO 'albumsrecordingsmap' VALUES (7951, 15, 936, 7421);
INSERT INTO 'albumsrecordingsmap' VALUES (7952, 16, 936, 7422);
INSERT INTO 'albumsrecordingsmap' VALUES (7953, 1, 937, 7423);
INSERT INTO 'albumsrecordingsmap' VALUES (7954, 2, 937, 7424);
INSERT INTO 'albumsrecordingsmap' VALUES (7955, 3, 937, 7425);
INSERT INTO 'albumsrecordingsmap' VALUES (7956, 4, 937, 7426);
INSERT INTO 'albumsrecordingsmap' VALUES (7957, 5, 937, 7427);
INSERT INTO 'albumsrecordingsmap' VALUES (7958, 6, 937, 7428);
INSERT INTO 'albumsrecordingsmap' VALUES (7959, 7, 937, 7429);
INSERT INTO 'albumsrecordingsmap' VALUES (7960, 8, 937, 7430);
INSERT INTO 'albumsrecordingsmap' VALUES (7961, 9, 937, 7431);
INSERT INTO 'albumsrecordingsmap' VALUES (7962, 10, 937, 7432);
INSERT INTO 'albumsrecordingsmap' VALUES (7963, 11, 937, 7433);
INSERT INTO 'albumsrecordingsmap' VALUES (7964, 12, 937, 7434);
INSERT INTO 'albumsrecordingsmap' VALUES (7965, 13, 937, 7435);
INSERT INTO 'albumsrecordingsmap' VALUES (7966, 14, 937, 7436);
INSERT INTO 'albumsrecordingsmap' VALUES (7967, 15, 937, 7437);
INSERT INTO 'albumsrecordingsmap' VALUES (7968, 16, 937, 7438);
INSERT INTO 'albumsrecordingsmap' VALUES (7969, 17, 937, 7439);
INSERT INTO 'albumsrecordingsmap' VALUES (7970, 18, 937, 7440);
INSERT INTO 'albumsrecordingsmap' VALUES (7971, 19, 937, 7441);
INSERT INTO 'albumsrecordingsmap' VALUES (7972, 20, 937, 7442);
INSERT INTO 'albumsrecordingsmap' VALUES (7973, 1, 938, 7443);
INSERT INTO 'albumsrecordingsmap' VALUES (7974, 2, 938, 7444);
INSERT INTO 'albumsrecordingsmap' VALUES (7975, 3, 938, 7445);
INSERT INTO 'albumsrecordingsmap' VALUES (7976, 4, 938, 7446);
INSERT INTO 'albumsrecordingsmap' VALUES (7977, 5, 938, 7447);
INSERT INTO 'albumsrecordingsmap' VALUES (7978, 6, 938, 7448);
INSERT INTO 'albumsrecordingsmap' VALUES (7979, 7, 938, 7449);
INSERT INTO 'albumsrecordingsmap' VALUES (7980, 8, 938, 7450);
INSERT INTO 'albumsrecordingsmap' VALUES (7981, 9, 938, 7451);
INSERT INTO 'albumsrecordingsmap' VALUES (7982, 10, 938, 7452);
INSERT INTO 'albumsrecordingsmap' VALUES (7983, 11, 938, 7453);
INSERT INTO 'albumsrecordingsmap' VALUES (7984, 12, 938, 7454);
INSERT INTO 'albumsrecordingsmap' VALUES (7985, 13, 938, 7455);
INSERT INTO 'albumsrecordingsmap' VALUES (7986, 14, 938, 7456);
INSERT INTO 'albumsrecordingsmap' VALUES (7987, 15, 938, 7457);
INSERT INTO 'albumsrecordingsmap' VALUES (7988, 16, 938, 7458);
INSERT INTO 'albumsrecordingsmap' VALUES (7989, 1, 939, 7459);
INSERT INTO 'albumsrecordingsmap' VALUES (7990, 2, 939, 7460);
INSERT INTO 'albumsrecordingsmap' VALUES (7991, 3, 939, 7461);
INSERT INTO 'albumsrecordingsmap' VALUES (7992, 4, 939, 7462);
INSERT INTO 'albumsrecordingsmap' VALUES (7993, 5, 939, 7463);
INSERT INTO 'albumsrecordingsmap' VALUES (7994, 6, 939, 7464);
INSERT INTO 'albumsrecordingsmap' VALUES (7995, 7, 939, 7465);
INSERT INTO 'albumsrecordingsmap' VALUES (7996, 8, 939, 7466);
INSERT INTO 'albumsrecordingsmap' VALUES (7997, 9, 939, 7467);
INSERT INTO 'albumsrecordingsmap' VALUES (7998, 10, 939, 7468);
INSERT INTO 'albumsrecordingsmap' VALUES (7999, 11, 939, 7469);
INSERT INTO 'albumsrecordingsmap' VALUES (8000, 12, 939, 7470);
INSERT INTO 'albumsrecordingsmap' VALUES (8001, 13, 939, 7471);
INSERT INTO 'albumsrecordingsmap' VALUES (8002, 14, 939, 7472);
INSERT INTO 'albumsrecordingsmap' VALUES (8003, 15, 939, 7473);
INSERT INTO 'albumsrecordingsmap' VALUES (8004, 16, 939, 7474);
INSERT INTO 'albumsrecordingsmap' VALUES (8005, 17, 939, 7475);
INSERT INTO 'albumsrecordingsmap' VALUES (8006, 18, 939, 7476);
INSERT INTO 'albumsrecordingsmap' VALUES (8007, 19, 939, 7477);
INSERT INTO 'albumsrecordingsmap' VALUES (8008, 20, 939, 7478);
INSERT INTO 'albumsrecordingsmap' VALUES (8009, 1, 940, 7479);
INSERT INTO 'albumsrecordingsmap' VALUES (8010, 2, 940, 7480);
INSERT INTO 'albumsrecordingsmap' VALUES (8011, 3, 940, 7481);
INSERT INTO 'albumsrecordingsmap' VALUES (8012, 4, 940, 7482);
INSERT INTO 'albumsrecordingsmap' VALUES (8013, 5, 940, 7483);
INSERT INTO 'albumsrecordingsmap' VALUES (8014, 6, 940, 7484);
INSERT INTO 'albumsrecordingsmap' VALUES (8015, 7, 940, 7485);
INSERT INTO 'albumsrecordingsmap' VALUES (8016, 8, 940, 7486);
INSERT INTO 'albumsrecordingsmap' VALUES (8017, 9, 940, 7487);
INSERT INTO 'albumsrecordingsmap' VALUES (8018, 10, 940, 7488);
INSERT INTO 'albumsrecordingsmap' VALUES (8019, 11, 940, 7489);
INSERT INTO 'albumsrecordingsmap' VALUES (8020, 12, 940, 7490);
INSERT INTO 'albumsrecordingsmap' VALUES (8021, 13, 940, 7491);
INSERT INTO 'albumsrecordingsmap' VALUES (8022, 14, 940, 7492);
INSERT INTO 'albumsrecordingsmap' VALUES (8023, 15, 940, 7493);
INSERT INTO 'albumsrecordingsmap' VALUES (8024, 16, 940, 7494);
INSERT INTO 'albumsrecordingsmap' VALUES (8025, 1, 941, 7495);
INSERT INTO 'albumsrecordingsmap' VALUES (8026, 2, 941, 7496);
INSERT INTO 'albumsrecordingsmap' VALUES (8027, 3, 941, 7497);
INSERT INTO 'albumsrecordingsmap' VALUES (8028, 4, 941, 7498);
INSERT INTO 'albumsrecordingsmap' VALUES (8029, 5, 941, 7499);
INSERT INTO 'albumsrecordingsmap' VALUES (8030, 6, 941, 7500);
INSERT INTO 'albumsrecordingsmap' VALUES (8031, 7, 941, 7501);
INSERT INTO 'albumsrecordingsmap' VALUES (8032, 8, 941, 7502);
INSERT INTO 'albumsrecordingsmap' VALUES (8033, 9, 941, 7503);
INSERT INTO 'albumsrecordingsmap' VALUES (8034, 10, 941, 7504);
INSERT INTO 'albumsrecordingsmap' VALUES (8035, 11, 941, 7505);
INSERT INTO 'albumsrecordingsmap' VALUES (8036, 12, 941, 7506);
INSERT INTO 'albumsrecordingsmap' VALUES (8037, 13, 941, 7507);
INSERT INTO 'albumsrecordingsmap' VALUES (8038, 14, 941, 7508);
INSERT INTO 'albumsrecordingsmap' VALUES (8039, 15, 941, 7509);
INSERT INTO 'albumsrecordingsmap' VALUES (8040, 16, 941, 7510);
INSERT INTO 'albumsrecordingsmap' VALUES (8041, 1, 942, 7511);
INSERT INTO 'albumsrecordingsmap' VALUES (8042, 2, 942, 7512);
INSERT INTO 'albumsrecordingsmap' VALUES (8043, 3, 942, 7513);
INSERT INTO 'albumsrecordingsmap' VALUES (8044, 4, 942, 7514);
INSERT INTO 'albumsrecordingsmap' VALUES (8045, 5, 942, 7515);
INSERT INTO 'albumsrecordingsmap' VALUES (8046, 6, 942, 7516);
INSERT INTO 'albumsrecordingsmap' VALUES (8047, 7, 942, 7517);
INSERT INTO 'albumsrecordingsmap' VALUES (8048, 8, 942, 7518);
INSERT INTO 'albumsrecordingsmap' VALUES (8049, 9, 942, 7519);
INSERT INTO 'albumsrecordingsmap' VALUES (8050, 10, 942, 7520);
INSERT INTO 'albumsrecordingsmap' VALUES (8051, 11, 942, 7521);
INSERT INTO 'albumsrecordingsmap' VALUES (8052, 12, 942, 7522);
INSERT INTO 'albumsrecordingsmap' VALUES (8053, 1, 943, 7523);
INSERT INTO 'albumsrecordingsmap' VALUES (8054, 2, 943, 7524);
INSERT INTO 'albumsrecordingsmap' VALUES (8055, 3, 943, 7525);
INSERT INTO 'albumsrecordingsmap' VALUES (8056, 4, 943, 7526);
INSERT INTO 'albumsrecordingsmap' VALUES (8057, 5, 943, 7527);
INSERT INTO 'albumsrecordingsmap' VALUES (8058, 6, 943, 7528);
INSERT INTO 'albumsrecordingsmap' VALUES (8059, 7, 943, 7529);
INSERT INTO 'albumsrecordingsmap' VALUES (8060, 8, 943, 7530);
INSERT INTO 'albumsrecordingsmap' VALUES (8061, 9, 943, 7531);
INSERT INTO 'albumsrecordingsmap' VALUES (8062, 10, 943, 7532);
INSERT INTO 'albumsrecordingsmap' VALUES (8063, 11, 943, 7533);
INSERT INTO 'albumsrecordingsmap' VALUES (8064, 12, 943, 7534);
INSERT INTO 'albumsrecordingsmap' VALUES (8065, 13, 943, 7535);
INSERT INTO 'albumsrecordingsmap' VALUES (8066, 14, 943, 7536);
INSERT INTO 'albumsrecordingsmap' VALUES (8067, 15, 943, 7537);
INSERT INTO 'albumsrecordingsmap' VALUES (8068, 16, 943, 7538);
INSERT INTO 'albumsrecordingsmap' VALUES (8069, 17, 943, 7539);
INSERT INTO 'albumsrecordingsmap' VALUES (8070, 1, 944, 7540);
INSERT INTO 'albumsrecordingsmap' VALUES (8071, 2, 944, 7541);
INSERT INTO 'albumsrecordingsmap' VALUES (8072, 3, 944, 7542);
INSERT INTO 'albumsrecordingsmap' VALUES (8073, 4, 944, 7543);
INSERT INTO 'albumsrecordingsmap' VALUES (8074, 5, 944, 7544);
INSERT INTO 'albumsrecordingsmap' VALUES (8075, 6, 944, 7545);
INSERT INTO 'albumsrecordingsmap' VALUES (8076, 7, 944, 7546);
INSERT INTO 'albumsrecordingsmap' VALUES (8077, 8, 944, 7547);
INSERT INTO 'albumsrecordingsmap' VALUES (8078, 9, 944, 7548);
INSERT INTO 'albumsrecordingsmap' VALUES (8079, 10, 944, 7549);
INSERT INTO 'albumsrecordingsmap' VALUES (8080, 11, 944, 7550);
INSERT INTO 'albumsrecordingsmap' VALUES (8081, 12, 944, 7551);
INSERT INTO 'albumsrecordingsmap' VALUES (8082, 13, 944, 7552);
INSERT INTO 'albumsrecordingsmap' VALUES (8083, 14, 944, 7553);
INSERT INTO 'albumsrecordingsmap' VALUES (8084, 15, 944, 7554);
INSERT INTO 'albumsrecordingsmap' VALUES (8085, 16, 944, 7555);
INSERT INTO 'albumsrecordingsmap' VALUES (8086, 17, 944, 7556);
INSERT INTO 'albumsrecordingsmap' VALUES (8087, 1, 945, 7557);
INSERT INTO 'albumsrecordingsmap' VALUES (8088, 2, 945, 7558);
INSERT INTO 'albumsrecordingsmap' VALUES (8089, 3, 945, 7559);
INSERT INTO 'albumsrecordingsmap' VALUES (8090, 4, 945, 7560);
INSERT INTO 'albumsrecordingsmap' VALUES (8091, 5, 945, 7561);
INSERT INTO 'albumsrecordingsmap' VALUES (8092, 6, 945, 7562);
INSERT INTO 'albumsrecordingsmap' VALUES (8093, 7, 945, 7563);
INSERT INTO 'albumsrecordingsmap' VALUES (8094, 8, 945, 7564);
INSERT INTO 'albumsrecordingsmap' VALUES (8095, 9, 945, 7565);
INSERT INTO 'albumsrecordingsmap' VALUES (8096, 10, 945, 7566);
INSERT INTO 'albumsrecordingsmap' VALUES (8097, 11, 945, 7567);
INSERT INTO 'albumsrecordingsmap' VALUES (8098, 12, 945, 7568);
INSERT INTO 'albumsrecordingsmap' VALUES (8099, 13, 945, 7569);
INSERT INTO 'albumsrecordingsmap' VALUES (8100, 14, 945, 7570);
INSERT INTO 'albumsrecordingsmap' VALUES (8101, 1, 946, 7571);
INSERT INTO 'albumsrecordingsmap' VALUES (8102, 2, 946, 7572);
INSERT INTO 'albumsrecordingsmap' VALUES (8103, 3, 946, 7573);
INSERT INTO 'albumsrecordingsmap' VALUES (8104, 4, 946, 7574);
INSERT INTO 'albumsrecordingsmap' VALUES (8105, 5, 946, 7575);
INSERT INTO 'albumsrecordingsmap' VALUES (8106, 6, 946, 7576);
INSERT INTO 'albumsrecordingsmap' VALUES (8107, 7, 946, 7577);
INSERT INTO 'albumsrecordingsmap' VALUES (8108, 8, 946, 7578);
INSERT INTO 'albumsrecordingsmap' VALUES (8109, 9, 946, 7579);
INSERT INTO 'albumsrecordingsmap' VALUES (8110, 10, 946, 7580);
INSERT INTO 'albumsrecordingsmap' VALUES (8111, 11, 946, 7581);
INSERT INTO 'albumsrecordingsmap' VALUES (8112, 12, 946, 7582);
INSERT INTO 'albumsrecordingsmap' VALUES (8113, 1, 947, 7583);
INSERT INTO 'albumsrecordingsmap' VALUES (8114, 2, 947, 7584);
INSERT INTO 'albumsrecordingsmap' VALUES (8115, 3, 947, 7585);
INSERT INTO 'albumsrecordingsmap' VALUES (8116, 4, 947, 7586);
INSERT INTO 'albumsrecordingsmap' VALUES (8117, 5, 947, 7587);
INSERT INTO 'albumsrecordingsmap' VALUES (8118, 6, 947, 7588);
INSERT INTO 'albumsrecordingsmap' VALUES (8119, 7, 947, 7589);
INSERT INTO 'albumsrecordingsmap' VALUES (8120, 8, 947, 7590);
INSERT INTO 'albumsrecordingsmap' VALUES (8121, 9, 947, 7591);
INSERT INTO 'albumsrecordingsmap' VALUES (8122, 10, 947, 7592);
INSERT INTO 'albumsrecordingsmap' VALUES (8123, 11, 947, 7593);
INSERT INTO 'albumsrecordingsmap' VALUES (8124, 12, 947, 7594);
INSERT INTO 'albumsrecordingsmap' VALUES (8125, 13, 947, 7595);
INSERT INTO 'albumsrecordingsmap' VALUES (8126, 14, 947, 7596);
INSERT INTO 'albumsrecordingsmap' VALUES (8127, 15, 947, 7597);
INSERT INTO 'albumsrecordingsmap' VALUES (8128, 16, 947, 7598);
INSERT INTO 'albumsrecordingsmap' VALUES (8129, 17, 947, 7599);
INSERT INTO 'albumsrecordingsmap' VALUES (8130, 18, 947, 7600);
INSERT INTO 'albumsrecordingsmap' VALUES (8131, 19, 947, 7601);
INSERT INTO 'albumsrecordingsmap' VALUES (8132, 20, 947, 7602);
INSERT INTO 'albumsrecordingsmap' VALUES (8133, 21, 947, 7603);
INSERT INTO 'albumsrecordingsmap' VALUES (8134, 22, 947, 7604);
INSERT INTO 'albumsrecordingsmap' VALUES (8135, 23, 947, 7605);
INSERT INTO 'albumsrecordingsmap' VALUES (8136, 1, 211, 7606);
INSERT INTO 'albumsrecordingsmap' VALUES (8137, 2, 211, 7607);
INSERT INTO 'albumsrecordingsmap' VALUES (8138, 3, 211, 7608);
INSERT INTO 'albumsrecordingsmap' VALUES (8139, 5, 211, 7610);
INSERT INTO 'albumsrecordingsmap' VALUES (8140, 6, 211, 7611);
INSERT INTO 'albumsrecordingsmap' VALUES (8141, 7, 211, 7612);
INSERT INTO 'albumsrecordingsmap' VALUES (8142, 9, 211, 7613);
INSERT INTO 'albumsrecordingsmap' VALUES (8143, 11, 211, 7614);
INSERT INTO 'albumsrecordingsmap' VALUES (8144, 12, 211, 7615);
INSERT INTO 'albumsrecordingsmap' VALUES (8145, 13, 211, 7616);
INSERT INTO 'albumsrecordingsmap' VALUES (8146, 14, 211, 7617);
INSERT INTO 'albumsrecordingsmap' VALUES (8147, 16, 211, 7618);
INSERT INTO 'albumsrecordingsmap' VALUES (8148, 18, 211, 7619);
INSERT INTO 'albumsrecordingsmap' VALUES (8149, 1, 948, 7620);
INSERT INTO 'albumsrecordingsmap' VALUES (8150, 2, 948, 7621);
INSERT INTO 'albumsrecordingsmap' VALUES (8151, 3, 948, 7622);
INSERT INTO 'albumsrecordingsmap' VALUES (8152, 4, 948, 7623);
INSERT INTO 'albumsrecordingsmap' VALUES (8153, 5, 948, 7624);
INSERT INTO 'albumsrecordingsmap' VALUES (8154, 6, 948, 7625);
INSERT INTO 'albumsrecordingsmap' VALUES (8155, 7, 948, 7626);
INSERT INTO 'albumsrecordingsmap' VALUES (8156, 8, 948, 7627);
INSERT INTO 'albumsrecordingsmap' VALUES (8157, 9, 948, 7628);
INSERT INTO 'albumsrecordingsmap' VALUES (8158, 10, 948, 7629);
INSERT INTO 'albumsrecordingsmap' VALUES (8159, 11, 948, 7630);
INSERT INTO 'albumsrecordingsmap' VALUES (8160, 12, 948, 7631);
INSERT INTO 'albumsrecordingsmap' VALUES (8161, 1, 949, 7632);
INSERT INTO 'albumsrecordingsmap' VALUES (8162, 2, 949, 7633);
INSERT INTO 'albumsrecordingsmap' VALUES (8163, 3, 949, 7634);
INSERT INTO 'albumsrecordingsmap' VALUES (8164, 4, 949, 7635);
INSERT INTO 'albumsrecordingsmap' VALUES (8165, 5, 949, 7636);
INSERT INTO 'albumsrecordingsmap' VALUES (8166, 6, 949, 7637);
INSERT INTO 'albumsrecordingsmap' VALUES (8167, 7, 949, 7638);
INSERT INTO 'albumsrecordingsmap' VALUES (8168, 8, 949, 7639);
INSERT INTO 'albumsrecordingsmap' VALUES (8169, 9, 949, 7640);
INSERT INTO 'albumsrecordingsmap' VALUES (8170, 1, 950, 7641);
INSERT INTO 'albumsrecordingsmap' VALUES (8171, 2, 950, 7642);
INSERT INTO 'albumsrecordingsmap' VALUES (8172, 3, 950, 7643);
INSERT INTO 'albumsrecordingsmap' VALUES (8173, 4, 950, 7644);
INSERT INTO 'albumsrecordingsmap' VALUES (8174, 5, 950, 7645);
INSERT INTO 'albumsrecordingsmap' VALUES (8175, 6, 950, 7646);
INSERT INTO 'albumsrecordingsmap' VALUES (8176, 7, 950, 7647);
INSERT INTO 'albumsrecordingsmap' VALUES (8177, 8, 950, 7648);
INSERT INTO 'albumsrecordingsmap' VALUES (8178, 9, 950, 7649);
INSERT INTO 'albumsrecordingsmap' VALUES (8179, 10, 950, 7650);
INSERT INTO 'albumsrecordingsmap' VALUES (8180, 11, 950, 7651);
INSERT INTO 'albumsrecordingsmap' VALUES (8181, 12, 950, 7652);
INSERT INTO 'albumsrecordingsmap' VALUES (8182, 13, 950, 7653);
INSERT INTO 'albumsrecordingsmap' VALUES (8183, 14, 950, 7654);
INSERT INTO 'albumsrecordingsmap' VALUES (8184, 15, 950, 7655);
INSERT INTO 'albumsrecordingsmap' VALUES (8185, 16, 950, 7656);
INSERT INTO 'albumsrecordingsmap' VALUES (8186, 17, 950, 7657);
INSERT INTO 'albumsrecordingsmap' VALUES (8187, 18, 950, 7658);
INSERT INTO 'albumsrecordingsmap' VALUES (8188, 19, 950, 7659);
INSERT INTO 'albumsrecordingsmap' VALUES (8189, 20, 950, 7660);
INSERT INTO 'albumsrecordingsmap' VALUES (8190, 1, 951, 7661);
INSERT INTO 'albumsrecordingsmap' VALUES (8191, 2, 951, 7662);
INSERT INTO 'albumsrecordingsmap' VALUES (8192, 3, 951, 7663);
INSERT INTO 'albumsrecordingsmap' VALUES (8193, 4, 951, 7664);
INSERT INTO 'albumsrecordingsmap' VALUES (8194, 5, 951, 7665);
INSERT INTO 'albumsrecordingsmap' VALUES (8195, 6, 951, 7666);
INSERT INTO 'albumsrecordingsmap' VALUES (8196, 7, 951, 7667);
INSERT INTO 'albumsrecordingsmap' VALUES (8197, 8, 951, 7668);
INSERT INTO 'albumsrecordingsmap' VALUES (8198, 9, 951, 7669);
INSERT INTO 'albumsrecordingsmap' VALUES (8199, 10, 951, 7670);
INSERT INTO 'albumsrecordingsmap' VALUES (8200, 11, 951, 7671);
INSERT INTO 'albumsrecordingsmap' VALUES (8201, 12, 951, 7672);
INSERT INTO 'albumsrecordingsmap' VALUES (8202, 13, 951, 7673);
INSERT INTO 'albumsrecordingsmap' VALUES (8203, 14, 951, 7674);
INSERT INTO 'albumsrecordingsmap' VALUES (8204, 15, 951, 7675);
INSERT INTO 'albumsrecordingsmap' VALUES (8205, 16, 951, 7676);
INSERT INTO 'albumsrecordingsmap' VALUES (8206, 17, 951, 7677);
INSERT INTO 'albumsrecordingsmap' VALUES (8207, 18, 951, 7678);
INSERT INTO 'albumsrecordingsmap' VALUES (8208, 19, 951, 7679);
INSERT INTO 'albumsrecordingsmap' VALUES (8209, 20, 951, 7680);
INSERT INTO 'albumsrecordingsmap' VALUES (8210, 1, 952, 7681);
INSERT INTO 'albumsrecordingsmap' VALUES (8211, 2, 952, 7682);
INSERT INTO 'albumsrecordingsmap' VALUES (8212, 3, 952, 7683);
INSERT INTO 'albumsrecordingsmap' VALUES (8213, 4, 952, 7684);
INSERT INTO 'albumsrecordingsmap' VALUES (8214, 5, 952, 7685);
INSERT INTO 'albumsrecordingsmap' VALUES (8215, 6, 952, 7686);
INSERT INTO 'albumsrecordingsmap' VALUES (8216, 7, 952, 7687);
INSERT INTO 'albumsrecordingsmap' VALUES (8217, 1, 953, 7688);
INSERT INTO 'albumsrecordingsmap' VALUES (8218, 2, 953, 7689);
INSERT INTO 'albumsrecordingsmap' VALUES (8219, 3, 953, 7690);
INSERT INTO 'albumsrecordingsmap' VALUES (8220, 4, 953, 7691);
INSERT INTO 'albumsrecordingsmap' VALUES (8221, 5, 953, 7692);
INSERT INTO 'albumsrecordingsmap' VALUES (8222, 6, 953, 7693);
INSERT INTO 'albumsrecordingsmap' VALUES (8223, 7, 953, 7694);
INSERT INTO 'albumsrecordingsmap' VALUES (8224, 8, 953, 7695);
INSERT INTO 'albumsrecordingsmap' VALUES (8225, 9, 953, 7696);
INSERT INTO 'albumsrecordingsmap' VALUES (8226, 10, 953, 7697);
INSERT INTO 'albumsrecordingsmap' VALUES (8227, 11, 953, 7698);
INSERT INTO 'albumsrecordingsmap' VALUES (8228, 12, 953, 7699);
INSERT INTO 'albumsrecordingsmap' VALUES (8229, 13, 953, 7700);
INSERT INTO 'albumsrecordingsmap' VALUES (8230, 14, 953, 7701);
INSERT INTO 'albumsrecordingsmap' VALUES (8231, 15, 953, 7702);
INSERT INTO 'albumsrecordingsmap' VALUES (8232, 1, 954, 7721);
INSERT INTO 'albumsrecordingsmap' VALUES (8233, 2, 954, 7722);
INSERT INTO 'albumsrecordingsmap' VALUES (8234, 3, 954, 7723);
INSERT INTO 'albumsrecordingsmap' VALUES (8235, 4, 954, 7724);
INSERT INTO 'albumsrecordingsmap' VALUES (8236, 5, 954, 7725);
INSERT INTO 'albumsrecordingsmap' VALUES (8237, 6, 954, 7726);
INSERT INTO 'albumsrecordingsmap' VALUES (8238, 7, 954, 7727);
INSERT INTO 'albumsrecordingsmap' VALUES (8239, 8, 954, 7728);
INSERT INTO 'albumsrecordingsmap' VALUES (8240, 9, 954, 7729);
INSERT INTO 'albumsrecordingsmap' VALUES (8241, 10, 954, 7730);
INSERT INTO 'albumsrecordingsmap' VALUES (8242, 11, 954, 7731);
INSERT INTO 'albumsrecordingsmap' VALUES (8243, 12, 954, 7732);
INSERT INTO 'albumsrecordingsmap' VALUES (8244, 13, 954, 7733);
INSERT INTO 'albumsrecordingsmap' VALUES (8245, 14, 954, 7734);
INSERT INTO 'albumsrecordingsmap' VALUES (8246, 15, 954, 7735);
INSERT INTO 'albumsrecordingsmap' VALUES (8247, 16, 954, 7736);
INSERT INTO 'albumsrecordingsmap' VALUES (8248, 17, 954, 7737);
INSERT INTO 'albumsrecordingsmap' VALUES (8249, 18, 954, 7738);
INSERT INTO 'albumsrecordingsmap' VALUES (8250, 1, 955, 7739);
INSERT INTO 'albumsrecordingsmap' VALUES (8251, 2, 955, 7740);
INSERT INTO 'albumsrecordingsmap' VALUES (8252, 3, 955, 7741);
INSERT INTO 'albumsrecordingsmap' VALUES (8253, 4, 955, 7742);
INSERT INTO 'albumsrecordingsmap' VALUES (8254, 5, 955, 7743);
INSERT INTO 'albumsrecordingsmap' VALUES (8255, 6, 955, 7744);
INSERT INTO 'albumsrecordingsmap' VALUES (8256, 7, 955, 7745);
INSERT INTO 'albumsrecordingsmap' VALUES (8257, 8, 955, 7746);
INSERT INTO 'albumsrecordingsmap' VALUES (8258, 9, 955, 7747);
INSERT INTO 'albumsrecordingsmap' VALUES (8259, 10, 955, 7748);
INSERT INTO 'albumsrecordingsmap' VALUES (8260, 11, 955, 7749);
INSERT INTO 'albumsrecordingsmap' VALUES (8261, 12, 955, 7750);
INSERT INTO 'albumsrecordingsmap' VALUES (8262, 13, 955, 7751);
INSERT INTO 'albumsrecordingsmap' VALUES (8263, 14, 955, 7752);
INSERT INTO 'albumsrecordingsmap' VALUES (8264, 15, 955, 7753);
INSERT INTO 'albumsrecordingsmap' VALUES (8265, 16, 955, 7754);
INSERT INTO 'albumsrecordingsmap' VALUES (8266, 17, 955, 7755);
INSERT INTO 'albumsrecordingsmap' VALUES (8267, 18, 955, 7756);
INSERT INTO 'albumsrecordingsmap' VALUES (8268, 19, 955, 7757);
INSERT INTO 'albumsrecordingsmap' VALUES (8269, 20, 955, 7758);
INSERT INTO 'albumsrecordingsmap' VALUES (8270, 21, 955, 7759);
INSERT INTO 'albumsrecordingsmap' VALUES (8271, 22, 955, 7760);
INSERT INTO 'albumsrecordingsmap' VALUES (8272, 1, 956, 7761);
INSERT INTO 'albumsrecordingsmap' VALUES (8273, 2, 956, 7762);
INSERT INTO 'albumsrecordingsmap' VALUES (8274, 3, 956, 7763);
INSERT INTO 'albumsrecordingsmap' VALUES (8275, 4, 956, 7764);
INSERT INTO 'albumsrecordingsmap' VALUES (8276, 5, 956, 7765);
INSERT INTO 'albumsrecordingsmap' VALUES (8277, 6, 956, 7766);
INSERT INTO 'albumsrecordingsmap' VALUES (8278, 7, 956, 7767);
INSERT INTO 'albumsrecordingsmap' VALUES (8279, 8, 956, 7768);
INSERT INTO 'albumsrecordingsmap' VALUES (8280, 9, 956, 7769);
INSERT INTO 'albumsrecordingsmap' VALUES (8281, 10, 956, 7770);
INSERT INTO 'albumsrecordingsmap' VALUES (8282, 11, 956, 7771);
INSERT INTO 'albumsrecordingsmap' VALUES (8283, 12, 956, 7772);
INSERT INTO 'albumsrecordingsmap' VALUES (8284, 1, 957, 7773);
INSERT INTO 'albumsrecordingsmap' VALUES (8285, 2, 957, 7774);
INSERT INTO 'albumsrecordingsmap' VALUES (8286, 3, 957, 7775);
INSERT INTO 'albumsrecordingsmap' VALUES (8287, 4, 957, 7776);
INSERT INTO 'albumsrecordingsmap' VALUES (8288, 5, 957, 7777);
INSERT INTO 'albumsrecordingsmap' VALUES (8289, 6, 957, 7778);
INSERT INTO 'albumsrecordingsmap' VALUES (8290, 7, 957, 7779);
INSERT INTO 'albumsrecordingsmap' VALUES (8291, 8, 957, 7780);
INSERT INTO 'albumsrecordingsmap' VALUES (8292, 9, 957, 7781);
INSERT INTO 'albumsrecordingsmap' VALUES (8293, 10, 957, 7782);
INSERT INTO 'albumsrecordingsmap' VALUES (8294, 11, 957, 7783);
INSERT INTO 'albumsrecordingsmap' VALUES (8295, 12, 957, 7784);
INSERT INTO 'albumsrecordingsmap' VALUES (8296, 13, 957, 7785);
INSERT INTO 'albumsrecordingsmap' VALUES (8297, 14, 957, 7786);
INSERT INTO 'albumsrecordingsmap' VALUES (8313, 1, 959, 7802);
INSERT INTO 'albumsrecordingsmap' VALUES (8314, 2, 959, 7803);
INSERT INTO 'albumsrecordingsmap' VALUES (8315, 3, 959, 7804);
INSERT INTO 'albumsrecordingsmap' VALUES (8316, 4, 959, 7805);
INSERT INTO 'albumsrecordingsmap' VALUES (8317, 5, 959, 7806);
INSERT INTO 'albumsrecordingsmap' VALUES (8318, 6, 959, 7807);
INSERT INTO 'albumsrecordingsmap' VALUES (8319, 7, 959, 7808);
INSERT INTO 'albumsrecordingsmap' VALUES (8320, 8, 959, 7809);
INSERT INTO 'albumsrecordingsmap' VALUES (8321, 9, 959, 7810);
INSERT INTO 'albumsrecordingsmap' VALUES (8322, 10, 959, 7811);
INSERT INTO 'albumsrecordingsmap' VALUES (8323, 11, 959, 7812);
INSERT INTO 'albumsrecordingsmap' VALUES (8324, 12, 959, 7813);
INSERT INTO 'albumsrecordingsmap' VALUES (8325, 13, 959, 7814);
INSERT INTO 'albumsrecordingsmap' VALUES (8326, 1, 960, 7815);
INSERT INTO 'albumsrecordingsmap' VALUES (8327, 2, 960, 7816);
INSERT INTO 'albumsrecordingsmap' VALUES (8328, 3, 960, 7817);
INSERT INTO 'albumsrecordingsmap' VALUES (8329, 4, 960, 7818);
INSERT INTO 'albumsrecordingsmap' VALUES (8330, 5, 960, 7819);
INSERT INTO 'albumsrecordingsmap' VALUES (8331, 6, 960, 7820);
INSERT INTO 'albumsrecordingsmap' VALUES (8332, 7, 960, 7821);
INSERT INTO 'albumsrecordingsmap' VALUES (8333, 8, 960, 7822);
INSERT INTO 'albumsrecordingsmap' VALUES (8334, 9, 960, 7823);
INSERT INTO 'albumsrecordingsmap' VALUES (8335, 10, 960, 7824);
INSERT INTO 'albumsrecordingsmap' VALUES (8336, 11, 960, 7825);
INSERT INTO 'albumsrecordingsmap' VALUES (8337, 12, 960, 7826);
INSERT INTO 'albumsrecordingsmap' VALUES (8338, 13, 960, 7827);
INSERT INTO 'albumsrecordingsmap' VALUES (8339, 14, 960, 7828);
INSERT INTO 'albumsrecordingsmap' VALUES (8340, 15, 960, 7829);
INSERT INTO 'albumsrecordingsmap' VALUES (8341, 16, 960, 7830);
INSERT INTO 'albumsrecordingsmap' VALUES (8342, 17, 960, 7831);
INSERT INTO 'albumsrecordingsmap' VALUES (8343, 18, 960, 7832);
INSERT INTO 'albumsrecordingsmap' VALUES (8344, 19, 960, 7833);
INSERT INTO 'albumsrecordingsmap' VALUES (8345, 20, 960, 7834);
INSERT INTO 'albumsrecordingsmap' VALUES (8346, 21, 960, 7835);
INSERT INTO 'albumsrecordingsmap' VALUES (8347, 22, 960, 7836);
INSERT INTO 'albumsrecordingsmap' VALUES (8348, 23, 960, 7837);
INSERT INTO 'albumsrecordingsmap' VALUES (8349, 24, 960, 7838);
INSERT INTO 'albumsrecordingsmap' VALUES (8350, 25, 960, 7839);
INSERT INTO 'albumsrecordingsmap' VALUES (8351, 26, 960, 7840);
INSERT INTO 'albumsrecordingsmap' VALUES (8352, 27, 960, 7841);
INSERT INTO 'albumsrecordingsmap' VALUES (8353, 28, 960, 7842);
INSERT INTO 'albumsrecordingsmap' VALUES (8354, 29, 960, 7843);
INSERT INTO 'albumsrecordingsmap' VALUES (8355, 30, 960, 7844);
INSERT INTO 'albumsrecordingsmap' VALUES (8356, 31, 960, 7845);
INSERT INTO 'albumsrecordingsmap' VALUES (8357, 32, 960, 7846);
INSERT INTO 'albumsrecordingsmap' VALUES (8358, 33, 960, 7847);
INSERT INTO 'albumsrecordingsmap' VALUES (8359, 34, 960, 7848);
INSERT INTO 'albumsrecordingsmap' VALUES (8360, 35, 960, 7849);
INSERT INTO 'albumsrecordingsmap' VALUES (8361, 36, 960, 7850);
INSERT INTO 'albumsrecordingsmap' VALUES (8362, 1, 961, 7851);
INSERT INTO 'albumsrecordingsmap' VALUES (8363, 2, 961, 7852);
INSERT INTO 'albumsrecordingsmap' VALUES (8364, 3, 961, 7853);
INSERT INTO 'albumsrecordingsmap' VALUES (8365, 4, 961, 7854);
INSERT INTO 'albumsrecordingsmap' VALUES (8366, 5, 961, 7855);
INSERT INTO 'albumsrecordingsmap' VALUES (8367, 6, 961, 7856);
INSERT INTO 'albumsrecordingsmap' VALUES (8368, 7, 961, 7857);
INSERT INTO 'albumsrecordingsmap' VALUES (8369, 8, 961, 7858);
INSERT INTO 'albumsrecordingsmap' VALUES (8370, 9, 961, 7859);
INSERT INTO 'albumsrecordingsmap' VALUES (8371, 10, 961, 7860);
INSERT INTO 'albumsrecordingsmap' VALUES (8372, 11, 961, 7861);
INSERT INTO 'albumsrecordingsmap' VALUES (8373, 12, 961, 7862);
INSERT INTO 'albumsrecordingsmap' VALUES (8374, 13, 961, 7863);
INSERT INTO 'albumsrecordingsmap' VALUES (8375, 14, 961, 7864);
INSERT INTO 'albumsrecordingsmap' VALUES (8376, 1, 962, 7865);
INSERT INTO 'albumsrecordingsmap' VALUES (8377, 2, 962, 7866);
INSERT INTO 'albumsrecordingsmap' VALUES (8378, 3, 962, 7867);
INSERT INTO 'albumsrecordingsmap' VALUES (8379, 4, 962, 7868);
INSERT INTO 'albumsrecordingsmap' VALUES (8380, 5, 962, 7869);
INSERT INTO 'albumsrecordingsmap' VALUES (8381, 6, 962, 7870);
INSERT INTO 'albumsrecordingsmap' VALUES (8382, 7, 962, 7871);
INSERT INTO 'albumsrecordingsmap' VALUES (8383, 8, 962, 7872);
INSERT INTO 'albumsrecordingsmap' VALUES (8384, 9, 962, 7873);
INSERT INTO 'albumsrecordingsmap' VALUES (8385, 10, 962, 7874);
INSERT INTO 'albumsrecordingsmap' VALUES (8386, 11, 962, 7875);
INSERT INTO 'albumsrecordingsmap' VALUES (8387, 12, 962, 7876);
INSERT INTO 'albumsrecordingsmap' VALUES (8388, 13, 962, 7877);
INSERT INTO 'albumsrecordingsmap' VALUES (8389, 14, 962, 7878);
INSERT INTO 'albumsrecordingsmap' VALUES (8390, 15, 962, 7879);
INSERT INTO 'albumsrecordingsmap' VALUES (8391, 16, 962, 7880);
INSERT INTO 'albumsrecordingsmap' VALUES (8392, 17, 962, 7881);
INSERT INTO 'albumsrecordingsmap' VALUES (8393, 18, 962, 7882);
INSERT INTO 'albumsrecordingsmap' VALUES (8394, 19, 962, 7883);
INSERT INTO 'albumsrecordingsmap' VALUES (8395, 20, 962, 7884);
INSERT INTO 'albumsrecordingsmap' VALUES (8396, 21, 962, 7885);
INSERT INTO 'albumsrecordingsmap' VALUES (8397, 22, 962, 7886);
INSERT INTO 'albumsrecordingsmap' VALUES (8398, 23, 962, 7887);
INSERT INTO 'albumsrecordingsmap' VALUES (8399, 24, 962, 7888);
INSERT INTO 'albumsrecordingsmap' VALUES (8400, 25, 962, 7889);
INSERT INTO 'albumsrecordingsmap' VALUES (8401, 26, 962, 7890);
INSERT INTO 'albumsrecordingsmap' VALUES (8402, 27, 962, 7891);
INSERT INTO 'albumsrecordingsmap' VALUES (8403, 28, 962, 7892);
INSERT INTO 'albumsrecordingsmap' VALUES (8404, 29, 962, 7893);
INSERT INTO 'albumsrecordingsmap' VALUES (8405, 30, 962, 7894);
INSERT INTO 'albumsrecordingsmap' VALUES (8406, 31, 962, 7895);
INSERT INTO 'albumsrecordingsmap' VALUES (8407, 32, 962, 7896);
INSERT INTO 'albumsrecordingsmap' VALUES (8408, 33, 962, 7897);
INSERT INTO 'albumsrecordingsmap' VALUES (8409, 34, 962, 7898);
INSERT INTO 'albumsrecordingsmap' VALUES (8410, 35, 962, 7899);
INSERT INTO 'albumsrecordingsmap' VALUES (8411, 36, 962, 7900);
INSERT INTO 'albumsrecordingsmap' VALUES (8432, 1, 964, 7921);
INSERT INTO 'albumsrecordingsmap' VALUES (8433, 2, 964, 7922);
INSERT INTO 'albumsrecordingsmap' VALUES (8434, 3, 964, 7923);
INSERT INTO 'albumsrecordingsmap' VALUES (8435, 4, 964, 7924);
INSERT INTO 'albumsrecordingsmap' VALUES (8436, 5, 964, 7925);
INSERT INTO 'albumsrecordingsmap' VALUES (8437, 6, 964, 7926);
INSERT INTO 'albumsrecordingsmap' VALUES (8438, 7, 964, 7927);
INSERT INTO 'albumsrecordingsmap' VALUES (8439, 8, 964, 7928);
INSERT INTO 'albumsrecordingsmap' VALUES (8440, 9, 964, 7929);
INSERT INTO 'albumsrecordingsmap' VALUES (8441, 10, 964, 7930);
INSERT INTO 'albumsrecordingsmap' VALUES (8442, 11, 964, 7931);
INSERT INTO 'albumsrecordingsmap' VALUES (8443, 12, 964, 7932);
INSERT INTO 'albumsrecordingsmap' VALUES (8444, 13, 964, 7933);
INSERT INTO 'albumsrecordingsmap' VALUES (8445, 14, 964, 7934);
INSERT INTO 'albumsrecordingsmap' VALUES (8446, 15, 964, 7935);
INSERT INTO 'albumsrecordingsmap' VALUES (8447, 16, 964, 7936);
INSERT INTO 'albumsrecordingsmap' VALUES (8448, 17, 964, 7937);
INSERT INTO 'albumsrecordingsmap' VALUES (8449, 18, 964, 7938);
INSERT INTO 'albumsrecordingsmap' VALUES (8450, 1, 965, 7939);
INSERT INTO 'albumsrecordingsmap' VALUES (8451, 2, 965, 7940);
INSERT INTO 'albumsrecordingsmap' VALUES (8452, 3, 965, 7941);
INSERT INTO 'albumsrecordingsmap' VALUES (8453, 4, 965, 7942);
INSERT INTO 'albumsrecordingsmap' VALUES (8454, 5, 965, 7943);
INSERT INTO 'albumsrecordingsmap' VALUES (8455, 6, 965, 7944);
INSERT INTO 'albumsrecordingsmap' VALUES (8456, 7, 965, 7945);
INSERT INTO 'albumsrecordingsmap' VALUES (8457, 8, 965, 7946);
INSERT INTO 'albumsrecordingsmap' VALUES (8458, 9, 965, 7947);
INSERT INTO 'albumsrecordingsmap' VALUES (8459, 10, 965, 7948);
INSERT INTO 'albumsrecordingsmap' VALUES (8460, 11, 965, 7949);
INSERT INTO 'albumsrecordingsmap' VALUES (8461, 12, 965, 7950);
INSERT INTO 'albumsrecordingsmap' VALUES (8462, 13, 965, 7951);
INSERT INTO 'albumsrecordingsmap' VALUES (8463, 14, 965, 7952);
INSERT INTO 'albumsrecordingsmap' VALUES (8464, 15, 965, 7953);
INSERT INTO 'albumsrecordingsmap' VALUES (8465, 16, 965, 7954);
INSERT INTO 'albumsrecordingsmap' VALUES (8466, 17, 965, 7955);
INSERT INTO 'albumsrecordingsmap' VALUES (8467, 18, 965, 7956);
INSERT INTO 'albumsrecordingsmap' VALUES (8468, 1, 966, 7957);
INSERT INTO 'albumsrecordingsmap' VALUES (8469, 2, 966, 7958);
INSERT INTO 'albumsrecordingsmap' VALUES (8470, 3, 966, 7959);
INSERT INTO 'albumsrecordingsmap' VALUES (8471, 4, 966, 7960);
INSERT INTO 'albumsrecordingsmap' VALUES (8472, 5, 966, 7961);
INSERT INTO 'albumsrecordingsmap' VALUES (8473, 6, 966, 7962);
INSERT INTO 'albumsrecordingsmap' VALUES (8474, 7, 966, 7963);
INSERT INTO 'albumsrecordingsmap' VALUES (8475, 8, 966, 7964);
INSERT INTO 'albumsrecordingsmap' VALUES (8476, 9, 966, 7965);
INSERT INTO 'albumsrecordingsmap' VALUES (8477, 10, 966, 7966);
INSERT INTO 'albumsrecordingsmap' VALUES (8478, 1, 967, 7967);
INSERT INTO 'albumsrecordingsmap' VALUES (8479, 2, 967, 7968);
INSERT INTO 'albumsrecordingsmap' VALUES (8480, 3, 967, 7969);
INSERT INTO 'albumsrecordingsmap' VALUES (8481, 4, 967, 7970);
INSERT INTO 'albumsrecordingsmap' VALUES (8482, 5, 967, 7971);
INSERT INTO 'albumsrecordingsmap' VALUES (8483, 6, 967, 7972);
INSERT INTO 'albumsrecordingsmap' VALUES (8484, 7, 967, 7973);
INSERT INTO 'albumsrecordingsmap' VALUES (8485, 8, 967, 7974);
INSERT INTO 'albumsrecordingsmap' VALUES (8486, 9, 967, 7975);
INSERT INTO 'albumsrecordingsmap' VALUES (8487, 10, 967, 7976);
INSERT INTO 'albumsrecordingsmap' VALUES (8488, 11, 967, 7977);
INSERT INTO 'albumsrecordingsmap' VALUES (8489, 12, 967, 7978);
INSERT INTO 'albumsrecordingsmap' VALUES (8490, 13, 967, 7979);
INSERT INTO 'albumsrecordingsmap' VALUES (8491, 14, 967, 7980);
INSERT INTO 'albumsrecordingsmap' VALUES (8492, 15, 967, 7981);
INSERT INTO 'albumsrecordingsmap' VALUES (8509, 1, 969, 7998);
INSERT INTO 'albumsrecordingsmap' VALUES (8510, 2, 969, 7999);
INSERT INTO 'albumsrecordingsmap' VALUES (8511, 3, 969, 8000);
INSERT INTO 'albumsrecordingsmap' VALUES (8512, 4, 969, 8001);
INSERT INTO 'albumsrecordingsmap' VALUES (8513, 5, 969, 8002);
INSERT INTO 'albumsrecordingsmap' VALUES (8514, 6, 969, 8003);
INSERT INTO 'albumsrecordingsmap' VALUES (8515, 7, 969, 8004);
INSERT INTO 'albumsrecordingsmap' VALUES (8516, 8, 969, 8005);
INSERT INTO 'albumsrecordingsmap' VALUES (8517, 9, 969, 8006);
INSERT INTO 'albumsrecordingsmap' VALUES (8518, 10, 969, 8007);
INSERT INTO 'albumsrecordingsmap' VALUES (8519, 11, 969, 8008);
INSERT INTO 'albumsrecordingsmap' VALUES (8520, 12, 969, 8009);
INSERT INTO 'albumsrecordingsmap' VALUES (8521, 13, 969, 8010);
INSERT INTO 'albumsrecordingsmap' VALUES (8522, 14, 969, 8011);
INSERT INTO 'albumsrecordingsmap' VALUES (8523, 15, 969, 8012);
INSERT INTO 'albumsrecordingsmap' VALUES (8524, 16, 969, 8013);
INSERT INTO 'albumsrecordingsmap' VALUES (8525, 17, 969, 8014);
INSERT INTO 'albumsrecordingsmap' VALUES (8526, 1, 970, 8015);
INSERT INTO 'albumsrecordingsmap' VALUES (8527, 2, 970, 8016);
INSERT INTO 'albumsrecordingsmap' VALUES (8528, 3, 970, 8017);
INSERT INTO 'albumsrecordingsmap' VALUES (8529, 4, 970, 8018);
INSERT INTO 'albumsrecordingsmap' VALUES (8530, 5, 970, 8019);
INSERT INTO 'albumsrecordingsmap' VALUES (8531, 6, 970, 8020);
INSERT INTO 'albumsrecordingsmap' VALUES (8532, 7, 970, 8021);
INSERT INTO 'albumsrecordingsmap' VALUES (8533, 8, 970, 8022);
INSERT INTO 'albumsrecordingsmap' VALUES (8534, 9, 970, 8023);
INSERT INTO 'albumsrecordingsmap' VALUES (8535, 10, 970, 8024);
INSERT INTO 'albumsrecordingsmap' VALUES (8536, 11, 970, 8025);
INSERT INTO 'albumsrecordingsmap' VALUES (8537, 12, 970, 8026);
INSERT INTO 'albumsrecordingsmap' VALUES (8538, 13, 970, 8027);
INSERT INTO 'albumsrecordingsmap' VALUES (8539, 14, 970, 8028);
INSERT INTO 'albumsrecordingsmap' VALUES (8540, 15, 970, 8029);
INSERT INTO 'albumsrecordingsmap' VALUES (8541, 16, 970, 8030);
INSERT INTO 'albumsrecordingsmap' VALUES (8542, 1, 971, 8031);
INSERT INTO 'albumsrecordingsmap' VALUES (8543, 2, 971, 8032);
INSERT INTO 'albumsrecordingsmap' VALUES (8544, 3, 971, 8033);
INSERT INTO 'albumsrecordingsmap' VALUES (8545, 4, 971, 8034);
INSERT INTO 'albumsrecordingsmap' VALUES (8546, 5, 971, 8035);
INSERT INTO 'albumsrecordingsmap' VALUES (8547, 6, 971, 8036);
INSERT INTO 'albumsrecordingsmap' VALUES (8548, 7, 971, 8037);
INSERT INTO 'albumsrecordingsmap' VALUES (8549, 8, 971, 8038);
INSERT INTO 'albumsrecordingsmap' VALUES (8550, 9, 971, 8039);
INSERT INTO 'albumsrecordingsmap' VALUES (8551, 10, 971, 8040);
INSERT INTO 'albumsrecordingsmap' VALUES (8552, 11, 971, 8041);
INSERT INTO 'albumsrecordingsmap' VALUES (8553, 12, 971, 8042);
INSERT INTO 'albumsrecordingsmap' VALUES (8554, 13, 971, 8043);
INSERT INTO 'albumsrecordingsmap' VALUES (8555, 14, 971, 8044);
INSERT INTO 'albumsrecordingsmap' VALUES (8556, 15, 971, 8045);
INSERT INTO 'albumsrecordingsmap' VALUES (8557, 16, 971, 8046);
INSERT INTO 'albumsrecordingsmap' VALUES (8558, 1, 972, 8047);
INSERT INTO 'albumsrecordingsmap' VALUES (8559, 2, 972, 8048);
INSERT INTO 'albumsrecordingsmap' VALUES (8560, 3, 972, 8049);
INSERT INTO 'albumsrecordingsmap' VALUES (8561, 4, 972, 8050);
INSERT INTO 'albumsrecordingsmap' VALUES (8562, 5, 972, 8051);
INSERT INTO 'albumsrecordingsmap' VALUES (8563, 6, 972, 8052);
INSERT INTO 'albumsrecordingsmap' VALUES (8564, 7, 972, 8053);
INSERT INTO 'albumsrecordingsmap' VALUES (8565, 8, 972, 8054);
INSERT INTO 'albumsrecordingsmap' VALUES (8566, 9, 972, 8055);
INSERT INTO 'albumsrecordingsmap' VALUES (8567, 10, 972, 8056);
INSERT INTO 'albumsrecordingsmap' VALUES (8568, 11, 972, 8057);
INSERT INTO 'albumsrecordingsmap' VALUES (8569, 12, 972, 8058);
INSERT INTO 'albumsrecordingsmap' VALUES (8570, 13, 972, 8059);
INSERT INTO 'albumsrecordingsmap' VALUES (8571, 14, 972, 8060);
INSERT INTO 'albumsrecordingsmap' VALUES (8572, 15, 972, 8061);
INSERT INTO 'albumsrecordingsmap' VALUES (8573, 16, 972, 8062);
INSERT INTO 'albumsrecordingsmap' VALUES (7684, 12, 918, 7154);
INSERT INTO 'albumsrecordingsmap' VALUES (7685, 13, 918, 7155);
INSERT INTO 'albumsrecordingsmap' VALUES (7686, 14, 918, 7156);
INSERT INTO 'albumsrecordingsmap' VALUES (7687, 15, 918, 7157);
INSERT INTO 'albumsrecordingsmap' VALUES (7688, 16, 918, 7158);
INSERT INTO 'albumsrecordingsmap' VALUES (10863, 5, 1118, 10269);
INSERT INTO 'albumsrecordingsmap' VALUES (10864, 6, 1118, 10270);
INSERT INTO 'albumsrecordingsmap' VALUES (8598, 1, 974, 8087);
INSERT INTO 'albumsrecordingsmap' VALUES (8599, 2, 974, 8088);
INSERT INTO 'albumsrecordingsmap' VALUES (8493, 1, 968, 7982);
INSERT INTO 'albumsrecordingsmap' VALUES (8494, 2, 968, 7983);
INSERT INTO 'albumsrecordingsmap' VALUES (8495, 3, 968, 7984);
INSERT INTO 'albumsrecordingsmap' VALUES (8496, 4, 968, 7985);
INSERT INTO 'albumsrecordingsmap' VALUES (8497, 5, 968, 7986);
INSERT INTO 'albumsrecordingsmap' VALUES (8498, 6, 968, 7987);
INSERT INTO 'albumsrecordingsmap' VALUES (8499, 7, 968, 7988);
INSERT INTO 'albumsrecordingsmap' VALUES (8500, 8, 968, 7989);
INSERT INTO 'albumsrecordingsmap' VALUES (8501, 9, 968, 7990);
INSERT INTO 'albumsrecordingsmap' VALUES (8502, 10, 968, 7991);
INSERT INTO 'albumsrecordingsmap' VALUES (8503, 11, 968, 7992);
INSERT INTO 'albumsrecordingsmap' VALUES (8504, 12, 968, 7993);
INSERT INTO 'albumsrecordingsmap' VALUES (8505, 13, 968, 7994);
INSERT INTO 'albumsrecordingsmap' VALUES (8506, 14, 968, 7995);
INSERT INTO 'albumsrecordingsmap' VALUES (8507, 15, 968, 7996);
INSERT INTO 'albumsrecordingsmap' VALUES (8508, 16, 968, 7997);
INSERT INTO 'albumsrecordingsmap' VALUES (8600, 3, 974, 8089);
INSERT INTO 'albumsrecordingsmap' VALUES (8601, 4, 974, 8090);
INSERT INTO 'albumsrecordingsmap' VALUES (8602, 5, 974, 8091);
INSERT INTO 'albumsrecordingsmap' VALUES (8603, 6, 974, 8092);
INSERT INTO 'albumsrecordingsmap' VALUES (8604, 7, 974, 8093);
INSERT INTO 'albumsrecordingsmap' VALUES (8605, 8, 974, 8094);
INSERT INTO 'albumsrecordingsmap' VALUES (8606, 9, 974, 8095);
INSERT INTO 'albumsrecordingsmap' VALUES (8607, 10, 974, 8096);
INSERT INTO 'albumsrecordingsmap' VALUES (8608, 11, 974, 8097);
INSERT INTO 'albumsrecordingsmap' VALUES (8609, 12, 974, 8098);
INSERT INTO 'albumsrecordingsmap' VALUES (8610, 13, 974, 8099);
INSERT INTO 'albumsrecordingsmap' VALUES (8611, 14, 974, 8100);
INSERT INTO 'albumsrecordingsmap' VALUES (8612, 15, 974, 8101);
INSERT INTO 'albumsrecordingsmap' VALUES (8613, 16, 974, 8102);
INSERT INTO 'albumsrecordingsmap' VALUES (8614, 17, 974, 8103);
INSERT INTO 'albumsrecordingsmap' VALUES (8615, 1, 975, 8104);
INSERT INTO 'albumsrecordingsmap' VALUES (8616, 2, 975, 8105);
INSERT INTO 'albumsrecordingsmap' VALUES (8617, 3, 975, 8106);
INSERT INTO 'albumsrecordingsmap' VALUES (8618, 4, 975, 8107);
INSERT INTO 'albumsrecordingsmap' VALUES (8619, 5, 975, 8108);
INSERT INTO 'albumsrecordingsmap' VALUES (8620, 6, 975, 8109);
INSERT INTO 'albumsrecordingsmap' VALUES (8621, 7, 975, 8110);
INSERT INTO 'albumsrecordingsmap' VALUES (8622, 8, 975, 8111);
INSERT INTO 'albumsrecordingsmap' VALUES (8623, 9, 975, 8112);
INSERT INTO 'albumsrecordingsmap' VALUES (8624, 10, 975, 8113);
INSERT INTO 'albumsrecordingsmap' VALUES (8625, 11, 975, 8114);
INSERT INTO 'albumsrecordingsmap' VALUES (8626, 12, 975, 8115);
INSERT INTO 'albumsrecordingsmap' VALUES (8627, 13, 975, 8116);
INSERT INTO 'albumsrecordingsmap' VALUES (8628, 14, 975, 8117);
INSERT INTO 'albumsrecordingsmap' VALUES (8629, 15, 975, 8118);
INSERT INTO 'albumsrecordingsmap' VALUES (8630, 16, 975, 8119);
INSERT INTO 'albumsrecordingsmap' VALUES (8631, 17, 975, 8120);
INSERT INTO 'albumsrecordingsmap' VALUES (8632, 18, 975, 8121);
INSERT INTO 'albumsrecordingsmap' VALUES (8633, 1, 976, 8122);
INSERT INTO 'albumsrecordingsmap' VALUES (8634, 2, 976, 8123);
INSERT INTO 'albumsrecordingsmap' VALUES (8635, 3, 976, 8124);
INSERT INTO 'albumsrecordingsmap' VALUES (8636, 4, 976, 8125);
INSERT INTO 'albumsrecordingsmap' VALUES (8637, 5, 976, 8126);
INSERT INTO 'albumsrecordingsmap' VALUES (8638, 6, 976, 8127);
INSERT INTO 'albumsrecordingsmap' VALUES (8639, 7, 976, 8128);
INSERT INTO 'albumsrecordingsmap' VALUES (8640, 8, 976, 8129);
INSERT INTO 'albumsrecordingsmap' VALUES (8641, 9, 976, 8130);
INSERT INTO 'albumsrecordingsmap' VALUES (8642, 10, 976, 8131);
INSERT INTO 'albumsrecordingsmap' VALUES (8643, 11, 976, 8132);
INSERT INTO 'albumsrecordingsmap' VALUES (8644, 12, 976, 8133);
INSERT INTO 'albumsrecordingsmap' VALUES (8645, 13, 976, 8134);
INSERT INTO 'albumsrecordingsmap' VALUES (8646, 14, 976, 8135);
INSERT INTO 'albumsrecordingsmap' VALUES (8647, 15, 976, 8136);
INSERT INTO 'albumsrecordingsmap' VALUES (8648, 16, 976, 8137);
INSERT INTO 'albumsrecordingsmap' VALUES (8649, 17, 976, 8138);
INSERT INTO 'albumsrecordingsmap' VALUES (8650, 18, 976, 8139);
INSERT INTO 'albumsrecordingsmap' VALUES (8651, 19, 976, 8140);
INSERT INTO 'albumsrecordingsmap' VALUES (8652, 1, 977, 8141);
INSERT INTO 'albumsrecordingsmap' VALUES (8653, 2, 977, 8142);
INSERT INTO 'albumsrecordingsmap' VALUES (8654, 3, 977, 8143);
INSERT INTO 'albumsrecordingsmap' VALUES (8655, 4, 977, 8144);
INSERT INTO 'albumsrecordingsmap' VALUES (8656, 5, 977, 8145);
INSERT INTO 'albumsrecordingsmap' VALUES (8657, 6, 977, 8146);
INSERT INTO 'albumsrecordingsmap' VALUES (8658, 7, 977, 8147);
INSERT INTO 'albumsrecordingsmap' VALUES (8659, 8, 977, 8148);
INSERT INTO 'albumsrecordingsmap' VALUES (8660, 9, 977, 8149);
INSERT INTO 'albumsrecordingsmap' VALUES (8661, 10, 977, 8150);
INSERT INTO 'albumsrecordingsmap' VALUES (8662, 11, 977, 8151);
INSERT INTO 'albumsrecordingsmap' VALUES (8663, 12, 977, 8152);
INSERT INTO 'albumsrecordingsmap' VALUES (8664, 13, 977, 8153);
INSERT INTO 'albumsrecordingsmap' VALUES (8665, 14, 977, 8154);
INSERT INTO 'albumsrecordingsmap' VALUES (8666, 15, 977, 8155);
INSERT INTO 'albumsrecordingsmap' VALUES (8667, 1, 978, 8156);
INSERT INTO 'albumsrecordingsmap' VALUES (8668, 2, 978, 8157);
INSERT INTO 'albumsrecordingsmap' VALUES (8669, 3, 978, 8158);
INSERT INTO 'albumsrecordingsmap' VALUES (8670, 4, 978, 8159);
INSERT INTO 'albumsrecordingsmap' VALUES (8671, 5, 978, 8160);
INSERT INTO 'albumsrecordingsmap' VALUES (8672, 6, 978, 8161);
INSERT INTO 'albumsrecordingsmap' VALUES (8673, 7, 978, 8162);
INSERT INTO 'albumsrecordingsmap' VALUES (8674, 8, 978, 8163);
INSERT INTO 'albumsrecordingsmap' VALUES (8675, 9, 978, 8164);
INSERT INTO 'albumsrecordingsmap' VALUES (8676, 10, 978, 8165);
INSERT INTO 'albumsrecordingsmap' VALUES (8677, 11, 978, 8166);
INSERT INTO 'albumsrecordingsmap' VALUES (8678, 12, 978, 8167);
INSERT INTO 'albumsrecordingsmap' VALUES (8679, 13, 978, 8168);
INSERT INTO 'albumsrecordingsmap' VALUES (8680, 14, 978, 8169);
INSERT INTO 'albumsrecordingsmap' VALUES (8681, 15, 978, 8170);
INSERT INTO 'albumsrecordingsmap' VALUES (8682, 16, 978, 8171);
INSERT INTO 'albumsrecordingsmap' VALUES (8683, 17, 978, 8172);
INSERT INTO 'albumsrecordingsmap' VALUES (8684, 18, 978, 8173);
INSERT INTO 'albumsrecordingsmap' VALUES (8685, 19, 978, 8174);
INSERT INTO 'albumsrecordingsmap' VALUES (8686, 20, 978, 8175);
INSERT INTO 'albumsrecordingsmap' VALUES (8687, 21, 978, 8176);
INSERT INTO 'albumsrecordingsmap' VALUES (8688, 1, 979, 8177);
INSERT INTO 'albumsrecordingsmap' VALUES (8689, 2, 979, 8178);
INSERT INTO 'albumsrecordingsmap' VALUES (8690, 3, 979, 8179);
INSERT INTO 'albumsrecordingsmap' VALUES (8691, 4, 979, 8180);
INSERT INTO 'albumsrecordingsmap' VALUES (8692, 5, 979, 8181);
INSERT INTO 'albumsrecordingsmap' VALUES (8693, 6, 979, 8182);
INSERT INTO 'albumsrecordingsmap' VALUES (8694, 7, 979, 8183);
INSERT INTO 'albumsrecordingsmap' VALUES (8695, 8, 979, 8184);
INSERT INTO 'albumsrecordingsmap' VALUES (8696, 9, 979, 8185);
INSERT INTO 'albumsrecordingsmap' VALUES (8697, 10, 979, 8186);
INSERT INTO 'albumsrecordingsmap' VALUES (8698, 11, 979, 8187);
INSERT INTO 'albumsrecordingsmap' VALUES (8699, 12, 979, 8188);
INSERT INTO 'albumsrecordingsmap' VALUES (8700, 13, 979, 8189);
INSERT INTO 'albumsrecordingsmap' VALUES (8701, 14, 979, 8190);
INSERT INTO 'albumsrecordingsmap' VALUES (8702, 15, 979, 8191);
INSERT INTO 'albumsrecordingsmap' VALUES (8703, 16, 979, 8192);
INSERT INTO 'albumsrecordingsmap' VALUES (8704, 17, 979, 8193);
INSERT INTO 'albumsrecordingsmap' VALUES (8705, 18, 979, 8194);
INSERT INTO 'albumsrecordingsmap' VALUES (8706, 19, 979, 8195);
INSERT INTO 'albumsrecordingsmap' VALUES (8707, 1, 980, 8196);
INSERT INTO 'albumsrecordingsmap' VALUES (8708, 2, 980, 8197);
INSERT INTO 'albumsrecordingsmap' VALUES (8709, 3, 980, 8198);
INSERT INTO 'albumsrecordingsmap' VALUES (8710, 4, 980, 8199);
INSERT INTO 'albumsrecordingsmap' VALUES (8711, 5, 980, 8200);
INSERT INTO 'albumsrecordingsmap' VALUES (8712, 6, 980, 8201);
INSERT INTO 'albumsrecordingsmap' VALUES (8713, 7, 980, 8202);
INSERT INTO 'albumsrecordingsmap' VALUES (8714, 8, 980, 8203);
INSERT INTO 'albumsrecordingsmap' VALUES (8715, 9, 980, 8204);
INSERT INTO 'albumsrecordingsmap' VALUES (8716, 10, 980, 8205);
INSERT INTO 'albumsrecordingsmap' VALUES (8717, 11, 980, 8206);
INSERT INTO 'albumsrecordingsmap' VALUES (8718, 12, 980, 8207);
INSERT INTO 'albumsrecordingsmap' VALUES (8719, 13, 980, 8208);
INSERT INTO 'albumsrecordingsmap' VALUES (8720, 14, 980, 8209);
INSERT INTO 'albumsrecordingsmap' VALUES (8721, 15, 980, 8210);
INSERT INTO 'albumsrecordingsmap' VALUES (8722, 16, 980, 8211);
INSERT INTO 'albumsrecordingsmap' VALUES (8723, 17, 980, 8212);
INSERT INTO 'albumsrecordingsmap' VALUES (8724, 18, 980, 8213);
INSERT INTO 'albumsrecordingsmap' VALUES (8725, 19, 980, 8214);
INSERT INTO 'albumsrecordingsmap' VALUES (8726, 20, 980, 8215);
INSERT INTO 'albumsrecordingsmap' VALUES (8727, 1, 981, 8216);
INSERT INTO 'albumsrecordingsmap' VALUES (8728, 2, 981, 8217);
INSERT INTO 'albumsrecordingsmap' VALUES (8729, 3, 981, 8218);
INSERT INTO 'albumsrecordingsmap' VALUES (8730, 4, 981, 8219);
INSERT INTO 'albumsrecordingsmap' VALUES (8731, 5, 981, 8220);
INSERT INTO 'albumsrecordingsmap' VALUES (8732, 6, 981, 8221);
INSERT INTO 'albumsrecordingsmap' VALUES (8733, 7, 981, 8222);
INSERT INTO 'albumsrecordingsmap' VALUES (8734, 8, 981, 8223);
INSERT INTO 'albumsrecordingsmap' VALUES (8735, 9, 981, 8224);
INSERT INTO 'albumsrecordingsmap' VALUES (8736, 10, 981, 8225);
INSERT INTO 'albumsrecordingsmap' VALUES (8737, 11, 981, 8226);
INSERT INTO 'albumsrecordingsmap' VALUES (8738, 12, 981, 8227);
INSERT INTO 'albumsrecordingsmap' VALUES (8739, 13, 981, 8228);
INSERT INTO 'albumsrecordingsmap' VALUES (8740, 14, 981, 8229);
INSERT INTO 'albumsrecordingsmap' VALUES (8741, 15, 981, 8230);
INSERT INTO 'albumsrecordingsmap' VALUES (8742, 16, 981, 8231);
INSERT INTO 'albumsrecordingsmap' VALUES (8743, 17, 981, 8232);
INSERT INTO 'albumsrecordingsmap' VALUES (8744, 18, 981, 8233);
INSERT INTO 'albumsrecordingsmap' VALUES (8745, 19, 981, 8234);
INSERT INTO 'albumsrecordingsmap' VALUES (8746, 20, 981, 8235);
INSERT INTO 'albumsrecordingsmap' VALUES (8747, 1, 982, 8236);
INSERT INTO 'albumsrecordingsmap' VALUES (8748, 2, 982, 8237);
INSERT INTO 'albumsrecordingsmap' VALUES (8749, 3, 982, 8238);
INSERT INTO 'albumsrecordingsmap' VALUES (8750, 4, 982, 8239);
INSERT INTO 'albumsrecordingsmap' VALUES (8751, 5, 982, 8240);
INSERT INTO 'albumsrecordingsmap' VALUES (8752, 6, 982, 8241);
INSERT INTO 'albumsrecordingsmap' VALUES (8753, 7, 982, 8242);
INSERT INTO 'albumsrecordingsmap' VALUES (8754, 8, 982, 8243);
INSERT INTO 'albumsrecordingsmap' VALUES (8755, 9, 982, 8244);
INSERT INTO 'albumsrecordingsmap' VALUES (8756, 10, 982, 8245);
INSERT INTO 'albumsrecordingsmap' VALUES (8757, 11, 982, 8246);
INSERT INTO 'albumsrecordingsmap' VALUES (8758, 12, 982, 8247);
INSERT INTO 'albumsrecordingsmap' VALUES (8759, 13, 982, 8248);
INSERT INTO 'albumsrecordingsmap' VALUES (8760, 14, 982, 8249);
INSERT INTO 'albumsrecordingsmap' VALUES (8761, 15, 982, 8250);
INSERT INTO 'albumsrecordingsmap' VALUES (8762, 16, 982, 8251);
INSERT INTO 'albumsrecordingsmap' VALUES (8763, 1, 983, 8252);
INSERT INTO 'albumsrecordingsmap' VALUES (8764, 2, 983, 8253);
INSERT INTO 'albumsrecordingsmap' VALUES (8765, 3, 983, 8254);
INSERT INTO 'albumsrecordingsmap' VALUES (8766, 4, 983, 8255);
INSERT INTO 'albumsrecordingsmap' VALUES (8767, 5, 983, 8256);
INSERT INTO 'albumsrecordingsmap' VALUES (8768, 6, 983, 8257);
INSERT INTO 'albumsrecordingsmap' VALUES (8769, 7, 983, 8258);
INSERT INTO 'albumsrecordingsmap' VALUES (8770, 8, 983, 8259);
INSERT INTO 'albumsrecordingsmap' VALUES (8771, 9, 983, 8260);
INSERT INTO 'albumsrecordingsmap' VALUES (8772, 10, 983, 8261);
INSERT INTO 'albumsrecordingsmap' VALUES (8773, 11, 983, 8262);
INSERT INTO 'albumsrecordingsmap' VALUES (8774, 12, 983, 8263);
INSERT INTO 'albumsrecordingsmap' VALUES (8775, 13, 983, 8264);
INSERT INTO 'albumsrecordingsmap' VALUES (8776, 14, 983, 8265);
INSERT INTO 'albumsrecordingsmap' VALUES (8777, 15, 983, 8266);
INSERT INTO 'albumsrecordingsmap' VALUES (8778, 1, 984, 8267);
INSERT INTO 'albumsrecordingsmap' VALUES (8779, 2, 984, 8268);
INSERT INTO 'albumsrecordingsmap' VALUES (8780, 3, 984, 8269);
INSERT INTO 'albumsrecordingsmap' VALUES (8781, 4, 984, 8270);
INSERT INTO 'albumsrecordingsmap' VALUES (8782, 5, 984, 8271);
INSERT INTO 'albumsrecordingsmap' VALUES (8783, 6, 984, 8272);
INSERT INTO 'albumsrecordingsmap' VALUES (8784, 7, 984, 8273);
INSERT INTO 'albumsrecordingsmap' VALUES (8785, 8, 984, 8274);
INSERT INTO 'albumsrecordingsmap' VALUES (8786, 9, 984, 8275);
INSERT INTO 'albumsrecordingsmap' VALUES (8787, 10, 984, 8276);
INSERT INTO 'albumsrecordingsmap' VALUES (8788, 11, 984, 8277);
INSERT INTO 'albumsrecordingsmap' VALUES (8789, 12, 984, 8278);
INSERT INTO 'albumsrecordingsmap' VALUES (8790, 13, 984, 8279);
INSERT INTO 'albumsrecordingsmap' VALUES (8791, 14, 984, 8280);
INSERT INTO 'albumsrecordingsmap' VALUES (8792, 15, 984, 8281);
INSERT INTO 'albumsrecordingsmap' VALUES (8793, 16, 984, 8282);
INSERT INTO 'albumsrecordingsmap' VALUES (8794, 17, 984, 8283);
INSERT INTO 'albumsrecordingsmap' VALUES (8795, 18, 984, 8284);
INSERT INTO 'albumsrecordingsmap' VALUES (8796, 19, 984, 8285);
INSERT INTO 'albumsrecordingsmap' VALUES (8797, 1, 985, 8286);
INSERT INTO 'albumsrecordingsmap' VALUES (8798, 2, 985, 8287);
INSERT INTO 'albumsrecordingsmap' VALUES (8799, 3, 985, 8288);
INSERT INTO 'albumsrecordingsmap' VALUES (8800, 4, 985, 8289);
INSERT INTO 'albumsrecordingsmap' VALUES (8801, 5, 985, 8290);
INSERT INTO 'albumsrecordingsmap' VALUES (8802, 6, 985, 8291);
INSERT INTO 'albumsrecordingsmap' VALUES (8803, 7, 985, 8292);
INSERT INTO 'albumsrecordingsmap' VALUES (8804, 8, 985, 8293);
INSERT INTO 'albumsrecordingsmap' VALUES (8805, 9, 985, 8294);
INSERT INTO 'albumsrecordingsmap' VALUES (8806, 10, 985, 8295);
INSERT INTO 'albumsrecordingsmap' VALUES (8807, 11, 985, 8296);
INSERT INTO 'albumsrecordingsmap' VALUES (8808, 12, 985, 8297);
INSERT INTO 'albumsrecordingsmap' VALUES (8809, 13, 985, 8298);
INSERT INTO 'albumsrecordingsmap' VALUES (8810, 14, 985, 8299);
INSERT INTO 'albumsrecordingsmap' VALUES (8811, 15, 985, 8300);
INSERT INTO 'albumsrecordingsmap' VALUES (8812, 1, 986, 8301);
INSERT INTO 'albumsrecordingsmap' VALUES (8813, 2, 986, 8302);
INSERT INTO 'albumsrecordingsmap' VALUES (8814, 3, 986, 8303);
INSERT INTO 'albumsrecordingsmap' VALUES (8815, 4, 986, 8304);
INSERT INTO 'albumsrecordingsmap' VALUES (8816, 5, 986, 8305);
INSERT INTO 'albumsrecordingsmap' VALUES (8817, 6, 986, 8306);
INSERT INTO 'albumsrecordingsmap' VALUES (8818, 7, 986, 8307);
INSERT INTO 'albumsrecordingsmap' VALUES (8819, 8, 986, 8308);
INSERT INTO 'albumsrecordingsmap' VALUES (8820, 9, 986, 8309);
INSERT INTO 'albumsrecordingsmap' VALUES (8821, 10, 986, 8310);
INSERT INTO 'albumsrecordingsmap' VALUES (8822, 11, 986, 8311);
INSERT INTO 'albumsrecordingsmap' VALUES (8823, 12, 986, 8312);
INSERT INTO 'albumsrecordingsmap' VALUES (8824, 13, 986, 8313);
INSERT INTO 'albumsrecordingsmap' VALUES (8825, 14, 986, 8314);
INSERT INTO 'albumsrecordingsmap' VALUES (8826, 15, 986, 8315);
INSERT INTO 'albumsrecordingsmap' VALUES (8827, 16, 986, 8316);
INSERT INTO 'albumsrecordingsmap' VALUES (8828, 1, 987, 8317);
INSERT INTO 'albumsrecordingsmap' VALUES (8829, 2, 987, 8318);
INSERT INTO 'albumsrecordingsmap' VALUES (8830, 3, 987, 8319);
INSERT INTO 'albumsrecordingsmap' VALUES (8831, 4, 987, 8320);
INSERT INTO 'albumsrecordingsmap' VALUES (8832, 5, 987, 8321);
INSERT INTO 'albumsrecordingsmap' VALUES (8833, 6, 987, 8322);
INSERT INTO 'albumsrecordingsmap' VALUES (8834, 1, 988, 8323);
INSERT INTO 'albumsrecordingsmap' VALUES (8835, 2, 988, 8324);
INSERT INTO 'albumsrecordingsmap' VALUES (8836, 3, 988, 8325);
INSERT INTO 'albumsrecordingsmap' VALUES (8837, 4, 988, 8326);
INSERT INTO 'albumsrecordingsmap' VALUES (8838, 5, 988, 8327);
INSERT INTO 'albumsrecordingsmap' VALUES (8839, 6, 988, 8328);
INSERT INTO 'albumsrecordingsmap' VALUES (8840, 7, 988, 8329);
INSERT INTO 'albumsrecordingsmap' VALUES (8841, 8, 988, 8330);
INSERT INTO 'albumsrecordingsmap' VALUES (8842, 9, 988, 8331);
INSERT INTO 'albumsrecordingsmap' VALUES (8843, 10, 988, 8332);
INSERT INTO 'albumsrecordingsmap' VALUES (8844, 11, 988, 8333);
INSERT INTO 'albumsrecordingsmap' VALUES (8845, 12, 988, 8334);
INSERT INTO 'albumsrecordingsmap' VALUES (8846, 13, 988, 8335);
INSERT INTO 'albumsrecordingsmap' VALUES (8847, 14, 988, 8336);
INSERT INTO 'albumsrecordingsmap' VALUES (8848, 1, 989, 8337);
INSERT INTO 'albumsrecordingsmap' VALUES (8849, 2, 989, 8338);
INSERT INTO 'albumsrecordingsmap' VALUES (8850, 3, 989, 8339);
INSERT INTO 'albumsrecordingsmap' VALUES (8851, 4, 989, 8340);
INSERT INTO 'albumsrecordingsmap' VALUES (8852, 5, 989, 8341);
INSERT INTO 'albumsrecordingsmap' VALUES (8853, 6, 989, 8342);
INSERT INTO 'albumsrecordingsmap' VALUES (8854, 7, 989, 8343);
INSERT INTO 'albumsrecordingsmap' VALUES (8855, 8, 989, 8344);
INSERT INTO 'albumsrecordingsmap' VALUES (8856, 9, 989, 8345);
INSERT INTO 'albumsrecordingsmap' VALUES (8857, 10, 989, 8346);
INSERT INTO 'albumsrecordingsmap' VALUES (8858, 1, 990, 8347);
INSERT INTO 'albumsrecordingsmap' VALUES (8859, 2, 990, 8348);
INSERT INTO 'albumsrecordingsmap' VALUES (8860, 3, 990, 8349);
INSERT INTO 'albumsrecordingsmap' VALUES (8861, 4, 990, 8350);
INSERT INTO 'albumsrecordingsmap' VALUES (8862, 5, 990, 8351);
INSERT INTO 'albumsrecordingsmap' VALUES (8863, 6, 990, 8352);
INSERT INTO 'albumsrecordingsmap' VALUES (8864, 7, 990, 8353);
INSERT INTO 'albumsrecordingsmap' VALUES (8865, 8, 990, 8354);
INSERT INTO 'albumsrecordingsmap' VALUES (8866, 9, 990, 8355);
INSERT INTO 'albumsrecordingsmap' VALUES (8867, 10, 990, 8356);
INSERT INTO 'albumsrecordingsmap' VALUES (8868, 11, 990, 8357);
INSERT INTO 'albumsrecordingsmap' VALUES (8869, 12, 990, 8358);
INSERT INTO 'albumsrecordingsmap' VALUES (8870, 13, 990, 8359);
INSERT INTO 'albumsrecordingsmap' VALUES (8871, 14, 990, 8360);
INSERT INTO 'albumsrecordingsmap' VALUES (8872, 15, 990, 8361);
INSERT INTO 'albumsrecordingsmap' VALUES (8873, 16, 990, 8362);
INSERT INTO 'albumsrecordingsmap' VALUES (8874, 17, 990, 8363);
INSERT INTO 'albumsrecordingsmap' VALUES (8875, 18, 990, 8364);
INSERT INTO 'albumsrecordingsmap' VALUES (8876, 19, 990, 8365);
INSERT INTO 'albumsrecordingsmap' VALUES (8877, 1, 991, 8366);
INSERT INTO 'albumsrecordingsmap' VALUES (8878, 2, 991, 8367);
INSERT INTO 'albumsrecordingsmap' VALUES (8879, 3, 991, 8368);
INSERT INTO 'albumsrecordingsmap' VALUES (8880, 4, 991, 8369);
INSERT INTO 'albumsrecordingsmap' VALUES (8881, 5, 991, 8370);
INSERT INTO 'albumsrecordingsmap' VALUES (8882, 6, 991, 8371);
INSERT INTO 'albumsrecordingsmap' VALUES (8883, 7, 991, 8372);
INSERT INTO 'albumsrecordingsmap' VALUES (8884, 8, 991, 8373);
INSERT INTO 'albumsrecordingsmap' VALUES (8885, 9, 991, 8374);
INSERT INTO 'albumsrecordingsmap' VALUES (8886, 10, 991, 8375);
INSERT INTO 'albumsrecordingsmap' VALUES (8887, 11, 991, 8376);
INSERT INTO 'albumsrecordingsmap' VALUES (8888, 12, 991, 8377);
INSERT INTO 'albumsrecordingsmap' VALUES (8889, 13, 991, 8378);
INSERT INTO 'albumsrecordingsmap' VALUES (8890, 14, 991, 8379);
INSERT INTO 'albumsrecordingsmap' VALUES (8917, 1, 995, 8406);
INSERT INTO 'albumsrecordingsmap' VALUES (8918, 2, 995, 8407);
INSERT INTO 'albumsrecordingsmap' VALUES (8919, 3, 995, 8408);
INSERT INTO 'albumsrecordingsmap' VALUES (8920, 4, 995, 8409);
INSERT INTO 'albumsrecordingsmap' VALUES (8921, 5, 995, 8410);
INSERT INTO 'albumsrecordingsmap' VALUES (8922, 6, 995, 8411);
INSERT INTO 'albumsrecordingsmap' VALUES (8923, 7, 995, 8412);
INSERT INTO 'albumsrecordingsmap' VALUES (8924, 8, 995, 8413);
INSERT INTO 'albumsrecordingsmap' VALUES (8925, 9, 995, 8414);
INSERT INTO 'albumsrecordingsmap' VALUES (8926, 10, 995, 8415);
INSERT INTO 'albumsrecordingsmap' VALUES (8927, 11, 995, 8416);
INSERT INTO 'albumsrecordingsmap' VALUES (8928, 12, 995, 8417);
INSERT INTO 'albumsrecordingsmap' VALUES (8929, 13, 995, 8418);
INSERT INTO 'albumsrecordingsmap' VALUES (8930, 14, 995, 8419);
INSERT INTO 'albumsrecordingsmap' VALUES (8931, 15, 995, 8420);
INSERT INTO 'albumsrecordingsmap' VALUES (8932, 1, 996, 8421);
INSERT INTO 'albumsrecordingsmap' VALUES (8933, 2, 996, 8422);
INSERT INTO 'albumsrecordingsmap' VALUES (8934, 3, 996, 8423);
INSERT INTO 'albumsrecordingsmap' VALUES (8935, 4, 996, 8424);
INSERT INTO 'albumsrecordingsmap' VALUES (8936, 5, 996, 8425);
INSERT INTO 'albumsrecordingsmap' VALUES (8937, 6, 996, 8426);
INSERT INTO 'albumsrecordingsmap' VALUES (8938, 7, 996, 8427);
INSERT INTO 'albumsrecordingsmap' VALUES (8939, 8, 996, 8428);
INSERT INTO 'albumsrecordingsmap' VALUES (8940, 9, 996, 8429);
INSERT INTO 'albumsrecordingsmap' VALUES (8941, 10, 996, 8430);
INSERT INTO 'albumsrecordingsmap' VALUES (8942, 11, 996, 8431);
INSERT INTO 'albumsrecordingsmap' VALUES (8943, 12, 996, 8432);
INSERT INTO 'albumsrecordingsmap' VALUES (8944, 13, 996, 8433);
INSERT INTO 'albumsrecordingsmap' VALUES (8945, 14, 996, 8434);
INSERT INTO 'albumsrecordingsmap' VALUES (8946, 15, 996, 8435);
INSERT INTO 'albumsrecordingsmap' VALUES (8947, 16, 996, 8436);
INSERT INTO 'albumsrecordingsmap' VALUES (8948, 17, 996, 8437);
INSERT INTO 'albumsrecordingsmap' VALUES (8949, 18, 996, 8438);
INSERT INTO 'albumsrecordingsmap' VALUES (8950, 19, 996, 8439);
INSERT INTO 'albumsrecordingsmap' VALUES (8951, 20, 996, 8440);
INSERT INTO 'albumsrecordingsmap' VALUES (8952, 21, 996, 8441);
INSERT INTO 'albumsrecordingsmap' VALUES (8953, 22, 996, 8442);
INSERT INTO 'albumsrecordingsmap' VALUES (8954, 23, 996, 8443);
INSERT INTO 'albumsrecordingsmap' VALUES (8955, 24, 996, 8444);
INSERT INTO 'albumsrecordingsmap' VALUES (8956, 25, 996, 8445);
INSERT INTO 'albumsrecordingsmap' VALUES (8957, 26, 996, 8446);
INSERT INTO 'albumsrecordingsmap' VALUES (8958, 27, 996, 8447);
INSERT INTO 'albumsrecordingsmap' VALUES (8959, 28, 996, 8448);
INSERT INTO 'albumsrecordingsmap' VALUES (8960, 29, 996, 8449);
INSERT INTO 'albumsrecordingsmap' VALUES (8961, 30, 996, 8450);
INSERT INTO 'albumsrecordingsmap' VALUES (8962, 31, 996, 8451);
INSERT INTO 'albumsrecordingsmap' VALUES (8963, 32, 996, 8452);
INSERT INTO 'albumsrecordingsmap' VALUES (8964, 33, 996, 8453);
INSERT INTO 'albumsrecordingsmap' VALUES (8965, 34, 996, 8454);
INSERT INTO 'albumsrecordingsmap' VALUES (8966, 35, 996, 8455);
INSERT INTO 'albumsrecordingsmap' VALUES (8967, 1, 997, 8456);
INSERT INTO 'albumsrecordingsmap' VALUES (8968, 2, 997, 8457);
INSERT INTO 'albumsrecordingsmap' VALUES (8969, 3, 997, 8458);
INSERT INTO 'albumsrecordingsmap' VALUES (8970, 4, 997, 8459);
INSERT INTO 'albumsrecordingsmap' VALUES (8971, 5, 997, 8460);
INSERT INTO 'albumsrecordingsmap' VALUES (8972, 6, 997, 8461);
INSERT INTO 'albumsrecordingsmap' VALUES (8973, 7, 997, 8462);
INSERT INTO 'albumsrecordingsmap' VALUES (8974, 8, 997, 8463);
INSERT INTO 'albumsrecordingsmap' VALUES (8975, 9, 997, 8464);
INSERT INTO 'albumsrecordingsmap' VALUES (8976, 10, 997, 8465);
INSERT INTO 'albumsrecordingsmap' VALUES (8977, 11, 997, 8466);
INSERT INTO 'albumsrecordingsmap' VALUES (8978, 12, 997, 8467);
INSERT INTO 'albumsrecordingsmap' VALUES (8979, 13, 997, 8468);
INSERT INTO 'albumsrecordingsmap' VALUES (9013, 1, 999, 8502);
INSERT INTO 'albumsrecordingsmap' VALUES (9014, 2, 999, 8503);
INSERT INTO 'albumsrecordingsmap' VALUES (9015, 3, 999, 8504);
INSERT INTO 'albumsrecordingsmap' VALUES (9016, 4, 999, 8505);
INSERT INTO 'albumsrecordingsmap' VALUES (9017, 5, 999, 8506);
INSERT INTO 'albumsrecordingsmap' VALUES (9018, 6, 999, 8507);
INSERT INTO 'albumsrecordingsmap' VALUES (9019, 7, 999, 8508);
INSERT INTO 'albumsrecordingsmap' VALUES (9020, 8, 999, 8509);
INSERT INTO 'albumsrecordingsmap' VALUES (9021, 9, 999, 8510);
INSERT INTO 'albumsrecordingsmap' VALUES (9022, 10, 999, 8511);
INSERT INTO 'albumsrecordingsmap' VALUES (9023, 11, 999, 8512);
INSERT INTO 'albumsrecordingsmap' VALUES (9024, 12, 999, 8513);
INSERT INTO 'albumsrecordingsmap' VALUES (9025, 13, 999, 8514);
INSERT INTO 'albumsrecordingsmap' VALUES (9026, 14, 999, 8515);
INSERT INTO 'albumsrecordingsmap' VALUES (9027, 15, 999, 8516);
INSERT INTO 'albumsrecordingsmap' VALUES (9028, 16, 999, 8517);
INSERT INTO 'albumsrecordingsmap' VALUES (9029, 1, 1000, 8518);
INSERT INTO 'albumsrecordingsmap' VALUES (9030, 2, 1000, 8519);
INSERT INTO 'albumsrecordingsmap' VALUES (9031, 3, 1000, 8520);
INSERT INTO 'albumsrecordingsmap' VALUES (9032, 4, 1000, 8521);
INSERT INTO 'albumsrecordingsmap' VALUES (9033, 5, 1000, 8522);
INSERT INTO 'albumsrecordingsmap' VALUES (9034, 6, 1000, 8523);
INSERT INTO 'albumsrecordingsmap' VALUES (9035, 7, 1000, 8524);
INSERT INTO 'albumsrecordingsmap' VALUES (9036, 8, 1000, 8525);
INSERT INTO 'albumsrecordingsmap' VALUES (9037, 9, 1000, 8526);
INSERT INTO 'albumsrecordingsmap' VALUES (9038, 10, 1000, 8527);
INSERT INTO 'albumsrecordingsmap' VALUES (9039, 11, 1000, 8528);
INSERT INTO 'albumsrecordingsmap' VALUES (9040, 12, 1000, 8529);
INSERT INTO 'albumsrecordingsmap' VALUES (9041, 13, 1000, 8530);
INSERT INTO 'albumsrecordingsmap' VALUES (9042, 14, 1000, 8531);
INSERT INTO 'albumsrecordingsmap' VALUES (9043, 15, 1000, 8532);
INSERT INTO 'albumsrecordingsmap' VALUES (9044, 16, 1000, 8533);
INSERT INTO 'albumsrecordingsmap' VALUES (9045, 17, 1000, 8534);
INSERT INTO 'albumsrecordingsmap' VALUES (9046, 18, 1000, 8535);
INSERT INTO 'albumsrecordingsmap' VALUES (9047, 19, 1000, 8536);
INSERT INTO 'albumsrecordingsmap' VALUES (9048, 20, 1000, 8537);
INSERT INTO 'albumsrecordingsmap' VALUES (9049, 1, 1001, 8556);
INSERT INTO 'albumsrecordingsmap' VALUES (9050, 2, 1001, 8557);
INSERT INTO 'albumsrecordingsmap' VALUES (9051, 3, 1001, 8558);
INSERT INTO 'albumsrecordingsmap' VALUES (9052, 4, 1001, 8559);
INSERT INTO 'albumsrecordingsmap' VALUES (9053, 5, 1001, 8560);
INSERT INTO 'albumsrecordingsmap' VALUES (9054, 6, 1001, 8561);
INSERT INTO 'albumsrecordingsmap' VALUES (9055, 7, 1001, 8562);
INSERT INTO 'albumsrecordingsmap' VALUES (9056, 8, 1001, 8563);
INSERT INTO 'albumsrecordingsmap' VALUES (9057, 9, 1001, 8564);
INSERT INTO 'albumsrecordingsmap' VALUES (9058, 10, 1001, 8565);
INSERT INTO 'albumsrecordingsmap' VALUES (9059, 11, 1001, 8566);
INSERT INTO 'albumsrecordingsmap' VALUES (9060, 12, 1001, 8567);
INSERT INTO 'albumsrecordingsmap' VALUES (9061, 13, 1001, 8568);
INSERT INTO 'albumsrecordingsmap' VALUES (9062, 14, 1001, 8569);
INSERT INTO 'albumsrecordingsmap' VALUES (9063, 15, 1001, 8570);
INSERT INTO 'albumsrecordingsmap' VALUES (9064, 16, 1001, 8571);
INSERT INTO 'albumsrecordingsmap' VALUES (9065, 17, 1001, 8572);
INSERT INTO 'albumsrecordingsmap' VALUES (9066, 18, 1001, 8573);
INSERT INTO 'albumsrecordingsmap' VALUES (9067, 1, 1002, 8574);
INSERT INTO 'albumsrecordingsmap' VALUES (9068, 2, 1002, 8575);
INSERT INTO 'albumsrecordingsmap' VALUES (9069, 3, 1002, 8576);
INSERT INTO 'albumsrecordingsmap' VALUES (9070, 4, 1002, 8577);
INSERT INTO 'albumsrecordingsmap' VALUES (9071, 5, 1002, 8578);
INSERT INTO 'albumsrecordingsmap' VALUES (9072, 6, 1002, 8579);
INSERT INTO 'albumsrecordingsmap' VALUES (9073, 7, 1002, 8580);
INSERT INTO 'albumsrecordingsmap' VALUES (9074, 8, 1002, 8581);
INSERT INTO 'albumsrecordingsmap' VALUES (9075, 9, 1002, 8582);
INSERT INTO 'albumsrecordingsmap' VALUES (9076, 10, 1002, 8583);
INSERT INTO 'albumsrecordingsmap' VALUES (9077, 11, 1002, 8584);
INSERT INTO 'albumsrecordingsmap' VALUES (9078, 12, 1002, 8585);
INSERT INTO 'albumsrecordingsmap' VALUES (9079, 13, 1002, 8586);
INSERT INTO 'albumsrecordingsmap' VALUES (9080, 14, 1002, 8587);
INSERT INTO 'albumsrecordingsmap' VALUES (9081, 15, 1002, 8588);
INSERT INTO 'albumsrecordingsmap' VALUES (9082, 16, 1002, 8589);
INSERT INTO 'albumsrecordingsmap' VALUES (9083, 17, 1002, 8590);
INSERT INTO 'albumsrecordingsmap' VALUES (9084, 18, 1002, 8591);
INSERT INTO 'albumsrecordingsmap' VALUES (9085, 19, 1002, 8592);
INSERT INTO 'albumsrecordingsmap' VALUES (9086, 20, 1002, 8593);
INSERT INTO 'albumsrecordingsmap' VALUES (9087, 21, 1002, 8594);
INSERT INTO 'albumsrecordingsmap' VALUES (9088, 1, 1003, 8595);
INSERT INTO 'albumsrecordingsmap' VALUES (9089, 2, 1003, 8596);
INSERT INTO 'albumsrecordingsmap' VALUES (9090, 3, 1003, 8597);
INSERT INTO 'albumsrecordingsmap' VALUES (9091, 4, 1003, 8598);
INSERT INTO 'albumsrecordingsmap' VALUES (9092, 5, 1003, 8599);
INSERT INTO 'albumsrecordingsmap' VALUES (9093, 6, 1003, 8600);
INSERT INTO 'albumsrecordingsmap' VALUES (9094, 7, 1003, 8601);
INSERT INTO 'albumsrecordingsmap' VALUES (9095, 8, 1003, 8602);
INSERT INTO 'albumsrecordingsmap' VALUES (9096, 9, 1003, 8603);
INSERT INTO 'albumsrecordingsmap' VALUES (9097, 10, 1003, 8604);
INSERT INTO 'albumsrecordingsmap' VALUES (9098, 11, 1003, 8605);
INSERT INTO 'albumsrecordingsmap' VALUES (9099, 12, 1003, 8606);
INSERT INTO 'albumsrecordingsmap' VALUES (9100, 13, 1003, 8607);
INSERT INTO 'albumsrecordingsmap' VALUES (9101, 14, 1003, 8608);
INSERT INTO 'albumsrecordingsmap' VALUES (9102, 15, 1003, 8609);
INSERT INTO 'albumsrecordingsmap' VALUES (9103, 16, 1003, 8610);
INSERT INTO 'albumsrecordingsmap' VALUES (9104, 1, 1004, 8611);
INSERT INTO 'albumsrecordingsmap' VALUES (9105, 2, 1004, 8612);
INSERT INTO 'albumsrecordingsmap' VALUES (9106, 3, 1004, 8613);
INSERT INTO 'albumsrecordingsmap' VALUES (9107, 4, 1004, 8614);
INSERT INTO 'albumsrecordingsmap' VALUES (9108, 5, 1004, 8615);
INSERT INTO 'albumsrecordingsmap' VALUES (9109, 6, 1004, 8616);
INSERT INTO 'albumsrecordingsmap' VALUES (8980, 14, 997, 8469);
INSERT INTO 'albumsrecordingsmap' VALUES (8981, 15, 997, 8470);
INSERT INTO 'albumsrecordingsmap' VALUES (8982, 16, 997, 8471);
INSERT INTO 'albumsrecordingsmap' VALUES (8983, 17, 997, 8472);
INSERT INTO 'albumsrecordingsmap' VALUES (8984, 18, 997, 8473);
INSERT INTO 'albumsrecordingsmap' VALUES (8985, 19, 997, 8474);
INSERT INTO 'albumsrecordingsmap' VALUES (8986, 20, 997, 8475);
INSERT INTO 'albumsrecordingsmap' VALUES (8987, 21, 997, 8476);
INSERT INTO 'albumsrecordingsmap' VALUES (8988, 22, 997, 8477);
INSERT INTO 'albumsrecordingsmap' VALUES (8989, 23, 997, 8478);
INSERT INTO 'albumsrecordingsmap' VALUES (8990, 24, 997, 8479);
INSERT INTO 'albumsrecordingsmap' VALUES (8991, 25, 997, 8480);
INSERT INTO 'albumsrecordingsmap' VALUES (8992, 26, 997, 8481);
INSERT INTO 'albumsrecordingsmap' VALUES (9110, 7, 1004, 8617);
INSERT INTO 'albumsrecordingsmap' VALUES (9111, 8, 1004, 8618);
INSERT INTO 'albumsrecordingsmap' VALUES (9112, 9, 1004, 8619);
INSERT INTO 'albumsrecordingsmap' VALUES (9113, 10, 1004, 8620);
INSERT INTO 'albumsrecordingsmap' VALUES (9114, 11, 1004, 8621);
INSERT INTO 'albumsrecordingsmap' VALUES (9115, 12, 1004, 8622);
INSERT INTO 'albumsrecordingsmap' VALUES (9116, 13, 1004, 8623);
INSERT INTO 'albumsrecordingsmap' VALUES (9117, 14, 1004, 8624);
INSERT INTO 'albumsrecordingsmap' VALUES (9118, 15, 1004, 8625);
INSERT INTO 'albumsrecordingsmap' VALUES (9119, 16, 1004, 8626);
INSERT INTO 'albumsrecordingsmap' VALUES (9120, 17, 1004, 8627);
INSERT INTO 'albumsrecordingsmap' VALUES (9121, 18, 1004, 8628);
INSERT INTO 'albumsrecordingsmap' VALUES (9122, 19, 1004, 8629);
INSERT INTO 'albumsrecordingsmap' VALUES (9123, 1, 1005, 8650);
INSERT INTO 'albumsrecordingsmap' VALUES (9124, 2, 1005, 8651);
INSERT INTO 'albumsrecordingsmap' VALUES (9125, 3, 1005, 8652);
INSERT INTO 'albumsrecordingsmap' VALUES (9126, 4, 1005, 8653);
INSERT INTO 'albumsrecordingsmap' VALUES (9127, 5, 1005, 8654);
INSERT INTO 'albumsrecordingsmap' VALUES (9128, 6, 1005, 8655);
INSERT INTO 'albumsrecordingsmap' VALUES (9129, 7, 1005, 8656);
INSERT INTO 'albumsrecordingsmap' VALUES (9130, 8, 1005, 8657);
INSERT INTO 'albumsrecordingsmap' VALUES (9131, 9, 1005, 8658);
INSERT INTO 'albumsrecordingsmap' VALUES (9132, 10, 1005, 8659);
INSERT INTO 'albumsrecordingsmap' VALUES (9133, 11, 1005, 8660);
INSERT INTO 'albumsrecordingsmap' VALUES (9134, 12, 1005, 8661);
INSERT INTO 'albumsrecordingsmap' VALUES (9135, 13, 1005, 8662);
INSERT INTO 'albumsrecordingsmap' VALUES (9136, 14, 1005, 8663);
INSERT INTO 'albumsrecordingsmap' VALUES (9137, 15, 1005, 8664);
INSERT INTO 'albumsrecordingsmap' VALUES (9138, 16, 1005, 8665);
INSERT INTO 'albumsrecordingsmap' VALUES (9139, 17, 1005, 8666);
INSERT INTO 'albumsrecordingsmap' VALUES (9140, 18, 1005, 8667);
INSERT INTO 'albumsrecordingsmap' VALUES (9141, 19, 1005, 8668);
INSERT INTO 'albumsrecordingsmap' VALUES (9142, 20, 1005, 8669);
INSERT INTO 'albumsrecordingsmap' VALUES (9143, 1, 1006, 8670);
INSERT INTO 'albumsrecordingsmap' VALUES (9144, 2, 1006, 8671);
INSERT INTO 'albumsrecordingsmap' VALUES (9145, 3, 1006, 8672);
INSERT INTO 'albumsrecordingsmap' VALUES (9146, 4, 1006, 8673);
INSERT INTO 'albumsrecordingsmap' VALUES (9147, 5, 1006, 8674);
INSERT INTO 'albumsrecordingsmap' VALUES (9148, 6, 1006, 8675);
INSERT INTO 'albumsrecordingsmap' VALUES (9149, 7, 1006, 8676);
INSERT INTO 'albumsrecordingsmap' VALUES (9150, 8, 1006, 8677);
INSERT INTO 'albumsrecordingsmap' VALUES (9151, 9, 1006, 8678);
INSERT INTO 'albumsrecordingsmap' VALUES (9152, 10, 1006, 8679);
INSERT INTO 'albumsrecordingsmap' VALUES (9153, 11, 1006, 8680);
INSERT INTO 'albumsrecordingsmap' VALUES (9154, 12, 1006, 8681);
INSERT INTO 'albumsrecordingsmap' VALUES (9155, 13, 1006, 8682);
INSERT INTO 'albumsrecordingsmap' VALUES (9156, 14, 1006, 8683);
INSERT INTO 'albumsrecordingsmap' VALUES (9157, 15, 1006, 8684);
INSERT INTO 'albumsrecordingsmap' VALUES (9158, 16, 1006, 8685);
INSERT INTO 'albumsrecordingsmap' VALUES (9159, 17, 1006, 8686);
INSERT INTO 'albumsrecordingsmap' VALUES (9160, 18, 1006, 8687);
INSERT INTO 'albumsrecordingsmap' VALUES (9161, 19, 1006, 8688);
INSERT INTO 'albumsrecordingsmap' VALUES (9162, 20, 1006, 8689);
INSERT INTO 'albumsrecordingsmap' VALUES (9163, 1, 1007, 8690);
INSERT INTO 'albumsrecordingsmap' VALUES (9164, 2, 1007, 8691);
INSERT INTO 'albumsrecordingsmap' VALUES (9165, 3, 1007, 8692);
INSERT INTO 'albumsrecordingsmap' VALUES (9166, 4, 1007, 8693);
INSERT INTO 'albumsrecordingsmap' VALUES (9167, 5, 1007, 8694);
INSERT INTO 'albumsrecordingsmap' VALUES (9168, 6, 1007, 8695);
INSERT INTO 'albumsrecordingsmap' VALUES (9169, 7, 1007, 8696);
INSERT INTO 'albumsrecordingsmap' VALUES (9170, 8, 1007, 8697);
INSERT INTO 'albumsrecordingsmap' VALUES (9171, 9, 1007, 8698);
INSERT INTO 'albumsrecordingsmap' VALUES (9172, 10, 1007, 8699);
INSERT INTO 'albumsrecordingsmap' VALUES (9173, 11, 1007, 8700);
INSERT INTO 'albumsrecordingsmap' VALUES (9174, 12, 1007, 8701);
INSERT INTO 'albumsrecordingsmap' VALUES (9175, 13, 1007, 8702);
INSERT INTO 'albumsrecordingsmap' VALUES (9176, 1, 1008, 8703);
INSERT INTO 'albumsrecordingsmap' VALUES (9177, 2, 1008, 8704);
INSERT INTO 'albumsrecordingsmap' VALUES (9178, 3, 1008, 8705);
INSERT INTO 'albumsrecordingsmap' VALUES (9179, 4, 1008, 8706);
INSERT INTO 'albumsrecordingsmap' VALUES (9180, 5, 1008, 8707);
INSERT INTO 'albumsrecordingsmap' VALUES (9181, 6, 1008, 8708);
INSERT INTO 'albumsrecordingsmap' VALUES (9182, 7, 1008, 8709);
INSERT INTO 'albumsrecordingsmap' VALUES (9183, 8, 1008, 8710);
INSERT INTO 'albumsrecordingsmap' VALUES (9184, 9, 1008, 8711);
INSERT INTO 'albumsrecordingsmap' VALUES (9185, 10, 1008, 8712);
INSERT INTO 'albumsrecordingsmap' VALUES (9186, 11, 1008, 8713);
INSERT INTO 'albumsrecordingsmap' VALUES (9187, 12, 1008, 8714);
INSERT INTO 'albumsrecordingsmap' VALUES (9188, 13, 1008, 8715);
INSERT INTO 'albumsrecordingsmap' VALUES (9189, 14, 1008, 8716);
INSERT INTO 'albumsrecordingsmap' VALUES (9190, 15, 1008, 8717);
INSERT INTO 'albumsrecordingsmap' VALUES (9191, 1, 1009, 8718);
INSERT INTO 'albumsrecordingsmap' VALUES (9192, 2, 1009, 8719);
INSERT INTO 'albumsrecordingsmap' VALUES (9193, 3, 1009, 8720);
INSERT INTO 'albumsrecordingsmap' VALUES (9194, 4, 1009, 8721);
INSERT INTO 'albumsrecordingsmap' VALUES (9195, 5, 1009, 8722);
INSERT INTO 'albumsrecordingsmap' VALUES (9196, 6, 1009, 8723);
INSERT INTO 'albumsrecordingsmap' VALUES (9197, 7, 1009, 8724);
INSERT INTO 'albumsrecordingsmap' VALUES (9198, 8, 1009, 8725);
INSERT INTO 'albumsrecordingsmap' VALUES (9199, 9, 1009, 8726);
INSERT INTO 'albumsrecordingsmap' VALUES (9200, 10, 1009, 8727);
INSERT INTO 'albumsrecordingsmap' VALUES (9201, 11, 1009, 8728);
INSERT INTO 'albumsrecordingsmap' VALUES (9202, 12, 1009, 8729);
INSERT INTO 'albumsrecordingsmap' VALUES (9203, 13, 1009, 8730);
INSERT INTO 'albumsrecordingsmap' VALUES (9204, 14, 1009, 8731);
INSERT INTO 'albumsrecordingsmap' VALUES (9205, 15, 1009, 8732);
INSERT INTO 'albumsrecordingsmap' VALUES (9206, 16, 1009, 8733);
INSERT INTO 'albumsrecordingsmap' VALUES (9207, 17, 1009, 8734);
INSERT INTO 'albumsrecordingsmap' VALUES (9208, 18, 1009, 8735);
INSERT INTO 'albumsrecordingsmap' VALUES (9209, 1, 1010, 8736);
INSERT INTO 'albumsrecordingsmap' VALUES (9210, 2, 1010, 8737);
INSERT INTO 'albumsrecordingsmap' VALUES (9211, 3, 1010, 8738);
INSERT INTO 'albumsrecordingsmap' VALUES (9212, 4, 1010, 8739);
INSERT INTO 'albumsrecordingsmap' VALUES (9213, 5, 1010, 8740);
INSERT INTO 'albumsrecordingsmap' VALUES (9214, 6, 1010, 8741);
INSERT INTO 'albumsrecordingsmap' VALUES (9215, 7, 1010, 8742);
INSERT INTO 'albumsrecordingsmap' VALUES (9216, 8, 1010, 8743);
INSERT INTO 'albumsrecordingsmap' VALUES (9217, 9, 1010, 8744);
INSERT INTO 'albumsrecordingsmap' VALUES (9218, 10, 1010, 8745);
INSERT INTO 'albumsrecordingsmap' VALUES (9219, 11, 1010, 8746);
INSERT INTO 'albumsrecordingsmap' VALUES (9220, 12, 1010, 8747);
INSERT INTO 'albumsrecordingsmap' VALUES (9221, 1, 1011, 8748);
INSERT INTO 'albumsrecordingsmap' VALUES (9222, 2, 1011, 8749);
INSERT INTO 'albumsrecordingsmap' VALUES (9223, 3, 1011, 8750);
INSERT INTO 'albumsrecordingsmap' VALUES (9224, 4, 1011, 8751);
INSERT INTO 'albumsrecordingsmap' VALUES (9225, 5, 1011, 8752);
INSERT INTO 'albumsrecordingsmap' VALUES (9226, 6, 1011, 8753);
INSERT INTO 'albumsrecordingsmap' VALUES (9227, 7, 1011, 8754);
INSERT INTO 'albumsrecordingsmap' VALUES (9228, 8, 1011, 8755);
INSERT INTO 'albumsrecordingsmap' VALUES (9229, 9, 1011, 8756);
INSERT INTO 'albumsrecordingsmap' VALUES (9230, 10, 1011, 8757);
INSERT INTO 'albumsrecordingsmap' VALUES (9231, 11, 1011, 8758);
INSERT INTO 'albumsrecordingsmap' VALUES (9232, 12, 1011, 8759);
INSERT INTO 'albumsrecordingsmap' VALUES (9233, 13, 1011, 8760);
INSERT INTO 'albumsrecordingsmap' VALUES (9234, 14, 1011, 8761);
INSERT INTO 'albumsrecordingsmap' VALUES (9235, 15, 1011, 8762);
INSERT INTO 'albumsrecordingsmap' VALUES (9236, 16, 1011, 8763);
INSERT INTO 'albumsrecordingsmap' VALUES (9237, 17, 1011, 8764);
INSERT INTO 'albumsrecordingsmap' VALUES (9238, 18, 1011, 8765);
INSERT INTO 'albumsrecordingsmap' VALUES (9239, 19, 1011, 8766);
INSERT INTO 'albumsrecordingsmap' VALUES (9240, 20, 1011, 8767);
INSERT INTO 'albumsrecordingsmap' VALUES (9241, 21, 1011, 8768);
INSERT INTO 'albumsrecordingsmap' VALUES (9242, 22, 1011, 8769);
INSERT INTO 'albumsrecordingsmap' VALUES (9243, 23, 1011, 8770);
INSERT INTO 'albumsrecordingsmap' VALUES (9244, 24, 1011, 8771);
INSERT INTO 'albumsrecordingsmap' VALUES (9245, 1, 1012, 8772);
INSERT INTO 'albumsrecordingsmap' VALUES (9246, 2, 1012, 8773);
INSERT INTO 'albumsrecordingsmap' VALUES (9247, 3, 1012, 8774);
INSERT INTO 'albumsrecordingsmap' VALUES (9248, 4, 1012, 8775);
INSERT INTO 'albumsrecordingsmap' VALUES (9249, 5, 1012, 8776);
INSERT INTO 'albumsrecordingsmap' VALUES (9250, 6, 1012, 8777);
INSERT INTO 'albumsrecordingsmap' VALUES (9251, 7, 1012, 8778);
INSERT INTO 'albumsrecordingsmap' VALUES (9252, 8, 1012, 8779);
INSERT INTO 'albumsrecordingsmap' VALUES (9253, 9, 1012, 8780);
INSERT INTO 'albumsrecordingsmap' VALUES (9254, 10, 1012, 8781);
INSERT INTO 'albumsrecordingsmap' VALUES (9255, 11, 1012, 8782);
INSERT INTO 'albumsrecordingsmap' VALUES (9256, 12, 1012, 8783);
INSERT INTO 'albumsrecordingsmap' VALUES (9257, 13, 1012, 8784);
INSERT INTO 'albumsrecordingsmap' VALUES (9258, 14, 1012, 8785);
INSERT INTO 'albumsrecordingsmap' VALUES (9259, 15, 1012, 8786);
INSERT INTO 'albumsrecordingsmap' VALUES (9260, 16, 1012, 8787);
INSERT INTO 'albumsrecordingsmap' VALUES (9261, 17, 1012, 8788);
INSERT INTO 'albumsrecordingsmap' VALUES (9262, 18, 1012, 8789);
INSERT INTO 'albumsrecordingsmap' VALUES (9263, 1, 1013, 8790);
INSERT INTO 'albumsrecordingsmap' VALUES (9264, 2, 1013, 8791);
INSERT INTO 'albumsrecordingsmap' VALUES (9265, 3, 1013, 8792);
INSERT INTO 'albumsrecordingsmap' VALUES (9266, 4, 1013, 8793);
INSERT INTO 'albumsrecordingsmap' VALUES (9267, 5, 1013, 8794);
INSERT INTO 'albumsrecordingsmap' VALUES (9268, 6, 1013, 8795);
INSERT INTO 'albumsrecordingsmap' VALUES (9269, 7, 1013, 8796);
INSERT INTO 'albumsrecordingsmap' VALUES (9270, 8, 1013, 8797);
INSERT INTO 'albumsrecordingsmap' VALUES (9271, 9, 1013, 8798);
INSERT INTO 'albumsrecordingsmap' VALUES (9272, 10, 1013, 8799);
INSERT INTO 'albumsrecordingsmap' VALUES (9273, 11, 1013, 8800);
INSERT INTO 'albumsrecordingsmap' VALUES (9274, 12, 1013, 8801);
INSERT INTO 'albumsrecordingsmap' VALUES (9275, 13, 1013, 8802);
INSERT INTO 'albumsrecordingsmap' VALUES (9276, 14, 1013, 8803);
INSERT INTO 'albumsrecordingsmap' VALUES (9277, 15, 1013, 8804);
INSERT INTO 'albumsrecordingsmap' VALUES (9278, 16, 1013, 8805);
INSERT INTO 'albumsrecordingsmap' VALUES (9279, 17, 1013, 8806);
INSERT INTO 'albumsrecordingsmap' VALUES (9280, 18, 1013, 8807);
INSERT INTO 'albumsrecordingsmap' VALUES (9281, 19, 1013, 8808);
INSERT INTO 'albumsrecordingsmap' VALUES (9282, 20, 1013, 8809);
INSERT INTO 'albumsrecordingsmap' VALUES (9283, 21, 1013, 8810);
INSERT INTO 'albumsrecordingsmap' VALUES (9284, 1, 1014, 8811);
INSERT INTO 'albumsrecordingsmap' VALUES (9285, 2, 1014, 8812);
INSERT INTO 'albumsrecordingsmap' VALUES (9286, 3, 1014, 8813);
INSERT INTO 'albumsrecordingsmap' VALUES (9287, 4, 1014, 8814);
INSERT INTO 'albumsrecordingsmap' VALUES (9288, 5, 1014, 8815);
INSERT INTO 'albumsrecordingsmap' VALUES (9289, 6, 1014, 8816);
INSERT INTO 'albumsrecordingsmap' VALUES (9304, 1, 1016, 8831);
INSERT INTO 'albumsrecordingsmap' VALUES (9305, 2, 1016, 8832);
INSERT INTO 'albumsrecordingsmap' VALUES (9306, 3, 1016, 8833);
INSERT INTO 'albumsrecordingsmap' VALUES (9307, 4, 1016, 8834);
INSERT INTO 'albumsrecordingsmap' VALUES (9308, 5, 1016, 8835);
INSERT INTO 'albumsrecordingsmap' VALUES (9309, 6, 1016, 8836);
INSERT INTO 'albumsrecordingsmap' VALUES (9310, 7, 1016, 8837);
INSERT INTO 'albumsrecordingsmap' VALUES (9311, 8, 1016, 8838);
INSERT INTO 'albumsrecordingsmap' VALUES (9312, 9, 1016, 8839);
INSERT INTO 'albumsrecordingsmap' VALUES (9313, 10, 1016, 8840);
INSERT INTO 'albumsrecordingsmap' VALUES (9314, 11, 1016, 8841);
INSERT INTO 'albumsrecordingsmap' VALUES (9315, 12, 1016, 8842);
INSERT INTO 'albumsrecordingsmap' VALUES (9316, 13, 1016, 8843);
INSERT INTO 'albumsrecordingsmap' VALUES (9317, 14, 1016, 8844);
INSERT INTO 'albumsrecordingsmap' VALUES (9318, 15, 1016, 8845);
INSERT INTO 'albumsrecordingsmap' VALUES (925, 6, 79, 915);
INSERT INTO 'albumsrecordingsmap' VALUES (926, 5, 79, 916);
INSERT INTO 'albumsrecordingsmap' VALUES (927, 10, 79, 917);
INSERT INTO 'albumsrecordingsmap' VALUES (928, 7, 79, 918);
INSERT INTO 'albumsrecordingsmap' VALUES (929, 3, 79, 920);
INSERT INTO 'albumsrecordingsmap' VALUES (930, 2, 79, 59);
INSERT INTO 'albumsrecordingsmap' VALUES (931, 12, 79, 90);
INSERT INTO 'albumsrecordingsmap' VALUES (935, 4, 79, 924);
INSERT INTO 'albumsrecordingsmap' VALUES (936, 8, 79, 925);
INSERT INTO 'albumsrecordingsmap' VALUES (937, 11, 79, 926);
INSERT INTO 'albumsrecordingsmap' VALUES (9901, 13, 79, 9328);
INSERT INTO 'albumsrecordingsmap' VALUES (9902, 1, 1052, 9329);
INSERT INTO 'albumsrecordingsmap' VALUES (9903, 2, 1052, 9330);
INSERT INTO 'albumsrecordingsmap' VALUES (9904, 3, 1052, 9331);
INSERT INTO 'albumsrecordingsmap' VALUES (9905, 4, 1052, 9332);
INSERT INTO 'albumsrecordingsmap' VALUES (9906, 5, 1052, 9333);
INSERT INTO 'albumsrecordingsmap' VALUES (9907, 6, 1052, 9334);
INSERT INTO 'albumsrecordingsmap' VALUES (9908, 7, 1052, 9335);
INSERT INTO 'albumsrecordingsmap' VALUES (9909, 8, 1052, 9336);
INSERT INTO 'albumsrecordingsmap' VALUES (9910, 10, 1052, 9337);
INSERT INTO 'albumsrecordingsmap' VALUES (9911, 11, 1052, 9338);
INSERT INTO 'albumsrecordingsmap' VALUES (9912, 9, 1052, 9339);
INSERT INTO 'albumsrecordingsmap' VALUES (9913, 12, 1052, 9340);
INSERT INTO 'albumsrecordingsmap' VALUES (9914, 13, 1052, 9341);
INSERT INTO 'albumsrecordingsmap' VALUES (9915, 14, 1052, 9342);
INSERT INTO 'albumsrecordingsmap' VALUES (9916, 15, 1052, 9343);
INSERT INTO 'albumsrecordingsmap' VALUES (9917, 16, 1052, 9344);
INSERT INTO 'albumsrecordingsmap' VALUES (9667, 1, 1039, 9151);
INSERT INTO 'albumsrecordingsmap' VALUES (9668, 2, 1039, 9152);
INSERT INTO 'albumsrecordingsmap' VALUES (9669, 3, 1039, 9153);
INSERT INTO 'albumsrecordingsmap' VALUES (9670, 4, 1039, 9154);
INSERT INTO 'albumsrecordingsmap' VALUES (9671, 5, 1039, 9155);
INSERT INTO 'albumsrecordingsmap' VALUES (9672, 6, 1039, 9156);
INSERT INTO 'albumsrecordingsmap' VALUES (9673, 7, 1039, 9157);
INSERT INTO 'albumsrecordingsmap' VALUES (9674, 8, 1039, 9158);
INSERT INTO 'albumsrecordingsmap' VALUES (9675, 9, 1039, 9159);
INSERT INTO 'albumsrecordingsmap' VALUES (9676, 10, 1039, 9160);
INSERT INTO 'albumsrecordingsmap' VALUES (9677, 11, 1039, 9161);
INSERT INTO 'albumsrecordingsmap' VALUES (9678, 12, 1039, 9162);
INSERT INTO 'albumsrecordingsmap' VALUES (9679, 13, 1039, 9163);
INSERT INTO 'albumsrecordingsmap' VALUES (9680, 14, 1039, 9164);
INSERT INTO 'albumsrecordingsmap' VALUES (9681, 15, 1039, 9165);
INSERT INTO 'albumsrecordingsmap' VALUES (9682, 16, 1039, 9166);
INSERT INTO 'albumsrecordingsmap' VALUES (9683, 17, 1039, 9167);
INSERT INTO 'albumsrecordingsmap' VALUES (9684, 18, 1039, 9168);
INSERT INTO 'albumsrecordingsmap' VALUES (9685, 19, 1039, 9169);
INSERT INTO 'albumsrecordingsmap' VALUES (9686, 20, 1039, 9170);
INSERT INTO 'albumsrecordingsmap' VALUES (9687, 21, 1039, 9171);
INSERT INTO 'albumsrecordingsmap' VALUES (9688, 22, 1039, 9172);
INSERT INTO 'albumsrecordingsmap' VALUES (9689, 23, 1039, 9173);
INSERT INTO 'albumsrecordingsmap' VALUES (9690, 24, 1039, 9174);
INSERT INTO 'albumsrecordingsmap' VALUES (9691, 25, 1039, 9175);
INSERT INTO 'albumsrecordingsmap' VALUES (9692, 26, 1039, 9176);
INSERT INTO 'albumsrecordingsmap' VALUES (9693, 27, 1039, 9177);
INSERT INTO 'albumsrecordingsmap' VALUES (9694, 28, 1039, 9178);
INSERT INTO 'albumsrecordingsmap' VALUES (9695, 29, 1039, 9179);
INSERT INTO 'albumsrecordingsmap' VALUES (9696, 30, 1039, 9180);
INSERT INTO 'albumsrecordingsmap' VALUES (9703, 37, 1039, 9187);
INSERT INTO 'albumsrecordingsmap' VALUES (9704, 38, 1039, 9188);
INSERT INTO 'albumsrecordingsmap' VALUES (9705, 39, 1039, 9189);
INSERT INTO 'albumsrecordingsmap' VALUES (9706, 40, 1039, 9190);
INSERT INTO 'albumsrecordingsmap' VALUES (9707, 41, 1039, 9191);
INSERT INTO 'albumsrecordingsmap' VALUES (9708, 42, 1039, 9192);
INSERT INTO 'albumsrecordingsmap' VALUES (9918, 1, 1053, 9345);
INSERT INTO 'albumsrecordingsmap' VALUES (9919, 2, 1053, 9346);
INSERT INTO 'albumsrecordingsmap' VALUES (9920, 3, 1053, 9347);
INSERT INTO 'albumsrecordingsmap' VALUES (9921, 4, 1053, 9348);
INSERT INTO 'albumsrecordingsmap' VALUES (9922, 5, 1053, 9349);
INSERT INTO 'albumsrecordingsmap' VALUES (9923, 6, 1053, 9350);
INSERT INTO 'albumsrecordingsmap' VALUES (9924, 7, 1053, 9351);
INSERT INTO 'albumsrecordingsmap' VALUES (9925, 8, 1053, 9352);
INSERT INTO 'albumsrecordingsmap' VALUES (9926, 9, 1053, 9353);
INSERT INTO 'albumsrecordingsmap' VALUES (9927, 10, 1053, 9354);
INSERT INTO 'albumsrecordingsmap' VALUES (9928, 11, 1053, 9355);
INSERT INTO 'albumsrecordingsmap' VALUES (9929, 12, 1053, 9356);
INSERT INTO 'albumsrecordingsmap' VALUES (9930, 13, 1053, 9357);
INSERT INTO 'albumsrecordingsmap' VALUES (9931, 1, 1054, 9358);
INSERT INTO 'albumsrecordingsmap' VALUES (9932, 2, 1054, 9359);
INSERT INTO 'albumsrecordingsmap' VALUES (9933, 3, 1054, 9360);
INSERT INTO 'albumsrecordingsmap' VALUES (9934, 4, 1054, 9361);
INSERT INTO 'albumsrecordingsmap' VALUES (9935, 5, 1054, 9363);
INSERT INTO 'albumsrecordingsmap' VALUES (9936, 6, 1054, 9362);
INSERT INTO 'albumsrecordingsmap' VALUES (9937, 7, 1054, 9364);
INSERT INTO 'albumsrecordingsmap' VALUES (9938, 8, 1054, 9365);
INSERT INTO 'albumsrecordingsmap' VALUES (9939, 9, 1054, 9366);
INSERT INTO 'albumsrecordingsmap' VALUES (9940, 10, 1054, 9367);
INSERT INTO 'albumsrecordingsmap' VALUES (9941, 11, 1054, 9368);
INSERT INTO 'albumsrecordingsmap' VALUES (9942, 12, 1054, 9369);
INSERT INTO 'albumsrecordingsmap' VALUES (9943, 1, 1055, 9370);
INSERT INTO 'albumsrecordingsmap' VALUES (9944, 2, 1055, 9371);
INSERT INTO 'albumsrecordingsmap' VALUES (9945, 3, 1055, 9372);
INSERT INTO 'albumsrecordingsmap' VALUES (9946, 4, 1055, 9373);
INSERT INTO 'albumsrecordingsmap' VALUES (9947, 5, 1055, 9374);
INSERT INTO 'albumsrecordingsmap' VALUES (9948, 6, 1055, 9375);
INSERT INTO 'albumsrecordingsmap' VALUES (9949, 7, 1055, 9376);
INSERT INTO 'albumsrecordingsmap' VALUES (9950, 8, 1055, 9377);
INSERT INTO 'albumsrecordingsmap' VALUES (9951, 9, 1055, 9378);
INSERT INTO 'albumsrecordingsmap' VALUES (9952, 10, 1055, 9379);
INSERT INTO 'albumsrecordingsmap' VALUES (9953, 11, 1055, 9380);
INSERT INTO 'albumsrecordingsmap' VALUES (9954, 12, 1055, 9381);
INSERT INTO 'albumsrecordingsmap' VALUES (9955, 13, 1055, 9382);
INSERT INTO 'albumsrecordingsmap' VALUES (9956, 14, 1055, 9383);
INSERT INTO 'albumsrecordingsmap' VALUES (9957, 15, 1055, 9384);
INSERT INTO 'albumsrecordingsmap' VALUES (9958, 16, 1055, 9385);
INSERT INTO 'albumsrecordingsmap' VALUES (9959, 17, 1055, 9386);
INSERT INTO 'albumsrecordingsmap' VALUES (9975, 1, 1057, 9402);
INSERT INTO 'albumsrecordingsmap' VALUES (9976, 2, 1057, 9403);
INSERT INTO 'albumsrecordingsmap' VALUES (9977, 3, 1057, 9404);
INSERT INTO 'albumsrecordingsmap' VALUES (9978, 4, 1057, 9405);
INSERT INTO 'albumsrecordingsmap' VALUES (9979, 5, 1057, 9406);
INSERT INTO 'albumsrecordingsmap' VALUES (9980, 6, 1057, 9407);
INSERT INTO 'albumsrecordingsmap' VALUES (9981, 7, 1057, 9408);
INSERT INTO 'albumsrecordingsmap' VALUES (9982, 8, 1057, 9409);
INSERT INTO 'albumsrecordingsmap' VALUES (9983, 9, 1057, 9410);
INSERT INTO 'albumsrecordingsmap' VALUES (9984, 10, 1057, 9411);
INSERT INTO 'albumsrecordingsmap' VALUES (9985, 11, 1057, 9412);
INSERT INTO 'albumsrecordingsmap' VALUES (9986, 12, 1057, 9413);
INSERT INTO 'albumsrecordingsmap' VALUES (9987, 13, 1057, 9414);
INSERT INTO 'albumsrecordingsmap' VALUES (9988, 14, 1057, 9415);
INSERT INTO 'albumsrecordingsmap' VALUES (9989, 15, 1057, 9416);
INSERT INTO 'albumsrecordingsmap' VALUES (9990, 1, 1058, 9417);
INSERT INTO 'albumsrecordingsmap' VALUES (9991, 2, 1058, 9418);
INSERT INTO 'albumsrecordingsmap' VALUES (9992, 3, 1058, 9419);
INSERT INTO 'albumsrecordingsmap' VALUES (9993, 4, 1058, 9420);
INSERT INTO 'albumsrecordingsmap' VALUES (9994, 5, 1058, 9421);
INSERT INTO 'albumsrecordingsmap' VALUES (9995, 6, 1058, 9422);
INSERT INTO 'albumsrecordingsmap' VALUES (9996, 7, 1058, 9423);
INSERT INTO 'albumsrecordingsmap' VALUES (9997, 8, 1058, 9424);
INSERT INTO 'albumsrecordingsmap' VALUES (9998, 9, 1058, 9425);
INSERT INTO 'albumsrecordingsmap' VALUES (9999, 10, 1058, 9426);
INSERT INTO 'albumsrecordingsmap' VALUES (10000, 11, 1058, 9427);
INSERT INTO 'albumsrecordingsmap' VALUES (10001, 12, 1058, 9428);
INSERT INTO 'albumsrecordingsmap' VALUES (10002, 1, 1059, 9429);
INSERT INTO 'albumsrecordingsmap' VALUES (10003, 2, 1059, 9430);
INSERT INTO 'albumsrecordingsmap' VALUES (10004, 3, 1059, 9431);
INSERT INTO 'albumsrecordingsmap' VALUES (10005, 4, 1059, 9432);
INSERT INTO 'albumsrecordingsmap' VALUES (10006, 5, 1059, 9433);
INSERT INTO 'albumsrecordingsmap' VALUES (10007, 6, 1059, 9434);
INSERT INTO 'albumsrecordingsmap' VALUES (10008, 7, 1059, 9435);
INSERT INTO 'albumsrecordingsmap' VALUES (10009, 8, 1059, 9436);
INSERT INTO 'albumsrecordingsmap' VALUES (10010, 9, 1059, 9437);
INSERT INTO 'albumsrecordingsmap' VALUES (10011, 10, 1059, 9438);
INSERT INTO 'albumsrecordingsmap' VALUES (10012, 11, 1059, 9439);
INSERT INTO 'albumsrecordingsmap' VALUES (10013, 12, 1059, 9440);
INSERT INTO 'albumsrecordingsmap' VALUES (10014, 13, 1059, 9441);
INSERT INTO 'albumsrecordingsmap' VALUES (10015, 14, 1059, 9442);
INSERT INTO 'albumsrecordingsmap' VALUES (10016, 13, 1058, 9443);
INSERT INTO 'albumsrecordingsmap' VALUES (10017, 1, 1060, 9444);
INSERT INTO 'albumsrecordingsmap' VALUES (10018, 2, 1060, 3925);
INSERT INTO 'albumsrecordingsmap' VALUES (10019, 3, 1060, 9446);
INSERT INTO 'albumsrecordingsmap' VALUES (10020, 4, 1060, 9447);
INSERT INTO 'albumsrecordingsmap' VALUES (10021, 5, 1060, 9448);
INSERT INTO 'albumsrecordingsmap' VALUES (10022, 6, 1060, 9449);
INSERT INTO 'albumsrecordingsmap' VALUES (10023, 7, 1060, 9450);
INSERT INTO 'albumsrecordingsmap' VALUES (10024, 8, 1060, 9451);
INSERT INTO 'albumsrecordingsmap' VALUES (10025, 9, 1060, 9452);
INSERT INTO 'albumsrecordingsmap' VALUES (10026, 10, 1060, 9453);
INSERT INTO 'albumsrecordingsmap' VALUES (10027, 11, 1060, 9454);
INSERT INTO 'albumsrecordingsmap' VALUES (10028, 12, 1060, 9455);
INSERT INTO 'albumsrecordingsmap' VALUES (10029, 13, 1060, 9456);
INSERT INTO 'albumsrecordingsmap' VALUES (10030, 14, 1060, 9457);
INSERT INTO 'albumsrecordingsmap' VALUES (10031, 15, 1060, 9458);
INSERT INTO 'albumsrecordingsmap' VALUES (10032, 1, 1061, 9459);
INSERT INTO 'albumsrecordingsmap' VALUES (10033, 2, 1061, 9460);
INSERT INTO 'albumsrecordingsmap' VALUES (10034, 3, 1061, 9461);
INSERT INTO 'albumsrecordingsmap' VALUES (10035, 4, 1061, 9462);
INSERT INTO 'albumsrecordingsmap' VALUES (10036, 5, 1061, 9463);
INSERT INTO 'albumsrecordingsmap' VALUES (10037, 6, 1061, 9464);
INSERT INTO 'albumsrecordingsmap' VALUES (10038, 7, 1061, 9465);
INSERT INTO 'albumsrecordingsmap' VALUES (10039, 8, 1061, 9466);
INSERT INTO 'albumsrecordingsmap' VALUES (10040, 9, 1061, 9467);
INSERT INTO 'albumsrecordingsmap' VALUES (10041, 10, 1061, 9468);
INSERT INTO 'albumsrecordingsmap' VALUES (10042, 11, 1061, 9469);
INSERT INTO 'albumsrecordingsmap' VALUES (10043, 12, 1061, 9470);
INSERT INTO 'albumsrecordingsmap' VALUES (10073, 1, 1063, 9500);
INSERT INTO 'albumsrecordingsmap' VALUES (10074, 2, 1063, 9501);
INSERT INTO 'albumsrecordingsmap' VALUES (10075, 3, 1063, 9502);
INSERT INTO 'albumsrecordingsmap' VALUES (10076, 4, 1063, 9503);
INSERT INTO 'albumsrecordingsmap' VALUES (10077, 5, 1063, 9504);
INSERT INTO 'albumsrecordingsmap' VALUES (10078, 6, 1063, 9505);
INSERT INTO 'albumsrecordingsmap' VALUES (10079, 7, 1063, 9506);
INSERT INTO 'albumsrecordingsmap' VALUES (10080, 8, 1063, 9507);
INSERT INTO 'albumsrecordingsmap' VALUES (10081, 9, 1063, 9508);
INSERT INTO 'albumsrecordingsmap' VALUES (10082, 10, 1063, 9509);
INSERT INTO 'albumsrecordingsmap' VALUES (10083, 11, 1063, 9510);
INSERT INTO 'albumsrecordingsmap' VALUES (10084, 12, 1063, 9511);
INSERT INTO 'albumsrecordingsmap' VALUES (10085, 13, 1063, 9512);
INSERT INTO 'albumsrecordingsmap' VALUES (10086, 14, 1063, 9513);
INSERT INTO 'albumsrecordingsmap' VALUES (10087, 1, 1064, 9514);
INSERT INTO 'albumsrecordingsmap' VALUES (10088, 2, 1064, 9515);
INSERT INTO 'albumsrecordingsmap' VALUES (10089, 3, 1064, 9516);
INSERT INTO 'albumsrecordingsmap' VALUES (10090, 4, 1064, 9517);
INSERT INTO 'albumsrecordingsmap' VALUES (10091, 5, 1064, 9518);
INSERT INTO 'albumsrecordingsmap' VALUES (10092, 6, 1064, 9519);
INSERT INTO 'albumsrecordingsmap' VALUES (10093, 7, 1064, 9520);
INSERT INTO 'albumsrecordingsmap' VALUES (10094, 8, 1064, 9521);
INSERT INTO 'albumsrecordingsmap' VALUES (10095, 9, 1064, 9522);
INSERT INTO 'albumsrecordingsmap' VALUES (10096, 10, 1064, 9523);
INSERT INTO 'albumsrecordingsmap' VALUES (10097, 11, 1064, 9524);
INSERT INTO 'albumsrecordingsmap' VALUES (10098, 12, 1064, 9525);
INSERT INTO 'albumsrecordingsmap' VALUES (10099, 13, 1064, 9526);
INSERT INTO 'albumsrecordingsmap' VALUES (10100, 14, 1064, 9527);
INSERT INTO 'albumsrecordingsmap' VALUES (10101, 15, 1064, 9528);
INSERT INTO 'albumsrecordingsmap' VALUES (10102, 16, 1064, 9529);
INSERT INTO 'albumsrecordingsmap' VALUES (10137, 1, 1067, 9564);
INSERT INTO 'albumsrecordingsmap' VALUES (10138, 2, 1067, 9565);
INSERT INTO 'albumsrecordingsmap' VALUES (10139, 3, 1067, 9566);
INSERT INTO 'albumsrecordingsmap' VALUES (10140, 4, 1067, 9567);
INSERT INTO 'albumsrecordingsmap' VALUES (10141, 5, 1067, 9568);
INSERT INTO 'albumsrecordingsmap' VALUES (10142, 6, 1067, 9569);
INSERT INTO 'albumsrecordingsmap' VALUES (10143, 7, 1067, 9570);
INSERT INTO 'albumsrecordingsmap' VALUES (10144, 8, 1067, 9571);
INSERT INTO 'albumsrecordingsmap' VALUES (10145, 9, 1067, 9572);
INSERT INTO 'albumsrecordingsmap' VALUES (10146, 10, 1067, 9573);
INSERT INTO 'albumsrecordingsmap' VALUES (10147, 12, 1067, 9574);
INSERT INTO 'albumsrecordingsmap' VALUES (10148, 11, 1067, 9575);
INSERT INTO 'albumsrecordingsmap' VALUES (10149, 13, 1067, 9576);
INSERT INTO 'albumsrecordingsmap' VALUES (10168, 1, 1069, 9595);
INSERT INTO 'albumsrecordingsmap' VALUES (10169, 2, 1069, 9596);
INSERT INTO 'albumsrecordingsmap' VALUES (10170, 3, 1069, 9597);
INSERT INTO 'albumsrecordingsmap' VALUES (10171, 4, 1069, 9598);
INSERT INTO 'albumsrecordingsmap' VALUES (10172, 5, 1069, 9599);
INSERT INTO 'albumsrecordingsmap' VALUES (10173, 6, 1069, 9600);
INSERT INTO 'albumsrecordingsmap' VALUES (10174, 7, 1069, 9601);
INSERT INTO 'albumsrecordingsmap' VALUES (10175, 8, 1069, 9602);
INSERT INTO 'albumsrecordingsmap' VALUES (10176, 9, 1069, 9603);
INSERT INTO 'albumsrecordingsmap' VALUES (10177, 10, 1069, 9604);
INSERT INTO 'albumsrecordingsmap' VALUES (10178, 11, 1069, 9605);
INSERT INTO 'albumsrecordingsmap' VALUES (10179, 12, 1069, 9606);
INSERT INTO 'albumsrecordingsmap' VALUES (10180, 13, 1069, 9607);
INSERT INTO 'albumsrecordingsmap' VALUES (10181, 14, 1069, 9608);
INSERT INTO 'albumsrecordingsmap' VALUES (10182, 15, 1069, 9609);
INSERT INTO 'albumsrecordingsmap' VALUES (10183, 16, 1069, 9610);
INSERT INTO 'albumsrecordingsmap' VALUES (10184, 17, 1069, 9611);
INSERT INTO 'albumsrecordingsmap' VALUES (10185, 18, 1069, 9612);
INSERT INTO 'albumsrecordingsmap' VALUES (10187, 1, 1070, 2952);
INSERT INTO 'albumsrecordingsmap' VALUES (10188, 2, 1070, 9615);
INSERT INTO 'albumsrecordingsmap' VALUES (10189, 3, 1070, 9616);
INSERT INTO 'albumsrecordingsmap' VALUES (10190, 4, 1070, 9617);
INSERT INTO 'albumsrecordingsmap' VALUES (10191, 5, 1070, 9618);
INSERT INTO 'albumsrecordingsmap' VALUES (10192, 6, 1070, 9619);
INSERT INTO 'albumsrecordingsmap' VALUES (10193, 7, 1070, 9620);
INSERT INTO 'albumsrecordingsmap' VALUES (10194, 8, 1070, 9621);
INSERT INTO 'albumsrecordingsmap' VALUES (10195, 9, 1070, 9622);
INSERT INTO 'albumsrecordingsmap' VALUES (10196, 10, 1070, 9623);
INSERT INTO 'albumsrecordingsmap' VALUES (10197, 12, 1070, 9624);
INSERT INTO 'albumsrecordingsmap' VALUES (10198, 13, 1070, 7662);
INSERT INTO 'albumsrecordingsmap' VALUES (10199, 14, 1070, 9626);
INSERT INTO 'albumsrecordingsmap' VALUES (10200, 15, 1070, 9627);
INSERT INTO 'albumsrecordingsmap' VALUES (10201, 16, 1070, 9628);
INSERT INTO 'albumsrecordingsmap' VALUES (10202, 17, 1070, 9629);
INSERT INTO 'albumsrecordingsmap' VALUES (10203, 18, 1070, 9630);
INSERT INTO 'albumsrecordingsmap' VALUES (10204, 11, 1070, 9631);
INSERT INTO 'albumsrecordingsmap' VALUES (10205, 1, 1071, 8782);
INSERT INTO 'albumsrecordingsmap' VALUES (10206, 2, 1071, 9633);
INSERT INTO 'albumsrecordingsmap' VALUES (10207, 3, 1071, 9634);
INSERT INTO 'albumsrecordingsmap' VALUES (10208, 4, 1071, 9635);
INSERT INTO 'albumsrecordingsmap' VALUES (10209, 5, 1071, 9636);
INSERT INTO 'albumsrecordingsmap' VALUES (10210, 6, 1071, 9637);
INSERT INTO 'albumsrecordingsmap' VALUES (10211, 7, 1071, 9638);
INSERT INTO 'albumsrecordingsmap' VALUES (10212, 8, 1071, 9639);
INSERT INTO 'albumsrecordingsmap' VALUES (10213, 9, 1071, 9640);
INSERT INTO 'albumsrecordingsmap' VALUES (10214, 10, 1071, 9641);
INSERT INTO 'albumsrecordingsmap' VALUES (10215, 11, 1071, 9642);
INSERT INTO 'albumsrecordingsmap' VALUES (10216, 12, 1071, 9643);
INSERT INTO 'albumsrecordingsmap' VALUES (10217, 13, 1071, 9644);
INSERT INTO 'albumsrecordingsmap' VALUES (10219, 15, 1071, 9646);
INSERT INTO 'albumsrecordingsmap' VALUES (10220, 14, 1071, 9647);
INSERT INTO 'albumsrecordingsmap' VALUES (10221, 16, 1071, 9648);
INSERT INTO 'albumsrecordingsmap' VALUES (10222, 17, 1071, 9649);
INSERT INTO 'albumsrecordingsmap' VALUES (10223, 18, 1071, 9650);
INSERT INTO 'albumsrecordingsmap' VALUES (10224, 19, 1071, 3369);
INSERT INTO 'albumsrecordingsmap' VALUES (10225, 20, 1071, 9651);
INSERT INTO 'albumsrecordingsmap' VALUES (10226, 1, 1072, 9652);
INSERT INTO 'albumsrecordingsmap' VALUES (10227, 2, 1072, 9653);
INSERT INTO 'albumsrecordingsmap' VALUES (10228, 3, 1072, 9654);
INSERT INTO 'albumsrecordingsmap' VALUES (10229, 4, 1072, 9655);
INSERT INTO 'albumsrecordingsmap' VALUES (10230, 5, 1072, 9656);
INSERT INTO 'albumsrecordingsmap' VALUES (10231, 6, 1072, 9657);
INSERT INTO 'albumsrecordingsmap' VALUES (10232, 7, 1072, 9658);
INSERT INTO 'albumsrecordingsmap' VALUES (10233, 8, 1072, 9659);
INSERT INTO 'albumsrecordingsmap' VALUES (10234, 9, 1072, 9660);
INSERT INTO 'albumsrecordingsmap' VALUES (10235, 10, 1072, 9661);
INSERT INTO 'albumsrecordingsmap' VALUES (10236, 11, 1072, 9662);
INSERT INTO 'albumsrecordingsmap' VALUES (10237, 12, 1072, 9663);
INSERT INTO 'albumsrecordingsmap' VALUES (10238, 1, 1073, 3705);
INSERT INTO 'albumsrecordingsmap' VALUES (10249, 2, 1073, 1962);
INSERT INTO 'albumsrecordingsmap' VALUES (10251, 11, 1073, 3192);
INSERT INTO 'albumsrecordingsmap' VALUES (10241, 3, 1073, 9664);
INSERT INTO 'albumsrecordingsmap' VALUES (10242, 4, 1073, 9665);
INSERT INTO 'albumsrecordingsmap' VALUES (10244, 5, 1073, 3189);
INSERT INTO 'albumsrecordingsmap' VALUES (10246, 7, 1073, 3190);
INSERT INTO 'albumsrecordingsmap' VALUES (10247, 8, 1073, 3191);
INSERT INTO 'albumsrecordingsmap' VALUES (10252, 6, 1073, 9667);
INSERT INTO 'albumsrecordingsmap' VALUES (10253, 9, 1073, 9668);
INSERT INTO 'albumsrecordingsmap' VALUES (10254, 10, 1073, 9669);
INSERT INTO 'albumsrecordingsmap' VALUES (10255, 1, 1074, 9670);
INSERT INTO 'albumsrecordingsmap' VALUES (10256, 2, 1074, 9671);
INSERT INTO 'albumsrecordingsmap' VALUES (10257, 3, 1074, 9672);
INSERT INTO 'albumsrecordingsmap' VALUES (10258, 4, 1074, 9673);
INSERT INTO 'albumsrecordingsmap' VALUES (10259, 5, 1074, 9674);
INSERT INTO 'albumsrecordingsmap' VALUES (10260, 6, 1074, 9675);
INSERT INTO 'albumsrecordingsmap' VALUES (10261, 7, 1074, 9676);
INSERT INTO 'albumsrecordingsmap' VALUES (10262, 8, 1074, 9677);
INSERT INTO 'albumsrecordingsmap' VALUES (10263, 9, 1074, 9678);
INSERT INTO 'albumsrecordingsmap' VALUES (10264, 10, 1074, 9679);
INSERT INTO 'albumsrecordingsmap' VALUES (10265, 11, 1074, 9680);
INSERT INTO 'albumsrecordingsmap' VALUES (10125, 1, 1066, 9552);
INSERT INTO 'albumsrecordingsmap' VALUES (10126, 2, 1066, 9553);
INSERT INTO 'albumsrecordingsmap' VALUES (10127, 3, 1066, 9554);
INSERT INTO 'albumsrecordingsmap' VALUES (10128, 4, 1066, 9555);
INSERT INTO 'albumsrecordingsmap' VALUES (10129, 5, 1066, 9556);
INSERT INTO 'albumsrecordingsmap' VALUES (10130, 6, 1066, 9557);
INSERT INTO 'albumsrecordingsmap' VALUES (10131, 7, 1066, 9558);
INSERT INTO 'albumsrecordingsmap' VALUES (10132, 8, 1066, 9559);
INSERT INTO 'albumsrecordingsmap' VALUES (10133, 9, 1066, 9560);
INSERT INTO 'albumsrecordingsmap' VALUES (10134, 10, 1066, 9561);
INSERT INTO 'albumsrecordingsmap' VALUES (10135, 11, 1066, 9562);
INSERT INTO 'albumsrecordingsmap' VALUES (10136, 12, 1066, 9563);
INSERT INTO 'albumsrecordingsmap' VALUES (10103, 1, 1065, 9530);
INSERT INTO 'albumsrecordingsmap' VALUES (10104, 2, 1065, 9553);
INSERT INTO 'albumsrecordingsmap' VALUES (10105, 3, 1065, 9532);
INSERT INTO 'albumsrecordingsmap' VALUES (10106, 4, 1065, 9533);
INSERT INTO 'albumsrecordingsmap' VALUES (10107, 5, 1065, 9534);
INSERT INTO 'albumsrecordingsmap' VALUES (10108, 6, 1065, 9535);
INSERT INTO 'albumsrecordingsmap' VALUES (10109, 7, 1065, 9536);
INSERT INTO 'albumsrecordingsmap' VALUES (10110, 8, 1065, 9537);
INSERT INTO 'albumsrecordingsmap' VALUES (10111, 9, 1065, 9538);
INSERT INTO 'albumsrecordingsmap' VALUES (10112, 10, 1065, 9539);
INSERT INTO 'albumsrecordingsmap' VALUES (10113, 11, 1065, 9540);
INSERT INTO 'albumsrecordingsmap' VALUES (10114, 12, 1065, 9541);
INSERT INTO 'albumsrecordingsmap' VALUES (10115, 13, 1065, 9542);
INSERT INTO 'albumsrecordingsmap' VALUES (10116, 14, 1065, 9543);
INSERT INTO 'albumsrecordingsmap' VALUES (10117, 15, 1065, 9544);
INSERT INTO 'albumsrecordingsmap' VALUES (10118, 16, 1065, 9545);
INSERT INTO 'albumsrecordingsmap' VALUES (10119, 17, 1065, 9546);
INSERT INTO 'albumsrecordingsmap' VALUES (10266, 12, 1074, 9681);
INSERT INTO 'albumsrecordingsmap' VALUES (10267, 13, 1074, 9682);
INSERT INTO 'albumsrecordingsmap' VALUES (10268, 14, 1074, 9683);
INSERT INTO 'albumsrecordingsmap' VALUES (10269, 15, 1074, 9684);
INSERT INTO 'albumsrecordingsmap' VALUES (419, 4, 34, 457);
INSERT INTO 'albumsrecordingsmap' VALUES (420, 5, 34, 458);
INSERT INTO 'albumsrecordingsmap' VALUES (421, 7, 34, 460);
INSERT INTO 'albumsrecordingsmap' VALUES (422, 9, 34, 462);
INSERT INTO 'albumsrecordingsmap' VALUES (423, 10, 34, 463);
INSERT INTO 'albumsrecordingsmap' VALUES (424, 11, 34, 464);
INSERT INTO 'albumsrecordingsmap' VALUES (425, 12, 34, 465);
INSERT INTO 'albumsrecordingsmap' VALUES (2908, 5, 269, 2906);
INSERT INTO 'albumsrecordingsmap' VALUES (2909, 8, 269, 2907);
INSERT INTO 'albumsrecordingsmap' VALUES (2910, 11, 269, 2909);
INSERT INTO 'albumsrecordingsmap' VALUES (2911, 13, 269, 2910);
INSERT INTO 'albumsrecordingsmap' VALUES (2912, 4, 269, 2911);
INSERT INTO 'albumsrecordingsmap' VALUES (4432, 6, 269, 4254);
INSERT INTO 'albumsrecordingsmap' VALUES (4433, 7, 269, 4255);
INSERT INTO 'albumsrecordingsmap' VALUES (4434, 9, 269, 4256);
INSERT INTO 'albumsrecordingsmap' VALUES (10270, 12, 269, 9685);
INSERT INTO 'albumsrecordingsmap' VALUES (10271, 3, 269, 9686);
INSERT INTO 'albumsrecordingsmap' VALUES (10272, 6, 214, 2315);
INSERT INTO 'albumsrecordingsmap' VALUES (10273, 10, 269, 9688);
INSERT INTO 'albumsrecordingsmap' VALUES (10186, 19, 1069, 9613);
INSERT INTO 'albumsrecordingsmap' VALUES (10289, 1, 1076, 9705);
INSERT INTO 'albumsrecordingsmap' VALUES (10290, 2, 1076, 9706);
INSERT INTO 'albumsrecordingsmap' VALUES (10291, 3, 1076, 9707);
INSERT INTO 'albumsrecordingsmap' VALUES (10292, 4, 1076, 9708);
INSERT INTO 'albumsrecordingsmap' VALUES (10293, 5, 1076, 9709);
INSERT INTO 'albumsrecordingsmap' VALUES (10294, 6, 1076, 9710);
INSERT INTO 'albumsrecordingsmap' VALUES (10295, 7, 1076, 9711);
INSERT INTO 'albumsrecordingsmap' VALUES (10296, 8, 1076, 9712);
INSERT INTO 'albumsrecordingsmap' VALUES (10297, 9, 1076, 9713);
INSERT INTO 'albumsrecordingsmap' VALUES (10298, 10, 1076, 9714);
INSERT INTO 'albumsrecordingsmap' VALUES (10299, 11, 1076, 9715);
INSERT INTO 'albumsrecordingsmap' VALUES (10300, 12, 1076, 9716);
INSERT INTO 'albumsrecordingsmap' VALUES (10301, 13, 1076, 9717);
INSERT INTO 'albumsrecordingsmap' VALUES (10302, 14, 1076, 9718);
INSERT INTO 'albumsrecordingsmap' VALUES (10303, 1, 1077, 9719);
INSERT INTO 'albumsrecordingsmap' VALUES (10304, 2, 1077, 9720);
INSERT INTO 'albumsrecordingsmap' VALUES (10305, 3, 1077, 9721);
INSERT INTO 'albumsrecordingsmap' VALUES (10306, 4, 1077, 9722);
INSERT INTO 'albumsrecordingsmap' VALUES (10307, 5, 1077, 9723);
INSERT INTO 'albumsrecordingsmap' VALUES (10308, 6, 1077, 9724);
INSERT INTO 'albumsrecordingsmap' VALUES (10309, 7, 1077, 9725);
INSERT INTO 'albumsrecordingsmap' VALUES (10310, 8, 1077, 9726);
INSERT INTO 'albumsrecordingsmap' VALUES (10311, 9, 1077, 9727);
INSERT INTO 'albumsrecordingsmap' VALUES (10312, 10, 1077, 9728);
INSERT INTO 'albumsrecordingsmap' VALUES (10313, 11, 1077, 9729);
INSERT INTO 'albumsrecordingsmap' VALUES (10314, 12, 1077, 9730);
INSERT INTO 'albumsrecordingsmap' VALUES (10315, 13, 1077, 9731);
INSERT INTO 'albumsrecordingsmap' VALUES (10316, 14, 1077, 9732);
INSERT INTO 'albumsrecordingsmap' VALUES (10317, 15, 1077, 9733);
INSERT INTO 'albumsrecordingsmap' VALUES (10318, 10, 1022, 9734);
INSERT INTO 'albumsrecordingsmap' VALUES (10319, 1, 1078, 9735);
INSERT INTO 'albumsrecordingsmap' VALUES (10320, 2, 1078, 9736);
INSERT INTO 'albumsrecordingsmap' VALUES (10321, 3, 1078, 9737);
INSERT INTO 'albumsrecordingsmap' VALUES (10322, 4, 1078, 9738);
INSERT INTO 'albumsrecordingsmap' VALUES (10323, 5, 1078, 9739);
INSERT INTO 'albumsrecordingsmap' VALUES (10324, 6, 1078, 9740);
INSERT INTO 'albumsrecordingsmap' VALUES (10325, 7, 1078, 9741);
INSERT INTO 'albumsrecordingsmap' VALUES (10326, 8, 1078, 9742);
INSERT INTO 'albumsrecordingsmap' VALUES (10327, 9, 1078, 9743);
INSERT INTO 'albumsrecordingsmap' VALUES (10328, 10, 1078, 9744);
INSERT INTO 'albumsrecordingsmap' VALUES (10329, 11, 1078, 9745);
INSERT INTO 'albumsrecordingsmap' VALUES (10330, 12, 1078, 9746);
INSERT INTO 'albumsrecordingsmap' VALUES (10331, 13, 1078, 9747);
INSERT INTO 'albumsrecordingsmap' VALUES (10332, 14, 1078, 9748);
INSERT INTO 'albumsrecordingsmap' VALUES (10333, 15, 1078, 9749);
INSERT INTO 'albumsrecordingsmap' VALUES (10334, 16, 1078, 9750);
INSERT INTO 'albumsrecordingsmap' VALUES (10335, 1, 1079, 9751);
INSERT INTO 'albumsrecordingsmap' VALUES (10336, 2, 1079, 9752);
INSERT INTO 'albumsrecordingsmap' VALUES (10337, 3, 1079, 9753);
INSERT INTO 'albumsrecordingsmap' VALUES (10338, 4, 1079, 9754);
INSERT INTO 'albumsrecordingsmap' VALUES (10339, 5, 1079, 9755);
INSERT INTO 'albumsrecordingsmap' VALUES (10340, 6, 1079, 9757);
INSERT INTO 'albumsrecordingsmap' VALUES (10341, 7, 1079, 9756);
INSERT INTO 'albumsrecordingsmap' VALUES (10342, 8, 1079, 9758);
INSERT INTO 'albumsrecordingsmap' VALUES (10343, 9, 1079, 9759);
INSERT INTO 'albumsrecordingsmap' VALUES (10344, 10, 1079, 9760);
INSERT INTO 'albumsrecordingsmap' VALUES (10345, 11, 1079, 9761);
INSERT INTO 'albumsrecordingsmap' VALUES (10346, 12, 1079, 9762);
INSERT INTO 'albumsrecordingsmap' VALUES (10347, 13, 1079, 9763);
INSERT INTO 'albumsrecordingsmap' VALUES (10348, 1, 1080, 9764);
INSERT INTO 'albumsrecordingsmap' VALUES (10349, 2, 1080, 9765);
INSERT INTO 'albumsrecordingsmap' VALUES (10350, 3, 1080, 9766);
INSERT INTO 'albumsrecordingsmap' VALUES (10351, 4, 1080, 9767);
INSERT INTO 'albumsrecordingsmap' VALUES (10353, 7, 1080, 9769);
INSERT INTO 'albumsrecordingsmap' VALUES (10352, 6, 1080, 9768);
INSERT INTO 'albumsrecordingsmap' VALUES (10354, 5, 1080, 9770);
INSERT INTO 'albumsrecordingsmap' VALUES (10355, 8, 1080, 9771);
INSERT INTO 'albumsrecordingsmap' VALUES (10356, 9, 1080, 9772);
INSERT INTO 'albumsrecordingsmap' VALUES (10357, 10, 1080, 9773);
INSERT INTO 'albumsrecordingsmap' VALUES (10358, 11, 1080, 9774);
INSERT INTO 'albumsrecordingsmap' VALUES (10359, 12, 1080, 9775);
INSERT INTO 'albumsrecordingsmap' VALUES (10360, 13, 1080, 9776);
INSERT INTO 'albumsrecordingsmap' VALUES (5572, 1, 394, 5225);
INSERT INTO 'albumsrecordingsmap' VALUES (5573, 2, 394, 5226);
INSERT INTO 'albumsrecordingsmap' VALUES (5574, 3, 394, 5227);
INSERT INTO 'albumsrecordingsmap' VALUES (5575, 4, 394, 5228);
INSERT INTO 'albumsrecordingsmap' VALUES (5576, 5, 394, 5229);
INSERT INTO 'albumsrecordingsmap' VALUES (5577, 6, 394, 5230);
INSERT INTO 'albumsrecordingsmap' VALUES (5578, 7, 394, 5231);
INSERT INTO 'albumsrecordingsmap' VALUES (5579, 8, 394, 5232);
INSERT INTO 'albumsrecordingsmap' VALUES (5580, 9, 394, 5233);
INSERT INTO 'albumsrecordingsmap' VALUES (5581, 10, 394, 5234);
INSERT INTO 'albumsrecordingsmap' VALUES (5582, 11, 394, 5235);
INSERT INTO 'albumsrecordingsmap' VALUES (5583, 12, 394, 5236);
INSERT INTO 'albumsrecordingsmap' VALUES (5584, 13, 394, 5237);
INSERT INTO 'albumsrecordingsmap' VALUES (5585, 14, 394, 5238);
INSERT INTO 'albumsrecordingsmap' VALUES (5586, 15, 394, 5239);
INSERT INTO 'albumsrecordingsmap' VALUES (10361, 1, 1081, 9777);
INSERT INTO 'albumsrecordingsmap' VALUES (10362, 2, 1081, 9778);
INSERT INTO 'albumsrecordingsmap' VALUES (10363, 3, 1081, 9779);
INSERT INTO 'albumsrecordingsmap' VALUES (10364, 4, 1081, 9780);
INSERT INTO 'albumsrecordingsmap' VALUES (10365, 5, 1081, 9782);
INSERT INTO 'albumsrecordingsmap' VALUES (10366, 6, 1081, 9781);
INSERT INTO 'albumsrecordingsmap' VALUES (10367, 7, 1081, 9783);
INSERT INTO 'albumsrecordingsmap' VALUES (10368, 8, 1081, 9784);
INSERT INTO 'albumsrecordingsmap' VALUES (10369, 9, 1081, 9785);
INSERT INTO 'albumsrecordingsmap' VALUES (10370, 10, 1081, 9787);
INSERT INTO 'albumsrecordingsmap' VALUES (10371, 11, 1081, 9788);
INSERT INTO 'albumsrecordingsmap' VALUES (10372, 12, 1081, 9786);
INSERT INTO 'albumsrecordingsmap' VALUES (3269, 1, 315, 3243);
INSERT INTO 'albumsrecordingsmap' VALUES (3270, 3, 315, 3244);
INSERT INTO 'albumsrecordingsmap' VALUES (3271, 4, 315, 3245);
INSERT INTO 'albumsrecordingsmap' VALUES (3272, 15, 315, 3246);
INSERT INTO 'albumsrecordingsmap' VALUES (3273, 16, 315, 3247);
INSERT INTO 'albumsrecordingsmap' VALUES (10392, 2, 315, 9808);
INSERT INTO 'albumsrecordingsmap' VALUES (10393, 5, 315, 9809);
INSERT INTO 'albumsrecordingsmap' VALUES (10394, 6, 315, 9810);
INSERT INTO 'albumsrecordingsmap' VALUES (10274, 1, 1075, 9690);
INSERT INTO 'albumsrecordingsmap' VALUES (10275, 2, 1075, 9691);
INSERT INTO 'albumsrecordingsmap' VALUES (10276, 3, 1075, 9692);
INSERT INTO 'albumsrecordingsmap' VALUES (10277, 4, 1075, 9693);
INSERT INTO 'albumsrecordingsmap' VALUES (10278, 5, 1075, 9694);
INSERT INTO 'albumsrecordingsmap' VALUES (10279, 6, 1075, 9695);
INSERT INTO 'albumsrecordingsmap' VALUES (10280, 7, 1075, 9696);
INSERT INTO 'albumsrecordingsmap' VALUES (10281, 8, 1075, 9697);
INSERT INTO 'albumsrecordingsmap' VALUES (10282, 9, 1075, 9698);
INSERT INTO 'albumsrecordingsmap' VALUES (10283, 10, 1075, 9699);
INSERT INTO 'albumsrecordingsmap' VALUES (10284, 11, 1075, 9700);
INSERT INTO 'albumsrecordingsmap' VALUES (10395, 7, 315, 9811);
INSERT INTO 'albumsrecordingsmap' VALUES (10396, 8, 315, 9812);
INSERT INTO 'albumsrecordingsmap' VALUES (10397, 9, 315, 9813);
INSERT INTO 'albumsrecordingsmap' VALUES (10398, 10, 315, 9814);
INSERT INTO 'albumsrecordingsmap' VALUES (10399, 11, 315, 9815);
INSERT INTO 'albumsrecordingsmap' VALUES (10285, 12, 1075, 9701);
INSERT INTO 'albumsrecordingsmap' VALUES (10286, 13, 1075, 9702);
INSERT INTO 'albumsrecordingsmap' VALUES (10287, 14, 1075, 9703);
INSERT INTO 'albumsrecordingsmap' VALUES (10862, 4, 1118, 10268);
INSERT INTO 'albumsrecordingsmap' VALUES (10865, 7, 1118, 10271);
INSERT INTO 'albumsrecordingsmap' VALUES (10866, 8, 1118, 10272);
INSERT INTO 'albumsrecordingsmap' VALUES (10867, 9, 1118, 10273);
INSERT INTO 'albumsrecordingsmap' VALUES (10868, 10, 1118, 10274);
INSERT INTO 'albumsrecordingsmap' VALUES (10400, 12, 315, 9816);
INSERT INTO 'albumsrecordingsmap' VALUES (10401, 1, 1083, 9817);
INSERT INTO 'albumsrecordingsmap' VALUES (10402, 2, 1083, 9818);
INSERT INTO 'albumsrecordingsmap' VALUES (10403, 3, 1083, 9819);
INSERT INTO 'albumsrecordingsmap' VALUES (10404, 4, 1083, 9820);
INSERT INTO 'albumsrecordingsmap' VALUES (10405, 5, 1083, 9821);
INSERT INTO 'albumsrecordingsmap' VALUES (10406, 6, 1083, 9822);
INSERT INTO 'albumsrecordingsmap' VALUES (10407, 7, 1083, 9823);
INSERT INTO 'albumsrecordingsmap' VALUES (10408, 8, 1083, 9824);
INSERT INTO 'albumsrecordingsmap' VALUES (10409, 9, 1083, 9825);
INSERT INTO 'albumsrecordingsmap' VALUES (10410, 10, 1083, 9826);
INSERT INTO 'albumsrecordingsmap' VALUES (10411, 11, 1083, 9827);
INSERT INTO 'albumsrecordingsmap' VALUES (10412, 12, 1083, 9828);
INSERT INTO 'albumsrecordingsmap' VALUES (10413, 13, 1083, 9829);
INSERT INTO 'albumsrecordingsmap' VALUES (5134, 1, 352, 4868);
INSERT INTO 'albumsrecordingsmap' VALUES (5135, 2, 352, 4869);
INSERT INTO 'albumsrecordingsmap' VALUES (5136, 3, 352, 4870);
INSERT INTO 'albumsrecordingsmap' VALUES (5137, 4, 352, 4871);
INSERT INTO 'albumsrecordingsmap' VALUES (5138, 5, 352, 4872);
INSERT INTO 'albumsrecordingsmap' VALUES (5139, 6, 352, 4873);
INSERT INTO 'albumsrecordingsmap' VALUES (5140, 7, 352, 4874);
INSERT INTO 'albumsrecordingsmap' VALUES (5141, 8, 352, 4875);
INSERT INTO 'albumsrecordingsmap' VALUES (5142, 9, 352, 4876);
INSERT INTO 'albumsrecordingsmap' VALUES (5143, 10, 352, 4877);
INSERT INTO 'albumsrecordingsmap' VALUES (5144, 11, 352, 4878);
INSERT INTO 'albumsrecordingsmap' VALUES (5145, 12, 352, 4879);
INSERT INTO 'albumsrecordingsmap' VALUES (5146, 13, 352, 4880);
INSERT INTO 'albumsrecordingsmap' VALUES (5147, 14, 352, 4881);
INSERT INTO 'albumsrecordingsmap' VALUES (10431, 1, 1085, 9847);
INSERT INTO 'albumsrecordingsmap' VALUES (10432, 2, 1085, 9848);
INSERT INTO 'albumsrecordingsmap' VALUES (10433, 3, 1085, 9849);
INSERT INTO 'albumsrecordingsmap' VALUES (10434, 4, 1085, 9850);
INSERT INTO 'albumsrecordingsmap' VALUES (10435, 5, 1085, 9851);
INSERT INTO 'albumsrecordingsmap' VALUES (10436, 6, 1085, 9852);
INSERT INTO 'albumsrecordingsmap' VALUES (10437, 7, 1085, 9853);
INSERT INTO 'albumsrecordingsmap' VALUES (10438, 8, 1085, 9854);
INSERT INTO 'albumsrecordingsmap' VALUES (10439, 9, 1085, 9855);
INSERT INTO 'albumsrecordingsmap' VALUES (10440, 10, 1085, 9856);
INSERT INTO 'albumsrecordingsmap' VALUES (10288, 15, 1075, 9704);
INSERT INTO 'albumsrecordingsmap' VALUES (10443, 1, 1087, 9860);
INSERT INTO 'albumsrecordingsmap' VALUES (2473, 4, 245, 2464);
INSERT INTO 'albumsrecordingsmap' VALUES (2474, 2, 245, 2465);
INSERT INTO 'albumsrecordingsmap' VALUES (2475, 11, 245, 2466);
INSERT INTO 'albumsrecordingsmap' VALUES (2476, 8, 245, 2467);
INSERT INTO 'albumsrecordingsmap' VALUES (2477, 12, 245, 2468);
INSERT INTO 'albumsrecordingsmap' VALUES (2478, 13, 245, 2469);
INSERT INTO 'albumsrecordingsmap' VALUES (2479, 6, 245, 2470);
INSERT INTO 'albumsrecordingsmap' VALUES (2480, 7, 245, 2471);
INSERT INTO 'albumsrecordingsmap' VALUES (2481, 1, 245, 2472);
INSERT INTO 'albumsrecordingsmap' VALUES (2482, 9, 245, 2473);
INSERT INTO 'albumsrecordingsmap' VALUES (2483, 10, 245, 2475);
INSERT INTO 'albumsrecordingsmap' VALUES (3067, 5, 245, 3078);
INSERT INTO 'albumsrecordingsmap' VALUES (10441, 3, 245, 9857);
INSERT INTO 'albumsrecordingsmap' VALUES (10444, 2, 1087, 9861);
INSERT INTO 'albumsrecordingsmap' VALUES (10465, 1, 1089, 4933);
INSERT INTO 'albumsrecordingsmap' VALUES (10466, 2, 1089, 2962);
INSERT INTO 'albumsrecordingsmap' VALUES (10809, 1, 1113, 10215);
INSERT INTO 'albumsrecordingsmap' VALUES (10810, 2, 1113, 10216);
INSERT INTO 'albumsrecordingsmap' VALUES (10811, 3, 1113, 10217);
INSERT INTO 'albumsrecordingsmap' VALUES (10812, 4, 1113, 10218);
INSERT INTO 'albumsrecordingsmap' VALUES (10813, 5, 1113, 10219);
INSERT INTO 'albumsrecordingsmap' VALUES (10814, 6, 1113, 10220);
INSERT INTO 'albumsrecordingsmap' VALUES (10815, 7, 1113, 10221);
INSERT INTO 'albumsrecordingsmap' VALUES (10816, 8, 1113, 10222);
INSERT INTO 'albumsrecordingsmap' VALUES (10817, 9, 1113, 10223);
INSERT INTO 'albumsrecordingsmap' VALUES (10824, 16, 1113, 10230);
INSERT INTO 'albumsrecordingsmap' VALUES (10150, 1, 1068, 9577);
INSERT INTO 'albumsrecordingsmap' VALUES (10151, 2, 1068, 9578);
INSERT INTO 'albumsrecordingsmap' VALUES (10152, 3, 1068, 9579);
INSERT INTO 'albumsrecordingsmap' VALUES (4323, 1, 365, 9858);
INSERT INTO 'albumsrecordingsmap' VALUES (4324, 2, 365, 1706);
INSERT INTO 'albumsrecordingsmap' VALUES (4325, 3, 365, 1707);
INSERT INTO 'albumsrecordingsmap' VALUES (4326, 4, 365, 1708);
INSERT INTO 'albumsrecordingsmap' VALUES (4327, 5, 365, 1709);
INSERT INTO 'albumsrecordingsmap' VALUES (4328, 6, 365, 1710);
INSERT INTO 'albumsrecordingsmap' VALUES (4329, 7, 365, 1711);
INSERT INTO 'albumsrecordingsmap' VALUES (4330, 8, 365, 1712);
INSERT INTO 'albumsrecordingsmap' VALUES (4331, 9, 365, 1713);
INSERT INTO 'albumsrecordingsmap' VALUES (4332, 11, 365, 1715);
INSERT INTO 'albumsrecordingsmap' VALUES (4333, 12, 365, 1716);
INSERT INTO 'albumsrecordingsmap' VALUES (4334, 13, 365, 3618);
INSERT INTO 'albumsrecordingsmap' VALUES (4335, 14, 365, 3619);
INSERT INTO 'albumsrecordingsmap' VALUES (4336, 15, 365, 4168);
INSERT INTO 'albumsrecordingsmap' VALUES (4337, 16, 365, 4169);
INSERT INTO 'albumsrecordingsmap' VALUES (4338, 17, 365, 4171);
INSERT INTO 'albumsrecordingsmap' VALUES (10442, 10, 365, 9859);
INSERT INTO 'albumsrecordingsmap' VALUES (10467, 3, 1089, 7662);
INSERT INTO 'albumsrecordingsmap' VALUES (10468, 4, 1089, 2964);
INSERT INTO 'albumsrecordingsmap' VALUES (10445, 3, 1087, 9862);
INSERT INTO 'albumsrecordingsmap' VALUES (10446, 4, 1087, 9863);
INSERT INTO 'albumsrecordingsmap' VALUES (10447, 5, 1087, 9864);
INSERT INTO 'albumsrecordingsmap' VALUES (10448, 6, 1087, 9865);
INSERT INTO 'albumsrecordingsmap' VALUES (10449, 7, 1087, 9866);
INSERT INTO 'albumsrecordingsmap' VALUES (10153, 4, 1068, 9580);
INSERT INTO 'albumsrecordingsmap' VALUES (10154, 5, 1068, 9581);
INSERT INTO 'albumsrecordingsmap' VALUES (10155, 6, 1068, 9582);
INSERT INTO 'albumsrecordingsmap' VALUES (10156, 7, 1068, 9583);
INSERT INTO 'albumsrecordingsmap' VALUES (10157, 8, 1068, 9584);
INSERT INTO 'albumsrecordingsmap' VALUES (10158, 9, 1068, 9585);
INSERT INTO 'albumsrecordingsmap' VALUES (10159, 10, 1068, 9586);
INSERT INTO 'albumsrecordingsmap' VALUES (10160, 11, 1068, 9587);
INSERT INTO 'albumsrecordingsmap' VALUES (10161, 12, 1068, 9588);
INSERT INTO 'albumsrecordingsmap' VALUES (10162, 13, 1068, 9589);
INSERT INTO 'albumsrecordingsmap' VALUES (10163, 14, 1068, 9590);
INSERT INTO 'albumsrecordingsmap' VALUES (10164, 15, 1068, 9591);
INSERT INTO 'albumsrecordingsmap' VALUES (10165, 16, 1068, 9592);
INSERT INTO 'albumsrecordingsmap' VALUES (10166, 17, 1068, 9593);
INSERT INTO 'albumsrecordingsmap' VALUES (10167, 18, 1068, 9594);
INSERT INTO 'albumsrecordingsmap' VALUES (6038, 1, 439, 5581);
INSERT INTO 'albumsrecordingsmap' VALUES (6039, 2, 439, 5582);
INSERT INTO 'albumsrecordingsmap' VALUES (6040, 3, 439, 5583);
INSERT INTO 'albumsrecordingsmap' VALUES (6041, 4, 439, 5584);
INSERT INTO 'albumsrecordingsmap' VALUES (6042, 5, 439, 5585);
INSERT INTO 'albumsrecordingsmap' VALUES (6043, 6, 439, 5586);
INSERT INTO 'albumsrecordingsmap' VALUES (6044, 7, 439, 5587);
INSERT INTO 'albumsrecordingsmap' VALUES (6045, 8, 439, 5588);
INSERT INTO 'albumsrecordingsmap' VALUES (6046, 9, 439, 5589);
INSERT INTO 'albumsrecordingsmap' VALUES (6047, 10, 439, 5590);
INSERT INTO 'albumsrecordingsmap' VALUES (6048, 11, 439, 5591);
INSERT INTO 'albumsrecordingsmap' VALUES (6049, 12, 439, 5592);
INSERT INTO 'albumsrecordingsmap' VALUES (6050, 13, 439, 5593);
INSERT INTO 'albumsrecordingsmap' VALUES (6051, 14, 439, 5594);
INSERT INTO 'albumsrecordingsmap' VALUES (6052, 15, 439, 5595);
INSERT INTO 'albumsrecordingsmap' VALUES (10450, 8, 1087, 9867);
INSERT INTO 'albumsrecordingsmap' VALUES (10451, 9, 1087, 9868);
INSERT INTO 'albumsrecordingsmap' VALUES (10469, 1, 1090, 9888);
INSERT INTO 'albumsrecordingsmap' VALUES (10470, 2, 1090, 9889);
INSERT INTO 'albumsrecordingsmap' VALUES (10485, 1, 1091, 9875);
INSERT INTO 'albumsrecordingsmap' VALUES (10452, 10, 1087, 9869);
INSERT INTO 'albumsrecordingsmap' VALUES (10486, 2, 1091, 9876);
INSERT INTO 'albumsrecordingsmap' VALUES (10825, 17, 1113, 10231);
INSERT INTO 'albumsrecordingsmap' VALUES (5368, 1, 371, 5067);
INSERT INTO 'albumsrecordingsmap' VALUES (10453, 1, 1088, 4060);
INSERT INTO 'albumsrecordingsmap' VALUES (10454, 2, 1088, 8680);
INSERT INTO 'albumsrecordingsmap' VALUES (10455, 3, 1088, 8660);
INSERT INTO 'albumsrecordingsmap' VALUES (10456, 4, 1088, 2829);
INSERT INTO 'albumsrecordingsmap' VALUES (10471, 3, 1090, 9890);
INSERT INTO 'albumsrecordingsmap' VALUES (10472, 4, 1090, 9891);
INSERT INTO 'albumsrecordingsmap' VALUES (10487, 3, 1091, 9877);
INSERT INTO 'albumsrecordingsmap' VALUES (10488, 4, 1091, 9878);
INSERT INTO 'albumsrecordingsmap' VALUES (10489, 5, 1091, 9879);
INSERT INTO 'albumsrecordingsmap' VALUES (10473, 5, 1090, 9892);
INSERT INTO 'albumsrecordingsmap' VALUES (10474, 6, 1090, 9893);
INSERT INTO 'albumsrecordingsmap' VALUES (10475, 7, 1090, 9894);
INSERT INTO 'albumsrecordingsmap' VALUES (10476, 8, 1090, 9895);
INSERT INTO 'albumsrecordingsmap' VALUES (10477, 9, 1090, 9896);
INSERT INTO 'albumsrecordingsmap' VALUES (10478, 10, 1090, 9897);
INSERT INTO 'albumsrecordingsmap' VALUES (10479, 11, 1090, 9898);
INSERT INTO 'albumsrecordingsmap' VALUES (10480, 12, 1090, 9899);
INSERT INTO 'albumsrecordingsmap' VALUES (10481, 13, 1090, 9900);
INSERT INTO 'albumsrecordingsmap' VALUES (10482, 14, 1090, 9901);
INSERT INTO 'albumsrecordingsmap' VALUES (10483, 15, 1090, 9902);
INSERT INTO 'albumsrecordingsmap' VALUES (10484, 16, 1090, 9903);
INSERT INTO 'albumsrecordingsmap' VALUES (10490, 6, 1091, 9880);
INSERT INTO 'albumsrecordingsmap' VALUES (10491, 7, 1091, 9881);
INSERT INTO 'albumsrecordingsmap' VALUES (10492, 8, 1091, 9882);
INSERT INTO 'albumsrecordingsmap' VALUES (10493, 9, 1091, 9883);
INSERT INTO 'albumsrecordingsmap' VALUES (10494, 10, 1091, 9884);
INSERT INTO 'albumsrecordingsmap' VALUES (10495, 11, 1091, 9885);
INSERT INTO 'albumsrecordingsmap' VALUES (10496, 12, 1091, 9886);
INSERT INTO 'albumsrecordingsmap' VALUES (10497, 13, 1091, 9887);
INSERT INTO 'albumsrecordingsmap' VALUES (5369, 2, 371, 5068);
INSERT INTO 'albumsrecordingsmap' VALUES (5370, 3, 371, 5069);
INSERT INTO 'albumsrecordingsmap' VALUES (5371, 4, 371, 5070);
INSERT INTO 'albumsrecordingsmap' VALUES (5372, 5, 371, 5071);
INSERT INTO 'albumsrecordingsmap' VALUES (5373, 6, 371, 5072);
INSERT INTO 'albumsrecordingsmap' VALUES (5374, 7, 371, 5073);
INSERT INTO 'albumsrecordingsmap' VALUES (10498, 1, 1092, 9904);
INSERT INTO 'albumsrecordingsmap' VALUES (10499, 2, 1092, 9905);
INSERT INTO 'albumsrecordingsmap' VALUES (10500, 3, 1092, 9906);
INSERT INTO 'albumsrecordingsmap' VALUES (10501, 4, 1092, 9907);
INSERT INTO 'albumsrecordingsmap' VALUES (10502, 5, 1092, 9908);
INSERT INTO 'albumsrecordingsmap' VALUES (10503, 6, 1092, 9909);
INSERT INTO 'albumsrecordingsmap' VALUES (10504, 7, 1092, 9910);
INSERT INTO 'albumsrecordingsmap' VALUES (10505, 8, 1092, 9911);
INSERT INTO 'albumsrecordingsmap' VALUES (10506, 9, 1092, 9912);
INSERT INTO 'albumsrecordingsmap' VALUES (10507, 10, 1092, 9913);
INSERT INTO 'albumsrecordingsmap' VALUES (10508, 11, 1092, 9914);
INSERT INTO 'albumsrecordingsmap' VALUES (10509, 12, 1092, 9915);
INSERT INTO 'albumsrecordingsmap' VALUES (10510, 13, 1092, 9916);
INSERT INTO 'albumsrecordingsmap' VALUES (10511, 14, 1092, 9917);
INSERT INTO 'albumsrecordingsmap' VALUES (5375, 8, 371, 5074);
INSERT INTO 'albumsrecordingsmap' VALUES (5376, 9, 371, 5075);
INSERT INTO 'albumsrecordingsmap' VALUES (5377, 10, 371, 5076);
INSERT INTO 'albumsrecordingsmap' VALUES (10512, 1, 1093, 9918);
INSERT INTO 'albumsrecordingsmap' VALUES (10513, 2, 1093, 9919);
INSERT INTO 'albumsrecordingsmap' VALUES (10514, 3, 1093, 9920);
INSERT INTO 'albumsrecordingsmap' VALUES (10515, 4, 1093, 9921);
INSERT INTO 'albumsrecordingsmap' VALUES (10516, 5, 1093, 9922);
INSERT INTO 'albumsrecordingsmap' VALUES (10517, 6, 1093, 9923);
INSERT INTO 'albumsrecordingsmap' VALUES (10518, 7, 1093, 9924);
INSERT INTO 'albumsrecordingsmap' VALUES (10519, 8, 1093, 9925);
INSERT INTO 'albumsrecordingsmap' VALUES (10520, 9, 1093, 9926);
INSERT INTO 'albumsrecordingsmap' VALUES (10521, 10, 1093, 9927);
INSERT INTO 'albumsrecordingsmap' VALUES (10522, 11, 1093, 9928);
INSERT INTO 'albumsrecordingsmap' VALUES (10523, 12, 1093, 9929);
INSERT INTO 'albumsrecordingsmap' VALUES (10524, 13, 1093, 9930);
INSERT INTO 'albumsrecordingsmap' VALUES (10525, 14, 1093, 9931);
INSERT INTO 'albumsrecordingsmap' VALUES (10526, 15, 1093, 9932);
INSERT INTO 'albumsrecordingsmap' VALUES (10527, 16, 1093, 9933);
INSERT INTO 'albumsrecordingsmap' VALUES (10528, 17, 1093, 9934);
INSERT INTO 'albumsrecordingsmap' VALUES (10529, 18, 1093, 9935);
INSERT INTO 'albumsrecordingsmap' VALUES (5378, 11, 371, 5077);
INSERT INTO 'albumsrecordingsmap' VALUES (5379, 12, 371, 5078);
INSERT INTO 'albumsrecordingsmap' VALUES (1124, 1, 93, 1105);
INSERT INTO 'albumsrecordingsmap' VALUES (1125, 2, 93, 1106);
INSERT INTO 'albumsrecordingsmap' VALUES (1126, 3, 93, 1107);
INSERT INTO 'albumsrecordingsmap' VALUES (1127, 4, 93, 1108);
INSERT INTO 'albumsrecordingsmap' VALUES (1128, 5, 93, 1109);
INSERT INTO 'albumsrecordingsmap' VALUES (1129, 6, 93, 1110);
INSERT INTO 'albumsrecordingsmap' VALUES (1130, 7, 93, 1111);
INSERT INTO 'albumsrecordingsmap' VALUES (1131, 8, 93, 1112);
INSERT INTO 'albumsrecordingsmap' VALUES (1132, 9, 93, 1113);
INSERT INTO 'albumsrecordingsmap' VALUES (1133, 10, 93, 1114);
INSERT INTO 'albumsrecordingsmap' VALUES (1134, 11, 93, 1115);
INSERT INTO 'albumsrecordingsmap' VALUES (1135, 12, 93, 1116);
INSERT INTO 'albumsrecordingsmap' VALUES (1136, 13, 93, 1117);
INSERT INTO 'albumsrecordingsmap' VALUES (1137, 14, 93, 1118);
INSERT INTO 'albumsrecordingsmap' VALUES (1138, 15, 93, 1119);
INSERT INTO 'albumsrecordingsmap' VALUES (1139, 16, 93, 1120);
INSERT INTO 'albumsrecordingsmap' VALUES (10530, 1, 1094, 9936);
INSERT INTO 'albumsrecordingsmap' VALUES (10531, 2, 1094, 9937);
INSERT INTO 'albumsrecordingsmap' VALUES (10532, 3, 1094, 9938);
INSERT INTO 'albumsrecordingsmap' VALUES (10533, 4, 1094, 9939);
INSERT INTO 'albumsrecordingsmap' VALUES (10534, 5, 1094, 9940);
INSERT INTO 'albumsrecordingsmap' VALUES (10535, 6, 1094, 9941);
INSERT INTO 'albumsrecordingsmap' VALUES (10536, 7, 1094, 9942);
INSERT INTO 'albumsrecordingsmap' VALUES (10537, 8, 1094, 9943);
INSERT INTO 'albumsrecordingsmap' VALUES (10538, 9, 1094, 9944);
INSERT INTO 'albumsrecordingsmap' VALUES (10539, 10, 1094, 9945);
INSERT INTO 'albumsrecordingsmap' VALUES (10540, 11, 1094, 9946);
INSERT INTO 'albumsrecordingsmap' VALUES (10541, 12, 1094, 9947);
INSERT INTO 'albumsrecordingsmap' VALUES (10542, 13, 1094, 9948);
INSERT INTO 'albumsrecordingsmap' VALUES (10543, 14, 1094, 9949);
INSERT INTO 'albumsrecordingsmap' VALUES (10544, 15, 1094, 9950);
INSERT INTO 'albumsrecordingsmap' VALUES (5380, 13, 371, 5079);
INSERT INTO 'albumsrecordingsmap' VALUES (1711, 4, 203, 1670);
INSERT INTO 'albumsrecordingsmap' VALUES (10871, 13, 1118, 10277);
INSERT INTO 'albumsrecordingsmap' VALUES (1712, 8, 203, 1671);
INSERT INTO 'albumsrecordingsmap' VALUES (1713, 6, 203, 1672);
INSERT INTO 'albumsrecordingsmap' VALUES (10592, 2, 1096, 9999);
INSERT INTO 'albumsrecordingsmap' VALUES (10593, 3, 1096, 10000);
INSERT INTO 'albumsrecordingsmap' VALUES (1714, 1, 203, 1673);
INSERT INTO 'albumsrecordingsmap' VALUES (1715, 7, 203, 1674);
INSERT INTO 'albumsrecordingsmap' VALUES (1716, 2, 203, 1675);
INSERT INTO 'albumsrecordingsmap' VALUES (10594, 4, 1096, 10001);
INSERT INTO 'albumsrecordingsmap' VALUES (10560, 1, 1097, 9967);
INSERT INTO 'albumsrecordingsmap' VALUES (10561, 2, 1097, 9968);
INSERT INTO 'albumsrecordingsmap' VALUES (10562, 3, 1097, 9972);
INSERT INTO 'albumsrecordingsmap' VALUES (10563, 4, 1097, 9970);
INSERT INTO 'albumsrecordingsmap' VALUES (1717, 5, 203, 1676);
INSERT INTO 'albumsrecordingsmap' VALUES (10564, 5, 1097, 9971);
INSERT INTO 'albumsrecordingsmap' VALUES (10565, 6, 1097, 9969);
INSERT INTO 'albumsrecordingsmap' VALUES (10566, 7, 1097, 9973);
INSERT INTO 'albumsrecordingsmap' VALUES (10457, 5, 1088, 3271);
INSERT INTO 'albumsrecordingsmap' VALUES (10458, 6, 1088, 9870);
INSERT INTO 'albumsrecordingsmap' VALUES (10459, 7, 1088, 4069);
INSERT INTO 'albumsrecordingsmap' VALUES (10460, 8, 1088, 9871);
INSERT INTO 'albumsrecordingsmap' VALUES (10461, 9, 1088, 8198);
INSERT INTO 'albumsrecordingsmap' VALUES (10462, 10, 1088, 9872);
INSERT INTO 'albumsrecordingsmap' VALUES (10463, 11, 1088, 9873);
INSERT INTO 'albumsrecordingsmap' VALUES (10464, 12, 1088, 9874);
INSERT INTO 'albumsrecordingsmap' VALUES (10567, 8, 1097, 9974);
INSERT INTO 'albumsrecordingsmap' VALUES (10568, 9, 1097, 9975);
INSERT INTO 'albumsrecordingsmap' VALUES (10569, 10, 1097, 9976);
INSERT INTO 'albumsrecordingsmap' VALUES (10570, 11, 1097, 9977);
INSERT INTO 'albumsrecordingsmap' VALUES (10571, 12, 1097, 9978);
INSERT INTO 'albumsrecordingsmap' VALUES (10572, 13, 1097, 9979);
INSERT INTO 'albumsrecordingsmap' VALUES (10573, 14, 1097, 9980);
INSERT INTO 'albumsrecordingsmap' VALUES (10574, 15, 1097, 9981);
INSERT INTO 'albumsrecordingsmap' VALUES (10595, 5, 1096, 10002);
INSERT INTO 'albumsrecordingsmap' VALUES (10596, 6, 1096, 10003);
INSERT INTO 'albumsrecordingsmap' VALUES (10597, 7, 1096, 10004);
INSERT INTO 'albumsrecordingsmap' VALUES (10598, 8, 1096, 10005);
INSERT INTO 'albumsrecordingsmap' VALUES (10600, 10, 1096, 10008);
INSERT INTO 'albumsrecordingsmap' VALUES (10601, 11, 1096, 10009);
INSERT INTO 'albumsrecordingsmap' VALUES (10575, 16, 1097, 9982);
INSERT INTO 'albumsrecordingsmap' VALUES (10576, 1, 1098, 9983);
INSERT INTO 'albumsrecordingsmap' VALUES (10577, 2, 1098, 9984);
INSERT INTO 'albumsrecordingsmap' VALUES (10578, 3, 1098, 9985);
INSERT INTO 'albumsrecordingsmap' VALUES (10579, 4, 1098, 9986);
INSERT INTO 'albumsrecordingsmap' VALUES (10580, 5, 1098, 9987);
INSERT INTO 'albumsrecordingsmap' VALUES (10581, 6, 1098, 9988);
INSERT INTO 'albumsrecordingsmap' VALUES (10582, 7, 1098, 9989);
INSERT INTO 'albumsrecordingsmap' VALUES (10583, 8, 1098, 9990);
INSERT INTO 'albumsrecordingsmap' VALUES (10584, 9, 1098, 9991);
INSERT INTO 'albumsrecordingsmap' VALUES (10585, 10, 1098, 9992);
INSERT INTO 'albumsrecordingsmap' VALUES (10586, 11, 1098, 9993);
INSERT INTO 'albumsrecordingsmap' VALUES (10587, 12, 1098, 9994);
INSERT INTO 'albumsrecordingsmap' VALUES (10588, 13, 1098, 9995);
INSERT INTO 'albumsrecordingsmap' VALUES (10589, 14, 1098, 9996);
INSERT INTO 'albumsrecordingsmap' VALUES (10590, 15, 1098, 9997);
INSERT INTO 'albumsrecordingsmap' VALUES (916, 2, 78, 904);
INSERT INTO 'albumsrecordingsmap' VALUES (917, 4, 78, 906);
INSERT INTO 'albumsrecordingsmap' VALUES (918, 5, 78, 907);
INSERT INTO 'albumsrecordingsmap' VALUES (919, 6, 78, 908);
INSERT INTO 'albumsrecordingsmap' VALUES (920, 7, 78, 909);
INSERT INTO 'albumsrecordingsmap' VALUES (921, 8, 78, 910);
INSERT INTO 'albumsrecordingsmap' VALUES (922, 9, 78, 911);
INSERT INTO 'albumsrecordingsmap' VALUES (923, 10, 78, 912);
INSERT INTO 'albumsrecordingsmap' VALUES (924, 11, 78, 913);
INSERT INTO 'albumsrecordingsmap' VALUES (932, 1, 78, 149);
INSERT INTO 'albumsrecordingsmap' VALUES (6364, 3, 78, 106);
INSERT INTO 'albumsrecordingsmap' VALUES (7689, 1, 919, 7159);
INSERT INTO 'albumsrecordingsmap' VALUES (7690, 2, 919, 7160);
INSERT INTO 'albumsrecordingsmap' VALUES (7691, 3, 919, 7161);
INSERT INTO 'albumsrecordingsmap' VALUES (7692, 4, 919, 7162);
INSERT INTO 'albumsrecordingsmap' VALUES (7693, 5, 919, 7163);
INSERT INTO 'albumsrecordingsmap' VALUES (7694, 6, 919, 7164);
INSERT INTO 'albumsrecordingsmap' VALUES (7695, 7, 919, 7165);
INSERT INTO 'albumsrecordingsmap' VALUES (7696, 8, 919, 7166);
INSERT INTO 'albumsrecordingsmap' VALUES (10602, 9, 1096, 10007);
INSERT INTO 'albumsrecordingsmap' VALUES (10603, 12, 1096, 10011);
INSERT INTO 'albumsrecordingsmap' VALUES (7697, 9, 919, 7167);
INSERT INTO 'albumsrecordingsmap' VALUES (7698, 10, 919, 7168);
INSERT INTO 'albumsrecordingsmap' VALUES (7699, 11, 919, 7169);
INSERT INTO 'albumsrecordingsmap' VALUES (7700, 12, 919, 7170);
INSERT INTO 'albumsrecordingsmap' VALUES (7701, 13, 919, 7171);
INSERT INTO 'albumsrecordingsmap' VALUES (10591, 1, 1096, 9998);
INSERT INTO 'albumsrecordingsmap' VALUES (10604, 13, 1096, 10012);
INSERT INTO 'albumsrecordingsmap' VALUES (10605, 14, 1096, 10013);
INSERT INTO 'albumsrecordingsmap' VALUES (10606, 15, 1096, 10014);
INSERT INTO 'albumsrecordingsmap' VALUES (7702, 14, 919, 7172);
INSERT INTO 'albumsrecordingsmap' VALUES (8574, 1, 973, 8063);
INSERT INTO 'albumsrecordingsmap' VALUES (8575, 2, 973, 8064);
INSERT INTO 'albumsrecordingsmap' VALUES (8576, 3, 973, 8065);
INSERT INTO 'albumsrecordingsmap' VALUES (8577, 4, 973, 8066);
INSERT INTO 'albumsrecordingsmap' VALUES (8578, 5, 973, 8067);
INSERT INTO 'albumsrecordingsmap' VALUES (8579, 6, 973, 8068);
INSERT INTO 'albumsrecordingsmap' VALUES (8580, 7, 973, 8069);
INSERT INTO 'albumsrecordingsmap' VALUES (8581, 8, 973, 8070);
INSERT INTO 'albumsrecordingsmap' VALUES (8582, 9, 973, 8071);
INSERT INTO 'albumsrecordingsmap' VALUES (8583, 10, 973, 8072);
INSERT INTO 'albumsrecordingsmap' VALUES (8584, 11, 973, 8073);
INSERT INTO 'albumsrecordingsmap' VALUES (8585, 12, 973, 8074);
INSERT INTO 'albumsrecordingsmap' VALUES (8586, 13, 973, 8075);
INSERT INTO 'albumsrecordingsmap' VALUES (8587, 14, 973, 8076);
INSERT INTO 'albumsrecordingsmap' VALUES (8588, 15, 973, 8077);
INSERT INTO 'albumsrecordingsmap' VALUES (8589, 16, 973, 8078);
INSERT INTO 'albumsrecordingsmap' VALUES (8590, 17, 973, 8079);
INSERT INTO 'albumsrecordingsmap' VALUES (8591, 18, 973, 8080);
INSERT INTO 'albumsrecordingsmap' VALUES (8592, 19, 973, 8081);
INSERT INTO 'albumsrecordingsmap' VALUES (8593, 20, 973, 8082);
INSERT INTO 'albumsrecordingsmap' VALUES (8594, 21, 973, 8083);
INSERT INTO 'albumsrecordingsmap' VALUES (8595, 22, 973, 8084);
INSERT INTO 'albumsrecordingsmap' VALUES (8596, 23, 973, 8085);
INSERT INTO 'albumsrecordingsmap' VALUES (8597, 24, 973, 8086);
INSERT INTO 'albumsrecordingsmap' VALUES (6160, 6, 447, 5692);
INSERT INTO 'albumsrecordingsmap' VALUES (6161, 7, 447, 5693);
INSERT INTO 'albumsrecordingsmap' VALUES (6162, 8, 447, 5694);
INSERT INTO 'albumsrecordingsmap' VALUES (6163, 9, 447, 5695);
INSERT INTO 'albumsrecordingsmap' VALUES (6164, 10, 447, 5696);
INSERT INTO 'albumsrecordingsmap' VALUES (6165, 11, 447, 5697);
INSERT INTO 'albumsrecordingsmap' VALUES (6166, 12, 447, 5698);
INSERT INTO 'albumsrecordingsmap' VALUES (6167, 13, 447, 5699);
INSERT INTO 'albumsrecordingsmap' VALUES (6168, 14, 447, 5700);
INSERT INTO 'albumsrecordingsmap' VALUES (6169, 15, 447, 5701);
INSERT INTO 'albumsrecordingsmap' VALUES (10641, 3, 1101, 10049);
INSERT INTO 'albumsrecordingsmap' VALUES (10642, 4, 1101, 10050);
INSERT INTO 'albumsrecordingsmap' VALUES (10643, 5, 1101, 10051);
INSERT INTO 'albumsrecordingsmap' VALUES (10644, 6, 1101, 10052);
INSERT INTO 'albumsrecordingsmap' VALUES (10645, 7, 1101, 10053);
INSERT INTO 'albumsrecordingsmap' VALUES (10646, 8, 1101, 10054);
INSERT INTO 'albumsrecordingsmap' VALUES (10647, 9, 1101, 10055);
INSERT INTO 'albumsrecordingsmap' VALUES (10648, 10, 1101, 10056);
INSERT INTO 'albumsrecordingsmap' VALUES (10649, 11, 1101, 10057);
INSERT INTO 'albumsrecordingsmap' VALUES (10650, 12, 1101, 10058);
INSERT INTO 'albumsrecordingsmap' VALUES (10651, 13, 1101, 10059);
INSERT INTO 'albumsrecordingsmap' VALUES (10652, 14, 1101, 10060);
INSERT INTO 'albumsrecordingsmap' VALUES (10653, 15, 1101, 10061);
INSERT INTO 'albumsrecordingsmap' VALUES (10665, 12, 1102, 10073);
INSERT INTO 'albumsrecordingsmap' VALUES (10666, 13, 1102, 10074);
INSERT INTO 'albumsrecordingsmap' VALUES (10667, 14, 1102, 10075);
INSERT INTO 'albumsrecordingsmap' VALUES (9603, 1, 1035, 9089);
INSERT INTO 'albumsrecordingsmap' VALUES (9604, 2, 1035, 9090);
INSERT INTO 'albumsrecordingsmap' VALUES (9605, 3, 1035, 9091);
INSERT INTO 'albumsrecordingsmap' VALUES (9606, 4, 1035, 9092);
INSERT INTO 'albumsrecordingsmap' VALUES (9607, 5, 1035, 9093);
INSERT INTO 'albumsrecordingsmap' VALUES (9608, 6, 1035, 9094);
INSERT INTO 'albumsrecordingsmap' VALUES (9609, 7, 1035, 9095);
INSERT INTO 'albumsrecordingsmap' VALUES (9610, 8, 1035, 9096);
INSERT INTO 'albumsrecordingsmap' VALUES (9611, 9, 1035, 9097);
INSERT INTO 'albumsrecordingsmap' VALUES (9612, 10, 1035, 9098);
INSERT INTO 'albumsrecordingsmap' VALUES (10608, 2, 1099, 10015);
INSERT INTO 'albumsrecordingsmap' VALUES (10609, 3, 1099, 10017);
INSERT INTO 'albumsrecordingsmap' VALUES (10610, 4, 1099, 10018);
INSERT INTO 'albumsrecordingsmap' VALUES (10611, 5, 1099, 10019);
INSERT INTO 'albumsrecordingsmap' VALUES (10612, 7, 1099, 10020);
INSERT INTO 'albumsrecordingsmap' VALUES (10613, 8, 1099, 10021);
INSERT INTO 'albumsrecordingsmap' VALUES (10614, 6, 1099, 10027);
INSERT INTO 'albumsrecordingsmap' VALUES (10616, 10, 1099, 10023);
INSERT INTO 'albumsrecordingsmap' VALUES (10617, 12, 1099, 10025);
INSERT INTO 'albumsrecordingsmap' VALUES (10618, 13, 1099, 10026);
INSERT INTO 'albumsrecordingsmap' VALUES (10619, 14, 1099, 10028);
INSERT INTO 'albumsrecordingsmap' VALUES (10620, 11, 1099, 10024);
INSERT INTO 'albumsrecordingsmap' VALUES (9613, 11, 1035, 9099);
INSERT INTO 'albumsrecordingsmap' VALUES (9614, 12, 1035, 9100);
INSERT INTO 'albumsrecordingsmap' VALUES (9615, 13, 1035, 9101);
INSERT INTO 'albumsrecordingsmap' VALUES (10685, 1, 1104, 10093);
INSERT INTO 'albumsrecordingsmap' VALUES (10621, 1, 1100, 10029);
INSERT INTO 'albumsrecordingsmap' VALUES (10622, 2, 1100, 10030);
INSERT INTO 'albumsrecordingsmap' VALUES (10623, 3, 1100, 10031);
INSERT INTO 'albumsrecordingsmap' VALUES (10624, 4, 1100, 10032);
INSERT INTO 'albumsrecordingsmap' VALUES (10625, 5, 1100, 10033);
INSERT INTO 'albumsrecordingsmap' VALUES (10626, 6, 1100, 10034);
INSERT INTO 'albumsrecordingsmap' VALUES (10627, 7, 1100, 10035);
INSERT INTO 'albumsrecordingsmap' VALUES (10628, 8, 1100, 10036);
INSERT INTO 'albumsrecordingsmap' VALUES (10629, 9, 1100, 10037);
INSERT INTO 'albumsrecordingsmap' VALUES (10630, 10, 1100, 10038);
INSERT INTO 'albumsrecordingsmap' VALUES (10631, 11, 1100, 10039);
INSERT INTO 'albumsrecordingsmap' VALUES (10632, 12, 1100, 10040);
INSERT INTO 'albumsrecordingsmap' VALUES (10633, 13, 1100, 10041);
INSERT INTO 'albumsrecordingsmap' VALUES (10634, 14, 1100, 10042);
INSERT INTO 'albumsrecordingsmap' VALUES (10635, 15, 1100, 10043);
INSERT INTO 'albumsrecordingsmap' VALUES (10636, 16, 1100, 10044);
INSERT INTO 'albumsrecordingsmap' VALUES (10637, 17, 1100, 10045);
INSERT INTO 'albumsrecordingsmap' VALUES (10638, 18, 1100, 10046);
INSERT INTO 'albumsrecordingsmap' VALUES (9881, 10, 1050, 9311);
INSERT INTO 'albumsrecordingsmap' VALUES (9882, 11, 1050, 9312);
INSERT INTO 'albumsrecordingsmap' VALUES (9883, 12, 1050, 9313);
INSERT INTO 'albumsrecordingsmap' VALUES (9884, 13, 1050, 9314);
INSERT INTO 'albumsrecordingsmap' VALUES (9885, 14, 1050, 9315);
INSERT INTO 'albumsrecordingsmap' VALUES (9886, 15, 1050, 9316);
INSERT INTO 'albumsrecordingsmap' VALUES (10545, 1, 1095, 9951);
INSERT INTO 'albumsrecordingsmap' VALUES (10546, 2, 1095, 9952);
INSERT INTO 'albumsrecordingsmap' VALUES (10547, 3, 1095, 9953);
INSERT INTO 'albumsrecordingsmap' VALUES (10548, 4, 1095, 9954);
INSERT INTO 'albumsrecordingsmap' VALUES (10549, 5, 1095, 9955);
INSERT INTO 'albumsrecordingsmap' VALUES (10550, 6, 1095, 9956);
INSERT INTO 'albumsrecordingsmap' VALUES (10551, 7, 1095, 9957);
INSERT INTO 'albumsrecordingsmap' VALUES (10552, 8, 1095, 9958);
INSERT INTO 'albumsrecordingsmap' VALUES (10553, 9, 1095, 9959);
INSERT INTO 'albumsrecordingsmap' VALUES (10554, 10, 1095, 9960);
INSERT INTO 'albumsrecordingsmap' VALUES (10555, 11, 1095, 9961);
INSERT INTO 'albumsrecordingsmap' VALUES (10556, 12, 1095, 9962);
INSERT INTO 'albumsrecordingsmap' VALUES (10557, 13, 1095, 9963);
INSERT INTO 'albumsrecordingsmap' VALUES (10558, 14, 1095, 9964);
INSERT INTO 'albumsrecordingsmap' VALUES (10559, 15, 1095, 9965);
INSERT INTO 'albumsrecordingsmap' VALUES (10668, 15, 1102, 10076);
INSERT INTO 'albumsrecordingsmap' VALUES (10669, 16, 1102, 10077);
INSERT INTO 'albumsrecordingsmap' VALUES (10670, 1, 1103, 10078);
INSERT INTO 'albumsrecordingsmap' VALUES (10671, 2, 1103, 10079);
INSERT INTO 'albumsrecordingsmap' VALUES (10672, 3, 1103, 10080);
INSERT INTO 'albumsrecordingsmap' VALUES (10639, 1, 1101, 10047);
INSERT INTO 'albumsrecordingsmap' VALUES (10640, 2, 1101, 10048);
INSERT INTO 'albumsrecordingsmap' VALUES (10654, 1, 1102, 10062);
INSERT INTO 'albumsrecordingsmap' VALUES (10655, 2, 1102, 10063);
INSERT INTO 'albumsrecordingsmap' VALUES (10656, 3, 1102, 10064);
INSERT INTO 'albumsrecordingsmap' VALUES (10657, 4, 1102, 10065);
INSERT INTO 'albumsrecordingsmap' VALUES (10658, 5, 1102, 10066);
INSERT INTO 'albumsrecordingsmap' VALUES (10659, 6, 1102, 10067);
INSERT INTO 'albumsrecordingsmap' VALUES (10660, 7, 1102, 10068);
INSERT INTO 'albumsrecordingsmap' VALUES (10661, 8, 1102, 10069);
INSERT INTO 'albumsrecordingsmap' VALUES (10662, 9, 1102, 10070);
INSERT INTO 'albumsrecordingsmap' VALUES (10663, 10, 1102, 10071);
INSERT INTO 'albumsrecordingsmap' VALUES (10664, 11, 1102, 10072);
INSERT INTO 'albumsrecordingsmap' VALUES (10673, 4, 1103, 10081);
INSERT INTO 'albumsrecordingsmap' VALUES (10674, 5, 1103, 10082);
INSERT INTO 'albumsrecordingsmap' VALUES (10675, 6, 1103, 10083);
INSERT INTO 'albumsrecordingsmap' VALUES (10676, 7, 1103, 10084);
INSERT INTO 'albumsrecordingsmap' VALUES (10677, 8, 1103, 10085);
INSERT INTO 'albumsrecordingsmap' VALUES (10678, 9, 1103, 10086);
INSERT INTO 'albumsrecordingsmap' VALUES (10679, 10, 1103, 10087);
INSERT INTO 'albumsrecordingsmap' VALUES (10680, 11, 1103, 10088);
INSERT INTO 'albumsrecordingsmap' VALUES (10681, 12, 1103, 10089);
INSERT INTO 'albumsrecordingsmap' VALUES (10682, 13, 1103, 10090);
INSERT INTO 'albumsrecordingsmap' VALUES (10683, 14, 1103, 10091);
INSERT INTO 'albumsrecordingsmap' VALUES (10684, 15, 1103, 10092);
INSERT INTO 'albumsrecordingsmap' VALUES (6368, 2, 462, 5858);
INSERT INTO 'albumsrecordingsmap' VALUES (6369, 3, 462, 5859);
INSERT INTO 'albumsrecordingsmap' VALUES (6370, 4, 462, 5860);
INSERT INTO 'albumsrecordingsmap' VALUES (6371, 5, 462, 5861);
INSERT INTO 'albumsrecordingsmap' VALUES (6372, 6, 462, 5862);
INSERT INTO 'albumsrecordingsmap' VALUES (6373, 7, 462, 5863);
INSERT INTO 'albumsrecordingsmap' VALUES (6374, 8, 462, 5864);
INSERT INTO 'albumsrecordingsmap' VALUES (6375, 9, 462, 5865);
INSERT INTO 'albumsrecordingsmap' VALUES (6376, 10, 462, 5866);
INSERT INTO 'albumsrecordingsmap' VALUES (6377, 11, 462, 5867);
INSERT INTO 'albumsrecordingsmap' VALUES (6378, 12, 462, 5868);
INSERT INTO 'albumsrecordingsmap' VALUES (6379, 13, 462, 5869);
INSERT INTO 'albumsrecordingsmap' VALUES (6380, 14, 462, 5870);
INSERT INTO 'albumsrecordingsmap' VALUES (6381, 15, 462, 5871);
INSERT INTO 'albumsrecordingsmap' VALUES (10686, 1, 1105, 10094);
INSERT INTO 'albumsrecordingsmap' VALUES (10687, 2, 1105, 10095);
INSERT INTO 'albumsrecordingsmap' VALUES (10688, 3, 1105, 10096);
INSERT INTO 'albumsrecordingsmap' VALUES (10826, 1, 1114, 10232);
INSERT INTO 'albumsrecordingsmap' VALUES (10689, 4, 1105, 10097);
INSERT INTO 'albumsrecordingsmap' VALUES (10690, 5, 1105, 10098);
INSERT INTO 'albumsrecordingsmap' VALUES (10691, 6, 1105, 10099);
INSERT INTO 'albumsrecordingsmap' VALUES (10832, 7, 1114, 10238);
INSERT INTO 'albumsrecordingsmap' VALUES (10741, 1, 1108, 10147);
INSERT INTO 'albumsrecordingsmap' VALUES (10742, 3, 1108, 10149);
INSERT INTO 'albumsrecordingsmap' VALUES (10743, 2, 1108, 10148);
INSERT INTO 'albumsrecordingsmap' VALUES (10833, 8, 1114, 10239);
INSERT INTO 'albumsrecordingsmap' VALUES (10744, 4, 1108, 10150);
INSERT INTO 'albumsrecordingsmap' VALUES (10745, 5, 1108, 10151);
INSERT INTO 'albumsrecordingsmap' VALUES (10746, 6, 1108, 10152);
INSERT INTO 'albumsrecordingsmap' VALUES (10747, 7, 1108, 10153);
INSERT INTO 'albumsrecordingsmap' VALUES (10834, 9, 1114, 10240);
INSERT INTO 'albumsrecordingsmap' VALUES (10748, 8, 1108, 10154);
INSERT INTO 'albumsrecordingsmap' VALUES (10749, 9, 1108, 10155);
INSERT INTO 'albumsrecordingsmap' VALUES (10750, 10, 1108, 10156);
INSERT INTO 'albumsrecordingsmap' VALUES (10751, 11, 1108, 10157);
INSERT INTO 'albumsrecordingsmap' VALUES (10752, 12, 1108, 10158);
INSERT INTO 'albumsrecordingsmap' VALUES (6936, 1, 499, 6366);
INSERT INTO 'albumsrecordingsmap' VALUES (10835, 10, 1114, 10241);
INSERT INTO 'albumsrecordingsmap' VALUES (10836, 11, 1114, 10242);
INSERT INTO 'albumsrecordingsmap' VALUES (10837, 12, 1114, 10243);
INSERT INTO 'albumsrecordingsmap' VALUES (10838, 13, 1114, 10244);
INSERT INTO 'albumsrecordingsmap' VALUES (10839, 14, 1114, 10245);
INSERT INTO 'albumsrecordingsmap' VALUES (10840, 15, 1114, 10246);
INSERT INTO 'albumsrecordingsmap' VALUES (10872, 1, 1119, 10278);
INSERT INTO 'albumsrecordingsmap' VALUES (10873, 2, 1119, 10279);
INSERT INTO 'albumsrecordingsmap' VALUES (10874, 3, 1119, 10280);
INSERT INTO 'albumsrecordingsmap' VALUES (10875, 4, 1119, 10281);
INSERT INTO 'albumsrecordingsmap' VALUES (10729, 1, 1107, 10135);
INSERT INTO 'albumsrecordingsmap' VALUES (10730, 2, 1107, 10136);
INSERT INTO 'albumsrecordingsmap' VALUES (10731, 3, 1107, 10137);
INSERT INTO 'albumsrecordingsmap' VALUES (10732, 4, 1107, 10138);
INSERT INTO 'albumsrecordingsmap' VALUES (10733, 5, 1107, 10139);
INSERT INTO 'albumsrecordingsmap' VALUES (10734, 6, 1107, 10140);
INSERT INTO 'albumsrecordingsmap' VALUES (10735, 7, 1107, 10141);
INSERT INTO 'albumsrecordingsmap' VALUES (10736, 8, 1107, 10142);
INSERT INTO 'albumsrecordingsmap' VALUES (10737, 9, 1107, 10143);
INSERT INTO 'albumsrecordingsmap' VALUES (10738, 10, 1107, 10144);
INSERT INTO 'albumsrecordingsmap' VALUES (10739, 11, 1107, 10145);
INSERT INTO 'albumsrecordingsmap' VALUES (10702, 1, 1086, 10110);
INSERT INTO 'albumsrecordingsmap' VALUES (10703, 2, 1086, 10111);
INSERT INTO 'albumsrecordingsmap' VALUES (10704, 3, 1086, 10112);
INSERT INTO 'albumsrecordingsmap' VALUES (10705, 4, 1086, 10113);
INSERT INTO 'albumsrecordingsmap' VALUES (10706, 5, 1086, 10114);
INSERT INTO 'albumsrecordingsmap' VALUES (10707, 6, 1086, 10115);
INSERT INTO 'albumsrecordingsmap' VALUES (10708, 7, 1086, 10116);
INSERT INTO 'albumsrecordingsmap' VALUES (10709, 8, 1086, 10117);
INSERT INTO 'albumsrecordingsmap' VALUES (10710, 9, 1086, 10118);
INSERT INTO 'albumsrecordingsmap' VALUES (10711, 10, 1086, 10119);
INSERT INTO 'albumsrecordingsmap' VALUES (10712, 11, 1086, 10120);
INSERT INTO 'albumsrecordingsmap' VALUES (10713, 12, 1086, 10121);
INSERT INTO 'albumsrecordingsmap' VALUES (7518, 1, 908, 6988);
INSERT INTO 'albumsrecordingsmap' VALUES (7519, 2, 908, 6989);
INSERT INTO 'albumsrecordingsmap' VALUES (7520, 3, 908, 6990);
INSERT INTO 'albumsrecordingsmap' VALUES (7521, 4, 908, 6991);
INSERT INTO 'albumsrecordingsmap' VALUES (7522, 5, 908, 6992);
INSERT INTO 'albumsrecordingsmap' VALUES (7523, 6, 908, 6993);
INSERT INTO 'albumsrecordingsmap' VALUES (7524, 7, 908, 6994);
INSERT INTO 'albumsrecordingsmap' VALUES (7525, 8, 908, 6995);
INSERT INTO 'albumsrecordingsmap' VALUES (7526, 9, 908, 6996);
INSERT INTO 'albumsrecordingsmap' VALUES (7527, 10, 908, 6997);
INSERT INTO 'albumsrecordingsmap' VALUES (7528, 11, 908, 6998);
INSERT INTO 'albumsrecordingsmap' VALUES (7529, 12, 908, 6999);
INSERT INTO 'albumsrecordingsmap' VALUES (7530, 13, 908, 7000);
INSERT INTO 'albumsrecordingsmap' VALUES (7531, 14, 908, 7001);
INSERT INTO 'albumsrecordingsmap' VALUES (7532, 15, 908, 7002);
INSERT INTO 'albumsrecordingsmap' VALUES (10692, 7, 1105, 10100);
INSERT INTO 'albumsrecordingsmap' VALUES (10693, 8, 1105, 10101);
INSERT INTO 'albumsrecordingsmap' VALUES (10694, 9, 1105, 10102);
INSERT INTO 'albumsrecordingsmap' VALUES (10695, 10, 1105, 10103);
INSERT INTO 'albumsrecordingsmap' VALUES (10696, 11, 1105, 10104);
INSERT INTO 'albumsrecordingsmap' VALUES (10697, 12, 1105, 10105);
INSERT INTO 'albumsrecordingsmap' VALUES (10698, 13, 1105, 10106);
INSERT INTO 'albumsrecordingsmap' VALUES (10699, 14, 1105, 10107);
INSERT INTO 'albumsrecordingsmap' VALUES (10700, 15, 1105, 10108);
INSERT INTO 'albumsrecordingsmap' VALUES (10701, 16, 1105, 10109);
INSERT INTO 'albumsrecordingsmap' VALUES (5677, 1, 403, 236);
INSERT INTO 'albumsrecordingsmap' VALUES (5678, 2, 403, 1307);
INSERT INTO 'albumsrecordingsmap' VALUES (5679, 3, 403, 62);
INSERT INTO 'albumsrecordingsmap' VALUES (5680, 4, 403, 1308);
INSERT INTO 'albumsrecordingsmap' VALUES (5681, 6, 403, 1309);
INSERT INTO 'albumsrecordingsmap' VALUES (5682, 7, 403, 1310);
INSERT INTO 'albumsrecordingsmap' VALUES (5683, 8, 403, 1311);
INSERT INTO 'albumsrecordingsmap' VALUES (5684, 11, 403, 233);
INSERT INTO 'albumsrecordingsmap' VALUES (5685, 12, 403, 1313);
INSERT INTO 'albumsrecordingsmap' VALUES (5686, 5, 403, 346);
INSERT INTO 'albumsrecordingsmap' VALUES (5687, 9, 403, 1312);
INSERT INTO 'albumsrecordingsmap' VALUES (5688, 10, 403, 347);
INSERT INTO 'albumsrecordingsmap' VALUES (10740, 12, 1107, 10146);
INSERT INTO 'albumsrecordingsmap' VALUES (6937, 2, 499, 6367);
INSERT INTO 'albumsrecordingsmap' VALUES (6938, 3, 499, 6368);
INSERT INTO 'albumsrecordingsmap' VALUES (6983, 5, 499, 6420);
INSERT INTO 'albumsrecordingsmap' VALUES (6984, 9, 499, 6421);
INSERT INTO 'albumsrecordingsmap' VALUES (10869, 11, 1118, 10275);
INSERT INTO 'albumsrecordingsmap' VALUES (10870, 12, 1118, 10276);
INSERT INTO 'albumsrecordingsmap' VALUES (6985, 13, 499, 6422);
INSERT INTO 'albumsrecordingsmap' VALUES (6986, 14, 499, 6423);
INSERT INTO 'albumsrecordingsmap' VALUES (6987, 4, 499, 6419);
INSERT INTO 'albumsrecordingsmap' VALUES (6988, 6, 499, 6369);
INSERT INTO 'albumsrecordingsmap' VALUES (6989, 7, 499, 6370);
INSERT INTO 'albumsrecordingsmap' VALUES (6990, 8, 499, 6371);
INSERT INTO 'albumsrecordingsmap' VALUES (6991, 10, 499, 6372);
INSERT INTO 'albumsrecordingsmap' VALUES (6992, 11, 499, 6373);
INSERT INTO 'albumsrecordingsmap' VALUES (6993, 12, 499, 6374);
INSERT INTO 'albumsrecordingsmap' VALUES (3072, 2, 833, 3083);
INSERT INTO 'albumsrecordingsmap' VALUES (3073, 4, 833, 3085);
INSERT INTO 'albumsrecordingsmap' VALUES (3074, 5, 833, 3086);
INSERT INTO 'albumsrecordingsmap' VALUES (3075, 7, 833, 3088);
INSERT INTO 'albumsrecordingsmap' VALUES (3076, 8, 833, 3089);
INSERT INTO 'albumsrecordingsmap' VALUES (3866, 6, 833, 3798);
INSERT INTO 'albumsrecordingsmap' VALUES (3867, 3, 833, 3795);
INSERT INTO 'albumsrecordingsmap' VALUES (6006, 7, 436, 5561);
INSERT INTO 'albumsrecordingsmap' VALUES (6007, 8, 436, 5562);
INSERT INTO 'albumsrecordingsmap' VALUES (6008, 9, 436, 5563);
INSERT INTO 'albumsrecordingsmap' VALUES (6009, 10, 436, 5564);
INSERT INTO 'albumsrecordingsmap' VALUES (6010, 11, 436, 5565);
INSERT INTO 'albumsrecordingsmap' VALUES (6011, 12, 436, 5566);
INSERT INTO 'albumsrecordingsmap' VALUES (10876, 5, 1119, 10282);
INSERT INTO 'albumsrecordingsmap' VALUES (10877, 6, 1119, 10283);
INSERT INTO 'albumsrecordingsmap' VALUES (10714, 1, 1106, 10122);
INSERT INTO 'albumsrecordingsmap' VALUES (10715, 2, 1106, 10123);
INSERT INTO 'albumsrecordingsmap' VALUES (10716, 3, 1106, 10124);
INSERT INTO 'albumsrecordingsmap' VALUES (10717, 4, 1106, 10125);
INSERT INTO 'albumsrecordingsmap' VALUES (10718, 13, 1106, 10134);
INSERT INTO 'albumsrecordingsmap' VALUES (10720, 5, 1106, 10126);
INSERT INTO 'albumsrecordingsmap' VALUES (10721, 6, 1106, 10127);
INSERT INTO 'albumsrecordingsmap' VALUES (10722, 7, 1106, 10128);
INSERT INTO 'albumsrecordingsmap' VALUES (10723, 8, 1106, 10129);
INSERT INTO 'albumsrecordingsmap' VALUES (10724, 9, 1106, 10130);
INSERT INTO 'albumsrecordingsmap' VALUES (10725, 10, 1106, 10131);
INSERT INTO 'albumsrecordingsmap' VALUES (10726, 11, 1106, 10132);
INSERT INTO 'albumsrecordingsmap' VALUES (10727, 12, 1106, 10133);
INSERT INTO 'albumsrecordingsmap' VALUES (10887, 1, 1120, 10293);
INSERT INTO 'albumsrecordingsmap' VALUES (10878, 7, 1119, 10284);
INSERT INTO 'albumsrecordingsmap' VALUES (10879, 8, 1119, 10285);
INSERT INTO 'albumsrecordingsmap' VALUES (10880, 9, 1119, 10286);
INSERT INTO 'albumsrecordingsmap' VALUES (10881, 10, 1119, 10287);
INSERT INTO 'albumsrecordingsmap' VALUES (10882, 11, 1119, 10288);
INSERT INTO 'albumsrecordingsmap' VALUES (10883, 12, 1119, 10289);
INSERT INTO 'albumsrecordingsmap' VALUES (10884, 13, 1119, 10290);
INSERT INTO 'albumsrecordingsmap' VALUES (10885, 14, 1119, 10291);
INSERT INTO 'albumsrecordingsmap' VALUES (10886, 15, 1119, 10292);
INSERT INTO 'albumsrecordingsmap' VALUES (10888, 2, 1120, 10294);
INSERT INTO 'albumsrecordingsmap' VALUES (10889, 3, 1120, 10295);
INSERT INTO 'albumsrecordingsmap' VALUES (10890, 4, 1120, 10296);
INSERT INTO 'albumsrecordingsmap' VALUES (10891, 5, 1120, 10297);
INSERT INTO 'albumsrecordingsmap' VALUES (10892, 6, 1120, 10298);
INSERT INTO 'albumsrecordingsmap' VALUES (10893, 7, 1120, 10299);
INSERT INTO 'albumsrecordingsmap' VALUES (10894, 8, 1120, 10300);
INSERT INTO 'albumsrecordingsmap' VALUES (10895, 9, 1120, 10301);
INSERT INTO 'albumsrecordingsmap' VALUES (10896, 10, 1120, 10302);
INSERT INTO 'albumsrecordingsmap' VALUES (10897, 11, 1120, 10303);
INSERT INTO 'albumsrecordingsmap' VALUES (1384, 1, 118, 1359);
INSERT INTO 'albumsrecordingsmap' VALUES (1385, 2, 118, 1360);
INSERT INTO 'albumsrecordingsmap' VALUES (1386, 3, 118, 184);
INSERT INTO 'albumsrecordingsmap' VALUES (1387, 4, 118, 110);
INSERT INTO 'albumsrecordingsmap' VALUES (1388, 5, 118, 139);
INSERT INTO 'albumsrecordingsmap' VALUES (1389, 6, 118, 1361);
INSERT INTO 'albumsrecordingsmap' VALUES (1390, 7, 118, 1362);
INSERT INTO 'albumsrecordingsmap' VALUES (1391, 8, 118, 207);
INSERT INTO 'albumsrecordingsmap' VALUES (6024, 1, 438, 5567);
INSERT INTO 'albumsrecordingsmap' VALUES (6025, 2, 438, 5568);
INSERT INTO 'albumsrecordingsmap' VALUES (6026, 3, 438, 5569);
INSERT INTO 'albumsrecordingsmap' VALUES (6027, 4, 438, 5570);
INSERT INTO 'albumsrecordingsmap' VALUES (6028, 5, 438, 5571);
INSERT INTO 'albumsrecordingsmap' VALUES (6029, 6, 438, 5572);
INSERT INTO 'albumsrecordingsmap' VALUES (6030, 7, 438, 5573);
INSERT INTO 'albumsrecordingsmap' VALUES (6031, 8, 438, 5574);
INSERT INTO 'albumsrecordingsmap' VALUES (6032, 9, 438, 5575);
INSERT INTO 'albumsrecordingsmap' VALUES (6033, 10, 438, 5576);
INSERT INTO 'albumsrecordingsmap' VALUES (6034, 11, 438, 5577);
INSERT INTO 'albumsrecordingsmap' VALUES (6035, 12, 438, 5578);
INSERT INTO 'albumsrecordingsmap' VALUES (6036, 13, 438, 5579);
INSERT INTO 'albumsrecordingsmap' VALUES (6037, 14, 438, 5580);
INSERT INTO 'albumsrecordingsmap' VALUES (10414, 1, 1084, 9830);
INSERT INTO 'albumsrecordingsmap' VALUES (10415, 2, 1084, 9831);
INSERT INTO 'albumsrecordingsmap' VALUES (10416, 3, 1084, 9832);
INSERT INTO 'albumsrecordingsmap' VALUES (10417, 4, 1084, 9833);
INSERT INTO 'albumsrecordingsmap' VALUES (10418, 5, 1084, 9834);
INSERT INTO 'albumsrecordingsmap' VALUES (10419, 6, 1084, 9835);
INSERT INTO 'albumsrecordingsmap' VALUES (10420, 7, 1084, 9836);
INSERT INTO 'albumsrecordingsmap' VALUES (10421, 8, 1084, 9837);
INSERT INTO 'albumsrecordingsmap' VALUES (10422, 9, 1084, 9838);
INSERT INTO 'albumsrecordingsmap' VALUES (10423, 10, 1084, 9839);
INSERT INTO 'albumsrecordingsmap' VALUES (10424, 11, 1084, 9840);
INSERT INTO 'albumsrecordingsmap' VALUES (10425, 12, 1084, 9841);
INSERT INTO 'albumsrecordingsmap' VALUES (10426, 13, 1084, 9842);
INSERT INTO 'albumsrecordingsmap' VALUES (10427, 14, 1084, 9843);
INSERT INTO 'albumsrecordingsmap' VALUES (10428, 15, 1084, 9844);
INSERT INTO 'albumsrecordingsmap' VALUES (10429, 16, 1084, 9845);
INSERT INTO 'albumsrecordingsmap' VALUES (10430, 17, 1084, 9846);
INSERT INTO 'albumsrecordingsmap' VALUES (10908, 1, 1122, 10311);
INSERT INTO 'albumsrecordingsmap' VALUES (10909, 2, 1122, 10312);
INSERT INTO 'albumsrecordingsmap' VALUES (10910, 3, 1122, 10313);
INSERT INTO 'albumsrecordingsmap' VALUES (10911, 4, 1122, 10314);
INSERT INTO 'albumsrecordingsmap' VALUES (10912, 5, 1122, 10315);
INSERT INTO 'albumsrecordingsmap' VALUES (10913, 6, 1122, 10327);
INSERT INTO 'albumsrecordingsmap' VALUES (10914, 7, 1122, 10317);
INSERT INTO 'albumsrecordingsmap' VALUES (10915, 8, 1122, 10318);
INSERT INTO 'albumsrecordingsmap' VALUES (10916, 9, 1122, 10319);
INSERT INTO 'albumsrecordingsmap' VALUES (10917, 10, 1122, 10320);
INSERT INTO 'albumsrecordingsmap' VALUES (10918, 11, 1122, 10321);
INSERT INTO 'albumsrecordingsmap' VALUES (10919, 12, 1122, 10328);
INSERT INTO 'albumsrecordingsmap' VALUES (10920, 13, 1122, 10323);
INSERT INTO 'albumsrecordingsmap' VALUES (10921, 14, 1122, 10324);
INSERT INTO 'albumsrecordingsmap' VALUES (10922, 15, 1122, 10325);
INSERT INTO 'albumsrecordingsmap' VALUES (10923, 16, 1122, 10326);
INSERT INTO 'albumsrecordingsmap' VALUES (10924, 17, 1122, 10316);
INSERT INTO 'albumsrecordingsmap' VALUES (10925, 18, 1122, 10322);
INSERT INTO 'albumsrecordingsmap' VALUES (2661, 1, 186, 2664);
INSERT INTO 'albumsrecordingsmap' VALUES (2662, 2, 186, 2665);
INSERT INTO 'albumsrecordingsmap' VALUES (2663, 3, 186, 2666);
INSERT INTO 'albumsrecordingsmap' VALUES (2664, 4, 186, 2667);
INSERT INTO 'albumsrecordingsmap' VALUES (2665, 5, 186, 2668);
INSERT INTO 'albumsrecordingsmap' VALUES (2666, 6, 186, 2669);
INSERT INTO 'albumsrecordingsmap' VALUES (2667, 7, 186, 2670);
INSERT INTO 'albumsrecordingsmap' VALUES (2668, 8, 186, 2671);
INSERT INTO 'albumsrecordingsmap' VALUES (2669, 9, 186, 2672);
INSERT INTO 'albumsrecordingsmap' VALUES (2670, 10, 186, 2673);
INSERT INTO 'albumsrecordingsmap' VALUES (2671, 11, 186, 2674);
INSERT INTO 'albumsrecordingsmap' VALUES (2672, 12, 186, 2675);
INSERT INTO 'albumsrecordingsmap' VALUES (2673, 13, 186, 2676);
INSERT INTO 'albumsrecordingsmap' VALUES (2674, 14, 186, 2677);
INSERT INTO 'albumsrecordingsmap' VALUES (2675, 15, 186, 2678);
INSERT INTO 'albumsrecordingsmap' VALUES (2676, 16, 186, 2679);
INSERT INTO 'albumsrecordingsmap' VALUES (2677, 17, 186, 2680);
INSERT INTO 'albumsrecordingsmap' VALUES (10926, 1, 1123, 10329);
INSERT INTO 'albumsrecordingsmap' VALUES (10927, 2, 1123, 10330);
INSERT INTO 'albumsrecordingsmap' VALUES (10928, 3, 1123, 10331);
INSERT INTO 'albumsrecordingsmap' VALUES (10929, 4, 1123, 10332);
INSERT INTO 'albumsrecordingsmap' VALUES (10930, 5, 1123, 10333);
INSERT INTO 'albumsrecordingsmap' VALUES (10931, 6, 1123, 10334);
INSERT INTO 'albumsrecordingsmap' VALUES (10932, 7, 1123, 10335);
INSERT INTO 'albumsrecordingsmap' VALUES (10933, 9, 1123, 10337);
INSERT INTO 'albumsrecordingsmap' VALUES (10934, 10, 1123, 10338);
INSERT INTO 'albumsrecordingsmap' VALUES (11022, 9, 1129, 10425);
INSERT INTO 'albumsrecordingsmap' VALUES (11023, 10, 1129, 10426);
INSERT INTO 'albumsrecordingsmap' VALUES (11024, 11, 1129, 10427);
INSERT INTO 'albumsrecordingsmap' VALUES (11025, 12, 1129, 10428);
INSERT INTO 'albumsrecordingsmap' VALUES (11026, 13, 1129, 10429);
INSERT INTO 'albumsrecordingsmap' VALUES (11027, 14, 1129, 10430);
INSERT INTO 'albumsrecordingsmap' VALUES (10935, 8, 1123, 10336);
INSERT INTO 'albumsrecordingsmap' VALUES (10936, 11, 1123, 10339);
INSERT INTO 'albumsrecordingsmap' VALUES (10937, 12, 1123, 10340);
INSERT INTO 'albumsrecordingsmap' VALUES (10938, 14, 1123, 10342);
INSERT INTO 'albumsrecordingsmap' VALUES (10939, 15, 1123, 10343);
INSERT INTO 'albumsrecordingsmap' VALUES (10940, 16, 1123, 10344);
INSERT INTO 'albumsrecordingsmap' VALUES (10941, 17, 1123, 10345);
INSERT INTO 'albumsrecordingsmap' VALUES (10942, 18, 1123, 10346);
INSERT INTO 'albumsrecordingsmap' VALUES (10943, 19, 1123, 10347);
INSERT INTO 'albumsrecordingsmap' VALUES (10944, 20, 1123, 10348);
INSERT INTO 'albumsrecordingsmap' VALUES (10945, 21, 1123, 10349);
INSERT INTO 'albumsrecordingsmap' VALUES (10946, 13, 1123, 10341);
INSERT INTO 'albumsrecordingsmap' VALUES (11028, 15, 1129, 10431);
INSERT INTO 'albumsrecordingsmap' VALUES (11003, 1, 1128, 10406);
INSERT INTO 'albumsrecordingsmap' VALUES (11004, 2, 1128, 10407);
INSERT INTO 'albumsrecordingsmap' VALUES (11005, 3, 1128, 10408);
INSERT INTO 'albumsrecordingsmap' VALUES (11006, 4, 1128, 10409);
INSERT INTO 'albumsrecordingsmap' VALUES (11007, 5, 1128, 10410);
INSERT INTO 'albumsrecordingsmap' VALUES (11008, 6, 1128, 10411);
INSERT INTO 'albumsrecordingsmap' VALUES (11009, 7, 1128, 10412);
INSERT INTO 'albumsrecordingsmap' VALUES (11010, 8, 1128, 10413);
INSERT INTO 'albumsrecordingsmap' VALUES (10947, 1, 1124, 10350);
INSERT INTO 'albumsrecordingsmap' VALUES (10948, 2, 1124, 10351);
INSERT INTO 'albumsrecordingsmap' VALUES (10949, 3, 1124, 10352);
INSERT INTO 'albumsrecordingsmap' VALUES (10950, 4, 1124, 10353);
INSERT INTO 'albumsrecordingsmap' VALUES (10951, 5, 1124, 10354);
INSERT INTO 'albumsrecordingsmap' VALUES (10952, 6, 1124, 10355);
INSERT INTO 'albumsrecordingsmap' VALUES (10953, 7, 1124, 10356);
INSERT INTO 'albumsrecordingsmap' VALUES (10954, 8, 1124, 10357);
INSERT INTO 'albumsrecordingsmap' VALUES (10955, 9, 1124, 10358);
INSERT INTO 'albumsrecordingsmap' VALUES (10956, 10, 1124, 10359);
INSERT INTO 'albumsrecordingsmap' VALUES (10957, 11, 1124, 10360);
INSERT INTO 'albumsrecordingsmap' VALUES (10958, 13, 1124, 10362);
INSERT INTO 'albumsrecordingsmap' VALUES (10959, 14, 1124, 10363);
INSERT INTO 'albumsrecordingsmap' VALUES (10960, 15, 1124, 10364);
INSERT INTO 'albumsrecordingsmap' VALUES (10961, 16, 1124, 10365);
INSERT INTO 'albumsrecordingsmap' VALUES (10962, 17, 1124, 10366);
INSERT INTO 'albumsrecordingsmap' VALUES (10963, 12, 1124, 10361);
INSERT INTO 'albumsrecordingsmap' VALUES (10981, 1, 1126, 10384);
INSERT INTO 'albumsrecordingsmap' VALUES (10982, 2, 1126, 10385);
INSERT INTO 'albumsrecordingsmap' VALUES (10983, 3, 1126, 10386);
INSERT INTO 'albumsrecordingsmap' VALUES (10984, 4, 1126, 10387);
INSERT INTO 'albumsrecordingsmap' VALUES (10985, 5, 1126, 10388);
INSERT INTO 'albumsrecordingsmap' VALUES (10986, 6, 1126, 10389);
INSERT INTO 'albumsrecordingsmap' VALUES (10987, 7, 1126, 10390);
INSERT INTO 'albumsrecordingsmap' VALUES (10988, 8, 1126, 10391);
INSERT INTO 'albumsrecordingsmap' VALUES (10989, 9, 1126, 10392);
INSERT INTO 'albumsrecordingsmap' VALUES (10990, 10, 1126, 10393);
INSERT INTO 'albumsrecordingsmap' VALUES (10991, 11, 1126, 10394);
INSERT INTO 'albumsrecordingsmap' VALUES (10992, 12, 1126, 10395);
INSERT INTO 'albumsrecordingsmap' VALUES (10993, 13, 1126, 10396);
INSERT INTO 'albumsrecordingsmap' VALUES (10994, 14, 1126, 10397);
INSERT INTO 'albumsrecordingsmap' VALUES (2507, 1, 233, 2514);
INSERT INTO 'albumsrecordingsmap' VALUES (2508, 2, 233, 2515);
INSERT INTO 'albumsrecordingsmap' VALUES (2509, 3, 233, 2516);
INSERT INTO 'albumsrecordingsmap' VALUES (2510, 4, 233, 2517);
INSERT INTO 'albumsrecordingsmap' VALUES (2511, 5, 233, 2518);
INSERT INTO 'albumsrecordingsmap' VALUES (2512, 6, 233, 2519);
INSERT INTO 'albumsrecordingsmap' VALUES (2513, 7, 233, 2520);
INSERT INTO 'albumsrecordingsmap' VALUES (2514, 8, 233, 2521);
INSERT INTO 'albumsrecordingsmap' VALUES (11011, 9, 1128, 10414);
INSERT INTO 'albumsrecordingsmap' VALUES (11012, 10, 1128, 10415);
INSERT INTO 'albumsrecordingsmap' VALUES (11013, 11, 1128, 10416);
INSERT INTO 'albumsrecordingsmap' VALUES (2515, 9, 233, 2522);
INSERT INTO 'albumsrecordingsmap' VALUES (3676, 10, 233, 3622);
INSERT INTO 'albumsrecordingsmap' VALUES (3372, 1, 366, 3319);
INSERT INTO 'albumsrecordingsmap' VALUES (3373, 2, 366, 3320);
INSERT INTO 'albumsrecordingsmap' VALUES (3374, 3, 366, 3321);
INSERT INTO 'albumsrecordingsmap' VALUES (3375, 4, 366, 3322);
INSERT INTO 'albumsrecordingsmap' VALUES (3376, 5, 366, 3323);
INSERT INTO 'albumsrecordingsmap' VALUES (3377, 6, 366, 3324);
INSERT INTO 'albumsrecordingsmap' VALUES (3378, 7, 366, 3325);
INSERT INTO 'albumsrecordingsmap' VALUES (3379, 8, 366, 3326);
INSERT INTO 'albumsrecordingsmap' VALUES (3380, 9, 366, 3327);
INSERT INTO 'albumsrecordingsmap' VALUES (3381, 10, 366, 3328);
INSERT INTO 'albumsrecordingsmap' VALUES (3382, 11, 366, 3329);
INSERT INTO 'albumsrecordingsmap' VALUES (3383, 12, 366, 3330);
INSERT INTO 'albumsrecordingsmap' VALUES (3384, 13, 366, 3331);
INSERT INTO 'albumsrecordingsmap' VALUES (11029, 1, 1130, 10432);
INSERT INTO 'albumsrecordingsmap' VALUES (11030, 7, 1130, 10433);
INSERT INTO 'albumsrecordingsmap' VALUES (11031, 8, 1130, 10434);
INSERT INTO 'albumsrecordingsmap' VALUES (10995, 1, 1127, 10398);
INSERT INTO 'albumsrecordingsmap' VALUES (10996, 2, 1127, 10399);
INSERT INTO 'albumsrecordingsmap' VALUES (10997, 3, 1127, 10400);
INSERT INTO 'albumsrecordingsmap' VALUES (10998, 4, 1127, 10401);
INSERT INTO 'albumsrecordingsmap' VALUES (10999, 5, 1127, 10402);
INSERT INTO 'albumsrecordingsmap' VALUES (11000, 6, 1127, 10403);
INSERT INTO 'albumsrecordingsmap' VALUES (11001, 7, 1127, 10404);
INSERT INTO 'albumsrecordingsmap' VALUES (11002, 8, 1127, 10405);
INSERT INTO 'albumsrecordingsmap' VALUES (11032, 13, 1130, 10435);
INSERT INTO 'albumsrecordingsmap' VALUES (3020, 1, 281, 3019);
INSERT INTO 'albumsrecordingsmap' VALUES (3021, 2, 281, 3020);
INSERT INTO 'albumsrecordingsmap' VALUES (3022, 3, 281, 3021);
INSERT INTO 'albumsrecordingsmap' VALUES (3023, 4, 281, 3022);
INSERT INTO 'albumsrecordingsmap' VALUES (3024, 5, 281, 3023);
INSERT INTO 'albumsrecordingsmap' VALUES (3025, 6, 281, 3024);
INSERT INTO 'albumsrecordingsmap' VALUES (3026, 7, 281, 3025);
INSERT INTO 'albumsrecordingsmap' VALUES (3027, 8, 281, 3026);
INSERT INTO 'albumsrecordingsmap' VALUES (11014, 1, 1129, 10417);
INSERT INTO 'albumsrecordingsmap' VALUES (11015, 2, 1129, 10418);
INSERT INTO 'albumsrecordingsmap' VALUES (11016, 3, 1129, 10419);
INSERT INTO 'albumsrecordingsmap' VALUES (11017, 4, 1129, 10420);
INSERT INTO 'albumsrecordingsmap' VALUES (11018, 5, 1129, 10421);
INSERT INTO 'albumsrecordingsmap' VALUES (11019, 6, 1129, 10422);
INSERT INTO 'albumsrecordingsmap' VALUES (11020, 7, 1129, 10423);
INSERT INTO 'albumsrecordingsmap' VALUES (11021, 8, 1129, 10424);
INSERT INTO 'albumsrecordingsmap' VALUES (3028, 9, 281, 3027);
INSERT INTO 'albumsrecordingsmap' VALUES (11033, 9, 1131, 10436);
INSERT INTO 'albumsrecordingsmap' VALUES (11042, 1, 1133, 10445);
INSERT INTO 'albumsrecordingsmap' VALUES (11034, 1, 1132, 10437);
INSERT INTO 'albumsrecordingsmap' VALUES (8298, 1, 958, 7787);
INSERT INTO 'albumsrecordingsmap' VALUES (8299, 2, 958, 7788);
INSERT INTO 'albumsrecordingsmap' VALUES (8300, 3, 958, 7789);
INSERT INTO 'albumsrecordingsmap' VALUES (8301, 4, 958, 7790);
INSERT INTO 'albumsrecordingsmap' VALUES (8302, 5, 958, 7791);
INSERT INTO 'albumsrecordingsmap' VALUES (8303, 6, 958, 7792);
INSERT INTO 'albumsrecordingsmap' VALUES (8304, 7, 958, 7793);
INSERT INTO 'albumsrecordingsmap' VALUES (8305, 8, 958, 7794);
INSERT INTO 'albumsrecordingsmap' VALUES (8306, 9, 958, 7795);
INSERT INTO 'albumsrecordingsmap' VALUES (8307, 10, 958, 7796);
INSERT INTO 'albumsrecordingsmap' VALUES (8308, 11, 958, 7797);
INSERT INTO 'albumsrecordingsmap' VALUES (8309, 12, 958, 7798);
INSERT INTO 'albumsrecordingsmap' VALUES (8310, 13, 958, 7799);
INSERT INTO 'albumsrecordingsmap' VALUES (8311, 14, 958, 7800);
INSERT INTO 'albumsrecordingsmap' VALUES (8312, 15, 958, 7801);
INSERT INTO 'albumsrecordingsmap' VALUES (11035, 2, 1132, 10438);
INSERT INTO 'albumsrecordingsmap' VALUES (11036, 3, 1132, 10439);
INSERT INTO 'albumsrecordingsmap' VALUES (11037, 4, 1132, 10440);
INSERT INTO 'albumsrecordingsmap' VALUES (11038, 5, 1132, 10441);
INSERT INTO 'albumsrecordingsmap' VALUES (11039, 6, 1132, 10442);
INSERT INTO 'albumsrecordingsmap' VALUES (11040, 7, 1132, 10443);
INSERT INTO 'albumsrecordingsmap' VALUES (11041, 8, 1132, 10444);
INSERT INTO 'albumsrecordingsmap' VALUES (11044, 6, 1135, 10448);
INSERT INTO 'albumsrecordingsmap' VALUES (11045, 11, 1135, 10449);
INSERT INTO 'albumsrecordingsmap' VALUES (11046, 14, 1135, 10450);
INSERT INTO 'albumsrecordingsmap' VALUES (11047, 20, 1135, 10451);
INSERT INTO 'albumsrecordingsmap' VALUES (5398, 2, 375, 3199);
INSERT INTO 'albumsrecordingsmap' VALUES (5399, 3, 375, 3198);
INSERT INTO 'albumsrecordingsmap' VALUES (5400, 4, 375, 3193);
INSERT INTO 'albumsrecordingsmap' VALUES (5401, 6, 375, 3195);
INSERT INTO 'albumsrecordingsmap' VALUES (5402, 1, 375, 3197);
INSERT INTO 'albumsrecordingsmap' VALUES (5403, 7, 375, 3196);
INSERT INTO 'albumsrecordingsmap' VALUES (5404, 8, 375, 1691);
INSERT INTO 'albumsrecordingsmap' VALUES (5405, 9, 375, 1692);
INSERT INTO 'albumsrecordingsmap' VALUES (5406, 10, 375, 1688);
INSERT INTO 'albumsrecordingsmap' VALUES (5407, 11, 375, 1695);
INSERT INTO 'albumsrecordingsmap' VALUES (5408, 12, 375, 1693);
INSERT INTO 'albumsrecordingsmap' VALUES (5409, 13, 375, 1689);
INSERT INTO 'albumsrecordingsmap' VALUES (5410, 14, 375, 1690);
INSERT INTO 'albumsrecordingsmap' VALUES (6154, 5, 375, 3194);
INSERT INTO 'albumsrecordingsmap' VALUES (7050, 1, 514, 6472);
INSERT INTO 'albumsrecordingsmap' VALUES (7051, 8, 514, 6473);
INSERT INTO 'albumsrecordingsmap' VALUES (7052, 2, 514, 6474);
INSERT INTO 'albumsrecordingsmap' VALUES (7053, 14, 514, 6475);
INSERT INTO 'albumsrecordingsmap' VALUES (7054, 3, 514, 6476);
INSERT INTO 'albumsrecordingsmap' VALUES (7055, 4, 514, 6477);
INSERT INTO 'albumsrecordingsmap' VALUES (7056, 7, 514, 6478);
INSERT INTO 'albumsrecordingsmap' VALUES (7057, 9, 514, 6479);
INSERT INTO 'albumsrecordingsmap' VALUES (7058, 12, 514, 6480);
INSERT INTO 'albumsrecordingsmap' VALUES (7059, 13, 514, 6481);
INSERT INTO 'albumsrecordingsmap' VALUES (7060, 11, 514, 6482);
INSERT INTO 'albumsrecordingsmap' VALUES (7061, 6, 514, 6483);
INSERT INTO 'albumsrecordingsmap' VALUES (7062, 5, 514, 6484);
INSERT INTO 'albumsrecordingsmap' VALUES (7063, 10, 514, 6485);
INSERT INTO 'albumsrecordingsmap' VALUES (7064, 15, 514, 6486);
INSERT INTO 'albumsrecordingsmap' VALUES (9441, 16, 514, 6476);
INSERT INTO 'albumsrecordingsmap' VALUES (9442, 17, 514, 6472);
INSERT INTO 'albumsrecordingsmap' VALUES (11048, 1, 1136, 10452);
INSERT INTO 'albumsrecordingsmap' VALUES (11049, 2, 1136, 10453);
INSERT INTO 'albumsrecordingsmap' VALUES (11050, 3, 1136, 10454);
INSERT INTO 'albumsrecordingsmap' VALUES (11051, 4, 1136, 10455);
INSERT INTO 'albumsrecordingsmap' VALUES (11052, 5, 1136, 10456);
INSERT INTO 'albumsrecordingsmap' VALUES (11053, 6, 1136, 10457);
INSERT INTO 'albumsrecordingsmap' VALUES (11054, 7, 1136, 10458);
INSERT INTO 'albumsrecordingsmap' VALUES (11055, 8, 1136, 10459);
INSERT INTO 'albumsrecordingsmap' VALUES (11056, 9, 1136, 10460);
INSERT INTO 'albumsrecordingsmap' VALUES (11057, 10, 1136, 10461);
INSERT INTO 'albumsrecordingsmap' VALUES (11058, 11, 1136, 10462);
INSERT INTO 'albumsrecordingsmap' VALUES (11059, 12, 1136, 10463);
INSERT INTO 'albumsrecordingsmap' VALUES (9889, 1, 1051, 9319);
INSERT INTO 'albumsrecordingsmap' VALUES (9890, 2, 1051, 9320);
INSERT INTO 'albumsrecordingsmap' VALUES (9891, 3, 1051, 9321);
INSERT INTO 'albumsrecordingsmap' VALUES (9892, 7, 1051, 2443);
INSERT INTO 'albumsrecordingsmap' VALUES (9893, 8, 1051, 9322);
INSERT INTO 'albumsrecordingsmap' VALUES (9894, 9, 1051, 9323);
INSERT INTO 'albumsrecordingsmap' VALUES (9895, 12, 1051, 9324);
INSERT INTO 'albumsrecordingsmap' VALUES (9896, 15, 1051, 2433);
INSERT INTO 'albumsrecordingsmap' VALUES (9897, 13, 1051, 9325);
INSERT INTO 'albumsrecordingsmap' VALUES (9898, 4, 1051, 9326);
INSERT INTO 'albumsrecordingsmap' VALUES (9899, 5, 1051, 306);
INSERT INTO 'albumsrecordingsmap' VALUES (9900, 6, 1051, 9327);
INSERT INTO 'albumsrecordingsmap' VALUES (3895, 1, 760, 3825);
INSERT INTO 'albumsrecordingsmap' VALUES (11043, 1, 1134, 10446);
INSERT INTO 'albumsrecordingsmap' VALUES (3896, 3, 760, 3826);
INSERT INTO 'albumsrecordingsmap' VALUES (3897, 5, 760, 3827);
INSERT INTO 'albumsrecordingsmap' VALUES (3898, 7, 760, 3828);
INSERT INTO 'albumsrecordingsmap' VALUES (3899, 9, 760, 3829);
INSERT INTO 'albumsrecordingsmap' VALUES (3900, 13, 760, 3830);
INSERT INTO 'albumsrecordingsmap' VALUES (10964, 1, 1125, 10367);
INSERT INTO 'albumsrecordingsmap' VALUES (10965, 2, 1125, 10368);
INSERT INTO 'albumsrecordingsmap' VALUES (10966, 3, 1125, 10369);
INSERT INTO 'albumsrecordingsmap' VALUES (10967, 4, 1125, 10370);
INSERT INTO 'albumsrecordingsmap' VALUES (10968, 5, 1125, 10371);
INSERT INTO 'albumsrecordingsmap' VALUES (10969, 6, 1125, 10372);
INSERT INTO 'albumsrecordingsmap' VALUES (10970, 7, 1125, 10373);
INSERT INTO 'albumsrecordingsmap' VALUES (10971, 8, 1125, 10374);
INSERT INTO 'albumsrecordingsmap' VALUES (10972, 9, 1125, 10375);
INSERT INTO 'albumsrecordingsmap' VALUES (10973, 10, 1125, 10376);
INSERT INTO 'albumsrecordingsmap' VALUES (10974, 11, 1125, 10377);
INSERT INTO 'albumsrecordingsmap' VALUES (10975, 12, 1125, 10378);
INSERT INTO 'albumsrecordingsmap' VALUES (10976, 13, 1125, 10379);
INSERT INTO 'albumsrecordingsmap' VALUES (10977, 14, 1125, 10380);
INSERT INTO 'albumsrecordingsmap' VALUES (10978, 15, 1125, 10381);
INSERT INTO 'albumsrecordingsmap' VALUES (10979, 16, 1125, 10382);
INSERT INTO 'albumsrecordingsmap' VALUES (10980, 17, 1125, 10383);
INSERT INTO 'albumsrecordingsmap' VALUES (11060, 1, 1137, 10464);
INSERT INTO 'albumsrecordingsmap' VALUES (11061, 2, 1137, 10465);
INSERT INTO 'albumsrecordingsmap' VALUES (11062, 3, 1137, 10466);
INSERT INTO 'albumsrecordingsmap' VALUES (11063, 4, 1137, 10467);
INSERT INTO 'albumsrecordingsmap' VALUES (11064, 5, 1137, 10468);
INSERT INTO 'albumsrecordingsmap' VALUES (11065, 6, 1137, 10469);
INSERT INTO 'albumsrecordingsmap' VALUES (11066, 7, 1137, 10470);
INSERT INTO 'albumsrecordingsmap' VALUES (11067, 8, 1137, 10471);
INSERT INTO 'albumsrecordingsmap' VALUES (11068, 9, 1137, 10472);
INSERT INTO 'albumsrecordingsmap' VALUES (11069, 10, 1137, 10473);
INSERT INTO 'albumsrecordingsmap' VALUES (11070, 11, 1137, 10474);
INSERT INTO 'albumsrecordingsmap' VALUES (11071, 12, 1137, 10475);
INSERT INTO 'albumsrecordingsmap' VALUES (11072, 13, 1137, 10476);
INSERT INTO 'albumsrecordingsmap' VALUES (1622, 1, 172, 1587);
INSERT INTO 'albumsrecordingsmap' VALUES (1623, 3, 172, 1588);
INSERT INTO 'albumsrecordingsmap' VALUES (1624, 5, 172, 1589);
INSERT INTO 'albumsrecordingsmap' VALUES (1625, 2, 172, 1590);
INSERT INTO 'albumsrecordingsmap' VALUES (1626, 4, 172, 1591);
INSERT INTO 'albumsrecordingsmap' VALUES (1627, 7, 172, 1592);
INSERT INTO 'albumsrecordingsmap' VALUES (1628, 6, 172, 1593);
INSERT INTO 'albumsrecordingsmap' VALUES (6707, 1, 490, 6141);
INSERT INTO 'albumsrecordingsmap' VALUES (6708, 2, 490, 6142);
INSERT INTO 'albumsrecordingsmap' VALUES (6709, 3, 490, 6143);
INSERT INTO 'albumsrecordingsmap' VALUES (6710, 4, 490, 6144);
INSERT INTO 'albumsrecordingsmap' VALUES (6711, 5, 490, 6145);
INSERT INTO 'albumsrecordingsmap' VALUES (6712, 6, 490, 6146);
INSERT INTO 'albumsrecordingsmap' VALUES (6713, 7, 490, 6147);
INSERT INTO 'albumsrecordingsmap' VALUES (6714, 8, 490, 6148);
INSERT INTO 'albumsrecordingsmap' VALUES (6715, 9, 490, 6149);
INSERT INTO 'albumsrecordingsmap' VALUES (6716, 10, 490, 6150);
INSERT INTO 'albumsrecordingsmap' VALUES (6717, 11, 490, 6151);
INSERT INTO 'albumsrecordingsmap' VALUES (6718, 12, 490, 6152);
INSERT INTO 'albumsrecordingsmap' VALUES (6719, 13, 490, 6153);
INSERT INTO 'albumsrecordingsmap' VALUES (6720, 14, 490, 6154);
INSERT INTO 'albumsrecordingsmap' VALUES (6721, 15, 490, 6155);
INSERT INTO 'albumsrecordingsmap' VALUES (6722, 16, 490, 6156);
INSERT INTO 'albumsrecordingsmap' VALUES (6723, 17, 490, 6157);
INSERT INTO 'albumsrecordingsmap' VALUES (6724, 18, 490, 6158);
INSERT INTO 'albumsrecordingsmap' VALUES (6725, 19, 490, 6159);
INSERT INTO 'albumsrecordingsmap' VALUES (6726, 20, 490, 6160);
INSERT INTO 'albumsrecordingsmap' VALUES (6727, 21, 490, 6161);
INSERT INTO 'albumsrecordingsmap' VALUES (6728, 22, 490, 6162);
INSERT INTO 'albumsrecordingsmap' VALUES (6729, 23, 490, 6163);
INSERT INTO 'albumsrecordingsmap' VALUES (6730, 24, 490, 6164);
INSERT INTO 'albumsrecordingsmap' VALUES (6731, 25, 490, 6165);
INSERT INTO 'albumsrecordingsmap' VALUES (6732, 26, 490, 6166);
INSERT INTO 'albumsrecordingsmap' VALUES (6733, 27, 490, 6167);
INSERT INTO 'albumsrecordingsmap' VALUES (6734, 28, 490, 6168);
INSERT INTO 'albumsrecordingsmap' VALUES (9446, 31, 490, 8935);
INSERT INTO 'albumsrecordingsmap' VALUES (9447, 32, 490, 8936);
INSERT INTO 'albumsrecordingsmap' VALUES (9448, 33, 490, 8937);
INSERT INTO 'albumsrecordingsmap' VALUES (9449, 34, 490, 8938);
INSERT INTO 'albumsrecordingsmap' VALUES (9450, 35, 490, 8939);
INSERT INTO 'albumsrecordingsmap' VALUES (9451, 36, 490, 8940);
INSERT INTO 'albumsrecordingsmap' VALUES (9452, 37, 490, 8941);
INSERT INTO 'albumsrecordingsmap' VALUES (11112, 1, 1139, 10491);
INSERT INTO 'albumsrecordingsmap' VALUES (11113, 2, 1139, 10492);
INSERT INTO 'albumsrecordingsmap' VALUES (11114, 3, 1139, 10493);
INSERT INTO 'albumsrecordingsmap' VALUES (11115, 4, 1139, 10494);
INSERT INTO 'albumsrecordingsmap' VALUES (11116, 5, 1139, 10495);
INSERT INTO 'albumsrecordingsmap' VALUES (11117, 6, 1139, 10496);
INSERT INTO 'albumsrecordingsmap' VALUES (11118, 7, 1139, 10497);
INSERT INTO 'albumsrecordingsmap' VALUES (11119, 8, 1139, 10498);
INSERT INTO 'albumsrecordingsmap' VALUES (11120, 9, 1139, 10499);
INSERT INTO 'albumsrecordingsmap' VALUES (11121, 10, 1139, 10500);
INSERT INTO 'albumsrecordingsmap' VALUES (11122, 11, 1139, 10501);
INSERT INTO 'albumsrecordingsmap' VALUES (11123, 12, 1139, 10502);
INSERT INTO 'albumsrecordingsmap' VALUES (11124, 13, 1139, 10503);
INSERT INTO 'albumsrecordingsmap' VALUES (11125, 14, 1139, 10504);
INSERT INTO 'albumsrecordingsmap' VALUES (11126, 15, 1139, 10505);
INSERT INTO 'albumsrecordingsmap' VALUES (11127, 16, 1139, 10506);
INSERT INTO 'albumsrecordingsmap' VALUES (8412, 1, 963, 7901);
INSERT INTO 'albumsrecordingsmap' VALUES (8413, 2, 963, 7902);
INSERT INTO 'albumsrecordingsmap' VALUES (8414, 3, 963, 7903);
INSERT INTO 'albumsrecordingsmap' VALUES (8415, 4, 963, 7904);
INSERT INTO 'albumsrecordingsmap' VALUES (8416, 5, 963, 7905);
INSERT INTO 'albumsrecordingsmap' VALUES (8417, 6, 963, 7906);
INSERT INTO 'albumsrecordingsmap' VALUES (8418, 7, 963, 7907);
INSERT INTO 'albumsrecordingsmap' VALUES (8419, 8, 963, 7908);
INSERT INTO 'albumsrecordingsmap' VALUES (8420, 9, 963, 7909);
INSERT INTO 'albumsrecordingsmap' VALUES (8421, 10, 963, 7910);
INSERT INTO 'albumsrecordingsmap' VALUES (8422, 11, 963, 7911);
INSERT INTO 'albumsrecordingsmap' VALUES (8423, 12, 963, 7912);
INSERT INTO 'albumsrecordingsmap' VALUES (8424, 13, 963, 7913);
INSERT INTO 'albumsrecordingsmap' VALUES (8425, 14, 963, 7914);
INSERT INTO 'albumsrecordingsmap' VALUES (8426, 15, 963, 7915);
INSERT INTO 'albumsrecordingsmap' VALUES (8427, 16, 963, 7916);
INSERT INTO 'albumsrecordingsmap' VALUES (8428, 17, 963, 7917);
INSERT INTO 'albumsrecordingsmap' VALUES (8429, 18, 963, 7918);
INSERT INTO 'albumsrecordingsmap' VALUES (8430, 19, 963, 7919);
INSERT INTO 'albumsrecordingsmap' VALUES (8431, 20, 963, 7920);
INSERT INTO 'albumsrecordingsmap' VALUES (11142, 1, 1141, 10521);
INSERT INTO 'albumsrecordingsmap' VALUES (11143, 2, 1141, 10522);
INSERT INTO 'albumsrecordingsmap' VALUES (11144, 3, 1141, 10523);
INSERT INTO 'albumsrecordingsmap' VALUES (11145, 4, 1141, 10524);
INSERT INTO 'albumsrecordingsmap' VALUES (11146, 5, 1141, 10525);
INSERT INTO 'albumsrecordingsmap' VALUES (11128, 1, 1140, 10507);
INSERT INTO 'albumsrecordingsmap' VALUES (11129, 2, 1140, 10508);
INSERT INTO 'albumsrecordingsmap' VALUES (11130, 3, 1140, 10509);
INSERT INTO 'albumsrecordingsmap' VALUES (11131, 4, 1140, 10510);
INSERT INTO 'albumsrecordingsmap' VALUES (11132, 5, 1140, 10511);
INSERT INTO 'albumsrecordingsmap' VALUES (11133, 6, 1140, 10512);
INSERT INTO 'albumsrecordingsmap' VALUES (11134, 7, 1140, 10513);
INSERT INTO 'albumsrecordingsmap' VALUES (11135, 8, 1140, 10514);
INSERT INTO 'albumsrecordingsmap' VALUES (11136, 9, 1140, 10515);
INSERT INTO 'albumsrecordingsmap' VALUES (11137, 10, 1140, 10516);
INSERT INTO 'albumsrecordingsmap' VALUES (11138, 11, 1140, 10517);
INSERT INTO 'albumsrecordingsmap' VALUES (11139, 12, 1140, 10518);
INSERT INTO 'albumsrecordingsmap' VALUES (11140, 13, 1140, 10519);
INSERT INTO 'albumsrecordingsmap' VALUES (11073, 1, 1138, 6141);
INSERT INTO 'albumsrecordingsmap' VALUES (11074, 2, 1138, 10477);
INSERT INTO 'albumsrecordingsmap' VALUES (11075, 3, 1138, 6142);
INSERT INTO 'albumsrecordingsmap' VALUES (11076, 4, 1138, 10478);
INSERT INTO 'albumsrecordingsmap' VALUES (11077, 5, 1138, 6144);
INSERT INTO 'albumsrecordingsmap' VALUES (11078, 6, 1138, 6146);
INSERT INTO 'albumsrecordingsmap' VALUES (11079, 8, 1138, 6147);
INSERT INTO 'albumsrecordingsmap' VALUES (11080, 10, 1138, 6149);
INSERT INTO 'albumsrecordingsmap' VALUES (11081, 9, 1138, 10479);
INSERT INTO 'albumsrecordingsmap' VALUES (11082, 11, 1138, 6150);
INSERT INTO 'albumsrecordingsmap' VALUES (11083, 12, 1138, 6151);
INSERT INTO 'albumsrecordingsmap' VALUES (11084, 13, 1138, 10480);
INSERT INTO 'albumsrecordingsmap' VALUES (11085, 15, 1138, 6154);
INSERT INTO 'albumsrecordingsmap' VALUES (11141, 14, 1140, 10520);
INSERT INTO 'albumsrecordingsmap' VALUES (3827, 1, 752, 3763);
INSERT INTO 'albumsrecordingsmap' VALUES (3828, 2, 752, 3764);
INSERT INTO 'albumsrecordingsmap' VALUES (3829, 3, 752, 3765);
INSERT INTO 'albumsrecordingsmap' VALUES (3830, 4, 752, 3766);
INSERT INTO 'albumsrecordingsmap' VALUES (3831, 5, 752, 3767);
INSERT INTO 'albumsrecordingsmap' VALUES (3832, 6, 752, 3768);
INSERT INTO 'albumsrecordingsmap' VALUES (3833, 8, 752, 3770);
INSERT INTO 'albumsrecordingsmap' VALUES (3834, 9, 752, 3771);
INSERT INTO 'albumsrecordingsmap' VALUES (3835, 10, 752, 3772);
INSERT INTO 'albumsrecordingsmap' VALUES (3836, 11, 752, 3773);
INSERT INTO 'albumsrecordingsmap' VALUES (3837, 12, 752, 3774);
INSERT INTO 'albumsrecordingsmap' VALUES (3838, 13, 752, 3775);
INSERT INTO 'albumsrecordingsmap' VALUES (3839, 14, 752, 3776);
INSERT INTO 'albumsrecordingsmap' VALUES (3840, 15, 752, 3777);
INSERT INTO 'albumsrecordingsmap' VALUES (4450, 7, 752, 1064);
INSERT INTO 'albumsrecordingsmap' VALUES (1836, 1, 164, 1805);
INSERT INTO 'albumsrecordingsmap' VALUES (1837, 6, 164, 1806);
INSERT INTO 'albumsrecordingsmap' VALUES (1838, 3, 164, 1807);
INSERT INTO 'albumsrecordingsmap' VALUES (1839, 4, 164, 1808);
INSERT INTO 'albumsrecordingsmap' VALUES (11163, 1, 1143, 7059);
INSERT INTO 'albumsrecordingsmap' VALUES (11164, 2, 1143, 7060);
INSERT INTO 'albumsrecordingsmap' VALUES (11165, 3, 1143, 7061);
INSERT INTO 'albumsrecordingsmap' VALUES (11166, 4, 1143, 7062);
INSERT INTO 'albumsrecordingsmap' VALUES (11167, 5, 1143, 7063);
INSERT INTO 'albumsrecordingsmap' VALUES (11168, 6, 1143, 7064);
INSERT INTO 'albumsrecordingsmap' VALUES (11169, 7, 1143, 7065);
INSERT INTO 'albumsrecordingsmap' VALUES (11170, 8, 1143, 7066);
INSERT INTO 'albumsrecordingsmap' VALUES (11171, 9, 1143, 7067);
INSERT INTO 'albumsrecordingsmap' VALUES (11172, 10, 1143, 7068);
INSERT INTO 'albumsrecordingsmap' VALUES (11173, 11, 1143, 7069);
INSERT INTO 'albumsrecordingsmap' VALUES (11174, 12, 1143, 7070);
INSERT INTO 'albumsrecordingsmap' VALUES (11175, 13, 1143, 7071);
INSERT INTO 'albumsrecordingsmap' VALUES (3124, 1, 293, 3127);
INSERT INTO 'albumsrecordingsmap' VALUES (3125, 2, 293, 3128);
INSERT INTO 'albumsrecordingsmap' VALUES (3126, 3, 293, 3129);
INSERT INTO 'albumsrecordingsmap' VALUES (3127, 4, 293, 3130);
INSERT INTO 'albumsrecordingsmap' VALUES (3128, 5, 293, 3131);
INSERT INTO 'albumsrecordingsmap' VALUES (3129, 6, 293, 3132);
INSERT INTO 'albumsrecordingsmap' VALUES (3130, 7, 293, 3133);
INSERT INTO 'albumsrecordingsmap' VALUES (3131, 8, 293, 3134);
INSERT INTO 'albumsrecordingsmap' VALUES (3132, 9, 293, 3135);
INSERT INTO 'albumsrecordingsmap' VALUES (1840, 8, 164, 1809);
INSERT INTO 'albumsrecordingsmap' VALUES (1841, 5, 164, 1810);
INSERT INTO 'albumsrecordingsmap' VALUES (1842, 7, 164, 1811);
INSERT INTO 'albumsrecordingsmap' VALUES (1843, 2, 164, 1812);
INSERT INTO 'albumsrecordingsmap' VALUES (11197, 1, 1145, 10563);
INSERT INTO 'albumsrecordingsmap' VALUES (11198, 2, 1145, 10564);
INSERT INTO 'albumsrecordingsmap' VALUES (11199, 3, 1145, 10565);
INSERT INTO 'albumsrecordingsmap' VALUES (11200, 4, 1145, 10566);
INSERT INTO 'albumsrecordingsmap' VALUES (11201, 5, 1145, 10567);
INSERT INTO 'albumsrecordingsmap' VALUES (11202, 6, 1145, 10568);
INSERT INTO 'albumsrecordingsmap' VALUES (11203, 7, 1145, 10569);
INSERT INTO 'albumsrecordingsmap' VALUES (11204, 8, 1145, 10570);
INSERT INTO 'albumsrecordingsmap' VALUES (11205, 9, 1145, 10571);
INSERT INTO 'albumsrecordingsmap' VALUES (11206, 10, 1145, 10572);
INSERT INTO 'albumsrecordingsmap' VALUES (11207, 11, 1145, 10573);
INSERT INTO 'albumsrecordingsmap' VALUES (1031, 1, 85, 1005);
INSERT INTO 'albumsrecordingsmap' VALUES (1032, 2, 85, 1006);
INSERT INTO 'albumsrecordingsmap' VALUES (1033, 3, 85, 1007);
INSERT INTO 'albumsrecordingsmap' VALUES (5263, 2, 359, 4988);
INSERT INTO 'albumsrecordingsmap' VALUES (5264, 3, 359, 4989);
INSERT INTO 'albumsrecordingsmap' VALUES (5265, 5, 359, 4990);
INSERT INTO 'albumsrecordingsmap' VALUES (5266, 6, 359, 4991);
INSERT INTO 'albumsrecordingsmap' VALUES (5267, 7, 359, 4992);
INSERT INTO 'albumsrecordingsmap' VALUES (5268, 11, 359, 4993);
INSERT INTO 'albumsrecordingsmap' VALUES (5269, 12, 359, 4994);
INSERT INTO 'albumsrecordingsmap' VALUES (5270, 17, 359, 4995);
INSERT INTO 'albumsrecordingsmap' VALUES (5271, 19, 359, 4996);
INSERT INTO 'albumsrecordingsmap' VALUES (6232, 15, 359, 95);
INSERT INTO 'albumsrecordingsmap' VALUES (6233, 18, 359, 259);
INSERT INTO 'albumsrecordingsmap' VALUES (6234, 16, 359, 263);
INSERT INTO 'albumsrecordingsmap' VALUES (11176, 9, 359, 10542);
INSERT INTO 'albumsrecordingsmap' VALUES (2826, 1, 261, 125);
INSERT INTO 'albumsrecordingsmap' VALUES (2827, 2, 261, 2826);
INSERT INTO 'albumsrecordingsmap' VALUES (2828, 0, 261, 2827);
INSERT INTO 'albumsrecordingsmap' VALUES (2829, 4, 261, 2828);
INSERT INTO 'albumsrecordingsmap' VALUES (2830, 5, 261, 2829);
INSERT INTO 'albumsrecordingsmap' VALUES (2831, 6, 261, 2830);
INSERT INTO 'albumsrecordingsmap' VALUES (2832, 7, 261, 2831);
INSERT INTO 'albumsrecordingsmap' VALUES (2833, 8, 261, 2832);
INSERT INTO 'albumsrecordingsmap' VALUES (2834, 9, 261, 2833);
INSERT INTO 'albumsrecordingsmap' VALUES (2835, 10, 261, 2834);
INSERT INTO 'albumsrecordingsmap' VALUES (2836, 12, 261, 2835);
INSERT INTO 'albumsrecordingsmap' VALUES (1034, 4, 85, 1008);
INSERT INTO 'albumsrecordingsmap' VALUES (1035, 5, 85, 1009);
INSERT INTO 'albumsrecordingsmap' VALUES (1036, 6, 85, 1010);
INSERT INTO 'albumsrecordingsmap' VALUES (1037, 7, 85, 1011);
INSERT INTO 'albumsrecordingsmap' VALUES (1038, 8, 85, 1012);
INSERT INTO 'albumsrecordingsmap' VALUES (1039, 9, 85, 1013);
INSERT INTO 'albumsrecordingsmap' VALUES (1040, 10, 85, 1014);
INSERT INTO 'albumsrecordingsmap' VALUES (1041, 11, 85, 1015);
INSERT INTO 'albumsrecordingsmap' VALUES (1042, 12, 85, 1016);
INSERT INTO 'albumsrecordingsmap' VALUES (1043, 13, 85, 1017);
INSERT INTO 'albumsrecordingsmap' VALUES (1044, 14, 85, 1018);
INSERT INTO 'albumsrecordingsmap' VALUES (1045, 15, 85, 1019);
INSERT INTO 'albumsrecordingsmap' VALUES (1046, 16, 85, 1020);
INSERT INTO 'albumsrecordingsmap' VALUES (1047, 17, 85, 1021);
INSERT INTO 'albumsrecordingsmap' VALUES (1888, 8, 167, 1857);
INSERT INTO 'albumsrecordingsmap' VALUES (1889, 9, 167, 1858);
INSERT INTO 'albumsrecordingsmap' VALUES (1657, 4, 177, 1615);
INSERT INTO 'albumsrecordingsmap' VALUES (1658, 5, 177, 1616);
INSERT INTO 'albumsrecordingsmap' VALUES (1659, 6, 177, 1617);
INSERT INTO 'albumsrecordingsmap' VALUES (1660, 7, 177, 1618);
INSERT INTO 'albumsrecordingsmap' VALUES (1661, 8, 177, 1619);
INSERT INTO 'albumsrecordingsmap' VALUES (1662, 9, 177, 1620);
INSERT INTO 'albumsrecordingsmap' VALUES (1663, 10, 177, 1621);
INSERT INTO 'albumsrecordingsmap' VALUES (1664, 11, 177, 1622);
INSERT INTO 'albumsrecordingsmap' VALUES (5280, 9, 360, 5005);
INSERT INTO 'albumsrecordingsmap' VALUES (5281, 10, 360, 5006);
INSERT INTO 'albumsrecordingsmap' VALUES (5282, 11, 360, 5007);
INSERT INTO 'albumsrecordingsmap' VALUES (5283, 12, 360, 5008);
INSERT INTO 'albumsrecordingsmap' VALUES (5284, 13, 360, 5009);
INSERT INTO 'albumsrecordingsmap' VALUES (11177, 1, 1144, 10543);
INSERT INTO 'albumsrecordingsmap' VALUES (11178, 2, 1144, 10544);
INSERT INTO 'albumsrecordingsmap' VALUES (11179, 3, 1144, 10545);
INSERT INTO 'albumsrecordingsmap' VALUES (11180, 4, 1144, 10546);
INSERT INTO 'albumsrecordingsmap' VALUES (11181, 5, 1144, 10547);
INSERT INTO 'albumsrecordingsmap' VALUES (11182, 6, 1144, 10548);
INSERT INTO 'albumsrecordingsmap' VALUES (11183, 8, 1144, 10550);
INSERT INTO 'albumsrecordingsmap' VALUES (11184, 9, 1144, 10551);
INSERT INTO 'albumsrecordingsmap' VALUES (11185, 10, 1144, 10552);
INSERT INTO 'albumsrecordingsmap' VALUES (11186, 11, 1144, 10553);
INSERT INTO 'albumsrecordingsmap' VALUES (11187, 12, 1144, 10554);
INSERT INTO 'albumsrecordingsmap' VALUES (11188, 7, 1144, 10549);
INSERT INTO 'albumsrecordingsmap' VALUES (11189, 13, 1144, 10555);
INSERT INTO 'albumsrecordingsmap' VALUES (11190, 14, 1144, 10556);
INSERT INTO 'albumsrecordingsmap' VALUES (11191, 15, 1144, 10557);
INSERT INTO 'albumsrecordingsmap' VALUES (11192, 16, 1144, 10558);
INSERT INTO 'albumsrecordingsmap' VALUES (11193, 17, 1144, 10559);
INSERT INTO 'albumsrecordingsmap' VALUES (11194, 18, 1144, 10560);
INSERT INTO 'albumsrecordingsmap' VALUES (11195, 19, 1144, 10561);
INSERT INTO 'albumsrecordingsmap' VALUES (11196, 20, 1144, 10562);
INSERT INTO 'albumsrecordingsmap' VALUES (5285, 14, 360, 5010);
INSERT INTO 'albumsrecordingsmap' VALUES (5286, 15, 360, 5011);
INSERT INTO 'albumsrecordingsmap' VALUES (5287, 16, 360, 3341);
INSERT INTO 'albumsrecordingsmap' VALUES (8993, 1, 998, 8482);
INSERT INTO 'albumsrecordingsmap' VALUES (8994, 2, 998, 8483);
INSERT INTO 'albumsrecordingsmap' VALUES (8995, 3, 998, 8484);
INSERT INTO 'albumsrecordingsmap' VALUES (8996, 4, 998, 8485);
INSERT INTO 'albumsrecordingsmap' VALUES (8997, 5, 998, 8486);
INSERT INTO 'albumsrecordingsmap' VALUES (8998, 6, 998, 8487);
INSERT INTO 'albumsrecordingsmap' VALUES (8999, 7, 998, 8488);
INSERT INTO 'albumsrecordingsmap' VALUES (9000, 8, 998, 8489);
INSERT INTO 'albumsrecordingsmap' VALUES (11147, 1, 1142, 10526);
INSERT INTO 'albumsrecordingsmap' VALUES (11148, 2, 1142, 10534);
INSERT INTO 'albumsrecordingsmap' VALUES (11149, 3, 1142, 10535);
INSERT INTO 'albumsrecordingsmap' VALUES (11150, 4, 1142, 10527);
INSERT INTO 'albumsrecordingsmap' VALUES (11151, 5, 1142, 10528);
INSERT INTO 'albumsrecordingsmap' VALUES (11152, 6, 1142, 10529);
INSERT INTO 'albumsrecordingsmap' VALUES (11153, 7, 1142, 10536);
INSERT INTO 'albumsrecordingsmap' VALUES (11154, 8, 1142, 10530);
INSERT INTO 'albumsrecordingsmap' VALUES (11155, 9, 1142, 10537);
INSERT INTO 'albumsrecordingsmap' VALUES (11156, 10, 1142, 10538);
INSERT INTO 'albumsrecordingsmap' VALUES (11157, 11, 1142, 10531);
INSERT INTO 'albumsrecordingsmap' VALUES (11158, 12, 1142, 10532);
INSERT INTO 'albumsrecordingsmap' VALUES (11159, 13, 1142, 10539);
INSERT INTO 'albumsrecordingsmap' VALUES (11160, 14, 1142, 10540);
INSERT INTO 'albumsrecordingsmap' VALUES (11161, 15, 1142, 10533);
INSERT INTO 'albumsrecordingsmap' VALUES (11162, 16, 1142, 10541);
INSERT INTO 'albumsrecordingsmap' VALUES (9001, 9, 998, 8490);
INSERT INTO 'albumsrecordingsmap' VALUES (9002, 10, 998, 8491);
INSERT INTO 'albumsrecordingsmap' VALUES (9003, 11, 998, 8492);
INSERT INTO 'albumsrecordingsmap' VALUES (9004, 12, 998, 8493);
INSERT INTO 'albumsrecordingsmap' VALUES (9005, 13, 998, 8494);
INSERT INTO 'albumsrecordingsmap' VALUES (9006, 14, 998, 8495);
INSERT INTO 'albumsrecordingsmap' VALUES (9007, 15, 998, 8496);
INSERT INTO 'albumsrecordingsmap' VALUES (9008, 16, 998, 8497);
INSERT INTO 'albumsrecordingsmap' VALUES (9009, 17, 998, 8498);
INSERT INTO 'albumsrecordingsmap' VALUES (9010, 18, 998, 8499);
INSERT INTO 'albumsrecordingsmap' VALUES (9011, 19, 998, 8500);
INSERT INTO 'albumsrecordingsmap' VALUES (9012, 20, 998, 8501);
INSERT INTO 'albumsrecordingsmap' VALUES (10841, 1, 1116, 10247);
INSERT INTO 'albumsrecordingsmap' VALUES (10842, 2, 1116, 10248);
INSERT INTO 'albumsrecordingsmap' VALUES (10843, 3, 1116, 10249);
INSERT INTO 'albumsrecordingsmap' VALUES (10844, 4, 1116, 10250);
INSERT INTO 'albumsrecordingsmap' VALUES (10845, 5, 1116, 10251);
INSERT INTO 'albumsrecordingsmap' VALUES (10846, 6, 1116, 10252);
INSERT INTO 'albumsrecordingsmap' VALUES (10847, 7, 1116, 10253);
INSERT INTO 'albumsrecordingsmap' VALUES (10848, 8, 1116, 10254);
INSERT INTO 'albumsrecordingsmap' VALUES (10849, 9, 1116, 10255);
INSERT INTO 'albumsrecordingsmap' VALUES (10850, 10, 1116, 10256);
INSERT INTO 'albumsrecordingsmap' VALUES (10851, 11, 1116, 10257);
INSERT INTO 'albumsrecordingsmap' VALUES (10856, 16, 1116, 10262);
INSERT INTO 'albumsrecordingsmap' VALUES (10857, 17, 1116, 10263);
INSERT INTO 'albumsrecordingsmap' VALUES (10858, 18, 1116, 10264);
INSERT INTO 'albumsrecordingsmap' VALUES (2690, 6, 711, 2693);
INSERT INTO 'albumsrecordingsmap' VALUES (2691, 16, 711, 2694);
INSERT INTO 'albumsrecordingsmap' VALUES (2692, 10, 711, 2695);
INSERT INTO 'albumsrecordingsmap' VALUES (2693, 3, 711, 2696);
INSERT INTO 'albumsrecordingsmap' VALUES (2694, 13, 711, 2697);
INSERT INTO 'albumsrecordingsmap' VALUES (2695, 18, 711, 2698);
INSERT INTO 'albumsrecordingsmap' VALUES (3402, 1, 711, 3349);
INSERT INTO 'albumsrecordingsmap' VALUES (3403, 2, 711, 3350);
INSERT INTO 'albumsrecordingsmap' VALUES (3404, 4, 711, 3351);
INSERT INTO 'albumsrecordingsmap' VALUES (3405, 5, 711, 3352);
INSERT INTO 'albumsrecordingsmap' VALUES (3406, 8, 711, 3353);
INSERT INTO 'albumsrecordingsmap' VALUES (3407, 12, 711, 3356);
INSERT INTO 'albumsrecordingsmap' VALUES (3408, 11, 711, 3355);
INSERT INTO 'albumsrecordingsmap' VALUES (3409, 9, 711, 3354);
INSERT INTO 'albumsrecordingsmap' VALUES (3410, 15, 711, 3358);
INSERT INTO 'albumsrecordingsmap' VALUES (3411, 14, 711, 3357);
INSERT INTO 'albumsrecordingsmap' VALUES (3412, 17, 711, 3359);
INSERT INTO 'albumsrecordingsmap' VALUES (10044, 1, 1062, 9471);
INSERT INTO 'albumsrecordingsmap' VALUES (10045, 2, 1062, 9472);
INSERT INTO 'albumsrecordingsmap' VALUES (10046, 3, 1062, 9473);
INSERT INTO 'albumsrecordingsmap' VALUES (10047, 4, 1062, 9474);
INSERT INTO 'albumsrecordingsmap' VALUES (10048, 5, 1062, 9475);
INSERT INTO 'albumsrecordingsmap' VALUES (10049, 6, 1062, 9476);
INSERT INTO 'albumsrecordingsmap' VALUES (10050, 7, 1062, 9477);
INSERT INTO 'albumsrecordingsmap' VALUES (10051, 8, 1062, 9478);
INSERT INTO 'albumsrecordingsmap' VALUES (10052, 9, 1062, 9479);
INSERT INTO 'albumsrecordingsmap' VALUES (10053, 10, 1062, 9480);
INSERT INTO 'albumsrecordingsmap' VALUES (10054, 11, 1062, 9481);
INSERT INTO 'albumsrecordingsmap' VALUES (10055, 12, 1062, 9482);
INSERT INTO 'albumsrecordingsmap' VALUES (10056, 13, 1062, 9483);
INSERT INTO 'albumsrecordingsmap' VALUES (10057, 14, 1062, 9484);
INSERT INTO 'albumsrecordingsmap' VALUES (10058, 15, 1062, 9485);
INSERT INTO 'albumsrecordingsmap' VALUES (10059, 16, 1062, 9486);
INSERT INTO 'albumsrecordingsmap' VALUES (10060, 17, 1062, 9487);
INSERT INTO 'albumsrecordingsmap' VALUES (10061, 18, 1062, 9488);
INSERT INTO 'albumsrecordingsmap' VALUES (10062, 19, 1062, 9489);
INSERT INTO 'albumsrecordingsmap' VALUES (10063, 20, 1062, 9490);
INSERT INTO 'albumsrecordingsmap' VALUES (10064, 21, 1062, 9491);
INSERT INTO 'albumsrecordingsmap' VALUES (10065, 22, 1062, 9492);
INSERT INTO 'albumsrecordingsmap' VALUES (10066, 23, 1062, 9493);
INSERT INTO 'albumsrecordingsmap' VALUES (10067, 24, 1062, 9494);
INSERT INTO 'albumsrecordingsmap' VALUES (10068, 25, 1062, 9495);
INSERT INTO 'albumsrecordingsmap' VALUES (10069, 26, 1062, 9496);
INSERT INTO 'albumsrecordingsmap' VALUES (10070, 27, 1062, 9497);
INSERT INTO 'albumsrecordingsmap' VALUES (10071, 28, 1062, 9498);
INSERT INTO 'albumsrecordingsmap' VALUES (10072, 29, 1062, 9499);
INSERT INTO 'albumsrecordingsmap' VALUES (6098, 3, 443, 5640);
INSERT INTO 'albumsrecordingsmap' VALUES (6099, 4, 443, 5641);
INSERT INTO 'albumsrecordingsmap' VALUES (6100, 5, 443, 5642);
INSERT INTO 'albumsrecordingsmap' VALUES (6101, 6, 443, 5643);
INSERT INTO 'albumsrecordingsmap' VALUES (6102, 7, 443, 5644);
INSERT INTO 'albumsrecordingsmap' VALUES (6103, 8, 443, 5645);
INSERT INTO 'albumsrecordingsmap' VALUES (6104, 9, 443, 5646);
INSERT INTO 'albumsrecordingsmap' VALUES (6105, 10, 443, 5647);
INSERT INTO 'albumsrecordingsmap' VALUES (6106, 11, 443, 5648);
INSERT INTO 'albumsrecordingsmap' VALUES (6107, 12, 443, 5649);
INSERT INTO 'albumsrecordingsmap' VALUES (6108, 13, 443, 5650);
INSERT INTO 'albumsrecordingsmap' VALUES (6109, 14, 443, 5651);
INSERT INTO 'albumsrecordingsmap' VALUES (6110, 15, 443, 5652);
INSERT INTO 'albumsrecordingsmap' VALUES (6190, 13, 449, 5719);
INSERT INTO 'albumsrecordingsmap' VALUES (6191, 14, 449, 5720);
INSERT INTO 'albumsrecordingsmap' VALUES (6192, 15, 449, 5721);
INSERT INTO 'albumsrecordingsmap' VALUES (6193, 16, 449, 5722);
INSERT INTO 'albumsrecordingsmap' VALUES (6194, 17, 449, 5723);
INSERT INTO 'albumsrecordingsmap' VALUES (11086, 16, 1138, 6155);
INSERT INTO 'albumsrecordingsmap' VALUES (11087, 17, 1138, 10482);
INSERT INTO 'albumsrecordingsmap' VALUES (11088, 18, 1138, 10483);
INSERT INTO 'albumsrecordingsmap' VALUES (11089, 19, 1138, 6158);
INSERT INTO 'albumsrecordingsmap' VALUES (11090, 20, 1138, 6161);
INSERT INTO 'albumsrecordingsmap' VALUES (11091, 21, 1138, 6160);
INSERT INTO 'albumsrecordingsmap' VALUES (11092, 14, 1138, 10481);
INSERT INTO 'albumsrecordingsmap' VALUES (11093, 22, 1138, 6162);
INSERT INTO 'albumsrecordingsmap' VALUES (11094, 23, 1138, 6159);
INSERT INTO 'albumsrecordingsmap' VALUES (11095, 24, 1138, 6163);
INSERT INTO 'albumsrecordingsmap' VALUES (11096, 26, 1138, 6165);
INSERT INTO 'albumsrecordingsmap' VALUES (11097, 25, 1138, 6164);
INSERT INTO 'albumsrecordingsmap' VALUES (11098, 27, 1138, 10484);
INSERT INTO 'albumsrecordingsmap' VALUES (11099, 28, 1138, 6167);
INSERT INTO 'albumsrecordingsmap' VALUES (11100, 31, 1138, 8934);
INSERT INTO 'albumsrecordingsmap' VALUES (11101, 34, 1138, 8937);
INSERT INTO 'albumsrecordingsmap' VALUES (11102, 35, 1138, 8938);
INSERT INTO 'albumsrecordingsmap' VALUES (11103, 36, 1138, 8939);
INSERT INTO 'albumsrecordingsmap' VALUES (11104, 37, 1138, 8940);
INSERT INTO 'albumsrecordingsmap' VALUES (11105, 38, 1138, 8941);
INSERT INTO 'albumsrecordingsmap' VALUES (11106, 39, 1138, 6145);
INSERT INTO 'albumsrecordingsmap' VALUES (11107, 30, 1138, 10485);
INSERT INTO 'albumsrecordingsmap' VALUES (11108, 32, 1138, 10486);
INSERT INTO 'albumsrecordingsmap' VALUES (11109, 33, 1138, 10487);
INSERT INTO 'albumsrecordingsmap' VALUES (11110, 7, 1138, 10488);
INSERT INTO 'albumsrecordingsmap' VALUES (11111, 29, 1138, 10489);
INSERT INTO 'albumsrecordingsmap' VALUES (689, 9, 57, 52);
INSERT INTO 'albumsrecordingsmap' VALUES (690, 3, 57, 722);
INSERT INTO 'albumsrecordingsmap' VALUES (691, 4, 57, 723);
INSERT INTO 'albumsrecordingsmap' VALUES (692, 5, 57, 724);
INSERT INTO 'albumsrecordingsmap' VALUES (693, 6, 57, 725);
INSERT INTO 'albumsrecordingsmap' VALUES (694, 7, 57, 726);
INSERT INTO 'albumsrecordingsmap' VALUES (695, 8, 57, 727);
INSERT INTO 'albumsrecordingsmap' VALUES (11208, 1, 1146, 10574);
INSERT INTO 'albumsrecordingsmap' VALUES (11209, 2, 1146, 10575);
INSERT INTO 'albumsrecordingsmap' VALUES (11210, 3, 1146, 10576);
INSERT INTO 'albumsrecordingsmap' VALUES (11211, 4, 1146, 10577);
INSERT INTO 'albumsrecordingsmap' VALUES (11212, 5, 1146, 10578);
INSERT INTO 'albumsrecordingsmap' VALUES (11213, 6, 1146, 10579);
INSERT INTO 'albumsrecordingsmap' VALUES (11214, 7, 1146, 10580);
INSERT INTO 'albumsrecordingsmap' VALUES (11215, 8, 1146, 10581);
INSERT INTO 'albumsrecordingsmap' VALUES (11216, 9, 1146, 10582);
INSERT INTO 'albumsrecordingsmap' VALUES (11217, 10, 1146, 10583);
INSERT INTO 'albumsrecordingsmap' VALUES (11218, 11, 1146, 10584);
INSERT INTO 'albumsrecordingsmap' VALUES (11219, 12, 1146, 10585);
INSERT INTO 'albumsrecordingsmap' VALUES (11220, 13, 1146, 10586);
INSERT INTO 'albumsrecordingsmap' VALUES (11221, 14, 1146, 10587);
INSERT INTO 'albumsrecordingsmap' VALUES (11222, 15, 1146, 10588);
INSERT INTO 'albumsrecordingsmap' VALUES (11223, 16, 1146, 10589);
INSERT INTO 'albumsrecordingsmap' VALUES (11225, 18, 1146, 10591);
INSERT INTO 'albumsrecordingsmap' VALUES (4950, 1, 330, 4697);
INSERT INTO 'albumsrecordingsmap' VALUES (4951, 2, 330, 4698);
INSERT INTO 'albumsrecordingsmap' VALUES (4952, 3, 330, 4699);
INSERT INTO 'albumsrecordingsmap' VALUES (4953, 4, 330, 4700);
INSERT INTO 'albumsrecordingsmap' VALUES (4954, 5, 330, 4701);
INSERT INTO 'albumsrecordingsmap' VALUES (4955, 6, 330, 4702);
INSERT INTO 'albumsrecordingsmap' VALUES (4956, 7, 330, 4703);
INSERT INTO 'albumsrecordingsmap' VALUES (4957, 8, 330, 4704);
INSERT INTO 'albumsrecordingsmap' VALUES (4958, 9, 330, 4705);
INSERT INTO 'albumsrecordingsmap' VALUES (4959, 10, 330, 4706);
INSERT INTO 'albumsrecordingsmap' VALUES (4960, 11, 330, 4707);
INSERT INTO 'albumsrecordingsmap' VALUES (4961, 12, 330, 4708);
INSERT INTO 'albumsrecordingsmap' VALUES (4962, 13, 330, 4709);
INSERT INTO 'albumsrecordingsmap' VALUES (4963, 14, 330, 4710);
INSERT INTO 'albumsrecordingsmap' VALUES (10373, 1, 1082, 9789);
INSERT INTO 'albumsrecordingsmap' VALUES (10374, 2, 1082, 9790);
INSERT INTO 'albumsrecordingsmap' VALUES (10375, 3, 1082, 9791);
INSERT INTO 'albumsrecordingsmap' VALUES (10376, 4, 1082, 9792);
INSERT INTO 'albumsrecordingsmap' VALUES (10377, 5, 1082, 9793);
INSERT INTO 'albumsrecordingsmap' VALUES (10378, 6, 1082, 9794);
INSERT INTO 'albumsrecordingsmap' VALUES (10379, 7, 1082, 9795);
INSERT INTO 'albumsrecordingsmap' VALUES (10380, 8, 1082, 9796);
INSERT INTO 'albumsrecordingsmap' VALUES (10381, 9, 1082, 9797);
INSERT INTO 'albumsrecordingsmap' VALUES (10382, 10, 1082, 9798);
INSERT INTO 'albumsrecordingsmap' VALUES (10383, 11, 1082, 9799);
INSERT INTO 'albumsrecordingsmap' VALUES (10384, 12, 1082, 9800);
INSERT INTO 'albumsrecordingsmap' VALUES (10385, 13, 1082, 9801);
INSERT INTO 'albumsrecordingsmap' VALUES (10386, 14, 1082, 9802);
INSERT INTO 'albumsrecordingsmap' VALUES (10387, 15, 1082, 9803);
INSERT INTO 'albumsrecordingsmap' VALUES (10388, 16, 1082, 9804);
INSERT INTO 'albumsrecordingsmap' VALUES (10389, 17, 1082, 9805);
INSERT INTO 'albumsrecordingsmap' VALUES (10390, 18, 1082, 9806);
INSERT INTO 'albumsrecordingsmap' VALUES (10391, 19, 1082, 9807);
INSERT INTO 'albumsrecordingsmap' VALUES (5955, 1, 433, 5520);
INSERT INTO 'albumsrecordingsmap' VALUES (5956, 2, 433, 5521);
INSERT INTO 'albumsrecordingsmap' VALUES (5957, 3, 433, 5522);
INSERT INTO 'albumsrecordingsmap' VALUES (5958, 4, 433, 5523);
INSERT INTO 'albumsrecordingsmap' VALUES (5959, 5, 433, 5524);
INSERT INTO 'albumsrecordingsmap' VALUES (5960, 6, 433, 5525);
INSERT INTO 'albumsrecordingsmap' VALUES (5961, 7, 433, 5526);
INSERT INTO 'albumsrecordingsmap' VALUES (5962, 8, 433, 5527);
INSERT INTO 'albumsrecordingsmap' VALUES (5963, 9, 433, 5528);
INSERT INTO 'albumsrecordingsmap' VALUES (5964, 10, 433, 5529);
INSERT INTO 'albumsrecordingsmap' VALUES (11226, 1, 1147, 10592);
INSERT INTO 'albumsrecordingsmap' VALUES (11227, 2, 1147, 10593);
INSERT INTO 'albumsrecordingsmap' VALUES (11228, 3, 1147, 10594);
INSERT INTO 'albumsrecordingsmap' VALUES (11229, 4, 1147, 10595);
INSERT INTO 'albumsrecordingsmap' VALUES (11230, 5, 1147, 10596);
INSERT INTO 'albumsrecordingsmap' VALUES (11231, 6, 1147, 10597);
INSERT INTO 'albumsrecordingsmap' VALUES (11232, 7, 1147, 10598);
INSERT INTO 'albumsrecordingsmap' VALUES (11233, 8, 1147, 10599);
INSERT INTO 'albumsrecordingsmap' VALUES (11234, 9, 1147, 10600);
INSERT INTO 'albumsrecordingsmap' VALUES (11235, 10, 1147, 10601);
INSERT INTO 'albumsrecordingsmap' VALUES (11236, 11, 1147, 10602);
INSERT INTO 'albumsrecordingsmap' VALUES (11237, 12, 1147, 10603);
INSERT INTO 'albumsrecordingsmap' VALUES (11238, 13, 1147, 10604);
INSERT INTO 'albumsrecordingsmap' VALUES (11239, 14, 1147, 10605);
INSERT INTO 'albumsrecordingsmap' VALUES (11240, 15, 1147, 10606);
INSERT INTO 'albumsrecordingsmap' VALUES (11241, 16, 1147, 10607);
INSERT INTO 'albumsrecordingsmap' VALUES (11242, 17, 1147, 10608);
INSERT INTO 'albumsrecordingsmap' VALUES (11243, 18, 1147, 10609);
INSERT INTO 'albumsrecordingsmap' VALUES (11244, 19, 1147, 10610);
INSERT INTO 'albumsrecordingsmap' VALUES (11245, 20, 1147, 10611);
INSERT INTO 'albumsrecordingsmap' VALUES (11246, 21, 1147, 10612);
INSERT INTO 'albumsrecordingsmap' VALUES (11247, 22, 1147, 10613);
INSERT INTO 'albumsrecordingsmap' VALUES (11248, 23, 1147, 10614);
INSERT INTO 'albumsrecordingsmap' VALUES (11249, 24, 1147, 10615);
INSERT INTO 'albumsrecordingsmap' VALUES (7191, 1, 887, 6609);
INSERT INTO 'albumsrecordingsmap' VALUES (7192, 2, 887, 6610);
INSERT INTO 'albumsrecordingsmap' VALUES (7193, 3, 887, 6611);
INSERT INTO 'albumsrecordingsmap' VALUES (7194, 4, 887, 6612);
INSERT INTO 'albumsrecordingsmap' VALUES (7195, 5, 887, 6613);
INSERT INTO 'albumsrecordingsmap' VALUES (7196, 6, 887, 6614);
INSERT INTO 'albumsrecordingsmap' VALUES (7197, 7, 887, 6615);
INSERT INTO 'albumsrecordingsmap' VALUES (7198, 8, 887, 6616);
INSERT INTO 'albumsrecordingsmap' VALUES (7199, 9, 887, 6617);
INSERT INTO 'albumsrecordingsmap' VALUES (7200, 10, 887, 6618);
INSERT INTO 'albumsrecordingsmap' VALUES (7201, 11, 887, 6619);
INSERT INTO 'albumsrecordingsmap' VALUES (7202, 12, 887, 6620);
INSERT INTO 'albumsrecordingsmap' VALUES (7203, 13, 887, 6621);
INSERT INTO 'albumsrecordingsmap' VALUES (7204, 14, 887, 6622);
INSERT INTO 'albumsrecordingsmap' VALUES (7205, 15, 887, 6623);
INSERT INTO 'albumsrecordingsmap' VALUES (7206, 16, 887, 6624);
INSERT INTO 'albumsrecordingsmap' VALUES (7207, 17, 887, 6625);
INSERT INTO 'albumsrecordingsmap' VALUES (7208, 18, 887, 6626);
INSERT INTO 'albumsrecordingsmap' VALUES (7209, 19, 887, 6627);
INSERT INTO 'albumsrecordingsmap' VALUES (7210, 20, 887, 6628);
INSERT INTO 'albumsrecordingsmap' VALUES (7211, 21, 887, 6629);
INSERT INTO 'albumsrecordingsmap' VALUES (7212, 22, 887, 6630);
INSERT INTO 'albumsrecordingsmap' VALUES (7213, 23, 887, 6631);
INSERT INTO 'albumsrecordingsmap' VALUES (7214, 24, 887, 6632);
INSERT INTO 'albumsrecordingsmap' VALUES (7215, 25, 887, 6633);
INSERT INTO 'albumsrecordingsmap' VALUES (7216, 26, 887, 6634);
INSERT INTO 'albumsrecordingsmap' VALUES (7217, 27, 887, 6635);
INSERT INTO 'albumsrecordingsmap' VALUES (7218, 28, 887, 6636);
INSERT INTO 'albumsrecordingsmap' VALUES (7219, 29, 887, 282);
INSERT INTO 'albumsrecordingsmap' VALUES (7220, 30, 887, 6638);
INSERT INTO 'albumsrecordingsmap' VALUES (11250, 1, 1148, 5641);
INSERT INTO 'albumsrecordingsmap' VALUES (11251, 2, 1148, 10616);
INSERT INTO 'albumsrecordingsmap' VALUES (11252, 3, 1148, 10617);
INSERT INTO 'albumsrecordingsmap' VALUES (11253, 4, 1148, 10618);
INSERT INTO 'albumsrecordingsmap' VALUES (11254, 5, 1148, 10619);
INSERT INTO 'albumsrecordingsmap' VALUES (11255, 6, 1148, 2155);
INSERT INTO 'albumsrecordingsmap' VALUES (11256, 7, 1148, 2151);
INSERT INTO 'albumsrecordingsmap' VALUES (11257, 8, 1148, 10620);
INSERT INTO 'albumsrecordingsmap' VALUES (11258, 9, 1148, 10621);
INSERT INTO 'albumsrecordingsmap' VALUES (11259, 10, 1148, 10622);
INSERT INTO 'albumsrecordingsmap' VALUES (11260, 11, 1148, 2156);
INSERT INTO 'albumsrecordingsmap' VALUES (11261, 12, 1148, 10623);
INSERT INTO 'albumsrecordingsmap' VALUES (11262, 13, 1148, 10624);
INSERT INTO 'albumsrecordingsmap' VALUES (11263, 14, 1148, 2157);
INSERT INTO 'albumsrecordingsmap' VALUES (11264, 15, 1148, 2152);
INSERT INTO 'albumsrecordingsmap' VALUES (11265, 16, 1148, 2159);
INSERT INTO 'albumsrecordingsmap' VALUES (11266, 17, 1148, 2158);
INSERT INTO 'albumsrecordingsmap' VALUES (11267, 18, 1148, 2160);
INSERT INTO 'albumsrecordingsmap' VALUES (11268, 19, 1148, 2154);
INSERT INTO 'albumsrecordingsmap' VALUES (11269, 20, 1148, 2161);
INSERT INTO 'albumsrecordingsmap' VALUES (11270, 21, 1148, 2153);
INSERT INTO 'albumsrecordingsmap' VALUES (6536, 1, 477, 2157);
INSERT INTO 'albumsrecordingsmap' VALUES (6537, 2, 477, 2152);
INSERT INTO 'albumsrecordingsmap' VALUES (6538, 3, 477, 2155);
INSERT INTO 'albumsrecordingsmap' VALUES (6539, 4, 477, 2159);
INSERT INTO 'albumsrecordingsmap' VALUES (6540, 5, 477, 2158);
INSERT INTO 'albumsrecordingsmap' VALUES (6541, 6, 477, 2151);
INSERT INTO 'albumsrecordingsmap' VALUES (6542, 7, 477, 2160);
INSERT INTO 'albumsrecordingsmap' VALUES (6543, 8, 477, 2154);
INSERT INTO 'albumsrecordingsmap' VALUES (6544, 9, 477, 2153);
INSERT INTO 'albumsrecordingsmap' VALUES (6545, 10, 477, 2161);
INSERT INTO 'albumsrecordingsmap' VALUES (6546, 11, 477, 2156);
INSERT INTO 'albumsrecordingsmap' VALUES (2260, 1, 198, 2235);
INSERT INTO 'albumsrecordingsmap' VALUES (2291, 2, 198, 2267);
INSERT INTO 'albumsrecordingsmap' VALUES (2292, 3, 198, 2268);
INSERT INTO 'albumsrecordingsmap' VALUES (2293, 4, 198, 2269);
INSERT INTO 'albumsrecordingsmap' VALUES (2294, 5, 198, 2270);
INSERT INTO 'albumsrecordingsmap' VALUES (2295, 6, 198, 2271);
INSERT INTO 'albumsrecordingsmap' VALUES (2296, 7, 198, 2272);
INSERT INTO 'albumsrecordingsmap' VALUES (2297, 8, 198, 2273);
INSERT INTO 'albumsrecordingsmap' VALUES (2298, 9, 198, 2274);
INSERT INTO 'albumsrecordingsmap' VALUES (2299, 10, 198, 2275);
INSERT INTO 'albumsrecordingsmap' VALUES (3301, 11, 198, 2276);
INSERT INTO 'albumsrecordingsmap' VALUES (3302, 12, 198, 2277);
INSERT INTO 'albumsrecordingsmap' VALUES (3303, 13, 198, 2278);
INSERT INTO 'albumsrecordingsmap' VALUES (3304, 14, 198, 2279);
INSERT INTO 'albumsrecordingsmap' VALUES (3305, 15, 198, 2280);
INSERT INTO 'albumsrecordingsmap' VALUES (3306, 16, 198, 2281);
INSERT INTO 'albumsrecordingsmap' VALUES (3307, 17, 198, 2282);
INSERT INTO 'albumsrecordingsmap' VALUES (3308, 18, 198, 2283);
INSERT INTO 'albumsrecordingsmap' VALUES (3309, 19, 198, 2284);
INSERT INTO 'albumsrecordingsmap' VALUES (3310, 20, 198, 2285);
INSERT INTO 'albumsrecordingsmap' VALUES (3311, 21, 198, 2286);
INSERT INTO 'albumsrecordingsmap' VALUES (11271, 1, 1149, 10625);
INSERT INTO 'albumsrecordingsmap' VALUES (11272, 2, 1149, 10626);
INSERT INTO 'albumsrecordingsmap' VALUES (11273, 3, 1149, 10627);
INSERT INTO 'albumsrecordingsmap' VALUES (11274, 4, 1149, 10628);
INSERT INTO 'albumsrecordingsmap' VALUES (11275, 5, 1149, 10629);
INSERT INTO 'albumsrecordingsmap' VALUES (11276, 6, 1149, 10630);
INSERT INTO 'albumsrecordingsmap' VALUES (11277, 7, 1149, 10631);
INSERT INTO 'albumsrecordingsmap' VALUES (11278, 8, 1149, 10632);
INSERT INTO 'albumsrecordingsmap' VALUES (11279, 9, 1149, 10633);
INSERT INTO 'albumsrecordingsmap' VALUES (11280, 10, 1149, 10634);
INSERT INTO 'albumsrecordingsmap' VALUES (11281, 11, 1149, 10635);
INSERT INTO 'albumsrecordingsmap' VALUES (11282, 12, 1149, 10636);
INSERT INTO 'albumsrecordingsmap' VALUES (11283, 13, 1149, 10637);
INSERT INTO 'albumsrecordingsmap' VALUES (11284, 1, 1150, 10638);
INSERT INTO 'albumsrecordingsmap' VALUES (11285, 2, 1150, 10639);
INSERT INTO 'albumsrecordingsmap' VALUES (11286, 3, 1150, 10640);
INSERT INTO 'albumsrecordingsmap' VALUES (11287, 4, 1150, 10641);
INSERT INTO 'albumsrecordingsmap' VALUES (11288, 5, 1150, 10642);
INSERT INTO 'albumsrecordingsmap' VALUES (11289, 6, 1150, 10643);
INSERT INTO 'albumsrecordingsmap' VALUES (11290, 7, 1150, 10644);
INSERT INTO 'albumsrecordingsmap' VALUES (11291, 8, 1150, 10645);
INSERT INTO 'albumsrecordingsmap' VALUES (11292, 9, 1150, 10646);
INSERT INTO 'albumsrecordingsmap' VALUES (11293, 10, 1150, 10647);
INSERT INTO 'albumsrecordingsmap' VALUES (11294, 11, 1150, 10648);
INSERT INTO 'albumsrecordingsmap' VALUES (7575, 1, 912, 7045);
INSERT INTO 'albumsrecordingsmap' VALUES (5091, 1, 348, 4825);
INSERT INTO 'albumsrecordingsmap' VALUES (5092, 2, 348, 4826);
INSERT INTO 'albumsrecordingsmap' VALUES (5093, 3, 348, 4827);
INSERT INTO 'albumsrecordingsmap' VALUES (5094, 4, 348, 4828);
INSERT INTO 'albumsrecordingsmap' VALUES (5095, 5, 348, 4829);
INSERT INTO 'albumsrecordingsmap' VALUES (5096, 6, 348, 4830);
INSERT INTO 'albumsrecordingsmap' VALUES (5097, 7, 348, 4831);
INSERT INTO 'albumsrecordingsmap' VALUES (5098, 8, 348, 4832);
INSERT INTO 'albumsrecordingsmap' VALUES (5099, 9, 348, 4833);
INSERT INTO 'albumsrecordingsmap' VALUES (5100, 10, 348, 4834);
INSERT INTO 'albumsrecordingsmap' VALUES (11349, 1, 1156, 3707);
INSERT INTO 'albumsrecordingsmap' VALUES (4129, 3, 800, 4018);
INSERT INTO 'albumsrecordingsmap' VALUES (4130, 12, 800, 4020);
INSERT INTO 'albumsrecordingsmap' VALUES (11295, 1, 800, 10649);
INSERT INTO 'albumsrecordingsmap' VALUES (11296, 2, 800, 10650);
INSERT INTO 'albumsrecordingsmap' VALUES (11297, 4, 800, 10651);
INSERT INTO 'albumsrecordingsmap' VALUES (11298, 5, 800, 10652);
INSERT INTO 'albumsrecordingsmap' VALUES (11299, 6, 800, 10653);
INSERT INTO 'albumsrecordingsmap' VALUES (11300, 7, 800, 10654);
INSERT INTO 'albumsrecordingsmap' VALUES (11301, 8, 800, 10655);
INSERT INTO 'albumsrecordingsmap' VALUES (11302, 10, 800, 10656);
INSERT INTO 'albumsrecordingsmap' VALUES (11303, 11, 800, 10657);
INSERT INTO 'albumsrecordingsmap' VALUES (11350, 1, 1157, 4170);
INSERT INTO 'albumsrecordingsmap' VALUES (11351, 1, 1158, 8743);
INSERT INTO 'albumsrecordingsmap' VALUES (11352, 1, 1159, 1683);
INSERT INTO 'albumsrecordingsmap' VALUES (7594, 20, 912, 7064);
INSERT INTO 'albumsrecordingsmap' VALUES (11354, 2, 1161, 8810);
INSERT INTO 'albumsrecordingsmap' VALUES (11353, 1, 1160, 8797);
INSERT INTO 'albumsrecordingsmap' VALUES (11304, 1, 1151, 10658);
INSERT INTO 'albumsrecordingsmap' VALUES (11305, 2, 1151, 10659);
INSERT INTO 'albumsrecordingsmap' VALUES (11306, 3, 1151, 10660);
INSERT INTO 'albumsrecordingsmap' VALUES (11307, 4, 1151, 10661);
INSERT INTO 'albumsrecordingsmap' VALUES (11308, 5, 1151, 10662);
INSERT INTO 'albumsrecordingsmap' VALUES (7595, 21, 912, 7065);
INSERT INTO 'albumsrecordingsmap' VALUES (7596, 22, 912, 7066);
INSERT INTO 'albumsrecordingsmap' VALUES (7597, 23, 912, 7067);
INSERT INTO 'albumsrecordingsmap' VALUES (7598, 24, 912, 7068);
INSERT INTO 'albumsrecordingsmap' VALUES (7599, 25, 912, 7069);
INSERT INTO 'albumsrecordingsmap' VALUES (7600, 26, 912, 7070);
INSERT INTO 'albumsrecordingsmap' VALUES (7601, 27, 912, 7071);
INSERT INTO 'albumsrecordingsmap' VALUES (11363, 9, 1162, 10697);
INSERT INTO 'albumsrecordingsmap' VALUES (11309, 6, 1151, 10663);
INSERT INTO 'albumsrecordingsmap' VALUES (11310, 7, 1151, 10664);
INSERT INTO 'albumsrecordingsmap' VALUES (11311, 8, 1151, 10665);
INSERT INTO 'albumsrecordingsmap' VALUES (11312, 9, 1151, 10666);
INSERT INTO 'albumsrecordingsmap' VALUES (11313, 10, 1151, 10667);
INSERT INTO 'albumsrecordingsmap' VALUES (11314, 11, 1151, 10668);
INSERT INTO 'albumsrecordingsmap' VALUES (11315, 12, 1151, 10669);
INSERT INTO 'albumsrecordingsmap' VALUES (10120, 18, 1065, 9547);
INSERT INTO 'albumsrecordingsmap' VALUES (10121, 19, 1065, 9548);
INSERT INTO 'albumsrecordingsmap' VALUES (10122, 20, 1065, 9549);
INSERT INTO 'albumsrecordingsmap' VALUES (10123, 21, 1065, 9550);
INSERT INTO 'albumsrecordingsmap' VALUES (10124, 22, 1065, 9551);
INSERT INTO 'albumsrecordingsmap' VALUES (9290, 1, 1015, 8817);
INSERT INTO 'albumsrecordingsmap' VALUES (9291, 2, 1015, 8818);
INSERT INTO 'albumsrecordingsmap' VALUES (9292, 3, 1015, 8819);
INSERT INTO 'albumsrecordingsmap' VALUES (9293, 4, 1015, 8820);
INSERT INTO 'albumsrecordingsmap' VALUES (9294, 5, 1015, 8821);
INSERT INTO 'albumsrecordingsmap' VALUES (9295, 6, 1015, 8822);
INSERT INTO 'albumsrecordingsmap' VALUES (9296, 7, 1015, 8823);
INSERT INTO 'albumsrecordingsmap' VALUES (9297, 8, 1015, 8824);
INSERT INTO 'albumsrecordingsmap' VALUES (9298, 9, 1015, 8825);
INSERT INTO 'albumsrecordingsmap' VALUES (9299, 10, 1015, 8826);
INSERT INTO 'albumsrecordingsmap' VALUES (9300, 11, 1015, 8827);
INSERT INTO 'albumsrecordingsmap' VALUES (9301, 12, 1015, 8828);
INSERT INTO 'albumsrecordingsmap' VALUES (9302, 13, 1015, 2609);
INSERT INTO 'albumsrecordingsmap' VALUES (9303, 14, 1015, 8830);
INSERT INTO 'albumsrecordingsmap' VALUES (11328, 1, 1153, 10670);
INSERT INTO 'albumsrecordingsmap' VALUES (11329, 2, 1153, 10671);
INSERT INTO 'albumsrecordingsmap' VALUES (11330, 3, 1153, 10672);
INSERT INTO 'albumsrecordingsmap' VALUES (7576, 2, 912, 7046);
INSERT INTO 'albumsrecordingsmap' VALUES (7577, 3, 912, 7047);
INSERT INTO 'albumsrecordingsmap' VALUES (7578, 4, 912, 7048);
INSERT INTO 'albumsrecordingsmap' VALUES (7579, 5, 912, 7049);
INSERT INTO 'albumsrecordingsmap' VALUES (7580, 6, 912, 7050);
INSERT INTO 'albumsrecordingsmap' VALUES (7581, 7, 912, 7051);
INSERT INTO 'albumsrecordingsmap' VALUES (7582, 8, 912, 7052);
INSERT INTO 'albumsrecordingsmap' VALUES (7583, 9, 912, 7053);
INSERT INTO 'albumsrecordingsmap' VALUES (7584, 10, 912, 7054);
INSERT INTO 'albumsrecordingsmap' VALUES (7585, 11, 912, 7055);
INSERT INTO 'albumsrecordingsmap' VALUES (7586, 12, 912, 7056);
INSERT INTO 'albumsrecordingsmap' VALUES (7587, 13, 912, 7057);
INSERT INTO 'albumsrecordingsmap' VALUES (7588, 14, 912, 7058);
INSERT INTO 'albumsrecordingsmap' VALUES (11331, 4, 1153, 10673);
INSERT INTO 'albumsrecordingsmap' VALUES (11332, 5, 1153, 10674);
INSERT INTO 'albumsrecordingsmap' VALUES (11333, 6, 1153, 10675);
INSERT INTO 'albumsrecordingsmap' VALUES (11334, 7, 1153, 10676);
INSERT INTO 'albumsrecordingsmap' VALUES (11335, 8, 1153, 10677);
INSERT INTO 'albumsrecordingsmap' VALUES (11336, 9, 1153, 10658);
INSERT INTO 'albumsrecordingsmap' VALUES (11337, 10, 1153, 10679);
INSERT INTO 'albumsrecordingsmap' VALUES (11338, 11, 1153, 10669);
INSERT INTO 'albumsrecordingsmap' VALUES (11339, 12, 1153, 10667);
INSERT INTO 'albumsrecordingsmap' VALUES (11340, 13, 1153, 10682);
INSERT INTO 'albumsrecordingsmap' VALUES (11341, 14, 1153, 10683);
INSERT INTO 'albumsrecordingsmap' VALUES (11342, 15, 1153, 10684);
INSERT INTO 'albumsrecordingsmap' VALUES (11343, 16, 1153, 10685);
INSERT INTO 'albumsrecordingsmap' VALUES (11344, 17, 1153, 10686);
INSERT INTO 'albumsrecordingsmap' VALUES (11345, 18, 1153, 10687);
INSERT INTO 'albumsrecordingsmap' VALUES (11346, 19, 1153, 10688);
INSERT INTO 'albumsrecordingsmap' VALUES (11316, 1, 1152, 10649);
INSERT INTO 'albumsrecordingsmap' VALUES (11317, 2, 1152, 10650);
INSERT INTO 'albumsrecordingsmap' VALUES (11318, 3, 1152, 4018);
INSERT INTO 'albumsrecordingsmap' VALUES (11319, 4, 1152, 10657);
INSERT INTO 'albumsrecordingsmap' VALUES (11320, 5, 1152, 10652);
INSERT INTO 'albumsrecordingsmap' VALUES (11321, 6, 1152, 10653);
INSERT INTO 'albumsrecordingsmap' VALUES (11322, 7, 1152, 10664);
INSERT INTO 'albumsrecordingsmap' VALUES (11323, 8, 1152, 10663);
INSERT INTO 'albumsrecordingsmap' VALUES (11324, 9, 1152, 10665);
INSERT INTO 'albumsrecordingsmap' VALUES (11325, 10, 1152, 10666);
INSERT INTO 'albumsrecordingsmap' VALUES (11326, 11, 1152, 10667);
INSERT INTO 'albumsrecordingsmap' VALUES (11327, 12, 1152, 10669);
INSERT INTO 'albumsrecordingsmap' VALUES (11347, 1, 1154, 7222);
INSERT INTO 'albumsrecordingsmap' VALUES (11348, 1, 1155, 3135);
INSERT INTO 'albumsrecordingsmap' VALUES (7589, 15, 912, 7059);
INSERT INTO 'albumsrecordingsmap' VALUES (7590, 16, 912, 7060);
INSERT INTO 'albumsrecordingsmap' VALUES (7591, 17, 912, 7061);
INSERT INTO 'albumsrecordingsmap' VALUES (7592, 18, 912, 7062);
INSERT INTO 'albumsrecordingsmap' VALUES (7593, 19, 912, 7063);
INSERT INTO 'albumsrecordingsmap' VALUES (11364, 10, 1162, 10698);
INSERT INTO 'albumsrecordingsmap' VALUES (11365, 11, 1162, 10699);
INSERT INTO 'albumsrecordingsmap' VALUES (11366, 12, 1162, 10700);
INSERT INTO 'albumsrecordingsmap' VALUES (11367, 2, 1134, 10701);
INSERT INTO 'albumsrecordingsmap' VALUES (11368, 3, 1134, 10702);
INSERT INTO 'albumsrecordingsmap' VALUES (11369, 6, 1134, 10705);
INSERT INTO 'albumsrecordingsmap' VALUES (11370, 4, 1134, 10703);
INSERT INTO 'albumsrecordingsmap' VALUES (11371, 5, 1134, 10704);
INSERT INTO 'albumsrecordingsmap' VALUES (11372, 7, 1134, 10706);
INSERT INTO 'albumsrecordingsmap' VALUES (11355, 1, 1162, 10689);
INSERT INTO 'albumsrecordingsmap' VALUES (11356, 2, 1162, 10690);
INSERT INTO 'albumsrecordingsmap' VALUES (11357, 3, 1162, 10691);
INSERT INTO 'albumsrecordingsmap' VALUES (11358, 4, 1162, 10692);
INSERT INTO 'albumsrecordingsmap' VALUES (11359, 5, 1162, 10693);
INSERT INTO 'albumsrecordingsmap' VALUES (11360, 6, 1162, 10694);
INSERT INTO 'albumsrecordingsmap' VALUES (11361, 7, 1162, 10695);
INSERT INTO 'albumsrecordingsmap' VALUES (11362, 8, 1162, 10696);
INSERT INTO 'albumsrecordingsmap' VALUES (11373, 8, 1134, 10707);
INSERT INTO 'albumsrecordingsmap' VALUES (11374, 9, 1134, 10708);
INSERT INTO 'albumsrecordingsmap' VALUES (11375, 10, 1134, 10709);
INSERT INTO 'albumsrecordingsmap' VALUES (11376, 11, 1134, 8183);
INSERT INTO 'albumsrecordingsmap' VALUES (11377, 12, 1134, 10711);
INSERT INTO 'albumsrecordingsmap' VALUES (11378, 13, 1134, 10712);
INSERT INTO 'albumsrecordingsmap' VALUES (11379, 14, 1134, 10713);
INSERT INTO 'albumsrecordingsmap' VALUES (11380, 15, 1134, 10714);
INSERT INTO 'albumsrecordingsmap' VALUES (11381, 16, 1134, 10715);
INSERT INTO 'albumsrecordingsmap' VALUES (11382, 17, 1134, 10716);
INSERT INTO 'albumsrecordingsmap' VALUES (11383, 18, 1134, 10717);
INSERT INTO 'albumsrecordingsmap' VALUES (11384, 1, 1163, 5116);
INSERT INTO 'albumsrecordingsmap' VALUES (11385, 2, 1163, 5117);
INSERT INTO 'albumsrecordingsmap' VALUES (11386, 3, 1163, 8365);
INSERT INTO 'albumsrecordingsmap' VALUES (11387, 4, 1163, 6050);
INSERT INTO 'albumsrecordingsmap' VALUES (11388, 5, 1163, 10718);
INSERT INTO 'albumsrecordingsmap' VALUES (11389, 6, 1163, 216);
INSERT INTO 'albumsrecordingsmap' VALUES (11390, 7, 1163, 8355);
INSERT INTO 'albumsrecordingsmap' VALUES (11391, 8, 1163, 787);
INSERT INTO 'albumsrecordingsmap' VALUES (11392, 9, 1163, 8362);
INSERT INTO 'albumsrecordingsmap' VALUES (11395, 12, 1163, 9844);
INSERT INTO 'albumsrecordingsmap' VALUES (11396, 13, 1163, 10721);
INSERT INTO 'albumsrecordingsmap' VALUES (11397, 14, 1163, 10722);
INSERT INTO 'albumsrecordingsmap' VALUES (11398, 15, 1163, 8353);
INSERT INTO 'albumsrecordingsmap' VALUES (2484, 13, 234, 2477);
INSERT INTO 'albumsrecordingsmap' VALUES (2485, 12, 234, 2478);
INSERT INTO 'albumsrecordingsmap' VALUES (2486, 11, 234, 2479);
INSERT INTO 'albumsrecordingsmap' VALUES (2487, 7, 234, 2480);
INSERT INTO 'albumsrecordingsmap' VALUES (2488, 9, 234, 2481);
INSERT INTO 'albumsrecordingsmap' VALUES (2489, 8, 234, 2482);
INSERT INTO 'albumsrecordingsmap' VALUES (2490, 10, 234, 2483);
INSERT INTO 'albumsrecordingsmap' VALUES (2491, 2, 234, 2484);
INSERT INTO 'albumsrecordingsmap' VALUES (2492, 1, 234, 2485);
INSERT INTO 'albumsrecordingsmap' VALUES (2493, 4, 234, 2486);
INSERT INTO 'albumsrecordingsmap' VALUES (2494, 3, 234, 2488);
INSERT INTO 'albumsrecordingsmap' VALUES (11399, 1, 1164, 10723);
INSERT INTO 'albumsrecordingsmap' VALUES (11400, 2, 1164, 10724);
INSERT INTO 'albumsrecordingsmap' VALUES (11401, 3, 1164, 10725);
INSERT INTO 'albumsrecordingsmap' VALUES (11402, 4, 1164, 10726);
INSERT INTO 'albumsrecordingsmap' VALUES (11403, 5, 1164, 10727);
INSERT INTO 'albumsrecordingsmap' VALUES (11404, 6, 1164, 10728);
INSERT INTO 'albumsrecordingsmap' VALUES (11405, 7, 1164, 10729);
INSERT INTO 'albumsrecordingsmap' VALUES (11406, 8, 1164, 10730);
INSERT INTO 'albumsrecordingsmap' VALUES (11407, 9, 1164, 10731);
INSERT INTO 'albumsrecordingsmap' VALUES (11408, 10, 1164, 10732);
INSERT INTO 'albumsrecordingsmap' VALUES (11409, 12, 1164, 10734);
INSERT INTO 'albumsrecordingsmap' VALUES (11410, 11, 1164, 10733);
INSERT INTO 'albumsrecordingsmap' VALUES (11411, 13, 1164, 10735);
INSERT INTO 'albumsrecordingsmap' VALUES (11412, 16, 1164, 10738);
INSERT INTO 'albumsrecordingsmap' VALUES (11413, 17, 1164, 10739);
INSERT INTO 'albumsrecordingsmap' VALUES (11414, 14, 1164, 10736);
INSERT INTO 'albumsrecordingsmap' VALUES (11415, 15, 1164, 10737);
INSERT INTO 'albumsrecordingsmap' VALUES (11416, 18, 1164, 10740);
INSERT INTO 'albumsrecordingsmap' VALUES (11417, 19, 1164, 10741);
INSERT INTO 'albumsrecordingsmap' VALUES (11418, 20, 1164, 10742);
INSERT INTO 'albumsrecordingsmap' VALUES (11419, 21, 1164, 10743);
INSERT INTO 'albumsrecordingsmap' VALUES (11420, 22, 1164, 10744);
INSERT INTO 'albumsrecordingsmap' VALUES (11421, 23, 1164, 10745);
INSERT INTO 'albumsrecordingsmap' VALUES (11422, 24, 1164, 10746);
INSERT INTO 'albumsrecordingsmap' VALUES (11423, 25, 1164, 10747);
INSERT INTO 'albumsrecordingsmap' VALUES (11424, 26, 1164, 10748);
INSERT INTO 'albumsrecordingsmap' VALUES (11425, 27, 1164, 10749);
INSERT INTO 'albumsrecordingsmap' VALUES (11426, 28, 1164, 10750);
INSERT INTO 'albumsrecordingsmap' VALUES (11427, 29, 1164, 10751);
INSERT INTO 'albumsrecordingsmap' VALUES (11428, 1, 1165, 10752);
INSERT INTO 'albumsrecordingsmap' VALUES (11429, 2, 1165, 10753);
INSERT INTO 'albumsrecordingsmap' VALUES (11430, 3, 1165, 10754);
INSERT INTO 'albumsrecordingsmap' VALUES (11431, 6, 1165, 10159);
INSERT INTO 'albumsrecordingsmap' VALUES (11433, 1, 1167, 10755);
INSERT INTO 'albumsrecordingsmap' VALUES (11434, 2, 1167, 10756);
INSERT INTO 'albumsrecordingsmap' VALUES (11435, 3, 1167, 10757);
INSERT INTO 'albumsrecordingsmap' VALUES (11437, 5, 1167, 10759);
INSERT INTO 'albumsrecordingsmap' VALUES (11439, 7, 1167, 10761);
INSERT INTO 'albumsrecordingsmap' VALUES (11440, 8, 1167, 10762);
INSERT INTO 'albumsrecordingsmap' VALUES (11441, 9, 1167, 10763);
INSERT INTO 'albumsrecordingsmap' VALUES (11438, 6, 1167, 10760);
INSERT INTO 'albumsrecordingsmap' VALUES (11442, 10, 1167, 10764);
INSERT INTO 'albumsrecordingsmap' VALUES (11443, 11, 1167, 10765);
INSERT INTO 'albumsrecordingsmap' VALUES (11444, 12, 1167, 10766);
INSERT INTO 'albumsrecordingsmap' VALUES (11445, 13, 1167, 10767);
INSERT INTO 'albumsrecordingsmap' VALUES (11446, 14, 1167, 10768);
INSERT INTO 'albumsrecordingsmap' VALUES (11447, 15, 1167, 10769);
INSERT INTO 'albumsrecordingsmap' VALUES (11448, 16, 1167, 10770);
INSERT INTO 'albumsrecordingsmap' VALUES (11449, 1, 1166, 10771);
INSERT INTO 'albumsrecordingsmap' VALUES (11450, 2, 1166, 10772);
INSERT INTO 'albumsrecordingsmap' VALUES (11451, 3, 1166, 10773);
INSERT INTO 'albumsrecordingsmap' VALUES (11452, 4, 1166, 10774);
INSERT INTO 'albumsrecordingsmap' VALUES (11453, 5, 1166, 10775);
INSERT INTO 'albumsrecordingsmap' VALUES (11454, 6, 1166, 10776);
INSERT INTO 'albumsrecordingsmap' VALUES (11455, 7, 1166, 10777);
INSERT INTO 'albumsrecordingsmap' VALUES (11456, 8, 1166, 10778);
INSERT INTO 'albumsrecordingsmap' VALUES (11457, 9, 1166, 10779);
INSERT INTO 'albumsrecordingsmap' VALUES (11458, 10, 1166, 10780);
INSERT INTO 'albumsrecordingsmap' VALUES (11459, 12, 1166, 10781);
INSERT INTO 'albumsrecordingsmap' VALUES (11460, 11, 1166, 10782);
INSERT INTO 'albumsrecordingsmap' VALUES (11436, 4, 1167, 10758);
INSERT INTO 'albumsrecordingsmap' VALUES (11461, 13, 1166, 10783);
INSERT INTO 'albumsrecordingsmap' VALUES (11462, 14, 1166, 10784);
INSERT INTO 'albumsrecordingsmap' VALUES (11463, 15, 1166, 10785);
INSERT INTO 'albumsrecordingsmap' VALUES (11464, 1, 1168, 10786);
INSERT INTO 'albumsrecordingsmap' VALUES (11465, 2, 1168, 10787);
INSERT INTO 'albumsrecordingsmap' VALUES (11466, 3, 1168, 10788);
INSERT INTO 'albumsrecordingsmap' VALUES (11467, 4, 1168, 10789);
INSERT INTO 'albumsrecordingsmap' VALUES (11468, 5, 1168, 10790);
INSERT INTO 'albumsrecordingsmap' VALUES (11469, 6, 1168, 10791);
INSERT INTO 'albumsrecordingsmap' VALUES (11470, 7, 1168, 10792);
INSERT INTO 'albumsrecordingsmap' VALUES (11471, 8, 1168, 10793);
INSERT INTO 'albumsrecordingsmap' VALUES (11472, 9, 1168, 10794);
INSERT INTO 'albumsrecordingsmap' VALUES (11473, 10, 1168, 10795);
INSERT INTO 'albumsrecordingsmap' VALUES (11474, 11, 1168, 10796);
INSERT INTO 'albumsrecordingsmap' VALUES (11475, 12, 1168, 10797);
INSERT INTO 'albumsrecordingsmap' VALUES (11476, 13, 1168, 10798);
INSERT INTO 'albumsrecordingsmap' VALUES (11477, 1, 1170, 10799);
INSERT INTO 'albumsrecordingsmap' VALUES (11478, 2, 1170, 10800);
INSERT INTO 'albumsrecordingsmap' VALUES (11479, 3, 1170, 10801);
INSERT INTO 'albumsrecordingsmap' VALUES (11480, 4, 1170, 10802);
INSERT INTO 'albumsrecordingsmap' VALUES (11481, 5, 1170, 10803);
INSERT INTO 'albumsrecordingsmap' VALUES (11482, 6, 1170, 10804);
INSERT INTO 'albumsrecordingsmap' VALUES (11483, 7, 1170, 10805);
INSERT INTO 'albumsrecordingsmap' VALUES (11484, 8, 1170, 10806);
INSERT INTO 'albumsrecordingsmap' VALUES (11485, 9, 1170, 10807);
INSERT INTO 'albumsrecordingsmap' VALUES (11486, 10, 1170, 10808);
INSERT INTO 'albumsrecordingsmap' VALUES (11487, 11, 1170, 10809);
INSERT INTO 'albumsrecordingsmap' VALUES (11488, 12, 1170, 10810);
INSERT INTO 'albumsrecordingsmap' VALUES (4615, 10, 725, 4389);
INSERT INTO 'albumsrecordingsmap' VALUES (5439, 9, 725, 1040);
INSERT INTO 'albumsrecordingsmap' VALUES (6365, 8, 725, 4387);
INSERT INTO 'albumsrecordingsmap' VALUES (6556, 6, 478, 6016);
INSERT INTO 'albumsrecordingsmap' VALUES (6557, 8, 478, 6017);
INSERT INTO 'albumsrecordingsmap' VALUES (6558, 9, 478, 6018);
INSERT INTO 'albumsrecordingsmap' VALUES (6559, 12, 478, 526);
INSERT INTO 'albumsrecordingsmap' VALUES (11489, 4, 478, 10811);
INSERT INTO 'albumsrecordingsmap' VALUES (11490, 5, 478, 8790);
INSERT INTO 'albumsrecordingsmap' VALUES (11491, 7, 478, 10812);
INSERT INTO 'albumsrecordingsmap' VALUES (11492, 10, 478, 10813);
INSERT INTO 'albumsrecordingsmap' VALUES (11493, 11, 478, 10814);
INSERT INTO 'albumsrecordingsmap' VALUES (11393, 11, 1163, 6866);
INSERT INTO 'albumsrecordingsmap' VALUES (11394, 10, 1163, 10720);
INSERT INTO 'albumsrecordingsmap' VALUES (11494, 1, 1171, 10815);
INSERT INTO 'albumsrecordingsmap' VALUES (11495, 2, 1171, 10816);
INSERT INTO 'albumsrecordingsmap' VALUES (11496, 3, 1171, 10817);
INSERT INTO 'albumsrecordingsmap' VALUES (11497, 4, 1171, 10818);
INSERT INTO 'albumsrecordingsmap' VALUES (11498, 5, 1171, 10819);
INSERT INTO 'albumsrecordingsmap' VALUES (11499, 6, 1171, 10820);
INSERT INTO 'albumsrecordingsmap' VALUES (11500, 7, 1171, 10821);
INSERT INTO 'albumsrecordingsmap' VALUES (11501, 8, 1171, 10822);
INSERT INTO 'albumsrecordingsmap' VALUES (11502, 9, 1171, 10823);
INSERT INTO 'albumsrecordingsmap' VALUES (11503, 10, 1171, 10824);
INSERT INTO 'albumsrecordingsmap' VALUES (11504, 11, 1171, 10825);
INSERT INTO 'albumsrecordingsmap' VALUES (11505, 12, 1171, 10826);
INSERT INTO 'albumsrecordingsmap' VALUES (11506, 13, 1171, 10827);
INSERT INTO 'albumsrecordingsmap' VALUES (11507, 14, 1171, 10828);
INSERT INTO 'albumsrecordingsmap' VALUES (11508, 15, 1171, 10829);
INSERT INTO 'albumsrecordingsmap' VALUES (11509, 1, 1172, 10830);
INSERT INTO 'albumsrecordingsmap' VALUES (11510, 2, 1172, 10831);
INSERT INTO 'albumsrecordingsmap' VALUES (11511, 3, 1172, 10832);
INSERT INTO 'albumsrecordingsmap' VALUES (11512, 4, 1172, 10833);
INSERT INTO 'albumsrecordingsmap' VALUES (11513, 5, 1172, 10834);
INSERT INTO 'albumsrecordingsmap' VALUES (11514, 6, 1172, 10835);
INSERT INTO 'albumsrecordingsmap' VALUES (11515, 7, 1172, 10836);
INSERT INTO 'albumsrecordingsmap' VALUES (11516, 8, 1172, 10837);
INSERT INTO 'albumsrecordingsmap' VALUES (11517, 9, 1172, 10838);
INSERT INTO 'albumsrecordingsmap' VALUES (11518, 10, 1172, 10839);
INSERT INTO 'albumsrecordingsmap' VALUES (11519, 1, 1173, 10840);
INSERT INTO 'albumsrecordingsmap' VALUES (11520, 2, 1173, 10841);
INSERT INTO 'albumsrecordingsmap' VALUES (11521, 3, 1173, 10842);
INSERT INTO 'albumsrecordingsmap' VALUES (11522, 4, 1173, 10843);
INSERT INTO 'albumsrecordingsmap' VALUES (11523, 5, 1173, 10844);
INSERT INTO 'albumsrecordingsmap' VALUES (11524, 6, 1173, 10845);
INSERT INTO 'albumsrecordingsmap' VALUES (11525, 7, 1173, 10846);
INSERT INTO 'albumsrecordingsmap' VALUES (11526, 8, 1173, 10847);
INSERT INTO 'albumsrecordingsmap' VALUES (11527, 9, 1173, 10848);
INSERT INTO 'albumsrecordingsmap' VALUES (11528, 10, 1173, 10849);
INSERT INTO 'albumsrecordingsmap' VALUES (11529, 11, 1173, 10850);
INSERT INTO 'albumsrecordingsmap' VALUES (11530, 12, 1173, 10851);
INSERT INTO 'albumsrecordingsmap' VALUES (11531, 13, 1173, 10852);
INSERT INTO 'albumsrecordingsmap' VALUES (11532, 1, 1174, 10853);
INSERT INTO 'albumsrecordingsmap' VALUES (11533, 2, 1174, 10854);
INSERT INTO 'albumsrecordingsmap' VALUES (11534, 3, 1174, 10855);
INSERT INTO 'albumsrecordingsmap' VALUES (11535, 4, 1174, 10856);
INSERT INTO 'albumsrecordingsmap' VALUES (11536, 5, 1174, 10857);
INSERT INTO 'albumsrecordingsmap' VALUES (11537, 6, 1174, 10858);
INSERT INTO 'albumsrecordingsmap' VALUES (11538, 7, 1174, 10859);
INSERT INTO 'albumsrecordingsmap' VALUES (11539, 8, 1174, 10860);
INSERT INTO 'albumsrecordingsmap' VALUES (11540, 9, 1174, 10861);
INSERT INTO 'albumsrecordingsmap' VALUES (11541, 10, 1174, 10862);
INSERT INTO 'albumsrecordingsmap' VALUES (11542, 11, 1174, 10863);
INSERT INTO 'albumsrecordingsmap' VALUES (11543, 12, 1174, 10864);
INSERT INTO 'albumsrecordingsmap' VALUES (11544, 13, 1174, 10865);
INSERT INTO 'albumsrecordingsmap' VALUES (11545, 14, 1174, 10866);
INSERT INTO 'albumsrecordingsmap' VALUES (11546, 15, 1174, 10867);
INSERT INTO 'albumsrecordingsmap' VALUES (11547, 16, 1174, 10868);
INSERT INTO 'albumsrecordingsmap' VALUES (11548, 17, 1174, 10869);
INSERT INTO 'albumsrecordingsmap' VALUES (11549, 18, 1174, 10870);
INSERT INTO 'albumsrecordingsmap' VALUES (11550, 19, 1174, 10871);
INSERT INTO 'albumsrecordingsmap' VALUES (11551, 20, 1174, 10872);
INSERT INTO 'albumsrecordingsmap' VALUES (11552, 21, 1174, 10873);
INSERT INTO 'albumsrecordingsmap' VALUES (11553, 22, 1174, 10874);
INSERT INTO 'albumsrecordingsmap' VALUES (11554, 23, 1174, 10875);
INSERT INTO 'albumsrecordingsmap' VALUES (11555, 24, 1174, 10876);
INSERT INTO 'albumsrecordingsmap' VALUES (11556, 25, 1174, 10877);
INSERT INTO 'albumsrecordingsmap' VALUES (11557, 26, 1174, 10878);
INSERT INTO 'albumsrecordingsmap' VALUES (11558, 27, 1174, 10879);
INSERT INTO 'albumsrecordingsmap' VALUES (11559, 28, 1174, 10880);
INSERT INTO 'albumsrecordingsmap' VALUES (11560, 29, 1174, 10881);
INSERT INTO 'albumsrecordingsmap' VALUES (11561, 30, 1174, 10882);
INSERT INTO 'albumsrecordingsmap' VALUES (11562, 31, 1174, 10883);
INSERT INTO 'albumsrecordingsmap' VALUES (11563, 1, 1175, 10884);
INSERT INTO 'albumsrecordingsmap' VALUES (11564, 2, 1175, 10885);
INSERT INTO 'albumsrecordingsmap' VALUES (11565, 3, 1175, 10886);
INSERT INTO 'albumsrecordingsmap' VALUES (11566, 4, 1175, 10887);
INSERT INTO 'albumsrecordingsmap' VALUES (11567, 5, 1175, 10888);
INSERT INTO 'albumsrecordingsmap' VALUES (11568, 6, 1175, 10889);
INSERT INTO 'albumsrecordingsmap' VALUES (11569, 7, 1175, 10890);
INSERT INTO 'albumsrecordingsmap' VALUES (11570, 8, 1175, 10891);
INSERT INTO 'albumsrecordingsmap' VALUES (11571, 9, 1175, 10892);
INSERT INTO 'albumsrecordingsmap' VALUES (11572, 10, 1175, 10893);
INSERT INTO 'albumsrecordingsmap' VALUES (11573, 11, 1175, 10894);
INSERT INTO 'albumsrecordingsmap' VALUES (11574, 12, 1175, 10895);
INSERT INTO 'albumsrecordingsmap' VALUES (11575, 1, 1176, 10896);
INSERT INTO 'albumsrecordingsmap' VALUES (11576, 2, 1176, 10897);
INSERT INTO 'albumsrecordingsmap' VALUES (11577, 3, 1176, 10898);
INSERT INTO 'albumsrecordingsmap' VALUES (11578, 4, 1176, 10899);
INSERT INTO 'albumsrecordingsmap' VALUES (11579, 5, 1176, 10900);
INSERT INTO 'albumsrecordingsmap' VALUES (11580, 6, 1176, 10901);
INSERT INTO 'albumsrecordingsmap' VALUES (11581, 7, 1176, 10902);
INSERT INTO 'albumsrecordingsmap' VALUES (11582, 8, 1176, 10903);
INSERT INTO 'albumsrecordingsmap' VALUES (11583, 9, 1176, 10904);
INSERT INTO 'albumsrecordingsmap' VALUES (11584, 10, 1176, 10905);
INSERT INTO 'albumsrecordingsmap' VALUES (11585, 11, 1176, 10906);
INSERT INTO 'albumsrecordingsmap' VALUES (11586, 12, 1176, 10907);
INSERT INTO 'albumsrecordingsmap' VALUES (11587, 13, 1176, 10908);
INSERT INTO 'albumsrecordingsmap' VALUES (11588, 1, 1177, 10909);
INSERT INTO 'albumsrecordingsmap' VALUES (11589, 3, 1177, 10911);
INSERT INTO 'albumsrecordingsmap' VALUES (11590, 2, 1177, 10910);
INSERT INTO 'albumsrecordingsmap' VALUES (11591, 4, 1177, 10912);
INSERT INTO 'albumsrecordingsmap' VALUES (11592, 5, 1177, 10913);
INSERT INTO 'albumsrecordingsmap' VALUES (11593, 6, 1177, 10914);
INSERT INTO 'albumsrecordingsmap' VALUES (11594, 1, 1178, 10915);
INSERT INTO 'albumsrecordingsmap' VALUES (11595, 2, 1178, 10916);
INSERT INTO 'albumsrecordingsmap' VALUES (11596, 3, 1178, 10917);
INSERT INTO 'albumsrecordingsmap' VALUES (11597, 4, 1178, 10918);
INSERT INTO 'albumsrecordingsmap' VALUES (11598, 5, 1178, 10919);
INSERT INTO 'albumsrecordingsmap' VALUES (11599, 6, 1178, 10920);
INSERT INTO 'albumsrecordingsmap' VALUES (11600, 7, 1178, 10921);
INSERT INTO 'albumsrecordingsmap' VALUES (11601, 8, 1178, 10922);
INSERT INTO 'albumsrecordingsmap' VALUES (11602, 9, 1178, 10923);
INSERT INTO 'albumsrecordingsmap' VALUES (11603, 10, 1178, 10924);
INSERT INTO 'albumsrecordingsmap' VALUES (11604, 11, 1178, 10925);
INSERT INTO 'albumsrecordingsmap' VALUES (11605, 12, 1178, 10926);
INSERT INTO 'albumsrecordingsmap' VALUES (11606, 13, 1178, 10927);
INSERT INTO 'albumsrecordingsmap' VALUES (11607, 14, 1178, 10928);
INSERT INTO 'albumsrecordingsmap' VALUES (11608, 15, 1178, 10929);
INSERT INTO 'albumsrecordingsmap' VALUES (11609, 16, 1178, 10930);
INSERT INTO 'albumsrecordingsmap' VALUES (11610, 17, 1178, 10931);
INSERT INTO 'albumsrecordingsmap' VALUES (11611, 18, 1178, 10932);
INSERT INTO 'albumsrecordingsmap' VALUES (11612, 19, 1178, 10933);
INSERT INTO 'albumsrecordingsmap' VALUES (11613, 1, 1179, 10934);
INSERT INTO 'albumsrecordingsmap' VALUES (11614, 2, 1179, 10935);
INSERT INTO 'albumsrecordingsmap' VALUES (11615, 3, 1179, 10936);
INSERT INTO 'albumsrecordingsmap' VALUES (11616, 4, 1179, 10937);
INSERT INTO 'albumsrecordingsmap' VALUES (11617, 2, 1180, 10940);
INSERT INTO 'albumsrecordingsmap' VALUES (11618, 1, 1180, 10939);
INSERT INTO 'albumsrecordingsmap' VALUES (11619, 3, 1180, 10941);
INSERT INTO 'albumsrecordingsmap' VALUES (11620, 4, 1180, 10942);
INSERT INTO 'albumsrecordingsmap' VALUES (11621, 5, 1180, 10943);
INSERT INTO 'albumsrecordingsmap' VALUES (11622, 6, 1180, 10944);
INSERT INTO 'albumsrecordingsmap' VALUES (11623, 7, 1180, 10945);
INSERT INTO 'albumsrecordingsmap' VALUES (11624, 8, 1180, 10946);
INSERT INTO 'albumsrecordingsmap' VALUES (11625, 9, 1180, 10947);
INSERT INTO 'albumsrecordingsmap' VALUES (11626, 10, 1180, 10948);
INSERT INTO 'albumsrecordingsmap' VALUES (11627, 11, 1180, 10949);
INSERT INTO 'albumsrecordingsmap' VALUES (11628, 12, 1180, 10950);
INSERT INTO 'albumsrecordingsmap' VALUES (11629, 13, 1180, 10951);
INSERT INTO 'albumsrecordingsmap' VALUES (11630, 14, 1180, 10952);
INSERT INTO 'albumsrecordingsmap' VALUES (11631, 15, 1180, 10953);
INSERT INTO 'albumsrecordingsmap' VALUES (11632, 16, 1180, 10954);
INSERT INTO 'albumsrecordingsmap' VALUES (11634, 18, 1180, 10956);
INSERT INTO 'albumsrecordingsmap' VALUES (11633, 17, 1180, 10955);
INSERT INTO 'albumsrecordingsmap' VALUES (2679, 4, 187, 2682);
INSERT INTO 'albumsrecordingsmap' VALUES (2680, 6, 187, 2683);
INSERT INTO 'albumsrecordingsmap' VALUES (11635, 5, 1165, 10957);
INSERT INTO 'albumsrecordingsmap' VALUES (11636, 4, 1165, 10958);
INSERT INTO 'albumsrecordingsmap' VALUES (11637, 7, 1165, 10959);
INSERT INTO 'albumsrecordingsmap' VALUES (11432, 9, 1165, 10961);
INSERT INTO 'albumsrecordingsmap' VALUES (11638, 8, 1165, 10960);
INSERT INTO 'albumsrecordingsmap' VALUES (11639, 10, 1165, 10962);
INSERT INTO 'albumsrecordingsmap' VALUES (11640, 11, 1165, 10963);
INSERT INTO 'albumsrecordingsmap' VALUES (11641, 13, 1165, 10964);
INSERT INTO 'albumsrecordingsmap' VALUES (11642, 12, 1165, 10965);
INSERT INTO 'albumsrecordingsmap' VALUES (11643, 14, 1165, 10966);
INSERT INTO 'albumsrecordingsmap' VALUES (11644, 15, 1165, 10967);
INSERT INTO 'albumsrecordingsmap' VALUES (11645, 16, 1165, 10968);
INSERT INTO 'albumsrecordingsmap' VALUES (11646, 7, 1182, 10969);
INSERT INTO 'albumsrecordingsmap' VALUES (11647, 9, 1182, 10970);
INSERT INTO 'albumsrecordingsmap' VALUES (11648, 10, 1182, 10971);
INSERT INTO 'albumsrecordingsmap' VALUES (11649, 11, 1182, 10972);
INSERT INTO 'albumsrecordingsmap' VALUES (11650, 12, 1182, 10973);
INSERT INTO 'albumsrecordingsmap' VALUES (11651, 14, 1182, 10974);
INSERT INTO 'albumsrecordingsmap' VALUES (11652, 15, 1182, 10975);
INSERT INTO 'albumsrecordingsmap' VALUES (11653, 16, 1182, 10976);
INSERT INTO 'albumsrecordingsmap' VALUES (11654, 19, 1182, 10977);
INSERT INTO 'albumsrecordingsmap' VALUES (11655, 3, 259, 10978);
INSERT INTO 'albumsrecordingsmap' VALUES (11656, 5, 259, 10979);
INSERT INTO 'albumsrecordingsmap' VALUES (11657, 1, 1183, 10980);
INSERT INTO 'albumsrecordingsmap' VALUES (11658, 2, 1183, 10981);
INSERT INTO 'albumsrecordingsmap' VALUES (11659, 3, 1183, 10982);
INSERT INTO 'albumsrecordingsmap' VALUES (11660, 4, 1183, 10983);
INSERT INTO 'albumsrecordingsmap' VALUES (11661, 5, 1183, 10984);
INSERT INTO 'albumsrecordingsmap' VALUES (11662, 6, 1183, 10985);
INSERT INTO 'albumsrecordingsmap' VALUES (11663, 7, 1183, 10986);
INSERT INTO 'albumsrecordingsmap' VALUES (11664, 8, 1183, 10987);
INSERT INTO 'albumsrecordingsmap' VALUES (11665, 9, 1183, 10988);
INSERT INTO 'albumsrecordingsmap' VALUES (11666, 10, 1183, 10989);
INSERT INTO 'albumsrecordingsmap' VALUES (11667, 11, 1183, 10990);
INSERT INTO 'albumsrecordingsmap' VALUES (11668, 12, 1183, 10991);
INSERT INTO 'albumsrecordingsmap' VALUES (11669, 13, 1183, 10992);
INSERT INTO 'albumsrecordingsmap' VALUES (11670, 14, 1183, 10993);
INSERT INTO 'albumsrecordingsmap' VALUES (11671, 15, 1183, 10994);
INSERT INTO 'albumsrecordingsmap' VALUES (11672, 16, 1183, 10995);
INSERT INTO 'albumsrecordingsmap' VALUES (11673, 1, 1184, 10996);
INSERT INTO 'albumsrecordingsmap' VALUES (11674, 2, 1184, 10997);
INSERT INTO 'albumsrecordingsmap' VALUES (11675, 3, 1184, 10998);
INSERT INTO 'albumsrecordingsmap' VALUES (11676, 4, 1184, 10999);
INSERT INTO 'albumsrecordingsmap' VALUES (11677, 5, 1184, 11000);
INSERT INTO 'albumsrecordingsmap' VALUES (11678, 6, 1184, 11001);
INSERT INTO 'albumsrecordingsmap' VALUES (11679, 7, 1184, 11002);
INSERT INTO 'albumsrecordingsmap' VALUES (11680, 8, 1184, 11003);
INSERT INTO 'albumsrecordingsmap' VALUES (11681, 9, 1184, 11004);
INSERT INTO 'albumsrecordingsmap' VALUES (11682, 10, 1184, 11005);
INSERT INTO 'albumsrecordingsmap' VALUES (11683, 11, 1184, 11006);
INSERT INTO 'albumsrecordingsmap' VALUES (11684, 12, 1184, 11007);
INSERT INTO 'albumsrecordingsmap' VALUES (11685, 13, 1184, 11008);
INSERT INTO 'albumsrecordingsmap' VALUES (11686, 14, 1184, 11009);
INSERT INTO 'albumsrecordingsmap' VALUES (11687, 1, 1185, 11010);
INSERT INTO 'albumsrecordingsmap' VALUES (11688, 2, 1185, 11011);
INSERT INTO 'albumsrecordingsmap' VALUES (11689, 3, 1185, 11012);
INSERT INTO 'albumsrecordingsmap' VALUES (11690, 4, 1185, 11013);
INSERT INTO 'albumsrecordingsmap' VALUES (11691, 6, 1185, 11015);
INSERT INTO 'albumsrecordingsmap' VALUES (11692, 7, 1185, 11016);
INSERT INTO 'albumsrecordingsmap' VALUES (11693, 8, 1185, 11017);
INSERT INTO 'albumsrecordingsmap' VALUES (11694, 5, 1185, 11014);
INSERT INTO 'albumsrecordingsmap' VALUES (11695, 9, 1185, 11018);
INSERT INTO 'albumsrecordingsmap' VALUES (11696, 10, 1185, 11019);
INSERT INTO 'albumsrecordingsmap' VALUES (11697, 11, 1185, 11020);
INSERT INTO 'albumsrecordingsmap' VALUES (11698, 12, 1185, 11021);
INSERT INTO 'albumsrecordingsmap' VALUES (11699, 13, 1185, 11022);
INSERT INTO 'albumsrecordingsmap' VALUES (11700, 14, 1185, 11023);
INSERT INTO 'albumsrecordingsmap' VALUES (11701, 15, 1185, 11024);
INSERT INTO 'albumsrecordingsmap' VALUES (11702, 16, 1185, 11025);
INSERT INTO 'albumsrecordingsmap' VALUES (11703, 1, 1187, 11026);
INSERT INTO 'albumsrecordingsmap' VALUES (11704, 2, 1187, 11027);
INSERT INTO 'albumsrecordingsmap' VALUES (11705, 3, 1187, 11028);
INSERT INTO 'albumsrecordingsmap' VALUES (11706, 4, 1187, 11029);
INSERT INTO 'albumsrecordingsmap' VALUES (11707, 5, 1187, 11030);
INSERT INTO 'albumsrecordingsmap' VALUES (11708, 1, 1186, 11031);
INSERT INTO 'albumsrecordingsmap' VALUES (11709, 2, 1186, 11032);
INSERT INTO 'albumsrecordingsmap' VALUES (11710, 3, 1186, 11033);
INSERT INTO 'albumsrecordingsmap' VALUES (11711, 4, 1186, 11034);
INSERT INTO 'albumsrecordingsmap' VALUES (11712, 5, 1186, 11035);
INSERT INTO 'albumsrecordingsmap' VALUES (11713, 6, 1186, 11036);
INSERT INTO 'albumsrecordingsmap' VALUES (11714, 1, 1188, 11037);
INSERT INTO 'albumsrecordingsmap' VALUES (11715, 2, 1188, 11038);
INSERT INTO 'albumsrecordingsmap' VALUES (11716, 3, 1188, 11039);
INSERT INTO 'albumsrecordingsmap' VALUES (11717, 4, 1188, 11040);
INSERT INTO 'albumsrecordingsmap' VALUES (11718, 5, 1188, 11041);
INSERT INTO 'albumsrecordingsmap' VALUES (11719, 6, 1188, 11042);
INSERT INTO 'albumsrecordingsmap' VALUES (11720, 7, 1188, 11043);
INSERT INTO 'albumsrecordingsmap' VALUES (11721, 8, 1188, 11044);
INSERT INTO 'albumsrecordingsmap' VALUES (11722, 9, 1188, 11045);
INSERT INTO 'albumsrecordingsmap' VALUES (11723, 10, 1188, 11046);
INSERT INTO 'albumsrecordingsmap' VALUES (11724, 11, 1188, 11047);
INSERT INTO 'albumsrecordingsmap' VALUES (11725, 12, 1188, 11048);
INSERT INTO 'albumsrecordingsmap' VALUES (11726, 13, 1188, 11049);
INSERT INTO 'albumsrecordingsmap' VALUES (11727, 14, 1188, 11050);
INSERT INTO 'albumsrecordingsmap' VALUES (11728, 15, 1188, 11051);
INSERT INTO 'albumsrecordingsmap' VALUES (11729, 1, 1189, 11052);
INSERT INTO 'albumsrecordingsmap' VALUES (11730, 2, 1189, 11053);
INSERT INTO 'albumsrecordingsmap' VALUES (11731, 3, 1189, 11054);
INSERT INTO 'albumsrecordingsmap' VALUES (11732, 4, 1189, 11055);
INSERT INTO 'albumsrecordingsmap' VALUES (11733, 5, 1189, 11056);
INSERT INTO 'albumsrecordingsmap' VALUES (11734, 6, 1189, 11057);
INSERT INTO 'albumsrecordingsmap' VALUES (11735, 7, 1189, 11058);
INSERT INTO 'albumsrecordingsmap' VALUES (11736, 8, 1189, 11059);
INSERT INTO 'albumsrecordingsmap' VALUES (11737, 9, 1189, 11060);
INSERT INTO 'albumsrecordingsmap' VALUES (11738, 10, 1189, 11061);
INSERT INTO 'albumsrecordingsmap' VALUES (11739, 11, 1189, 11062);
INSERT INTO 'albumsrecordingsmap' VALUES (11740, 12, 1189, 11063);
INSERT INTO 'albumsrecordingsmap' VALUES (10607, 1, 1099, 10016);
INSERT INTO 'albumsrecordingsmap' VALUES (10615, 9, 1099, 10022);
INSERT INTO 'albumsrecordingsmap' VALUES (11741, 1, 1190, 11064);
INSERT INTO 'albumsrecordingsmap' VALUES (11742, 2, 1190, 11065);
INSERT INTO 'albumsrecordingsmap' VALUES (11743, 3, 1190, 11066);
INSERT INTO 'albumsrecordingsmap' VALUES (11744, 4, 1190, 11067);
INSERT INTO 'albumsrecordingsmap' VALUES (11745, 5, 1190, 11068);
INSERT INTO 'albumsrecordingsmap' VALUES (11746, 6, 1190, 11069);
INSERT INTO 'albumsrecordingsmap' VALUES (11747, 7, 1190, 11070);
INSERT INTO 'albumsrecordingsmap' VALUES (11748, 8, 1190, 11071);
INSERT INTO 'albumsrecordingsmap' VALUES (11749, 9, 1190, 11072);
INSERT INTO 'albumsrecordingsmap' VALUES (11750, 10, 1190, 11073);
INSERT INTO 'albumsrecordingsmap' VALUES (11751, 11, 1190, 11074);
INSERT INTO 'albumsrecordingsmap' VALUES (11752, 12, 1190, 11075);
INSERT INTO 'albumsrecordingsmap' VALUES (11753, 1, 1191, 11076);
INSERT INTO 'albumsrecordingsmap' VALUES (11754, 2, 1191, 11077);
INSERT INTO 'albumsrecordingsmap' VALUES (11755, 3, 1191, 11078);
INSERT INTO 'albumsrecordingsmap' VALUES (11756, 7, 1191, 11079);
INSERT INTO 'albumsrecordingsmap' VALUES (11757, 11, 1191, 11080);
INSERT INTO 'albumsrecordingsmap' VALUES (11758, 13, 1191, 11081);
INSERT INTO 'albumsrecordingsmap' VALUES (11759, 10, 152, 11082);
INSERT INTO 'albumsrecordingsmap' VALUES (11760, 3, 333, 11082);
INSERT INTO 'albumsrecordingsmap' VALUES (11761, 14, 728, 11082);
INSERT INTO 'albumsrecordingsmap' VALUES (11762, 1, 1192, 11083);
INSERT INTO 'albumsrecordingsmap' VALUES (11763, 2, 1192, 11084);
INSERT INTO 'albumsrecordingsmap' VALUES (11764, 3, 1192, 11085);
INSERT INTO 'albumsrecordingsmap' VALUES (11765, 4, 1192, 11086);
INSERT INTO 'albumsrecordingsmap' VALUES (11766, 5, 1192, 11087);
INSERT INTO 'albumsrecordingsmap' VALUES (11767, 6, 1192, 11088);
INSERT INTO 'albumsrecordingsmap' VALUES (11768, 7, 1192, 11089);
INSERT INTO 'albumsrecordingsmap' VALUES (11769, 8, 1192, 11090);
INSERT INTO 'albumsrecordingsmap' VALUES (11770, 9, 1192, 11091);
INSERT INTO 'albumsrecordingsmap' VALUES (11771, 10, 1192, 11092);
INSERT INTO 'albumsrecordingsmap' VALUES (11772, 11, 1192, 11093);
INSERT INTO 'albumsrecordingsmap' VALUES (11773, 12, 1192, 11094);
INSERT INTO 'albumsrecordingsmap' VALUES (11774, 13, 1192, 11095);
INSERT INTO 'albumsrecordingsmap' VALUES (11775, 14, 1192, 11096);
INSERT INTO 'albumsrecordingsmap' VALUES (11776, 15, 1192, 11097);
INSERT INTO 'albumsrecordingsmap' VALUES (11777, 16, 1192, 11098);
INSERT INTO 'albumsrecordingsmap' VALUES (11778, 17, 1146, 10590);
INSERT INTO 'albumsrecordingsmap' VALUES (11780, 1, 1193, 11099);
INSERT INTO 'albumsrecordingsmap' VALUES (11781, 2, 1193, 11100);
INSERT INTO 'albumsrecordingsmap' VALUES (11782, 3, 1193, 11101);
INSERT INTO 'albumsrecordingsmap' VALUES (11783, 4, 1193, 11102);
INSERT INTO 'albumsrecordingsmap' VALUES (11784, 5, 1193, 11103);
INSERT INTO 'albumsrecordingsmap' VALUES (11785, 6, 1193, 11104);
INSERT INTO 'albumsrecordingsmap' VALUES (11786, 1, 1194, 11105);
INSERT INTO 'albumsrecordingsmap' VALUES (11787, 2, 1194, 11106);
INSERT INTO 'albumsrecordingsmap' VALUES (11788, 3, 1194, 11107);
INSERT INTO 'albumsrecordingsmap' VALUES (11789, 4, 1194, 11108);
INSERT INTO 'albumsrecordingsmap' VALUES (11790, 5, 1194, 11109);
INSERT INTO 'albumsrecordingsmap' VALUES (11791, 6, 1194, 11110);
INSERT INTO 'albumsrecordingsmap' VALUES (11792, 7, 1194, 11111);
INSERT INTO 'albumsrecordingsmap' VALUES (11793, 8, 1194, 11112);
INSERT INTO 'albumsrecordingsmap' VALUES (11794, 9, 1194, 11113);
INSERT INTO 'albumsrecordingsmap' VALUES (11795, 10, 1194, 11114);
INSERT INTO 'albumsrecordingsmap' VALUES (11796, 11, 1194, 11115);
INSERT INTO 'albumsrecordingsmap' VALUES (11797, 12, 1194, 11116);
INSERT INTO 'albumsrecordingsmap' VALUES (11798, 13, 1194, 11117);
INSERT INTO 'albumsrecordingsmap' VALUES (11799, 14, 1194, 11118);
INSERT INTO 'albumsrecordingsmap' VALUES (11800, 15, 1194, 11119);
INSERT INTO 'albumsrecordingsmap' VALUES (11801, 16, 1194, 11120);
INSERT INTO 'albumsrecordingsmap' VALUES (11802, 17, 1194, 11121);
INSERT INTO 'albumsrecordingsmap' VALUES (11803, 18, 1194, 11122);
INSERT INTO 'albumsrecordingsmap' VALUES (11804, 19, 1194, 11128);
INSERT INTO 'albumsrecordingsmap' VALUES (11805, 20, 1194, 11124);
INSERT INTO 'albumsrecordingsmap' VALUES (11806, 21, 1194, 11125);
INSERT INTO 'albumsrecordingsmap' VALUES (11807, 22, 1194, 11126);
INSERT INTO 'albumsrecordingsmap' VALUES (11808, 23, 1194, 11127);
INSERT INTO 'albumsrecordingsmap' VALUES (11809, 24, 1194, 11128);
INSERT INTO 'albumsrecordingsmap' VALUES (11810, 1, 1195, 11129);
INSERT INTO 'albumsrecordingsmap' VALUES (11811, 2, 1195, 11130);
INSERT INTO 'albumsrecordingsmap' VALUES (11812, 3, 1195, 11131);
INSERT INTO 'albumsrecordingsmap' VALUES (11813, 4, 1195, 11132);
INSERT INTO 'albumsrecordingsmap' VALUES (11814, 5, 1195, 11133);
INSERT INTO 'albumsrecordingsmap' VALUES (11815, 6, 1195, 11134);
INSERT INTO 'albumsrecordingsmap' VALUES (11816, 7, 1195, 11135);
INSERT INTO 'albumsrecordingsmap' VALUES (11817, 8, 1195, 11136);
INSERT INTO 'albumsrecordingsmap' VALUES (11818, 9, 1195, 11137);
INSERT INTO 'albumsrecordingsmap' VALUES (11819, 10, 1195, 11138);
INSERT INTO 'albumsrecordingsmap' VALUES (11820, 11, 1195, 11139);
INSERT INTO 'albumsrecordingsmap' VALUES (11821, 12, 1195, 11140);
INSERT INTO 'albumsrecordingsmap' VALUES (11822, 13, 1195, 11141);
INSERT INTO 'albumsrecordingsmap' VALUES (11823, 14, 1195, 11142);
INSERT INTO 'albumsrecordingsmap' VALUES (11824, 15, 1195, 11143);
INSERT INTO 'albumsrecordingsmap' VALUES (11825, 16, 1195, 11144);
INSERT INTO 'albumsrecordingsmap' VALUES (11826, 17, 1195, 11145);
INSERT INTO 'albumsrecordingsmap' VALUES (11827, 18, 1195, 11146);
INSERT INTO 'albumsrecordingsmap' VALUES (11828, 19, 1195, 11147);
INSERT INTO 'albumsrecordingsmap' VALUES (11829, 20, 1195, 11148);
INSERT INTO 'albumsrecordingsmap' VALUES (11830, 21, 1195, 11149);
INSERT INTO 'albumsrecordingsmap' VALUES (11831, 22, 1195, 11150);
INSERT INTO 'albumsrecordingsmap' VALUES (11832, 23, 1195, 11151);
INSERT INTO 'albumsrecordingsmap' VALUES (11848, 1, 1196, 11152);
INSERT INTO 'albumsrecordingsmap' VALUES (11849, 2, 1196, 11153);
INSERT INTO 'albumsrecordingsmap' VALUES (11850, 3, 1196, 11154);
INSERT INTO 'albumsrecordingsmap' VALUES (11851, 4, 1196, 11155);
INSERT INTO 'albumsrecordingsmap' VALUES (11852, 5, 1196, 11156);
INSERT INTO 'albumsrecordingsmap' VALUES (11853, 6, 1196, 11157);
INSERT INTO 'albumsrecordingsmap' VALUES (11854, 7, 1196, 11158);
INSERT INTO 'albumsrecordingsmap' VALUES (11855, 8, 1196, 11159);
INSERT INTO 'albumsrecordingsmap' VALUES (11856, 9, 1196, 11160);
INSERT INTO 'albumsrecordingsmap' VALUES (11857, 11, 1196, 11162);
INSERT INTO 'albumsrecordingsmap' VALUES (11858, 12, 1196, 11163);
INSERT INTO 'albumsrecordingsmap' VALUES (11859, 10, 1196, 11161);
INSERT INTO 'albumsrecordingsmap' VALUES (11860, 13, 1196, 11164);
INSERT INTO 'albumsrecordingsmap' VALUES (11861, 14, 1196, 11165);
INSERT INTO 'albumsrecordingsmap' VALUES (11862, 13, 276, 11166);


--
INSERT INTO 'couples' VALUES (105, '6 couples (4x,5x,6x)');
INSERT INTO 'couples' VALUES (108, '16 couples');
INSERT INTO 'couples' VALUES (109, '2 couples (1x)');
INSERT INTO 'couples' VALUES (110, '3 couples (1x)');
INSERT INTO 'couples' VALUES (111, '9 persons');
INSERT INTO 'couples' VALUES (112, '7 persons');
INSERT INTO 'couples' VALUES (101, '4w+2m');
INSERT INTO 'couples' VALUES (1, '1 couple');
INSERT INTO 'couples' VALUES (2, '2 couples');
INSERT INTO 'couples' VALUES (3, '3 couples');
INSERT INTO 'couples' VALUES (4, '4 couples');
INSERT INTO 'couples' VALUES (5, '5 couples');
INSERT INTO 'couples' VALUES (6, '6 couples');
INSERT INTO 'couples' VALUES (7, '7 couples');
INSERT INTO 'couples' VALUES (8, '8 couples');
INSERT INTO 'couples' VALUES (51, '1 person');
INSERT INTO 'couples' VALUES (53, '3 persons');
INSERT INTO 'couples' VALUES (54, '4 persons');
INSERT INTO 'couples' VALUES (55, '5 persons');
INSERT INTO 'couples' VALUES (56, '2 trios');
INSERT INTO 'couples' VALUES (99, 'unknown');
INSERT INTO 'couples' VALUES (100, '4 couples (3x,4x)');
INSERT INTO 'couples' VALUES (102, '4 couples (2x,4x)');
INSERT INTO 'couples' VALUES (104, '3 couples (2x)');
INSERT INTO 'couples' VALUES (114, '4 couples (1x,3x)');
INSERT INTO 'couples' VALUES (115, '12 persons');
INSERT INTO 'couples' VALUES (116, '4 couples (1x,2x)');
INSERT INTO 'couples' VALUES (106, '2 couples (Glasgow Highl)');
INSERT INTO 'couples' VALUES (107, '4 couples (Glasgow Highl)');
INSERT INTO 'couples' VALUES (117, '6 persons');
INSERT INTO 'couples' VALUES (118, '3 trios');
INSERT INTO 'couples' VALUES (130, '4 couples (1x,4x)');
INSERT INTO 'couples' VALUES (113, 'any');
INSERT INTO 'couples' VALUES (119, '4 trios');
INSERT INTO 'couples' VALUES (120, '3 couples (3x)');
INSERT INTO 'couples' VALUES (121, '3 couples (1x,2x)');
INSERT INTO 'couples' VALUES (122, '8 persons');
INSERT INTO 'couples' VALUES (98, 'other');
INSERT INTO 'couples' VALUES (124, '>8 couples');
INSERT INTO 'couples' VALUES (125, '2 couples (2x)');
INSERT INTO 'couples' VALUES (126, '>9 persons');
INSERT INTO 'couples' VALUES (127, '4 couples (4x)');
INSERT INTO 'couples' VALUES (128, '4 couples (2x,3x)');
INSERT INTO 'couples' VALUES (129, '5 couples (2x,4x)');
INSERT INTO 'couples' VALUES (132, '3 couples (1x,3x)');
INSERT INTO 'couples' VALUES (133, '6 couples (2x,4x,6x)');
INSERT INTO 'couples' VALUES (134, '3 couples (2x,3x)');
INSERT INTO 'couples' VALUES (135, '2 persons');
INSERT INTO 'couples' VALUES (137, '5 couples (4x,5x)');
INSERT INTO 'couples' VALUES (138, '4 couples (1x)');


--
INSERT INTO 'couplesshape' VALUES (43, '4P/SQ', 54, 4);
INSERT INTO 'couplesshape' VALUES (44, '4P/RR', 54, 5);
INSERT INTO 'couplesshape' VALUES (1, '1C/4', 1, 1);
INSERT INTO 'couplesshape' VALUES (45, '4P/tri', 54, 6);
INSERT INTO 'couplesshape' VALUES (2, 'RR', 1, 5);
INSERT INTO 'couplesshape' VALUES (46, '4P/6', 54, 8);
INSERT INTO 'couplesshape' VALUES (47, '5P/4', 55, 1);
INSERT INTO 'couplesshape' VALUES (3, '1C/Circle', 1, 7);
INSERT INTO 'couplesshape' VALUES (48, '5P/SQ', 55, 4);
INSERT INTO 'couplesshape' VALUES (4, '1C', 1, 11);
INSERT INTO 'couplesshape' VALUES (49, '5P/RR', 55, 5);
INSERT INTO 'couplesshape' VALUES (50, '5P', 55, 11);
INSERT INTO 'couplesshape' VALUES (5, '2C/4', 2, 1);
INSERT INTO 'couplesshape' VALUES (51, '3P-3/RR', 56, 5);
INSERT INTO 'couplesshape' VALUES (6, '2C/3', 2, 2);
INSERT INTO 'couplesshape' VALUES (52, '3P-3/circl', 56, 7);
INSERT INTO 'couplesshape' VALUES (53, '3P-3', 56, 11);
INSERT INTO 'couplesshape' VALUES (7, '2C/square', 2, 4);
INSERT INTO 'couplesshape' VALUES (54, '?', 99, 1);
INSERT INTO 'couplesshape' VALUES (55, '?', 99, 4);
INSERT INTO 'couplesshape' VALUES (56, '?', 99, 6);
INSERT INTO 'couplesshape' VALUES (57, '?', 99, 7);
INSERT INTO 'couplesshape' VALUES (58, '?', 99, 11);
INSERT INTO 'couplesshape' VALUES (8, '2C/RR', 2, 5);
INSERT INTO 'couplesshape' VALUES (9, '2C/Circle', 2, 7);
INSERT INTO 'couplesshape' VALUES (10, '2C', 2, 11);
INSERT INTO 'couplesshape' VALUES (11, '3C/4', 3, 1);
INSERT INTO 'couplesshape' VALUES (12, '3C/3', 3, 2);
INSERT INTO 'couplesshape' VALUES (13, '3C/5', 3, 3);
INSERT INTO 'couplesshape' VALUES (14, '3C/square', 3, 4);
INSERT INTO 'couplesshape' VALUES (15, '3C/RR', 3, 5);
INSERT INTO 'couplesshape' VALUES (16, 'Triang.', 3, 6);
INSERT INTO 'couplesshape' VALUES (17, '3C/7', 3, 9);
INSERT INTO 'couplesshape' VALUES (18, '3C', 3, 11);
INSERT INTO 'couplesshape' VALUES (19, '4C/4', 4, 1);
INSERT INTO 'couplesshape' VALUES (20, '4C/5', 4, 3);
INSERT INTO 'couplesshape' VALUES (21, 'SQ', 4, 4);
INSERT INTO 'couplesshape' VALUES (22, '4C/RR', 4, 5);
INSERT INTO 'couplesshape' VALUES (23, '4C/Tri', 4, 6);
INSERT INTO 'couplesshape' VALUES (24, '4C', 4, 11);
INSERT INTO 'couplesshape' VALUES (25, '5C/5', 5, 3);
INSERT INTO 'couplesshape' VALUES (26, '5C/SQ', 5, 4);
INSERT INTO 'couplesshape' VALUES (27, '5C/RR', 5, 5);
INSERT INTO 'couplesshape' VALUES (28, '5C/circle', 5, 7);
INSERT INTO 'couplesshape' VALUES (29, '5C', 5, 11);
INSERT INTO 'couplesshape' VALUES (30, '6C/SQ', 6, 4);
INSERT INTO 'couplesshape' VALUES (31, '6C/circle', 6, 7);
INSERT INTO 'couplesshape' VALUES (32, '6C/6', 6, 8);
INSERT INTO 'couplesshape' VALUES (33, '6C', 6, 11);
INSERT INTO 'couplesshape' VALUES (34, '7C/7', 7, 9);
INSERT INTO 'couplesshape' VALUES (35, '8C/SQ', 8, 4);
INSERT INTO 'couplesshape' VALUES (36, '8C', 8, 11);
INSERT INTO 'couplesshape' VALUES (37, '1P/4', 51, 1);
INSERT INTO 'couplesshape' VALUES (38, '3P/4', 53, 1);
INSERT INTO 'couplesshape' VALUES (39, '3P/RR', 53, 5);
INSERT INTO 'couplesshape' VALUES (40, '3P/tri', 53, 6);
INSERT INTO 'couplesshape' VALUES (41, '3P', 53, 11);
INSERT INTO 'couplesshape' VALUES (42, '4P/4', 54, 1);


--
INSERT INTO 'dance' VALUES (18396, '2018-07-13 09:52:29.547919+00', '2018-07-13 09:52:29.547919+00', 'Metamorphosis', 'METAMORPHOSIS', 40, -1, -1, '', NULL, 0, 0, 0, 0, '', 4, 11659, NULL, NULL, 1, 2);
INSERT INTO 'dance' VALUES (4, '1997-08-28 22:00:00+00', '2012-01-20 12:55:59.955314+00', 'A'' Dol Suiridhe', 'A DOL SUIRIDHE', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 4, 607, 9999, NULL, 1, 3);
INSERT INTO 'dance' VALUES (5, '1997-04-03 22:00:00+00', '2012-01-20 12:55:59.962458+00', 'A'' the Marquis''s', 'A THE MARQUISS', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 4, 35, 9999, NULL, 1, 3);
INSERT INTO 'dance' VALUES (38, '1997-08-28 22:00:00+00', '2019-09-13 19:16:25.254153+00', 'Adelaide Grand Prix', 'ADELAIDE GRAND PRIX', 32, -1, -1, '', NULL, 0, 1, 0, 0, '', 4, 605, 9999, 1, 1, 1);
INSERT INTO 'dance' VALUES (12, '2003-01-26 23:00:00+00', '2012-01-20 12:56:00.025897+00', 'Aberdeen to Zorra', 'ABERDEEN TO ZORRA', 32, -1, -1, '', NULL, 1, 1, 1, 1, '', 4, 35, 9999, 1, 1, 3);
INSERT INTO 'dance' VALUES (17, '1998-04-20 22:00:00+00', '2012-01-20 12:56:00.072818+00', 'Academy, The', 'ACADEMY', 32, -1, -1, '', NULL, 1, 1, 1, 1, '', 2, 44, 40, NULL, 1, 4);
INSERT INTO 'dance' VALUES (19, '1997-04-03 22:00:00+00', '2012-01-20 12:56:00.090382+00', 'Accounting For Time', 'ACCOUNTING FOR TIME', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 4, 360, 9999, NULL, 1, 3);
INSERT INTO 'dance' VALUES (3755, '1997-08-26 22:00:00+00', '2019-03-15 10:00:01.428299+00', 'Lawson''s Lady', 'LAWSONS LADY', 32, 71, -1, '880/855/855/844', '1995-01-01', 0, 1, 0, 0, '', 3, 553, 9999, 17, 2, 3);
INSERT INTO 'dance' VALUES (2611, '1997-04-03 22:00:00+00', '2019-03-16 16:28:07.456831+00', 'Gordon Chase, The', 'GORDON CHASE', 80, 100, -1, '8888/8888/8888/8888/8888/8888/8888/8888/8888/8888', '1988-01-01', 0, 1, 0, 0, '', 4, 108, 9999, 3, 4, 3);
INSERT INTO 'dance' VALUES (25, '1997-08-28 22:00:00+00', '2012-01-20 12:56:00.143018+00', 'Achnamara', 'ACHNAMARA', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 4, 602, 9999, NULL, 1, 3);
INSERT INTO 'dance' VALUES (26, '1997-08-28 22:00:00+00', '2012-01-20 12:56:00.151706+00', 'Achnasheen', 'ACHNASHEEN', 48, -1, -1, '', NULL, 0, 0, 0, 0, '', 4, 28, 9999, NULL, 4, 3);
INSERT INTO 'dance' VALUES (27, '1997-08-28 22:00:00+00', '2012-01-20 12:56:00.160394+00', 'Ackergill Agreement', 'ACKERGILL AGREEMENT', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 4, 603, 9999, NULL, 1, 1);
INSERT INTO 'dance' VALUES (18398, '2018-07-13 10:05:21.12156+00', '2019-05-01 08:30:01.084364+00', 'Memento, The', 'MEMENTO', 32, 34, -1, '802/806/800/822', NULL, 1, 1, 0, 0, '', 3, 11662, NULL, 42, 1, 2);
INSERT INTO 'dance' VALUES (2612, '1998-04-12 22:00:00+00', '2012-01-20 12:56:20.879056+00', 'Gordon Highlanders', 'GORDON HIGHLANDERS', 40, -1, -1, '', '1990-01-01', 0, 0, 0, 0, '', 4, 313, 9999, NULL, 1, 2);
INSERT INTO 'dance' VALUES (2614, '1997-09-03 22:00:00+00', '2012-01-20 12:56:20.896634+00', 'Heather in a Mist', 'HEATHER IN A MIST', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 4, 729, 9999, NULL, 4, 1);
INSERT INTO 'dance' VALUES (2615, '1997-04-03 22:00:00+00', '2012-01-20 12:56:20.90594+00', 'Gosford House Jig', 'GOSFORD HOUSE JIG', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 4, 107, 9999, NULL, 1, 2);
INSERT INTO 'dance' VALUES (3754, '1997-09-07 22:00:00+00', '2012-01-20 12:56:30.515966+00', 'Lawrence Centenary Medley', 'LAWRENCE CENTENARY MEDLEY', 128, -1, -1, '', NULL, 0, 0, 0, 0, '', 4, 48, 9999, NULL, 4, 4);
INSERT INTO 'dance' VALUES (3758, '1999-04-21 22:00:00+00', '2012-01-20 12:56:30.543617+00', 'Grand Jour, Le', 'GRAND JOUR', 32, -1, -1, '', '1990-01-01', 0, 0, 0, 0, '', 3, 23, 9999, NULL, 2, 3);
INSERT INTO 'dance' VALUES (3760, '1997-09-07 22:00:00+00', '2012-01-20 12:56:30.557295+00', 'Leading Lady', 'LEADING LADY', 48, -1, -1, '', NULL, 0, 0, 0, 0, '', 4, 1067, 9999, NULL, 1, 2);
INSERT INTO 'dance' VALUES (7, '1997-04-03 22:00:00+00', '2018-04-03 00:07:29.38674+00', 'Abbess, The', 'ABBESS', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 3, 27, 9999, 42, 1, 1);
INSERT INTO 'dance' VALUES (33, '2002-02-21 23:00:00+00', '2012-01-20 12:56:00.213743+00', 'Across the Tay Bridge', 'ACROSS THE TAY BRIDGE', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 4, 173, 9999, NULL, 1, 3);
INSERT INTO 'dance' VALUES (35, '1997-08-28 22:00:00+00', '2012-01-20 12:56:00.231087+00', 'Adam Buchan O!', 'ADAM BUCHAN O', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 3, 270, 9999, NULL, 2, 1);
INSERT INTO 'dance' VALUES (8, '1997-08-28 22:00:00+00', '2018-04-03 00:07:29.450245+00', 'Abbey Craig', 'ABBEY CRAIG', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 3, 346, 9999, 42, 1, 3);
INSERT INTO 'dance' VALUES (23, '1997-04-03 22:00:00+00', '2018-04-03 00:07:29.531539+00', 'Achnacloich', 'ACHNACLOICH', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 3, 3, 9999, 42, 1, 3);
INSERT INTO 'dance' VALUES (24, '1997-04-03 22:00:00+00', '2018-04-03 00:07:29.539945+00', 'Achnahennich', 'ACHNAHENNICH', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 3, 270, 9999, 42, 1, 3);
INSERT INTO 'dance' VALUES (21, '2002-03-02 23:00:00+00', '2018-04-03 00:07:29.548307+00', 'Achtilbuie', 'ACHTILBUIE', 40, -1, -1, '', NULL, 1, 1, 1, 1, '', 3, 26, 9999, 42, 1, 2);
INSERT INTO 'dance' VALUES (31, '2002-02-21 23:00:00+00', '2018-04-03 00:07:29.581805+00', 'Across the High C''s', 'ACROSS THE HIGH CS', 32, -1, -1, '', '1991-01-01', 0, 0, 0, 0, '', 3, 23, 9999, 42, 1, 1);
INSERT INTO 'dance' VALUES (34, '2002-02-21 23:00:00+00', '2018-04-03 00:07:29.632073+00', 'Across the Tweed', 'ACROSS THE TWEED', 40, -1, -1, '', NULL, 0, 0, 0, 0, '', 3, 28, 9999, 42, 1, 1);
INSERT INTO 'dance' VALUES (36, '2003-01-28 23:00:00+00', '2018-04-03 00:07:29.656798+00', 'Adam Fergusson''s Reel', 'ADAM FERGUSSONS REEL', 32, -1, -1, '', '1984-01-01', 1, 1, 1, 1, '', 3, 35, 9999, 42, 1, 1);
INSERT INTO 'dance' VALUES (37, '1998-09-04 22:00:00+00', '2018-04-03 00:07:29.665099+00', 'Adam Forrester of Knocksheen''s Night Out', 'ADAM FORRESTER OF KNOCKSHEENS NIGHT OUT', 32, -1, -1, '', NULL, 1, 1, 1, 1, '', 3, 210, 9999, 42, 1, 2);
INSERT INTO 'dance' VALUES (3, '1997-08-28 22:00:00+00', '2018-04-03 00:07:29.673488+00', 'A'' Dannsadh An Aghaidh an t-Struith', 'A DANNSADH AN AGHAIDH AN TSTRUITH', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 3, 264, 9999, 42, 1, 3);
INSERT INTO 'dance' VALUES (3757, '1997-09-01 22:00:00+00', '2018-04-03 00:07:41.633397+00', 'Debauche, Le', 'DEBAUCHE', 48, -1, -1, '', '1757-01-01', 0, 0, 0, 0, '', 3, 198, 9999, 42, 1, 1);
INSERT INTO 'dance' VALUES (2609, '1997-04-03 22:00:00+00', '2018-04-03 00:07:49.40753+00', 'Gopher''s Reel, The', 'GOPHERS REEL', 32, -1, -1, '', NULL, 1, 1, 1, 1, '', 3, 35, 9999, 42, 1, 1);
INSERT INTO 'dance' VALUES (3756, '1997-07-16 22:00:00+00', '2018-04-03 00:07:59.187668+00', 'Lazy Jean', 'LAZY JEAN', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 3, 259, 9999, 42, 1, 3);
INSERT INTO 'dance' VALUES (3761, '1997-09-07 22:00:00+00', '2018-04-03 00:07:59.223142+00', 'Leamington Lassies And Lads', 'LEAMINGTON LASSIES AND LADS', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 3, 1068, 9999, 42, 1, 2);
INSERT INTO 'dance' VALUES (10323, '2002-01-08 23:00:00+00', '2018-04-03 00:08:05.143974+00', 'Monday Evening', 'MONDAY EVENING', 40, -1, -1, '', NULL, 0, 0, 0, 0, '', 3, 1038, 9999, 42, 1, 3);
INSERT INTO 'dance' VALUES (39, '1998-04-04 22:00:00+00', '2012-01-20 12:56:00.265983+00', 'Adelaide''s Welcome to John Drewry', 'ADELAIDES WELCOME TO JOHN DREWRY', 48, -1, -1, '', NULL, 0, 0, 0, 0, '', 4, 711, 9999, NULL, 1, 2);
INSERT INTO 'dance' VALUES (42, '1998-01-05 23:00:00+00', '2012-01-20 12:56:00.292159+00', 'Admiral Jervis', 'ADMIRAL JERVIS', 32, -1, -1, '', '1984-01-01', 0, 0, 0, 0, '', 5, 606, 9999, NULL, 3, 1);
INSERT INTO 'dance' VALUES (72, '1997-04-03 22:00:00+00', '2019-02-24 10:31:55.7359+00', 'Aldwark Reel, The', 'ALDWARK REEL', 32, -1, -1, '', NULL, 1, 1, 1, 1, '', 3, 211, 9999, 42, 1, 1);
INSERT INTO 'dance' VALUES (9, '1997-08-28 22:00:00+00', '2020-09-07 14:00:42.980451+00', 'Abbotswell Jig, The', 'ABBOTSWELL JIG', 32, 44, -1, '800/880/800/888', NULL, 0, 1, 0, 0, '', 3, 601, 9999, 42, 1, 2);
INSERT INTO 'dance' VALUES (32, '2002-02-21 23:00:00+00', '2020-09-07 14:06:07.186051+00', 'Across the Tay', 'ACROSS THE TAY', 48, -1, -1, '', NULL, 0, 1, 0, 0, '', 4, 176, 9999, 1, 1, 2);
INSERT INTO 'dance' VALUES (10325, '2005-12-21 23:00:00+00', '2020-11-08 12:24:25.171944+00', 'George''s Strathspey', 'GEORGES STRATHSPEY', 40, 90, -1, '8448/8888/8888/8888/4884', NULL, 0, 1, 0, 0, '', 100, 3412, 9999, 11, 1, 3);
INSERT INTO 'dance' VALUES (10324, '2002-01-08 23:00:00+00', '2021-02-10 10:13:09.484229+00', 'Muirton Bank', 'MUIRTON BANK', 32, 50, -1, '440/880/844/888', NULL, 0, 1, 0, 0, '', 3, 205, 9999, 17, 2, 3);
INSERT INTO 'dance' VALUES (2639, '1997-04-03 22:00:00+00', '2021-04-05 08:18:39.483807+00', 'Grand Tour, The', 'GRAND TOUR', 40, 69, -1, '880/844/888/844/844', '1991-10-26', 0, 1, 1, 0, '', 3, 352, 9999, 42, 1, 1);
INSERT INTO 'dance' VALUES (10322, '2002-01-08 23:00:00+00', '2021-06-08 09:50:02.270782+00', 'Millennium Reel', 'MILLENNIUM REEL', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 3, 851, 9999, 42, 1, 1);
INSERT INTO 'dance' VALUES (53, '1997-08-28 22:00:00+00', '2012-01-20 12:56:00.392358+00', 'Ainsty Strathspey, The', 'AINSTY STRATHSPEY', 40, -1, -1, '', NULL, 1, 1, 1, 1, '', 4, 611, 9999, 1, 1, 3);
INSERT INTO 'dance' VALUES (78, '1998-01-05 23:00:00+00', '2018-04-29 21:15:54.290612+00', 'Alexander Hamilton''s Reel', 'ALEXANDER HAMILTONS REEL', 40, -1, -1, '', NULL, 0, 0, 0, 0, '', 3, 608, 9999, 42, 1, 1);
INSERT INTO 'dance' VALUES (2618, '1997-09-03 22:00:00+00', '2012-01-20 12:56:20.932707+00', 'Govandale Reel', 'GOVANDALE REEL', 48, -1, -1, '', NULL, 0, 0, 0, 0, '', 4, 967, 9999, NULL, 1, 2);
INSERT INTO 'dance' VALUES (14389, '2012-01-03 23:00:00+00', '2022-08-14 08:48:57.914191+00', 'Abbey Jig', 'ABBEY JIG', 32, 100, 100, '88  88  88  88', NULL, 1, 1, 1, 0, '', 2, 10870, NULL, 76, 5, 2);
INSERT INTO 'dance' VALUES (2613, '1997-04-03 22:00:00+00', '2023-01-27 11:06:29.834598+00', 'Gordon Young''s Reel', 'GORDON YOUNGS REEL', 32, 69, -1, '888/888/808/888', NULL, 1, 1, 0, 1, '', 3, 21, 9999, 42, 1, 1);
INSERT INTO 'dance' VALUES (2610, '1997-11-20 23:00:00+00', '2023-01-27 11:12:58.862234+00', 'Gordon Castle', 'GORDON CASTLE', 32, -1, -1, '', NULL, 0, 1, 0, 0, '', 2, 9998, 9999, 76, 1, 3);
INSERT INTO 'dance' VALUES (2621, '1997-04-03 22:00:00+00', '2012-01-20 12:56:20.959995+00', 'Gowden Reel, The', 'GOWDEN REEL', 32, -1, -1, '', '1978-01-01', 0, 0, 0, 0, '', 4, 108, 9999, NULL, 1, 1);
INSERT INTO 'dance' VALUES (2622, '1997-09-03 22:00:00+00', '2012-01-20 12:56:20.968781+00', 'Goyt Valley Reel, The', 'GOYT VALLEY REEL', 48, -1, -1, '', NULL, 0, 0, 0, 0, '', 4, 968, 9999, NULL, 1, 2);
INSERT INTO 'dance' VALUES (67, '1998-11-02 23:00:00+00', '2019-03-20 00:16:18.912397+00', 'Alberta Rose, The', 'ALBERTA ROSE', 80, -1, -1, '', '1982-01-01', 0, 1, 0, 0, '', 4, 612, 9999, 3, 4, 3);
INSERT INTO 'dance' VALUES (45, '1997-08-25 22:00:00+00', '2019-02-27 23:46:39.821154+00', 'Afore Ye Go', 'AFORE YE GO', 40, -1, -1, '', '1977-01-01', 0, 1, 1, 0, '', 4, 549, 9999, 1, 1, 2);
INSERT INTO 'dance' VALUES (2625, '2002-05-11 22:00:00+00', '2012-01-20 12:56:20.994791+00', 'Fourteenth of February', 'FOURTEENTH OF FEBRUARY', 32, -1, -1, '', '1979-01-01', 0, 0, 0, 0, '', 5, 1146, 9999, NULL, 3, 2);
INSERT INTO 'dance' VALUES (10326, '2002-02-09 23:00:00+00', '2012-01-20 12:57:20.335841+00', 'North Muir Jig', 'NORTH MUIR JIG', 32, -1, -1, '', NULL, 1, 1, 1, 1, '', 4, 9998, 9999, 2, 1, 2);
INSERT INTO 'dance' VALUES (18399, '2018-07-13 10:05:59.999864+00', '2019-10-26 18:38:30.144452+00', 'Telesita''s Fancy', 'TELESITAS FANCY', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 3, 11662, NULL, NULL, 1, 3);
INSERT INTO 'dance' VALUES (61, '1997-04-03 22:00:00+00', '2012-01-20 12:56:00.465449+00', 'Alamein', 'ALAMEIN', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 4, 89, 9999, NULL, 1, 1);
INSERT INTO 'dance' VALUES (70, '1997-12-29 23:00:00+00', '2012-01-20 12:56:00.543832+00', 'Aldivalloch', 'ALDIVALLOCH', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 4, 270, 9999, NULL, 1, 3);
INSERT INTO 'dance' VALUES (58, '1997-04-03 22:00:00+00', '2018-04-03 00:07:29.790936+00', 'Airth Castle', 'AIRTH CASTLE', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 3, 34, 9999, 42, 1, 3);
INSERT INTO 'dance' VALUES (80, '2002-04-28 22:00:00+00', '2012-01-20 12:56:00.633625+00', 'Alexander''s 40th Reel', 'ALEXANDERS 40TH REEL', 40, -1, -1, '', NULL, 1, 1, 1, 1, '', 4, 614, 9999, 2, 1, 1);
INSERT INTO 'dance' VALUES (85, '1997-05-17 22:00:00+00', '2012-01-20 12:56:00.677958+00', 'Alice', 'ALICE', 32, -1, -1, '', '1994-01-01', 1, 1, 1, 1, '', 3, 108, 9999, NULL, 2, 3);
INSERT INTO 'dance' VALUES (2634, '1997-04-03 22:00:00+00', '2012-01-20 12:56:21.073776+00', 'Grand Affair, A', 'GRAND AFFAIR', 32, -1, -1, '', NULL, 1, 1, 1, 1, '', 4, 35, 9999, 1, 1, 3);
INSERT INTO 'dance' VALUES (2638, '1997-09-03 22:00:00+00', '2015-09-21 06:42:57.161515+00', 'Grand Slam', 'GRAND SLAM', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 5, 377, 9999, NULL, 3, 2);
INSERT INTO 'dance' VALUES (48, '1997-04-03 22:00:00+00', '2015-09-21 06:47:53.609816+00', 'Agnes Evans', 'AGNES EVANS', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 4, 377, 9999, NULL, 1, 2);
INSERT INTO 'dance' VALUES (44, '1998-07-08 22:00:00+00', '2016-09-04 19:59:03.284732+00', 'Ae Fond Kiss', 'AE FOND KISS', 48, -1, -1, '', NULL, 0, 0, 0, 0, '(bottom 3 couples do not start improper)', 6, 608, 9999, NULL, 8, 1);
INSERT INTO 'dance' VALUES (49, '1997-04-03 22:00:00+00', '2018-04-03 00:07:29.816043+00', 'Ai Strathspey', 'AI STRATHSPEY', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 3, 270, 9999, 42, 1, 3);
INSERT INTO 'dance' VALUES (62, '1997-04-03 22:00:00+00', '2018-04-03 00:07:29.866292+00', 'Alan Malone''s Reel', 'ALAN MALONES REEL', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 3, 418, 9999, 42, 1, 1);
INSERT INTO 'dance' VALUES (63, '1997-04-03 22:00:00+00', '2018-04-03 00:07:29.874732+00', 'Alan Maxwell''s Farewell', 'ALAN MAXWELLS FAREWELL', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 3, 270, 9999, 42, 1, 3);
INSERT INTO 'dance' VALUES (65, '1997-04-03 22:00:00+00', '2018-04-03 00:07:29.89978+00', 'Albany House', 'ALBANY HOUSE', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 3, 9998, 9999, 42, 1, 2);
INSERT INTO 'dance' VALUES (69, '1997-08-28 22:00:00+00', '2018-04-03 00:07:29.94757+00', 'Alderley Medley', 'ALDERLEY MEDLEY', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 3, 314, 9999, 42, 1, 4);
INSERT INTO 'dance' VALUES (71, '1998-04-29 22:00:00+00', '2018-04-03 00:07:29.95822+00', 'Aldridge''s Hornpipe', 'ALDRIDGES HORNPIPE', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 3, 270, 9999, 42, 1, 1);
INSERT INTO 'dance' VALUES (2620, '1997-09-03 22:00:00+00', '2018-04-03 00:07:49.465948+00', 'Gowden Laverock, The', 'GOWDEN LAVEROCK', 32, -1, -1, '', '1975-02-02', 0, 0, 0, 0, '', 3, 108, 9999, 42, 1, 3);
INSERT INTO 'dance' VALUES (2626, '2002-04-19 22:00:00+00', '2018-04-03 00:07:49.507556+00', 'Graduation Jig, The', 'GRADUATION JIG', 32, -1, -1, '', NULL, 1, 1, 1, 1, '', 3, 969, 9999, 42, 1, 2);
INSERT INTO 'dance' VALUES (2627, '2002-01-06 23:00:00+00', '2018-04-03 00:07:49.515946+00', 'Graelynda Strathspey, The', 'GRAELYNDA STRATHSPEY', 32, -1, -1, '', '1990-01-01', 1, 1, 1, 1, '', 3, 108, 9999, 42, 1, 3);
INSERT INTO 'dance' VALUES (2633, '1997-04-03 22:00:00+00', '2018-04-03 00:07:49.532595+00', 'Grampian Tartan, The', 'GRAMPIAN TARTAN', 32, -1, -1, '', NULL, 1, 1, 1, 1, '', 3, 35, 9999, 42, 1, 3);
INSERT INTO 'dance' VALUES (2637, '1998-04-24 22:00:00+00', '2018-04-03 00:07:49.565876+00', 'Grand Promenade, The', 'GRAND PROMENADE', 32, -1, -1, '', '1988-01-01', 0, 0, 0, 0, '', 3, 108, 9999, 42, 1, 3);
INSERT INTO 'dance' VALUES (10330, '2002-02-09 23:00:00+00', '2018-04-03 00:08:10.481652+00', 'Petherum Brig', 'PETHERUM BRIG', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 3, 1272, 9999, 42, 1, 1);
INSERT INTO 'dance' VALUES (10331, '2002-02-09 23:00:00+00', '2018-04-03 00:08:11.682655+00', 'Queen Mother''s Century, The', 'QUEEN MOTHERS CENTURY', 32, -1, -1, '', '2001-01-01', 0, 0, 0, 0, '', 3, 2987, 9999, 42, 1, 1);
INSERT INTO 'dance' VALUES (2657, '1998-04-12 22:00:00+00', '2018-12-13 02:26:03.858061+00', 'Great Thunder Falls, The', 'GREAT THUNDER FALLS', 32, 53, -1, '888/800/804/888', '1986-01-01', 1, 1, 1, 1, 'Presented to the Teachers'' Association (Canada) to celebrate the 1986 TAC Summer School.', 3, 44, 9999, 42, 1, 2);
INSERT INTO 'dance' VALUES (10360, '2002-02-26 23:00:00+00', '2012-01-20 12:57:20.653145+00', 'Larkhall Ladies', 'LARKHALL LADIES', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 5, 9998, 9999, 16, 3, 3);
INSERT INTO 'dance' VALUES (10362, '2002-03-03 23:00:00+00', '2012-01-20 12:57:20.671402+00', 'Key to the Fylde', 'KEY TO THE FYLDE', 128, -1, -1, '', NULL, 1, 1, 1, 1, '', 4, 9998, 9999, NULL, 4, 3);
INSERT INTO 'dance' VALUES (47, '1997-04-03 22:00:00+00', '2020-06-30 18:58:20.905056+00', 'After the Battle', 'AFTER THE BATTLE', 32, 94, -1, '88/77/88/77', NULL, 0, 1, 1, 0, '', 2, 270, 9999, NULL, 5, 1);
INSERT INTO 'dance' VALUES (46, '1997-08-28 22:00:00+00', '2020-08-24 22:48:53.95524+00', 'After the Ball', 'AFTER THE BALL', 48, -1, -1, '', NULL, 0, 1, 0, 0, '', 4, 609, 9999, 3, 4, 3);
INSERT INTO 'dance' VALUES (10329, '2002-02-09 23:00:00+00', '2021-02-10 10:09:37.829808+00', 'Pauline''s Wedding', 'PAULINES WEDDING', 40, 100, -1, '', '2000-01-01', 0, 1, 0, 0, '', 4, 103, 9999, 14, 4, 3);
INSERT INTO 'dance' VALUES (2656, '1998-04-12 22:00:00+00', '2021-06-02 11:27:57.456321+00', 'Great Spirit''s Voice, The', 'GREAT SPIRITS VOICE', 32, 60, -1, '84/88/84/88', '1983-01-01', 0, 1, 1, 0, '', 2, 401, 9999, 76, 1, 3);
INSERT INTO 'dance' VALUES (10328, '2002-02-09 23:00:00+00', '2021-06-08 09:49:13.858675+00', 'Pat Petrie''s Jig', 'PAT PETRIES JIG', 40, -1, -1, '', NULL, 0, 0, 0, 0, '', 4, 9998, 9999, NULL, 1, 2);
INSERT INTO 'dance' VALUES (81, '1997-04-03 22:00:00+00', '2021-06-22 20:17:20.786351+00', 'Alexander''s Jig', 'ALEXANDERS JIG', 32, 53, -1, '800/888/822/888', NULL, 1, 1, 0, 1, '', 3, 259, 9999, 42, 1, 2);
INSERT INTO 'dance' VALUES (2629, '1998-01-05 23:00:00+00', '2021-07-11 15:53:00.371303+00', 'Graham Park', 'GRAHAM PARK', 32, 64, -1, '864/888/888/844', NULL, 0, 1, 0, 0, '', 3, 970, 9999, 42, 1, 1);
INSERT INTO 'dance' VALUES (2630, '1997-04-03 22:00:00+00', '2021-07-17 18:41:20.620077+00', 'Graham''s Fancy', 'GRAHAMS FANCY', 32, -1, -1, '', NULL, 0, 1, 0, 1, 'According to the dance notes, the tune Graham Warren Hamilton was composed by Brian Hamilton for his son Graham for whom this dance was devised.', 4, 377, 9999, 1, 1, 2);
INSERT INTO 'dance' VALUES (10363, '2002-03-03 23:00:00+00', '2012-01-20 12:57:20.680941+00', 'Millennium Bug, The', 'MILLENNIUM BUG', 32, -1, -1, '', '1999-01-01', 1, 1, 1, 1, '', 4, 123, 9999, 2, 1, 1);
INSERT INTO 'dance' VALUES (18400, '2018-07-13 10:08:02.705115+00', '2019-10-26 18:38:02.875259+00', 'Five Reasons for Drinking, The', 'FIVE REASONS FOR DRINKING', 40, -1, -1, '', NULL, 0, 0, 0, 0, '', 3, 11663, NULL, NULL, 1, 1);
INSERT INTO 'dance' VALUES (94, '1997-04-03 22:00:00+00', '2012-01-20 12:56:00.761808+00', 'All Friends Around Wrekin', 'ALL FRIENDS AROUND WREKIN', 64, -1, -1, '', NULL, 0, 0, 0, 0, '', 4, 329, 9999, NULL, 4, 3);
INSERT INTO 'dance' VALUES (97, '1997-04-03 22:00:00+00', '2018-04-02 10:27:25.782689+00', 'All That Glisters', 'ALL THAT GLISTERS', 32, -1, -1, '', '1993-05-20', 0, 1, 0, 0, '', 3, 352, 9999, 42, 1, 2);
INSERT INTO 'dance' VALUES (96, '1997-04-03 22:00:00+00', '2012-01-20 12:56:00.779124+00', 'All Slobbered And Sost', 'ALL SLOBBERED AND SOST', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 2, 9998, 9999, NULL, 1, 2);
INSERT INTO 'dance' VALUES (2654, '1997-04-03 22:00:00+00', '2018-04-02 23:56:35.026267+00', 'Great Obsession, The', 'GREAT OBSESSION', 24, -1, -1, '', '1994-01-13', 0, 1, 0, 0, '', 3, 352, 9999, 42, 1, 3);
INSERT INTO 'dance' VALUES (2628, '1997-04-03 22:00:00+00', '2022-11-07 22:05:24.625705+00', 'Graham Hamilton of Glenwood', 'GRAHAM HAMILTON OF GLENWOOD', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 4, 270, 9999, NULL, 1, 3);
INSERT INTO 'dance' VALUES (99, '1997-08-31 22:00:00+00', '2012-01-20 12:56:00.805468+00', 'All Together, One After Another', 'ALL TOGETHER ONE AFTER ANOTHER', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 2, 446, 9999, NULL, 1, 2);
INSERT INTO 'dance' VALUES (102, '1997-08-28 22:00:00+00', '2012-01-20 12:56:00.838695+00', 'Allerton Lassies', 'ALLERTON LASSIES', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 4, 620, 9999, NULL, 1, 1);
INSERT INTO 'dance' VALUES (87, '1997-04-03 22:00:00+00', '2018-04-03 00:07:30.050187+00', 'Alison and Sandy Grant', 'ALISON AND SANDY GRANT', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 3, 270, 9999, 42, 1, 1);
INSERT INTO 'dance' VALUES (106, '1997-08-28 22:00:00+00', '2012-01-20 12:56:00.88332+00', 'Alloway Rant, The', 'ALLOWAY RANT', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 4, 622, 9999, NULL, 1, 1);
INSERT INTO 'dance' VALUES (110, '1997-08-28 22:00:00+00', '2012-01-20 12:56:00.922265+00', 'Alpin Fancy', 'ALPIN FANCY', 48, -1, -1, '', NULL, 0, 0, 0, 0, '', 4, 311, 9999, NULL, 1, 2);
INSERT INTO 'dance' VALUES (111, '1997-04-03 22:00:00+00', '2012-01-20 12:56:00.930946+00', 'Altnabreac', 'ALTNABREAC', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 4, 270, 9999, NULL, 1, 2);
INSERT INTO 'dance' VALUES (59, '1997-04-03 22:00:00+00', '2024-07-09 22:36:24.252452+00', 'Airy Fairy', 'AIRY FAIRY', 32, -1, -1, '', '1993-01-22', 1, 1, 1, 0, 'The original instructions for this dance say it is a Reel. But the recommended recording is a Jig.', 2, 352, 9999, 76, 1, 1);
INSERT INTO 'dance' VALUES (75, '1997-04-03 22:00:00+00', '2025-01-28 12:29:57.580584+00', 'Alec''s Favourite', 'ALECS FAVOURITE', 32, 91, -1, '8888/6666/8848/8888', '1990-07-26', 1, 1, 0, 0, '', 4, 173, 9999, 1, 1, 3);
INSERT INTO 'dance' VALUES (2623, '2002-11-29 23:00:00+00', '2025-11-24 22:37:14.766846+00', 'Grace Of Alvertoune, The', 'GRACE OF ALVERTOUNE', 32, -1, -1, '', NULL, 1, 1, 1, 1, '', 4, 2614, 9999, 1, 1, 3);
INSERT INTO 'dance' VALUES (113, '1998-01-04 23:00:00+00', '2012-01-20 12:56:00.948597+00', 'Always Welcome', 'ALWAYS WELCOME', 32, -1, -1, '', '1968-01-01', 1, 1, 1, 1, '', 2, 44, 9999, NULL, 1, 1);
INSERT INTO 'dance' VALUES (115, '1997-09-21 22:00:00+00', '2012-01-20 12:56:00.966291+00', 'Always Welcome', 'ALWAYS WELCOME', 40, -1, -1, '', NULL, 0, 0, 0, 0, '', 4, 270, 9999, NULL, 1, 1);
INSERT INTO 'dance' VALUES (2646, '1998-07-08 22:00:00+00', '2012-01-20 12:56:21.190909+00', 'Grant''s Strathspey', 'GRANTS STRATHSPEY', 40, -1, -1, '', NULL, 0, 0, 0, 0, '', 4, 270, 9999, 2, 1, 3);
INSERT INTO 'dance' VALUES (2647, '1997-09-03 22:00:00+00', '2012-01-20 12:56:21.20621+00', 'Granton Lassie, The', 'GRANTON LASSIE', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 4, 27, 9999, NULL, 1, 3);
INSERT INTO 'dance' VALUES (2648, '1997-09-03 22:00:00+00', '2012-01-20 12:56:21.214889+00', 'Granville Reel, The', 'GRANVILLE REEL', 40, -1, -1, '', NULL, 0, 0, 0, 0, '', 4, 929, 9999, NULL, 4, 1);
INSERT INTO 'dance' VALUES (2650, '1997-04-03 22:00:00+00', '2012-01-20 12:56:21.232199+00', 'Great Aunt Henderson', 'GREAT AUNT HENDERSON', 40, -1, -1, '', NULL, 0, 0, 0, 0, '', 4, 393, 9999, NULL, 1, 2);
INSERT INTO 'dance' VALUES (2652, '1997-04-03 22:00:00+00', '2012-01-20 12:56:21.24956+00', 'Great MacMillan Of Knap', 'GREAT MACMILLAN OF KNAP', 40, -1, -1, '', NULL, 0, 0, 0, 0, '', 98, 380, 9999, NULL, 1, 3);
INSERT INTO 'dance' VALUES (90, '1997-04-03 22:00:00+00', '2018-04-03 00:07:30.066952+00', 'Alistair''s Favourite Pickle', 'ALISTAIRS FAVOURITE PICKLE', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 3, 259, 9999, 42, 1, 2);
INSERT INTO 'dance' VALUES (10369, '2002-03-07 23:00:00+00', '2012-01-20 12:57:20.735731+00', 'Celtic Curve, The', 'CELTIC CURVE', 64, -1, -1, '', NULL, 1, 1, 1, 1, '', 4, 2994, 9999, 14, 4, 3);
INSERT INTO 'dance' VALUES (119, '1997-08-28 22:00:00+00', '2012-01-20 12:56:01.001358+00', 'Amang The Heather', 'AMANG THE HEATHER', 40, -1, -1, '', NULL, 0, 0, 0, 0, '', 4, 78, 9999, NULL, 1, 2);
INSERT INTO 'dance' VALUES (122, '1997-04-03 22:00:00+00', '2012-01-20 12:56:01.027536+00', 'Amerada Hess Reel', 'AMERADA HESS REEL', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 4, 377, 9999, NULL, 1, 1);
INSERT INTO 'dance' VALUES (2643, '1997-12-27 23:00:00+00', '2018-02-19 00:43:39.871869+00', 'Grant Park', 'GRANT PARK', 24, -1, -1, '', NULL, 0, 1, 0, 0, '', 2, 361, 9999, 76, 1, 3);
INSERT INTO 'dance' VALUES (10358, '2002-02-26 23:00:00+00', '2017-05-31 13:03:28.347795+00', 'schoener Wunsch, Ein', 'SCHOENER WUNSCH EIN', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 3, 9998, 9999, 17, 2, 1);
INSERT INTO 'dance' VALUES (101, '1997-09-17 22:00:00+00', '2018-04-03 00:07:30.108657+00', 'Allan''s Rant, The', 'ALLANS RANT', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 3, 346, 9999, 42, 1, 1);
INSERT INTO 'dance' VALUES (120, '1998-04-04 22:00:00+00', '2018-04-03 00:07:30.309311+00', 'Amazing Glace', 'AMAZING GLACE', 32, -1, -1, '', '1995-01-01', 0, 0, 0, 0, '', 3, 108, 9999, 42, 1, 3);
INSERT INTO 'dance' VALUES (2655, '1997-04-03 22:00:00+00', '2018-04-03 00:07:49.724448+00', 'Great October Blow, The', 'GREAT OCTOBER BLOW', 48, -1, -1, '', NULL, 0, 0, 0, 0, '', 3, 145, 9999, 42, 1, 2);
INSERT INTO 'dance' VALUES (10359, '2002-02-26 23:00:00+00', '2018-04-03 00:07:53.718988+00', 'Inveruglas House', 'INVERUGLAS HOUSE', 0, -1, -1, '', NULL, 0, 0, 0, 0, '', 3, 9998, 9999, 42, 1, 99);
INSERT INTO 'dance' VALUES (2641, '2000-11-17 23:00:00+00', '2018-04-03 00:07:55.320012+00', 'Jess Nichol''s Fancy', 'JESS NICHOLS FANCY', 32, -1, -1, '', '1998-01-01', 1, 1, 1, 1, '', 3, 2825, 9999, 42, 1, 3);
INSERT INTO 'dance' VALUES (124, '1998-07-08 22:00:00+00', '2012-01-20 12:56:01.089584+00', 'Among the Wicklow Hills', 'AMONG THE WICKLOW HILLS', 40, -1, -1, '', NULL, 1, 1, 1, 1, '', 4, 35, 9999, 2, 1, 3);
INSERT INTO 'dance' VALUES (10335, '2002-02-11 23:00:00+00', '2018-04-03 00:07:30.11691+00', 'All at Once Well Met', 'ALL AT ONCE WELL MET', 40, -1, -1, '', NULL, 0, 0, 0, 0, '', 3, 2408, 9999, 42, 1, 2);
INSERT INTO 'dance' VALUES (131, '1997-09-11 22:00:00+00', '2012-01-20 12:56:01.182104+00', 'Poussie, Poussie, Bawdrons', 'POUSSIE POUSSIE BAWDRONS', 12, -1, -1, '', NULL, 0, 0, 0, 0, '', 4, 3, 9999, NULL, 1, 3);
INSERT INTO 'dance' VALUES (299, '1997-04-03 22:00:00+00', '2018-04-03 00:07:31.537638+00', 'Auld Kirk, The', 'AULD KIRK', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 3, 270, 9999, 42, 1, 3);
INSERT INTO 'dance' VALUES (114, '1997-09-30 22:00:00+00', '2020-08-14 20:53:36.411143+00', 'Always Welcome', 'ALWAYS WELCOME', 32, 56, -1, '8008/8008/8000/8888', NULL, 0, 1, 0, 0, '', 4, 21, 9999, 1, 1, 1);
INSERT INTO 'dance' VALUES (92, '1997-09-30 22:00:00+00', '2020-09-07 14:21:09.100733+00', 'All Feathers and Fluff', 'ALL FEATHERS AND FLUFF', 32, 53, -1, '840/888/880/880', NULL, 0, 1, 0, 0, '', 3, 21, 9999, 42, 1, 2);
INSERT INTO 'dance' VALUES (88, '1997-08-28 22:00:00+00', '2020-12-27 12:57:32.273249+00', 'Alison Jane''s Jig', 'ALISON JANES JIG', 40, 49, -1, '860/866/844/800/866', NULL, 0, 1, 0, 0, '', 3, 617, 9999, 42, 1, 2);
INSERT INTO 'dance' VALUES (10357, '2002-04-11 22:00:00+00', '2021-02-09 12:37:57.686277+00', 'Anchors Aweigh', 'ANCHORS AWEIGH', 48, 65, -1, '844/888/888/822/888/888', NULL, 0, 1, 0, 0, '', 3, 2863, 9999, 42, 1, 1);
INSERT INTO 'dance' VALUES (10364, '2002-07-23 22:00:00+00', '2021-02-09 12:31:30.566718+00', 'Mr MacAskill''s Problem', 'MR MACASKILLS PROBLEM', 32, 81, -1, '8888/8888/8440/8448', '1997-01-01', 1, 1, 1, 1, '', 4, 1, 9999, 1, 1, 3);
INSERT INTO 'dance' VALUES (10368, '2002-03-06 23:00:00+00', '2021-04-18 19:02:51.612649+00', 'Nut Loaf, The', 'NUT LOAF', 40, 60, -1, '844/866/844/866/888', '2000-03-25', 1, 1, 1, 1, '', 3, 44, 9999, 42, 1, 2);
INSERT INTO 'dance' VALUES (2666, '1998-01-05 23:00:00+00', '2021-05-13 14:04:36.533502+00', 'Green Moss', 'GREEN MOSS', 24, 42, -1, '800/800/888', '1993-01-12', 0, 1, 1, 0, '', 3, 352, 9999, 42, 1, 1);
INSERT INTO 'dance' VALUES (103, '1998-11-02 23:00:00+00', '2021-06-22 20:06:03.941833+00', 'Allison''s Invention', 'ALLISONS INVENTION', 32, 50, -1, '800/888/844/844', '1986-01-01', 1, 1, 0, 1, 'Devised as a teaching dance for Kingston''s 1986 Spring Workshop.', 3, 621, 9999, 42, 1, 1);
INSERT INTO 'dance' VALUES (18401, '2018-07-13 10:09:09.559026+00', '2018-07-13 10:09:09.559026+00', 'All-Around Poussette', 'ALLAROUND POUSSETTE', 40, -1, -1, '', NULL, 0, 0, 0, 0, '', 4, 11661, NULL, NULL, 4, 2);
INSERT INTO 'dance' VALUES (136, '1997-08-28 22:00:00+00', '2012-01-20 12:56:01.225682+00', 'And One for Judy', 'AND ONE FOR JUDY', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 3, 377, 9999, NULL, 2, 2);
INSERT INTO 'dance' VALUES (146, '1997-08-28 22:00:00+00', '2018-08-20 10:33:41.69255+00', 'Andrew''s Welcome', 'ANDREWS WELCOME', 32, 56, -1, '4000/4000/8888/8888', NULL, 0, 1, 1, 0, 'Written for Andrew, son of David and Janet Berg.', 4, 377, 9999, 1, 1, 1);
INSERT INTO 'dance' VALUES (143, '1998-07-08 22:00:00+00', '2012-01-20 12:56:01.287832+00', 'Andrew Rankine''s Reel', 'ANDREW RANKINES REEL', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 4, 627, 9999, 11, 1, 1);
INSERT INTO 'dance' VALUES (160, '1997-08-28 22:00:00+00', '2019-03-20 00:02:42.250783+00', 'Anna''s Reel', 'ANNAS REEL', 32, 81, -1, '8888/8448/8888/8008', NULL, 0, 1, 1, 0, '', 4, 634, 9999, 2, 1, 1);
INSERT INTO 'dance' VALUES (2665, '1997-04-03 22:00:00+00', '2012-01-20 12:56:21.366565+00', 'Green Meadow, The', 'GREEN MEADOW', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 4, 270, 9999, NULL, 1, 1);
INSERT INTO 'dance' VALUES (126, '1997-08-31 22:00:00+00', '2022-12-18 21:58:48.66917+00', 'Fair Quaker of Deal, The', 'FAIR QUAKER OF DEAL', 32, -1, -1, '', '1712-01-01', 0, 0, 0, 0, '', 2, 397, 9999, NULL, 1, 2);
INSERT INTO 'dance' VALUES (108, '1997-11-27 23:00:00+00', '2023-03-11 21:14:07.905113+00', 'Alltreoch', 'ALLTREOCH', 32, -1, -1, '', '1977-01-01', 1, 1, 0, 1, 'The notes say this was "dedicated to Miss Isobel Graham Ferrier, of Alltreoch, Strathardle, Perthshire".', 3, 176, 1, 42, 1, 4);
INSERT INTO 'dance' VALUES (169, '2000-08-01 22:00:00+00', '2018-02-27 09:45:41.735131+00', 'Anne Grant''s Reel', 'ANNE GRANTS REEL', 32, -1, -1, '', '1993-01-01', 0, 1, 1, 0, '', 3, 827, 9999, 42, 1, 1);
INSERT INTO 'dance' VALUES (10332, '2002-02-09 23:00:00+00', '2012-01-20 12:57:20.393585+00', 'RNLI - 175th Anniversary', 'RNLI  175TH ANNIVERSARY', 32, -1, -1, '', '1999-01-01', 0, 0, 0, 0, '', 4, 1836, 9999, 1, 1, 1);
INSERT INTO 'dance' VALUES (10336, '2002-02-11 23:00:00+00', '2012-01-20 12:57:20.430327+00', 'Matinee, The', 'MATINEE', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 4, 2988, 9999, NULL, 4, 3);
INSERT INTO 'dance' VALUES (10337, '2002-02-12 23:00:00+00', '2012-01-20 12:57:20.439832+00', 'Scottish Fare', 'SCOTTISH FARE', 32, -1, -1, '', '1998-01-01', 1, 1, 1, 1, '', 4, 205, 9999, 2, 1, 1);
INSERT INTO 'dance' VALUES (148, '1997-08-28 22:00:00+00', '2012-01-20 12:56:01.331593+00', 'Ane Reel For Fionnghuala', 'ANE REEL FOR FIONNGHUALA', 40, -1, -1, '', NULL, 0, 0, 0, 0, '', 2, 264, 9999, NULL, 1, 1);
INSERT INTO 'dance' VALUES (133, '1997-04-03 22:00:00+00', '2018-04-03 00:07:30.401864+00', 'Ancient Glasgow''s Glory', 'ANCIENT GLASGOWS GLORY', 32, -1, -1, '', NULL, 1, 1, 1, 1, '', 3, 35, 9999, 42, 1, 3);
INSERT INTO 'dance' VALUES (134, '1997-08-28 22:00:00+00', '2018-04-03 00:07:30.418554+00', 'Ancient Yew, The', 'ANCIENT YEW', 32, -1, -1, '', '1987-01-01', 0, 0, 0, 0, '', 3, 108, 9999, 42, 1, 3);
INSERT INTO 'dance' VALUES (172, '1997-04-03 22:00:00+00', '2012-01-20 12:56:01.548151+00', 'Anne Simpson of Perth', 'ANNE SIMPSON OF PERTH', 32, -1, -1, '', NULL, 1, 1, 1, 1, '', 4, 35, 9999, 2, 1, 3);
INSERT INTO 'dance' VALUES (10334, '2002-02-11 23:00:00+00', '2015-03-03 22:28:56.121944+00', 'Ron Ramsay Reel, The', 'RON RAMSAY REEL', 40, -1, -1, '', '1999-01-01', 0, 0, 0, 0, '', 4, 2913, 9999, 1, 1, 1);
INSERT INTO 'dance' VALUES (163, '1997-04-03 22:00:00+00', '2024-04-16 13:44:38.211954+00', 'Annandale', 'ANNANDALE', 32, 65, -1, '88288/80808/86888/80000', NULL, 1, 1, 0, 1, '', 5, 13, 9999, 16, 3, 2);
INSERT INTO 'dance' VALUES (125, '1997-04-03 22:00:00+00', '2024-09-08 09:33:03.325903+00', 'Ample Plaid, The', 'AMPLE PLAID', 32, -1, -1, '', NULL, 1, 1, 1, 1, '', 4, 35, 9999, 11, 1, 3);
INSERT INTO 'dance' VALUES (121, '1997-04-03 22:00:00+00', '2025-02-26 12:30:31.355746+00', 'Amerada Hess Jig', 'AMERADA HESS JIG', 32, 81, -1, '4884/6666/8448/8888', NULL, 1, 1, 1, 1, 'Written for the Amerada Hess Group of Scottish Country Dancers', 4, 377, 9999, 2, 1, 2);
INSERT INTO 'dance' VALUES (18880, '2018-10-08 18:09:58.224869+00', '2025-01-10 11:05:38.38764+00', 'Simple Simon', 'SIMPLE SIMON', 32, 50, -1, '880/880/822/866', '2009-06-01', 1, 1, 1, 0, '', 3, 2766, NULL, 42, 1, 1);
INSERT INTO 'dance' VALUES (112, '2002-11-29 23:00:00+00', '2025-11-24 21:39:48.476833+00', 'Alverton Strathspey', 'ALVERTON STRATHSPEY', 48, -1, -1, '', NULL, 1, 1, 1, 1, 'Alverton is the ancient name now adapted to Allerton.', 4, 3249, 9999, NULL, 1, 3);
INSERT INTO 'dance' VALUES (138, '1997-04-03 22:00:00+00', '2018-04-03 00:07:30.443662+00', 'Andenne Jig, The', 'ANDENNE JIG', 40, -1, -1, '', NULL, 0, 0, 0, 0, '', 3, 313, 9999, 42, 1, 2);
INSERT INTO 'dance' VALUES (142, '1998-01-05 23:00:00+00', '2018-04-03 00:07:30.485291+00', 'Andrew Arrived', 'ANDREW ARRIVED', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 3, 377, 9999, 42, 1, 1);
INSERT INTO 'dance' VALUES (147, '1997-04-03 22:00:00+00', '2018-04-03 00:07:30.526983+00', 'Andy Stewart''s Reel', 'ANDY STEWARTS REEL', 40, -1, -1, '', NULL, 0, 0, 0, 0, '', 3, 39, 9999, 42, 1, 1);
INSERT INTO 'dance' VALUES (149, '1997-08-31 22:00:00+00', '2018-04-03 00:07:30.568976+00', 'Angela''s Delight', 'ANGELAS DELIGHT', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 3, 21, 9999, 42, 1, 2);
INSERT INTO 'dance' VALUES (165, '1997-04-03 22:00:00+00', '2018-04-03 00:07:30.702606+00', 'Anne', 'ANNE', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 3, 28, 9999, 42, 1, 3);
INSERT INTO 'dance' VALUES (166, '1997-04-03 22:00:00+00', '2018-04-03 00:07:30.719289+00', 'Anne Elizabeth''s Fancy', 'ANNE ELIZABETHS FANCY', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 3, 271, 9999, 42, 1, 2);
INSERT INTO 'dance' VALUES (158, '1997-04-03 22:00:00+00', '2018-04-03 00:07:30.877795+00', 'Ann''s Joy', 'ANNS JOY', 32, -1, -1, '', '1975-02-02', 0, 0, 0, 0, '', 3, 108, 9999, 42, 1, 3);
INSERT INTO 'dance' VALUES (2658, '1998-01-05 23:00:00+00', '2018-04-03 00:07:49.749452+00', 'Green And White, The', 'GREEN AND WHITE', 32, -1, -1, '', NULL, 1, 1, 1, 1, '', 3, 211, 9999, 42, 1, 1);
INSERT INTO 'dance' VALUES (2662, '1997-04-03 22:00:00+00', '2018-04-03 00:07:49.950838+00', 'Green Jersey, The', 'GREEN JERSEY', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 3, 270, 9999, 42, 1, 2);
INSERT INTO 'dance' VALUES (10338, '2002-02-12 23:00:00+00', '2018-04-03 00:08:16.15242+00', 'Sheila''s Jig', 'SHEILAS JIG', 40, -1, -1, '', NULL, 0, 0, 0, 0, '', 3, 619, 9999, 42, 1, 2);
INSERT INTO 'dance' VALUES (2697, '1998-10-19 22:00:00+00', '2018-03-18 21:48:36.756075+00', 'Guid Tae See Ye', 'GUID TAE SEE YE', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 3, 349, 9999, 42, 1, 1);
INSERT INTO 'dance' VALUES (176, '1997-04-03 22:00:00+00', '2018-04-03 00:07:30.777623+00', 'Anne''s Quest', 'ANNES QUEST', 40, -1, -1, '', NULL, 1, 1, 1, 1, '', 3, 35, 9999, 42, 1, 3);
INSERT INTO 'dance' VALUES (2676, '1997-09-03 22:00:00+00', '2012-01-20 12:56:21.46502+00', 'Greenwich Park', 'GREENWICH PARK', 32, -1, -1, '', '1709-01-01', 0, 0, 0, 0, '', 2, 446, 9999, NULL, 1, 1);
INSERT INTO 'dance' VALUES (2677, '1997-04-03 22:00:00+00', '2012-01-20 12:56:21.473854+00', 'Greenwood Reel, The', 'GREENWOOD REEL', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 4, 199, 9999, NULL, 1, 1);
INSERT INTO 'dance' VALUES (18403, '2018-07-13 10:11:25.248412+00', '2018-07-13 10:11:25.248412+00', 'Pas-De-Basco', 'PASDEBASCO', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 3, 11664, NULL, NULL, 2, 2);
INSERT INTO 'dance' VALUES (168, '1997-09-02 22:00:00+00', '2020-07-01 03:33:23.498027+00', 'Anne Fraser McKenzie', 'ANNE FRASER MACKENZIE', 40, 55, -1, '480/880/848/884/866', NULL, 0, 1, 1, 0, '', 3, 270, 9999, 42, 1, 2);
INSERT INTO 'dance' VALUES (2668, '2003-03-21 23:00:00+00', '2021-01-18 23:25:18.107348+00', 'Kathy''s Jig', 'KATHYS JIG', 40, 50, -1, '804/840/844/844/888', '2002-01-01', 1, 1, 1, 1, 'Dance devised for Kathy Stewart''s 60th Birthday.', 3, 2626, 9999, 42, 1, 2);
INSERT INTO 'dance' VALUES (177, '1997-04-03 22:00:00+00', '2020-08-29 11:47:40.033837+00', 'Annie Elizabeth Bruce', 'ANNIE ELIZABETH BRUCE', 32, -1, -1, '', NULL, 0, 1, 0, 0, '', 3, 371, 9999, 42, 1, 1);
INSERT INTO 'dance' VALUES (2670, '1997-09-03 22:00:00+00', '2020-10-07 21:36:57.396236+00', 'Green Sleeves and Yellow Lace', 'GREEN SLEEVES AND YELLOW LACE', 64, -1, -1, '', '1721-01-01', 0, 0, 0, 0, '', 3, 976, 9999, 42, 1, 2);
INSERT INTO 'dance' VALUES (10333, '2002-02-11 23:00:00+00', '2021-02-09 18:28:44.504261+00', 'Reel of the A68, The', 'REEL OF THE A68', 40, 57, -1, '0008/8000/0880/8888/4888', '1993-01-01', 0, 1, 0, 0, '', 4, 1175, 9999, 1, 1, 1);
INSERT INTO 'dance' VALUES (128, '1997-08-31 22:00:00+00', '2020-12-27 18:47:24.658265+00', 'An Cailin Dhu', 'CAILIN DHU', 32, -1, -1, '', '1991-01-01', 1, 1, 1, 1, '', 4, 411, 9999, 13, 4, 3);
INSERT INTO 'dance' VALUES (155, '1997-04-03 22:00:00+00', '2020-12-27 19:03:47.741467+00', 'Ann Nisbet''s Strathspey', 'ANN NISBETS STRATHSPEY', 32, 53, -1, '888/800/888/822', NULL, 0, 1, 0, 0, '', 3, 62, 9999, 42, 1, 3);
INSERT INTO 'dance' VALUES (141, '1997-04-03 22:00:00+00', '2021-03-03 16:13:13.708608+00', 'Andersons'' Awa''', 'ANDERSONS AWA', 32, 63, -1, '822/880/800/888', NULL, 1, 1, 1, 1, '', 3, 3586, 9999, 17, 2, 3);
INSERT INTO 'dance' VALUES (137, '2002-03-03 23:00:00+00', '2021-07-04 11:29:38.246644+00', 'And They Lived Happily Ever After', 'AND THEY LIVED HAPPILY EVER AFTER', 40, 46, -1, '8000/8110/8404/8000/8888', NULL, 1, 1, 1, 1, 'Devised "in honour of the 30th Wedding Anniversary of Alec and Margaret Macwaters, Ottawa Branch."', 4, 630, 9999, 1, 1, 3);
INSERT INTO 'dance' VALUES (173, '1998-01-11 23:00:00+00', '2019-03-19 23:58:05.262601+00', 'Anne Smyth', 'ANNE SMYTH', 40, 60, -1, '8008/8888/6666/8008/8000', NULL, 1, 1, 1, 1, '', 4, 149, 9999, 1, 1, 2);
INSERT INTO 'dance' VALUES (2684, '1997-04-03 22:00:00+00', '2012-01-20 12:56:21.535129+00', 'Grey Buck, The', 'GREY BUCK', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 4, 270, 9999, NULL, 1, 2);
INSERT INTO 'dance' VALUES (2685, '1997-04-03 22:00:00+00', '2012-01-20 12:56:21.543805+00', 'Grey Cairns, The', 'GREY CAIRNS', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 5, 313, 9999, NULL, 3, 3);
INSERT INTO 'dance' VALUES (10371, '2002-03-07 23:00:00+00', '2012-01-20 12:57:20.754762+00', 'Dragon Dance, The', 'DRAGON DANCE', 32, -1, -1, '', NULL, 1, 1, 1, 1, '', 4, 2994, 9999, 1, 1, 3);
INSERT INTO 'dance' VALUES (10372, '2002-03-07 23:00:00+00', '2012-01-20 12:57:20.764355+00', 'Finding Heather Fold', 'FINDING HEATHER FOLD', 32, -1, -1, '', NULL, 1, 1, 1, 1, '', 4, 2995, 9999, 1, 1, 2);
INSERT INTO 'dance' VALUES (2690, '1997-09-03 22:00:00+00', '2019-09-15 19:14:08.227464+00', 'Grinder''s Hornpipe, The', 'GRINDERS HORNPIPE', 40, -1, -1, '', NULL, 0, 0, 0, 0, '', 3, 270, 9999, 42, 1, 1);
INSERT INTO 'dance' VALUES (10374, '2002-03-07 23:00:00+00', '2012-01-20 12:57:20.782662+00', 'Highlandology', 'HIGHLANDOLOGY', 40, -1, -1, '', NULL, 1, 1, 1, 1, '', 5, 2997, 9999, 16, 3, 3);
INSERT INTO 'dance' VALUES (10375, '2002-03-07 23:00:00+00', '2012-01-20 12:57:20.79225+00', 'Left-Handed Reel or Jig', 'LEFTHANDED REEL OR JIG', 32, -1, -1, '', NULL, 1, 1, 1, 1, '', 3, 1133, 9999, 17, 2, 1);
INSERT INTO 'dance' VALUES (10377, '2002-03-07 23:00:00+00', '2012-01-20 12:57:20.810518+00', 'Milk River Jig, The', 'MILK RIVER JIG', 64, -1, -1, '', NULL, 1, 1, 1, 1, '', 4, 2998, 9999, 2, 1, 2);
INSERT INTO 'dance' VALUES (179, '1997-04-03 22:00:00+00', '2012-01-20 12:56:01.609051+00', 'Annie''s Well', 'ANNIES WELL', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 2, 313, 9999, NULL, 1, 2);
INSERT INTO 'dance' VALUES (180, '2002-03-12 23:00:00+00', '2012-01-20 12:56:01.6177+00', 'Anniesland Cross', 'ANNIESLAND CROSS', 80, -1, -1, '', NULL, 1, 1, 1, 1, '', 4, 111, 4, NULL, 1, 4);
INSERT INTO 'dance' VALUES (181, '1998-01-05 23:00:00+00', '2012-01-20 12:56:01.626347+00', 'Bothy Night at Frimley Green', 'BOTHY NIGHT AT FRIMLEY GREEN', 40, -1, -1, '', NULL, 0, 0, 0, 0, '', 4, 329, 9999, NULL, 1, 1);
INSERT INTO 'dance' VALUES (182, '1997-08-28 22:00:00+00', '2012-01-20 12:56:01.635016+00', 'Anniversary Jig', 'ANNIVERSARY JIG', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 4, 638, 9999, NULL, 1, 2);
INSERT INTO 'dance' VALUES (187, '1997-09-12 22:00:00+00', '2012-01-20 12:56:01.678446+00', 'Anniversary Strathspey, The', 'ANNIVERSARY STRATHSPEY', 40, -1, -1, '', NULL, 0, 0, 0, 0, '', 4, 318, 9999, NULL, 1, 3);
INSERT INTO 'dance' VALUES (191, '1997-08-31 22:00:00+00', '2012-01-20 12:56:01.713481+00', 'Another Kind Love', 'ANOTHER KIND LOVE', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 2, 27, 9999, NULL, 1, 2);
INSERT INTO 'dance' VALUES (194, '1998-01-05 23:00:00+00', '2012-01-20 12:56:01.740264+00', 'Anthony McLaren', 'ANTHONY MACLAREN', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 2, 173, 9999, NULL, 1, 1);
INSERT INTO 'dance' VALUES (196, '1997-08-31 22:00:00+00', '2012-01-20 12:56:01.757563+00', 'Apley House', 'APLEY HOUSE', 24, -1, -1, '', '1702-01-01', 0, 0, 0, 0, '', 2, 446, 9999, NULL, 1, 1);
INSERT INTO 'dance' VALUES (199, '1997-09-22 22:00:00+00', '2012-01-20 12:56:01.784598+00', 'Appleringie', 'APPLERINGIE', 128, -1, -1, '', NULL, 0, 0, 0, 0, '', 4, 81, 9999, NULL, 1, 4);
INSERT INTO 'dance' VALUES (201, '1997-08-28 22:00:00+00', '2018-04-03 00:07:31.011574+00', 'Arascain Reel', 'ARASCAIN REEL', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 3, 377, 9999, 42, 1, 1);
INSERT INTO 'dance' VALUES (2692, '1997-04-03 22:00:00+00', '2012-01-20 12:56:21.605643+00', 'Growling Old Woman, The', 'GROWLING OLD WOMAN', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 2, 270, 9999, NULL, 1, 2);
INSERT INTO 'dance' VALUES (2694, '1997-09-03 22:00:00+00', '2012-01-20 12:56:21.623075+00', 'Guethary Reel, The', 'GUETHARY REEL', 96, -1, -1, '', NULL, 0, 0, 0, 0, '', 4, 313, 9999, NULL, 4, 1);
INSERT INTO 'dance' VALUES (10378, '2002-03-07 23:00:00+00', '2012-01-20 12:57:20.819337+00', 'Morning After, The', 'MORNING AFTER', 32, -1, -1, '', NULL, 1, 1, 1, 1, '', 4, 428, 9999, NULL, 1, 3);
INSERT INTO 'dance' VALUES (2683, '1997-04-03 22:00:00+00', '2016-10-04 21:33:56.88549+00', 'Gretna Green Jig, The', 'GRETNA GREEN JIG', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 2, 212, 9999, NULL, 1, 2);
INSERT INTO 'dance' VALUES (253, '1997-04-03 22:00:00+00', '2012-01-20 12:56:02.266741+00', 'Ashley Terrace', 'ASHLEY TERRACE', 40, -1, -1, '', NULL, 1, 1, 1, 1, '', 4, 35, 9999, 1, 1, 3);
INSERT INTO 'dance' VALUES (254, '1997-08-28 22:00:00+00', '2012-01-20 12:56:02.275396+00', 'Ashra Autad', 'ASHRA AUTAD', 88, -1, -1, '', NULL, 0, 0, 0, 0, '', 98, 270, 9999, NULL, 6, 1);
INSERT INTO 'dance' VALUES (167, '1997-04-03 22:00:00+00', '2023-12-24 12:44:07.50773+00', 'Anne Eltham''s Fancy', 'ANNE ELTHAMS FANCY', 32, -1, -1, '', NULL, 1, 1, 0, 1, '', 3, 270, 9999, 42, 1, 2);
INSERT INTO 'dance' VALUES (192, '1997-04-03 22:00:00+00', '2024-06-26 19:48:29.440841+00', 'Another Piece of Silver', 'ANOTHER PIECE OF SILVER', 32, 53, -1, '888/844/844/822', '1986-01-01', 1, 1, 1, 1, 'Inscribed "For Joan and Dennis Smith on their Silver Wedding, July 1986".', 3, 146, 9999, 42, 1, 1);
INSERT INTO 'dance' VALUES (2663, '1997-04-03 22:00:00+00', '2024-08-03 17:25:24.660098+00', 'Green Lady Of Skipness Castle', 'GREEN LADY OF SKIPNESS CASTLE', 32, -1, -1, '', NULL, 1, 1, 0, 0, '1M & 3M start in exchanged places, diagonally opposite their partner.



The notes explain that "A small long-haired spirit, known as the Green Lady, was thought to protect the inhabitants of Skipness Castle in times of danger."', 3, 313, 9999, 18, 2, 3);
INSERT INTO 'dance' VALUES (200, '1998-01-04 23:00:00+00', '2016-11-10 23:11:35.818756+00', 'April In October', 'APRIL IN OCTOBER', 32, 75, -1, '888/888/888/888', '1979-10-25', 0, 1, 1, 1, 'This dance is for Carla and Daniel Clarke of Nashwaaksis, N.B. to celebrate the birth of their

daughter, April Phyllis, on October 25, 1979', 3, 90, 9999, 42, 1, 1);
INSERT INTO 'dance' VALUES (10373, '2002-03-07 23:00:00+00', '2018-04-03 00:07:48.256087+00', 'Gillespie Jig, The', 'GILLESPIE JIG', 32, -1, -1, '', NULL, 1, 1, 1, 1, '', 3, 2996, 9999, 42, 1, 2);
INSERT INTO 'dance' VALUES (2672, '1997-04-03 22:00:00+00', '2018-04-03 00:07:50.016205+00', 'Green''s Hotel, The', 'GREENS HOTEL', 32, -1, -1, '', NULL, 1, 1, 1, 1, '', 3, 35, 9999, 42, 1, 1);
INSERT INTO 'dance' VALUES (2678, '1997-04-03 22:00:00+00', '2018-04-03 00:07:50.049633+00', 'Greenwoodside', 'GREENWOODSIDE', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 3, 270, 9999, 42, 1, 1);
INSERT INTO 'dance' VALUES (2679, '1997-04-03 22:00:00+00', '2018-04-03 00:07:50.057966+00', 'Greeting Greta', 'GREETING GRETA', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 3, 99, 9999, 42, 1, 3);
INSERT INTO 'dance' VALUES (2680, '2003-01-28 23:00:00+00', '2018-04-03 00:07:50.074578+00', 'Greeting, The', 'GREETING', 32, -1, -1, '', NULL, 1, 1, 1, 1, '', 3, 35, 9999, 42, 1, 1);
INSERT INTO 'dance' VALUES (2689, '2003-01-25 23:00:00+00', '2018-04-03 00:07:50.141318+00', 'Grigarach Reel', 'GRIGARACH REEL', 32, -1, -1, '', NULL, 1, 1, 1, 1, '', 3, 35, 9999, 42, 1, 1);
INSERT INTO 'dance' VALUES (2693, '2003-01-28 23:00:00+00', '2018-04-03 00:07:50.183023+00', 'Guess This''ll Do', 'GUESS THISLL DO', 32, -1, -1, '', '1984-01-01', 1, 1, 1, 1, '', 3, 35, 9999, 42, 1, 2);
INSERT INTO 'dance' VALUES (2699, '1997-09-03 22:00:00+00', '2018-04-03 00:07:50.191344+00', 'Guide Patrol, The', 'GUIDE PATROL', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 3, 109, 9999, 42, 1, 1);
INSERT INTO 'dance' VALUES (2696, '2002-02-28 23:00:00+00', '2018-04-03 00:07:50.249711+00', 'Guid Luck Go Wi'' Ye', 'GUID LUCK GO WI YE', 32, -1, -1, '', '1975-01-01', 0, 0, 0, 0, '', 3, 406, 9999, 42, 1, 3);
INSERT INTO 'dance' VALUES (18404, '2018-07-13 10:12:10.953535+00', '2018-07-13 10:12:10.953535+00', 'Last Year''s Snow Was Falling', 'LAST YEARS SNOW WAS FALLING', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 3, 11664, NULL, NULL, 1, 3);
INSERT INTO 'dance' VALUES (2883, '1999-04-14 22:00:00+00', '2019-03-16 12:36:14.099952+00', 'Herself', 'HERSELF', 32, -1, -1, '', NULL, 0, 1, 0, 0, '', 55, 23, 9999, 30, 4, 3);
INSERT INTO 'dance' VALUES (216, '1997-04-03 22:00:00+00', '2012-01-20 12:56:01.933895+00', 'Argyll Broadswords', 'ARGYLL BROADSWORDS', 64, -1, -1, '', NULL, 0, 0, 0, 0, '', 98, 9998, 9999, NULL, 1, 7);
INSERT INTO 'dance' VALUES (175, '1997-04-03 22:00:00+00', '2020-04-29 10:40:31.335349+00', 'Anne''s Dancing Duster', 'ANNES DANCING DUSTER', 32, 81, -1, '8888/8008/8888/4668', '1986-04-01', 0, 0, 0, 0, '', 4, 99, 9999, 1, 1, 1);
INSERT INTO 'dance' VALUES (18621, '2018-09-17 18:24:34.430206+00', '2020-11-19 19:14:52.920509+00', 'Lossie Lass', 'LOSSIE LASS', 40, -1, -1, '', '2007-10-01', 0, 1, 0, 0, '', 100, 11708, NULL, 2, 1, 1);
INSERT INTO 'dance' VALUES (174, '1997-08-28 22:00:00+00', '2020-12-27 19:16:32.733711+00', 'Anne Tufts'' Strathspey', 'ANNE TUFTS STRATHSPEY', 32, 84, -1, '8888/8888/8048/8088', NULL, 0, 1, 0, 0, 'To Anne and Duncan on their Wedding Day', 4, 636, 9999, 1, 1, 3);
INSERT INTO 'dance' VALUES (197, '2002-02-26 23:00:00+00', '2020-12-27 19:20:21.367717+00', 'Apple Tree, The', 'APPLE TREE', 32, 88, -1, '8008/8888/8888/8888', '1988-01-01', 1, 1, 1, 1, '', 100, 108, 9999, 11, 1, 1);
INSERT INTO 'dance' VALUES (2686, '1997-09-18 22:00:00+00', '2021-05-07 22:17:34.217087+00', 'Grey Daylight', 'GREY DAYLIGHT', 32, 52, -1, '84/84/80/88', '1962-01-01', 1, 1, 1, 1, '"Grey Daylight" is an alternative name for Stirling Castle (which is the tune for the dance).', 2, 392, 9999, 76, 1, 3);
INSERT INTO 'dance' VALUES (217, '1997-09-12 22:00:00+00', '2012-01-20 12:56:01.942534+00', 'Argyll Gathering', 'ARGYLL GATHERING', 64, -1, -1, '', NULL, 0, 0, 0, 0, '', 5, 270, 9999, NULL, 3, 4);
INSERT INTO 'dance' VALUES (225, '1998-10-08 22:00:00+00', '2012-01-20 12:56:02.012589+00', 'Ariel Eightsome, The', 'ARIEL EIGHTSOME', 64, -1, -1, '', NULL, 0, 0, 0, 0, '', 4, 27, 9999, NULL, 4, 4);
INSERT INTO 'dance' VALUES (226, '1998-07-08 22:00:00+00', '2012-01-20 12:56:02.022949+00', 'Aries In Conjunction', 'ARIES IN CONJUNCTION', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 4, 425, 9999, 5, 1, 1);
INSERT INTO 'dance' VALUES (2703, '1998-07-08 22:00:00+00', '2012-01-20 12:56:21.705161+00', 'Gulf Of Coirebhreachain, The', 'GULF OF COIREBHREACHAIN', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 4, 1, 9999, 2, 1, 1);
INSERT INTO 'dance' VALUES (232, '1997-04-03 22:00:00+00', '2019-04-17 13:56:52.396156+00', 'Arniston Glen', 'ARNISTON GLEN', 32, -1, -1, '660/888/660/888', NULL, 0, 1, 1, 1, 'Dedicated to Ruth abd Archie Scott', 3, 101, 9999, 42, 1, 3);
INSERT INTO 'dance' VALUES (2710, '1997-04-03 22:00:00+00', '2012-01-20 12:56:21.769355+00', 'Gyrating Wheel', 'GYRATING WHEEL', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 4, 352, 9999, NULL, 1, 3);
INSERT INTO 'dance' VALUES (210, '1997-04-03 22:00:00+00', '2019-10-17 22:35:40.945613+00', 'Ardbeg', 'ARDBEG', 32, 56, -1, '66/88/88/44', NULL, 0, 0, 0, 0, '', 2, 270, 9999, NULL, 1, 1);
INSERT INTO 'dance' VALUES (10391, '2002-11-13 23:00:00+00', '2012-01-20 12:57:20.937925+00', 'Jigsaw', 'JIGSAW', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 4, 9998, 9999, NULL, 1, 3);
INSERT INTO 'dance' VALUES (204, '1997-04-03 22:00:00+00', '2018-04-03 00:07:31.019974+00', 'Archbishop Sharp''s Jig', 'ARCHBISHOP SHARPS JIG', 48, -1, -1, '', NULL, 0, 0, 0, 0, '', 3, 99, 9999, 42, 1, 2);
INSERT INTO 'dance' VALUES (236, '1998-01-12 23:00:00+00', '2012-01-20 12:56:02.10997+00', 'Aroon the Clachan of Dalry', 'AROON THE CLACHAN OF DALRY', 32, -1, -1, '', NULL, 1, 1, 1, 1, '', 2, 210, 9999, NULL, 5, 2);
INSERT INTO 'dance' VALUES (238, '1998-01-04 23:00:00+00', '2012-01-20 12:56:02.127608+00', 'Arrabri Reel', 'ARRABRI REEL', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 4, 653, 9999, NULL, 1, 1);
INSERT INTO 'dance' VALUES (239, '1997-08-28 22:00:00+00', '2012-01-20 12:56:02.136266+00', 'Arrabri Scramble', 'ARRABRI SCRAMBLE', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 4, 43, 9999, NULL, 1, 1);
INSERT INTO 'dance' VALUES (242, '1997-04-03 22:00:00+00', '2012-01-20 12:56:02.166128+00', 'Arran View', 'ARRAN VIEW', 40, -1, -1, '', NULL, 0, 0, 0, 0, '', 4, 28, 9999, NULL, 1, 3);
INSERT INTO 'dance' VALUES (209, '1997-04-03 22:00:00+00', '2022-07-17 09:54:55.392269+00', 'Ardailly Mill', 'ARDAILLY MILL', 32, -1, -1, '', NULL, 0, 1, 1, 0, '', 53, 370, 9999, 4, 5, 1);
INSERT INTO 'dance' VALUES (2695, '1997-09-03 22:00:00+00', '2023-01-20 19:32:06.089508+00', 'Guid Freens', 'GUID FREENS', 32, -1, -1, '', NULL, 1, 1, 0, 1, 'The notes say this is "Dedicated to Avril and David Quarrie, the Chicago Branch''s teachers, mentors, and friends."', 3, 787, 9999, 42, 1, 1);
INSERT INTO 'dance' VALUES (2673, '1997-09-03 22:00:00+00', '2023-01-20 19:36:38.506559+00', 'Greenan Mill, The', 'GREENAN MILL', 48, -1, -1, '', '1974-01-01', 1, 1, 0, 1, '', 4, 477, 9999, 1, 1, 1);
INSERT INTO 'dance' VALUES (248, '1997-04-03 22:00:00+00', '2012-01-20 12:56:02.221609+00', 'Ascot Lady, The', 'ASCOT LADY', 80, -1, -1, '', NULL, 0, 0, 0, 0, '', 4, 360, 9999, NULL, 4, 3);
INSERT INTO 'dance' VALUES (10382, '2002-03-07 23:00:00+00', '2016-11-22 03:06:24.044093+00', 'Seann Truibhas for Four', 'SEANN TRUIBHAS FOR FOUR', 32, -1, -1, '', NULL, 1, 1, 1, 1, 'The correct Gaelic spelling is Triubhas.  For details see "Extra Info" for the dance Seann Triubhas Wikkichan".', 4, 3000, 9999, 1, 1, 3);
INSERT INTO 'dance' VALUES (206, '2001-11-18 23:00:00+00', '2018-04-03 00:07:31.061575+00', 'Archibald Minto', 'ARCHIBALD MINTO', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 3, 270, 9999, 42, 1, 2);
INSERT INTO 'dance' VALUES (208, '1997-04-03 22:00:00+00', '2018-04-03 00:07:31.070022+00', 'Archie Patterson', 'ARCHIE PATTERSON', 40, -1, -1, '', NULL, 0, 0, 0, 0, '', 3, 270, 9999, 42, 1, 1);
INSERT INTO 'dance' VALUES (211, '1998-01-05 23:00:00+00', '2018-04-03 00:07:31.078236+00', 'Ardbrae Reel, The', 'ARDBRAE REEL', 48, -1, -1, '', NULL, 0, 0, 0, 0, '', 3, 649, 9999, 42, 1, 1);
INSERT INTO 'dance' VALUES (227, '1998-01-05 23:00:00+00', '2018-04-03 00:07:31.145284+00', 'Arisaig Tushker, The', 'ARISAIG TUSHKER', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 3, 176, 9999, 42, 1, 1);
INSERT INTO 'dance' VALUES (234, '1997-04-03 22:00:00+00', '2018-04-03 00:07:31.187079+00', 'Arniston House', 'ARNISTON HOUSE', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 3, 270, 9999, 42, 1, 3);
INSERT INTO 'dance' VALUES (233, '2001-03-13 23:00:00+00', '2018-04-03 00:07:31.195334+00', 'Arniston House', 'ARNISTON HOUSE', 32, -1, -1, '', '1989-01-01', 0, 0, 0, 0, '', 3, 401, 9999, 42, 1, 2);
INSERT INTO 'dance' VALUES (244, '1997-09-17 22:00:00+00', '2018-04-03 00:07:31.253763+00', 'Arthur''s Fancy', 'ARTHURS FANCY', 32, -1, -1, '', '1971-01-01', 1, 1, 1, 1, '', 3, 35, 9999, 42, 1, 2);
INSERT INTO 'dance' VALUES (2712, '1997-04-03 22:00:00+00', '2018-04-03 00:07:52.36782+00', 'H.M.S. Invincible', 'HMS INVINCIBLE', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 3, 21, 9999, 42, 1, 1);
INSERT INTO 'dance' VALUES (10379, '2002-03-07 23:00:00+00', '2018-04-03 00:08:07.79628+00', 'Nice an'' Aisy', 'NICE AN AISY', 32, -1, -1, '', NULL, 1, 1, 1, 1, '', 3, 2999, 9999, 42, 1, 2);
INSERT INTO 'dance' VALUES (10383, '2002-03-07 23:00:00+00', '2018-04-03 00:08:19.004461+00', 'Summer Dancing in Ottawa', 'SUMMER DANCING IN OTTAWA', 32, -1, -1, '', NULL, 1, 1, 1, 1, '', 3, 3005, 9999, 42, 1, 3);
INSERT INTO 'dance' VALUES (252, '1998-10-19 22:00:00+00', '2012-01-20 12:56:02.257222+00', 'Ashhurst Gathering, The', 'ASHHURST GATHERING', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 4, 349, 9999, NULL, 4, 3);
INSERT INTO 'dance' VALUES (247, '1997-04-03 22:00:00+00', '2023-05-19 17:44:15.293382+00', 'As Time Will Serve Her', 'AS TIME WILL SERVE HER', 64, -1, -1, '', '1988-01-01', 1, 1, 0, 1, '', 4, 99, 9999, 3, 4, 2);
INSERT INTO 'dance' VALUES (207, '1997-04-03 22:00:00+00', '2023-11-18 20:34:17.595579+00', 'Archie Menzies', 'ARCHIE MENZIES', 32, -1, -1, '', NULL, 1, 1, 0, 1, '', 4, 270, 9999, 2, 1, 2);
INSERT INTO 'dance' VALUES (10387, '2002-04-24 22:00:00+00', '2023-11-21 10:42:58.864864+00', 'What''s Up?', 'WHATS UP', 32, 86, -1, '8888/8888/8888/8000', '2002-01-01', 1, 1, 1, 1, '', 4, 3035, 9999, 1, 1, 3);
INSERT INTO 'dance' VALUES (19185, '2019-02-14 09:19:09.175613+00', '2024-06-21 09:25:04.284529+00', 'Bass Rock, The', 'BASS ROCK', 32, -1, -1, '', NULL, 1, 1, 0, 0, 'Originally entered in SCDDB as "The Bass Rock Strathspey" the title as published in the Exeter 50th Anniversary book is just "The Bass Rock".', 3, 10902, NULL, 17, 2, 3);
INSERT INTO 'dance' VALUES (10385, '2002-03-07 23:00:00+00', '2024-06-24 06:57:39.575313+00', 'Whiskey-Jack, The', 'WHISKEYJACK', 32, 63, -1, '888/888/880/880', NULL, 1, 1, 1, 1, '', 3, 2999, 9999, 42, 1, 1);
INSERT INTO 'dance' VALUES (259, '1997-04-03 22:00:00+00', '2012-01-20 12:56:02.318949+00', 'Aston Reel', 'ASTON REEL', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 4, 102, 9999, NULL, 1, 1);
INSERT INTO 'dance' VALUES (18406, '2018-07-13 10:16:23.389472+00', '2018-07-13 10:16:23.389472+00', 'Finding the Way', 'FINDING THE WAY', 48, -1, -1, '', NULL, 0, 0, 0, 0, '', 4, 11487, NULL, NULL, 1, 3);
INSERT INTO 'dance' VALUES (2724, '1997-09-03 22:00:00+00', '2012-01-20 12:56:21.890844+00', 'Hague Silver Jubilee', 'HAGUE SILVER JUBILEE', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 4, 980, 9999, NULL, 1, 3);
INSERT INTO 'dance' VALUES (2726, '1997-09-03 22:00:00+00', '2012-01-20 12:56:21.908613+00', 'Half A Loaf', 'HALF A LOAF', 40, -1, -1, '', NULL, 0, 0, 0, 0, '', 4, 981, 9999, NULL, 1, 3);
INSERT INTO 'dance' VALUES (286, '1997-04-03 22:00:00+00', '2018-04-02 23:56:32.87832+00', 'August Frost', 'AUGUST FROST', 32, -1, -1, '', '1993-04-11', 0, 1, 0, 0, '', 3, 352, 9999, 42, 1, 3);
INSERT INTO 'dance' VALUES (10393, '2002-03-12 23:00:00+00', '2012-01-20 12:57:20.956852+00', 'Happier Meeting, The', 'HAPPIER MEETING', 32, -1, -1, '', '1998-01-01', 1, 1, 1, 1, '', 2, 49, 9999, NULL, 5, 1);
INSERT INTO 'dance' VALUES (10394, '2005-04-27 22:00:00+00', '2012-01-20 12:57:20.967105+00', 'Nae Luck aboot the Hoose', 'NAE LUCK ABOOT THE HOOSE', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', NULL, 3578, 9999, NULL, NULL, 3);
INSERT INTO 'dance' VALUES (10396, '2002-03-13 23:00:00+00', '2012-01-20 12:57:20.988325+00', 'Palindrome, The', 'PALINDROME', 128, -1, -1, '', '1998-01-01', 1, 1, 1, 1, '', 4, 550, 2, NULL, 4, 4);
INSERT INTO 'dance' VALUES (10384, '2002-03-07 23:00:00+00', '2020-02-01 22:09:27.678317+00', 'Taffy Strathspey, The', 'TAFFY STRATHSPEY', 32, -1, -1, '', NULL, 1, 1, 1, 1, '', 4, 3033, 9999, 1, 1, 3);
INSERT INTO 'dance' VALUES (276, '1998-01-05 23:00:00+00', '2020-08-02 11:47:13.363536+00', 'Auchencairn', 'AUCHENCAIRN', 32, 56, -1, '84/66/88/85', '1966-01-01', 1, 1, 0, 1, '', 2, 129, 9999, 76, 1, 1);
INSERT INTO 'dance' VALUES (2706, '1997-04-03 22:00:00+00', '2021-04-12 21:45:53.07677+00', 'Gunn''s Rant, The', 'GUNNS RANT', 32, 34, -1, '800/844/800/822', NULL, 0, 0, 0, 0, '', 3, 418, 9999, 42, 1, 1);
INSERT INTO 'dance' VALUES (237, '1997-04-03 22:00:00+00', '2021-05-13 09:29:05.024257+00', 'Around The Corner', 'AROUND THE CORNER', 32, 38, -1, '800/844/844/800', '1993-01-23', 0, 1, 1, 0, '', 3, 352, 9999, 42, 1, 1);
INSERT INTO 'dance' VALUES (235, '1998-04-04 22:00:00+00', '2021-07-04 10:45:57.765415+00', 'Arnold House Medley', 'ARNOLD HOUSE MEDLEY', 32, -1, -1, '', NULL, 0, 1, 0, 0, '', 3, 270, 1, 42, 1, 4);
INSERT INTO 'dance' VALUES (228, '2002-02-26 23:00:00+00', '2021-07-04 10:54:21.163172+00', 'Arkaig Jig', 'ARKAIG JIG', 32, 63, -1, '888/888/822/866', NULL, 0, 1, 0, 0, '', 3, 500, 9999, 42, 1, 2);
INSERT INTO 'dance' VALUES (243, '1997-12-03 23:00:00+00', '2021-08-09 16:04:46.519528+00', 'Sixth of September', 'SIXTH OF SEPTEMBER', 32, -1, -1, '', NULL, 1, 1, 1, 1, 'This dance is good for the first night of dancing. (T)', 2, 1382, 9999, NULL, 1, 2);
INSERT INTO 'dance' VALUES (2739, '1997-04-03 22:00:00+00', '2018-10-30 10:12:52.040147+00', 'Halloween', 'HALLOWEEN', 40, 48, -1, '800/833/833/888/844', NULL, 0, 0, 0, 0, '', 3, 270, 9999, 42, 1, 2);
INSERT INTO 'dance' VALUES (258, '1997-08-28 22:00:00+00', '2018-04-03 00:07:31.30395+00', 'Aster, The', 'ASTER', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 3, 27, 9999, 42, 1, 1);
INSERT INTO 'dance' VALUES (266, '1997-09-22 22:00:00+00', '2012-01-20 12:56:02.380017+00', 'Atherny Lodge', 'ATHERNY LODGE', 64, -1, -1, '', NULL, 0, 0, 0, 0, '', 4, 270, 9999, NULL, 1, 1);
INSERT INTO 'dance' VALUES (2718, '1997-04-03 22:00:00+00', '2019-02-04 18:33:43.004397+00', 'Hadrian''s Reel', 'HADRIANS REEL', 32, 66, -1, '6006/8888/8448/8008', NULL, 0, 0, 0, 0, '', 4, 212, 9999, 2, 1, 1);
INSERT INTO 'dance' VALUES (269, '1997-08-24 22:00:00+00', '2012-01-20 12:56:02.407867+00', 'Atholl Highlanders, The', 'ATHOLL HIGHLANDERS', 32, -1, -1, '', '1991-01-01', 1, 1, 1, 1, '', 4, 35, 9999, 1, 1, 1);
INSERT INTO 'dance' VALUES (260, '1997-04-03 22:00:00+00', '2018-04-03 00:07:31.329003+00', 'At Buckie', 'AT BUCKIE', 32, -1, -1, '', NULL, 1, 1, 1, 1, '', 3, 35, 9999, 42, 1, 2);
INSERT INTO 'dance' VALUES (267, '1997-04-03 22:00:00+00', '2018-04-03 00:07:31.345759+00', 'Atholl Brose', 'ATHOLL BROSE', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 3, 35, 9999, 42, 1, 2);
INSERT INTO 'dance' VALUES (18407, '2018-07-13 10:17:15.214824+00', '2019-04-25 08:15:36.16268+00', 'Club Harmony, The', 'CLUB HARMONY', 48, 83, -1, '844/844/888/880/888/888', NULL, 0, 1, 1, 0, '', 3, 11663, NULL, 18, 2, 1);
INSERT INTO 'dance' VALUES (278, '2001-05-21 22:00:00+00', '2019-03-21 00:09:52.699815+00', 'Auchentoshen', 'AUCHENTOSHEN', 40, 65, -1, '8448/4884/8888/4444/8000', '1977-01-01', 0, 1, 1, 0, '', 4, 539, 9999, 1, 1, 1);
INSERT INTO 'dance' VALUES (272, '1997-08-28 22:00:00+00', '2018-04-03 00:07:31.354019+00', 'Atlanta Fair', 'ATLANTA FAIR', 32, -1, -1, '', NULL, 0, 0, 0, 0, '', 3, 656, 9999, 42, 1, 2);
INSERT INTO 'dance' VALUES (2728, '199